// pvoceditor.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <X11/keysym.h>
#include "filecommand.h"
#include "pvoceditor.h"
#include "pvocdata.h"
#include "pvocmodifier.h"

Data *
PvocEditor::newModel() { return new PvocData(); }

boolean
PvocEditor::keyCommand(unsigned long sym) {
	boolean interested = true;
	switch (sym) {
	case XK_bracketleft:
		harmonicShift();
		break;
	case XK_bracketright:
		stretchShift();
		break;
	default:
		interested = DataEditor::keyCommand(sym);
		break;
	}
	return interested;
}

void
PvocEditor::newFile() {
	PvocEditor::new_File(controller);
}

// static constructor

Controller *
PvocEditor::new_File(Controller* controller) {
	PvocFileCreator pfc;
	applyModifierUsing(pfc, controller);
	return pfc.getNewController();
}

// this operations are all performed on a copy of the existing data, which
// is then displayed in a new window -- this way, no undo's are necessary

void
PvocEditor::harmonicShift() {
	copy();
	SpectrumTransposer s(copyBuffer());
	applyModifierToNew(s);
}

void
PvocEditor::stretchShift() {
	copy();
	SpectrumStretcher s(copyBuffer());
	applyModifierToNew(s);
}

void
PvocEditor::compressOrExpand() {}

void
PvocEditor::crossfadeSpectrum() {}

void
PvocEditor::setDataOptions() {}

// these static functions have their addresses loaded into a ctor array
// in the DataEditor base class

DataEditor*
PvocEditor::new_DataEditor1(Controller *c) {
	return new PvocEditor(c);
}

DataEditor*
PvocEditor::new_DataEditor2(Controller *c, const Data *d) {
	return new PvocEditor(c, d);
}
