// formantsynth.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FormantSynth combines a time-varying All-Pass filter with a Buzz object
// (harmonically-limited pulse generator) and a RandomNoise object to allow
// mixed-excitation resynthesis of Linear Predictive Coding analysis files.

#ifndef FORMANTSYNTH_H
#ifdef __GNUG__
#pragma interface
#endif
#define FORMANTSYNTH_H

#include "lpcfilter.h"
#include "randomnoise.h"
#include "synthfunction.h"

class Data;
class LPCData;

class FormantSynthesizer : private LPC_Filter, public Buzz {
public:
	FormantSynthesizer(Data* output, LPCData* , double, int, double amp=1.0);
	FormantSynthesizer(Data* output, LPCData* data);
	redefined void restoreState();
protected:
	redefined void initialize();
	redefined double doSynthesis();
	redefined boolean setValues(Request &r);
	redefined boolean confirmValues(Controller *);
	double voiced() { return Buzz::doSynthesis(); }
	double unvoiced() { return noise(); }
private:
	redefined const QueryInfo *requestInfo();
private:
	RandomNoise noise;
	float gain;
	float voicedFactor;
	float hiThreshold, lowThreshold;
	float srOverTwo;			// cached for optimization
};

#endif
