// byteswap.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// inline routines for swapping bytes for standard datatypes

#ifndef BYTESWAP_H
#define BYTESWAP_H

/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */


/* Byte swappers */

/* generic swap routine */

static void
swapBytes(char *l, char *f, int n) {
	for (int i= 0; i< n; i++)
		f[i]= l[n-i-1];
}

inline unsigned short
swap(unsigned short us) {
	return ((us >> 8) | (us << 8)) & 0xffff;
}

inline short
swap(short s) { return short(swap((unsigned short) s)); }

inline unsigned long
swap(unsigned long ul) {
	return (ul >> 24) | ((ul >> 8) & 0xff00) | ((ul << 8) & 0xff0000) | (ul << 24);
}

inline long
swap(long l) { return long(swap((unsigned long) l)); }

inline float
swap(float uf) {
	union { unsigned long l; float f; } u;
	u.f = uf;
	u.l = swap(u.l);
	return (u.f);
}

inline double
swap(double df) {
	double sdf;
	swapBytes((char *) &df, (char *) &sdf, sizeof(df));
	return (sdf);
}

// dont swap references to classes

inline const class Id &
swap(const class Id& id) { return id; }

inline const class IEEE_Float &
swap(const class IEEE_Float& f) { return f; }

inline const class CompressionName&
swap(const class CompressionName& name) { return name; }

#endif

