// buttonarray.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <InterViews/box.h>
#include <InterViews/button.h>
#include <InterViews/glue.h>
#include <InterViews/message.h>

#include "buttonarray.h"
#include "query.h"

// macro for deleting any type of list as defined by me

#define delete_list(LinkType, list) {LinkType *l = list; while(l) { LinkType *nxt = l->next; delete l; l = nxt; }}

ButtonArray::ButtonStateLink::~ButtonStateLink() { Resource::unref(state); }
		
ButtonArray::ButtonStateLink *
ButtonArray::ButtonStateLink::tail() {
	ButtonStateLink *b = this;
	while(b && b->next) b = b->next;
	return b;
}

void
ButtonArray::ButtonStateLink::append(ButtonArray::ButtonStateLink *b) {
	tail()->next = b;
}

int
ButtonArray::ButtonStateLink::finalValue() {	// logical OR of its states
	ButtonStateLink *b = this;
	int value = 0;
	while(b != nil) {
		int currentVal;
		b->state->GetValue(currentVal);
		value |= currentVal;
		b = b->next;
	}
	return value;
}

////////

ButtonArray::ButtonArray(ButtonState* state, QueryChoice* choices)
		: subject(nil), stateList(nil), queryChoice(choices) {
	init(state, choices);
}

ButtonArray::~ButtonArray() {
	if(subject != nil)
		subject->Detach(this);
	delete_list(ButtonStateLink, stateList);
}

void
ButtonArray::init(ButtonState* state, QueryChoice* choices) {
	subject = state;
	if(subject != nil)
		subject->Attach(this);
	boolean exclusive = choices->areExclusive();
	Scene* arrayBox = new VBox;	// enclosing box for buttons
	Scene* rowBox = new HBox;		// box for each row of buttons
	rowBox->Insert(new HGlue);			// left edge glue
	const char *label = nil;
	// exclusive buttons all use the same state
	ButtonState *exclstate = exclusive ? 
		new ButtonState(choices->state()) : nil;
	int numberOfButtons = choices->numberOfValues();
	int endOfRow = (numberOfButtons > 4) ? roundUp(numberOfButtons / 2.0) : numberOfButtons;
	endOfRow -= 1;		// to match with 0 to n-1
	choices->start();	// initialize the iterators
	for(int buttonNumber = 0; buttonNumber < numberOfButtons; buttonNumber++) {
		label = choices->nextLabel();
		int value;
		// retrieve value & whether or not it is currently set
		boolean isOn = choices->nextValue(&value);
		Interactor *button = nil;
		// radio buttons are used for exclusive choices and
		// check-boxes used for multiple choices
		if(exclusive) {
			button = new RadioButton(label, exclstate, value);
		}
		else {
			exclstate = new ButtonState(isOn ? value : 0);
			button = new CheckBox(label, exclstate, value, 0);
		}
		// append each state if non-exclusive
		if(stateList == nil)
			stateList = new ButtonStateLink(exclstate);
		else if(!exclusive)
			stateList->append(new ButtonStateLink(exclstate));
		rowBox->Insert(button);
		rowBox->Insert(new HGlue);
		if(buttonNumber == endOfRow) {
			arrayBox->Insert(rowBox);			// insert current row
			int finalEnd = numberOfButtons - 1;
			if(buttonNumber < finalEnd) {
				rowBox = new HBox;		// start new row if not at end
				rowBox->Insert(new HGlue);			// left edge glue
				endOfRow = finalEnd;
			}
		}
	}
	// each set of choice buttons has a text label above it
	Insert(
		new VBox(
			new HBox(
				new HGlue(10),
				new Message("ChoiceButtonTitle", choices->label()),
				new HGlue(10)
			),
			new VGlue,
			arrayBox
		)
	);
}

// set the "master" state of the ButtonArray to the OR'd combination of the
// individual buttons' states (returned by ButtonStateList::finalValue())

void
ButtonArray::Update() {
	int stateValue;
	subject->GetValue(stateValue);
	if(stateValue == Yes)	// if user confirmed the dialog
		queryChoice->setState(stateList->finalValue());
	Super::Update();
}
