/*
 * Copyright (c) 1987, 1988, 1989 Stanford University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Stanford not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Stanford makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * STANFORD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * dclock timing information
 */

#ifndef clocktime_h
#define clocktime_h

#ifdef __GNUG__
#pragma interface
#endif

#include <OS/types.h>
#include <time.h>
#if defined(__FTX)
/* sys/time.h includes sys/types.h, grab clean version first */
#include <OS/types.h>
#endif
#include <sys/time.h>

class Clock {
public:
    Clock();

    int NextTick();	    /* seconds until next minute */
    void GetTime(char *date, int& hours, int &mins, int &secs);
private:
    struct timeval gmt;
    long nextMinute;	    /* next minute in gmt */
};

#endif
