/*
Copyright Notice:
	Copyright 1990 Robert C. Hood
	This software is distributed "as is" without warranty.  Use this software at your OWN RISK.  Source may be distributed freely, at NO CHARGE, but must be accompanied by this documentation and copyright notice.
*/
#import <appkit/appkit.h>
#include "giflib.h"

id myapp, infopanel, menupanel, mainmenu, openpanel;
char *opentypes [2] = {"gif", 0 };
NXRect temprect;
	
@interface GIF: View
{
    id thiswindow, thisview;
    int xsize, ysize;
    void *rmap, *gmap, *bmap;
}
+new;
-open: (char *)fileName;
-drawSelf: (const NXRect *)rects : (int)rectCount;
-free;
@end

@interface Myapp : Application
{
}
+new;
-(int)appOpenFile: (const char *)fullPath type: (const char *)tipe;
-(BOOL)appAcceptsAnotherFile:sender;
-openfile:sender;
-info:sender;
@end

//****************************************************************
//**** Implemenation Section
//****************************************************************

@implementation GIF : View
{
}

+new
    {
    self = [super new];
    }
//****************************************************************
//**** Open new GIF file
//****************************************************************
-open: (char *)fileName
    {
    thisview = self;
    rmap = 0;

	if ((GIF_file = fopen (fileName, "rb")) == 0)
		{
		NXRunAlertPanel ("GIF ERROR", "Can't open %s", NULL, NULL, NULL, fileName);
		[self free];
		return self;
		}
	if (readgifheader () < 0)
		{
		NXRunAlertPanel ("GIF ERROR", "Error reading image header - Can't display image", NULL, NULL, NULL);
		[self free];
		return self;
		}
	xsize = GIF_xsize;
	ysize = GIF_ysize;
    NXSetRect (&temprect, 150.0, (800.0 - (double)ysize),
		(double)xsize, (double)ysize);
    thiswindow = [Window 
        newContent: &temprect
        style: NX_TITLEDSTYLE
	backing: NX_RETAINED
	buttonMask: NX_CLOSEBUTTONMASK | NX_MINIATURIZEBUTTONMASK | NX_RESIZEBUTTONMASK
	defer: NO ];
    [thiswindow setTitle: fileName];
    [thiswindow orderFront: nil];
    [thiswindow display];
    NXPing ();
	if (readgif () < 0)
		{
		NXRunAlertPanel ("GIF ERROR", "Error reading image - Displaying as much of the image as was read", NULL, NULL, NULL);
		}
	rmap = r;
	gmap = g;
	bmap = b;
    [[thiswindow setContentView: self] free];
    [thiswindow display];
    }
-drawSelf: (const NXRect *)rects : (int)rectCount
	{
	if (rmap == 0)
		return self;
	[self getFrame: &temprect];
	temprect.origin.x = 0.0;
	temprect.origin.y = 0.0;
	[self lockFocus];
	NXImageBitmap (&temprect, xsize, ysize, 8, 3, NX_PLANAR, NX_COLORMASK, rmap, gmap, bmap, 0, 0);
	[self unlockFocus];
	return self;
	}
-free
	{
	free (rmap);
	free (gmap);
	free (bmap);
	[super free];
	}
@end

@implementation Myapp : Application
{
}
+new
    {
    self = [super new];
    [self activateSelf: NO];
    }
-(int)appOpenFile: (const char *)fullPath type: (const char *)tipe
	{
	id ptr;
	
	[self activateSelf: NO];
	ptr = [GIF new];
	[ptr open:(char *)fullPath];
	return YES;
	}
-(BOOL)appAcceptsAnotherFile:sender
	{
	return YES;
	}
-openfile:sender
    {
    char temp [500];
    id ptr;
    int loop;
    
    if ([openpanel runModalForTypes:opentypes])
        {
		loop = 0;
		while ([openpanel filenames] [loop])
			{
		    strcpy (temp, [openpanel directory]);
		    strcat (temp, "/");
		    strcat (temp, [openpanel filenames] [loop]);
		    ptr = [GIF new];
		    [ptr open:temp];
		    ++loop;
		    }
	    }
    }
-info:sender
	{
	[infopanel orderFront: self];
	[infopanel becomeKeyWindow];

	}
@end
   
       
main ()
    {
    [Myapp new];
    setUp ();
    [NXApp run];
    [NXApp free];
    }

setUp ()
    {
    id id1, id2, font, text;
    NXRect temp;
    id submenu, fileID;
/**********************/
/***   Open Panel   ***/
/**********************/
    openpanel = [OpenPanel new];
	[openpanel allowMultipleFiles: YES];
/******************/
/*** info panel ***/
/******************/
	NXSetRect (&temp, 200.0, 600.0, 340.0, 125.0);
	infopanel = [Panel newContent: &temp
		style: NX_TITLEDSTYLE
		backing: NX_RETAINED
		buttonMask: NX_CLOSEBUTTONMASK
		defer: NO];
	[infopanel setHideOnDeactivate: NO];
	[infopanel setTitle: "Info"];
	NXSetRect (&temp, 25.0, 25.0, 80.0, 80.0);
	id2 = [View new];
	[[infopanel setContentView: id2] free];
	id1 = [Button newFrame: &temp
		icon: "app"
		tag: 1
		target: nil
		action: nil
		key: 0
		enabled: NO];
	[id2 addSubview: id1];
/** NeXTGIF **/
	font = [Font newFont: "Times-Bold" size: 30.0];
	text = [Text setDefaultFont: font];
	NXSetRect (&temp, 120.0, 0.0, 250.0, 110.0);
	id1 = [Text newFrame: &temp
		text: "NeXTGIF"
		alignment: NX_LEFTALIGNED];
	[id1 setEditable: NO];
	[id1 setSelectable: NO];
	[id2 addSubview: id1];
/** By Robert Hood **/
	font = [Font newFont: "Times-Roman" size: 12.0];
	text = [Text setDefaultFont: font];
	NXSetRect (&temp, 120.0, 0.0, 250.0, 75.0);
	id1 = [Text newFrame: &temp
		text: "By Robert Hood"
		alignment: NX_LEFTALIGNED];
	[id1 setEditable: NO];
	[id1 setSelectable: NO];
	[id1 setTextGray: 1.0];
	[id2 addSubview: id1];
/** Version and copyright **/
	font = [Font newFont: "Times-Italic" size: 12.0];
	text = [Text setDefaultFont: font];
	NXSetRect (&temp, 120.0, 0.0, 250.0, 58.0);
	id1 = [Text newFrame: &temp
		text: "Version 0.1\nCopyright 1990 Robert C. Hood"
		alignment: NX_LEFTALIGNED];
	[id1 setEditable: NO];
	[id1 setSelectable: NO];
	[id1 setTextGray: NX_DKGRAY];
	[id2 addSubview: id1];
	[infopanel display];
/********************************/    
/***   File operations menu   ***/    
/********************************/    
    submenu = [Menu newTitle: "File"];
    [[submenu addItem: "Open"
         action: @selector (openfile:)
	     keyEquivalent: 'o'] setTarget: myapp];
    [submenu display];
    
/*********************/    
/***   Main menu   ***/    
/*********************/    
    mainmenu = [Menu newTitle: "GIF"];    
    [[mainmenu addItem: "Info..."
    	action: @selector (info:)
		keyEquivalent: 0] setTarget : myapp];
    [mainmenu setSubmenu: submenu
              forItem: [mainmenu addItem: "File"
                             action: 0
	                         keyEquivalent: 0]];
    [mainmenu addItem: "Hide"
              action: @selector (hide:)
	      keyEquivalent: 'h'];
    [mainmenu addItem: "Quit"
              action: @selector (terminate:)
	      keyEquivalent: 'q'];
	      
    [mainmenu display];
    [NXApp setMainMenu: mainmenu];
    }

