// -*- verilog -*-
//
//  USRP - Universal Software Radio Peripheral
//
//  Copyright (C) 2005,2006 Matt Ettus
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

module shifter(input wire [33:0] in, output reg [15:0] out, input wire [7:0] shift);
   // Wish we could do  assign out = in[15+shift:shift];

   always @*
     case(shift)
       0 : out = in[15:0];
       1 : out = in[16:1];
       2 : out = in[17:2];
       3 : out = in[18:3];
       4 : out = in[19:4];
       5 : out = in[20:5];
       6 : out = in[21:6];
       7 : out = in[22:7];
       8 : out = in[23:8];
       9 : out = in[24:9];
       10 : out = in[25:10];
       11 : out = in[26:11];
       12 : out = in[27:12];
       13 : out = in[28:13];
       14 : out = in[29:14];
       15 : out = in[30:15];
       16 : out = in[31:16];
       17 : out = in[32:17];
       18 : out = in[33:18];
       default : out = in[15:0];
     endcase // case(shift)
  
endmodule // shifter

