/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE = new FileSystemUtils();
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int OS;

    public static long freeSpace(String path) throws IOException {
        return INSTANCE.freeSpaceOS(path, OS, false);
    }

    public static long freeSpaceKb(String path) throws IOException {
        return INSTANCE.freeSpaceOS(path, OS, true);
    }

    long freeSpaceOS(String path, int os, boolean kb) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (os) {
            case 1: {
                return kb ? this.freeSpaceWindows(path) / 1024L : this.freeSpaceWindows(path);
            }
            case 2: {
                return this.freeSpaceUnix(path, kb);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    long freeSpaceWindows(String path) throws IOException {
        if ((path = FilenameUtils.normalize(path)).length() > 2 && path.charAt(1) == ':') {
            path = path.substring(0, 2);
        }
        String[] cmdAttrbs = new String[]{"cmd.exe", "/C", "dir /-c " + path};
        BufferedReader in = null;
        String line = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            in = this.openProcessStream(cmdAttrbs);
            line = in.readLine();
            while (line != null) {
                line = line.toLowerCase().trim();
                lines.add(line);
                line = in.readLine();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        if (lines.size() == 0) {
            throw new IOException("Command line 'dir /c' did not return any info for command '" + cmdAttrbs[2] + "'");
        }
        long bytes = -1L;
        int i = lines.size() - 1;
        int bytesStart = 0;
        int bytesEnd = 0;
        block3: while (i > 0) {
            char c;
            line = (String)lines.get(i);
            if (line.length() <= 0) continue;
            int j = line.length() - 1;
            while (j >= 0) {
                c = line.charAt(j);
                if (Character.isDigit(c)) {
                    bytesEnd = j + 1;
                    break;
                }
                --j;
            }
            while (j >= 0) {
                c = line.charAt(j);
                if (!Character.isDigit(c) && c != ',' && c != '.') {
                    bytesStart = j + 1;
                    break block3;
                }
                --j;
            }
            break block3;
        }
        StringBuffer buf = new StringBuffer(line.substring(bytesStart, bytesEnd));
        int k = 0;
        while (k < buf.length()) {
            if (buf.charAt(k) == ',' || buf.charAt(k) == '.') {
                buf.deleteCharAt(k--);
            }
            ++k;
        }
        bytes = Long.parseLong(buf.toString());
        return bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long freeSpaceUnix(String path, boolean kb) throws IOException {
        String[] stringArray;
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        path = FilenameUtils.normalize(path);
        if (kb) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "df";
            stringArray2[1] = "-k";
            stringArray = stringArray2;
            stringArray2[2] = path;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "df";
            stringArray = stringArray3;
            stringArray3[1] = path;
        }
        String[] cmdAttribs = stringArray;
        long bytes = -1L;
        BufferedReader in = null;
        try {
            in = this.openProcessStream(cmdAttribs);
            String line1 = in.readLine();
            String line2 = in.readLine();
            String line3 = in.readLine();
            if (line2 == null) {
                throw new IOException("Command line 'df' did not return info as expected for path '" + path + "'- response on first line was '" + line1 + "'");
            }
            StringTokenizer tok = new StringTokenizer(line2 = line2.trim(), " ");
            if (tok.countTokens() < 4) {
                if (tok.countTokens() != 1 || line3 == null) throw new IOException("Command line 'df' did not return data as expected for path '" + path + "'- check path is valid");
                line3 = line3.trim();
                tok = new StringTokenizer(line3, " ");
            } else {
                tok.nextToken();
            }
            tok.nextToken();
            tok.nextToken();
            String freeSpace = tok.nextToken();
            try {
                bytes = Long.parseLong(freeSpace);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Command line 'df' did not return numeric data as expected for path '" + path + "'- check path is valid");
            }
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        if (bytes >= 0L) return bytes;
        throw new IOException("Command line 'df' did not find free space in response for path '" + path + "'- check path is valid");
    }

    BufferedReader openProcessStream(String[] params) throws IOException {
        Process proc = Runtime.getRuntime().exec(params);
        return new BufferedReader(new InputStreamReader(proc.getInputStream()));
    }

    static {
        int os = 0;
        try {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new IOException("os.name not found");
            }
            os = (osName = osName.toLowerCase()).indexOf("windows") != -1 ? 1 : (osName.indexOf("linux") != -1 || osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1 || osName.indexOf("mpe/ix") != -1 || osName.indexOf("hp-ux") != -1 || osName.indexOf("aix") != -1 || osName.indexOf("freebsd") != -1 || osName.indexOf("irix") != -1 || osName.indexOf("digital unix") != -1 || osName.indexOf("unix") != -1 || osName.indexOf("mac os x") != -1 ? 2 : 0);
        }
        catch (Exception ex) {
            os = -1;
        }
        OS = os;
    }
}

