/*** FILE "fatal.h" ***********************************************************/
#ifndef _fatal_h_
#define _fatal_h_

/*** WARNING, FATAL ***********************************************************/

#define WARNING(msg) Warning(__FILE__,__LINE__,msg)
#define FATAL(msg)   Fatal(__FILE__,__LINE__,msg)

/*** ALLOCATION ***************************************************************/

extern const char* const ALLOCATION;  //Message descriping an allocation error,
                                      //should be used like
                                      //"FATAL(ALLOCATION);".

/*** Warning, Fatal ***********************************************************/

void Warning(const char* const file, int line, const char* const msg);
/* Issues a message 'msg' with reference to the line 'line' in the file 'file'.
 * Program execution can be continued after the warning; this function always
 * returns.
 */

void Fatal(const char* const file, int line, const char* const msg);
/* Issues a message 'msg' with reference to the line 'line' in the file 'file'.
 * Program execution can NOT be continued; this function never returns!!!
 */

#endif
/******** "fatal.h" ***********************************************************/

