program nic2cb;
{$m 65520,0,600000}
uses
  crt,dos, ch_files, ch_chess, ch_parse;

const
  omit_deleted: longint = 0;
  omit_fragment: longint = 0;
  omit_quiz: longint = 0;
  omit_illegal: longint = 0;

var
  not_printed_games, temp : longint;
  i : integer;
  numb_of_games, game_numb : longint;
  kk : byte;
  source, target, target2 : sourcetype;
  game : gametype;
  target_idx, t_game_numb : longint;
  log_fil : text;

{mainprogram}
begin
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln;
  writeln('SYNTAX: NIC2CB source-file target-file');
  writeln;
  writeln('The following games will be omitted: ');
  writeln;
  writeln('- deleted, and overwritten games');
  writeln('- game fragments (games starting with a position)');
  writeln;
  writeln;
  source.name:='';
  target.name:='';
  not_printed_games:=0;
  if paramcount=0 then
  begin
    write('NicBase-file to be converted to ChessBase:    ');
    readln(source.name);
    target.name:='';
    write('Name of new ChessBase file:                   ');
    readln(target.name);
    if length(target.name)=0 then
      target.name:=source.name;
  end
  else
  if paramcount=1 then
  begin
    source.name:=paramstr(1);
    target.name:=source.name;
  end
  else
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
  end;
  remove_ext(source.name);
  remove_ext(target.name);
  find_path(source.name,source.path);
  find_path(target.name,target.path);

  if file_exist(source.path+source.name+'.I30') and
     file_exist(source.path+source.name+'.G30') then
  begin
    open_file_for_write(target.index,target.path+target.name+'.CBI');
    open_file_for_write(target.game,target.path+target.name+'.CBF');
    io_test;
    open_file_for_read(source.index  ,source.path+source.name+'.I30');
    open_file_for_read(source.game   ,source.path+source.name+'.G30');
    if not io_error then
    begin
      target_idx:=0;
      t_game_numb:=0;
      game.game_format:='NIC';
      game.beg:=get_index_val(source.index);
      numb_of_games:=(filesize(source.index.f)-4) div 4;
      writeln(numb_of_games:6,' Games to examine');
      put_index_val(target.index,numb_of_games+1);
      put_index_val(target.index,target_idx+t_game_numb+2);
      game_numb:=1;
      while (game_numb<=numb_of_games) and (not io_error) and
            (not keypressed) do
      begin
        game.beg_next:=get_index_val(source.index);
        game.len:=game.beg_next-game.beg;
        if game.len<0 then
        begin
          write('game.len<0');
          halt;
        end;
        i:=0;
        while (i<game.len) and (not io_error) do
        begin
          game.bytes[i]:=get_next_byte(source.game);
          inc(i);
        end;
        game.bytes[game.len]:=-1;
        parse_nic_gamehead(game);
        if not (game.deleted or game.overwritten or
                game.position or game.quiz)
        then
        begin
          parse_nic_moves(game);
          write_cb_gamehead(game);
          if not game.illegal_move then
          begin
            inc(t_game_numb);
            target_idx:=target_idx+game.len;
            put_index_val(target.index,target_idx+t_game_numb+2);
            for i:=0 to game.len-1 do
            begin
              put_next_byte(target.game,game.bytes[i]);
            end;
          end
          else
          begin
            inc(not_printed_games);
            inc(omit_illegal);
            if omit_illegal=1 then
            begin
              assign(log_fil,source.path+source.name+'.log');
              rewrite(log_fil);
            end;
            writeln(log_fil,game_numb+1:6,'':4,game.cb_players);
          end;
        end
        else
        begin
          inc(not_printed_games);
          if (game.deleted) or (game.overwritten) then
            inc(omit_deleted)
          else if game.position then
            inc(omit_fragment)
          else if game.quiz then
            inc(omit_quiz);
        end;
        game.beg:=game.beg_next;
        gotoxy(1,wherey);
        write(game_numb:6,' Games Examined ',not_printed_games:6,
              ' Games omitted');
        inc(game_numb);

      end;
    end;
    close_read_file(source.index);
    close_read_file(source.game);
    close_write_file(target.index);
    close_write_file(target.game);
    if omit_illegal>0 then
      close(log_fil);
    if (not_printed_games>0) or (keypressed) then
    begin
      open_file_for_read(target.index,target.path+target.name+'.CBI');
      open_file_for_write(target2.index,'--new_ix.ccc');
      temp:=get_index_val(target.index);
      put_index_val(target2.index,t_game_numb+1);
      for i:=1 to t_game_numb+1 do
      begin
        put_index_val(target2.index,get_index_val(target.index));
        if (i mod 40)=0 then
          write('.');
      end;
      close_read_file(target.index);
      close_write_file(target2.index);
      erase(target.index.f);
      io_test;
      rename(target2.index.f,target.path+target.name+'.CBI');
      writeln;
      if not_printed_games>0 then
      begin
        writeln;
        writeln('Omitted games due to deletion/overwrite:    ',omit_deleted);
        writeln('Omitted games due to game fragments:        ',omit_fragment);
        writeln('Omitted games due to quiz:                  ',omit_quiz);
        writeln('Omitted games due to illegal moves          ',omit_illegal);
      end;
    end;
  end
  else
  begin
    writeln(source.path+source.name,'  Does not exist');
  end;
  writeln;
end.
