/* Autogenerated file, DO NOT EDIT manually! generated by pan_gen_perf.py
 *
 * Copyright © 2021 Arm Limited
 * Copyright © 2021 Collabora Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include "pan_perf_metrics.h"

#include <util/macros.h>

static void UNUSED
static_asserts_tdvx(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(57 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_tdvx = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tdvx.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 68,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 81,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 83,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 85,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 87,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 88,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 90,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 91,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 95,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 98,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 99,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 101,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 102,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 118,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 119,
               .category = &panfrost_perf_config_tdvx.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 57,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Partial fragment warps",
               .desc = "The number of fragment warps containing helper threads that do not correspond to a hit sample point.",
               .symbol_name = "frag_partial_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 202,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Execution engine active",
               .desc = "The number of cycles where the execution engine unit is processing at least one thread.",
               .symbol_name = "exec_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 219,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Executed instructions",
               .desc = "The number of instructions executed per warp.",
               .symbol_name = "exec_instr_count",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where no new threads are available for execution.",
               .symbol_name = "exec_instr_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 222,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Arithmetic instructions",
               .desc = "The number of instructions where the workload is a single FMA pipe arithmetic operation.",
               .symbol_name = "arith_instr_single_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Dual Arithmetic instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe arithmetic operation.",
               .symbol_name = "arith_instr_double",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Arithmetic + Message instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe message operation",
               .symbol_name = "arith_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 225,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions where the workload is a single ADD pipe message operation, with no FMA pipe operation",
               .symbol_name = "arith_instr_msg_only",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgi_num_quads",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 227,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Texture issues",
               .desc = "The number of quad-width filtering passes.",
               .symbol_name = "tex_dfch_num_passes",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 228,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Descriptor misses",
               .desc = "The number of quad-width filtering passes that miss in the resource or sampler descriptor cache.",
               .symbol_name = "tex_dfch_num_passes_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 229,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Mipmapped texture issues",
               .desc = "The number of quad-width filtering passes that use a mipmapped texture.",
               .symbol_name = "tex_dfch_num_passes_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 230,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Trilinear filtered issues",
               .desc = "The number of quad-width filtering passes that use a trilinear filter.",
               .symbol_name = "tex_tidx_num_split_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 231,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "The number of texture line fetches from the L2 cache.",
               .symbol_name = "tex_tfch_num_lines_fetched",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 232,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Compressed line fetches",
               .desc = "The number of texture line fetches from the L2 cache that are block compressed textures.",
               .symbol_name = "tex_tfch_num_lines_fetched_block_compressed",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 233,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Cache lookups",
               .desc = "The number of texture cache lookup cycles.",
               .symbol_name = "tex_tfch_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 234,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 235,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_tdvx.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 132,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 144,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 145,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 146,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 147,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 148,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 149,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 150,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 151,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 152,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 153,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 154,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 155,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 156,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 157,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 158,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 159,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 160,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 161,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 162,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 163,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 164,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 165,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 166,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 167,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 168,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 169,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 170,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 171,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 172,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 173,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 174,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 175,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 176,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 177,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 178,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 179,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 180,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 181,
               .category = &panfrost_perf_config_tdvx.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_tdvx

static void UNUSED
static_asserts_tsix(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(57 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_tsix = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tsix.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 68,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 81,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 83,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 85,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 87,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 88,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 90,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 91,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 95,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 98,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 99,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 101,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 102,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 118,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 119,
               .category = &panfrost_perf_config_tsix.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 57,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Partial fragment warps",
               .desc = "The number of fragment warps containing helper threads that do not correspond to a hit sample point.",
               .symbol_name = "frag_partial_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 202,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Execution engine active",
               .desc = "The number of cycles where the execution engine unit is processing at least one thread.",
               .symbol_name = "exec_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 219,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Executed instructions",
               .desc = "The number of instructions executed per warp.",
               .symbol_name = "exec_instr_count",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where no new threads are available for execution.",
               .symbol_name = "exec_instr_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 222,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Arithmetic instructions",
               .desc = "The number of instructions where the workload is a single FMA pipe arithmetic operation.",
               .symbol_name = "arith_instr_single_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Dual Arithmetic instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe arithmetic operation.",
               .symbol_name = "arith_instr_double",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Arithmetic + Message instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe message operation",
               .symbol_name = "arith_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 225,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions where the workload is a single ADD pipe message operation, with no FMA pipe operation",
               .symbol_name = "arith_instr_msg_only",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgi_num_quads",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 227,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Texture issues",
               .desc = "The number of quad-width filtering passes.",
               .symbol_name = "tex_dfch_num_passes",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 228,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Descriptor misses",
               .desc = "The number of quad-width filtering passes that miss in the resource or sampler descriptor cache.",
               .symbol_name = "tex_dfch_num_passes_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 229,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Mipmapped texture issues",
               .desc = "The number of quad-width filtering passes that use a mipmapped texture.",
               .symbol_name = "tex_dfch_num_passes_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 230,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Trilinear filtered issues",
               .desc = "The number of quad-width filtering passes that use a trilinear filter.",
               .symbol_name = "tex_tidx_num_split_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 231,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "The number of texture line fetches from the L2 cache.",
               .symbol_name = "tex_tfch_num_lines_fetched",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 232,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Compressed line fetches",
               .desc = "The number of texture line fetches from the L2 cache that are block compressed textures.",
               .symbol_name = "tex_tfch_num_lines_fetched_block_compressed",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 233,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Cache lookups",
               .desc = "The number of texture cache lookup cycles.",
               .symbol_name = "tex_tfch_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 234,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 235,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_tsix.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 132,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 144,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 145,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 146,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 147,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 148,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 149,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 150,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 151,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 152,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 153,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 154,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 155,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 156,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 157,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 158,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 159,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 160,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 161,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 162,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 163,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 164,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 165,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 166,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 167,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 168,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 169,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 170,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 171,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 172,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 173,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 174,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 175,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 176,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 177,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 178,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 179,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 180,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 181,
               .category = &panfrost_perf_config_tsix.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_tsix

static void UNUSED
static_asserts_tgox(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(59 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_tgox = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tgox.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 68,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 81,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 83,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 85,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 87,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 88,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 90,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 91,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 95,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 98,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 99,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 101,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 102,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 118,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 119,
               .category = &panfrost_perf_config_tgox.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 59,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Partial fragment warps",
               .desc = "The number of fragment warps containing helper threads that do not correspond to a hit sample point.",
               .symbol_name = "frag_partial_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 202,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "All register warps",
               .desc = "The number of warps that require more than 32 registers.",
               .symbol_name = "warp_reg_size_64",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 209,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Full quad warps",
               .desc = "The number of warps that are fully populated with quads.",
               .symbol_name = "full_quad_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 213,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Execution engine active",
               .desc = "The number of cycles where the execution engine unit is processing at least one thread.",
               .symbol_name = "exec_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 219,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Executed instructions",
               .desc = "The number of instructions executed per warp.",
               .symbol_name = "exec_instr_count",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where no new threads are available for execution.",
               .symbol_name = "exec_instr_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 222,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Arithmetic instructions",
               .desc = "The number of instructions where the workload is a single FMA pipe arithmetic operation.",
               .symbol_name = "arith_instr_single_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Dual Arithmetic instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe arithmetic operation.",
               .symbol_name = "arith_instr_double",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Arithmetic + Message instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe message operation",
               .symbol_name = "arith_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 225,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions where the workload is a single ADD pipe message operation, with no FMA pipe operation",
               .symbol_name = "arith_instr_msg_only",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgi_num_quads",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 227,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Texture issues",
               .desc = "The number of quad-width filtering passes.",
               .symbol_name = "tex_dfch_num_passes",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 228,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Descriptor misses",
               .desc = "The number of quad-width filtering passes that miss in the resource or sampler descriptor cache.",
               .symbol_name = "tex_dfch_num_passes_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 229,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Mipmapped texture issues",
               .desc = "The number of quad-width filtering passes that use a mipmapped texture.",
               .symbol_name = "tex_dfch_num_passes_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 230,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Trilinear filtered issues",
               .desc = "The number of quad-width filtering passes that use a trilinear filter.",
               .symbol_name = "tex_tidx_num_split_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 231,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "The number of texture line fetches from the L2 cache.",
               .symbol_name = "tex_tfch_num_lines_fetched",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 232,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Compressed line fetches",
               .desc = "The number of texture line fetches from the L2 cache that are block compressed textures.",
               .symbol_name = "tex_tfch_num_lines_fetched_block_compressed",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 233,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Cache lookups",
               .desc = "The number of texture cache lookup cycles.",
               .symbol_name = "tex_tfch_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 234,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 235,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_tgox.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 132,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 144,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 145,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 146,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 147,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 148,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 149,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 150,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 151,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 152,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 153,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 154,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 155,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 156,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 157,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 158,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 159,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 160,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 161,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 162,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 163,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 164,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 165,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 166,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 167,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 168,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 169,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 170,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 171,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 172,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 173,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 174,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 175,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 176,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 177,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 178,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 179,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 180,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 181,
               .category = &panfrost_perf_config_tgox.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_tgox

static void UNUSED
static_asserts_tnax(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(59 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_tnax = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tnax.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 196,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 208,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 209,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 210,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 212,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 213,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 214,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 215,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 216,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 217,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 218,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 219,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 220,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 224,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 227,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 228,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 229,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 230,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 231,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 232,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 233,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 235,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 236,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 237,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 238,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 239,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 242,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 243,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 245,
               .category = &panfrost_perf_config_tnax.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 59,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives_out",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Partial rasterized quads",
               .desc = "The number of partially-rasterized fragment quads created.",
               .symbol_name = "frag_partial_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 202,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "All register warps",
               .desc = "The number of warps that require more than 32 registers.",
               .symbol_name = "warp_reg_size_64",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 209,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Full quad warps",
               .desc = "The number of warps that are fully populated with quads.",
               .symbol_name = "full_quad_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 213,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "FMA instructions",
               .desc = "The number of instructions issued to the FMA pipe.",
               .symbol_name = "exec_instr_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "CVT instructions",
               .desc = "The number of instructions issued to the CVT pipe.",
               .symbol_name = "exec_instr_cvt",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "SFU instructions",
               .desc = "The number of instructions issued to the SFU pipe.",
               .symbol_name = "exec_instr_sfu",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions issued to the MSG pipe.",
               .symbol_name = "exec_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Instruction cache misses",
               .desc = "The number of instruction cache misses.",
               .symbol_name = "exec_icache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 224,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where the processing unit is starved of work.",
               .symbol_name = "exec_starve_arith",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Blend shader calls",
               .desc = "The number of blend shader invocations executed.",
               .symbol_name = "call_blend_shader",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Input beats",
               .desc = "The number of texture request message data beats.",
               .symbol_name = "tex_msgi_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 227,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Descriptor stall cycles",
               .desc = "The number of cycles where a quad is stalled on texture descriptor fetch.",
               .symbol_name = "tex_dfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 228,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Fetch queue stall cycles",
               .desc = "The number of cycles where a quad is stalled on entering texture fetch because the fetch queue is full.",
               .symbol_name = "tex_tfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 229,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Filtering unit stall cycles",
               .desc = "The number of cycles where the filtering unit is idle and there is at least one quad present in the texture data fetch queue.",
               .symbol_name = "tex_tfch_starved_pending_data_fetch",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 230,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 231,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "4x bilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement nearest or bilinear filtering.",
               .symbol_name = "tex_filt_num_fxr_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 232,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "2x trilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement trilinear filtering.",
               .symbol_name = "tex_filt_num_fst_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 233,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgo_num_msg",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 234,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Output beats",
               .desc = "The number of texture response message data beats.",
               .symbol_name = "tex_msgo_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 235,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_tnax.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 4,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 6,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 7,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 8,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 9,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 10,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 11,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 12,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 13,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 14,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 17,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 19,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 21,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 24,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 26,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 27,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 34,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 35,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 37,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 38,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 54,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 55,
               .category = &panfrost_perf_config_tnax.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_tnax

static void UNUSED
static_asserts_totx(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(59 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_totx = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_totx.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 196,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 208,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 209,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 210,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 212,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 213,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 214,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 215,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 216,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 217,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 218,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 219,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 220,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 224,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 227,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 228,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 229,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 230,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 231,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 232,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 233,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 235,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 236,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 237,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 238,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 239,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 242,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 243,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 245,
               .category = &panfrost_perf_config_totx.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 59,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives_out",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Partial rasterized quads",
               .desc = "The number of partially-rasterized fragment quads created.",
               .symbol_name = "frag_partial_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 202,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "All register warps",
               .desc = "The number of warps that require more than 32 registers.",
               .symbol_name = "warp_reg_size_64",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 209,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Full quad warps",
               .desc = "The number of warps that are fully populated with quads.",
               .symbol_name = "full_quad_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 213,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "FMA instructions",
               .desc = "The number of instructions issued to the FMA pipe.",
               .symbol_name = "exec_instr_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "CVT instructions",
               .desc = "The number of instructions issued to the CVT pipe.",
               .symbol_name = "exec_instr_cvt",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "SFU instructions",
               .desc = "The number of instructions issued to the SFU pipe.",
               .symbol_name = "exec_instr_sfu",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions issued to the MSG pipe.",
               .symbol_name = "exec_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Instruction cache misses",
               .desc = "The number of instruction cache misses.",
               .symbol_name = "exec_icache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 224,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where the processing unit is starved of work.",
               .symbol_name = "exec_starve_arith",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Blend shader calls",
               .desc = "The number of blend shader invocations executed.",
               .symbol_name = "call_blend_shader",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Input beats",
               .desc = "The number of texture request message data beats.",
               .symbol_name = "tex_msgi_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 227,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Descriptor stall cycles",
               .desc = "The number of cycles where a quad is stalled on texture descriptor fetch.",
               .symbol_name = "tex_dfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 228,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Fetch queue stall cycles",
               .desc = "The number of cycles where a quad is stalled on entering texture fetch because the fetch queue is full.",
               .symbol_name = "tex_tfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 229,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Filtering unit stall cycles",
               .desc = "The number of cycles where the filtering unit is idle and there is at least one quad present in the texture data fetch queue.",
               .symbol_name = "tex_tfch_starved_pending_data_fetch",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 230,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 231,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "4x bilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement nearest or bilinear filtering.",
               .symbol_name = "tex_filt_num_fxr_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 232,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "2x trilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement trilinear filtering.",
               .symbol_name = "tex_filt_num_fst_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 233,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgo_num_msg",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 234,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Output beats",
               .desc = "The number of texture response message data beats.",
               .symbol_name = "tex_msgo_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 235,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Any active",
               .desc = "The number of cycles where the shader core is processing either a non-fragment workload or a fragment workload.",
               .symbol_name = "shader_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 245,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_totx.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 4,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 6,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 7,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 8,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 9,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 10,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 11,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 12,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 13,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 14,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 17,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 19,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 21,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 24,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 26,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 27,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 34,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 35,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 37,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 38,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 54,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 55,
               .category = &panfrost_perf_config_totx.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_totx

static void UNUSED
static_asserts_tmix(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(57 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_tmix = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tmix.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 68,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 81,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 83,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 85,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 87,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 88,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 90,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 91,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 95,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 98,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 99,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 101,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 102,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 118,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 119,
               .category = &panfrost_perf_config_tmix.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 57,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Partial fragment warps",
               .desc = "The number of fragment warps containing helper threads that do not correspond to a hit sample point.",
               .symbol_name = "frag_partial_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 202,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Execution engine active",
               .desc = "The number of cycles where the execution engine unit is processing at least one thread.",
               .symbol_name = "exec_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 219,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Executed instructions",
               .desc = "The number of instructions executed per warp.",
               .symbol_name = "exec_instr_count",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where no new threads are available for execution.",
               .symbol_name = "exec_instr_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 222,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Arithmetic instructions",
               .desc = "The number of instructions where the workload is a single FMA pipe arithmetic operation.",
               .symbol_name = "arith_instr_single_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Dual Arithmetic instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe arithmetic operation.",
               .symbol_name = "arith_instr_double",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Arithmetic + Message instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe message operation",
               .symbol_name = "arith_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 225,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions where the workload is a single ADD pipe message operation, with no FMA pipe operation",
               .symbol_name = "arith_instr_msg_only",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of thread-width texture operations processed.",
               .symbol_name = "tex_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 227,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Mipmapped texture request",
               .desc = "The number of texture operations that act on a mipmapped texture.",
               .symbol_name = "tex_instr_mipmap",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 228,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Compressed texture requests",
               .desc = "The number of texture operations acting on a compressed texture.",
               .symbol_name = "tex_instr_compressed",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 229,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "3D texture requests",
               .desc = "The number of texture operations acting on a 3D texture.",
               .symbol_name = "tex_instr_3d",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 230,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Trilinear filtered requests",
               .desc = "The number of texture operations using a trilinear texture filter.",
               .symbol_name = "tex_instr_trilinear",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 231,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_coord_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 232,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Coordinate stall cycles",
               .desc = "The number of clock cycles where threads are stalled at the texel coordinate calculation stage.",
               .symbol_name = "tex_coord_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 233,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Line fill stall cycles",
               .desc = "The number of clock cycles where at least one thread is waiting for data from the texture cache, but no lookup is completed.",
               .symbol_name = "tex_starve_cache",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 234,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Partial data stall cycles",
               .desc = "The number of clock cycles where at least one thread fetched some data from the texture cache, but no filtering operation is started.",
               .symbol_name = "tex_starve_filter",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 235,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Load/store write beats",
               .desc = "The number of write beats sent by the load/store unit.",
               .symbol_name = "beats_wr_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
            {
               .name = "Other write beats",
               .desc = "The number of write beats sent by any unit that is not specifically identified.",
               .symbol_name = "beats_wr_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_tmix.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 132,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 144,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 145,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 146,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 147,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 148,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 149,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 150,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 151,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 152,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 153,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 154,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 155,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 156,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 157,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 158,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 159,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 160,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 161,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 162,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 163,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 164,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 165,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 166,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 167,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 168,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 169,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 170,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 171,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 172,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 173,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 174,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 175,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 176,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 177,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 178,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 179,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 180,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 181,
               .category = &panfrost_perf_config_tmix.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_tmix

static void UNUSED
static_asserts_thex(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(57 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_thex = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_thex.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 68,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 81,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 83,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 85,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 87,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 88,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 90,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 91,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 95,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 98,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 99,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 101,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 102,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 118,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 119,
               .category = &panfrost_perf_config_thex.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 57,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Partial fragment warps",
               .desc = "The number of fragment warps containing helper threads that do not correspond to a hit sample point.",
               .symbol_name = "frag_partial_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 202,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Execution engine active",
               .desc = "The number of cycles where the execution engine unit is processing at least one thread.",
               .symbol_name = "exec_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 219,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Executed instructions",
               .desc = "The number of instructions executed per warp.",
               .symbol_name = "exec_instr_count",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where no new threads are available for execution.",
               .symbol_name = "exec_instr_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 222,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Arithmetic instructions",
               .desc = "The number of instructions where the workload is a single FMA pipe arithmetic operation.",
               .symbol_name = "arith_instr_single_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Dual Arithmetic instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe arithmetic operation.",
               .symbol_name = "arith_instr_double",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Arithmetic + Message instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe message operation",
               .symbol_name = "arith_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 225,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions where the workload is a single ADD pipe message operation, with no FMA pipe operation",
               .symbol_name = "arith_instr_msg_only",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of thread-width texture operations processed.",
               .symbol_name = "tex_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 227,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Mipmapped texture request",
               .desc = "The number of texture operations that act on a mipmapped texture.",
               .symbol_name = "tex_instr_mipmap",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 228,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Compressed texture requests",
               .desc = "The number of texture operations acting on a compressed texture.",
               .symbol_name = "tex_instr_compressed",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 229,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "3D texture requests",
               .desc = "The number of texture operations acting on a 3D texture.",
               .symbol_name = "tex_instr_3d",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 230,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Trilinear filtered requests",
               .desc = "The number of texture operations using a trilinear texture filter.",
               .symbol_name = "tex_instr_trilinear",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 231,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_coord_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 232,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Coordinate stall cycles",
               .desc = "The number of clock cycles where threads are stalled at the texel coordinate calculation stage.",
               .symbol_name = "tex_coord_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 233,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Line fill stall cycles",
               .desc = "The number of clock cycles where at least one thread is waiting for data from the texture cache, but no lookup is completed.",
               .symbol_name = "tex_starve_cache",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 234,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Partial data stall cycles",
               .desc = "The number of clock cycles where at least one thread fetched some data from the texture cache, but no filtering operation is started.",
               .symbol_name = "tex_starve_filter",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 235,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Load/store write beats",
               .desc = "The number of write beats sent by the load/store unit.",
               .symbol_name = "beats_wr_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
            {
               .name = "Other write beats",
               .desc = "The number of write beats sent by any unit that is not specifically identified.",
               .symbol_name = "beats_wr_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_thex.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 132,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 144,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 145,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 146,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 147,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 148,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 149,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 150,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 151,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 152,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 153,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 154,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 155,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 156,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 157,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 158,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 159,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 160,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 161,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 162,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 163,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 164,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 165,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 166,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 167,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 168,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 169,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 170,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 171,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 172,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 173,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 174,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 175,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 176,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 177,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 178,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 179,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 180,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 181,
               .category = &panfrost_perf_config_thex.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_thex

static void UNUSED
static_asserts_tnox(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(59 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_tnox = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tnox.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 68,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 81,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 83,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 85,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 87,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 88,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 90,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 91,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 95,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 98,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 99,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 101,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 102,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 118,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 119,
               .category = &panfrost_perf_config_tnox.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 59,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Partial fragment warps",
               .desc = "The number of fragment warps containing helper threads that do not correspond to a hit sample point.",
               .symbol_name = "frag_partial_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 202,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "All register warps",
               .desc = "The number of warps that require more than 32 registers.",
               .symbol_name = "warp_reg_size_64",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 209,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Full quad warps",
               .desc = "The number of warps that are fully populated with quads.",
               .symbol_name = "full_quad_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 213,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Execution engine active",
               .desc = "The number of cycles where the execution engine unit is processing at least one thread.",
               .symbol_name = "exec_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 219,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Executed instructions",
               .desc = "The number of instructions executed per warp.",
               .symbol_name = "exec_instr_count",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where no new threads are available for execution.",
               .symbol_name = "exec_instr_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 222,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Arithmetic instructions",
               .desc = "The number of instructions where the workload is a single FMA pipe arithmetic operation.",
               .symbol_name = "arith_instr_single_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Dual Arithmetic instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe arithmetic operation.",
               .symbol_name = "arith_instr_double",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Arithmetic + Message instructions",
               .desc = "The number of instructions where the workload is one FMA pipe arithmetic operation and one ADD pipe message operation",
               .symbol_name = "arith_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 225,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions where the workload is a single ADD pipe message operation, with no FMA pipe operation",
               .symbol_name = "arith_instr_msg_only",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgi_num_quads",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 227,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Texture issues",
               .desc = "The number of quad-width filtering passes.",
               .symbol_name = "tex_dfch_num_passes",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 228,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Descriptor misses",
               .desc = "The number of quad-width filtering passes that miss in the resource or sampler descriptor cache.",
               .symbol_name = "tex_dfch_num_passes_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 229,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Mipmapped texture issues",
               .desc = "The number of quad-width filtering passes that use a mipmapped texture.",
               .symbol_name = "tex_dfch_num_passes_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 230,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Trilinear filtered issues",
               .desc = "The number of quad-width filtering passes that use a trilinear filter.",
               .symbol_name = "tex_tidx_num_split_mip_map",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 231,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "The number of texture line fetches from the L2 cache.",
               .symbol_name = "tex_tfch_num_lines_fetched",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 232,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Compressed line fetches",
               .desc = "The number of texture line fetches from the L2 cache that are block compressed textures.",
               .symbol_name = "tex_tfch_num_lines_fetched_block_compressed",
               .units = PAN_PERF_COUNTER_UNITS_ISSUES,
               .offset = 233,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Cache lookups",
               .desc = "The number of texture cache lookup cycles.",
               .symbol_name = "tex_tfch_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 234,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 235,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_tnox.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 132,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 144,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 145,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 146,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 147,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 148,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 149,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 150,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 151,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 152,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 153,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 154,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 155,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 156,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 157,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 158,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 159,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 160,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 161,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 162,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 163,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 164,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 165,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 166,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 167,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 168,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 169,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 170,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 171,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 172,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 173,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 174,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 175,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 176,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 177,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 178,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 179,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 180,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 181,
               .category = &panfrost_perf_config_tnox.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_tnox

static void UNUSED
static_asserts_ttrx(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(59 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_ttrx = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_ttrx.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 196,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 208,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 209,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 210,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 212,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 213,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 214,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 215,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 216,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 217,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 218,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 219,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 220,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 224,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 227,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 228,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 229,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 230,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 231,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 232,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 233,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 235,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 236,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 237,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 238,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 239,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 242,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 243,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 245,
               .category = &panfrost_perf_config_ttrx.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 59,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives_out",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Partial rasterized quads",
               .desc = "The number of partially-rasterized fragment quads created.",
               .symbol_name = "frag_partial_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 202,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "All register warps",
               .desc = "The number of warps that require more than 32 registers.",
               .symbol_name = "warp_reg_size_64",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 209,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Full quad warps",
               .desc = "The number of warps that are fully populated with quads.",
               .symbol_name = "full_quad_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 213,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "FMA instructions",
               .desc = "The number of instructions issued to the FMA pipe.",
               .symbol_name = "exec_instr_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "CVT instructions",
               .desc = "The number of instructions issued to the CVT pipe.",
               .symbol_name = "exec_instr_cvt",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "SFU instructions",
               .desc = "The number of instructions issued to the SFU pipe.",
               .symbol_name = "exec_instr_sfu",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions issued to the MSG pipe.",
               .symbol_name = "exec_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Instruction cache misses",
               .desc = "The number of instruction cache misses.",
               .symbol_name = "exec_icache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 224,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where the processing unit is starved of work.",
               .symbol_name = "exec_starve_arith",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Blend shader calls",
               .desc = "The number of blend shader invocations executed.",
               .symbol_name = "call_blend_shader",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Input beats",
               .desc = "The number of texture request message data beats.",
               .symbol_name = "tex_msgi_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 227,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Descriptor stall cycles",
               .desc = "The number of cycles where a quad is stalled on texture descriptor fetch.",
               .symbol_name = "tex_dfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 228,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Fetch queue stall cycles",
               .desc = "The number of cycles where a quad is stalled on entering texture fetch because the fetch queue is full.",
               .symbol_name = "tex_tfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 229,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Filtering unit stall cycles",
               .desc = "The number of cycles where the filtering unit is idle and there is at least one quad present in the texture data fetch queue.",
               .symbol_name = "tex_tfch_starved_pending_data_fetch",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 230,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 231,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "4x bilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement nearest or bilinear filtering.",
               .symbol_name = "tex_filt_num_fxr_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 232,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "2x trilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement trilinear filtering.",
               .symbol_name = "tex_filt_num_fst_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 233,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgo_num_msg",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 234,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Output beats",
               .desc = "The number of texture response message data beats.",
               .symbol_name = "tex_msgo_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 235,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Multiplier instructions",
               .desc = "The number of instructions where the workload uses floating-point multiplier hardware.",
               .symbol_name = "arith_instr_fp_mul",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 245,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_ttrx.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 4,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 6,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 7,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 8,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 9,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 10,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 11,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 12,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 13,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 14,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 17,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 19,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 21,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 24,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 26,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 27,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 34,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 35,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 37,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 38,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 54,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 55,
               .category = &panfrost_perf_config_ttrx.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_ttrx

static void UNUSED
static_asserts_tbox(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(23 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(39 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(59 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(24 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_tbox = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 23,
         .counters = {
            {
               .name = "GPU active",
               .desc = "The number of cycles where the GPU has a workload of any type queued for processing.",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Interrupt active",
               .desc = "The number of cycles where the GPU has a pending interrupt.",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Fragment jobs",
               .desc = "The number of jobs processed by the GPU fragment queue.",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Fragment tasks",
               .desc = "The number of 32x32 pixel tasks processed by the GPU fragment queue.",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 9,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Fragment queue active",
               .desc = "The number of cycles where work is queued for processing in the GPU fragment queue.",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Fragment descriptor reads cycles",
               .desc = "The number of cycles where queued fragment work is waiting for a descriptor load.",
               .symbol_name = "js0_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 12,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Fragment job issue cycles",
               .desc = "The number of cycles where queued fragment work is waiting for an available processor.",
               .symbol_name = "js0_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 13,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Fragment job dependency cycles",
               .desc = "The number of cycles where queued fragment work is waiting for dependent work to complete.",
               .symbol_name = "js0_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued fragment work to complete.",
               .symbol_name = "js0_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 15,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Non-fragment jobs",
               .desc = "The number of jobs processed by the GPU non-fragment queue.",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of tasks processed by the GPU non-fragment queue.",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Non-fragment queue active",
               .desc = "The number of cycles where work is queued in the GPU non-fragment queue.",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Non-fragment descriptor read cycles",
               .desc = "The number number of cycles where queued non-fragment work is waiting for a descriptor load.",
               .symbol_name = "js1_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 20,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job issue cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for an available processor.",
               .symbol_name = "js1_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 21,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job dependency cycles",
               .desc = "The number of cycles where queued non-fragment work is waiting for dependent work to complete.",
               .symbol_name = "js1_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 22,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Non-fragment job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued non-fragment work to complete.",
               .symbol_name = "js1_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Reserved jobs",
               .desc = "The number of jobs processed by the GPU reserved queue.",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Reserved tasks",
               .desc = "The number of tasks processed by the GPU reserved queue.",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Reserved queue active",
               .desc = "The number of cycles where work is queued in the GPU reserved queue.",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Reserved descriptor read cycles",
               .desc = "The number of cycles where queued reserved work is waiting for a descriptor load.",
               .symbol_name = "js2_wait_read",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 28,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Reserved job issue cycles",
               .desc = "The number of cycles where queued reserved work is waiting for an available processor.",
               .symbol_name = "js2_wait_issue",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 29,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Reserved job dependency cycles",
               .desc = "The number of cycles where queued reserved work is waiting for dependent work to complete.",
               .symbol_name = "js2_wait_depend",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 30,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
            {
               .name = "Reserved job finish cycles",
               .desc = "The number of cycles where the GPU is waiting for issued reserved work to complete.",
               .symbol_name = "js2_wait_finish",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tbox.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Memory System",
         .n_counters = 39,
         .counters = {
            {
               .name = "MMU lookups",
               .desc = "The number of main MMU address translations performed.",
               .symbol_name = "mmu_requests",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 196,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Read requests",
               .desc = "The number of L2 cache read requests from internal masters.",
               .symbol_name = "l2_rd_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 208,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles L2 cache read requests from internal masters are stalled.",
               .symbol_name = "l2_rd_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 209,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Write requests",
               .desc = "The number of L2 cache write requests from internal masters.",
               .symbol_name = "l2_wr_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 210,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where L2 cache write requests from internal masters are stalled.",
               .symbol_name = "l2_wr_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Snoop requests",
               .desc = "The number of L2 snoop requests from internal masters.",
               .symbol_name = "l2_snp_msg_in",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 212,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where L2 cache snoop requests from internal masters are stalled.",
               .symbol_name = "l2_snp_msg_in_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 213,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "L1 read requests",
               .desc = "The number of L1 cache read requests sent by the L2 cache to an internal master.",
               .symbol_name = "l2_rd_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 214,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "L1 read stall cycles",
               .desc = "The number of cycles where L1 cache read requests sent by the L2 cache to an internal master are stalled.",
               .symbol_name = "l2_rd_msg_out_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 215,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "L1 write requests",
               .desc = "The number of L1 cache write responses sent by the L2 cache to an internal master.",
               .symbol_name = "l2_wr_msg_out",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 216,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Any lookup",
               .desc = "The number of L2 cache lookups performed.",
               .symbol_name = "l2_any_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 217,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Read lookup",
               .desc = "The number of L2 cache read lookups performed.",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 218,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Write lookup",
               .desc = "The number of L2 cache write lookups performed.",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 219,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "External snoop lookups",
               .desc = "The number of coherency snoop lookups performed that were triggered by an external master.",
               .symbol_name = "l2_ext_snoop_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 220,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Read transaction",
               .desc = "The number of external read transactions.",
               .symbol_name = "l2_ext_read",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "ReadNoSnoop transactions",
               .desc = "The number of external non-coherent read transactions.",
               .symbol_name = "l2_ext_read_nosnp",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "ReadUnique transactions",
               .desc = "The number of external coherent read unique transactions.",
               .symbol_name = "l2_ext_read_unique",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Read beat",
               .desc = "The number of external bus data read cycles.",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 224,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Read stall cycles",
               .desc = "The number of cycles where a read is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of read transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of read transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 227,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of read transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_ar_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 228,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "0-127 cycles",
               .desc = "The number of data beats returned 0-127 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_0_127",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 229,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "128-191 cycles",
               .desc = "The number of data beats returned 128-191 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_128_191",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 230,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "192-255 cycles",
               .desc = "The number of data beats returned 192-255 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_192_255",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 231,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "256-319 cycles",
               .desc = "The number of data beats returned 256-319 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_256_319",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 232,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "320-383 cycles",
               .desc = "The number of data beats returned 320-383 cycles after the read request.",
               .symbol_name = "l2_ext_rresp_320_383",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 233,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Write transaction",
               .desc = "The number of external write transactions.",
               .symbol_name = "l2_ext_write",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopFull transactions",
               .desc = "The number of external non-coherent full write transactions.",
               .symbol_name = "l2_ext_write_nosnp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 235,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "WriteNoSnoopPartial transactions",
               .desc = "The number of external non-coherent partial write transactions.",
               .symbol_name = "l2_ext_write_nosnp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 236,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "WriteSnoopFull transactions",
               .desc = "The number of external coherent full write transactions.",
               .symbol_name = "l2_ext_write_snp_full",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 237,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "WriteSnoopPartial transactions",
               .desc = "The number of external coherent partial write transactions.",
               .symbol_name = "l2_ext_write_snp_ptl",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 238,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Write beat",
               .desc = "The number of external bus data write cycles.",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 239,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Write stall cycles",
               .desc = "The number of cycles where a write is stalled waiting for the external bus.",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "0-25% outstanding",
               .desc = "The number of write transactions initiated when 0-25% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q1",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "25-50% outstanding",
               .desc = "The number of write transactions initiated when 25-50% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q2",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 242,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "50-75% outstanding",
               .desc = "The number of write transactions initiated when 50-75% of the maximum are in use.",
               .symbol_name = "l2_ext_aw_cnt_q3",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 243,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Snoop transactions",
               .desc = "The number of coherency snoops triggered by external masters.",
               .symbol_name = "l2_ext_snoop",
               .units = PAN_PERF_COUNTER_UNITS_TRANSACTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
            {
               .name = "Snoop stall cycles",
               .desc = "The number of cycles where a coherency snoop triggered by external master is stalled.",
               .symbol_name = "l2_ext_snoop_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 245,
               .category = &panfrost_perf_config_tbox.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 59,
         .counters = {
            {
               .name = "Fragment active",
               .desc = "The number of cycles where the shader core is processing a fragment workload.",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Read primitives",
               .desc = "The number of primitives read from the tile list by the fragment front-end.",
               .symbol_name = "frag_primitives_out",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Rasterized primitives",
               .desc = "The number of primitives being rasterized.",
               .symbol_name = "frag_prim_rast",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Fragment FPKB active",
               .desc = "The number of cycles where at least one quad is present in the pre-pipe quad queue.",
               .symbol_name = "frag_fpk_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 199,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Fragment warps",
               .desc = "The number of fragment warps created.",
               .symbol_name = "frag_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 201,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Partial rasterized quads",
               .desc = "The number of partially-rasterized fragment quads created.",
               .symbol_name = "frag_partial_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 202,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Rasterized quads",
               .desc = "The number of quads generated by the rasterization phase.",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Early ZS tested quads",
               .desc = "The number of quads that are undergoing early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 204,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Early ZS updated quads",
               .desc = "The number of quads undergoing early depth and stencil testing, that are capable of updating the framebuffer.",
               .symbol_name = "frag_quads_ezs_update",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 205,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Early ZS killed quads",
               .desc = "The number of quads killed by early depth and stencil testing.",
               .symbol_name = "frag_quads_ezs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Late ZS tested quads",
               .desc = "The number of quads undergoing late depth and stencil testing.",
               .symbol_name = "frag_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Late ZS killed quads",
               .desc = "The number of quads killed by late depth and stencil testing.",
               .symbol_name = "frag_lzs_kill",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "All register warps",
               .desc = "The number of warps that require more than 32 registers.",
               .symbol_name = "warp_reg_size_64",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 209,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Tiles",
               .desc = "The number of tiles processed by the shader core.",
               .symbol_name = "frag_ptiles",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 210,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Constant tiles killed",
               .desc = "The number of tiles killed by transaction elimination.",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 211,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "FPK occluder quads",
               .desc = "The number of quads that are valid occluders for hidden surface removal.",
               .symbol_name = "quad_fpk_killer",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 212,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Full quad warps",
               .desc = "The number of warps that are fully populated with quads.",
               .symbol_name = "full_quad_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 213,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Non-fragment active",
               .desc = "The number of cycles where the shader core is processing some non-fragment workload.",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Non-fragment tasks",
               .desc = "The number of non-fragment tasks issued to the shader core.",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Non-fragment warps",
               .desc = "The number of non-fragment warps created.",
               .symbol_name = "compute_warps",
               .units = PAN_PERF_COUNTER_UNITS_WARPS,
               .offset = 216,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Non-fragment starvation cycles",
               .desc = "The number of cycles where the shader core is processing a non-fragment workload and there are no new threads available for execution.",
               .symbol_name = "compute_starving",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 217,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Execution core active",
               .desc = "The number of cycles where the shader core is processing at least one warp.",
               .symbol_name = "exec_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "FMA instructions",
               .desc = "The number of instructions issued to the FMA pipe.",
               .symbol_name = "exec_instr_fma",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "CVT instructions",
               .desc = "The number of instructions issued to the CVT pipe.",
               .symbol_name = "exec_instr_cvt",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 220,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "SFU instructions",
               .desc = "The number of instructions issued to the SFU pipe.",
               .symbol_name = "exec_instr_sfu",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Message instructions",
               .desc = "The number of instructions issued to the MSG pipe.",
               .symbol_name = "exec_instr_msg",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 222,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Diverged instructions",
               .desc = "The number of instructions executed per warp, that have control flow divergence.",
               .symbol_name = "exec_instr_diverged",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Instruction cache misses",
               .desc = "The number of instruction cache misses.",
               .symbol_name = "exec_icache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 224,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Execution engine starvation cycles",
               .desc = "The number of cycles where the processing unit is starved of work.",
               .symbol_name = "exec_starve_arith",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 225,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Blend shader calls",
               .desc = "The number of blend shader invocations executed.",
               .symbol_name = "call_blend_shader",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 226,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Input beats",
               .desc = "The number of texture request message data beats.",
               .symbol_name = "tex_msgi_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 227,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Descriptor stall cycles",
               .desc = "The number of cycles where a quad is stalled on texture descriptor fetch.",
               .symbol_name = "tex_dfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 228,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Fetch queue stall cycles",
               .desc = "The number of cycles where a quad is stalled on entering texture fetch because the fetch queue is full.",
               .symbol_name = "tex_tfch_clk_stalled",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 229,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Filtering unit stall cycles",
               .desc = "The number of cycles where the filtering unit is idle and there is at least one quad present in the texture data fetch queue.",
               .symbol_name = "tex_tfch_starved_pending_data_fetch",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 230,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Texturing active",
               .desc = "The number of texture filtering issue cycles.",
               .symbol_name = "tex_filt_num_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 231,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "4x bilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement nearest or bilinear filtering.",
               .symbol_name = "tex_filt_num_fxr_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 232,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "2x trilinear filtering active",
               .desc = "The number of cycles where the filtering unit uses the 4x path to implement trilinear filtering.",
               .symbol_name = "tex_filt_num_fst_operations",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 233,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Texture requests",
               .desc = "The number of quad-width texture operations processed by the texture unit.",
               .symbol_name = "tex_msgo_num_msg",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 234,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Output beats",
               .desc = "The number of texture response message data beats.",
               .symbol_name = "tex_msgo_num_flits",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 235,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Full read cycles",
               .desc = "The number of full-width load/store cache reads.",
               .symbol_name = "ls_mem_read_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 236,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Partial read cycles",
               .desc = "The number of partial-width load/store cache reads.",
               .symbol_name = "ls_mem_read_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 237,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Full write cycles",
               .desc = "The number of full-width load/store cache writes.",
               .symbol_name = "ls_mem_write_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 238,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Partial write cycles",
               .desc = "The number of partial-width load/store cache writes.",
               .symbol_name = "ls_mem_write_short",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 239,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Atomic access cycles",
               .desc = "The number of load/store atomic accesses.",
               .symbol_name = "ls_mem_atomic",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 240,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Interpolation requests",
               .desc = "The number of warp-width interpolation operations processed by the varying unit.",
               .symbol_name = "vary_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 241,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "32-bit interpolation active",
               .desc = "The number of 32-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_32",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 242,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "16-bit interpolation active",
               .desc = "The number of 16-bit interpolation cycles processed by the varying unit.",
               .symbol_name = "vary_slot_16",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 243,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Attribute requests",
               .desc = "The number of instructions executed by the attribute unit.",
               .symbol_name = "attr_instr",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 244,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Any active",
               .desc = "The number of cycles where the shader core is processing either a non-fragment workload or a fragment workload.",
               .symbol_name = "shader_core_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 245,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Fragment L2 read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end.",
               .symbol_name = "beats_rd_ftc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 246,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Fragment external read beats",
               .desc = "The number of read beats received by the fixed-function fragment front-end that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_ftc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 247,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Load/store L2 read beats",
               .desc = "The number of read beats received by the load/store unit.",
               .symbol_name = "beats_rd_lsc",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 248,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Load/store external read beats",
               .desc = "The number of read beats received by the load/store unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_lsc_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 249,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Texture L2 read beats",
               .desc = "The number of read beats received by the texture unit.",
               .symbol_name = "beats_rd_tex",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 250,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Texture external read beats",
               .desc = "The number of read beats received by the texture unit that required an external memory access due to an L2 cache miss.",
               .symbol_name = "beats_rd_tex_ext",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 251,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Other L2 read beats",
               .desc = "The number of read beats received by a unit that is not specifically identified.",
               .symbol_name = "beats_rd_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 252,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Load/store other write beats",
               .desc = "The number of write beats by the load/store unit that are due to any reason other than writeback.",
               .symbol_name = "beats_wr_lsc_other",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 253,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Tile buffer write beats",
               .desc = "The number of write beats sent by the tile buffer writeback unit.",
               .symbol_name = "beats_wr_tib",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 254,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
            {
               .name = "Load/store writeback write beats",
               .desc = "The number of write beats by the load/store unit that are due to writeback.",
               .symbol_name = "beats_wr_lsc_wb",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 255,
               .category = &panfrost_perf_config_tbox.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 24,
         .counters = {
            {
               .name = "Tiler active",
               .desc = "The number of cycles where the tiler has a workload queued for processing.",
               .symbol_name = "tiler_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 4,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Triangle primitives",
               .desc = "The number of input triangle primitives.",
               .symbol_name = "triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 6,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Line primitives",
               .desc = "The number of input line primitives.",
               .symbol_name = "lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 7,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Point primitives",
               .desc = "The number of input point primitives.",
               .symbol_name = "points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 8,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Front-facing primitives",
               .desc = "The number of front-facing triangles that are visible after culling.",
               .symbol_name = "front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 9,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Back-facing primitives",
               .desc = "The number of back-facing triangles that are visible after culling.",
               .symbol_name = "back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 10,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Visible primitives",
               .desc = "The number of primitives that are visible after culling.",
               .symbol_name = "prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 11,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Facing and XY plane test culled primitives",
               .desc = "The number of primitives that are culled by facing or frustum XY plane tests.",
               .symbol_name = "prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 12,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Z plane test culled primitives",
               .desc = "The number of primitives that are culled by frustum Z plane tests.",
               .symbol_name = "prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 13,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Sample test culled primitives",
               .desc = "The number of primitives culled by the sample coverage test.",
               .symbol_name = "prim_sat_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 14,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Read beats",
               .desc = "The number of internal bus data read cycles made by the tiler.",
               .symbol_name = "bus_read",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 17,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Write beats",
               .desc = "The number of internal bus data write cycles made by the tiler.",
               .symbol_name = "bus_write",
               .units = PAN_PERF_COUNTER_UNITS_BEATS,
               .offset = 19,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Position shading requests",
               .desc = "The number of position shading requests in the IDVS flow.",
               .symbol_name = "idvs_pos_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 21,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Position shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading request.",
               .symbol_name = "idvs_pos_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 23,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Position FIFO full cycles",
               .desc = "The number of cycles where the tiler has a stalled position shading buffer.",
               .symbol_name = "idvs_pos_fifo_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 24,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Position cache hits",
               .desc = "The number of position lookups that result in a hit in the vertex cache.",
               .symbol_name = "vcache_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 26,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Position cache misses",
               .desc = "The number of position lookups that miss in the vertex cache.",
               .symbol_name = "vcache_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 27,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Primitive assembly busy stall cycles",
               .desc = "The number of cycles where the tiler is stalled waiting for primitive assembly.",
               .symbol_name = "vfetch_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 31,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Varying cache hits",
               .desc = "The number of varying lookups that result in a hit in the vertex cache.",
               .symbol_name = "idvs_vbu_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 34,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Varying cache misses",
               .desc = "The number of varying lookups that miss in the vertex cache.",
               .symbol_name = "idvs_vbu_miss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 35,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Varying shading requests",
               .desc = "The number of varying shading requests in the IDVS flow.",
               .symbol_name = "idvs_var_shad_req",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 37,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Varying shading stall cycles",
               .desc = "The number of cycles where the tiler has a stalled varying shading request.",
               .symbol_name = "idvs_var_shad_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 38,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Write buffer transaction stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because it has no available write IDs.",
               .symbol_name = "wrbuf_no_axi_id_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 54,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
            {
               .name = "Write buffer write stall cycles",
               .desc = "The number of cycles where the tiler write buffer can not send data because the bus is not ready.",
               .symbol_name = "wrbuf_axi_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 55,
               .category = &panfrost_perf_config_tbox.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_tbox

static void UNUSED
static_asserts_t72x(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(31 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(8 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_t72x = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 11,
         .counters = {
            {
               .name = "GPU cycles",
               .desc = "Number of cycles GPU active",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 4,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "IRQ cycles",
               .desc = "Number of cycles GPU interrupt pending",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 5,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS0 cycles",
               .desc = "Number of cycles JS0 (fragment) active",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 8,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS1 cycles",
               .desc = "Number of cycles JS1 (vertex/tiler/compute) active",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 11,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS2 cycles",
               .desc = "Number of cycles JS2 (vertex/compute) active",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 14,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS0 jobs",
               .desc = "Number of Jobs (fragment) completed in JS0",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 6,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS1 jobs",
               .desc = "Number of Jobs (vertex/tiler/compute) completed in JS1",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 9,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS2 jobs",
               .desc = "Number of Jobs (vertex/compute) completed in JS2",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 12,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of Pixels completed in JS0",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 7,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS1 tasks",
               .desc = "Number of Tasks completed in JS1",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 10,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
            {
               .name = "JS2 tasks",
               .desc = "Number of Tasks completed in JS2",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 13,
               .category = &panfrost_perf_config_t72x.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 11,
         .counters = {
            {
               .name = "Tiler cycles",
               .desc = "Number of cycles Tiler active",
               .symbol_name = "ti_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 86,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Polygons",
               .desc = "Number of polygons processed",
               .symbol_name = "ti_polygons",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Quads",
               .desc = "Number of quads processed",
               .symbol_name = "ti_quads",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 69,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Triangles",
               .desc = "Number of triangles processed",
               .symbol_name = "ti_triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 68,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Lines",
               .desc = "Number of lines processed",
               .symbol_name = "ti_lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Points",
               .desc = "Number of points processed",
               .symbol_name = "ti_points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Front facing prims",
               .desc = "Number of front facing primitives",
               .symbol_name = "ti_front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Back facing prims",
               .desc = "Number of back facing primitives",
               .symbol_name = "ti_back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Visible prims",
               .desc = "Number of visible primitives",
               .symbol_name = "ti_prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Culled prims",
               .desc = "Number of culled primitives",
               .symbol_name = "ti_prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
            {
               .name = "Clipped prims",
               .desc = "Number of clipped primitives",
               .symbol_name = "ti_prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_t72x.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 31,
         .counters = {
            {
               .name = "Tripipe cycles",
               .desc = "Number of cycles tripipe was active",
               .symbol_name = "tripipe_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 212,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles",
               .desc = "Number of cycles fragment processing was active",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Compute cycles",
               .desc = "Number of cycles vertex\\compute processing was active",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 209,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles waiting for tile",
               .desc = "Number of cycles spent waiting for a physical tile buffer",
               .symbol_name = "frag_cycles_no_tile",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 206,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Fragment threads",
               .desc = "Number of fragment threads started",
               .symbol_name = "frag_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 199,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Dummy fragment threads",
               .desc = "Number of dummy fragment threads started",
               .symbol_name = "frag_dummy_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 200,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Fragment threads doing late ZS",
               .desc = "Number of threads doing late ZS test",
               .symbol_name = "frag_threads_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 204,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Fragment threads killed late ZS",
               .desc = "Number of threads killed by late ZS test",
               .symbol_name = "frag_threads_lzs_killed",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 205,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Compute tasks",
               .desc = "Number of compute tasks",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 210,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Compute threads",
               .desc = "Number of compute threads started",
               .symbol_name = "compute_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 211,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Primitives loaded",
               .desc = "Number of primitives loaded from tiler",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Primitives dropped",
               .desc = "Number of primitives dropped because out of tile",
               .symbol_name = "frag_primitives_dropped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Quads rasterized",
               .desc = "Number of quads rasterized",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 201,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Quads doing early ZS",
               .desc = "Number of quads doing early ZS test",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 202,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Quads killed early Z",
               .desc = "Number of quads killed by early ZS test",
               .symbol_name = "frag_quads_ezs_killed",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 203,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of pixels rendered",
               .symbol_name = "frag_num_tiles",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 207,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Tile writes killed by TE",
               .desc = "Number of tile writes skipped by transaction elimination",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 208,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "A instructions",
               .desc = "Number of batched instructions executed by the A-pipe",
               .symbol_name = "arith_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 213,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "LS instructions",
               .desc = "Number of instructions completed by the LS-pipe",
               .symbol_name = "ls_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 215,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "LS instruction issues",
               .desc = "Number of instructions issued to the LS-pipe, including restarts",
               .symbol_name = "ls_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 216,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "T instructions",
               .desc = "Number of instructions completed by the T-pipe",
               .symbol_name = "tex_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "T instruction issues",
               .desc = "Number of threads through loop 2 address calculation",
               .symbol_name = "tex_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 221,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Read hits",
               .desc = "Number of read hits in the Load/Store cache",
               .symbol_name = "lsc_read_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 222,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Read misses",
               .desc = "Number of read misses in the Load/Store cache",
               .symbol_name = "lsc_read_misses",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 223,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Write hits",
               .desc = "Number of write hits in the Load/Store cache",
               .symbol_name = "lsc_write_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 224,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Write misses",
               .desc = "Number of write misses in the Load/Store cache",
               .symbol_name = "lsc_write_misses",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 225,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Atomic hits",
               .desc = "Number of atomic hits in the Load/Store cache",
               .symbol_name = "lsc_atomic_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 226,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Atomic misses",
               .desc = "Number of atomic misses in the Load/Store cache",
               .symbol_name = "lsc_atomic_misses",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 227,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "Number of line fetches in the Load/Store cache",
               .symbol_name = "lsc_line_fetches",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 228,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Dirty line evictions",
               .desc = "Number of dirty line evictions in the Load/Store cache",
               .symbol_name = "lsc_dirty_line",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 229,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
            {
               .name = "Snoops in to LSC",
               .desc = "Number of coherent memory snoops in to the Load/Store cache",
               .symbol_name = "lsc_snoops",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 230,
               .category = &panfrost_perf_config_t72x.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "L2 Cache",
         .n_counters = 8,
         .counters = {
            {
               .name = "Read snoops",
               .desc = "Number of read transaction snoops",
               .symbol_name = "l2_read_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 134,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
            {
               .name = "L2 read hits",
               .desc = "Number of reads hitting in the L2 cache",
               .symbol_name = "l2_read_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 135,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
            {
               .name = "Write snoops",
               .desc = "Number of write transaction snoops",
               .symbol_name = "l2_write_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 136,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
            {
               .name = "L2 write hits",
               .desc = "Number of writes hitting in the L2 cache",
               .symbol_name = "l2_write_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 137,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
            {
               .name = "External read bytes",
               .desc = "Number of external bus read bytes",
               .symbol_name = "l2_ext_read_beat",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 133,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (AR)",
               .desc = "Number of cycles a valid read address (AR) is stalled by the external interconnect",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 140,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
            {
               .name = "External write bytes",
               .desc = "Number of external bus write bytes",
               .symbol_name = "l2_ext_write_beat",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 132,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (W)",
               .desc = "Number of cycles a valid write data (W channel) is stalled by the external interconnect",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 141,
               .category = &panfrost_perf_config_t72x.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_t72x

static void UNUSED
static_asserts_t76x(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(19 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(33 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(13 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_t76x = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 11,
         .counters = {
            {
               .name = "GPU cycles",
               .desc = "Number of cycles GPU active",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "IRQ cycles",
               .desc = "Number of cycles GPU interrupt pending",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS0 cycles",
               .desc = "Number of cycles JS0 (fragment) active",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS1 cycles",
               .desc = "Number of cycles JS1 (vertex/tiler/compute) active",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS2 cycles",
               .desc = "Number of cycles JS2 (vertex/compute) active",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS0 jobs",
               .desc = "Number of Jobs (fragment) completed in JS0",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS1 jobs",
               .desc = "Number of Jobs (vertex/tiler/compute) completed in JS1",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS2 jobs",
               .desc = "Number of Jobs (vertex/compute) completed in JS2",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of Pixels completed in JS0",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 9,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS1 tasks",
               .desc = "Number of Tasks completed in JS1",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
            {
               .name = "JS2 tasks",
               .desc = "Number of Tasks completed in JS2",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_t76x.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 19,
         .counters = {
            {
               .name = "Tiler cycles",
               .desc = "Number of cycles Tiler active",
               .symbol_name = "ti_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 109,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Polygons",
               .desc = "Number of polygons processed",
               .symbol_name = "ti_polygons",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Quads",
               .desc = "Number of quads processed",
               .symbol_name = "ti_quads",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 69,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Triangles",
               .desc = "Number of triangles processed",
               .symbol_name = "ti_triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 68,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Lines",
               .desc = "Number of lines processed",
               .symbol_name = "ti_lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Points",
               .desc = "Number of points processed",
               .symbol_name = "ti_points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Front facing prims",
               .desc = "Number of front facing primitives",
               .symbol_name = "ti_front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Back facing prims",
               .desc = "Number of back facing primitives",
               .symbol_name = "ti_back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Visible prims",
               .desc = "Number of visible primitives",
               .symbol_name = "ti_prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Culled prims",
               .desc = "Number of culled primitives",
               .symbol_name = "ti_prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "Clipped prims",
               .desc = "Number of clipped primitives",
               .symbol_name = "ti_prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 79,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L0 prims",
               .desc = "Number of primitives in hierarchy level 0",
               .symbol_name = "ti_level0",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 80,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L1 prims",
               .desc = "Number of primitives in hierarchy level 1",
               .symbol_name = "ti_level1",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 81,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L2 prims",
               .desc = "Number of primitives in hierarchy level 2",
               .symbol_name = "ti_level2",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 82,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L3 prims",
               .desc = "Number of primitives in hierarchy level 3",
               .symbol_name = "ti_level3",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 83,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L4 prims",
               .desc = "Number of primitives in hierarchy level 4",
               .symbol_name = "ti_level4",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 84,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L5 prims",
               .desc = "Number of primitives in hierarchy level 5",
               .symbol_name = "ti_level5",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 85,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L6 prims",
               .desc = "Number of primitives in hierarchy level 6",
               .symbol_name = "ti_level6",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 86,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
            {
               .name = "L7 prims",
               .desc = "Number of primitives in hierarchy level 7",
               .symbol_name = "ti_level7",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 87,
               .category = &panfrost_perf_config_t76x.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 33,
         .counters = {
            {
               .name = "Tripipe cycles",
               .desc = "Number of cycles tripipe was active",
               .symbol_name = "tripipe_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles",
               .desc = "Number of cycles fragment processing was active",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Compute cycles",
               .desc = "Number of cycles vertex\\compute processing was active",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles waiting for tile",
               .desc = "Number of cycles spent waiting for a physical tile buffer",
               .symbol_name = "frag_cycles_no_tile",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles pre-pipe buffer not empty",
               .desc = "Number of cycles the pre-pipe queue contains quads",
               .symbol_name = "frag_cycles_fpkq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 200,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Fragment threads",
               .desc = "Number of fragment threads started",
               .symbol_name = "frag_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 204,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Dummy fragment threads",
               .desc = "Number of dummy fragment threads started",
               .symbol_name = "frag_dummy_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 205,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Fragment threads doing late ZS",
               .desc = "Number of threads doing late ZS test",
               .symbol_name = "frag_threads_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 209,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Fragment threads killed late ZS",
               .desc = "Number of threads killed by late ZS test",
               .symbol_name = "frag_threads_lzs_killed",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 210,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Compute tasks",
               .desc = "Number of compute tasks",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Compute threads",
               .desc = "Number of compute threads started",
               .symbol_name = "compute_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 216,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Primitives loaded",
               .desc = "Number of primitives loaded from tiler",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Primitives dropped",
               .desc = "Number of primitives dropped because out of tile",
               .symbol_name = "frag_primitives_dropped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Quads rasterized",
               .desc = "Number of quads rasterized",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Quads doing early ZS",
               .desc = "Number of quads doing early ZS test",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Quads killed early Z",
               .desc = "Number of quads killed by early ZS test",
               .symbol_name = "frag_quads_ezs_killed",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of pixels rendered",
               .symbol_name = "frag_num_tiles",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 212,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Tile writes killed by TE",
               .desc = "Number of tile writes skipped by transaction elimination",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 213,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "A instructions",
               .desc = "Number of instructions completed by the the A-pipe (normalized per pipeline)",
               .symbol_name = "arith_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "LS instructions",
               .desc = "Number of instructions completed by the LS-pipe",
               .symbol_name = "ls_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "LS instruction issues",
               .desc = "Number of instructions issued to the LS-pipe, including restarts",
               .symbol_name = "ls_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "T instructions",
               .desc = "Number of instructions completed by the T-pipe",
               .symbol_name = "tex_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 230,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "T instruction issues",
               .desc = "Number of threads through loop 2 address calculation",
               .symbol_name = "tex_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Cache misses",
               .desc = "Number of instructions in the T-pipe, recirculated due to cache miss",
               .symbol_name = "tex_recirc_fmiss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 235,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Read operations",
               .desc = "Number of read operations in the Load/Store cache",
               .symbol_name = "lsc_read_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 241,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Read hits",
               .desc = "Number of read hits in the Load/Store cache",
               .symbol_name = "lsc_read_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 240,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Write operations",
               .desc = "Number of write operations in the Load/Store cache",
               .symbol_name = "lsc_write_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 243,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Write hits",
               .desc = "Number of write hits in the Load/Store cache",
               .symbol_name = "lsc_write_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 242,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Atomic operations",
               .desc = "Number of atomic operations in the Load/Store cache",
               .symbol_name = "lsc_atomic_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 245,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Atomic hits",
               .desc = "Number of atomic hits in the Load/Store cache",
               .symbol_name = "lsc_atomic_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 244,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "Number of line fetches in the Load/Store cache",
               .symbol_name = "lsc_line_fetches",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 246,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Dirty line evictions",
               .desc = "Number of dirty line evictions in the Load/Store cache",
               .symbol_name = "lsc_dirty_line",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 247,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
            {
               .name = "Snoops in to LSC",
               .desc = "Number of coherent memory snoops in to the Load/Store cache",
               .symbol_name = "lsc_snoops",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 248,
               .category = &panfrost_perf_config_t76x.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "L2 Cache",
         .n_counters = 13,
         .counters = {
            {
               .name = "L2 read lookups",
               .desc = "Number of reads into the L2 cache",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 161,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "Read snoops",
               .desc = "Number of read transaction snoops",
               .symbol_name = "l2_read_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 164,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "L2 read hits",
               .desc = "Number of reads hitting in the L2 cache",
               .symbol_name = "l2_read_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 165,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "Write snoops",
               .desc = "Number of write transaction snoops",
               .symbol_name = "l2_write_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 170,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "L2 write hits",
               .desc = "Number of writes hitting in the L2 cache",
               .symbol_name = "l2_write_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 171,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "L2 write lookups",
               .desc = "Number of writes into the L2 cache",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 167,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "External read bytes",
               .desc = "Number of external bus read bytes",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 159,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (AR)",
               .desc = "Number of cycles a valid read address (AR) is stalled by the external interconnect",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 182,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "External bus response buffer full",
               .desc = "Number of cycles a valid request is blocked by a full response buffer",
               .symbol_name = "l2_ext_r_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 188,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "External bus read data buffer full",
               .desc = "Number of cycles a valid request is blocked by a full read data buffer",
               .symbol_name = "l2_ext_rd_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 184,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "External write bytes",
               .desc = "Number of external bus write bytes",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 158,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (W)",
               .desc = "Number of cycles a valid write data (W channel) is stalled by the external interconnect",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 186,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
            {
               .name = "External bus write buffer full",
               .desc = "Number of cycles a valid request is blocked by a full write buffer",
               .symbol_name = "l2_ext_w_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 187,
               .category = &panfrost_perf_config_t76x.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_t76x

static void UNUSED
static_asserts_t82x(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(33 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(13 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_t82x = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 11,
         .counters = {
            {
               .name = "GPU cycles",
               .desc = "Number of cycles GPU active",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "IRQ cycles",
               .desc = "Number of cycles GPU interrupt pending",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS0 cycles",
               .desc = "Number of cycles JS0 (fragment) active",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS1 cycles",
               .desc = "Number of cycles JS1 (vertex/tiler/compute) active",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS2 cycles",
               .desc = "Number of cycles JS2 (vertex/compute) active",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS0 jobs",
               .desc = "Number of Jobs (fragment) completed in JS0",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS1 jobs",
               .desc = "Number of Jobs (vertex/tiler/compute) completed in JS1",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS2 jobs",
               .desc = "Number of Jobs (vertex/compute) completed in JS2",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of Pixels completed in JS0",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 9,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS1 tasks",
               .desc = "Number of Tasks completed in JS1",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
            {
               .name = "JS2 tasks",
               .desc = "Number of Tasks completed in JS2",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_t82x.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 11,
         .counters = {
            {
               .name = "Tiler cycles",
               .desc = "Number of cycles Tiler active",
               .symbol_name = "ti_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 86,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Polygons",
               .desc = "Number of polygons processed",
               .symbol_name = "ti_polygons",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Quads",
               .desc = "Number of quads processed",
               .symbol_name = "ti_quads",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 69,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Triangles",
               .desc = "Number of triangles processed",
               .symbol_name = "ti_triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 68,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Lines",
               .desc = "Number of lines processed",
               .symbol_name = "ti_lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Points",
               .desc = "Number of points processed",
               .symbol_name = "ti_points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Front facing prims",
               .desc = "Number of front facing primitives",
               .symbol_name = "ti_front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Back facing prims",
               .desc = "Number of back facing primitives",
               .symbol_name = "ti_back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Visible prims",
               .desc = "Number of visible primitives",
               .symbol_name = "ti_prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Culled prims",
               .desc = "Number of culled primitives",
               .symbol_name = "ti_prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
            {
               .name = "Clipped prims",
               .desc = "Number of clipped primitives",
               .symbol_name = "ti_prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_t82x.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 33,
         .counters = {
            {
               .name = "Tripipe cycles",
               .desc = "Number of cycles tripipe was active",
               .symbol_name = "tripipe_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles",
               .desc = "Number of cycles fragment processing was active",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Compute cycles",
               .desc = "Number of cycles vertex\\compute processing was active",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles waiting for tile",
               .desc = "Number of cycles spent waiting for a physical tile buffer",
               .symbol_name = "frag_cycles_no_tile",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles pre-pipe buffer not empty",
               .desc = "Number of cycles the pre-pipe queue contains quads",
               .symbol_name = "frag_cycles_fpkq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 200,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Fragment threads",
               .desc = "Number of fragment threads started",
               .symbol_name = "frag_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 204,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Dummy fragment threads",
               .desc = "Number of dummy fragment threads started",
               .symbol_name = "frag_dummy_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 205,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Fragment threads doing late ZS",
               .desc = "Number of threads doing late ZS test",
               .symbol_name = "frag_threads_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 209,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Fragment threads killed late ZS",
               .desc = "Number of threads killed by late ZS test",
               .symbol_name = "frag_threads_lzs_killed",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 210,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Compute tasks",
               .desc = "Number of compute tasks",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Compute threads",
               .desc = "Number of compute threads started",
               .symbol_name = "compute_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 216,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Primitives loaded",
               .desc = "Number of primitives loaded from tiler",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Primitives dropped",
               .desc = "Number of primitives dropped because out of tile",
               .symbol_name = "frag_primitives_dropped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Quads rasterized",
               .desc = "Number of quads rasterized",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Quads doing early ZS",
               .desc = "Number of quads doing early ZS test",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Quads killed early Z",
               .desc = "Number of quads killed by early ZS test",
               .symbol_name = "frag_quads_ezs_killed",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of pixels rendered",
               .symbol_name = "frag_num_tiles",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 212,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Tile writes killed by TE",
               .desc = "Number of tile writes skipped by transaction elimination",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 213,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "A instructions",
               .desc = "Number of batched instructions executed by the A-pipe (normalized per pipe)",
               .symbol_name = "arith_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "LS instructions",
               .desc = "Number of instructions completed by the LS-pipe",
               .symbol_name = "ls_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "LS instruction issues",
               .desc = "Number of instructions issued to the LS-pipe, including restarts",
               .symbol_name = "ls_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "T instructions",
               .desc = "Number of instructions completed by the T-pipe",
               .symbol_name = "tex_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 230,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "T instruction issues",
               .desc = "Number of threads through loop 2 address calculation",
               .symbol_name = "tex_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Cache misses",
               .desc = "Number of instructions in the T-pipe, recirculated due to cache miss",
               .symbol_name = "tex_recirc_fmiss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 235,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Read operations",
               .desc = "Number of read operations in the Load/Store cache",
               .symbol_name = "lsc_read_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 241,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Read hits",
               .desc = "Number of read hits in the Load/Store cache",
               .symbol_name = "lsc_read_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 240,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Write operations",
               .desc = "Number of write operations in the Load/Store cache",
               .symbol_name = "lsc_write_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 243,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Write hits",
               .desc = "Number of write hits in the Load/Store cache",
               .symbol_name = "lsc_write_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 242,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Atomic operations",
               .desc = "Number of atomic operations in the Load/Store cache",
               .symbol_name = "lsc_atomic_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 245,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Atomic hits",
               .desc = "Number of atomic hits in the Load/Store cache",
               .symbol_name = "lsc_atomic_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 244,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "Number of line fetches in the Load/Store cache",
               .symbol_name = "lsc_line_fetches",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 246,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Dirty line evictions",
               .desc = "Number of dirty line evictions in the Load/Store cache",
               .symbol_name = "lsc_dirty_line",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 247,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
            {
               .name = "Snoops in to LSC",
               .desc = "Number of coherent memory snoops in to the Load/Store cache",
               .symbol_name = "lsc_snoops",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 248,
               .category = &panfrost_perf_config_t82x.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "L2 Cache",
         .n_counters = 13,
         .counters = {
            {
               .name = "L2 read lookups",
               .desc = "Number of reads into the L2 cache",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 161,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "Read snoops",
               .desc = "Number of read transaction snoops",
               .symbol_name = "l2_read_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 164,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "L2 read hits",
               .desc = "Number of reads hitting in the L2 cache",
               .symbol_name = "l2_read_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 165,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "Write snoops",
               .desc = "Number of write transaction snoops",
               .symbol_name = "l2_write_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 170,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "L2 write hits",
               .desc = "Number of writes hitting in the L2 cache",
               .symbol_name = "l2_write_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 171,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "L2 write lookups",
               .desc = "Number of writes into the L2 cache",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 167,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "External read bytes",
               .desc = "Number of external bus read bytes",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 159,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (AR)",
               .desc = "Number of cycles a valid read address (AR) is stalled by the external interconnect",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 182,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "External bus response buffer full",
               .desc = "Number of cycles a valid request is blocked by a full response buffer",
               .symbol_name = "l2_ext_r_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 188,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "External bus read data buffer full",
               .desc = "Number of cycles a valid request is blocked by a full read data buffer",
               .symbol_name = "l2_ext_rd_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 184,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "External write bytes",
               .desc = "Number of external bus write bytes",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 158,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (W)",
               .desc = "Number of cycles a valid write data (W channel) is stalled by the external interconnect",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 186,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
            {
               .name = "External bus write buffer full",
               .desc = "Number of cycles a valid request is blocked by a full write buffer",
               .symbol_name = "l2_ext_w_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 187,
               .category = &panfrost_perf_config_t82x.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_t82x

static void UNUSED
static_asserts_t83x(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(33 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(13 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_t83x = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 11,
         .counters = {
            {
               .name = "GPU cycles",
               .desc = "Number of cycles GPU active",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "IRQ cycles",
               .desc = "Number of cycles GPU interrupt pending",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS0 cycles",
               .desc = "Number of cycles JS0 (fragment) active",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS1 cycles",
               .desc = "Number of cycles JS1 (vertex/tiler/compute) active",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS2 cycles",
               .desc = "Number of cycles JS2 (vertex/compute) active",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS0 jobs",
               .desc = "Number of Jobs (fragment) completed in JS0",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS1 jobs",
               .desc = "Number of Jobs (vertex/tiler/compute) completed in JS1",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS2 jobs",
               .desc = "Number of Jobs (vertex/compute) completed in JS2",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of Pixels completed in JS0",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 9,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS1 tasks",
               .desc = "Number of Tasks completed in JS1",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
            {
               .name = "JS2 tasks",
               .desc = "Number of Tasks completed in JS2",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_t83x.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 11,
         .counters = {
            {
               .name = "Tiler cycles",
               .desc = "Number of cycles Tiler active",
               .symbol_name = "ti_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 86,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Polygons",
               .desc = "Number of polygons processed",
               .symbol_name = "ti_polygons",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Quads",
               .desc = "Number of quads processed",
               .symbol_name = "ti_quads",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 69,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Triangles",
               .desc = "Number of triangles processed",
               .symbol_name = "ti_triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 68,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Lines",
               .desc = "Number of lines processed",
               .symbol_name = "ti_lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Points",
               .desc = "Number of points processed",
               .symbol_name = "ti_points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Front facing prims",
               .desc = "Number of front facing primitives",
               .symbol_name = "ti_front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 73,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Back facing prims",
               .desc = "Number of back facing primitives",
               .symbol_name = "ti_back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 74,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Visible prims",
               .desc = "Number of visible primitives",
               .symbol_name = "ti_prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Culled prims",
               .desc = "Number of culled primitives",
               .symbol_name = "ti_prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
            {
               .name = "Clipped prims",
               .desc = "Number of clipped primitives",
               .symbol_name = "ti_prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_t83x.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 33,
         .counters = {
            {
               .name = "Tripipe cycles",
               .desc = "Number of cycles tripipe was active",
               .symbol_name = "tripipe_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles",
               .desc = "Number of cycles fragment processing was active",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Compute cycles",
               .desc = "Number of cycles vertex\\compute processing was active",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles waiting for tile",
               .desc = "Number of cycles spent waiting for a physical tile buffer",
               .symbol_name = "frag_cycles_no_tile",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles pre-pipe buffer not empty",
               .desc = "Number of cycles the pre-pipe queue contains quads",
               .symbol_name = "frag_cycles_fpkq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 200,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Fragment threads",
               .desc = "Number of fragment threads started",
               .symbol_name = "frag_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 204,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Dummy fragment threads",
               .desc = "Number of dummy fragment threads started",
               .symbol_name = "frag_dummy_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 205,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Fragment threads doing late ZS",
               .desc = "Number of threads doing late ZS test",
               .symbol_name = "frag_threads_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 209,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Fragment threads killed late ZS",
               .desc = "Number of threads killed by late ZS test",
               .symbol_name = "frag_threads_lzs_killed",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 210,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Compute tasks",
               .desc = "Number of compute tasks",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Compute threads",
               .desc = "Number of compute threads started",
               .symbol_name = "compute_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 216,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Primitives loaded",
               .desc = "Number of primitives loaded from tiler",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Primitives dropped",
               .desc = "Number of primitives dropped because out of tile",
               .symbol_name = "frag_primitives_dropped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Quads rasterized",
               .desc = "Number of quads rasterized",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Quads doing early ZS",
               .desc = "Number of quads doing early ZS test",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Quads killed early Z",
               .desc = "Number of quads killed by early ZS test",
               .symbol_name = "frag_quads_ezs_killed",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of pixels rendered",
               .symbol_name = "frag_num_tiles",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 212,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Tile writes killed by TE",
               .desc = "Number of tile writes skipped by transaction elimination",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 213,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "A instructions",
               .desc = "Number of batched instructions executed by the A-pipe (normalized per pipe)",
               .symbol_name = "arith_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "LS instructions",
               .desc = "Number of instructions completed by the LS-pipe",
               .symbol_name = "ls_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "LS instruction issues",
               .desc = "Number of instructions issued to the LS-pipe, including restarts",
               .symbol_name = "ls_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "T instructions",
               .desc = "Number of instructions completed by the T-pipe",
               .symbol_name = "tex_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 230,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "T instruction issues",
               .desc = "Number of threads through loop 2 address calculation",
               .symbol_name = "tex_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Cache misses",
               .desc = "Number of instructions in the T-pipe, recirculated due to cache miss",
               .symbol_name = "tex_recirc_fmiss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 235,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Read operations",
               .desc = "Number of read operations in the Load/Store cache",
               .symbol_name = "lsc_read_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 241,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Read hits",
               .desc = "Number of read hits in the Load/Store cache",
               .symbol_name = "lsc_read_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 240,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Write operations",
               .desc = "Number of write operations in the Load/Store cache",
               .symbol_name = "lsc_write_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 243,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Write hits",
               .desc = "Number of write hits in the Load/Store cache",
               .symbol_name = "lsc_write_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 242,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Atomic operations",
               .desc = "Number of atomic operations in the Load/Store cache",
               .symbol_name = "lsc_atomic_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 245,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Atomic hits",
               .desc = "Number of atomic hits in the Load/Store cache",
               .symbol_name = "lsc_atomic_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 244,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "Number of line fetches in the Load/Store cache",
               .symbol_name = "lsc_line_fetches",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 246,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Dirty line evictions",
               .desc = "Number of dirty line evictions in the Load/Store cache",
               .symbol_name = "lsc_dirty_line",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 247,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
            {
               .name = "Snoops in to LSC",
               .desc = "Number of coherent memory snoops in to the Load/Store cache",
               .symbol_name = "lsc_snoops",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 248,
               .category = &panfrost_perf_config_t83x.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "L2 Cache",
         .n_counters = 13,
         .counters = {
            {
               .name = "L2 read lookups",
               .desc = "Number of reads into the L2 cache",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 161,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "Read snoops",
               .desc = "Number of read transaction snoops",
               .symbol_name = "l2_read_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 164,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "L2 read hits",
               .desc = "Number of reads hitting in the L2 cache",
               .symbol_name = "l2_read_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 165,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "Write snoops",
               .desc = "Number of write transaction snoops",
               .symbol_name = "l2_write_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 170,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "L2 write hits",
               .desc = "Number of writes hitting in the L2 cache",
               .symbol_name = "l2_write_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 171,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "L2 write lookups",
               .desc = "Number of writes into the L2 cache",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 167,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "External read bytes",
               .desc = "Number of external bus read bytes",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 159,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (AR)",
               .desc = "Number of cycles a valid read address (AR) is stalled by the external interconnect",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 182,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "External bus response buffer full",
               .desc = "Number of cycles a valid request is blocked by a full response buffer",
               .symbol_name = "l2_ext_r_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 188,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "External bus read data buffer full",
               .desc = "Number of cycles a valid request is blocked by a full read data buffer",
               .symbol_name = "l2_ext_rd_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 184,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "External write bytes",
               .desc = "Number of external bus write bytes",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 158,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (W)",
               .desc = "Number of cycles a valid write data (W channel) is stalled by the external interconnect",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 186,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
            {
               .name = "External bus write buffer full",
               .desc = "Number of cycles a valid request is blocked by a full write buffer",
               .symbol_name = "l2_ext_w_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 187,
               .category = &panfrost_perf_config_t83x.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_t83x

static void UNUSED
static_asserts_t86x(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(19 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(33 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(13 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_t86x = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 11,
         .counters = {
            {
               .name = "GPU cycles",
               .desc = "Number of cycles GPU active",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "IRQ cycles",
               .desc = "Number of cycles GPU interrupt pending",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS0 cycles",
               .desc = "Number of cycles JS0 (fragment) active",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS1 cycles",
               .desc = "Number of cycles JS1 (vertex/tiler/compute) active",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS2 cycles",
               .desc = "Number of cycles JS2 (vertex/compute) active",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS0 jobs",
               .desc = "Number of Jobs (fragment) completed in JS0",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS1 jobs",
               .desc = "Number of Jobs (vertex/tiler/compute) completed in JS1",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS2 jobs",
               .desc = "Number of Jobs (vertex/compute) completed in JS2",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of Pixels completed in JS0",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 9,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS1 tasks",
               .desc = "Number of Tasks completed in JS1",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
            {
               .name = "JS2 tasks",
               .desc = "Number of Tasks completed in JS2",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_t86x.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 19,
         .counters = {
            {
               .name = "Tiler cycles",
               .desc = "Number of cycles Tiler active",
               .symbol_name = "ti_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 109,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Polygons",
               .desc = "Number of polygons processed",
               .symbol_name = "ti_polygons",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Quads",
               .desc = "Number of quads processed",
               .symbol_name = "ti_quads",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 69,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Triangles",
               .desc = "Number of triangles processed",
               .symbol_name = "ti_triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 68,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Lines",
               .desc = "Number of lines processed",
               .symbol_name = "ti_lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Points",
               .desc = "Number of points processed",
               .symbol_name = "ti_points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Front facing prims",
               .desc = "Number of front facing primitives",
               .symbol_name = "ti_front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Back facing prims",
               .desc = "Number of back facing primitives",
               .symbol_name = "ti_back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Visible prims",
               .desc = "Number of visible primitives",
               .symbol_name = "ti_prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Culled prims",
               .desc = "Number of culled primitives",
               .symbol_name = "ti_prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "Clipped prims",
               .desc = "Number of clipped primitives",
               .symbol_name = "ti_prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 79,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L0 prims",
               .desc = "Number of primitives in hierarchy level 0",
               .symbol_name = "ti_level0",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 80,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L1 prims",
               .desc = "Number of primitives in hierarchy level 1",
               .symbol_name = "ti_level1",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 81,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L2 prims",
               .desc = "Number of primitives in hierarchy level 2",
               .symbol_name = "ti_level2",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 82,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L3 prims",
               .desc = "Number of primitives in hierarchy level 3",
               .symbol_name = "ti_level3",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 83,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L4 prims",
               .desc = "Number of primitives in hierarchy level 4",
               .symbol_name = "ti_level4",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 84,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L5 prims",
               .desc = "Number of primitives in hierarchy level 5",
               .symbol_name = "ti_level5",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 85,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L6 prims",
               .desc = "Number of primitives in hierarchy level 6",
               .symbol_name = "ti_level6",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 86,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
            {
               .name = "L7 prims",
               .desc = "Number of primitives in hierarchy level 7",
               .symbol_name = "ti_level7",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 87,
               .category = &panfrost_perf_config_t86x.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 33,
         .counters = {
            {
               .name = "Tripipe cycles",
               .desc = "Number of cycles tripipe was active",
               .symbol_name = "tripipe_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles",
               .desc = "Number of cycles fragment processing was active",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Compute cycles",
               .desc = "Number of cycles vertex\\compute processing was active",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles waiting for tile",
               .desc = "Number of cycles spent waiting for a physical tile buffer",
               .symbol_name = "frag_cycles_no_tile",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles pre-pipe buffer not empty",
               .desc = "Number of cycles the pre-pipe queue contains quads",
               .symbol_name = "frag_cycles_fpkq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 200,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Fragment threads",
               .desc = "Number of fragment threads started",
               .symbol_name = "frag_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 204,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Dummy fragment threads",
               .desc = "Number of dummy fragment threads started",
               .symbol_name = "frag_dummy_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 205,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Fragment threads doing late ZS",
               .desc = "Number of threads doing late ZS test",
               .symbol_name = "frag_threads_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 209,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Fragment threads killed late ZS",
               .desc = "Number of threads killed by late ZS test",
               .symbol_name = "frag_threads_lzs_killed",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 210,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Compute tasks",
               .desc = "Number of compute tasks",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Compute threads",
               .desc = "Number of compute threads started",
               .symbol_name = "compute_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 216,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Primitives loaded",
               .desc = "Number of primitives loaded from tiler",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Primitives dropped",
               .desc = "Number of primitives dropped because out of tile",
               .symbol_name = "frag_primitives_dropped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Quads rasterized",
               .desc = "Number of quads rasterized",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Quads doing early ZS",
               .desc = "Number of quads doing early ZS test",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Quads killed early Z",
               .desc = "Number of quads killed by early ZS test",
               .symbol_name = "frag_quads_ezs_killed",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of pixels rendered",
               .symbol_name = "frag_num_tiles",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 212,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Tile writes killed by TE",
               .desc = "Number of tile writes skipped by transaction elimination",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 213,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "A instructions",
               .desc = "Number of instructions completed by the the A-pipe (normalized per pipeline)",
               .symbol_name = "arith_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "LS instructions",
               .desc = "Number of instructions completed by the LS-pipe",
               .symbol_name = "ls_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "LS instruction issues",
               .desc = "Number of instructions issued to the LS-pipe, including restarts",
               .symbol_name = "ls_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "T instructions",
               .desc = "Number of instructions completed by the T-pipe",
               .symbol_name = "tex_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 230,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "T instruction issues",
               .desc = "Number of threads through loop 2 address calculation",
               .symbol_name = "tex_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Cache misses",
               .desc = "Number of instructions in the T-pipe, recirculated due to cache miss",
               .symbol_name = "tex_recirc_fmiss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 235,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Read operations",
               .desc = "Number of read operations in the Load/Store cache",
               .symbol_name = "lsc_read_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 241,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Read hits",
               .desc = "Number of read hits in the Load/Store cache",
               .symbol_name = "lsc_read_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 240,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Write operations",
               .desc = "Number of write operations in the Load/Store cache",
               .symbol_name = "lsc_write_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 243,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Write hits",
               .desc = "Number of write hits in the Load/Store cache",
               .symbol_name = "lsc_write_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 242,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Atomic operations",
               .desc = "Number of atomic operations in the Load/Store cache",
               .symbol_name = "lsc_atomic_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 245,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Atomic hits",
               .desc = "Number of atomic hits in the Load/Store cache",
               .symbol_name = "lsc_atomic_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 244,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "Number of line fetches in the Load/Store cache",
               .symbol_name = "lsc_line_fetches",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 246,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Dirty line evictions",
               .desc = "Number of dirty line evictions in the Load/Store cache",
               .symbol_name = "lsc_dirty_line",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 247,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
            {
               .name = "Snoops in to LSC",
               .desc = "Number of coherent memory snoops in to the Load/Store cache",
               .symbol_name = "lsc_snoops",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 248,
               .category = &panfrost_perf_config_t86x.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "L2 Cache",
         .n_counters = 13,
         .counters = {
            {
               .name = "L2 read lookups",
               .desc = "Number of reads into the L2 cache",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 161,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "Read snoops",
               .desc = "Number of read transaction snoops",
               .symbol_name = "l2_read_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 164,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "L2 read hits",
               .desc = "Number of reads hitting in the L2 cache",
               .symbol_name = "l2_read_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 165,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "Write snoops",
               .desc = "Number of write transaction snoops",
               .symbol_name = "l2_write_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 170,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "L2 write hits",
               .desc = "Number of writes hitting in the L2 cache",
               .symbol_name = "l2_write_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 171,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "L2 write lookups",
               .desc = "Number of writes into the L2 cache",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 167,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "External read bytes",
               .desc = "Number of external bus read bytes",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 159,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (AR)",
               .desc = "Number of cycles a valid read address (AR) is stalled by the external interconnect",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 182,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "External bus response buffer full",
               .desc = "Number of cycles a valid request is blocked by a full response buffer",
               .symbol_name = "l2_ext_r_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 188,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "External bus read data buffer full",
               .desc = "Number of cycles a valid request is blocked by a full read data buffer",
               .symbol_name = "l2_ext_rd_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 184,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "External write bytes",
               .desc = "Number of external bus write bytes",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 158,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (W)",
               .desc = "Number of cycles a valid write data (W channel) is stalled by the external interconnect",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 186,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
            {
               .name = "External bus write buffer full",
               .desc = "Number of cycles a valid request is blocked by a full write buffer",
               .symbol_name = "l2_ext_w_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 187,
               .category = &panfrost_perf_config_t86x.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_t86x

static void UNUSED
static_asserts_t88x(void)
{
   STATIC_ASSERT(4 <= PAN_PERF_MAX_CATEGORIES);
   STATIC_ASSERT(11 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(19 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(33 <= PAN_PERF_MAX_COUNTERS);
   STATIC_ASSERT(13 <= PAN_PERF_MAX_COUNTERS);
}

const struct panfrost_perf_config panfrost_perf_config_t88x = {
   .n_categories = 4,
   .categories = {
      {
         .name = "Job Manager",
         .n_counters = 11,
         .counters = {
            {
               .name = "GPU cycles",
               .desc = "Number of cycles GPU active",
               .symbol_name = "gpu_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 6,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "IRQ cycles",
               .desc = "Number of cycles GPU interrupt pending",
               .symbol_name = "irq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 7,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS0 cycles",
               .desc = "Number of cycles JS0 (fragment) active",
               .symbol_name = "js0_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 10,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS1 cycles",
               .desc = "Number of cycles JS1 (vertex/tiler/compute) active",
               .symbol_name = "js1_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 18,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS2 cycles",
               .desc = "Number of cycles JS2 (vertex/compute) active",
               .symbol_name = "js2_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 26,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS0 jobs",
               .desc = "Number of Jobs (fragment) completed in JS0",
               .symbol_name = "js0_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 8,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS1 jobs",
               .desc = "Number of Jobs (vertex/tiler/compute) completed in JS1",
               .symbol_name = "js1_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 16,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS2 jobs",
               .desc = "Number of Jobs (vertex/compute) completed in JS2",
               .symbol_name = "js2_jobs",
               .units = PAN_PERF_COUNTER_UNITS_JOBS,
               .offset = 24,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of Pixels completed in JS0",
               .symbol_name = "js0_tasks",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 9,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS1 tasks",
               .desc = "Number of Tasks completed in JS1",
               .symbol_name = "js1_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 17,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
            {
               .name = "JS2 tasks",
               .desc = "Number of Tasks completed in JS2",
               .symbol_name = "js2_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 25,
               .category = &panfrost_perf_config_t88x.categories[0],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Tiler",
         .n_counters = 19,
         .counters = {
            {
               .name = "Tiler cycles",
               .desc = "Number of cycles Tiler active",
               .symbol_name = "ti_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 109,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Polygons",
               .desc = "Number of polygons processed",
               .symbol_name = "ti_polygons",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 70,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Quads",
               .desc = "Number of quads processed",
               .symbol_name = "ti_quads",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 69,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Triangles",
               .desc = "Number of triangles processed",
               .symbol_name = "ti_triangles",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 68,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Lines",
               .desc = "Number of lines processed",
               .symbol_name = "ti_lines",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 72,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Points",
               .desc = "Number of points processed",
               .symbol_name = "ti_points",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 71,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Front facing prims",
               .desc = "Number of front facing primitives",
               .symbol_name = "ti_front_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 75,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Back facing prims",
               .desc = "Number of back facing primitives",
               .symbol_name = "ti_back_facing",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 76,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Visible prims",
               .desc = "Number of visible primitives",
               .symbol_name = "ti_prim_visible",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 77,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Culled prims",
               .desc = "Number of culled primitives",
               .symbol_name = "ti_prim_culled",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 78,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "Clipped prims",
               .desc = "Number of clipped primitives",
               .symbol_name = "ti_prim_clipped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 79,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L0 prims",
               .desc = "Number of primitives in hierarchy level 0",
               .symbol_name = "ti_level0",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 80,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L1 prims",
               .desc = "Number of primitives in hierarchy level 1",
               .symbol_name = "ti_level1",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 81,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L2 prims",
               .desc = "Number of primitives in hierarchy level 2",
               .symbol_name = "ti_level2",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 82,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L3 prims",
               .desc = "Number of primitives in hierarchy level 3",
               .symbol_name = "ti_level3",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 83,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L4 prims",
               .desc = "Number of primitives in hierarchy level 4",
               .symbol_name = "ti_level4",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 84,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L5 prims",
               .desc = "Number of primitives in hierarchy level 5",
               .symbol_name = "ti_level5",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 85,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L6 prims",
               .desc = "Number of primitives in hierarchy level 6",
               .symbol_name = "ti_level6",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 86,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
            {
               .name = "L7 prims",
               .desc = "Number of primitives in hierarchy level 7",
               .symbol_name = "ti_level7",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 87,
               .category = &panfrost_perf_config_t88x.categories[1],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "Shader Core",
         .n_counters = 33,
         .counters = {
            {
               .name = "Tripipe cycles",
               .desc = "Number of cycles tripipe was active",
               .symbol_name = "tripipe_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 218,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles",
               .desc = "Number of cycles fragment processing was active",
               .symbol_name = "frag_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 196,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Compute cycles",
               .desc = "Number of cycles vertex\\compute processing was active",
               .symbol_name = "compute_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 214,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles waiting for tile",
               .desc = "Number of cycles spent waiting for a physical tile buffer",
               .symbol_name = "frag_cycles_no_tile",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 211,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Fragment cycles pre-pipe buffer not empty",
               .desc = "Number of cycles the pre-pipe queue contains quads",
               .symbol_name = "frag_cycles_fpkq_active",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 200,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Fragment threads",
               .desc = "Number of fragment threads started",
               .symbol_name = "frag_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 204,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Dummy fragment threads",
               .desc = "Number of dummy fragment threads started",
               .symbol_name = "frag_dummy_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 205,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Fragment threads doing late ZS",
               .desc = "Number of threads doing late ZS test",
               .symbol_name = "frag_threads_lzs_test",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 209,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Fragment threads killed late ZS",
               .desc = "Number of threads killed by late ZS test",
               .symbol_name = "frag_threads_lzs_killed",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 210,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Compute tasks",
               .desc = "Number of compute tasks",
               .symbol_name = "compute_tasks",
               .units = PAN_PERF_COUNTER_UNITS_TASKS,
               .offset = 215,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Compute threads",
               .desc = "Number of compute threads started",
               .symbol_name = "compute_threads",
               .units = PAN_PERF_COUNTER_UNITS_THREADS,
               .offset = 216,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Primitives loaded",
               .desc = "Number of primitives loaded from tiler",
               .symbol_name = "frag_primitives",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 197,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Primitives dropped",
               .desc = "Number of primitives dropped because out of tile",
               .symbol_name = "frag_primitives_dropped",
               .units = PAN_PERF_COUNTER_UNITS_PRIMITIVES,
               .offset = 198,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Quads rasterized",
               .desc = "Number of quads rasterized",
               .symbol_name = "frag_quads_rast",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 206,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Quads doing early ZS",
               .desc = "Number of quads doing early ZS test",
               .symbol_name = "frag_quads_ezs_test",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 207,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Quads killed early Z",
               .desc = "Number of quads killed by early ZS test",
               .symbol_name = "frag_quads_ezs_killed",
               .units = PAN_PERF_COUNTER_UNITS_QUADS,
               .offset = 208,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Pixels",
               .desc = "Number of pixels rendered",
               .symbol_name = "frag_num_tiles",
               .units = PAN_PERF_COUNTER_UNITS_PIXELS,
               .offset = 212,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Tile writes killed by TE",
               .desc = "Number of tile writes skipped by transaction elimination",
               .symbol_name = "frag_trans_elim",
               .units = PAN_PERF_COUNTER_UNITS_TILES,
               .offset = 213,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "A instructions",
               .desc = "Number of instructions completed by the the A-pipe (normalized per pipeline)",
               .symbol_name = "arith_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 219,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "LS instructions",
               .desc = "Number of instructions completed by the LS-pipe",
               .symbol_name = "ls_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 223,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "LS instruction issues",
               .desc = "Number of instructions issued to the LS-pipe, including restarts",
               .symbol_name = "ls_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 224,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "T instructions",
               .desc = "Number of instructions completed by the T-pipe",
               .symbol_name = "tex_words",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 230,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "T instruction issues",
               .desc = "Number of threads through loop 2 address calculation",
               .symbol_name = "tex_issues",
               .units = PAN_PERF_COUNTER_UNITS_INSTRUCTIONS,
               .offset = 234,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Cache misses",
               .desc = "Number of instructions in the T-pipe, recirculated due to cache miss",
               .symbol_name = "tex_recirc_fmiss",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 235,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Read operations",
               .desc = "Number of read operations in the Load/Store cache",
               .symbol_name = "lsc_read_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 241,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Read hits",
               .desc = "Number of read hits in the Load/Store cache",
               .symbol_name = "lsc_read_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 240,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Write operations",
               .desc = "Number of write operations in the Load/Store cache",
               .symbol_name = "lsc_write_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 243,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Write hits",
               .desc = "Number of write hits in the Load/Store cache",
               .symbol_name = "lsc_write_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 242,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Atomic operations",
               .desc = "Number of atomic operations in the Load/Store cache",
               .symbol_name = "lsc_atomic_op",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 245,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Atomic hits",
               .desc = "Number of atomic hits in the Load/Store cache",
               .symbol_name = "lsc_atomic_hits",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 244,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Line fetches",
               .desc = "Number of line fetches in the Load/Store cache",
               .symbol_name = "lsc_line_fetches",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 246,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Dirty line evictions",
               .desc = "Number of dirty line evictions in the Load/Store cache",
               .symbol_name = "lsc_dirty_line",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 247,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
            {
               .name = "Snoops in to LSC",
               .desc = "Number of coherent memory snoops in to the Load/Store cache",
               .symbol_name = "lsc_snoops",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 248,
               .category = &panfrost_perf_config_t88x.categories[2],
            }, // counter
         }, // counters
      }, // category
      {
         .name = "L2 Cache",
         .n_counters = 13,
         .counters = {
            {
               .name = "L2 read lookups",
               .desc = "Number of reads into the L2 cache",
               .symbol_name = "l2_read_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 161,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "Read snoops",
               .desc = "Number of read transaction snoops",
               .symbol_name = "l2_read_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 164,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "L2 read hits",
               .desc = "Number of reads hitting in the L2 cache",
               .symbol_name = "l2_read_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 165,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "Write snoops",
               .desc = "Number of write transaction snoops",
               .symbol_name = "l2_write_snoop",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 170,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "L2 write hits",
               .desc = "Number of writes hitting in the L2 cache",
               .symbol_name = "l2_write_hit",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 171,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "L2 write lookups",
               .desc = "Number of writes into the L2 cache",
               .symbol_name = "l2_write_lookup",
               .units = PAN_PERF_COUNTER_UNITS_REQUESTS,
               .offset = 167,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "External read bytes",
               .desc = "Number of external bus read bytes",
               .symbol_name = "l2_ext_read_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 159,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (AR)",
               .desc = "Number of cycles a valid read address (AR) is stalled by the external interconnect",
               .symbol_name = "l2_ext_ar_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 182,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "External bus response buffer full",
               .desc = "Number of cycles a valid request is blocked by a full response buffer",
               .symbol_name = "l2_ext_r_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 188,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "External bus read data buffer full",
               .desc = "Number of cycles a valid request is blocked by a full read data buffer",
               .symbol_name = "l2_ext_rd_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 184,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "External write bytes",
               .desc = "Number of external bus write bytes",
               .symbol_name = "l2_ext_write_beats",
               .units = PAN_PERF_COUNTER_UNITS_BYTES,
               .offset = 158,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "External bus stalls (W)",
               .desc = "Number of cycles a valid write data (W channel) is stalled by the external interconnect",
               .symbol_name = "l2_ext_w_stall",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 186,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
            {
               .name = "External bus write buffer full",
               .desc = "Number of cycles a valid request is blocked by a full write buffer",
               .symbol_name = "l2_ext_w_buf_full",
               .units = PAN_PERF_COUNTER_UNITS_CYCLES,
               .offset = 187,
               .category = &panfrost_perf_config_t88x.categories[3],
            }, // counter
         }, // counters
      }, // category
   }, // categories
}; // panfrost_perf_config_t88x
