/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *                                                                  *
 *    Please See COPYLEFT notice.                                   *
 *                                                                  *
 ********************************************************************/
# include	"crisp.h"

void
tags()
{
	tag();
}
void
tag()
{
	string function, sstring;
	int	tag_buf, old_buf;

	get_parm(0, function, "Function: ");
	old_buf = inq_buffer();
	tag_buf = create_buffer("Tags", "tags", 1);
	set_buffer(tag_buf);
	top_of_buffer();
	sstring = "^" + function;
	
	if (re_search(NULL, sstring)) {
		string line, file, pattern;
		int i, j;
		line = read();
		i = index(line, "\t") + 1;
		j = re_search(NULL, "[ \t][?/]", line);
		file = substr(line, i, j - i);
		set_buffer(old_buf);
		edit__file(file);
		top_of_buffer();
		j += 2;
		i = strlen(line) - j - 1;
		pattern = substr(line, j, i);
		if (re_search(NULL, pattern) <= 0)
			error("Function not found.");
		}
	else {
		error("Function %s not found.", function);
		set_buffer(old_buf);
		}
}
void
tag_function()
{
	string function;
	int	i;
		
	save_position();
	re_search(SF_BACKWARDS, "<|{[^_A-Za-z0-9]\\c}");
	function = ltrim(trim(read()));
	i = re_search(NULL, "[^_A-Za-z0-9]", function);
	if (i > 0)
		function = substr(function, 1, i - 1);
	restore_position();
	if (function == "") {
		beep();
		return;
		}
	tag(function);
}
/**********************************************************************/
/*   Macro to create a tags file for *.m files in current directory.  */
/**********************************************************************/
void
mtags()
{
	int	curbuf, buf;
	
	curbuf = inq_buffer();
	message("Creating .m tags file.");
	buf = perform_unix_command(
		"grep '^(macro' *.m | awk '{printf \"%s\t%s\\n\",$2,$0}' | sort", "");
	set_buffer(buf);
	top_of_buffer();
	re_translate(SF_GLOBAL, ":", "	/^");
	top_of_buffer();
	re_translate(SF_GLOBAL, "$", "$/");
	write_buffer("tags");
	set_buffer(curbuf);
	message("'tags' file created.");
}
