.so crisp.mac
.SP 9
.ce
\s+5\s+9\s+9\f(HBC\s-9RISP  Configuration and Installation Guide\fR\s-9\s-5
.SP 9
.nf
.in +2i
\s+5\f(HBVersion:	2.0

Author:	Paul Fox

Date:		May 1991
.in
\s-5\fR
.SP 9
.in +1i
.ll -1i
.ce
\f(HBCopyright Notice\fR
.SP 2
.fi
This document and the software it describes is Copyright (C) 1991
by Foxtrot Systems Ltd and Paul Fox. This copyright notice will remain
in effect at all times.
This manual may be reproduced under the terms of the CRISP copyright notice
associated with the distribution software.
.in
.ll
.SP 5
.nf
Foxtrot Systems Ltd
8, Theobalds Way
Frimley,
Surrey,
England GU16 5RF
.fi
.bp
.PH "'''Page %'"
.PF "'CRISP Configuration Guide'May 1991'Release 2.1'"
.H 1 Introduction
.P
This guide describes how to configure and customise CRISP for your
particular environment. The manual is intended for people who are
installing the software or porting it to their own machines. The
new users should read the following documents as well:
.DL
.LI
CRISP User Guide. This covers a basic introduction on how to \fIuse\fR
CRISP, in terms of functions available from the keyboard and
the user interface.
.LI
CRISP Programmers Guide. This document should be read by people who wish to
write their own macros in either the lisp-like language or the 
\f(HBcrunch\fR language.
.LE
.P
Setting up CRISP can be a fairly complex
operation or it can be relatively easy. On systems where the binary is
supplied, setting up is fairly straightforward if the user is using
the \fIconsole\fR. If the user wishes to access CRISP from a local
serial terminal, using CRISP can be more of a problem.
.P
If you have any problems getting CRISP to start, you
should read the descriptions below carefully. There are
many configurable options, partly due to the flexibility
of CRISP and the lack of any standards available for
describing the functionality of terminals needed to run
CRISP on.
.P
As a bare minimum the BPATH and BTERM environment
variables need to be set up.
.H 1 "The Distribution Files"
.P
The CRISP package may exist as either a \fIbinary\fR distribution
or a \fIsource\fR distribution. Binary distributions are used when people
do not need or want to port the code, but just want to use it. The source
distribution consists of the entire source code for CRISP without any
ready made binaries -- you will need to compile it yourself.
.P
The binary distribution contains the files and directories listed in the
table below. The source distribution includes the source files listed
in this table together with other stuff not described here.
.TS H
center allbox;
cB cB
l lw(4i).
Name	Description
=
.TH
\f(HBcr\fR	Executable program which implements the CRISP editor.
\f(HBcm\fR	T{
Executable program which is used to compile macros in the old \fH.m\fR
format. This is compatible with the BRIEF language. This language
is Lisp oriented and difficult to use for newcomers.
T}
\f(HBcrunch\fR	T{
This is the executable for the CRISP macro compiler. This language
is an ANSI-C like language, allowing CRISP macros to be written in
a more understandable manner. This is the preferred language for macros.
T}
help/	T{
Files constituting the on-line help and printed manual.
T}
macros/	T{
This directory contains the compiled macros needed at run-time
to support the various editing facilities.
T}
src/crunch	T{
Directory containing the sources for the macro files. These may be used
for local customization, and as examples of how to write macros using
the CRUNCH language.
T}
utils/	T{
Miscellaneous code which is useful on many systems and also
public domain code found useful in supporting CRISP. All code
supplied in source form.
T}
.TE
.P
The following table describes the purpose of each file in the \fHutils\fR
directory.
.ne 1.5i
.TS H
center allbox;
cB cB
lfH lw(4i).
Filename	Description
=
.TH
\.Xdefaults	T{
This file is a copy of an X11 defaults file which I have used
under the OpenLOOK windowing system supplied by Sun Microsystems. This
file is provided as an example of an actually used file. Some of the parts
are not relevant to using CRISP, but the Xterm settings may be useful to you.

There are actually two sets of xterm settings -- those for a native
xterm, and those for when xterm is run as xcrisp. The first settings
are liable to removal in a future release. To run xterm as xcrisp
please consult the section on running CRISP under the xcrisp
environment.
T}
\.bashrc	T{
This file is a startup file used for setting up
environment variables and local functions used in
conjunction with the GNU shell (\fIbash\fR). This file
should be compatible with the Korn-shell and may be used
as a \fH.profile\fR file for the Bourne shell if the
alias commands are removed.
T}
\.crtswrc	T{
This file is a configuration file for the \fHcrttool\fR utility.
(See description of the \fHcrttool.tar.Z\fR program below).
T}
\.cshrc	T{
An example .cshrc file for the C-shell.
T}
\.defaults	T{
File used when running SunView. Used to tell SunView to
generate special escape sequences for as many function
keys as possible.
T}
\.login	T{
An example .login showing how the environment variables
are set up on a SPARCstation.
T}
crisp.csh	T{
This is an example file which should be read by your .login file
when using the cshell. You will need to tailor this file depending
on your environment.
T}
crisp.sh	T{
This is an example file which should be read by your .profile
or .bashrc file
when using the Bourne or Bash shells. 
You will need to tailor this file depending
on your environment.
T}
crttool.tar.Z	T{
This is a public domain color VT220 emulator for SunView and
OpenLOOK. It is a very good utility. This is a
compressed tar file, and you will need to look at this
if you want to install it on your system. An example
\.crtswrc file is provided in this directory which is
used to support some extra key bindings.
T}
ftp.notes	T{
Notes for using and setting up the FTP terminal emulator package.
I've not personally used this so you'll need to read this note.
T}
getcwd.c	T{
Public domain implementation of the \f(CWgetcwd()\fR
library call used to replace the standard ones with Unix
System V and BSD implementations which fork a copy of the /bin/pwd
program.
T}
kbd.c	T{
Utility to remap keyboard when running under Unix V.3.2
(e.g. on a 386/486 PC). This file is used with the \fHkeyboard.fox\fR
file so that CRISP can see the various <ALT> key
combinations. This program should be run from your \fH.login\fR or \fH.profile\fR. 
It also sets the
hot-keys up for switching to the other virtual consoles to \fH<Alt-Fn>\fR.
T}
keys	T{
This file is a keyboard mapping file for older SCO
versions of Xenix. This file should be given as an
argument to \fImapkey(1)\fR program.
T}
keyupor.v3	T{
A keyboard mapping file for the Microport Unix V.3.0e system.
T}
mapstr.c	T{
Utility designed to replace the \fImapstr(1)\fR utility
under Xenix systems, and providing the ability to
redefine function keys with the top bit set.
T}
rdetool.tar.Z	T{
This is a replacement for the shelltool/cmdtool utilities under
Xview. It is a public domain piece of code, with some hacks by
me so that we can see all the function keys and Alt combinations. This
can be used with BTERM=rde.
T}
strings	T{
File to be used as input to the \fImapstr(1)\fR program
under Xenix.
T}
termcap	T{
My personal collection of termcap entries incorporating
tweaks for certain terminal types. If you experience any
problems with the standard termcap file on your system,
try setting the BTERMCAP environment variable to point to
this file. My personal additions to this file are
located near the beginning.
T}
xmodmaprc	T{
This file should be used via the command: xmodmap xmodmaprc, when
running X-windows. It is needed for a Sun system so that all the <Alt>
keys on the bottom row of the keyboard can be used. This may or may not
work on your system. You will need to ensure that xmodmap is run
during the X-windows startup.
T}
.TE
.H 1 "The CRISP Directory Tree"
.P
There are three main directories which need to be
accessible in order for CRISP to stand any chance of running:
.DL
.LI
The directory where the \fHcr\fR binary is located.
Set via the PATH environment variable.
.LI
The compiled macros directory.
Set via the BPATH environment variable.
.LI
The help files directory.
Set via the BHELP environment variable.
.LE
.P
The help files directory is not absolutely mandatory in
order for
CRISP to run but obviously without it, help will not be available.
Ensuring that the macros directory is accessible is
important. If the macros are not accessible then CRISP
will not display \fIanything\fR on the screen.
.H 1 "Setting up Environment Variables"
.P
CRISP uses various environment variables to control its
actions. These environment variables allow users to
tailor where they want to place certain parts of the
CRISP support environment, (e.g. help files and macros) or
setup default options.
.P
Some of these are used internally by the code itself (eg
BFLAGS), others by the support macros, (eg BHELP).
.P
All environment variables start with a \fBB\fR to avoid
conflicts with other packages.
.TS H
center allbox;
c c 
l lw(4i).
Name	Description
=
.TH
BBACKUP	T{
This should contain the path of a directory
which is writable to by CRISP. This directory is used to
place backups of the files which have been edited. If this variable
is not set, then backups will be written to the
directory where a file was edited, but with an extension
of \fH.bak\fR.
T}
BFILE	T{
If no file arguments are given on the command line, then
by default CRISP places the user in the buffer labelled
\fHnewfile\fR. Setting the BFILE environment variable
allows the user to specify an alternate default file name.
T}
BFLAGS	T{
This environment variable can be used to augment the
default command line switches. CRISP processes the
switches specified in BFLAGS after processing the flags
on the command line.

The BFLAGS environment variable provides a simple way to
set up a private macro file to be invoked on start up.
For example, setting BFLAGS to:

	BFLAGS="-i60 -mfox"

causes the idle timer to be set to 60 seconds, and the
macro file \fHfox.cm\fR to be executed. (\fHfox.cm\fR will be looked
for in the default \fHBPATH\fR list or in the user's home
directory).
T}
BHELP	T{
This variable contains the path where the CRISP help
files are located. If it is not specified, CRISP uses
the internal default:

	/usr/local/crisp/help

Setting it to another value allows a site to put the
help files under a different path.
T}
BKBD	T{
This variable is used to define a macro file which is
used to define the labels which appear on your keyboard.
CRISP uses the PC keyboard names internally. This macro
is only relevant to the 'Command Summary' option of the
help menu so that the keyboard keys are given meaningful
labels to you. Currently there are two defined keyboard
layouts - \fHpc\fR for generic PC keyboards and \fHsun3\fR for a
Sun type 3 keyboard.
T}
BLEVEL	T{
This environment is set by CRISP when it is run, so that
nested invocations of CRISP can show to what level of
nesting has occurred. This is a hangover from the PC
version of BRIEF which displays the level number in the
bottom right corner. This is done so that the user can
realise he has nested invocations of CRISP.
T}
BPACKAGES	T{
This macro is reserved for use by the BRIEF/CRISP macro
language sensitive editing modes. CRISP currently does
not support language sensitive editing (unless used with
the BRIEF macros).
T}
BPATH	T{
This is similar to the standard PATH variable, and is
used by CRISP when it is trying to autoload a macro. The
directories should be separated by semi-colons, since
some macros hardwire the parsing of the string. (This is
in contrast to the PATH variable which is usually colon
delimited).
T}
BTERM	T{
BTERM is similar to the TERM environment variable, and
is used to access the special terminal description file
which CRISP uses to define special escape sequences and
function key bindings. If this environment variable is
not set, then CRISP uses the value of TERM instead.

When CRISP starts up, the macro file \fHcrisp.cm\fR causes the
file \fHtty/$BTERM.cm\fR to be loaded as well. For example, if
BTERM is set to \fHsun\fR, then the file \fHtty/sun.cm\fR gets
loaded. The \fHtty/*.cm\fR files are responsible for
configuring CRISP for the appropriate keyboard and
screen layout.

Multiple options may be specified in the BTERM variable
by using the hyphen character. For example, to specify
that you are using a Interactive Systems Unix console,
running in monochrome mode, you would set BTERM to
\fHisc-mono\fR. The \fHcrisp.cr\fR macro splits the
BTERM environment variable and executes macros
corresponding to each word in the list. Thus, in the
case of \fHisc-mono\fR, the \fHisc()\fR and \fHmono()\fR
macros are executed.
T}
BTERMCAP	T{
This variable acts just like the TERMCAP environment variable,
and may be used in preference to TERMCAP if you want to use
CRISP but also maintain the value of TERMCAP for some other applications
T}
BTMP & TMP	T{
CRISP creates files in a temporary directory. This is
usually /tmp. The files it creates here are for holding
the undo buffer. (The file will not usually appear in
directory listings since the file is deleted as soon as
it is opened). If /tmp on your system is not very large
and you wish to use an alternate directory, then you can
specify this in the BTMP or TMP environment variables.

CRISP looks in BTMP first; if this is not defined it
tries TMP. If this isn't defined, it defaults to /tmp.
T}
BVERSION	T{
This variable allows you to keep multiple backup copies
of edited files. If this variable is not set, then only
the last version of the edited file is saved (see the
BBACKUP variable). Setting BVERSION to 'n' means that
CRISP will create 'n' sub-directories in the backup
directory, labelled 0, 1, .., n. The oldest version of a
file can be found in the 'n' directory; the next oldest
is in n-1. The most recent backup is the file in the
backup directory.
T}
CRISP_LOG	T{
This variable can be used to override the name of the log file
created when debugging is turned on. By default debugging output
is written to /tmp/crisp.log.
T}
.TE
.H 1 "Command Line Switches"
.P
CRISP has a number of command line switches available.
To see the list at any time, just run CRISP with an
invalid switch, e.g. \fB-Q\fR is invalid.
.P
CRISP accepts switches in any order. If any files are
specified on the command line, then these are
automatically read into a buffer on startup. Multiple
files may be specified.
.P
The syntax of switches allows arguments to either
immediately follow the switch character or occur
separated by a space. (Contrary to the \fIgetopt(1)\fR standard).
.P
A default set of switches may be placed in the BFLAGS
environment variable. These switches are parsed before
the command line switches, and therefore these can be
used to override your private defaults. The most common
reason to do this is to have a private startup file
which customises CRISPs behaviour.
.TS H
center allbox expand;
cB cB
l lw(4i).
Switch	Description
=
.TH
-b	T{
This switch turns off backup file creation.
T}
-d and -f	T{
The -d switch is equivalent to executing the (debug)
macro before any of the standard macros are read in.
This is provided so that it is possible to debug macros
which cause CRISP to crash on start up. Debugging is
always sent to the file \fHcrisp.log\fR in the current directory.

The -f switches is used to control flushing of the debug
log file. Normally CRISP uses the stdio package to write
to the crisp.log file. If this switch is specified, then
every call to trace something is immediately written to
disk. This switch is provided because if a macro causes
CRISP to crash, then the last partial buffer of output
may be lost. The -f switch significantly slows CRISP
down on large debug traces.
T}
-e	T{
This switch is similar to the \fIecho_line()\fR
primitive. It is used to set the flags controlling the
appearance of the echo status line (e.g. whether the
Line:, Col:, etc fields should be there).

The argument is the same argument as passed to
\fIecho_line()\fR. Refer to this macro for further details.
T}
-i	T{
This switch allows the user to change the default idle
timer. The idle timer is used to allow registered macros
to be called after a certain amount of keyboard
inactivity.

The argument specifies the number of seconds of keyboard
activity. The default is 60 seconds.
T}
-m\fIname\fR	T{
This switch specifies a macro or macro file to execute
on startup. If the macro name is an internal primitive
then that is executed; otherwise CRISP looks for a macro
file with the name specified and executes the macro in
that file with the same name.

The macro file can be placed in the users home directory.
T}
-p	T{
This switch is used to allow CRISP to dump a
\fImon.out\fR file for profiling on exit. Not normally
needed by users.
T}
-R	T{
CRISP operates in read-only mode. In this mode all files edited
have the read-only attribute disabling accidental changes to files.
T}
-s	T{
Used to print out statistics when CRISP exits. None of these
are guaranteed to be useful to anyone and are always
subject to change. Used for optimising the code.
T}
-t	T{
This switch is similar to the \fIuse_tab_char()\fR macro. If
specified, then CRISP will use soft tabs (inserts spaces
instead of tabs); if omitted, then the default of using
hard tabs in buffers is in effect.
T}
-w	T{
This switch controls the (read_char) macro. Under DOS,
the (read_char) macro is used to poll the keyboard and
returns -1 if there is no input pending. Some macros use
the (read_char) primitive in a busy poll loop waiting
for character input. This is an antisocial thing to do
under Unix, as it steals the CPU from other processes.

By default CRISP does not allow (read_char) to return
-1, but instead will block until a character is
available. This may affect some macros which rely on
this feature.

This switch is antiquated. CRISP now supports an
argument to \fIread_char()\fR to allow the macro to
specify a timeout.
T}
+nn	T{
This switch tells CRISP to go to line \fInn\fR in the
first buffer to be edited. This is useful after getting a 
syntax error from a compilation and the user wants to go
directly to the line in error.
T}
-4	T{
Antiquated switch to support EGA 43 line mode switching on PCs.
T}
.TE
.H 1 "Sequence of actions on startup"
.P
CRISP performs a number of actions on startup before the editing screen
is ready for use. It may be useful to understand the
sequence of events performed in case the user wants to
customise this startup processing.
.P
When CRISP starts up, it firstly initialises all its
internal data structures. It then parses the command
line and remembers the names of all the macro's
specified in the -m switches.
The macros are not executed until the rest of the
startup processing is complete.
.P
It then autoload's the macro \fHcrisp\fR. Since no autoload
definition is available for this macro during the startup, 
it looks to see if
it can find a \fHcrisp.cm\fR or \f(HBcrisp.m\fR in its BPATH directory
list. It normally resolves this into
\fH/usr/local/crisp/macros/crisp.cm\fR.
.P
The \fHcrisp\fR macro looks at the TERM and BTERM
environment variables and executes the the macros needed
to tell CRISP how your terminal is setup. The TERM
variable is only used if BTERM is not set. The BTERM
variable is
split into hyphen separated \fIwords\fR and macros
corresponding to these words are executed in sequence.
This allows generic descriptions for terminals to be
made, and allows the user to specify sub-options for
his/her private setup. These terminal specific macros
are located in
the \fHtty/\fR subdirectory.
When the appropriate terminal definition has been
processed, the display is enabled. This means that CRISP
will actually generate output. (On startup CRISP is
disabled from generating characters to the screen
because it won't
know what escape sequences to send).
.P
After processing the \fHcrisp\fR macro, CRISP runs a
macro called \fHstartup\fR. In the default installation,
this is located in the \fHstartup.cm\fR compiled macro file.
This file is designed to allow local customisation. It
should only be modified if all users are to have the
same set of defaults. Private defaults can be
accomplished with the BFLAGS environment variable and
the \fB-m\fR switch.
.P
After these macros have been executed, the macros
specified in the BFLAGS environment variable are
executed, followed by any macros on the command line.
.H 1 "Setting environments for Terminals"
.P
This section gives some information on setting up
environments for particular terminal types which have
been tested and known to work. You should follow the
guidelines in this section if you have a similar
configuration or use the notes presented in this section
to help you customise your own environment.
.P
The two important variables to set up are TERM and BTERM. CRISP
uses TERM in the same manner as other programs. Because
other programs rely on TERM to tell them the terminal
type, CRISP cannot modify or expect the user to modify
this variable or the corresponding termcap/terminfo
entry for any form of personalisation. Therefore, BTERM
is used instead, ensuring no conflict with existing applications.
.P
The TERM variable is used to tell CRISP as much
information as termcap can provide (i.e. the usual stuff
about how to move the cursor and clear the screen).
However, termcap cannot describe the function keys on
the terminal, and although terminfo is capable of this
no Unix system specifies the values for the multitudes
of function keys on the console, e.g. a PC VGA screen or
a Sun screen.
.P
BTERM is primarily used to indicate the name of a
startup terminal description file to execute on startup,
describing your terminal. This startup file describes
whether the terminal supports the line drawing character
set, whether it supports color and any other peculiar characteristics.
BTERM can also indicate a set of minor macros to execute
depending on your actual physical terminal. For example,
under Interactive Unix (and SCO), the base terminal type
is \fHAT386\fR. However, the user may have a color VGA
or a monochrome VGA attached. In fact, the type of
monitor may change whilst the user is logged in, so it
is worth setting up a minor terminal mode.
Another important example is when running an xterm under X-windows.
The user may or may not have the Sun function key
bindings on a per window basis. Because of this it is
useful to keep the majority of the terminal description
in one file and just have small subroutines which
customise the local terminal settings. (Refer to the
source code for the terminals located in the
\fHsrc/crunch/tty\fR directory).
.P
You will probably also need to use the \f(HBtermcap\fR file supplied
(crisp/utils/termcap) for many of these settings. If you get
no output from crisp or the screen screws up occasionally, you should
trying setting \fHBTERMCAP\fR to the name of this file.
.P
The following sections describe terminal setups which I
have used and managed to get reasonably faithful PC
emulations of the keyboard.
.H 1 "PC Compatible running Unix V.3 (SCO & ISC)"
.P
TERM should be set to \fHAT386\fR.
.P
BTERM should be set to \fHisc\fR if you have a color
EGA/VGA screen. This entry should work for SCO Unix but
has not been tested. If you have a monochrome screen
then use \fHisc-mono\fR.
.P
In order to properly use Interactive Unix, SCO Unix or Xenix,
you will need to remap the keyboard so that CRISP can see the
various <Alt> and function keys. Code to set this up can be found
in the utils subdirectory. You need to compile
utils/kbd.c and run it as follows:
.DS
	kbd keyboard.fox
.DE
where \fHkeyboard.fox\fR is located in the utils
directory as well.
The file kbd.c is designed to run under Unix V.3 (i.e. SCO
and Interactive). Its known to work under Interactive but
not SCO, but it should conform to the 386 ABI. The file
is a replacement for the Xenix/SCO-Unix programs mapstr
and strings. It takes as input the file keyboard.fox.

If you get this to work but you don't like the keyboard
bindings, e.g. because it conflicts with some other application
you use, please feel free to change the file, but you'll
have to make appropriate changes to the isc.cr file
located in the src/crunch/tty directory.
.H 1 "Running xcr -- native CRISP under X11"
.P
CRISP can be run as a native X11 window under X11 release 3 or 4 or
under XView. In order to do this, it is necessary to run the
CRISP binary compiled with X11 support. The normal makefile does not
build this. To build CRISP under X11 (xcr), you will need
to go into the crisp/x11 directory and type \fImake\fR. Under X11
release 3, it is necessary to type '\fImake x11r3\fR'.
.P
This will produce a binary called \f(HBxcr\fR. xcr can be run
as a normal character based version of crisp or as an X application.
By default it will run as an X application. If the file is renamed
to be called 'cr' it will run as a normal binary. (This allows system
managers to keep just one binary up to date. However the X11 binary is
about twice the size of the normal cr binary).
.P
If xcr is renamed to 'cr', then it can still be invoked by using the \f(HB-x11\fR
switch to cr. This switch MUST be the first switch specified.
.P
When running xcr, CRISP ignores the BTERMCAP, BTERM and TERM environment
variables. This allows the user to run either version of crisp from
the same xterm or shelltool window. Note that setting colors within crisp
(via the \f(HBsetcolor\fR macro) will cause these color settings to be
shared between cr and xcr.
.P
xcr currently supports color, and has not been tested on a monochrome
screen. The internal colors are not configurable, unless you edit
the source code (x11/crwin.c) to change the color mapping names.
.P
xcr has one bug which has yet to be resolved and that is resizing the window
can cause crisp to screw up when trying to resize the internal windows.
It should work if you are zooming and unzooming the window but is not
guaranteed under all circumstances.
.P
The following resources are understood:
.P
.TS H
center allbox;
cB cB
lw(2i) lw(2.5i).
Resource	Description
=
.TH
font	T[
Font used for displaying text. For systems that support it, 7x13bold
is better than the standard one.
T}
insertCursorColor	T{
This is a Pixel resource which defines the color of the cursor when in
normal insert mode. This is a standard color name used for the background.
The foreground color is hardcoded as black to ensure the character stands out.
The default value is "red".
T}
overtypeCursorColor	T{
This is a Pixel resource which defines the color of the cursor when in
overtype mode.
The default value is "yellow".
T}
.TE
.H 1 "CRISP under Interactive Unix X11 using xcrisp"
.P
This section describes how to use CRISP when running Interactive Systems
Corporation version of X11 under Unix V.3.2. This description may
well be applicable to other systems but I have not had a chance
to verify this.
.P
Make sure you do NOT use the crisp/utils/.xmodmaprc file -- the
keyboard does not need to be remapped.
.P
You SHOULD use the crisp/utils/.Xdefaults file. You may need to
merge it with your own file. The file at present will generate
warnings when you start xterms about translations being overridden.
These can be ignored.
.P
xterm should be run with the name 'xcrisp':
.DS
	xterm -name xcrisp
.DE
.P
wherever you refer to it, e.g. command line, popup windows, window
manager, etc.
.P
You should set BTERM to the value 'xcrisp'.
.P
For best results, you can use the xcr program mentioned in the previous
section.
.H 1 "CRISP under X11 and/or OpenLOOK using xterm"
.P
The X11 windowing system covers a wide variety of machines, and
many suppliers customise their systems. For example, Sun have
an enhanced and merged version of X11 supporting older SunView applications
together with their NeWS system. These instructions describe the principals
behind getting CRISP to work with the \f(Hxterm\fR terminal emulation
utility. Because each system allows configuration in different ways, it
is difficult to come up with a generic installation procedure.
.P
Firstly, there are \fBtwo\fR ways to run xterm -- the \fIxterm\fR
way and the \fIxcrisp\fR way. When xterm is running it can be given
a \f(HB-name\fR switch on the command line telling it to change its
name. This is useful and important because it means that you can set up
different key bindings in your \f(HB~/.Xdefaults\fR file so that
CRISP doesn't interfere with any other applications you may use under
xterm. The xcrisp mechanism does this, and you will need to ensure that
when using xcrisp, that you always run xterm as:
.DS
	xterm -name xcrisp
.DE
.P
This means changing your \f(HB~/.xinitrc\fR and any private popup
windows, e.g. \f(HB~/.openwin-menu\fR when running OpenLOOK from
Sun. The xcrisp way is the preferred method for running CRISP
since it allows new key assignments to be made and other environmental
changes without necessarily damaging your working environment. At the
same time, the xcrisp mechanism is designed to be compatible with
your normal Xterm environment so you should be able to use it always. This
means for example that the arrow keys will still work with \fIvi(1)\fR.
.P
In order to run CRISP with an xterm window, it is necessary to tell
X11 about the function keys which are not normally mapped to any sequence.
Where possible, CRISP uses the function keys which xterm defines, but
there are many sequences which xterm does not normally interpret, e.g.
\fH<Ctrl-left-arrow>\fR.
.P
Setting up the system to ensure that these key sequences are set
up involves setting up or modifying your various preferences files:
.AL
.LI
Tell X to read the \f(HBxmodmaprc\fR startup file for remapping certain
scan codes on the keyboard. This may or may not work on your system and
has only currently been tested completely under XView, and partially
under Interactive Unix X11 release 1.0. xmodmaprc is located
in the crisp/utils directory. This program should be executed
from your \f(HB.xinitrc\fR file located in your home directory.
When installing CRISP for the first time, you will probably
need to exit X-windows and restart it for the keystrokes
to become effective.
.LI
Copy the crisp/utils/.Xdefaults file to your home directory or merge
its contents with the one you have already set up. If you are not
running Sun's version of OpenLOOK, you will have to edit this
file and remove the references to SunF37 and SunF36 (they define
two function keys unknown by the standard X11 release).
The crisp version has settings for other programs -- not
only xterm, so you may find your color scheme changed if you copy
the file as is. You should restart X-windows after installing/modifying
this file. (You can carry on without starting X-windows, but you
need to execute the command:
.DS
	xrdb -merge ~/.Xdefaults
.DE
.P
and re-spawn new xterm windows as a consequence for it to have any effect).
.LI
You should ensure that your `\f(HB.login\fR' or '\f(HB.profile\fR'
file reads the crisp/utils/crisp.csh or crisp/utils/crisp.sh file
on startup. You will need to tailor these files for your environment. The
BTERM environment variable is set up ready to run as \f(HBxcrisp\fR.
.LE
.P
If you have any problems, remember to restart your windowing system.
You can normally verify that the keyboard is operational by doing
something like this:
.DS
	% od -h
	<type keys followed by ^D>
.DE
to check the escape sequences. Also remember to have BPATH
point to your crisp macros directory.
.P
If your are running XView on the Sun and cannot find \f(HBxterm\fR
just add \f(HB$OPENWINHOME/demo\fR to your PATH environment
variable.
.H 1 "CRISP under OpenLOOK using cmd-/shelltool"
.P
BTERM should be set to \fHsun-xmodmap\fR.
The -xmodmap specifier means that you have remapped the
keyboard using xmodmap so that you can gain access to
the Alt-keys. When using this, you will need to use the
\fH<AltGraph>\fR key as the Alt key. (I have not worked out how
to get \fH<Diamond>\fR or \fH<Alt>\fR to work as an Alt key yet).

The screen doesn't look too pretty, using '-', '|' and
\'+' for the line drawing character set. But is still
fully functional.
.P
In order to use this setting, you will need to add the
following line to you your X startup file:
.DS
	xmodmap $HOME/crisp/utils/xmodmaprc 
.DE
Note that this has
only been tested on a Sun keyboard. I have not tested it
on any other version of X11.

If you do not do this, you will not get the AltGraph
keys to work.
.P
It is much more preferable to use the xterm settings described
in the previous section or the \f(HBrdetool\fR described in a later
section.
.H 1 "CRISP with crttool under SunView and XView"
.P
BTERM should be set to \fHsun-crttool\fR if you use the crttool
program under SunView. If you have a mono screen, set BTERM to
\fHsun-crttool-mono\fR. Also for a mono screen, run crttool with the
\f(HB-Cm\fR switch. If you do not do this then you will get lots
of holes on your screen.
.P
BTERM should be set to \fHsun-crttool-ansi_arrows\fR
when running crttool under XView. In this mode the
\fH<Ctrl-left-arrow>\fR and \fH<Ctrl-right-arrow>\fR
keys are available.
.P
You will also need to ensure that the BTERMCAP environment variable
points to the termcap file supplied (crisp/utils/termcap).
.P
crttool is a public domain VT200 emulator which runs
under SunView and supports the color escape sequences
needed to make crisp look pretty. The source code as I
found it is supplied for this utility. This utility
supports the Alt key using the \fH<Diamond>\fR keys. If you
use this, it may be a good idea to add
\fHcrisp/utils/.crtswrc\fH to your home directory to gain a
few extra function key entries.
.P
This utility is really brilliant under SunView but
because of the colormap flashing under Xview, you may
find it unacceptable. (I do).
.P
TERM should be set to \fHcrttool\fR when using this utility;
you'll find a termcap entry for crttool in the termcap
file (crisp/utils/termcap). Crttool needs access to the
fonts located in the \fHcrisp/utils/crttool.tar.Z\fR file. To
extract from this file, simply type: 
.DS

	zcat <crisp/utils/crttool.tar.Z | tar xvf - 

.DE
.P
You will need to
set the \fHCRTHOME\fR environment variable to the basename of
the crttool directory. E.g. if you extract the sources
as follows:
.DS

	cd /home
	zcat < crisp/utils/crttool.tar.Z | tar xvf - 

.DE
then you should set \fHCRTHOME\fR to \fH/home/crttool\fR.
.P
If this entry works for you but the arrow keys don't,
try setting \fHBTERM\fR to \fHsun-crttool-ansi_arrows\fR.
.H 1 "CRISP under OpenLOOK using rdetool"
.P
\fHrdetool\fR is a public domain replacement for Suns shelltool and
cmdtool utilities allowing access to more keys on the keyboard. If
you use this, set your BTERM environment variable to \f(HBrde\fR.
.P
You should also set TERM to \f(HBsun-cmd\fR.
.P
The source code for this utility is provided in the utils directory
(rdetool.tar.Z). Unfortunately the default Sun fonts do not
have any line drawing graphics characters and so the window borders
are simply unconnected lines. If you want these, then look at the newfont.info
file in utils. This contains a font for Sunview and Xview which does
contain a line drawing character set. If you use this entry you
will need to set BTERM to 'rde-nf'.
.H 1 "Dumb Terminal Key Bindings"
.P
The macro file dumb.cr contains a set of keybindings which attempts
to make CRISP useful in the absence of an ALT or META key.
You should execute this by aliasing cr to be 'cr -mdumb'. These key
bindings can be used in conjunction with any normal bindings.
.P
It is preferable to use this macro rather than hack the
files in src/crunch/tty with assign_to_key() statements.
.bp
.H 1 "Regression Testing"
.P
When CRISP has been modified, or is being ported to a new machine, it
is a good idea to perform a regression test to ensure that nothing
has been accidentally broken or that the new machine doesn't have
any surprises up its sleeve. CRISP contains a large number of macros
all of which help to verify that it is working correctly. In addition,
certain macros are provided to aid in regression testing. 
.VL 10
.LI regress
This macro can be executed from the command prompt. It does not do
an exhaustive test, but does check out a variety of things, especially
the list processing primitives. Unless stated otherwise (e.g. in
the README's), all tests should pass -- there should be no failures.
If you do have a failure condition, then the chances are that CRISP
may work unreliably and crash at various times, e.g. due to memory overwriting.
Also if any test fails then various other macros are liable to fail as well.
.LI perf
This macro is simply a performance measurement tool to act as a kind
of benchmark to compare processing performance with a real
application (CRISP). This test may be useful to indicate severe
performance problems due to the underlying machine architecture if the
results are not in agreement with other benchmarks (e.g. SPECmarks).
.LI demo
The demo macro is designed to wander around the user interface and
access most, if not all, loadable macros and verify the correct
operation of CRISP. It does not in itself verify correct operation -- you
the human will have to watch it to make sure it does not get stuck
in a popup or whatever.
.LE
.P
These macros should be run multiple times if possible and you
should keep an eye on the memory requirements of CRISP. The core
size of CRISP should stabilise and only increase as new macros or
objects are created. If memory starts to grow in an unbounded
manner, then this indicates some memory leakage problem. Please
note that CRISP dynamically allocates memory but never frees it, so it
should reach a suitable working size.
.H 1 "Notes on terminal Configuration"
.P
This section describes how keyboard bindings work so that the user
knows how to configure CRISP or understand what options are available
for configuration.
.P
CRISP understands the concept of function-keys and normal keys. Normal
keys are keys which simply insert there ASCII value. Function keys tend
to be keys which generate multiple characters, usually starting with
an ESCape character. These sequences tend to be referred to as
\fIescape sequences\fR.
.P
When CRISP is started, it executes a set of macros which is dependent
on the TERM and BTERM environment variable settings. These macros tell
CRISP what function keys are present on the keyboard, the escape
sequences generated by these function keys, and the macros which are
to be executed when the key is pressed.
.P
Internally, CRISP has two fundamental tables -- a table of the
escape sequences which are generated by each function key, and a table
of mappings defining what macros are to be executed when a key
is pressed. This macro table is indexed by a number which corresponds
to the key pressed. Internal key codes are 16-bits wide. All non-ASCII
characters, i.e. function keys, have an internal 16-bit code where the
top 8 bits are non-zero. This means that for foreign keyboards
which use the characters with the top bit set can input local
characters, e.g. the Icelandic people have a large character set with
characters in the range 128..255 used to represent national characters.
CRISP can handle these with impunity.
.P
The internal key codes are defined in the file \f(HBalt.h\fR in the
source directory. The encoding of keys is designed to make it 
relatively easy to convert to and from key codes to key names.
In addition, there is a lot of room for private additions.
.P
The encoding of the internal key codes is as follows:
.P
.ne 1.5i
.TS H
allbox;
c c 
lw(1.5i) lw(4i).
Range	Description
=
.TH
0x000..0x0ff	T{
Keys in this range are the normal 8-bit character set keys, with
codes 0x00..0x1f being the control characters.
T}
0x100..0x1ff	T{
This range is reserved for function keys, labelled F1..F256.
This is more than enough room for most keyboards.
T}
0x200..0x2ff	T{
This range is reserved for the keypad keys. 0x200..0x209 represent
the numeric keys on the keypad. Keys above 0x209 are used to represent
other keys on the keypad.
T}
0x300..0x3ff	T{
This is a miscellaneous range for keys which don't easily fit into
the other categories. Currently there are two \fIkeys\fR, the
\fBMouse\fR key and the \fBBack-tab\fR key.
T}
0x400..0x7ff	T{
This range is used internally by CRISP to represent multi-character
key sequences assigned via assign_to_key().
T}
0x800..0x8ff	T{
This range is reserved as the 'Private' range. This range can
be used freely by users for their own private keys not easily handled by
any of the other range types. When using int_to_key(), this range
will be encoded as '\f(HB<Private-nn>\fR'.
T}
0x900..0x9ff	T{
This range is for detecting mouse events. On windowing systems and other
machines where the mouse is supported, mouse up and down events will be
translated as if they were key presses allowing the user to use the standard
assign_to_key() macor to trap mouse events.
There are three subranges -- one for button down events, one for button up
events and one for pointer tracking events. Pointer tracking will only
occur if at least one pointer button is held down.
T}
.TE
.P
Each key code can be OR'ed with the following bits to
indicate that a modifier is being specified:
.DS
0x1000	Shift version of key, e.g. Shift-Keypad-4
0x2000	Control version of key, e.g. Ctrl-Keypad-4
0x4000	Meta or Alt version of key, e.g. Alt-Up-arrow
.DE
.P
The mapping of escape sequences (function keys) to internal key codes
is normally handled by the files in the src/crunch/tty directory, using
the set_term_keyboard() macro primitive. This mechanism allows
multiple keys on the keyboard to map to the same internal key code,
so that keys can be used interchangeably. For example, on the Sun type-4
keyboard, There are three sets of function keys - the Left keys, the Top 'Fn'
keys, and the Right function keys. Using set_term_keyboard(), it is
possible to set up the <F1> and <L1> key to be identical (i.e.
change window).
.P
The characters Ctrl-S, Ctrl-Q, and Ctrl-Z are normally not interpreted
by CRISP but by the operating system (XON/XOFF and job control keys
respectively). If the user wants to use these keys, then
the input_mode() macro will need to be called to ensure that the correct
\fIioctl()\fR is issued to disable their normal action. (See description
of \fIinput_mode()\fR macro primitive for further details).
.P
It is not normally necessary to use the internal key codes in macros --
the alt.h file can be used which contains a set of macros for accessing
the key codes, and the \fIkey_to_int()\fR and \fIint_to_key()\fR macros
may be used to convert from the internal codes to ascii strings.
.P
CRISP supports the concept of a multi-key sequence. This occurs when the
user performs an assign_to_key() call where the first argument does
not evaluate to a single key press. For example, the user could
map the string 'xyz' to a macro call. These multi-key sequences are
special in the sense that when the user hits the first character
of a multi-key sequence, CRISP will not time out trying to match
the key if the second and subsequent keystrokes are not typed within a short
delay. Multi-key sequences are only valid if each character of the sequence
is an 8-bit ascii character. For example, '1<F1>2' is not valid, since
the <F1> sequence is a 16-bit key code. Trying to assign to invalid
multi-key sequences will be ignored.
.P
CRISP attempts to support mice (or other pointer devices) by pretending
that they are a part of the keyboard. This is done by assigning keycodes
to the various events that can happen. This allows macro writers to
use all the primitives available for keystroke handling to also handle mouse
events. The amount of support for mice depends very much on the actual 
operating system environment. CRISP attempts to follow the X11 system
and nomenclature. 
.H 1 Problems
.P
This section describes typical problems seen when trying to get CRISP to
run and/or compile.
.H 2 "Display Problems"
.P
CRISP prints the following message during startup:
.P
.DS
*** CRISP has failed to locate the 'crisp.cm' startup macro.
*** This is due to either your environment variable BPATH
*** not being setup properly or you have not compiled the macros.
.DE
.in +1i
.P
This message is printed to indicate that the macro file crisp.cm could
not be located. This macro file is normally located in the crisp/macros
directory. You should check that the BPATH environment variable
points to this directory and that the macro files have been compiled
if you have just installed a new version of CRISP.
.in
.P
CRISP starts up with but displays the border around the windows with
lots of characters that look like: 'xB0xBqB0qB0qB0...'.
.in +1i
.P
This indicates that CRISP thinks you have a VT-100 compatible line drawing
character set and is sending the escape sequence to draw the border.
This problem is due to your BTERM environment variable not
being set or set incorrectly.
.in
.P
CRISP starts up but doesn't draw any border but displays the status
line correctly and the buffer name at the top left hand corner of the screen.
.in +1i
.P
This is due to the BTERM environment variable not being set properly.
CRISP is probably using the PC character set for drawing the borders
of the windows on a system which doesn't support this. Please
ensure that BTERM is set correctly.
.in
.P
When using crttool on a mono screen, lots of holes appear and the
hilighted areas are not drawn properly.
.in +1i
.P
You should append the string '-mono' to the end of BTERM. Also
you should make sure you run the crttool utility with the -Cm
switch.
.in
.H 2 "Keyboard mapping Problems"
.P
When using 'xterm' with BTERM=xterm, only the arrow keys
work -- the other keys on the keyboard generate funny sequences
or just move the cursor. Also the <Alt> keys don't seem to work
properly.
.in +1i
.P
This is usually due to a number of problems. Please check your ~/.Xdefaults
file (copy the one in crisp/utils if necessary). You may need to
restart your windowing system for this to have an effect.
.P
You should run xterm with the Sun keyboard mappings (i.e. not the
vt100 ones). This gives you access to all the keypad keys. This
will happen if you use the supplied .Xdefaults file. Alternatively
start xterm with the '-sf' switch.
.P
The BTERM environment variable should have '-sf' tacked on to the
end of it, e.g. 'xterm-sf'.
.in
.P
CRISP runs with the keypad keys but the <Alt-letter> keys do not
work.
.P
.in +1i
You should remap the keyboard using 'xmodmap crisp/utils/xmodmaprc'.
.P
Keyboard does not understand <Ctrl-S>, <Ctrl-Q>, or <Ctrl-Z>. For
example <Ctrl-Z> causes CRISP to stop.
.P
These keys by default have their normal system action. Ctrl-S/Ctrl-Q
are the XON/XOFF characters. These are enabled in case the user
is executing on a slow dumb terminal. <Ctrl-Z> is commonly
used as the stop signal on systems that support job control.
Some people like to use any of these keys for different purposes.
CRISP supports the ability to map these characters so that CRISP
can use them as function keys. In order to do this, it is necessary
to call the \f(HBinput_mode()\fR macro. (See the manual page for
a complete description of this primitive).
.P
The input_mode() macro allows these operating system sensitive
characters to be passed directly to CRISP. If you are going
to use the assign_to_key() macro to map these keys, then you need
to ensure you all input_mode() with the character you want to be
passed to CRISP.
.in
.P
You are using CRISP under X11 but cannot understand the instructions.
.P
.in +1i
Please consult the various sections describing how to use 'xterm' and 'xcrisp'.
They are a bit haphazard, but the information in all sections may lead
you to an understanding of what is wrong.
.in
.H 2 "Environment Problems"
.P
When starting an xterm after installing the supplied \f(HB.Xdefaults\fR
file, error messages are printed complaining about unknown
keysyms \f(HBSunF36\fR and \f(HBSunF37\fR.
.in +1i
.P
You are not running OpenLOOK, and therefore you should delete these
entries from the .Xdefaults file. Suns version of X11 supports the
extra keys on their type-4 keyboard. Other X11 implementations do
not understand these key names.
.in
.TC
