# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementSqlVulnerabilityAssessmentRuleBaselineOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_vulnerability_assessment_rule_baseline_list_by_baseline(self, resource_group):
        response = self.client.sql_vulnerability_assessment_rule_baseline.list_by_baseline(
            resource_group_name=resource_group.name,
            server_name="str",
            vulnerability_assessment_name="str",
            baseline_name="str",
            system_database_name="master",
            api_version="2022-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_vulnerability_assessment_rule_baseline_get(self, resource_group):
        response = await self.client.sql_vulnerability_assessment_rule_baseline.get(
            resource_group_name=resource_group.name,
            server_name="str",
            vulnerability_assessment_name="str",
            baseline_name="str",
            rule_id="str",
            system_database_name="master",
            api_version="2022-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_vulnerability_assessment_rule_baseline_create_or_update(self, resource_group):
        response = await self.client.sql_vulnerability_assessment_rule_baseline.create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            vulnerability_assessment_name="str",
            baseline_name="str",
            rule_id="str",
            parameters={
                "id": "str",
                "latestScan": bool,
                "name": "str",
                "results": [["str"]],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            system_database_name="master",
            api_version="2022-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...
