# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ClinicalDocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the clinical document."""

    CONSULTATION = "consultation"
    DISCHARGE_SUMMARY = "dischargeSummary"
    HISTORY_AND_PHYSICAL = "historyAndPhysical"
    PROCEDURE = "procedure"
    PROGRESS = "progress"
    IMAGING = "imaging"
    LABORATORY = "laboratory"
    PATHOLOGY = "pathology"


class DocumentContentSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the content's source.
    In case the source type is 'inline', the content is given as a string (for instance, text).
    In case the source type is 'reference', the content is given as a URI.
    """

    INLINE = "inline"
    REFERENCE = "reference"


class DocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the patient document, such as 'note' (text document) or 'fhirBundle' (FHIR JSON
    document).
    """

    NOTE = "note"
    FHIR_BUNDLE = "fhirBundle"
    DICOM = "dicom"
    GENOMIC_SEQUENCING = "genomicSequencing"


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the processing job."""

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    PARTIALLY_COMPLETED = "partiallyCompleted"


class OncoPhenotypeInferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the Onco Phenotype inference."""

    TUMOR_SITE = "tumorSite"
    HISTOLOGY = "histology"
    CLINICAL_STAGE_T = "clinicalStageT"
    CLINICAL_STAGE_N = "clinicalStageN"
    CLINICAL_STAGE_M = "clinicalStageM"
    PATHOLOGIC_STAGE_T = "pathologicStageT"
    PATHOLOGIC_STAGE_N = "pathologicStageN"
    PATHOLOGIC_STAGE_M = "pathologicStageM"


class PatientInfoSex(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The patient's sex."""

    FEMALE = "female"
    MALE = "male"
    UNSPECIFIED = "unspecified"


class RepeatabilityResultType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of RepeatabilityResultType."""

    ACCEPTED = "accepted"
    REJECTED = "rejected"
