# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AcceptanceMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode of acceptance for an agreement."""

    CLICK_TO_ACCEPT = "ClickToAccept"
    E_SIGN_EMBEDDED = "ESignEmbedded"
    E_SIGN_OFFLINE = "ESignOffline"


class AccountStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the billing account."""

    ACTIVE = "Active"
    DELETED = "Deleted"
    DISABLED = "Disabled"
    EXPIRED = "Expired"
    TRANSFERRED = "Transferred"
    EXTENDED = "Extended"
    TERMINATED = "Terminated"


class AccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of customer."""

    ENTERPRISE = "Enterprise"
    INDIVIDUAL = "Individual"
    PARTNER = "Partner"


class AddressValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the address validation."""

    VALID = "Valid"
    INVALID = "Invalid"


class AgreementType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of agreement."""

    MICROSOFT_CUSTOMER_AGREEMENT = "MicrosoftCustomerAgreement"
    ENTERPRISE_AGREEMENT = "EnterpriseAgreement"
    MICROSOFT_ONLINE_SERVICES_PROGRAM = "MicrosoftOnlineServicesProgram"
    MICROSOFT_PARTNER_AGREEMENT = "MicrosoftPartnerAgreement"


class AutoRenew(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether auto renewal is turned on or off for a product."""

    OFF = "Off"
    ON = "On"


class BillingFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The frequency at which the product will be billed."""

    ONE_TIME = "OneTime"
    MONTHLY = "Monthly"
    USAGE_BASED = "UsageBased"


class BillingProfileSpendingLimit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The billing profile spending limit."""

    OFF = "Off"
    ON = "On"


class BillingProfileStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the billing profile."""

    ACTIVE = "Active"
    DISABLED = "Disabled"
    WARNED = "Warned"


class BillingProfileStatusReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason for the specified billing profile status."""

    PAST_DUE = "PastDue"
    SPENDING_LIMIT_REACHED = "SpendingLimitReached"
    SPENDING_LIMIT_EXPIRED = "SpendingLimitExpired"


class BillingRelationshipType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifies which services and purchases are paid by a billing profile."""

    DIRECT = "Direct"
    INDIRECT_CUSTOMER = "IndirectCustomer"
    INDIRECT_PARTNER = "IndirectPartner"
    CSP_PARTNER = "CSPPartner"


class BillingSubscriptionStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current billing status of the subscription."""

    ACTIVE = "Active"
    INACTIVE = "Inactive"
    ABANDONED = "Abandoned"
    DELETED = "Deleted"
    WARNING = "Warning"


class Category(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The category of the agreement signed by a customer."""

    MICROSOFT_CUSTOMER_AGREEMENT = "MicrosoftCustomerAgreement"
    AFFILIATE_PURCHASE_TERMS = "AffiliatePurchaseTerms"
    OTHER = "Other"


class DocumentSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The source of the document. ENF for Brazil and DRS for rest of the world."""

    DRS = "DRS"
    ENF = "ENF"


class DocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the document."""

    INVOICE = "Invoice"
    VOID_NOTE = "VoidNote"
    TAX_RECEIPT = "TaxReceipt"
    CREDIT_NOTE = "CreditNote"


class InvoiceDocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the document."""

    INVOICE = "Invoice"
    CREDIT_NOTE = "CreditNote"


class InvoiceSectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifies the state of an invoice section."""

    ACTIVE = "Active"
    RESTRICTED = "Restricted"


class InvoiceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the invoice."""

    DUE = "Due"
    OVER_DUE = "OverDue"
    PAID = "Paid"
    VOID = "Void"


class InvoiceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Invoice type."""

    AZURE_SERVICE = "AzureService"
    AZURE_MARKETPLACE = "AzureMarketplace"
    AZURE_SUPPORT = "AzureSupport"


class MarketplacePurchasesPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The policy that controls whether Azure marketplace purchases are allowed for a billing profile."""

    ALL_ALLOWED = "AllAllowed"
    ONLY_FREE_ALLOWED = "OnlyFreeAllowed"
    NOT_ALLOWED = "NotAllowed"


class PaymentMethodFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The family of payment method."""

    CREDITS = "Credits"
    CHECK_WIRE = "CheckWire"
    CREDIT_CARD = "CreditCard"
    NONE = "None"


class ProductStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the product."""

    ACTIVE = "Active"
    INACTIVE = "Inactive"
    PAST_DUE = "PastDue"
    EXPIRING = "Expiring"
    EXPIRED = "Expired"
    DISABLED = "Disabled"
    CANCELLED = "Cancelled"
    AUTO_RENEW = "AutoRenew"


class ProductTransferValidationErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Error code of the transfer validation response."""

    INVALID_SOURCE = "InvalidSource"
    PRODUCT_NOT_ACTIVE = "ProductNotActive"
    INSUFFICIENT_PERMISSION_ON_SOURCE = "InsufficientPermissionOnSource"
    INSUFFICIENT_PERMISSION_ON_DESTINATION = "InsufficientPermissionOnDestination"
    DESTINATION_BILLING_PROFILE_PAST_DUE = "DestinationBillingProfilePastDue"
    PRODUCT_TYPE_NOT_SUPPORTED = "ProductTypeNotSupported"
    CROSS_BILLING_ACCOUNT_NOT_ALLOWED = "CrossBillingAccountNotAllowed"
    NOT_AVAILABLE_FOR_DESTINATION_MARKET = "NotAvailableForDestinationMarket"
    ONE_TIME_PURCHASE_PRODUCT_TRANSFER_NOT_ALLOWED = "OneTimePurchaseProductTransferNotAllowed"


class ReservationPurchasesPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The policy that controls whether Azure reservation purchases are allowed for a billing profile."""

    ALLOWED = "Allowed"
    NOT_ALLOWED = "NotAllowed"


class ReservationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of transaction."""

    PURCHASE = "Purchase"
    USAGE_CHARGE = "Usage Charge"


class SpendingLimit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The billing profile spending limit."""

    OFF = "Off"
    ON = "On"


class SpendingLimitForBillingProfile(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The billing profile spending limit."""

    OFF = "Off"
    ON = "On"


class StatusReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason for the specified billing profile status."""

    PAST_DUE = "PastDue"
    SPENDING_LIMIT_REACHED = "SpendingLimitReached"
    SPENDING_LIMIT_EXPIRED = "SpendingLimitExpired"


class StatusReasonCodeForBillingProfile(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason for the specified billing profile status."""

    PAST_DUE = "PastDue"
    SPENDING_LIMIT_REACHED = "SpendingLimitReached"
    SPENDING_LIMIT_EXPIRED = "SpendingLimitExpired"


class SubscriptionTransferValidationErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Error code of the transfer validation response."""

    BILLING_ACCOUNT_INACTIVE = "BillingAccountInactive"
    CROSS_BILLING_ACCOUNT_NOT_ALLOWED = "CrossBillingAccountNotAllowed"
    DESTINATION_BILLING_PROFILE_INACTIVE = "DestinationBillingProfileInactive"
    DESTINATION_BILLING_PROFILE_NOT_FOUND = "DestinationBillingProfileNotFound"
    DESTINATION_BILLING_PROFILE_PAST_DUE = "DestinationBillingProfilePastDue"
    DESTINATION_INVOICE_SECTION_INACTIVE = "DestinationInvoiceSectionInactive"
    DESTINATION_INVOICE_SECTION_NOT_FOUND = "DestinationInvoiceSectionNotFound"
    INSUFFICIENT_PERMISSION_ON_DESTINATION = "InsufficientPermissionOnDestination"
    INSUFFICIENT_PERMISSION_ON_SOURCE = "InsufficientPermissionOnSource"
    INVALID_DESTINATION = "InvalidDestination"
    INVALID_SOURCE = "InvalidSource"
    MARKETPLACE_NOT_ENABLED_ON_DESTINATION = "MarketplaceNotEnabledOnDestination"
    NOT_AVAILABLE_FOR_DESTINATION_MARKET = "NotAvailableForDestinationMarket"
    PRODUCT_INACTIVE = "ProductInactive"
    PRODUCT_NOT_FOUND = "ProductNotFound"
    PRODUCT_TYPE_NOT_SUPPORTED = "ProductTypeNotSupported"
    SOURCE_BILLING_PROFILE_PAST_DUE = "SourceBillingProfilePastDue"
    SOURCE_INVOICE_SECTION_INACTIVE = "SourceInvoiceSectionInactive"
    SUBSCRIPTION_NOT_ACTIVE = "SubscriptionNotActive"
    SUBSCRIPTION_TYPE_NOT_SUPPORTED = "SubscriptionTypeNotSupported"


class TargetCloud(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible cloud environments."""

    US_GOV = "USGov"
    US_NAT = "USNat"
    US_SEC = "USSec"


class TransactionTypeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of transaction. Options are all or reservation."""

    ALL = "all"
    RESERVATION = "reservation"


class ViewCharges(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The policy that controls whether the users in customer's organization can view charges at
    pay-as-you-go prices.
    """

    ALLOWED = "Allowed"
    NOT_ALLOWED = "NotAllowed"


class ViewChargesPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The policy that controls whether users with Azure RBAC access to a subscription can view its
    charges.
    """

    ALLOWED = "Allowed"
    NOT_ALLOWED = "NotAllowed"
