/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class QuestionRecord {
    private String qName;
    private int qType;
    private int qClass;

    public QuestionRecord() {
    }

    public QuestionRecord(String qName, int qType, int qClass) {
        this.qName = qName;
        this.qType = qType;
        this.qClass = qClass;
    }

    public int writeBytes(byte[] buffer, int startIdx) throws DomainProtocolException {
        int idx = startIdx;
        if (buffer == null) {
            throw new DomainProtocolException(Messages.getString("jndi.32"));
        }
        if (startIdx >= buffer.length || startIdx < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        idx = ProviderMgr.writeName(this.qName, buffer, idx);
        idx = ProviderMgr.write16Int(this.qType, buffer, idx);
        idx = ProviderMgr.write16Int(this.qClass, buffer, idx);
        return idx;
    }

    public static int parseRecord(byte[] mesBytes, int startIdx, QuestionRecord resultQR) throws DomainProtocolException {
        int idx = startIdx;
        StringBuffer nameSB = new StringBuffer();
        if (resultQR == null) {
            throw new NullPointerException(Messages.getString("jndi.33"));
        }
        idx = ProviderMgr.parseName(mesBytes, idx, nameSB);
        resultQR.setQName(nameSB.toString());
        resultQR.setQType(ProviderMgr.parse16Int(mesBytes, idx));
        resultQR.setQClass(ProviderMgr.parse16Int(mesBytes, idx += 2));
        return idx += 2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String qTypeStr = this.qType > 0 && this.qType < 256 ? ProviderConstants.rrTypeNames[this.qType] : String.valueOf(this.qType);
        String qClassStr = this.qClass > 0 && this.qClass < 256 ? ProviderConstants.rrClassNames[this.qClass] : String.valueOf(this.qClass);
        sb.append(qClassStr);
        sb.append(" ");
        sb.append(qTypeStr);
        sb.append(" ");
        sb.append(this.qName);
        return sb.toString();
    }

    public int getQClass() {
        return this.qClass;
    }

    public void setQClass(int class1) {
        this.qClass = class1;
    }

    public String getQName() {
        return this.qName;
    }

    public void setQName(String name) {
        this.qName = name;
    }

    public int getQType() {
        return this.qType;
    }

    public void setQType(int type) {
        this.qType = type;
    }
}

