# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python arc_machine_baseline_rules_put_latest.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.sql_vulnerability_assessment_baseline_rules.create_or_update(
        rule_id="VA1234",
        workspace_id="55555555-6666-7777-8888-999999999999",
        resource_id="subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master",
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_PutLatest.json
if __name__ == "__main__":
    main()
