/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.xml.tools.java.generator;

import java.awt.event.ActionEvent;
import java.util.*;
import java.text.DateFormat;

import org.openide.filesystems.FileObject;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.EditCookie;
import org.openide.loaders.*;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class GenerateSupportUtils {

    /**
     * Use some heuristics and create valid java name.
     */
    public static String getJavaName (String name) {
        StringTokenizer st = new StringTokenizer (name, " -.:"); // NOI18N
        StringBuffer sb = new StringBuffer ();
        if (st.hasMoreTokens()) {
            sb.append (st.nextToken());
            while (st.hasMoreTokens()) {
                sb.append ("_").append (st.nextToken()); // NOI18N
            }
        }
        return sb.toString();
    }


    /*
     * Generate default java header.
     * @param primFile a model used for generated code or null
     */
    public static String getJavaFileHeader (String name, FileObject primFile) {
        Date now = new Date();

        StringBuffer sb = new StringBuffer ();
        sb.append("/*\n * File:           ").append (name).append (".java"); // NOI18N
        if (primFile != null) {
            sb.append ("\n * Generated from: ").append (primFile.getName()).append (".").append (primFile.getExt()); // NOI18N
        }
        sb.append("\n * Date:           ").append (DateFormat.getDateInstance (DateFormat.LONG).format (now)); // NOI18N
        sb.append ("  ").append (DateFormat.getTimeInstance (DateFormat.SHORT).format (now)); // NOI18N
        sb.append("\n *"); // NOI18N
        sb.append("\n * @author  ").append(System.getProperty ("user.name")); // NOI18N
        sb.append("\n * @version generated by NetBeans XML module"); // NOI18N
        sb.append("\n */"); // NOI18N
        return sb.toString();
    }
    
//      public static final void debug(String msg, Throwable ex) {
//          if (Boolean.getBoolean("netbeans.debug.xml")) { // NOI18N
//              System.err.println(msg);
//              ex.printStackTrace();
//          }
//      }

    
    /**
     * Test whether given identifier is valid Java return type
     */
    public static boolean isValidReturnType(String value) {
        
        if (value == null || "".equals(value)) return false; // NOI18N
        int length = value.length();
        
        // check for arrays e.g. "String[][]"
        while (length > 2 && value.charAt(length-2) == '[' && value.charAt(length-1) == ']') {
            value = value.substring(0, length-2);
            length -= 2;
        }
        
        if (value.charAt(0) == '.' || value.charAt(value.length()-1) == '.')
            return false;
        
        for(int i=1; i<length-2; i++) {
            if (value.charAt(i) == '.' && value.charAt(i+1) == '.')
                return false;
        }
        
                    
        StringTokenizer st = new StringTokenizer(value, "."); // NOI18N
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!!!isPrimitiveType(token) && !!!Utilities.isJavaIdentifier(token))
                return false;
        }
        return true;
    }

    /**
     * @return true if given value does represent Java primitive type.
     */
    public static boolean isPrimitiveType(String value) {

        String val[] = {"int", "char", "boolean", "long", "float", "double", "void"}; // NOI18N
        for(int i=0;i<val.length;i++) {
            if(val[i].equals(value))
                return true;
        }
        return false;
    }            
    
}
