/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import alt.jiapi.file.Attribute;
import alt.jiapi.file.ConstantPool;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class LocalVariableTableAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "LocalVariableTable";
    private List localVariables = new LinkedList();

    public LocalVariableTableAttribute(ConstantPool cp) {
        super(cp.addUtf8Info(ATTRIBUTE_NAME).getEntryIndex());
        this.setConstantPool(cp);
    }

    LocalVariableTableAttribute(short nameIndex, DataInputStream dis) throws IOException {
        super(nameIndex);
        int l = dis.readShort();
        for (int i = 0; i < l; ++i) {
            short start_pc = dis.readShort();
            short length = dis.readShort();
            short name_index = dis.readShort();
            short descriptor_index = dis.readShort();
            short index = dis.readShort();
            this.localVariables.add(new LocalVariable(start_pc, length, name_index, descriptor_index, index));
        }
    }

    public List getLocalVariables() {
        return this.localVariables;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.localVariables.size());
            for (LocalVariable lvte : this.localVariables) {
                dos.writeShort(lvte.getStartPc());
                dos.writeShort(lvte.getLength());
                dos.writeShort(lvte.getNameIndex());
                dos.writeShort(lvte.getDescriptorIndex());
                dos.writeShort(lvte.getIndex());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public class LocalVariable {
        private short start_pc;
        private short length;
        private short name_index;
        private short descriptor_index;
        private short index;

        LocalVariable(short start_pc, short length, short name_index, short descriptor_index, short index) {
            this.start_pc = start_pc;
            this.length = length;
            this.name_index = name_index;
            this.descriptor_index = descriptor_index;
            this.index = index;
        }

        public short getStartPc() {
            return this.start_pc;
        }

        public short getLength() {
            return this.length;
        }

        public String getName() {
            return LocalVariableTableAttribute.this.cp.getUtf8(this.name_index);
        }

        short getNameIndex() {
            return this.name_index;
        }

        public String getDescriptor() {
            return LocalVariableTableAttribute.this.cp.getUtf8(this.descriptor_index);
        }

        short getDescriptorIndex() {
            return this.descriptor_index;
        }

        public short getIndex() {
            return this.index;
        }
    }
}

