import OCP.UnitsMethods
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
__all__  = [
"UnitsMethods",
"UnitsMethods_LengthUnit",
"UnitsMethods_LengthUnit_Centimeter",
"UnitsMethods_LengthUnit_Foot",
"UnitsMethods_LengthUnit_Inch",
"UnitsMethods_LengthUnit_Kilometer",
"UnitsMethods_LengthUnit_Meter",
"UnitsMethods_LengthUnit_Microinch",
"UnitsMethods_LengthUnit_Micron",
"UnitsMethods_LengthUnit_Mil",
"UnitsMethods_LengthUnit_Mile",
"UnitsMethods_LengthUnit_Millimeter",
"UnitsMethods_LengthUnit_Undefined"
]
class UnitsMethods():
    """
    Class for using global units variables
    """
    @staticmethod
    @overload
    def DumpLengthUnit_s(theScaleFactor : float,theBaseUnit : UnitsMethods_LengthUnit=UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter) -> str: 
        """
        Returns string name for the given scale factor

        Returns string for the given value of LengthUnit
        """
    @staticmethod
    @overload
    def DumpLengthUnit_s(theUnit : UnitsMethods_LengthUnit) -> str: ...
    @staticmethod
    def GetCasCadeLengthUnit_s(theBaseUnit : UnitsMethods_LengthUnit=UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter) -> float: 
        """
        Returns value of current internal unit for CASCADE in millemeters by default
        """
    @staticmethod
    def GetLengthFactorValue_s(theUnit : int) -> float: 
        """
        Returns value of unit encoded by parameter theUnit (integer value denoting unit, as described in IGES standard) in millimeters by default
        """
    @staticmethod
    def GetLengthUnitByFactorValue_s(theFactorValue : float,theBaseUnit : UnitsMethods_LengthUnit=UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter) -> UnitsMethods_LengthUnit: 
        """
        Returns the enumeration corresponding to the given scale factor
        """
    @staticmethod
    def GetLengthUnitScale_s(theFromUnit : UnitsMethods_LengthUnit,theToUnit : UnitsMethods_LengthUnit) -> float: 
        """
        Returns the scale factor for switch from first given unit to second given unit
        """
    @staticmethod
    def LengthUnitFromString_s(theStr : str,theCaseSensitive : bool) -> UnitsMethods_LengthUnit: 
        """
        Make conversion of given string to value of LengthUnit
        """
    @staticmethod
    @overload
    def SetCasCadeLengthUnit_s(theUnitValue : float,theBaseUnit : UnitsMethods_LengthUnit=UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter) -> None: 
        """
        Sets value of current internal unit for CASCADE

        Sets value of current internal unit for CASCADE by parameter theUnit (integer value denoting unit, as described in IGES standard)
        """
    @staticmethod
    @overload
    def SetCasCadeLengthUnit_s(theUnit : int) -> None: ...
    def __init__(self) -> None: ...
    pass
class UnitsMethods_LengthUnit():
    """
    The Enumeration describes possible values for length units

    Members:

      UnitsMethods_LengthUnit_Undefined

      UnitsMethods_LengthUnit_Inch

      UnitsMethods_LengthUnit_Millimeter

      UnitsMethods_LengthUnit_Foot

      UnitsMethods_LengthUnit_Mile

      UnitsMethods_LengthUnit_Meter

      UnitsMethods_LengthUnit_Kilometer

      UnitsMethods_LengthUnit_Mil

      UnitsMethods_LengthUnit_Micron

      UnitsMethods_LengthUnit_Centimeter

      UnitsMethods_LengthUnit_Microinch
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    UnitsMethods_LengthUnit_Centimeter: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Centimeter: 10>
    UnitsMethods_LengthUnit_Foot: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Foot: 4>
    UnitsMethods_LengthUnit_Inch: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Inch: 1>
    UnitsMethods_LengthUnit_Kilometer: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Kilometer: 7>
    UnitsMethods_LengthUnit_Meter: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Meter: 6>
    UnitsMethods_LengthUnit_Microinch: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Microinch: 11>
    UnitsMethods_LengthUnit_Micron: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Micron: 9>
    UnitsMethods_LengthUnit_Mil: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mil: 8>
    UnitsMethods_LengthUnit_Mile: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mile: 5>
    UnitsMethods_LengthUnit_Millimeter: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter: 2>
    UnitsMethods_LengthUnit_Undefined: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Undefined: 0>
    __entries: dict # value = {'UnitsMethods_LengthUnit_Undefined': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Undefined: 0>, None), 'UnitsMethods_LengthUnit_Inch': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Inch: 1>, None), 'UnitsMethods_LengthUnit_Millimeter': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter: 2>, None), 'UnitsMethods_LengthUnit_Foot': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Foot: 4>, None), 'UnitsMethods_LengthUnit_Mile': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mile: 5>, None), 'UnitsMethods_LengthUnit_Meter': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Meter: 6>, None), 'UnitsMethods_LengthUnit_Kilometer': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Kilometer: 7>, None), 'UnitsMethods_LengthUnit_Mil': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mil: 8>, None), 'UnitsMethods_LengthUnit_Micron': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Micron: 9>, None), 'UnitsMethods_LengthUnit_Centimeter': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Centimeter: 10>, None), 'UnitsMethods_LengthUnit_Microinch': (<UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Microinch: 11>, None)}
    __members__: dict # value = {'UnitsMethods_LengthUnit_Undefined': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Undefined: 0>, 'UnitsMethods_LengthUnit_Inch': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Inch: 1>, 'UnitsMethods_LengthUnit_Millimeter': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter: 2>, 'UnitsMethods_LengthUnit_Foot': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Foot: 4>, 'UnitsMethods_LengthUnit_Mile': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mile: 5>, 'UnitsMethods_LengthUnit_Meter': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Meter: 6>, 'UnitsMethods_LengthUnit_Kilometer': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Kilometer: 7>, 'UnitsMethods_LengthUnit_Mil': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mil: 8>, 'UnitsMethods_LengthUnit_Micron': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Micron: 9>, 'UnitsMethods_LengthUnit_Centimeter': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Centimeter: 10>, 'UnitsMethods_LengthUnit_Microinch': <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Microinch: 11>}
    pass
UnitsMethods_LengthUnit_Centimeter: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Centimeter: 10>
UnitsMethods_LengthUnit_Foot: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Foot: 4>
UnitsMethods_LengthUnit_Inch: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Inch: 1>
UnitsMethods_LengthUnit_Kilometer: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Kilometer: 7>
UnitsMethods_LengthUnit_Meter: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Meter: 6>
UnitsMethods_LengthUnit_Microinch: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Microinch: 11>
UnitsMethods_LengthUnit_Micron: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Micron: 9>
UnitsMethods_LengthUnit_Mil: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mil: 8>
UnitsMethods_LengthUnit_Mile: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Mile: 5>
UnitsMethods_LengthUnit_Millimeter: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Millimeter: 2>
UnitsMethods_LengthUnit_Undefined: OCP.UnitsMethods.UnitsMethods_LengthUnit # value = <UnitsMethods_LengthUnit.UnitsMethods_LengthUnit_Undefined: 0>
