# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin

from ._configuration import ContainerServiceClientConfiguration
from ._serialization import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential

class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implementation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class ContainerServiceClient(MultiApiClientMixin, _SDKClient):
    """The Container Service Client.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param base_url: Service URL
    :type base_url: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2025-03-01'
    _PROFILE_TAG = "azure.mgmt.containerservice.ContainerServiceClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'container_service': '2025-02-02-preview',
            'container_services': '2017-07-01',
            'load_balancers': '2025-02-02-preview',
            'managed_cluster_snapshots': '2025-02-02-preview',
            'namespaces': '2025-02-02-preview',
            'open_shift_managed_clusters': '2019-09-30-preview',
            'operation_status_result': '2025-02-02-preview',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        api_version: Optional[str]=None,
        base_url: Optional[str] = None,
        profile: KnownProfiles=KnownProfiles.default,
        **kwargs: Any
    ):
        if api_version:
            kwargs.setdefault('api_version', api_version)
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = ContainerServiceClientConfiguration(credential, subscription_id, credential_scopes=credential_scopes, **kwargs)
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, base_url), policies=_policies, **kwargs)
        super(ContainerServiceClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2017-07-01: :mod:`v2017_07_01.models<azure.mgmt.containerservice.v2017_07_01.models>`
           * 2019-09-30-preview: :mod:`v2019_09_30_preview.models<azure.mgmt.containerservice.v2019_09_30_preview.models>`
           * 2020-03-01: :mod:`v2020_03_01.models<azure.mgmt.containerservice.v2020_03_01.models>`
           * 2020-11-01: :mod:`v2020_11_01.models<azure.mgmt.containerservice.v2020_11_01.models>`
           * 2025-02-02-preview: :mod:`v2025_02_02_preview.models<azure.mgmt.containerservice.v2025_02_02_preview.models>`
           * 2025-03-01: :mod:`v2025_03_01.models<azure.mgmt.containerservice.v2025_03_01.models>`
        """
        if api_version == '2017-07-01':
            from .v2017_07_01 import models
            return models
        elif api_version == '2019-09-30-preview':
            from .v2019_09_30_preview import models
            return models
        elif api_version == '2020-03-01':
            from .v2020_03_01 import models
            return models
        elif api_version == '2020-11-01':
            from .v2020_11_01 import models
            return models
        elif api_version == '2025-02-02-preview':
            from .v2025_02_02_preview import models
            return models
        elif api_version == '2025-03-01':
            from .v2025_03_01 import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def agent_pools(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`AgentPoolsOperations<azure.mgmt.containerservice.v2020_03_01.operations.AgentPoolsOperations>`
           * 2020-11-01: :class:`AgentPoolsOperations<azure.mgmt.containerservice.v2020_11_01.operations.AgentPoolsOperations>`
           * 2025-02-02-preview: :class:`AgentPoolsOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.AgentPoolsOperations>`
           * 2025-03-01: :class:`AgentPoolsOperations<azure.mgmt.containerservice.v2025_03_01.operations.AgentPoolsOperations>`
        """
        api_version = self._get_api_version('agent_pools')
        if api_version == '2020-03-01':
            from .v2020_03_01.operations import AgentPoolsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AgentPoolsOperations as OperationClass
        elif api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import AgentPoolsOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import AgentPoolsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'agent_pools'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def container_service(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`ContainerServiceOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.ContainerServiceOperations>`
        """
        api_version = self._get_api_version('container_service')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import ContainerServiceOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'container_service'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def container_services(self):
        """Instance depends on the API version:

           * 2017-07-01: :class:`ContainerServicesOperations<azure.mgmt.containerservice.v2017_07_01.operations.ContainerServicesOperations>`
        """
        api_version = self._get_api_version('container_services')
        if api_version == '2017-07-01':
            from .v2017_07_01.operations import ContainerServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'container_services'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def load_balancers(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`LoadBalancersOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.LoadBalancersOperations>`
        """
        api_version = self._get_api_version('load_balancers')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import LoadBalancersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancers'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def machines(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`MachinesOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.MachinesOperations>`
           * 2025-03-01: :class:`MachinesOperations<azure.mgmt.containerservice.v2025_03_01.operations.MachinesOperations>`
        """
        api_version = self._get_api_version('machines')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import MachinesOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import MachinesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'machines'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def maintenance_configurations(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`MaintenanceConfigurationsOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.MaintenanceConfigurationsOperations>`
           * 2025-03-01: :class:`MaintenanceConfigurationsOperations<azure.mgmt.containerservice.v2025_03_01.operations.MaintenanceConfigurationsOperations>`
        """
        api_version = self._get_api_version('maintenance_configurations')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import MaintenanceConfigurationsOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import MaintenanceConfigurationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'maintenance_configurations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def managed_cluster_snapshots(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`ManagedClusterSnapshotsOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.ManagedClusterSnapshotsOperations>`
        """
        api_version = self._get_api_version('managed_cluster_snapshots')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import ManagedClusterSnapshotsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'managed_cluster_snapshots'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def managed_clusters(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`ManagedClustersOperations<azure.mgmt.containerservice.v2020_03_01.operations.ManagedClustersOperations>`
           * 2020-11-01: :class:`ManagedClustersOperations<azure.mgmt.containerservice.v2020_11_01.operations.ManagedClustersOperations>`
           * 2025-02-02-preview: :class:`ManagedClustersOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.ManagedClustersOperations>`
           * 2025-03-01: :class:`ManagedClustersOperations<azure.mgmt.containerservice.v2025_03_01.operations.ManagedClustersOperations>`
        """
        api_version = self._get_api_version('managed_clusters')
        if api_version == '2020-03-01':
            from .v2020_03_01.operations import ManagedClustersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ManagedClustersOperations as OperationClass
        elif api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import ManagedClustersOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import ManagedClustersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'managed_clusters'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def namespaces(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`NamespacesOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.NamespacesOperations>`
        """
        api_version = self._get_api_version('namespaces')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import NamespacesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'namespaces'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def open_shift_managed_clusters(self):
        """Instance depends on the API version:

           * 2019-09-30-preview: :class:`OpenShiftManagedClustersOperations<azure.mgmt.containerservice.v2019_09_30_preview.operations.OpenShiftManagedClustersOperations>`
        """
        api_version = self._get_api_version('open_shift_managed_clusters')
        if api_version == '2019-09-30-preview':
            from .v2019_09_30_preview.operations import OpenShiftManagedClustersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'open_shift_managed_clusters'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def operation_status_result(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`OperationStatusResultOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.OperationStatusResultOperations>`
        """
        api_version = self._get_api_version('operation_status_result')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import OperationStatusResultOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operation_status_result'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`Operations<azure.mgmt.containerservice.v2020_03_01.operations.Operations>`
           * 2020-11-01: :class:`Operations<azure.mgmt.containerservice.v2020_11_01.operations.Operations>`
           * 2025-02-02-preview: :class:`Operations<azure.mgmt.containerservice.v2025_02_02_preview.operations.Operations>`
           * 2025-03-01: :class:`Operations<azure.mgmt.containerservice.v2025_03_01.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2020-03-01':
            from .v2020_03_01.operations import Operations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import Operations as OperationClass
        elif api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import Operations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import Operations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def private_endpoint_connections(self):
        """Instance depends on the API version:

           * 2020-11-01: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerservice.v2020_11_01.operations.PrivateEndpointConnectionsOperations>`
           * 2025-02-02-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2025-03-01: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerservice.v2025_03_01.operations.PrivateEndpointConnectionsOperations>`
        """
        api_version = self._get_api_version('private_endpoint_connections')
        if api_version == '2020-11-01':
            from .v2020_11_01.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import PrivateEndpointConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_endpoint_connections'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def private_link_resources(self):
        """Instance depends on the API version:

           * 2020-11-01: :class:`PrivateLinkResourcesOperations<azure.mgmt.containerservice.v2020_11_01.operations.PrivateLinkResourcesOperations>`
           * 2025-02-02-preview: :class:`PrivateLinkResourcesOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.PrivateLinkResourcesOperations>`
           * 2025-03-01: :class:`PrivateLinkResourcesOperations<azure.mgmt.containerservice.v2025_03_01.operations.PrivateLinkResourcesOperations>`
        """
        api_version = self._get_api_version('private_link_resources')
        if api_version == '2020-11-01':
            from .v2020_11_01.operations import PrivateLinkResourcesOperations as OperationClass
        elif api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import PrivateLinkResourcesOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import PrivateLinkResourcesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_link_resources'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def resolve_private_link_service_id(self):
        """Instance depends on the API version:

           * 2020-11-01: :class:`ResolvePrivateLinkServiceIdOperations<azure.mgmt.containerservice.v2020_11_01.operations.ResolvePrivateLinkServiceIdOperations>`
           * 2025-02-02-preview: :class:`ResolvePrivateLinkServiceIdOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.ResolvePrivateLinkServiceIdOperations>`
           * 2025-03-01: :class:`ResolvePrivateLinkServiceIdOperations<azure.mgmt.containerservice.v2025_03_01.operations.ResolvePrivateLinkServiceIdOperations>`
        """
        api_version = self._get_api_version('resolve_private_link_service_id')
        if api_version == '2020-11-01':
            from .v2020_11_01.operations import ResolvePrivateLinkServiceIdOperations as OperationClass
        elif api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import ResolvePrivateLinkServiceIdOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import ResolvePrivateLinkServiceIdOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'resolve_private_link_service_id'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def snapshots(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`SnapshotsOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.SnapshotsOperations>`
           * 2025-03-01: :class:`SnapshotsOperations<azure.mgmt.containerservice.v2025_03_01.operations.SnapshotsOperations>`
        """
        api_version = self._get_api_version('snapshots')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import SnapshotsOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import SnapshotsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'snapshots'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def trusted_access_role_bindings(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`TrustedAccessRoleBindingsOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.TrustedAccessRoleBindingsOperations>`
           * 2025-03-01: :class:`TrustedAccessRoleBindingsOperations<azure.mgmt.containerservice.v2025_03_01.operations.TrustedAccessRoleBindingsOperations>`
        """
        api_version = self._get_api_version('trusted_access_role_bindings')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import TrustedAccessRoleBindingsOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import TrustedAccessRoleBindingsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'trusted_access_role_bindings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def trusted_access_roles(self):
        """Instance depends on the API version:

           * 2025-02-02-preview: :class:`TrustedAccessRolesOperations<azure.mgmt.containerservice.v2025_02_02_preview.operations.TrustedAccessRolesOperations>`
           * 2025-03-01: :class:`TrustedAccessRolesOperations<azure.mgmt.containerservice.v2025_03_01.operations.TrustedAccessRolesOperations>`
        """
        api_version = self._get_api_version('trusted_access_roles')
        if api_version == '2025-02-02-preview':
            from .v2025_02_02_preview.operations import TrustedAccessRolesOperations as OperationClass
        elif api_version == '2025-03-01':
            from .v2025_03_01.operations import TrustedAccessRolesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'trusted_access_roles'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    def close(self):
        self._client.close()
    def __enter__(self):
        self._client.__enter__()
        return self
    def __exit__(self, *exc_details):
        self._client.__exit__(*exc_details)
