"""Test definitions for Highway."""

# path, name, deps
HWY_CONTRIB_TESTS = (
    (
        "hwy/contrib/algo/",
        "copy_test",
        (":algo",),
    ),
    (
        "hwy/contrib/algo/",
        "find_test",
        (":algo",),
    ),
    (
        "hwy/contrib/algo/",
        "transform_test",
        (":algo",),
    ),
    (
        "hwy/contrib/bit_pack/",
        "bit_pack_test",
        (":bit_pack",),
    ),
    (
        "hwy/contrib/dot/",
        "dot_test",
        (":dot",),
    ),
    (
        "hwy/contrib/image/",
        "image_test",
        (":image",),
    ),
    (
        "hwy/contrib/math/",
        "math_test",
        (":math",),
    ),
    (
        "hwy/contrib/math/",
        "math_hyper_test",
        (":math",),
    ),
    (
        "hwy/contrib/math/",
        "math_tan_test",
        (":math",),
    ),
    (
        "hwy/contrib/math/",
        "math_trig_test",
        (":math",),
    ),
    (
        "hwy/contrib/random/",
        "random_test",
        (":random",),
    ),
    (
        "hwy/contrib/matvec/",
        "matvec_test",
        (":matvec", ":algo", ":topology", ":thread_pool"),
    ),
    (
        "hwy/contrib/thread_pool/",
        "spin_test",
        (":topology", ":thread_pool"),
    ),
    (
        "hwy/contrib/thread_pool/",
        "thread_pool_test",
        (":topology", ":thread_pool"),
    ),
    (
        "hwy/contrib/thread_pool/",
        "topology_test",
        (":thread_pool", ":topology"),
    ),
    (
        "hwy/contrib/unroller/",
        "unroller_test",
        (":unroller",),
    ),
    # contrib/sort has its own BUILD, we also add sort_test to GUITAR_TESTS.
    # To run bench_sort, specify --test=hwy/contrib/sort:bench_sort.
)

# path, name, deps
HWY_TESTS = HWY_CONTRIB_TESTS + (
    (
        "hwy/examples/",
        "skeleton_test",
        (":skeleton",),
    ),
    ("hwy/", "abort_test", []),
    ("hwy/", "aligned_allocator_test", []),
    (
        "hwy/",
        "auto_tune_test",
        (":auto_tune",),
    ),
    ("hwy/", "base_test", []),
    (
        "hwy/",
        "bit_set_test",
        (":bit_set",),
    ),
    ("hwy/", "highway_test", []),
    ("hwy/", "nanobenchmark_test", []),
    (
        "hwy/",
        "perf_counters_test",
        (":perf_counters", ":thread_pool"),
    ),
    ("hwy/", "targets_test", []),
    ("hwy/tests/", "arithmetic_test", []),
    ("hwy/tests/", "bit_permute_test", []),
    ("hwy/tests/", "blockwise_combine_test", []),
    ("hwy/tests/", "blockwise_shift_test", []),
    ("hwy/tests/", "blockwise_test", []),
    ("hwy/tests/", "cast_test", []),
    ("hwy/tests/", "combine_test", []),
    ("hwy/tests/", "compare_test", []),
    ("hwy/tests/", "compress_test", []),
    ("hwy/tests/", "complex_arithmetic_test", []),
    ("hwy/tests/", "concat_test", []),
    ("hwy/tests/", "convert_test", []),
    ("hwy/tests/", "count_test", []),
    ("hwy/tests/", "crypto_test", []),
    ("hwy/tests/", "demote_test", []),
    ("hwy/tests/", "div_test", []),
    ("hwy/tests/", "dup128_vec_test", []),
    ("hwy/tests/", "expand_test", []),
    ("hwy/tests/", "float_test", []),
    ("hwy/tests/", "fma_test", []),
    ("hwy/tests/", "foreach_vec_test", []),
    ("hwy/tests/", "if_test", []),
    ("hwy/tests/", "in_range_float_to_int_conv_test", []),
    ("hwy/tests/", "interleaved_test", []),
    ("hwy/tests/", "logical_test", []),
    ("hwy/tests/", "mask_combine_test", []),
    ("hwy/tests/", "mask_convert_test", []),
    ("hwy/tests/", "mask_mem_test", []),
    ("hwy/tests/", "mask_set_test", []),
    ("hwy/tests/", "mask_slide_test", []),
    ("hwy/tests/", "mask_test", []),
    ("hwy/tests/", "masked_arithmetic_test", []),
    ("hwy/tests/", "masked_minmax_test", []),
    ("hwy/tests/", "memory_test", []),
    ("hwy/tests/", "minmax_magnitude_test", []),
    ("hwy/tests/", "minmax_number_test", []),
    ("hwy/tests/", "minmax_test", []),
    ("hwy/tests/", "minmax128_test", []),
    ("hwy/tests/", "mul_by_pow2_test", []),
    ("hwy/tests/", "mul_pairwise_test", []),
    ("hwy/tests/", "mul_test", []),
    ("hwy/tests/", "reduction_test", []),
    ("hwy/tests/", "resize_test", []),
    ("hwy/tests/", "reverse_test", []),
    ("hwy/tests/", "rotate_test", []),
    ("hwy/tests/", "saturated_test", []),
    ("hwy/tests/", "shift_test", []),
    ("hwy/tests/", "shuffle4_test", []),
    ("hwy/tests/", "sign_test", []),
    ("hwy/tests/", "slide_up_down_test", []),
    ("hwy/tests/", "sums_abs_diff_test", []),
    ("hwy/tests/", "swizzle_block_test", []),
    ("hwy/tests/", "swizzle_test", []),
    ("hwy/tests/", "table_test", []),
    ("hwy/tests/", "test_util_test", []),
    ("hwy/tests/", "truncate_test", []),
    ("hwy/tests/", "tuple_test", []),
    ("hwy/tests/", "widen_mul_test", []),
)
