/**** Program to display fixed data base of net land.  ****/

/*	Copyright (C) 1989, 1990, 1991 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */


/* This program displays some network connectivity.  The data presently
 * is more or less fixed by values in certain data files.  Eventually I
 * hope to be able to do this more dynamically.
 */


#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 3  20-Feb-89	M. A. Patton	First release version.
 3A  4-Mar-89	M. A. Patton	Removed Vertex stuff from all over.
				Removed other X stuff from header.
 4  17-Mar-89	M. A. Patton	Added config file.
 4A 20-Mar-89	P. V. O'Neill	Removed extraneous declare of input.
 4B 23-Mar-89	M. A. Patton	Added table_addresses field to Host structure.
 4C 29-Jun-89	M. A. Patton	Added text pos and command value to Title.
 4D 10-Feb-90	M. A. Patton	Changed declaration of AddressList to make
				type matches come out better.
 5   9-Aug-90	M. A. Patton	Added derivation for HAVE_HARDCOPY
				Removed extraneous externs dflt_*_output
 5A 15-Aug-90	Edwin Kremer	Modifications for HP-UX 7.0 on HP9000/345:
				 + don't have <arpa/inet.h>
				 + use <string.h> (SYSV-like)
				 + BSD string routines cause compiler warnings
				   so redefine them to the equiv. SYSV routines.
 5B  1-Apr-91	Mike Patton	Added flag for point-to-point nets.

#endif
/**** compiler setup page ****/


/* Include the world (or a large portion of it) */
/* Eventually any of these that are only used by some of the files should
 * be moved there
 */
#include "common.h"
#include "config.h"
#include <stdio.h>
  
#if defined(hp9000s300) || defined(SYSV)
#include <string.h>
#else
#include <strings.h>
#endif


#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#if !defined(hp9000s300)
#include <arpa/inet.h>
#endif

#include <ctype.h>

/* Recast BSD routines in terms of Sys V routines, used by HP instead */
#if defined(hp9000s300) || defined(SYSV)
#define index(s, c)	strchr(s, c)
#define rindex(s, c)	strrchr(s, c)
#define bzero(s, n)	memset(s, 0, n)
#endif



/* Random parameters */

/* Length of type-in buffer. */
#define INPUT_LEN	40


/* Derived definitions */
#if defined(HARDCOPY_PS) || defined(HARDCOPY_TEK)
#define HAVE_HARDCOPY
#endif



/* Some functions take a modifier flag that is the OR of these values */
#define MOD_VERBOSE	(1<<0)
#define MOD_GEOMETRY	(1<<1)

/* These macros are used for testing above */
#define VERBOSE_P(m)	( (m&MOD_VERBOSE) != 0 )
#define GEOMETRY_P(m)	( (m&MOD_GEOMETRY) != 0 )



/* Declarations of cross-module routines to keep compiler happy */
caddr_t InitDisplay();
int InterpretColor();
/**** ???? ****/

/* The parameters for the program.
 * These are in general set to a program determined default in the main module,
 * and then modified to the Xdefault value if given, and then set
 * according to command line arguments if overridden.
 */
extern int border_width;	/* The width of the border */
extern char *display_name;	/* The name of the display */
extern char *border_color;	/* The color for the border */
extern char *fore_color;	/* The text color */
extern char *back_color;	/* The background color */
extern char *highlight_color;	/* Indicate the selected host */
extern char *font_name;		/* The font to use */
extern char *geometry;		/* Pointer to geometry string for window */

/* Where the data files live: */
extern char *geo_file;		/* geometry data */
extern char *host_file;		/* master host table */

/* Added flags for XGeometries: */
/*	"already placed" or not */
#define AlreadyPlaced	0x1000
/*	Special Point-to-Point net */
#define P_P_NET		0x2000
/**** Main database structure ****/





/* The following data structures are used to keep the information read
 * from the data files.
 */

/* This structure is designed to hold an arbitrary address (of a net or a
 * machine).
 */
typedef struct _NetAddress
{   int class;	    /* Uses address family values (i.e. AF_INET, AF_CHAOS) */
    unsigned long value;
} NetAddress;

/* This structure is used to make a list of addresses. */
typedef struct _AddressList
{   struct _AddressList *next;
    NetAddress address;
    struct _Network *net_p;
} AddressList;

/* This structure is used to make a list of names. */
typedef struct _NameList
{   struct _NameList *next;
    char *name;
} NameList;

/* This structure represents one protocol spoken by a host.  It can have
 * children for protocols that run on top of it.
 */
typedef struct _Protocol
{   struct _Protocol *next;
    struct _Protocol *child;
    char *name;
} Protocol;
extern Protocol *all_protocols;	/* Union of all protocols spoken by any host */

/* There is one of these for each type of transmission media mentioned
 * in the geometry file.  They are all linked together in one list.
 */
typedef struct _Media
{   struct _Media *next;
    char *name;
    int pixel;
} Media;
extern Media *media_base;
/* There is one of these for each network line in the geometry file.
 * They are all linked together in one list.
 */
typedef struct _Network
{   struct _Network *next;
    char *name;
    struct _AddressList *addresses;
    int geo_flag, x_pos, y_pos, width, height;
    int x1, y1, x2, y2;
    int label_x, label_y;
    int side1, side2;		/* The sides of the media line */
    int vertical;		/* TRUE is vertical, FALSE is horizontal */
    struct _Media *media;	/* Pointer to media to get representations */
    int nbr_hosts;		/* -1 => Never computed (or invalidated) */
} Network;
extern Network *net_base;

/* There is one of these for each machine line in the geometry file.
 * They are all linked together in one list.
 */
typedef struct _Machine
{   struct _Machine *next;
    char *name;			/* Should be defering this to Host???? */
    struct _Host *host;
} Machine;
extern Machine *machine_base;


/* There is one of these for each host line in the master host table file.
 * They are all linked together in one list.
 */
typedef struct _Host
{   struct _Host *next;
    struct _NameList *names;
    char *preferred_name;
    int geo_flag, x_pos, y_pos, width, height;
    int x1, y1, x2, y2;
    struct _AddressList *addresses;
    struct _AddressList *table_addresses;
    char *hardware;
    char *opsys;
    struct _Machine *machine;
    struct _Protocol *protocols;
} Host;
extern Host *host_base;
extern Host *FindHost();
/****	Miscellaneous display artifacts	****/



/* There is one of these for each title line in the geometry file.
 * They are all linked together in one list.
 */
typedef struct _Title
{   struct _Title *next;
    char *text;
    char *command;
    int geo_flag, x_pos, y_pos, width, height;
    int text_x, text_y;
    int x1, y1, x2, y2;		/* ???? */
} Title;
extern Title *title_base;

/**** Random global data ****/






/* Globals to hold original values of argc and argv. */
extern int Argc;
extern char **Argv;











/* Global information, used during operation. */
extern int display_height, display_width;

extern int foreground;


/* Random state variables */
extern int show_chaos;
extern int show_IP;


extern Host *selected_host;
