/**** Generalized I/O ****/

/*	Copyright (C) 1989 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */

#include "common.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 1  29-Jun-89	M. A. Patton	First version based on GNUemacs "load".
 1A 29-Jul-89	M. A. Patton	Efficiency improved, not as much copying.

#endif


/* helper routine, maximum length of any string in an array */
static int
maxlen(p)
char **p;
{   int i=0, l;

    for (; *p!=NULL; p++ )
	if ( (l=strlen(*p)) > i ) i=l;
    return (i);
}
/* find_file	-locate file based on search criteria
 *
 * This routine is used to find a file with a given name using a
 * search list of possible directories and suffixes.
 *
 * Returned value is NULL if no file matches or a file ptr (stdio) if
 * a match was found (first fit).
 */
FILE *
find_file(str, path, suffix, real_name)
char *str;			/* Name to match for */
char **path;			/* array of directories to try (with /) */
char **suffix;			/* array of suffixes to try (with .)  */
char **real_name;		/* return value for real name (or NULL) */
{   char *val=(char *)malloc(maxlen(path)+maxlen(suffix)+strlen(str)+1);
    FILE *fd;
    struct stat st;

    if ( real_name != NULL ) *real_name = NULL;
    for (; *path != NULL; path++ )
    {	char **nsuffix;
	char *p=val;

	/* Append the leadding part and the file name */
	{   char *tmp = *path;
	    while (*tmp) *p++ = *tmp++;
	}
	{   char *tmp = str;
	    while (*tmp) *p++ = *tmp++;
	}
	/* Now try each of the suffixes in turn (appending from there) */
	for (nsuffix=suffix; *nsuffix!=NULL; nsuffix++ )
	{   strcpy(p,*nsuffix);
	    /* Ignore file if it's a directory.  */
	    if (stat (val, &st) >= 0
		&& (st.st_mode & S_IFMT) != S_IFDIR)
	    {	fd = fopen (val, "r");
		if (fd != NULL)
		{   /* We succeeded; return this descriptor.  */
		    if ( real_name != NULL )
			*real_name = val;
		    else
			free(val);
		    return (fd);
		}
	    }
	}
    }
    free(val);
    return (NULL);
}
