use ExtUtils::MakeMaker;
use strict;
use warnings;

# Call 'perldoc ExtUtils::MakeMaker' for details of how to influence
# the contents of the Makefile that is written.

my %WriteMakefileArgs = (
    NAME                => 'Net::API::Telegram',
    VERSION_FROM        => 'lib/Net/API/Telegram.pm',
    AUTHOR              => 'Jacques Deguest (jack@deguest.jp)',
    ABSTRACT            => 'Implementation of Telegram API',
    INSTALLDIRS         => ($] < 5.011 ? 'perl' : 'site'),
    PREREQ_PM           => {
        'Test::Simple' => 0.44,
        'strict'			=> 0,
        'parent'			=> 0,
        'constant'			=> 0,
        'Module::Generic'	=> '0.11.6',
        'HTTP::Daemon'		=> '6.06',
        'HTTP::Daemon::SSL'	=> '1.04',
        'File::Temp'		=> '0.2309',
        'File::Spec'		=> '3.78',
        'File::Basename'	=> '2.85',
        'IO::File'			=> '1.41',
        'Data::UUID'		=> '1.224',
        'JSON'				=> '4.02',
        'Encode'			=> '3.01',
        'TryCatch'			=> '1.003002',
        'File::Map'			=> '0.66',
        'Class::Struct'		=> '0.65',
        'Devel::StackTrace'	=> '2.04',
        'Time::HiRes'		=> '1.9760',
        'DateTime'			=> '1.51',
        'DateTime::TimeZone' => '',
        'POSIX'				=> '',
        'Net::IP'			=> '',
        'Errno'				=> '',
        'LWP::UserAgent'	=> '',
        'HTTP::Headers'		=> '',
        'HTTP::Request'		=> '',
        'HTTP::Request::Common' => '',
        'HTTP::Response'	=> '',
        'Devel::Confess'	=> '',
        'Data::Dumper'		=> '',
        'Scalar::Util'		=> '',
        'File::Copy'		=> '',
        'Cwd'				=> '',
        'File::Type'		=> '',
        'Number::Format'	=> '',
        'HTTP::Status'		=> '',
    },
    LICENSE				=> 'perl_5',
    MIN_PERL_VERSION	=> 5.6.0,
    ( eval { ExtUtils::MakeMaker->VERSION(6.46) } ? () : ( META_MERGE => {
        'meta-spec' => { version => 2 },
        dynamic_config => 1,
        #resources => {
        #    homepage    => undef,
            repository  => {
                url         => 'git@git.deguest.jp:jack/Net-API-Telegram.git',
                web         => 'https://git.deguest.jp/jack/Net-API-Telegram',
                type        => 'git',
            },
        #    bugtracker => {
        #        web         => undef,
        #    },
        #},
    })),
);

WriteMakefile(%WriteMakefileArgs);
