(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Jun  9 14:10:37 PDT 1992 by kalsow     *)
(*      modified on Mon Nov 18 14:52:27 PST 1991 by muller     *)


UNSAFE MODULE FileStream;

IMPORT Rd, Wr, DOSTextRd, DOSTextWr, NameMap, FileIO;

PROCEDURE OpenRead (nm: TEXT): Rd.T RAISES {Rd.Failure} =
  VAR n : TEXT := NameMap.GetDos (nm);
  BEGIN
    (*RETURN DOSTextRd.New (FileIO.OpenRead (n));*)
    RETURN FileIO.OpenRead (n); 
  END OpenRead;

PROCEDURE OpenWrite (nm: TEXT): Wr.T RAISES {Wr.Failure} =
  VAR n: TEXT := NameMap.GetDos (nm, add:= TRUE);
  BEGIN
    (*RETURN DOSTextWr.New (FileIO.OpenWrite (n));*)
    RETURN FileIO.OpenWrite (n); 
  END OpenWrite;

PROCEDURE OpenAppend (nm: TEXT): Wr.T RAISES {Wr.Failure} =
  VAR n: TEXT := NameMap.GetDos (nm, add:= TRUE);
  BEGIN
    (*RETURN DOSTextWr.New (FileIO.OpenAppend (n));*)
    RETURN FileIO.OpenAppend (n); 
  END OpenAppend;

BEGIN
END FileStream.
