(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Jan 31 10:17:21 PST 1992 by kalsow     *)
(*      modified on Tue Oct  9 21:54:08 1990 by muller         *)

INTERFACE RTProc;

(* This interface provides safe access to the runtime
   representations of procedures *)

IMPORT RT0;

TYPE
  Proc = ADDRESS;
  (* representing a procedure by its address seems to be the best
     approximation we can give for the super type of all procedure types *)

TYPE
  Name = ADDRESS;
  (* a C-style null terminated string *)

PROCEDURE NumProcedures (): CARDINAL;   
(* returns the number of global procedures registered in the runtime *)

TYPE
  Fingerprint = RT0.Fingerprint;
  (* a fingerprint is a 64-bit hash value computed from a procedure's
     name and type.  The probability of distinct procedures having the
     same fingerprint is very small. *)

PROCEDURE ToFingerprint (p: Proc): Fingerprint;
(* given p, the address of a global procedure of the current program,
   returns its fingerprint.  It is a checked runtime error if
   p does not correspond to a global procedure. *)

PROCEDURE FromFingerprint (READONLY fp: Fingerprint): Proc;
(* if fp is the fingerprint of a global procedure in the current program, 
   returns the address of that procedure; otherwise returns NIL. *)

PROCEDURE FromPC (pc: ADDRESS;  VAR p: Proc;  VAR name: Name);
(* returns in (p, name) the address and name of the procedure that
   seems to contain pc.  (i.e. the first registered procedure before pc)
   Note that this procedure may require a linear search of the registered
   procedures. *)

END RTProc.

