(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: EnumElt.m3                                            *)
(* Last modified on Mon Feb  3 08:54:34 PST 1992 by kalsow     *)
(*      modified on Fri Apr 20 06:45:16 1990 by muller         *)

MODULE EnumElt;

IMPORT Type, String, Value, ValueRep, Expr, Error;
IMPORT Emit, EnumExpr, Temp, MBuf;

TYPE
  T = Value.T BRANDED OBJECT
	value  : INTEGER;
	parent : Type.T;
      OVERRIDES
        typeCheck   := Check;
	class       := MyClass;
        fingerprint := FPrinter;
        load        := Load;
        write       := Write;
        declare0    := Declarer;
        declare1    := Compile;
	toExpr      := ToExpr;
	toType      := ValueRep.NoType;
        typeOf      := TypeOf;
      END;

PROCEDURE New (name: String.T;  value: INTEGER;  parent: Type.T): Value.T =
  VAR t := NEW (T);
  BEGIN
    ValueRep.Init (t, name);
    t.readonly := TRUE;
    t.value    := value;
    t.parent   := parent;
    RETURN t;
  END New;

PROCEDURE OrdValue (v: Value.T): INTEGER =
  BEGIN
    RETURN NARROW (v, T).value;
  END OrdValue;

PROCEDURE Check (<*UNUSED*> t: T;  <*UNUSED*> VAR cs: Value.CheckState) =
  BEGIN
    (* no checking needed *)
  END Check;

PROCEDURE Load (t: T): Temp.T =
  BEGIN
    RETURN Temp.FromValue (t);
  END Load;

PROCEDURE Write (t: T) =
  BEGIN
    Emit.OpI (" @ ", t.value);
  END Write;

PROCEDURE Compile (<*UNUSED*> t: T) =
  BEGIN
  END Compile;

PROCEDURE MyClass (<*UNUSED*> t: T): Value.Class =
  BEGIN
    RETURN Value.Class.Expr;
  END MyClass;

PROCEDURE ToExpr (t: T): Expr.T =
  BEGIN
    RETURN EnumExpr.New (t.parent, t.value);
  END ToExpr;

PROCEDURE TypeOf (t: T): Type.T =
  BEGIN
    RETURN t.parent;
  END TypeOf;

PROCEDURE Declarer (t: T): BOOLEAN =
  BEGIN
    Error.Str (t.name, "enumeration element declared??");
    <* ASSERT FALSE *>
    (* RETURN FALSE; *)
  END Declarer;

PROCEDURE FPrinter (t: T; <*UNUSED*> map: Type.FPMap; wr: MBuf.T) =
  BEGIN
    MBuf.PutInt (wr, t.value);
  END FPrinter;

BEGIN
END EnumElt.
