 /*
  * Khoros: $Id: roi.h,v 1.2 1991/07/15 05:57:43 khoros Exp $
  */

 /*
  * $Log: roi.h,v $
 * Revision 1.2  1991/07/15  05:57:43  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *                       All Rights Reserved
 *
 *----------------------------------------------------------------------
 */
#include "unmcopyright.h"        /* Copyright 1990 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: roi.h
 >>>>            Author: Mark Young
 >>>> Date Last Updated: Mon Aug  6 14:12:32 1990
 >>>>          Contents: Contains the commands and options 
 >>>>                    for roi - included by run_roi()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _roi_h_
#define _roi_h_

typedef struct {
	char *label;
	char *command;
	char *input;
	char *output;
	char *options;

} roi_command;

static roi_command commands[] = 
{
   { " xprism2  ", "xprism2", "-i11", NULL, " " },
   { " xprism3  ", "xprism3", "-i11",  NULL, " " },
   { " vgrad    ", "vgrad",   "-i",   "-o", "-t 1  -p 0" },
   { " vdiff    ", "vdiff",   "-i1",  "-o", "-i2 ${KHOROS_HOME}/data/kernels/sobel_x -i3 ${KHOROS_HOME}/data/kernels/sobel_y" },
   { " vdrf     ", "vdrf",    "-i",   "-o", "-a1 0.3 -a2 0.3 -w 5 -t1 12 -t2 15 -l 10" },
   { " vgef     ", "vgef",    "-i",   "-o", "-a0 0.45 -t1 3 -t2 4 -l 5" },
   { " vsdef    ", "vsdef",   "-i",   "-o", "-a0 0.45 -t1 3 -t2 4 -l 10" },
   { " v1bgamut ", "v1bgamut","-i",   "-o", "-n 2 -r 0.5" },
   { " venhance ", "venhance","-i",   "-o", "-w 9 -h 9 -k .5 -v 1.0" },
   { " venhpatch", "venhpatch","-i",   "-o", "-w 9 -h 9 -k .5 -v 1.0" },
   { " vheq     ", "vheq",     "-i",   "-o", "-p 0" },
   { " vhisto   ", "vhisto",   "-i",   "-o", "-l 0 -u 255 -n 256 -t 0 -p 0" },
   { " vhstr    ", "vhstr",    "-i",   "-o", "-p 0" },
   { " vhxray   ", "vhxray",   "-i",   "-o", "-w 15 -h 15  -t 0" },
   { " vexp     ", "vexp",     "-i",   "-o", "-t 1" },
   { " vlog     ", "vlog",     "-i",   "-o", "-t 1 -n 1" },
   { " vinvert  ", "vinvert",  "-i",   "-o", " " },
   { " vsqrt    ", "vsqrt",    "-i",   "-o", " " },
   { " vlshift  ", "vlshift",  "-i",   "-o", "-s 1" },
   { " vrshift  ", "vrshift",  "-i",   "-o", "-s 1" },
   { " vexpand  ", "vexpand",  "-i",   "-o", "-s 2" },
   { " vshrink  ", "vshrink",  "-i",   "-o", "-s 2" },
   { " vtranspos", "vtranspos","-i",   "-o", " " },
   { " vflip_rl ", "vflip",    "-i",   "-o", "-t 0 -r 1" },
   { " vflip_tb ", "vflip",    "-i",   "-o", "-t 1 -r 0" },
   { " vflip_tbrl","vflip",    "-i",   "-o", "-t 1 -r 1" },
   { " vmsquish ", "vmsquish", "-i",   "-o", "-m 1 -t 1" },
   { " vdetilt  ", "vdetilt",  "-i",   "-o", "-p 0" },
   { " vdistance", "vdistance","-i",   "-o", " " },
   { " vmapdata ", "vmapdata", "-i",   "-o", " " },
   { " vremmap  ", "vremmap",  "-i",   "-o", " " },
   { " vshape   ", "vshape",   "-i2",  "-o1","-f # -mc 1  -col 0" },
   { " vstats   ", "vstats",   "-i",   NULL, "-all 1  -f #" },
   { " vgrow    ", "vgrow",    "-i",   "-o", " " },
   { " vmskel   ", "vmskel",   "-i",   "-o", " " },
   { " vmspan   ", "vmspan",   "-i",   "-o", " " },
   { " vm180    ", "vm180",    "-i",   "-o", " " },
   { " vmediaxis", "vmediaxis","-i",   "-o", "-w 0" },
   { " vhmed    ", "vhmed",    "-i",   "-o", "-w 3 -h 3" },
   { " vqmed    ", "vqmed",    "-i",   "-o", "-w 3 -h 3" },
   { " vspeckle ", "vspeckle", "-i",   "-o", "-iterations 10" }
};


#endif /* not not add after this point */
