/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvtilt.c
 >>>>
 >>>>      Program Name: vtilt
 >>>>
 >>>> Date Last Updated: Fri Jun 28 16:56:47 1991 
 >>>>
 >>>>          Routines: lvtilt - the library call for vtilt
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvtilt - library call for vtilt
*
* Purpose:
*    
*    Adds a specified plane to the input image to correct  for  a
*    tilt in the image luminance.
*    
*    
* Input:
*    
*    img1           (struct  xvimage)  -  input/output  image  xvimage
*                   structure
*    
*    img2           (struct xvimage) - input mask image
*    
*    mflg           (int) - set to one if img2 to is to be used  as  a
*                   mask image
*    
*    xslope & yslope(float) - specify the characteristics of the plane
*                   and must be given in units per pixel.
*    
*    
* Output:
*    
*    img1           (struct  xvimage)  -  input/output  image  xvimage
*                   structure
*    
*    lvtilt will return a value of one upon  success  and  a  zero  on
*    failure.
*    
*    
*
* Written By: Scott Wilson, Donna Koechner
*    
*    John Rasure, Marcelo Teran, Donna Koechner
*    Mon Jun 11 16:53:44 MDT 1990 Donna  Koechner  -  updated  to
*    ghostwriter
*    Fri Jun 28 16:43:19 MDT 1991 Scott  Wilson  -  Fixed  bogous
*    pointer increment in float loop with mask
*    
*    
****************************************************************/


/* -library_def */
int
lvtilt(img1,img2,mflg,xslope,yslope)
struct xvimage  *img1, *img2;
int             mflg;
float           xslope, yslope;
/* -library_def_end */

/* -library_code */
{

    int i,j,k,rows,cols,rowsd2,colsd2;
    unsigned char *c1,*c2;
    short *s1,*s2;
    int *i1,*i2;
    float *f1,*f2;

    rows = img1->col_size;
    cols = img1->row_size;

    rowsd2 = rows / 2;
    colsd2 = cols / 2;

    if (rowsd2 == 0 || colsd2 == 0)
      {
        (void) fprintf(stderr,"lvtilt: Cannot tilt a one-pixel wide image!\n");
        return(0);
      }

    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          (void) fprintf(stderr,"lvtilt: Don't know how to TILT a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          if (mflg) c2 = (unsigned char *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      i = *c1 + (xslope*(k-colsd2)+yslope*(j-rowsd2));
                      if (i < 0) i = 0;
                      if (i > 255) i = 255;
                      *c1 = i;
                      c1++;
                    }
                }
            }
          else
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*c2++)
                        {
                          i = *c1 + (xslope*(k-colsd2)+yslope*(j-rowsd2));
                          if (i < 0) i = 0;
                          if (i > 255) i = 255;
                          *c1 = i;
                          c1++;
                        }
                      else c1++;
                    }
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          if (mflg) s2 = (short *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      *s1 += xslope*(k-colsd2)+yslope*(j-rowsd2);
                      s1++;
                    }
                }
            }
          else
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*s2++)
                        {
                          *s1 += xslope*(k-colsd2)+yslope*(j-rowsd2);
                          s1++;
                        }
                      else s1++;
                    }
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          if (mflg) i2 = (int *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      *i1 += xslope*(k-colsd2)+yslope*(j-rowsd2);
                      i1++;
                    }
                }
            }
          else
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*i2++)
                        {
                          *i1 += xslope*(k-colsd2)+yslope*(j-rowsd2);
                          i1++;
                        }
                      else i1++;
                    }
                }
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          if (mflg) f2 = (float *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      *f1 += xslope*(k-colsd2)+yslope*(j-rowsd2);
                      f1++;
                    }
                }
            }
          else
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<cols; k++)
                    {
                      if (*f2++)
                        {
                          *f1 += xslope*(k-colsd2)+yslope*(j-rowsd2);
                          f1++;
                        }
                      else f1++;
                    }
                }
            }
          break;
        case VFF_TYP_COMPLEX :
          (void) fprintf(stderr,"lvtilt: Don't know how to TILT a COMPLEX image!\n");
          return(0);
          break;
        default:
          (void) fprintf(stderr,"lvtilt: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);
}

/* -library_code_end */
