/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    private String resource;

    public Configuration() {
        this.resource = "/jiapi.properties";
    }

    public Configuration(String resource) {
        this.resource = resource;
    }

    public boolean getBoolean(String key, boolean deflt) {
        if (key == null) {
            return deflt;
        }
        Properties p = this.getProperties(this.resource);
        String s = p.getProperty(key);
        boolean b = deflt;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        return b;
    }

    public int getInt(String key, int deflt) {
        if (key == null) {
            return deflt;
        }
        Properties p = this.getProperties(this.resource);
        String s = p.getProperty(key);
        int i = deflt;
        try {
            i = Integer.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        return i;
    }

    private Properties getProperties(String name) {
        Properties properties = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                properties.load(is);
            } else {
                System.out.println("Could not find resource: " + name);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get property file " + name + ", " + e);
        }
        return properties;
    }
}

