//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.util.SparseArray;
import android.util.SparseIntArray;

public final class SuperBlock {
	
	public static volatile SparseArray<ArrayList<Float>> superblocklinewidth = new SparseArray<ArrayList<Float>>(); 
	public static volatile SparseArray<ArrayList<Float>> superblocklineheight = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> superblocklinedepth = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Character>> superblocktype = new SparseArray<ArrayList<Character>>();
	public static volatile SparseArray<ArrayList<String>> blockatom = new  SparseArray<ArrayList<String>>();
	public static volatile SparseArray<ArrayList<Float>> blockxpos = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> blockypos = new SparseArray<ArrayList<Float>>(); 
	public static volatile SparseArray<ArrayList<String>> blockattribute  = new SparseArray<ArrayList<String>>();
	public static volatile SparseArray<ArrayList<Integer>> blockcolumnnum  = new SparseArray<ArrayList<Integer>>();
	public static volatile SparseArray<Float> ypos = new SparseArray<Float>();
    public static volatile SparseIntArray superblocklinenumber = new SparseIntArray();
    
    public static volatile SparseIntArray tablenumber = new SparseIntArray();
    public static volatile SparseIntArray tablestartline = new SparseIntArray();
    public static volatile SparseIntArray tableendline = new SparseIntArray();
    public static volatile SparseArray<Float> tableheight = new SparseArray<Float>();
    public static volatile SparseIntArray titlenumber = new SparseIntArray();
    public static volatile SparseIntArray titlestartline = new SparseIntArray();
    public static volatile SparseIntArray titleendline = new SparseIntArray();
    public static volatile SparseArray<Float> titleheight = new SparseArray<Float>();   
    public static volatile SparseArray<ArrayList<Integer>> pagebreak = new SparseArray<ArrayList<Integer>>();
    
    public void init(int tid){
    	synchronized(this){
		superblocklinewidth.put(tid,new ArrayList<Float>());
		superblocklineheight.put(tid,new ArrayList<Float>());
		superblocklinedepth.put(tid,new ArrayList<Float>()); 		
		superblocktype.put(tid, new ArrayList<Character>());
		superblocklinenumber.put(tid, -1);
		
		tablenumber.put(tid, 0);
		
		pagebreak.put(tid, new ArrayList<Integer>());
		return;
    	}
}

    
	public void create(int tid){
		synchronized(this){

		superblocklinenumber.put(tid,superblocklinenumber.get(tid)+1);
		
		int tid2=tid*1000+superblocklinenumber.get(tid);
		blockatom.put(tid2,new ArrayList<String>());
		blockxpos.put(tid2,new ArrayList<Float>());
		blockypos.put(tid2,new ArrayList<Float>()); 
		blockattribute.put(tid2,new ArrayList<String>());
		blockcolumnnum.put(tid2,new ArrayList<Integer>());		
        superblocklinewidth.get(tid).add(0.0f);
        superblocklineheight.get(tid).add(0.0f);
        superblocklinedepth.get(tid).add(0.0f);
     
        return;
	}
}
	
	public void addtable(int tid){
		synchronized(this){
		tablenumber.put(tid, tablenumber.get(tid)+1);
		tablestartline.put(tid*1000+tablenumber.get(tid), -1);
		tableendline.put(tid*1000+tablenumber.get(tid), -1);
		tableheight.put(tid*1000+tablenumber.get(tid), 0.0f);
		}
	}

	public void addtitle(int tid){
		synchronized(this){
		titlenumber.put(tid, 1);
		titlestartline.put(tid, 0);
		titleendline.put(tid, -1);
		titleheight.put(tid, 0.0f);
		}
	}
	
	public void add(int tid, SparseArray<ArrayList<String>> atom,  
			SparseArray<ArrayList<Float>> xpos,SparseArray<ArrayList<Float>> ypos,SparseArray<ArrayList<String>> attribute, Float tsuperblockwidth, Float tsuperblockheight, Float tsuperblockdepth, Character type, Integer columnnum) {
		synchronized(this){
		int tid2=tid*1000+superblocklinenumber.get(tid);
		int i=0;
		for (i=0;i<=atom.get(tid).size()-1;i++){			
			blockatom.get(tid2).add(atom.get(tid).get(i));
			blockxpos.get(tid2).add(xpos.get(tid).get(i));
			blockypos.get(tid2).add(ypos.get(tid).get(i));
			blockattribute.get(tid2).add(attribute.get(tid).get(i));
			blockcolumnnum.get(tid2).add(columnnum);
		}				
	       superblocklinewidth.get(tid).set(superblocklinenumber.get(tid), superblocklinewidth.get(tid).get(superblocklinenumber.get(tid))+tsuperblockwidth);
	        float maxtop=Math.max(superblocklineheight.get(tid).get(superblocklinenumber.get(tid))-superblocklinedepth.get(tid).get(superblocklinenumber.get(tid)), tsuperblockheight-tsuperblockdepth);
	        superblocklinedepth.get(tid).set(superblocklinenumber.get(tid), Math.max(superblocklinedepth.get(tid).get(superblocklinenumber.get(tid)),tsuperblockdepth)); 
	        superblocklineheight.get(tid).set(superblocklinenumber.get(tid),maxtop+superblocklinedepth.get(tid).get(superblocklinenumber.get(tid)));
	        superblocktype.get(tid).add(type);
	        return;		   
		}
	}
	
	public void add(int tid, ArrayList<String> atom,  
			ArrayList<Float> xpos,ArrayList<Float> ypos,ArrayList<String> attribute, Float tsuperblockwidth, Float tsuperblockheight, Float tsuperblockdepth, Character type, Integer columnnum) {
		synchronized(this){
		int tid2=tid*1000+superblocklinenumber.get(tid);
		
		for (int i=0;i<=atom.size()-1;i++){			
			blockatom.get(tid2).add(atom.get(i));
			blockxpos.get(tid2).add(xpos.get(i));
			blockypos.get(tid2).add(ypos.get(i));
			blockattribute.get(tid2).add(attribute.get(i));
			blockcolumnnum.get(tid2).add(columnnum);
		}		
	       superblocklinewidth.get(tid).set(superblocklinenumber.get(tid), superblocklinewidth.get(tid).get(superblocklinenumber.get(tid))+tsuperblockwidth);
	        float maxtop=Math.max(superblocklineheight.get(tid).get(superblocklinenumber.get(tid))-superblocklinedepth.get(tid).get(superblocklinenumber.get(tid)), tsuperblockheight-tsuperblockdepth);
	        superblocklinedepth.get(tid).set(superblocklinenumber.get(tid), Math.max(superblocklinedepth.get(tid).get(superblocklinenumber.get(tid)),tsuperblockdepth)); 
	        superblocklineheight.get(tid).set(superblocklinenumber.get(tid),maxtop+superblocklinedepth.get(tid).get(superblocklinenumber.get(tid)));
	        superblocktype.get(tid).add(type);
	        return;		   
		}
	}
	
}