////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Copyright 1999-2005, Hitek Software LLC
//http://www.sharewarejustice.com
//This source code is subject to change without any prior notice.  
//The source code is subject to a non-disclosure agreement. 
//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
import java.io.*;
import java.util.*;
import java.lang.*;
import java.text.*;
import java.net.*;

public class CollectData
{
	///////////////////////////////////////////////
	//POST METHOD
	String GET = "GET";
	String POST = "POST";
	////////////////////////////////////////////////
	public String GetParameterString(String method,String authorid, String authorpwd, String mode, String program, String version, String key, String key2)
	{
		try
		{
			ArrayList keys = new ArrayList();
			ArrayList values = new ArrayList();
			//add required author data
			//if method = GET, authorid and authorpwd = "***"
			if(method.equals(GET))
			{
				keys.add("authorid"); values.add("***");
				keys.add("authorpwd"); values.add("***");
			}
			if(method.equals(POST)) //for POST mode, send in authorid and authorpwd
			{
				keys.add("authorid"); values.add(authorid);
				keys.add("authorpwd"); values.add(authorpwd);
			}
			keys.add("mode"); values.add(mode);
			keys.add("program"); values.add(program);
			keys.add("version"); values.add(version);
			keys.add("key"); values.add(key);
			keys.add("key2"); values.add(key2);
			//add recommended data 
			//this should be noted in license agreement
			keys.add("owner"); values.add(GetRegisteredOwner());
			keys.add("organization"); values.add(GetRegisteredOrganization());
			keys.add("country"); values.add(GetCountry());
			keys.add("userdate"); values.add(GetUserdate());
			keys.add("timezone"); values.add(GetTimezone());
			keys.add("ip_internal"); values.add(GetIP());
			keys.add("computer"); values.add(GetComputer());
			keys.add("username"); values.add(GetUsername());
			keys.add("domain"); values.add(GetDomain());
			keys.add("os"); values.add(GetOS());
			//add optional data added by author from user collected input
			//for example from a user registration form
			keys.add("author1"); values.add("test.pl using fbEmail");
			keys.add("author2"); values.add("ReallyLongEmail@EmailCompany.com.long");
			keys.add("author3"); values.add("");
			keys.add("author4"); values.add("");
			keys.add("author5"); values.add("");
			keys.add("author6"); values.add("");
			keys.add("author7"); values.add("");
			keys.add("author8"); values.add("");
			keys.add("author9"); values.add("");
			keys.add("author10"); values.add("");
			//data that authors can collect from system
			//this information should be noted in license agreement
			keys.add("tracker1"); values.add("MAC number = ");
			keys.add("tracker2"); values.add("");
			keys.add("tracker3"); values.add("");
			keys.add("tracker4"); values.add("");
			keys.add("tracker5"); values.add("");
			keys.add("tracker6"); values.add("");
			keys.add("tracker7"); values.add("");
			keys.add("tracker8"); values.add("");
			keys.add("tracker9"); values.add("");
			keys.add("tracker10"); values.add("");
			//for testing purposes only, when using test.pl script
			//data posted to the website will be sent to email address below 
			keys.add("fbEmail");values.add("support@your_company.com");

			String parString = "";
			//important:  make sure to url encode all values
			for (int i = 0; i < keys.size(); i++)
			{
				values.set(i,URLEncoder.encode(values.get(i).toString()));
				parString += keys.get(i).toString() + "=" + values.get(i).toString() + "&";
			}
			//remove the & at the end of pars
			parString = parString.substring(0, parString.length() - 1);
			return parString;
		}
		catch (Exception e)
		{
			String err = e.toString();
			return null;
		}
	}
	///////////////////////////////////////////////
	private String GetRegisteredOwner()
	{
		try
		{
			//no available classes in java to access windows regisry
			//During installation, the IA installer reads 'RegisteredOwner' from registry
			//and saves it to a file. This function reads the 'RegisteredOwner' value from file
			//c#,c++ etc.. have Registry classes to read this value

			//read value from file created by installer
			return "-";
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetRegisteredOrganization()
	{
		try
		{
			//no available classes in java to access windows regisry
			//During installation, the IA installer reads 'RegisteredOwner' from registry
			//and saves it to a file. This function reads the 'RegisteredOwner' value from file
			//c#,c++ etc.. have Registry classes to read this value

			//read value from file created by installer
			return "-";
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetUserdate()
	{
		try
		{
			String date = DateFormat.getDateTimeInstance(DateFormat.LONG,DateFormat.FULL).format(new Date());
			return date;
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetCountry()
	{
		try
		{
				//get country name in us_en format
				String country = Locale.getDefault().getDisplayCountry(Locale.US);
				if(country==null)country="-";
				if(country.equals(""))country="-";
				return country;
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}    
	///////////////////////////////////////////////
	private String GetTimezone()
	{
		try
		{
			//get timezone name in us_en format
			String timeZone = TimeZone.getDefault().getDisplayName(Locale.US);
			if(timeZone==null)timeZone="-";
			if(timeZone.equals(""))timeZone="-";
			return timeZone;
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetComputer()
	{
		try
		{
			return InetAddress.getLocalHost().getHostName(); 
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetUsername()
	{
		try
		{
			return System.getProperty("user.name");
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetDomain()
	{
		try
		{
			//no available classes in java to read domain
			//During installation, the IA installer determines this value
			//and saves it to a file. This function reads the 'domain' value from file
			//c#,c++ etc.. have classes to read this value
			
			//read value from file created by installer
			return "-";
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetIP()
	{
		try
		{
			return InetAddress.getLocalHost().getHostAddress();
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}
	///////////////////////////////////////////////
	private String GetOS()
	{
		try
		{
			return System.getProperty("os.name");
		}
		catch (Exception e)
		{
			String err = e.toString();
			return "-";
		}
	}      
	///////////////////////////////////////////////
}

