/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.NonPlsqlTTCColumn;
import oracle.jdbc.ttc7.NonPlsqlTTCDataSet;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.PlsqlTTCDataSet;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class TTCAdapter {
    private MAREngine meg;

    public TTCAdapter(MAREngine mAREngine) {
        this.meg = mAREngine;
    }

    public PlsqlTTCDataSet createPlsqlTTCDataSet(DBType[] dBTypeArray, DBData[] dBDataArray, DBType[] dBTypeArray2, DBData[] dBDataArray2) throws SQLException, IOException {
        DBType[] dBTypeArray3 = dBTypeArray != null ? dBTypeArray : new DBType[]{};
        DBType[] dBTypeArray4 = dBTypeArray2 != null ? dBTypeArray2 : new DBType[]{};
        DBData[] dBDataArray3 = dBDataArray != null ? dBDataArray : new DBData[]{};
        DBData[] dBDataArray4 = dBDataArray2 != null ? dBDataArray2 : new DBData[]{};
        int n2 = dBTypeArray3.length > dBTypeArray4.length ? dBTypeArray3.length : dBTypeArray4.length;
        byte[] byArray = new byte[n2];
        PlsqlTTCColumn[] plsqlTTCColumnArray = this.createBindColumns(dBTypeArray3, dBDataArray3, dBTypeArray4, dBDataArray4, byArray);
        PlsqlTTCDataSet plsqlTTCDataSet = new PlsqlTTCDataSet(plsqlTTCColumnArray, byArray);
        return plsqlTTCDataSet;
    }

    private PlsqlTTCColumn[] createBindColumns(DBType[] dBTypeArray, DBData[] dBDataArray, DBType[] dBTypeArray2, DBData[] dBDataArray2, byte[] byArray) throws SQLException, IOException {
        PlsqlTTCColumn[] plsqlTTCColumnArray = new PlsqlTTCColumn[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 0;
            if (n2 < dBTypeArray.length && dBTypeArray[n2] == null && n2 < dBTypeArray2.length && dBTypeArray2[n2] == null) {
                DBError.check_error(435);
            }
            if (n2 < dBTypeArray2.length && dBTypeArray2[n2] != null) {
                if (dBDataArray2 == null || dBDataArray2[n2] == null) {
                    DBError.check_error(435);
                }
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] | 0x10);
                plsqlTTCColumnArray[n2] = new PlsqlTTCColumn(this.newTTCType(dBTypeArray2[n2]));
            }
            if (n2 < dBTypeArray.length && dBTypeArray[n2] != null) {
                if (dBDataArray[n2] == null) {
                    DBError.check_error(435);
                }
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] | 0x20);
                if (plsqlTTCColumnArray[n2] == null) {
                    plsqlTTCColumnArray[n2] = new PlsqlTTCColumn(this.newTTCType(dBTypeArray[n2]));
                }
            }
            if ((byArray[n2] & 0x10) > 0) {
                plsqlTTCColumnArray[n2].setOUT(this.newTTCItem(dBDataArray2[n2].getItem(0), dBTypeArray2[n2]));
            }
            if ((byArray[n2] & 0x20) > 0) {
                plsqlTTCColumnArray[n2].setIN(this.newTTCItem(dBDataArray[n2].getItem(0), dBTypeArray[n2]));
            }
            ++n2;
        }
        return plsqlTTCColumnArray;
    }

    public NonPlsqlTTCDataSet createNonPlsqlTTCDataSet(DBType[] dBTypeArray, DBData[] dBDataArray, int n2, boolean bl) throws IOException, SQLException {
        DBType[] dBTypeArray2 = dBTypeArray != null ? dBTypeArray : new DBType[]{};
        DBData[] dBDataArray2 = dBDataArray != null ? dBDataArray : new DBData[]{};
        int n3 = dBDataArray2.length == 0 ? 0 : n2;
        NonPlsqlTTCDataSet nonPlsqlTTCDataSet = new NonPlsqlTTCDataSet(this.createNonPlsqlTTCColumnArray(dBTypeArray2, dBDataArray2, n3, bl), n3);
        return nonPlsqlTTCDataSet;
    }

    private NonPlsqlTTCColumn[] createNonPlsqlTTCColumnArray(DBType[] dBTypeArray, DBData[] dBDataArray, int n2, boolean bl) throws IOException, SQLException {
        int n3 = 0;
        if (dBDataArray != null && dBDataArray.length != 0 && dBTypeArray != null && n2 != 0) {
            n3 = dBDataArray.length;
        }
        NonPlsqlTTCColumn[] nonPlsqlTTCColumnArray = new NonPlsqlTTCColumn[n3];
        int n4 = 0;
        while (n4 < nonPlsqlTTCColumnArray.length) {
            nonPlsqlTTCColumnArray[n4] = new NonPlsqlTTCColumn(this.newTTCType(dBTypeArray[n4]), n2, bl, this.newTTCItemArray(dBDataArray[n4], n2, dBTypeArray[n4]));
            ++n4;
        }
        return nonPlsqlTTCColumnArray;
    }

    private TTIoac newTTCType(DBType dBType) throws IOException, SQLException {
        TTIoac tTIoac = (TTIoac)dBType;
        tTIoac.init(dBType);
        return tTIoac;
    }

    private TTCItem[] newTTCItemArray(DBData dBData, int n2, DBType dBType) throws SQLException, IOException {
        int n3 = dBData.getNItems() == 0 ? 0 : n2;
        TTCItem[] tTCItemArray = new TTCItem[n3];
        int n4 = 0;
        while (n4 < tTCItemArray.length) {
            tTCItemArray[n4] = this.newTTCItem(dBData.getItem(n4), dBType);
            ++n4;
        }
        return tTCItemArray;
    }

    private TTCItem newTTCItem(DBItem dBItem, DBType dBType) throws SQLException, IOException {
        if (dBItem == null || dBType == null) {
            DBError.check_error(440);
        }
        return (TTCItem)dBItem;
    }
}

