/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import unity.functions.Expression;
import unity.predicates.SortComparator;
import unity.relational.Relation;
import unity.relational.Tuple;

public class ExprSortComparator
extends SortComparator {
    private Expression[] expressions;

    public ExprSortComparator(Expression[] exp, boolean[] sa) {
        this.expressions = exp;
        this.sortAsc = sa;
        this.numAttrs = exp.length;
    }

    public int sqlcompare(Object o1, Object o2) {
        Tuple t1 = (Tuple)o1;
        Tuple t2 = (Tuple)o2;
        int i = 0;
        while (i < this.numAttrs) {
            int val;
            Comparable c1 = (Comparable)this.expressions[i].evaluate(t1);
            Comparable c2 = (Comparable)this.expressions[i].evaluate(t2);
            if (c1 == null || c2 == null) {
                if (c1 == null && c2 == null) {
                    return 0;
                }
                val = 1;
                val = c1 == null ? -1 : 1;
                if (!this.sortAsc[i]) {
                    val *= -1;
                }
                return val;
            }
            val = c1.compareTo(c2);
            if (this.sortAsc[i]) {
                if (val > 0) {
                    return 1;
                }
                if (val < 0) {
                    return -1;
                }
            } else {
                if (val < 0) {
                    return 1;
                }
                if (val > 0) {
                    return -1;
                }
            }
            ++i;
        }
        return 0;
    }

    public String toString(Relation relation) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.expressions[0].toString(relation));
        if (this.sortAsc[0]) {
            sb.append(" ASC");
        } else {
            sb.append(" DESC");
        }
        int i = 1;
        while (i < this.expressions.length) {
            sb.append(", " + this.expressions[i].toString(relation));
            if (this.sortAsc[i]) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            ++i;
        }
        return sb.toString();
    }
}

