// --------------------------------------------------------------
// WinPlot3DF.cpp : implementation of the WinPlot3DF class.
// Concrete plotting class derived from Plot3DF abstract class.
//

#include "stdafx.h"
#include "WinPlot3DF.h"

/*
double WinPlot3DF::Func(double x,double y,double z)
{
	#define	PI	(3.141592654)
	double f;
	double c1,c2,c3,c4,c5,c6,c7,c8;

	return(f);
}
*/

// --------------------------------------------------------------
// Parametric equations
// Note: don't need to implement unless you use parametric plotting
double WinPlot3DF::XParametric(double u,double v)
{
	return(0.);
}

double WinPlot3DF::YParametric(double u,double v)
{
	return(0.);
}

double WinPlot3DF::ZParametric(double u,double v)
{
	return(0.);
}

// --------------------------------------------------------------
// clipping function: return: 0=clipped, 1=drawable
int WinPlot3DF::Within(double x,double y,double z)
{
	double r,s,theta;
	r = sqrt(x*x + y*y + z*z);
	if (r==0.) return(1);
	theta = acos((x+y+z)/(r*sqrt(3.)));
	s = r*sin(theta);
	if (fabs(s) > m_sphere_radius) return(0);
	return(1);
}

// --------------------------------------------------------------
// The mathematical equation used to define the "color" of the surface.
long WinPlot3DF::Color(double x,double y,double z)
{
	#define NCOLORS	6
	#define NSHADES	(NCOLORS*2)
	static long ColorValues[NCOLORS] = 
	{   //   R   G   B
		RGB(255,000,000),	// red
		RGB(255,128,000),	// orange
		RGB(200,200,000),	// yellow
		RGB(000,160,000),	// green
		RGB(000,000,200),	// blue
		RGB(128,000,128)	// violet
	};
	int iz;

	/*
	double theta;
	theta = atan2(y,x);
	iz = abs((int)(theta*NSHADES/(2.*PI)));
	*/

	double d,r;
	d = x + y + z;
	r = m_sphere_radius;
	if (r == 0.0) r=1.e-6;
	iz = abs((int)(d*NSHADES/(2.*r)));

	if ((iz & 1)==0) return( RGB(000,000,000) ); // black band between each color
	iz = iz % (NSHADES-1);
	return( ColorValues[iz] );
}

/*	<><><><><><><><><><><><><>  WinPlot3DF.cpp  <><><><><><><><><><><><><><> */
