(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    844409,      33148]*)
(*NotebookOutlinePosition[    845558,      33185]*)
(*  CellTagsIndexPosition[    845514,      33181]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Demos for the SuperMenu newsletter", "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Initialization"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDirectory["\<JuHa:Mathematica 3.0 Files:Omat:HT\>"]\)], "Input"],

Cell[BoxData[
    \("JuHa:Mathematica 3.0 Files:Omat:HT"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["<<HTessellate.m", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(HTessellate::"usage" \( : \ \) 
      "HTessellate is a collection of packages for forming, manipulating and  \
visualizing geometric objects in two-dimensional hyperbolic  geometry. See \
the documentation for the command HDraw."\)], "Message"]
}, Open  ]],

Cell["\<\
black = GrayLevel[0];
white = GrayLevel[1];
color0 = black;
color1 = GrayLevel[0.7];
color2 = GrayLevel[0.85];
color3 = GrayLevel[0.95];\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Drawing geodesics"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
poly = NGP[RegularPolygon[18,6*Pi/7]];
ln = Geodesic[ZPoint[0.2-0.3*I],ZPoint[-0.2+0.3*I]];
ln2 = Geodesic[ZPoint[0.9+0.1*I],ZPoint[-0.3+0.8*I]];
poly2 = Inversion[ln2][poly];
diag = Diagonals[poly2] /. Line -> Geodesic;\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
pt = ZPoint[0.4+0.4*I];
ln = Geodesic[ZPoint[0.2-0.3*I],ZPoint[-0.2+0.3*I]];
gd = Map[Geodesic[pt, ZPoint[#]]&, 
\t{0.6-0.2*I, 0.8-0.1*I, 0.8+0.1*I, 0.7+0.2*I, 0.7+0.3*I,
\t-0.2+0.9*I}];\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
SetOptions[PointLabel, DefaultFont -> {\"Times-Roman\", 18}];
glabel = {PointLabel[Point[{-0.1,-0.05}], \"L\"],
\tPointLabel[Point[{0.25,0.4}], \"p\"]};\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["HDraw[{ln,Take[diag,{4,Length[diag]}],glabel}]", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[.45238 .47619 -7.5 -8 ]
[.45238 .47619 7.5 8 ]
[.61905 .69048 -6.5 -8 ]
[.61905 .69048 6.5 8 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.76414 .10379 m
.23586 .89621 L
s
newpath
1.1642 .72267 .51379 155.708 241.358 arc
s
newpath
.96425 .84465 .32795 161.145 272.034 arc
s
newpath
.86142 .90739 .26425 167.449 289.395 arc
s
newpath
.78424 .95447 .24612 175.31 300.644 arc
s
newpath
.70841 1.00073 .25963 186.003 308.802 arc
s
newpath
.6114 1.05992 .3149 202.224 315.272 arc
s
gsave
.45238 .47619 -68.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
63.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(L) show
74.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.61905 .69048 -67.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
72.000000 15.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{274, 274},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004B00014PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l04`000?l04`000?l04`000?l04`000?l0
4`000?l04`000?l04`0007`06Omm0000M008oaT02?me0000K`05obT01Om`0000J`04oc<01Om[0000
IP05oc`01?mW0000H`03odD00omT0000H003od/00omQ0000G@03oe400omN0000F`02oeL01?mJ0000
F003oed00omG0000E@03of<000?o0000E00005800omW0003o`0005<0001A0003o`0006T00omB0000
C`02ofl00om?0000C003og@00_m=0000B`000ol0001g0003o`0004X0001900;oN`03odT0001600?o
P002odL000150003o`0008<000?o0000A00004<00_n700;oA000048000?o0000R@000ol000110000
@@000ol0002;0003o`00040000100003o`0008d000?o0000?`0003h00_n@00Co?P0003`00_nA0003
o`0000800_ll0000>`000ol0002@0003o`0000D000?o0000>@0003T00_nC0003o`0000H000?o0000
>00003P000?o0000TP000ol000080003o`0003L0000f00;oU0000ol0000:00;o=`0003D000?o0000
U0000ol0000<0003o`0003@0000d0003o`0009@000?o00003P000ol0000c0000=0000ol0002C0003
o`0000l000?o0000<`0003<000?o0000U0000ol0000@0003o`000380000b0003o`0009@000?o0000
4P000ol0000a0000<@000ol0002D0003o`0001@000?o0000<00002l00_nG0003o`0001D00_l`0000
;P000ol0002F0003o`0001P000?o0000;@0002d000?o0000UP000ol0000J0003o`0002`0000/0003
o`0009L000?o00006`000ol0000[0000:`000ol0002G0003o`0001d000?o0000:P0002/000?o0000
UP000ol0000N0003o`0002X0000Z0003o`0009L000?o00007`000ol0000Y0000:@000ol0002G0003
o`00024000?o0000:00002P000?o0000U`000ol0000S0003o`0002L0000V00;oVP000ol0000T00;o
9`0002D000?o0000V@000ol0000W0003o`0002@0000T0003o`0009T000?o0000:@000ol0000S0000
90000ol0002I0003o`0002T000?o00008`0002<000?o0000V@000ol0000[0003o`000280000R0003
o`0009T000?o0000;@000ol0000Q00008@000ol0002J0003o`0002d000?o00008@00020000?o0000
VP000ol0000_0003o`000200000P0003o`0009T000?o0000<@000ol0000O00007`000ol0002J0003
o`00038000?o00007P0001h000?o0000VP000ol0000d0003o`0001d0000N0003o`0009T000?o0000
=@000ol0000M00007@000ol0002J0003o`0003H000?o0000700001d000?o0000V@000ol0000g0003
o`0001`0000L0003o`0009T000?o0000>@000ol0000K00006`000ol0002J0003o`0003X000?o0000
6P0001/000?o0000V@000ol0000k0003o`0001X0000J0003o`0009T000?o0000?@000ol0000I0000
6@000ol0002J0003o`0003h000?o0000600001T000?o0000V@000ol0000o0003o`0001P0000H0003
o`0009T000?o0000@@000ol0000G00005`000ol0002J0003o`00048000?o00005P0001L000?o0000
V@000ol000130003o`0001H0000F0003o`0009T000?o0000A@000ol0000E00005P000ol0002I0003
o`0004@00_lG00005P000ol0002H0003o`0004800ol00`3o000F00005@000ol0002H0003o`000480
00?o00000`000ol0000D000050000ol0002I0003o`00044000?o00001@000ol0000C000050000ol0
002H0003o`00044000?o00001P000ol0000C00004`000ol0002H0003o`0004000_l:0003o`000180
000C0003o`0009P000?o0000?@03o``000?o00004P0001<000?o0000U`000ol0000m0003o`0000d0
00?o00004P00018000?o0000U`000ol0000m0003o`0000l000?o00004@00018000?o0000U`000ol0
000l0003o`00014000?o00004000014000?o0000U`000ol0000k00;o50000ol0000@000040000ol0
002G0003o`0003/000?o00005@000ol0000?000040000ol0002G0003o`0003T00_lH0003o`0000l0
000?0003o`0009L000?o0000>@000ol0000H0003o`0000l0000?0003o`0009H000?o0000>@000ol0
000J0003o`0000h0000?0003o`0009H000?o0000>0000ol0000K0003o`0000h0000>0003o`0009H0
00?o0000>0000ol0000M0003o`0000d0000>0003o`0009D000?o0000>0000ol0000N0003o`0000d0
000>0003o`0009D000?o0000=`000ol0000O0003o`0000d0000=0003o`0009D000?o0000=`000ol0
000Q0003o`0000`0000=0003o`0009@000?o0000=`000ol0000R0003o`0000`0000=0003o`0009@0
00?o0000=P000ol0000S0003o`0000`0000<0003o`0009@000?o0000=P000ol0000U0003o`0000/0
000<0003o`0009<000?o0000=@02obP000?o00002`0000`000?o0000T`000ol0000d0003o`0002P0
00?o00002`0000/000?o0000T`000ol0000d0003o`0002X000?o00002P0000/000?o0000TP000ol0
000e0003o`0002X000?o00002P0000/000?o0000TP000ol0000d0003o`0002/000?o00002P0000X0
00?o0000TP000ol0000d0003o`0002d000?o00002@0000X000?o0000T@000ol0000d0003o`0002h0
00?o00002@0000X000?o0000T@000ol0000c0003o`0002l000?o00002@0000X000?o0000T0000ol0
000d0003o`0002l000?o00002@0000X000?o0000S`000ol0000d0003o`00030000?o00002@0000T0
00?o0000T0000ol0000c0003o`00038000?o0000200000T000?o0000S`000ol0000c0003o`0003<0
00?o0000200000T000?o0000SP000ol0000c0003o`0003@000?o0000200000T000?o0000SP000ol0
000c0003o`0003@000?o0000200000T000?o0000S@000ol0000c0003o`0003D000?o0000200000P0
00?o0000S@000ol0000c0003o`0003L000?o00001`0000P000?o0000S@000ol0000b0003o`0003P0
00?o00001`0000P000?o0000S0000ol0000b0003o`0003T000?o00001`0000P000?o0000R`000ol0
000c0003o`0003T000?o00001`0000P000?o0000R`000ol0000b0003o`0003X000?o00001`0000L0
00?o0000R`000ol0000b0003o`0003`000?o00001P0000L000?o0000RP000ol0000c0003o`0003`0
00?o00001P0000L000?o0000RP000ol0000b0003o`0003d000?o00001P0000L000?o0000R@000ol0
000b0003o`0003h000?o00001P0000L000?o0000R0000ol0000c0003o`0003h000?o00001P0000L0
00?o0000R0000ol0000b0003o`0003l000?o00001P0000L000?o0000Q`000ol0000b0003o`000400
00?o00001P0000L000?o0000QP000ol0000c0003o`00040000?o00001P0000H000?o0000K@0:oa00
00?o0000<P000ol000120003o`0000D000060003o`0006l00_l50003o`0000d000?o0000<`000ol0
00120003o`0000D000060003o`0006l00_l60003o`0000/000?o0000<`000ol000130003o`0000D0
00060003o`0006l00_lD0003o`00038000?o0000A0000ol0000500001P000ol0001_00;o4`000ol0
000c0003o`0004@000?o00001@0000H000?o0000K`02oa8000?o0000<`000ol000150003o`0000D0
00060003o`0006l00_lB0003o`00038000?o0000AP000ol0000500001P000ol0001_00;o4@000ol0
000c0003o`0004H000?o00001@0000H000?o0000K`02oa0000?o0000<`000ol000170003o`0000D0
00060003o`0006l00_l@0003o`0003<000?o0000A`000ol0000500001P000ol0001_00;o3`000ol0
000d0003o`0004L000?o00001@0000H000?o0000K`02o`h000?o0000=0000ol000180003o`0000D0
00060003o`0006d01_l<0003o`0003<000?o0000B@000ol0000500001P000ol0001n0003o`0003@0
00?o0000B@000ol0000500001P000ol0001m0003o`0003@000?o0000BP000ol0000500001P000ol0
001m0003o`0003@000?o0000BP000ol0000500001P000ol0001l0003o`0003D000?o0000>`0@o`L0
00060003o`0007/000?o0000=@000ol0000d00So3`000ol0000500001P000ol0001k0003o`0003D0
00?o0000<P02oaL000?o00001@0000H000?o0000NP000ol0000f0003o`0002d01OlI0003o`0000D0
00060003o`0007T000?o0000=P000ol0000[00?o7P000ol0000500001P000ol0001i0003o`0003H0
00?o0000:003ob4000?o00001@0000H000?o0000N0000ol0000g0003o`0002H00_lT0003o`0000D0
00060003o`0007L000?o0000=`000ol0000T00?o9P000ol0000500001`000ol0001f0003o`0003H0
00?o000090000ol0000V0003o`0000H000070003o`0007D000?o0000=`000ol0000S0003o`0002L0
00?o00001P0000L000?o0000M0000ol0000h0003o`0002400_lZ0003o`0000H000070003o`0007@0
00?o0000=`000ol0000O00?o;0000ol0000600001`000ol0001c0003o`0003P000?o00007@02obl0
00?o00001P0000L000?o0000LP000ol0000i0003o`0001`000?o0000;`000ol0000600001`000ol0
001b0003o`0003P000?o00006`02oc8000?o00001P0000L000?o0000L@000ol0000i0003o`0001X0
00?o0000<P000ol00006000020000ol0001_0003o`0003X000?o00006@000ol0000b0003o`0000L0
00080003o`0006l000?o0000>@000ol0000H00;o=@000ol00007000020000ol0001^0003o`0003X0
00?o00005`000ol0000e0003o`0000L000080003o`0006d000?o0000>`000ol0000F0003o`0003H0
00?o00001`0000P000?o0000K@000ol0000k0003o`0001D000?o0000=`000ol0000700002@000ol0
001[0003o`0003`000?o000050000ol0000g0003o`0000P000090003o`0006X000?o0000?0000ol0
000D0003o`0003P000?o0000200000T000?o0000JP000ol0000l0003o`0001<000?o0000>@000ol0
000800002@000ol0001Y0003o`0003d000?o00004P000ol0000j0003o`0000P0000:0003o`0006L0
00?o0000?@000ol0000B0003o`0003/000?o0000200000X000?o0000I`000ol0000m0003o`000100
0_lm0003o`0000T0000:0003o`0006H000?o0000?P000ol0000?0003o`0003d000?o00002@0000X0
00?o0000I@000ol0000o0003o`0000h000?o0000?P000ol0000900002P000ol0001U0003o`0003l0
00?o00003@000ol0000o0003o`0000T0000;0003o`0006<000?o0000?`000ol0000=0003o`0003l0
00?o00002P0000/000?o0000HP000ol000100003o`0000`000?o0000@0000ol0000:00002`000ol0
001R0003o`00040000?o000030000ol000100003o`0000X0000<0003o`00060000?o0000@@000ol0
000;0003o`00040000?o00002`0000`000?o0000G`000ol000120003o`0000/000?o00007`0Bo`l0
00?o00002`0000`000?o0000G`000ol000120003o`0000X000?o00006@07oa801?l;0003o`0000/0
000=0003o`0005d000?o0000@`000ol000090003o`0001L00olM00Go1@000ol0000<00003@000ol0
001L0003o`0004<000?o00002@000ol0000D00Co9@06o`h0000=0003o`0005`000?o0000@`000ol0
00080003o`0001<00_l^0003o`0000`0000>0003o`0005X000?o0000A0000ol000080003o`000100
0ol_0003o`0000d0000>0003o`0005T000?o0000A@000ol000070003o`0000l00_lb0003o`0000d0
000?0003o`0005P000?o0000=`04o`X000?o00001P000ol0000>00;o<`000ol0000>00003`000ol0
001G0003o`0003T00_l;0003o`0000D000?o00003@02ocD000?o00003P0000l000?o0000EP000ol0
000j00;o2`000ol000050003o`0000/00_lg0003o`0000h0000@0003o`0005D000?o0000>P02o`/0
00?o000010000ol0000900?o>0000ol0000?000040000ol0001D0003o`0003/01Ol70003o`0000D0
00?o00001`02oc/000?o00003`00010000?o0000D`000ol0000l00;o0P02o`H000?o00001@000ol0
00060003o`0003/000?o00003`00014000?o0000DP000ol0000l00;o0`02o`D000?o000010000ol0
00060003o`0003/000?o00004000018000?o0000D0000ol0000m00;o0`02o`D000?o000010000ol0
000400;o?@000ol0000A00004P000ol0001?0003o`0003h00_l300;o1@000ol000030003o`0000@0
00?o0000?@000ol0000A00004`000ol0001>0003o`0003h00_l300;o1@000ol000020003o`0000D0
00?o0000?0000ol0000B00004`000ol0001=0003o`0003h01?l0103oool50003o`00008000?o0000
0`02ocl000?o00004P0001<000?o0000C0000ol000110003o`3o00;o1P001Ol0003o00D000?o0000
3`0Coad000?o00004P0001@000?o0000B`000ol0001<0005o`000?l010000ol0000900Oo4`05oaL0
00?o00004`0001@000?o0000BP000ol0001=0004o`00o`@000?o00002002oal01?lC0003o`0001<0
000D0003o`0004T000?o0000CP001?l00?l30003o`0000@01OlU00Go3P000ol0000C00005@000ol0
00180003o`0004h000?o0?l00`000ol0000300;o;`02o`/000?o0000500001H000?o0000AP000ol0
001?0003o`3o008000?o00000P02oc<00_l80003o`0001D0000F0003o`0004D000?o0000D0001Ol0
o`3o00<00_lg00;o1P000ol0000E00005`000ol000140003o`0005000_l0103o0002oc/00_l30003
o`0001H0000G0003o`0004<000?o0000D@02o`040?ooocl00_l00`3o000G00005`000ol000120003
o`0005801?l201Co;@02oaP0000H0003o`00044000?o0000?@0Koa@01olV0003o`0001L0000I0003
o`0003l000?o0000>@05oa801?l00`3oo`03oaX01?lQ0003o`0001P0000I0003o`0003h000?o0000
=@05oa@00ol0103o0?l600Go6@03oah000?o0000600001X000?o0000?@000ol0000`00Go5@04o`80
0_l00`3oo`0;00?o6@02oa/000?o00006@0001/000?o0000>`000ol0000^00?o6002o`D000Ko003o
0?l>00Go5P02oaP000?o00006P0001`000?o0000>@000ol0000]00;o6003o`H000Go003o0002oa<0
0_lF00;o5@000ol0000K00007@000ol0000h0003o`0002X00olH00;o20002Ol0003o0?l0o`0D00;o
5P02oa8000?o0000700001d000?o0000=`000ol0000Y00;o6@02o`T000Oo0000o`3o008000?o0000
5003oaD00_l@0003o`0001`0000N0003o`0003D000?o0000:002oaX000?o000020000ol000020003
o`3o008000?o00005`000ol0000D00?o30000ol0000M00007P000ol0000e0003o`0002H00_lK0003
o`0000L00_l40004o`00o`8000?o000060000ol0000F00;o2P000ol0000M00007`000ol0000c0003
o`0002H000?o00006@02o`T000?o000010001?l00?l20003o`0001T00olG0003o`0000H000?o0000
7P00020000?o0000<@000ol0000U00;o6P02o`/000?o00000`001Ol0003o008000?o00007002oaH0
00?o000010000ol0000O000080000ol0000a0003o`0002<00_lK0003o`0000X000?o000010001Ol0
003o008000?o00007P000ol0000D0003o`0000<000?o00007`00024000?o0000;`000ol0000R00;o
70000ol0000:0003o`0000@000Go0000o`030003o`0001l000?o00005002o`8000?o000080000280
00?o0000;@000ol0000R0003o`0001X00_l<0003o`0000D000Go0000o`040003o`0001l00_lF00;o
8`00028000?o0000;@000ol0000P00;o70000ol0000;0003o`0000D000?o00000P000ol000020003
o`00024000?o000050000ol0000Q00008`000ol0000[0003o`00020000?o000070000ol0000;0003
o`0000D000?o00000P000ol000020003o`00028000?o00004P000ol0000R00009002obX000?o0000
80000ol0000K00;o3@000ol000050003o`0000<000?o00000P000ol0000S00?o3`02obD0000V0003
o`0002L000?o00007`000ol0000K0003o`0000`000?o00001P000ol000030003o`00008000?o0000
9P000ol0000;0003o`0002D0000W0003o`0002D000?o00007`000ol0000K0003o`0000`000?o0000
1P000ol000040003o`00008000?o00009`000ol000090003o`0002H0000X0003o`0002<000?o0000
7P02oad000?o00003@000ol000060003o`0000@000?o00000`000ol0000W0003o`0000L000?o0000
9`0002T000?o00008P000ol0000M0003o`0001d000?o000030000ol000070003o`0000<000?o0000
10000ol0000X0003o`0000D000?o0000:00002T000?o00008@000ol0000M0003o`0001d000?o0000
3@000ol000060003o`0000@000?o000010000ol0000Y0003o`0000@000?o0000:00002X000?o0000
7`000ol0000M0003o`0001d000?o00003@000ol000070003o`0000@000?o000010000ol0000Z0003
o`00008000?o0000:@0002/000?o00007P000ol0000L0003o`0001d000?o00003P000ol000060003
o`0000D000?o000010000ol0000[0004o`00ob`0000/0003o`0001`000?o000070000ol0000M0003
o`0000h000?o00001`000ol000050003o`0000D000?o0000:`02obd0000]00;o6`000ol0000L0003
o`0001d000?o00003`000ol000070003o`0000D000?o00001@000ol0000Z00;o;P0002l000?o0000
60000ol0000K0003o`0001d000?o00003`000ol000080003o`0000D000?o00001@000ol0000Y0003
o`0002h0000`0003o`0001H000?o00006`000ol0000N0003o`0000l000?o000020000ol000050003
o`0000D000?o0000:0000ol0000_0000<@000ol0000D0003o`0001/000?o00007P000ol0000?0003
o`0000P000?o00001P000ol000050003o`0002L000?o0000<000038000?o00004`000ol0000J0003
o`0001h000?o000040000ol000080003o`0000H000?o00001P000ol0000U0003o`000340000b0003
o`00018000?o00006P000ol0000N0003o`00010000?o00002@000ol000060003o`0000H000?o0000
9@000ol0000a0000<`000ol0000@0003o`0001/000?o00007P000ol0000@0003o`0000T000?o0000
1P000ol000060003o`0002@000?o0000<P0003@00_l@0003o`0001X000?o00007P000ol0000@0003
o`0000T000?o00001`000ol000070003o`0002400_le0000=P000ol0000<0003o`0001X000?o0000
7`000ol0000@0003o`0000T000?o000020000ol000060003o`00020000?o0000=@0003L000?o0000
2P000ol0000J0003o`0001l000?o000040000ol0000:0003o`0000P000?o00001P000ol0000N00;o
>00003P000?o00002@000ol0000J0003o`0001l000?o000040000ol0000:0003o`0000P000?o0000
1`000ol0000L0003o`0003P0000i00;o20000ol0000J0003o`0001l000?o000040000ol0000;0003
o`0000P000?o00001`000ol0000K0003o`0003T0000k0003o`0000@000?o00006P000ol0000P0003
o`00010000?o00002`000ol000080003o`0000L000?o00006P000ol0000j0000?003o`<000?o0000
6@000ol0000P0003o`00014000?o00002`000ol000080003o`0000P000?o00005`02ocd0000o0003
o`3o01`000?o000080000ol0000A0003o`0000/000?o000020000ol000080003o`0001D00_lo0000
@0000ol0000J0003o`00024000?o00004@000ol0000;0003o`0000P000?o000020000ol0000D0003
o`0003l0001100;o6P000ol0000P0003o`00014000?o000030000ol000090003o`0000P000?o0000
4@02od8000130003o`0001H000?o00008@000ol0000A0003o`0000`000?o00002@000ol000080003
o`00010000?o0000@P0004@00_lE0003o`00024000?o00004P000ol0000<0003o`0000T000?o0000
20000ol0000>00;oA@0004H000?o00004P000ol0000Q0003o`00018000?o000030000ol000090003
o`0000T000?o000030000ol000150000A`03oa0000?o00008@000ol0000B0003o`0000d000?o0000
2@000ol000090003o`0000X00_m80000BP02o`h000?o00008@000ol0000B0003o`0000d000?o0000
2@000ol0000:0003o`0000H00om:0000C0000ol0000:0003o`00024000?o00004`000ol0000=0003
o`0000X000?o00002@000ol000050003o`0004/0001=00?o2@000ol0000Q0003o`0001<000?o0000
3@000ol0000:0003o`0000T000?o00000`02odh0001@00?o1@000ol0000R0003o`0001<000?o0000
3@000ol0000:0003o`0000X000?o0?l00_m@0000D`000ol000020003o`00028000?o00004`000ol0
000=0003o`0000X000?o00002@03oe<0001D0005o`000?l090000ol0000C0003o`0000d000?o0000
2P000ol000080003o`0005@0001E00?o90000ol0000D0003o`0000d000?o00002`000ol0000500;o
E`0005P00_lR0003o`0001@000?o00003@000ol0000;0003o`0000800omI0000FP03oal000?o0000
4`000ol0000>0003o`0000`000Co0?ooG00005d00olL0003o`0001<000?o00003P000ol0000;00?o
GP0006000olH0003o`0001@000?o00003`000ol0000700?oH@0006<00olE0003o`0001@000?o0000
3`000ol0000400?oI00006H01Ol@0003o`0001@000?o00003`000ol0o`04ofL0001[00Go2`000ol0
000D0003o`0000`01Om/0000L005o`H000?o000050000ol0000700GoL@0007D02?lF00WoMP0007d0
5omn0000o`0C0000o`0C0000o`0C0000o`0C0000o`0C0000o`0C0000\
\>"],
  ImageRangeCache->{{{0, 273}, {273, 0}} -> {-1.05001, -1.05001, 0.00769239, 
  0.00769239}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["A triangle", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
pts = Map[RotatePoint[#,-Pi/2]&, Map[ZPoint, {0.3 + 0.6*I, -0.6 + \
0.5*I, 
        0.1 - 0.8*I}]];
poly = Polygon[pts];
sides = {Line[pts[[1]],pts[[2]]], Line[pts[[2]],pts[[3]]],
        Line[pts[[3]],pts[[1]]]};
geodsides = sides /. Line -> Geodesic;
bisect = Bisectors[poly];
bpoint = HSolve[Make[bisect[[1]]],Make[bisect[[2]]]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{{color3, Thickness[0.005], 
        poly /. Polygon -> FilledPolygon},
        Thickness[0.003], bisect,
        Thickness[0.002], geodsides,
        PointSize[0.02], pts, bpoint}]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.95 g
.11905 .45238 m
.14929 .45914 L
.17936 .46666 L
.20923 .47492 L
.23888 .48392 L
.2683 .49365 L
.29747 .50412 L
.32637 .51531 L
.35498 .52722 L
.38329 .53983 L
.41127 .55315 L
.43892 .56715 L
.4662 .58185 L
.49311 .59721 L
.51963 .61325 L
.54575 .62993 L
.57144 .64727 L
.59669 .66524 L
.62148 .68383 L
.6458 .70303 L
.66964 .72283 L
.69298 .74322 L
.7158 .76419 L
.7381 .78571 L
.7381 .78571 L
.72622 .75572 L
.71662 .72493 L
.70936 .6935 L
.70448 .66161 L
.702 .62945 L
.70194 .5972 L
.7043 .56503 L
.70906 .53313 L
.7162 .50167 L
.72568 .47084 L
.73744 .4408 L
.75142 .41173 L
.76754 .38379 L
.78571 .35714 L
.78571 .35714 L
.76202 .36548 L
.73821 .37346 L
.71427 .38107 L
.69023 .38833 L
.66608 .39522 L
.64182 .40174 L
.61748 .4079 L
.59304 .41369 L
.56851 .41911 L
.54391 .42416 L
.51923 .42883 L
.49449 .43313 L
.46968 .43706 L
.44482 .44061 L
.4199 .44379 L
.39494 .44659 L
.36995 .44901 L
.34491 .45105 L
.31985 .45272 L
.29477 .454 L
.26967 .45491 L
.24456 .45544 L
.21944 .45558 L
.19433 .45535 L
.16922 .45474 L
.14413 .45375 L
.11905 .45238 L
F
0 g
.005 w
[ ] 0 setdash
newpath
1.13165 .61251 .42998 156.246 216.434 arc
s
newpath
-0.13732 1.66999 1.2443 281.89 314.712 arc
s
newpath
.22222 -1.20635 1.66194 70.1805 93.5593 arc
s
.003 w
newpath
1.13165 .61251 .42998 156.246 183.7 arc
s
newpath
-0.13732 1.66999 1.2443 281.89 297.854 arc
s
newpath
.22222 -1.20635 1.66194 70.1805 83.1897 arc
s
.002 w
newpath
1.13165 .61251 .42998 142.181 238.019 arc
s
newpath
-0.13732 1.66999 1.2443 277.637 319.52 arc
s
newpath
.22222 -1.20635 1.66194 64.7654 96.7424 arc
s
.02 w
.78571 .35714 Mdot
.7381 .78571 Mdot
.11905 .45238 Mdot
.7381 .78571 Mdot
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l06`000?l06`000?l06`000?l06`000?l0
6`000?l06`000?l06`0008<04on40000N@0:oa<02_mj0000M005obL01Ome0000K`05oc401Om`0000
JP05oc/01Om[0000I`03odD00omX0000I003od/00omU0000H@03oe400omR0000GP03oeL00omO0000
F`03oed00omL0000F@02of<00_mJ0000EP03ofL00omG0000E002ofd00omD0000D@03og800_mB0000
D0000ol0001e0003o`0004l0001>00;oN@03odh0001;00?oOP02od`0001:0003o`00084000?o0000
B@0004P00_n500;oB@0004L000?o0000Q`000ol000160000A@02oh/00_m60000A0000ol0002=0003
o`0004<0001200;oT@02od<0001000;oU@02od40000o0003o`0009L000?o0000?P0003d00_nK00;o
?P0003`000?o0000W@000ol0000k0000>`000ol0002O0003o`0003X0000j0003o`000:4000?o0000
>@0003P00_nU0003o`0003P0000g0003o`000:H000?o0000=`0003H000?o0000Z0000ol0000f0000
=@000ol0002Z00;o=P0003@000?o0000[@000ol0000c0000<`000ol0002_0003o`000380000b0003
o`000;4000?o0000<@00034000?o0000/`000ol0000`0000<0000ol0002e0003o`0002l0000_0003
o`000;L000?o0000;P0002h000?o0000^@000ol0000]0000;@000ol0002k0003o`0002`0000/0003
o`000;d000?o0000:`0002/000?o0000_`000ol0000Z0000:P000ol000310003o`0002T0000Y0003
o`000<<000?o0000:00002P000?o0000a@000ol0000W0000:0000ol000360003o`0002H0000W0003
o`000<P000?o00009@0002H000?o0000bP000ol0000T00009@000ol0003;0003o`0002@0000T0003
o`000<d000?o00008`0002<000?o0000c`000ol0000R00008P000ol0003A0003o`000240000Q0003
o`000=<000?o00008000024000?o0000d`000ol0000P000080000ol0003E0003o`0001l0000O0003
o`000=L000?o00007P0001l000?o0000e`000ol0000N00007P000ol0003I0003o`0001d0000M0003
o`000=/000?o0000700001d000?o0000f`000ol0000L000070000ol0003M0003o`0001/0000L0003
o`000=d000?o00006`0001/000?o0000g`02oa/0000J0003o`000=l000?o0?l06`0001X000?o0000
g@02o`8000?o00006@0001T000?o0000g@000ol000030003o`0001P0000H0003o`000=`00_l70003
o`0001L0000H0003o`000=X00_l90003o`0001L0000G0003o`000=X000?o00002P000ol0000F0000
5P000ol0003J0003o`0000`000?o00005@0001H000?o0000f@000ol0000=0003o`0001D0000E0003
o`000=P00_lA0003o`0001@0000E0003o`000=L000?o00004@000ol0000D00005@000ol0003F0003
o`00018000?o0000500001@000?o0000eP000ol0000D0003o`0001<0000C0003o`000=H000?o0000
5P000ol0000B00004`000ol0003F0003o`0001D00_lD00004`000ol0003E0003o`0001@00_l20003
o`000140000B0003o`000=@00_lE00;o10000ol0000A00004@000ol0003D0003o`0001800ol60003
o`000140000A0003o`000=<000?o00004@02o`X000?o00004000014000?o0000dP000ol0000@00;o
30000ol0000@00004@000ol0003A0003o`0000l00_l>0003o`000100000@0003o`000=4000?o0000
3004oa4000?o00003`0000l000?o0000d@000ol0000<0003o`0001@000?o00003P0000l000?o0000
d@000ol0000:00;o5`000ol0000>00003`000ol0003@0003o`0000T00_lI0003o`0000h0000>0003
o`000=0000?o00001P04oa`000?o00003@0000h000?o0000c`000ol0000500;o80000ol0000=0000
3P000ol0003>0003o`0000@00_lR0003o`0000d0000=0003o`000<l000?o00001?lU0003o`0000`0
000=0003o`000</01?l00`3oo`0Y0003o`0000`0000=0003o`000<X01_l[0003o`0000`0000=0003
o`000<X01Ol/0003o`0000`0000<0003o`000<P02?l]0003o`0000/0000<0003o`000<H01?l2D0?o
;P000ol0000;000030000ol0003200Go15000ol0000_0003o`0000/0000;0003o`000<401?l6D0;o
<P000ol0000:00002`000ol0002m00Go2E000ol0000a0003o`0000X0000;0003o`000;X01Ol;D003
o`00038000?o00002P0000X000?o0000^004o`m@00?o0000<`000ol0000900002P000ol0002e00Co
4E000ol0000d0003o`0000T0000:0003o`000;401OlCD0;o=P000ol0000900002P000ol0002^00Co
00<0D50055000ol0000e0003o`0000T0000:0003o`000:T01_l00`1@D00FD003o`0003H000?o0000
2@0000T000?o0000Y`05oaa@0_li0003o`0000P000090003o`000:<01OlPD003o`0003P000?o0000
200000T000?o0000W`06ob9@0_lj0003o`0000P000090003o`0009/01OlWD003o`0003T000?o0000
200000T000?o0000UP06ob]@00?o0000>@000ol00008000020000ol0002C00Co00<0D500;E000ol0
000k0003o`0000L000080003o`0008h01_lbD003o`0003`000?o00001`0000P000?o0000R@06ocM@
00?o0000?0000ol00007000020000ol0002300Ko00<0D500>E000ol0000m0003o`0000L000080003
o`0007d01om1D003o`0003d000?o00001`0000L01?mg00KoAe000ol0000o0003o`0000H000070004
o`0000KoJP07ode@00?o0000?`000ol0000600001`02o`P01_mL00WoDU02od4000?o00001P0000L0
00?o0?l02Ol400Ko0`03odL02_mJD003o`00040000?o00001P0000L000?o00002@0AocX03?l00`1@
D01QD003o`00040000?o00001P0000L000?o00005@0Mo`L06om`D003o`00040000?o00001P0000L0
00?o00005@05o`9@1Ol?D0[oRE000ol000110003o`0000H000070003o`0001H00ol5009@1_nLD003
o`00048000?o00001P0000L000?o00008P03D0CoVE000ol000120003o`0000H000070003o`0002L0
00=@ool00_nED0;oA0000ol0000600001P000ol0000/0003D?oo00CoSe02odD000?o00001@0000H0
00?o0000<005ohe@00?o0000A0000ol0000500001P000ol0000c00KoR502odH000?o00001@0000H0
00?o0000=`05ohE@00?o0000A@000ol0000500001P000ol0000k00CoPU000ol000150003o`0000D0
00060003o`0003h01?moD003o`0004D000?o00001@0000H000?o0000@005og]@0_m70003o`0000D0
00060003o`0004@01?mhD003o`0004H000?o00001@0000H000?o0000AP05ogE@00?o0000AP000ol0
000500001P000ol0001:00?oLe000ol000160003o`0000D000060003o`0004`00omaD003o`0004H0
00?o00001@0000H000?o0000CP04ofe@00?o0000A`000ol0000500001P000ol0001A00CoJU000ol0
00170003o`0000D000060003o`0005<01?mXD003o`0004L000?o00001@0000H000?o0000EP00153o
oomTD0;oB@000ol0000500001P000ol0001H00?oHe000ol000180003o`0000D000060003o`0005X0
0omQD003o`0004P000?o00001@0000H000?o0000G004oei@00?o0000B0000ol0000500001`000ol0
001N00?oG5000ol000170003o`0000H000070003o`0006400omID003o`0004L000?o00001P0000L0
00?o0000HP04oeI@00?o0000B0000ol0000600001`000ol0001T00?oEE000ol000180003o`0000H0
00070003o`0006H01?mBD003o`0004P000?o00001P0000L000?o0000J@000e3oo`1@D003o`0004P0
00?o00001P0000L000?o0000J`02odm@00?o0000B0000ol0000600001`000ol0001/00CoC5000ol0
00180003o`0000H000070003o`0006l00om9D003o`0004T000?o00001P0000L000?o0000L@03odM@
00?o0000B@000ol00006000020000ol0001a00?oAU000ol000180003o`0000L000080003o`0007<0
0om4D003o`0004P000?o00001`0000P000?o0000M@03od9@00?o0000B0000ol00007000020000ol0
001g00;o@E000ol000180003o`0000L000080003o`0007T00olnD003o`0004P000?o00001`0000T0
00?o0000N@04oca@00?o0000A`000ol0000800002@000ol0001k00?o>e000ol000170003o`0000P0
00090003o`0007d00_ljD003o`0004L000?o0000200000T000?o0000O`000om@D00gD003o`0004L0
00?o0000200000T000?o0000P003ocI@00?o0000A`000ol0000800002P000ol0002100?o=5000ol0
00160003o`0000T0000:0003o`0008<00_lcD003o`0004H000?o00002@0000X000?o0000Q002oc9@
00?o0000AP000ol0000900002P000ol0002600;o<5000ol000160003o`0000T0000:0003o`0008L0
0ol^D003o`0004H000?o00002@0000/000?o0000R003oba@00?o0000A@000ol0000:00002`000ol0
002:00;o:e000ol000150003o`0000X0000;0003o`0008/000=@oe00:E000ol000150003o`0000X0
000<0003o`0008`00_lXD003o`0004@000?o00002`0000`000?o0000S@03obI@00?o0000A0000ol0
000;000030000ol0002?00;o9E000ol000140003o`0000/0000=0003o`0008l00_lTD003o`0004<0
00?o0000300000d000?o0000T003ob9@00?o0000@`000ol0000<00003@000ol0002B00;o8E000ol0
00130003o`0000`0000>0003o`0009<000?oD5007U000ol000120003o`0000d0000>0003o`0009@0
0_lND003o`00048000?o00003@0000h000?o0000U@03oaa@0_m30003o`0000d0000?0003o`0009H0
0_lKD0030?l0044000?o00003P0000l000?o0000U`000om@D00JD003o`00040000?o00003P0000l0
00?o0000V002oaY@00?o0000@0000ol0000>000040000ol0002H00?o65000ol0000o0003o`0000l0
000@0003o`0009X00_lGD003o`0003l000?o00003`00014000?o0000VP000e3oo`0ED003o`0003h0
00?o00004000014000?o0000W002oaA@0_lo0003o`000100000A0003o`0009d00_lDD003o`0003d0
00?o00004000018000?o0000W@02oa=@00?o0000?0000ol0000A00004P000ol0002O0003oe1@011@
00?o0000?0000ol0000A00004`000ol0002O00;o45000ol0000k0003o`000180000C0003o`000:40
00?oD5003E02oc`000?o00004P0001<000?o0000X@02o`m@00?o0000>P000ol0000B000050000ol0
002Q00;o3U000ol0000i0003o`0001<0000E0003o`000:8000?oD5002e000ol0000h0003o`0001@0
000E0003o`000:<000?oD5002U000ol0000h0003o`0001@0000F0003o`000:<00_l;D003o`0003H0
00?o00005@0001H000?o0000Y002o`Y@00?o0000=P000ol0000E00005P000ol0002U00;o2E000ol0
000f0003o`0001D0000G0003o`000:D00_l8D003o`0003D000?o00005P0001P000?o0000Y@02o`Q@
00?o0000<`000ol0000G000060000ol0002V00;o1e000ol0000c0003o`0001L0000I0003o`000:L0
00?oD5001502oc<000?o0000600001X000?o0000Y`000om@D004D003o`00030000?o00006@0001X0
00?o0000Z0000om@D003D003o`00030000?o00006@0001/000?o0000Z0000om@D002D0;o<0000ol0
000J000070000ol0002X0003oe1@009@00?o0000;@000ol0000K000070000ol0002Y0005oe1@D?l0
;`000ol0000K00007@000ol0002Y0005oe1@D?l0;@000ol0000L00007@000ol0002Z00;o00=@o`00
;0000ol0000L00007P000ol0002[00;o;0000ol0000M00007`000ol0002[00;o:P000ol0000N0000
7`000ol0002/00?o:0000ol0000N000080000ol0002Z00Go9P000ol0000O00008@000ol0002Y00Go
9@000ol0000P00008P000ol0002X00Go90000ol0000Q00008`000ol0002X00?o00<0o`008@000ol0
000R00008`000ol0002[0003o`3o024000?o00008P0002@000?o0000ZP000ol0o`0P0003o`0002<0
000U0003o`000:X000?o0?l07P000ol0000T00009P000ol0002Y0004o`00oa`000?o00009@0002L0
00?o0000Z0001Ol0003o01X000?o00009P0002P000?o0000Z0001Ol0003o01P000?o00009`0002T0
00?o0000Z0001Ol0003o01H000?o0000:00002X000?o0000Y`000ol000020003o`00018000?o0000
:@0002/000?o0000Y`000ol000020003o`00010000?o0000:P0002`000?o0000YP000ol000030003
o`0000h000?o0000:`0002d000?o0000YP000ol000030003o`0000`000?o0000;00002h000?o0000
YP000ol000030003o`0000X000?o0000;@0002l000?o0000Y@000ol000040003o`0000P000?o0000
;P00030000?o0000Y@000ol000030003o`0000L000?o0000;`00034000?o0000Y@000ol000030003
o`0000D000?o0000<000038000?o0000Y0000ol0000400;o10000ol0000a0000<`02ojD000?o0000
1@001?l00?ld0000=@000ol0002R0003o`0000D000?o0?l0=@0003H000?o0000XP000ol000050003
o`0003@0000g0003o`000:8000?o00000P02ocL0000h0003o`000:4000Go0000o`0i0000>@000ol0
002Q0003o`3o03X0000j0003o`000:4000?o0000>@0003/00_nO00;o?00003d000?o0000V`000ol0
000l0000?P02oiT00_lo0000@0000ol0002E0003o`0003l0001100;oT`02od80001300;oS`02od@0
00150003o`0008/000?o0000A00004H00_n900;oA`0004P000?o0000Q@000ol000170000B@02oh<0
0_m:0000B`000ol0001o0003o`0004X0001<00?oO002odd0001?00;oM`03odl0001A0003o`0007<0
00?o0000D00005800om`00;oD`0005D000?o0000J`02oeD0001F00CoI@04oeL0001J0003o`000640
00?o0000F@0005/00omM00?oG00005h00omG00?oG`0006401?m?00CoHP0006D00om900?oIP0006P0
0om300?oJ@0006/01Oli00GoK00007001Ol_00GoL@0007D01OlU00GoMP0007X02_lA00[oN`0008@0
4On50000o`0K0000o`0K0000o`0K0000o`0K0000o`0K0000o`0K0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-1.05001, -1.05001, 0.00747339, 
  0.00747339}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Unit polygons"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
polygons = {p1, p2, p3} = 
\tNGP[Map[UnitPolygon, {12, 6, 3}]];
h1 = HDraw[polygons, DisplayFunction -> Identity];
h2 = HDraw[{GrayLevel[0], p1, GrayLevel[0.6], p2,
\tGrayLevel[0.9], p3} /. Polygon -> FilledPolygon,
\tDisplayFunction -> Identity];
Show[GraphicsArray[{h1,h2}]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
.62759 .97619 .12759 180 330 arc
s
newpath
.8486 .8486 .12759 150 300 arc
s
newpath
.97619 .62759 .12759 120 270 arc
s
newpath
.97619 .37241 .12759 90 240 arc
s
newpath
.8486 .1514 .12759 60 210 arc
s
newpath
.62759 .02381 .12759 30 180 arc
s
newpath
.37241 .02381 .12759 0 150 arc
s
newpath
.1514 .1514 .12759 -30 120 arc
s
newpath
.02381 .37241 .12759 -60 90 arc
s
newpath
.02381 .62759 .12759 -90 60 arc
s
newpath
.1514 .8486 .12759 -120 30 arc
s
newpath
.37241 .97619 .12759 210 360 arc
s
newpath
.77493 .97619 .27493 180 300 arc
s
newpath
1.04986 .5 .27493 120 240 arc
s
newpath
.77493 .02381 .27493 60 180 arc
s
newpath
.22507 .02381 .27493 0 120 arc
s
newpath
-0.04986 .5 .27493 -60 60 arc
s
newpath
.22507 .97619 .27493 240 360 arc
s
newpath
1.32479 .97619 .82479 180 240 arc
s
newpath
.5 -0.45238 .82479 60 120 arc
s
newpath
-0.32479 .97619 .82479 300 360 arc
s
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 .97619 m
.5036 .94611 L
.51418 .91772 L
.53117 .89263 L
.55358 .87225 L
.58017 .85774 L
.60944 .84989 L
.63972 .84917 L
.66933 .85561 L
.69658 .86885 L
.71994 .88814 L
.7381 .91239 L
.7381 .91239 L
.72617 .88454 L
.72115 .85467 L
.72331 .82445 L
.73253 .79559 L
.7483 .76972 L
.76972 .7483 L
.79559 .73253 L
.82445 .72331 L
.85467 .72115 L
.88454 .72617 L
.91239 .7381 L
.91239 .7381 L
.88814 .71994 L
.86885 .69658 L
.85561 .66933 L
.84917 .63972 L
.84989 .60944 L
.85774 .58017 L
.87225 .55358 L
.89263 .53117 L
.91772 .51418 L
.94611 .5036 L
.97619 .5 L
.97619 .5 L
.94611 .4964 L
.91772 .48582 L
.89263 .46883 L
.87225 .44642 L
.85774 .41983 L
.84989 .39056 L
.84917 .36028 L
.85561 .33067 L
.86885 .30342 L
.88814 .28006 L
.91239 .2619 L
.91239 .2619 L
.88454 .27383 L
.85467 .27885 L
.82445 .27669 L
.79559 .26747 L
.76972 .2517 L
.7483 .23028 L
.73253 .20441 L
.72331 .17555 L
.72115 .14533 L
.72617 .11546 L
.7381 .08761 L
.7381 .08761 L
.71994 .11186 L
.69658 .13115 L
.66933 .14439 L
.63972 .15083 L
.60944 .15011 L
.58017 .14226 L
.55358 .12775 L
.53117 .10737 L
.51418 .08228 L
.5036 .05389 L
.5 .02381 L
.5 .02381 L
.4964 .05389 L
.48582 .08228 L
.46883 .10737 L
.44642 .12775 L
.41983 .14226 L
.39056 .15011 L
.36028 .15083 L
.33067 .14439 L
.30342 .13115 L
.28006 .11186 L
.2619 .08761 L
.2619 .08761 L
.27383 .11546 L
.27885 .14533 L
.27669 .17555 L
.26747 .20441 L
.2517 .23028 L
.23028 .2517 L
.20441 .26747 L
.17555 .27669 L
.14533 .27885 L
.11546 .27383 L
.08761 .2619 L
.08761 .2619 L
.11186 .28006 L
.13115 .30342 L
.14439 .33067 L
.15083 .36028 L
.15011 .39056 L
.14226 .41983 L
.12775 .44642 L
.10737 .46883 L
.08228 .48582 L
.05389 .4964 L
.02381 .5 L
.02381 .5 L
.05389 .5036 L
.08228 .51418 L
.10737 .53117 L
.12775 .55358 L
.14226 .58017 L
.15011 .60944 L
.15083 .63972 L
.14439 .66933 L
.13115 .69658 L
.11186 .71994 L
.08761 .7381 L
.08761 .7381 L
.11546 .72617 L
.14533 .72115 L
.17555 .72331 L
.20441 .73253 L
.23028 .7483 L
.2517 .76972 L
.26747 .79559 L
.27669 .82445 L
.27885 .85467 L
.27383 .88454 L
.2619 .91239 L
.2619 .91239 L
.28006 .88814 L
.30342 .86885 L
.33067 .85561 L
.36028 .84917 L
.39056 .84989 L
.41983 .85774 L
.44642 .87225 L
.46883 .89263 L
.48582 .91772 L
.4964 .94611 L
.5 .97619 L
F
.5 Mabswid
[ ] 0 setdash
newpath
.62759 .97619 .12759 180 330 arc
s
newpath
.8486 .8486 .12759 150 300 arc
s
newpath
.97619 .62759 .12759 120 270 arc
s
newpath
.97619 .37241 .12759 90 240 arc
s
newpath
.8486 .1514 .12759 60 210 arc
s
newpath
.62759 .02381 .12759 30 180 arc
s
newpath
.37241 .02381 .12759 0 150 arc
s
newpath
.1514 .1514 .12759 -30 120 arc
s
newpath
.02381 .37241 .12759 -60 90 arc
s
newpath
.02381 .62759 .12759 -90 60 arc
s
newpath
.1514 .8486 .12759 -120 30 arc
s
newpath
.37241 .97619 .12759 210 360 arc
s
.6 g
.5 .97619 m
.50418 .92845 L
.51658 .88216 L
.53683 .83873 L
.56432 .79947 L
.59821 .76558 L
.63746 .7381 L
.6809 .71784 L
.72719 .70544 L
.77493 .70126 L
.82267 .70544 L
.86896 .71784 L
.91239 .7381 L
.91239 .7381 L
.87314 .71061 L
.83925 .67672 L
.81176 .63746 L
.79151 .59403 L
.77911 .54774 L
.77493 .5 L
.77911 .45226 L
.79151 .40597 L
.81176 .36254 L
.83925 .32328 L
.87314 .28939 L
.91239 .2619 L
.91239 .2619 L
.86896 .28216 L
.82267 .29456 L
.77493 .29874 L
.72719 .29456 L
.6809 .28216 L
.63746 .2619 L
.59821 .23442 L
.56432 .20053 L
.53683 .16127 L
.51658 .11784 L
.50418 .07155 L
.5 .02381 L
.5 .02381 L
.49582 .07155 L
.48342 .11784 L
.46317 .16127 L
.43568 .20053 L
.40179 .23442 L
.36254 .2619 L
.3191 .28216 L
.27281 .29456 L
.22507 .29874 L
.17733 .29456 L
.13104 .28216 L
.08761 .2619 L
.08761 .2619 L
.12686 .28939 L
.16075 .32328 L
.18824 .36254 L
.20849 .40597 L
.22089 .45226 L
.22507 .5 L
.22089 .54774 L
.20849 .59403 L
.18824 .63746 L
.16075 .67672 L
.12686 .71061 L
.08761 .7381 L
.08761 .7381 L
.13104 .71784 L
.17733 .70544 L
.22507 .70126 L
.27281 .70544 L
.3191 .71784 L
.36254 .7381 L
.40179 .76558 L
.43568 .79947 L
.46317 .83873 L
.48342 .88216 L
.49582 .92845 L
.5 .97619 L
F
0 g
newpath
.77493 .97619 .27493 180 300 arc
s
newpath
1.04986 .5 .27493 120 240 arc
s
newpath
.77493 .02381 .27493 60 180 arc
s
newpath
.22507 .02381 .27493 0 120 arc
s
newpath
-0.04986 .5 .27493 -60 60 arc
s
newpath
.22507 .97619 .27493 240 360 arc
s
.9 g
.5 .97619 m
.5014 .92823 L
.50558 .88044 L
.51253 .83297 L
.52223 .78598 L
.53465 .73964 L
.54974 .6941 L
.56745 .64951 L
.58773 .60603 L
.6105 .5638 L
.63569 .52296 L
.66321 .48366 L
.69296 .44603 L
.72486 .41019 L
.75878 .37626 L
.79462 .34437 L
.83226 .31461 L
.87156 .28709 L
.91239 .2619 L
.91239 .2619 L
.87016 .28467 L
.82668 .30495 L
.78209 .32266 L
.73655 .33776 L
.69021 .35017 L
.64322 .35987 L
.59575 .36683 L
.54796 .37101 L
.5 .37241 L
.45204 .37101 L
.40425 .36683 L
.35678 .35987 L
.30979 .35017 L
.26345 .33776 L
.21791 .32266 L
.17332 .30495 L
.12984 .28467 L
.08761 .2619 L
.08761 .2619 L
.12844 .28709 L
.16774 .31461 L
.20538 .34437 L
.24122 .37626 L
.27514 .41019 L
.30704 .44603 L
.33679 .48366 L
.36431 .52296 L
.3895 .5638 L
.41227 .60603 L
.43255 .64951 L
.45026 .6941 L
.46535 .73964 L
.47777 .78598 L
.48747 .83297 L
.49442 .88044 L
.4986 .92823 L
.5 .97619 L
F
0 g
newpath
1.32479 .97619 .82479 180 240 arc
s
newpath
.5 -0.45238 .82479 60 120 arc
s
newpath
-0.32479 .97619 .82479 300 360 arc
s
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{408, 194},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006H0000`PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l0V@000?l0V@000?l0V@000?l0V@000?l0
V@000?l0V@000?l0V@000?l0V@000?l0V@000?l0V@0005X06On_01goF@0005@01_l<0003o`0000X0
1_nU00Co3P000ol0000<00GoE00004l01OlB0003o`0001001OnL00Co4P000ol0000A00CoD00004/0
1?lG0003o`0001D01?nC00Go5P000ol0000E00CoC00004T00_lK0003o`0001T00_n?00;o6P02oa/0
0_m:0000A`02oa`00olL00;oR`02oa`00olL00;oB00004<01?lN00?o7P04oh<01?lN0003mooo01h0
1?m40000@@02ob800olR00;oO`02ob8000?gool08P02od80000o00;o90000ol0o`0T00;oN`02ob<0
0_l00oOo000S00;o@00003d00_lU00;o00<0ool09@02ogL00_lU00;o00?gool09@02och0000k00;o
9`02o`030?oo02L00_mc00;o9`02o`03mooo02L00_ll0000>@02obP000Oo0?l0o`3o02P00_m_00;o
:003o`04moooobP00_lj0000>0000ol0o`0W0006o`00o`3o0P000ol0000U0003o`3o06d000?o0?l0
9`02o`03moog00Co9`000ol0o`0i0000=`001Ol0003o02H000?o0?l00`000ol0o`0U00;o0P000ol0
001Z0004o`0000;o9@03o`?g0olV0005o`000?l0>00003H000?o00000P02ob@000Co003o0`001?l0
0?lS0003o`3o00<00_mY0003o`00008000?o0?l08`04o`?g1?lT00;o10000ol0000e0000=002o`H0
0_lR0005o`000?l00`001?l00?lS00;o1P02ofD00_l600;o8`04o`?g1OlR00;o1P02ocD0000b00;o
20000ol0o`0P0005o`000?l01@001?l00?lQ0003o`3o00P00_mQ00;o2003ob401?l5m`Go80000ol0
o`0800;o<`00034000?o000020001?l00?lM00;o10000ol000030004o`0000;o7@02o`030?l000X0
00?o0000G@000ol0000900Co7@06o`Gg1olM00Co2P000ol0000`0000<0000ol0000:0003o`0000;o
6P000ol000040003o`0000<000?o00000`000ol0000I0005o`000?l02`000ol0001M0003o`0000T0
1OlK00Oo1OL6o`030?l001T01Ol<0003o`0002l0000_0003o`0000/000?o00000P02oaL000?o0000
10000ol000050003o`0000<00_lG00;o10000ol0000:00;oF`02o``01olG00So1oL6o`030?l001H0
1ol=0003o`0002h0000]00;o3P000ol000040003o`0001800_l70003o`0000D000?o00001@02oa<0
0_l60003o`0000`00_mG00;o3P09oa<02_l7m`[o5008o`h00_l^0000;0000ol0000>0003o`0000D0
0_l@00;o20000ol000070003o`0000H000?o00003P02o`P000?o00003P000ol0001C0003o`0000h0
2_lA00[o2OL;oa002_l@0003o`0002/0000[0003o`0000l000?o00001`04o`T00ol:0003o`0000L0
00?o00001`04o`T00ol90003o`0000l000?o0000D`000ol0000>00ko2@0>o`Wg3_l900ko4@000ol0
000Z0000:P000ol0000@0003o`0000/02Ol=0003o`0000L000?o00002`09o``000?o00004002oe40
0_lA02Go2OLGo`030?oo00_o4P000ol0000Y0000:@000ol0000A0003o`00020000?o00002@000ol0
000P0003o`00014000?o0000C@000ol0000A02Co2oLToa<000?o0000:00002P000?o00004P000ol0
000O0003o`0000/000?o00007`000ol0000B0003o`0004/000?o00004P0So`gg8olD0003o`0002L0
000W0003o`0001<000?o00007`000ol0000;0003o`0001l000?o00004`000ol000190003o`0001<0
8ol=mb?o5@000ol0000V00009`000ol0000C0003o`0001h000?o00003@000ol0000N0003o`0001<0
00?o0000B0000ol0000D02;o3oLRoaD000?o00009P0002D00_lF0003o`0001d000?o00003P000ol0
000N0003o`0001@000?o0000AP000ol0000E02;o4?LQoaH00_lV000090000ol0000F0003o`0001`0
00?o000040000ol0000M0003o`0001D000?o0000A0000ol0000F027o4_LPoaP000?o00008`0002@0
00?o00005@000ol0000L0003o`00018000?o000070000ol0000F0003o`0004<000?o00005@0Qoa?g
8OlG0003o`0002<0000R00;o60000ol0000L0003o`00018000?o000070000ol0000G0003o`000440
00?o00005P0QoaCg8?lH00;o8`00024000?o000060000ol0000K0003o`0001@000?o000070000ol0
000G0003o`0003l000?o00005`0PoaKg7olJ0003o`000200000Q0003o`0001L000?o00006`000ol0
000F00;o7@000ol0000G0003o`0003d000?o00005`0PoaSg7olI0003o`000200000P0003o`0001P0
00?o00006P000ol0000I0003o`0001X000?o000060000ol0000k0003o`0001P07_lKmako6P000ol0
000O000080000ol0000G0003o`0001X000?o00006`000ol0000J0003o`0001L000?o0000>`000ol0
000G01ko7OLNoaT000?o00007`0001l000?o000060000ol0000J0003o`0001/000?o00006P000ol0
000H0003o`0003T000?o0000600Moaog7OlJ0003o`0001h0000O0003o`0001L000?o00006P000ol0
000M0003o`0001X000?o00005`000ol0000i0003o`0001L07OlQmago6@000ol0000N00007P000ol0
000G0003o`0001T00_lQ00;o6P000ol0000H0003o`0003L000?o00005`0Mob?g7OlI0003o`0001d0
000M0003o`0001L000?o00006@000ol0000S0003o`0001P000?o00005`000ol0000g0003o`0001L0
7?lUmago6@000ol0000L000070000ol0000F00;o6P02obL000?o00006002oaP00_le00;o600MobOg
7_lH0003o`0001/0000K0003o`0001H000?o00006@000ol0000X0003o`0001T000?o00005`000ol0
000a0003o`0001L06ol00oOom`0Ymago60000ol0000J00006`000ol0000E0003o`0001P00_l/00?o
6@02oaL000?o0000<@000ol0000E01ko;?LMoaL000?o00006P0001X00_lE00;o6@02oc400_lI00;o
5@02oc400_lE01ko<?LMoaD00_lK00006P04oa400_lJ0003o`0003<000?o000060000ol0000@00Co
<@04oa807?lemago4@04oa/0000I0003o`0000Co3003oaX00_lg00?o6004o``01?l20003o`0002d0
00?o00001?l<01oo=oLOo`d00ol20003o`0001P0000I0003o`0000803_lJ00?o?002oaX03_l40003
o`0002d000?o00000P0[occg:_l40003o`0001P0000H0003o`0000@01_lN00?o@@03oah01_l60003
o`0002/000?o0000100Wod7g9ol60003o`0001L0000H0003o`0000D02?lH00?oA`03oaP02?l70003
o`0002/000?o0000100TodOg8ol70003o`0001L0000G0003o`0000H000?o0?l01?l00`3oo`03o`h0
1Om=00Go3P05o`030?oo00?o00<0o`001`000ol0000Y0003o`0000H08?m=maSo00?gool01Ol80003
o`0001H0000G0003o`0000L000?o00001_l300koE`0>o`<01_l00`3oo`090003o`0002T000?o0000
1`02o`05moooog000_l3m`koEoL>o`Cg1Ol00oOoo`090003o`0001H0000F0003o`0000T000Ko003o
0?l200;oM@02o`8000Go0?l0o`0<0003o`0002L000?o00002@02o`04moogo`9`0_mem`?o00E`ooOo
m`02o`/000?o00005@0001H000?o00002@001?l00?l20004o`0000;oL@02o`<000Ko003o0?l<0003
o`0002L000?o00002@04o`;g00CoL71`0_mam`;o0g000oogm`04o`/000?o00005@0001D000?o0000
2`001?l00?l200;o0`02ofd00_l300;o0P001?l00?l=0003o`0002D000?o00002`04o`;g0_l3L0?o
K?L2o`=`0_l2m`Co3@000ol0000D00005@000ol0000;0005o`000?l00`000ol0000200?oI`03o`@0
00Go0000o`030003o`0000/000?o00009@000ol0000;00Go0oL00om`L003L0;oIoL3o`A`00ComoOg
1Ol=0003o`0001@0000D0003o`0000d000Go0000o`030003o`0000@00_mS00;o1P001Ol0003o00<0
00?o000030000ol0000U0003o`0000`01Ol3m`03og1`00A`0_mSm`;o1W001?ogmoL5o`l000?o0000
4`0001@000?o00003P001Ol0003o00<000?o00001@05oeT01Ol600;o0`001Ol0003o00l000?o0000
9@000ol0000=00?o00?gooL00_L2o`I`1OmIm`Go1g001?ogmoL5oa0000?o00004`0001@000?o0000
3P001Ol0003o00@000?o00002@02oeD00_l:0003o`0000<000Go0000o`0@0003o`0002<000?o0000
3P05o`Gg00?oL7002702oeGg0_l;L003ooOg00;g1Ol@0003o`0001<0000D0003o`0000h000?o0000
0P000ol000020003o`0000X01Om;00Go2`000ol000030003o`00008000?o00003P000ol0000S0003
o`0000h01_l5m`03og1`00U`1Om;m`Go37000oogm`02m`Ko40000ol0000C00004`000ol0000?0003
o`0000<000?o00000P000ol0000>00;oA`02o`l000?o00000`000ol000030003o`0000l000?o0000
8@000ol0000?00Oo1OL00om`L00=L0?oA_L2oa1`00?omoL00_L7oa4000?o00004P0001<000?o0000
40000ol000020003o`0000<000?o00003`05ocd01OlA0003o`0000<000?o00000P000ol0000@0003
o`00024000?o00004006o`Gg00?omg004705occg1OlAL003ooOg00?g1_lB0003o`000180000B0003
o`00014000?o00000`000ol0000300;o5005oc<01OlD00;o1@000ol000030003o`00010000?o0000
80000ol0000A00Oo1OL2oaE`1?lcm`Go5702o`Gg1olC0003o`000140000B0003o`00014000?o0000
10000ol000040003o`0001H02?lT00Oo60000ol000040003o`0000@000?o000040000ol0000P0003
o`0001402?l6m`03og1`01I`2?lTm`Oo67000oogm`04m`So4`000ol0000A00004P000ol0000A0003
o`0000@000?o00001@000ol0000M00co2`0=oah000?o00001@000ol000040003o`00014000?o0000
7`000ol0000A00So1oL00om`L00KL0;g3ol6m`oo00?gL7006g000oogm`05m`So4`000ol0000A0000
4P000ol0000A0003o`0000D000?o00001@000ol0000X00_o:P000ol000050003o`0000D000?o0000
4@000ol0000O0003o`0001402Ol7m`03og1`02Y`00?gool01?l00oM`L00YL003ooOg00Gg2OlC0003
o`000140000A0003o`00018000?o00001@000ol000060003o`0005/000?o00001P000ol000050003
o`00018000?o00007@000ol0000B00Wo2?L00om`L01KL003ooOg00Kg2OlD0003o`000100000A0003
o`00018000?o00001P000ol000060003o`0005P00_l80003o`0000H000?o00004P000ol0000M0003
o`0001802Ol9m`;oFG02o`Wg2OlD0003o`000100000A0003o`00018000?o00001P000ol000070003
o`0005H000?o000020000ol000060003o`00018000?o00007@000ol0000B00[o2OL00g3oL01FL003
og3g00Sg2_lD0003o`000100000A0003o`00014000?o000020000ol000070003o`0005D000?o0000
1`000ol000070003o`00018000?o00007@000ol0000B00_o2OL00om`L01EL003ooOg00Og2_l00`3o
000B0003o`000100000A0003o`00014000?o000020000ol000080003o`0005<000?o000020000ol0
00070003o`00018000?o00007@000ol0000B00_o2_L00om`L01CL003ooOg00Sg3?lC0003o`000100
000@0003o`00018000?o000020000ol000090003o`00054000?o00002@000ol000080003o`000180
00?o00006`000ol0000B00co2oL00om`L01AL003ooOg00Wg3?lD0003o`0000l0000@0003o`000140
00?o00002P000ol000090003o`0004l000?o00002@000ol000090003o`00018000?o00006`000ol0
000B00go2oL00om`L01?L003ooOg00Wg3?l00`3o000B0003o`0000l0000@0003o`00014000?o0000
2P000ol0000:0003o`0004d000?o00002P000ol000090003o`00018000?o00006`000ol0000B00go
3?L00om`L01=L003ooOg00[g3_lC0003o`0000l0000@0003o`00014000?o00002P000ol0000;0003
o`0004/000?o00002`000ol0000:0003o`00014000?o00006`000ol0000A00ko3OL00om`L01;L003
og3g00_g3_lC0003o`0000l0000?0003o`00018000?o00002`000ol0000:0003o`0004X000?o0000
2`000ol0000;0003o`00014000?o00006`000ol0000A00oo3?L00om`L01;L003ooOg00[g3olD0003
o`0000h0000?0003o`00014000?o000030000ol0000;00;oB@000ol0000<0003o`0000`000?o0000
40000ol0000K0003o`0001004?l=m`;oBG02o`gg4?lC0003o`0000h0000?0003o`00014000?o0000
30000ol0000=0003o`0004D000?o00003@000ol0000<0003o`00014000?o00006@000ol0000A013o
3oL00om`L015L003og3g00gg4?lC0003o`0000h0000?0003o`00010000?o00003@000ol0000=0003
o`0004@000?o00003@000ol0000>0003o`00010000?o00006@000ol0000@01;o3oL00om`L014L003
ooOg00gg4OlB0003o`0000h0000?0003o`0000l000?o00003P000ol0000>0003o`00048000?o0000
3P000ol0000>0003o`00010000?o00006@000ol0000@01;o3oL00g3oL013L003ooOg00kg4_lA0003
o`0000h0000?0003o`0000h000?o000040000ol0000>0003o`00044000?o00003P000ol0000?0003
o`0000l000?o00006@000ol0000?01?o4?L00om`L011L003og3g00kg5?l@0003o`0000h0000?0003
o`0000d000?o00004@000ol0000?0003o`0003l000?o00003`000ol0000@00;o3`000ol0000I0003
o`0000d05OlAm`03og1`03m`00?oL?L03oLEo`l000?o00003P0000l000?o000030000ol0000B0003
o`00010000?o0000?@000ol0000@0003o`00018000?o000030000ol0000I0003o`0000`05_lBm`03
og1`03e`00?oL?L04?LFo`h000?o00003P0000h000?o00002`02oaD000?o00004@000ol0000k0003
o`00014000?o00004`02o``000?o00006@000ol0000:01So4_L00g3oL00lL003og3g017g6?l<0003
o`0000h0000>0003o`0000T00_lG0003o`00014000?o0000>`000ol0000A0003o`0001D000?o0000
2@000ol0000I0003o`0000T06OlCm`03og1`03]`00?omoL04OLJo`/000?o00003@0000h000?o0000
20000ol0000G0003o`00018000?o0000>@000ol0000B0003o`0001H00_l90003o`0001T000?o0000
1`0KoaCg00?oL700>G000oogm`0Bma_o2P000ol0000=00003P000ol0000600;o6P000ol0000C0003
o`0003L000?o00004P000ol0000I00;o1`000ol0000I0003o`0000D07_lCm`03L?m`03Q`00?omoL0
4oLMo`P000?o00003@0000h000?o00000P04oa`000?o000050000ol0000e0003o`0001<000?o0000
6`04o`<000?o00006@001?l0000RoaCg00=`og00=W000om`m`0Dmb7o10000ol0000=00003P06oal0
00?o000050000ol0000e0003o`0001<000?o00007P05oa/09_lEm`03og1`03E`00?omoL05?LVo`l0
000>0003o`0000<01?lK0003o`0001D000?o0000<`000ol0000D0003o`0001X01?l40003o`0001T0
00Co00008_lFm`03og1`03=`00?omoL05OLRo`<000?o00003@0000h000?o00001`000ol0000H0003
o`0001D000?o0000<P000ol0000E0003o`0001P00_l80003o`0001T000?o0000100OoaKg00=`og00
<g000oogm`0Emako1`000ol0000=00003P000ol0000800;o60000ol0000F0003o`00030000?o0000
5`000ol0000F0003o`0000P000?o00006@000ol0000701_o6?L00g3oL00aL003ooOg01Kg6ol:0003
o`0000d0000>0003o`0000X00_lF0003o`0001L000?o0000;`000ol0000G0003o`0001@00_l;0003
o`0001T000?o00002@0IoaWg00?oL700;g000oogm`0GmaWo30000ol0000=00003P000ol0000<0003
o`0001<000?o000060000ol0000]0003o`0001P000?o00004P02o`d000?o00006@000ol0000;01Oo
6OL00g3oL00^L003ooOg01Sg5ol>0003o`0000d0000?0003o`0000`000?o00004P000ol0000H0003
o`0002d000?o000060000ol0000A0003o`0000d000?o00006@000ol0000<01Ko6_L00om`L00]L003
ooOg01Sg5_l>0003o`0000h0000?0003o`0000d000?o00004@000ol0000I0003o`0002/000?o0000
6@000ol0000@0003o`0000h000?o00006@000ol0000=01Go6oL00om`L00[L003ooOg01Wg5Ol?0003
o`0000h0000?0003o`0000h000?o000040000ol0000I0003o`0002/000?o00006@000ol0000@0003
o`0000h000?o00006@000ol0000>01Co6oL00om`L00[L003ooOg01Wg5Ol?0003o`0000h0000?0003
o`0000l000?o00003`000ol0000J0003o`0002T000?o00006P000ol0000?0003o`0000l000?o0000
6@000ol0000?01?o7?L00om`L00ZL003ooOg01Wg5?l@0003o`0000h0000?0003o`00010000?o0000
3@000ol0000K0003o`0002P000?o00006`000ol0000>0003o`00010000?o00006@000ol0000@01;o
7?L00g3oL00YL003ooOg01[g4olA0003o`0000h0000?0003o`00010000?o00003@000ol0000L0003
o`0002L000?o00006`000ol0000>0003o`00010000?o00006@000ol0000@01;o7OL00om`L00WL003
ooOg01cg4OlB0003o`0000h0000?0003o`00014000?o000030000ol0000M0003o`0002D000?o0000
7@000ol0000<0003o`00014000?o00006@000ol0000A013o7oL00om`L00UL003ooOg01gg4OlB0003
o`0000h0000?0003o`00014000?o000030000ol0000M0003o`0002D000?o00007@000ol0000<0003
o`00010000?o00006`000ol0000@013o7oL00om`L00UL003ooOg01gg4?lC0003o`0000h0000?0003
o`00018000?o00002`000ol0000N0003o`0002<000?o00007P000ol0000;0003o`00014000?o0000
6`000ol0000@013o8?L00om`L00SL003ooOg01kg3olD0003o`0000h0000@0003o`00014000?o0000
2P000ol0000O0003o`0002<000?o00007`000ol0000:0003o`00014000?o00006`000ol0000A00ko
8OL00om`L00SL003ooOg01og3_lC0003o`0000l0000@0003o`00014000?o00002P000ol0000P0003
o`00024000?o000080000ol000090003o`00018000?o00006`000ol0000A00ko8_L00om`L00QL003
ooOg023g3_lC0003o`0000l0000@0003o`00018000?o00002@000ol0000P0003o`00024000?o0000
80000ol000090003o`00018000?o00006`000ol0000B00go8_L00om`L00QL003ooOg023g3OlD0003
o`0000l0000@0003o`00018000?o000020000ol0000R0003o`0001l000?o00008P000ol000080003
o`00018000?o00006`000ol0000B00co9?L00om`L00OL003ooOg02;g3?lD0003o`0000l0000A0003
o`00014000?o000020000ol0000R0003o`0001l000?o00008P000ol000070003o`00018000?o0000
7@000ol0000A00co9?L00om`L00OL003ooOg02;g3?lC0003o`000100000A0003o`00014000?o0000
20000ol0000S0003o`0001d000?o00008`000ol000070003o`00018000?o00007@000ol0000B00_o
9OL00om`L00ML003ooOg02?g3?lC0003o`000100000A0003o`00018000?o00001P000ol0000T0003
o`0001d000?o000090000ol000060003o`00018000?o00007@000ol0000B00[o9_L00om`L00ML003
ooOg02Cg2_lD0003o`000100000A0003o`00018000?o00001@000ol0000V0003o`0001/000?o0000
9P000ol000050003o`00018000?o00007@000ol0000B00Wo:?L00om`L00LL003ooOg02Gg2OlD0003
o`000100000A0003o`00018000?o00001@000ol0000V0003o`0001X000?o00009`000ol000050003
o`00018000?o00007@000ol0000B00Wo:?L00g3oL00KL003ooOg02Kg2OlD0003o`000100000B0003
o`00014000?o000010000ol0000W0003o`0001X000?o0000:0000ol000040003o`00014000?o0000
7`000ol0000A00So:_L00om`L00JL003ooOg02Kg2OlC0003o`000140000B0003o`00014000?o0000
10000ol0000X0003o`0001P000?o0000:@000ol000040003o`00014000?o00007`000ol0000A00So
:_L00g3oL00IL003ooOg02Sg2?lC0003o`000140000B0003o`00014000?o000010000ol0000X0003
o`0001P000?o0000:@000ol000040003o`00010000?o000080000ol0000A00So:oL00om`L00HL003
ooOg02Sg2?lC0003o`000140000B0003o`00014000?o00000`000ol0000Z0003o`0001H000?o0000
:`000ol000030003o`00010000?o000080000ol0000A00Oo;?L00g3oL00GL003ooOg02[g1olC0003
o`000140000C0003o`00010000?o00000P000ol0000[0003o`0001H000?o0000;0000ol000020003
o`00010000?o00008@000ol0000@00Ko;_L00om`L00FL003ooOg02_g1_lB0003o`000180000C0003
o`0000l000?o00000`000ol0000/0003o`0001@000?o0000;@000ol000030003o`0000l000?o0000
8@000ol0000?00Oo;_L00g3oL00EL003ooOg02cg1olA0003o`000180000D0003o`0000h000?o0000
0P000ol0000]0003o`0001@000?o0000;P000ol000020003o`0000h000?o00008`000ol0000>00Ko
<?L00om`L00DL003ooOg02gg1_l@0003o`0001<0000D0003o`0000h000Go0000o`0`0003o`0001@0
00?o0000;`001Ol0003o010000?o00008`000ol0000>00Go<OL00om`L00CL003moog02kg1_l@0003
o`0001<0000D0003o`0000d000Go0000o`0b0003o`00018000?o0000<@001Ol0003o00h000?o0000
9@000ol0000<00Ko<OL00om`L00CL003ooOg02og1?l00`3o000>0003o`0001<0000D0003o`0000d0
00Co003o<`000ol0000B0003o`00038000Co003o3P000ol0000U0003o`0000`01Olbm`03og1`01=`
00?omoL0<?L5o`l000?o00004`0001D000?o00002`001Ol0003o03@000?o00004@000ol0000b0005
o`000?l03@000ol0000U0003o`0000/01Oldm`03og1`015`00?omoL0<_L5o`d000?o0000500001D0
00?o00002`001?l00?le0003o`00014000?o0000<`001?l00?l=0003o`0002D000?o00002`04ocGg
00?oL7004G000oogm`0cm`Co3@000ol0000D00005P000ol000090004o`3oocL000?o00003`000ol0
000e00Co2`000ol0000W0003o`0000T01?lgm`03og1`00m`00?omoL0=OL4o`/000?o00005@0001H0
00?o000020000ol0o`08013o8@000ol0000?0003o`0001l04?l80003o`3o00X000?o00009`000ol0
000800Co1oL@ob7g00?oL7003g000oogm`0Oma3o2?L00ol0o`0:0003o`0001D0000G0003o`0000L0
0_l400Go4004oah000?o00003@000ol0000K00Go4004o`D00_l90003o`0002T000?o00001`03o`?g
1Ol4m`Wo0oL5oagg00?oL7003G000oogm`0Lm`Co1?L9o`?g1Ol4m`;o2@000ol0000F00005`000ol0
000600;o0P03oaT01?lJ0003o`0000d000?o00006003oaT01?l200;o20000ol0000Y0003o`0000H0
0ol01?Ooool2maKo0_L3oa[g00?oL7003G000oogm`0Hm`Co00?gool05?l2m`?o0_L2o`P000?o0000
5P0001P000?o00001005ob000olG0003o`0000d000?o00005@03ob001Ol60003o`0002/000?o0000
100XoaOg00?oL7003G000oogm`0EmbSo1P000ol0000G000060000ol0000300oo6P03oaD000?o0000
2`000ol0000D00;o6P0?o`D000?o0000:`000ol0000302co5OL00om`L00;L003ooOg01Cg:ol50003
o`0001L0000I0003o`0000Co3@03oaX00_lC0003o`0000/000?o00004@03oaT00ol<00Go0P000ol0
000]0003o`0000Ko2`0Lo`03mooo01?g00?oL7002g000oogm`0Amb3o2P03o`03mooo008000?o0000
600001T000Co0?oo4`02oaX000?o000040000ol0000:0003o`00014000?o00006002oa<00_l00`3o
000^0005o`3omol04P0Ko`03moog017g00=`og002g000oogm`0@m`03ooOo01_o4@001Oogo`3o01X0
000J0003o`0001D000?o000060000ol0000?0003o`0000X000?o00003`02oaT00_lG0003o`0002l0
00?o00005@0Moa7g00?oL7002W000oogm`0?maco5`000ol0000I00006P000ol0000F0003o`0001P0
00?o00003P000ol0000:0003o`0000h000?o000060000ol0000G0003o`0002l000?o00005`0Loa3g
00?oL7002G000oOom`0?maco60000ol0000I00006`000ol0000F0003o`0001P00ol>0003o`0000T0
00?o00003002oaX000?o00005`000ol0000a0003o`0001L07Ol>m`03og1`00U`00?omoL03OLMoaP0
00?o00006P0001`000?o00005P000ol0000J0003o`0000/000?o00002@000ol0000;0003o`0001T0
00?o00005`000ol0000c0003o`0001H07_l=m`03og1`00U`00?omoL02oLNoaT000?o00006P0001d0
00?o00005P02oa/000?o00002`000ol000070003o`0000/000?o00006@000ol0000G0003o`0003D0
00?o00005P0No`gg00?oL7001g000oogm`0;mako6002oad0000N0003o`0001L000?o00006@000ol0
000:0003o`0000L000?o00002P000ol0000I0003o`0001L000?o0000=`000ol0000F01ko3?L00om`
L007L003ooOg00[g7_lH0003o`0001d0000N0003o`0001P000?o00006@000ol000090003o`0000H0
00?o00002P000ol0000I0003o`0001P000?o0000=`000ol0000G01ko2oL00g3oL007L003ooOg00Wg
7_lI0003o`0001d0000O0003o`0001L000?o00006P000ol000080003o`0000H000?o00002@000ol0
000J0003o`0001L000?o0000>@000ol0000F01oo2_L00g3oL007L003ooOg00Sg7_lI0003o`0001h0
000O0003o`0001P000?o00006P000ol000070003o`0000H000?o00001`02oa`000?o000060000ol0
000i0003o`0001L08?l9m`03og1`00I`00?omoL01oLOoaT000?o00007P00020000?o00005`000ol0
000K0003o`0000L000?o00001@000ol000060003o`0001`000?o00005`000ol0000k0003o`0001L0
7_l00oOom`07m`03og1`00E`00?omoL01oLOoaT000?o00007`00020000?o000060000ol0000K0003
o`0000H000?o00001@000ol000050003o`0001`000?o00005`000ol0000m0003o`0001L07_l00oOo
m`06m`03og1`00E`00?omoL01_LOoaX000?o00007`0002400_lI0003o`0001X000?o00001P000ol0
00040003o`0000H000?o00006`000ol0000G0003o`0003l000?o00005P0Po`Og00=`og001G000oog
m`06mako6@02ob80000S0003o`0001H000?o00006`000ol000050003o`0000@000?o00001@000ol0
000L0003o`0001H000?o0000@@000ol0000F01ko00?gooL01_L00om`L004L003ooOg00Gg7olH0003
o`000280000S0003o`0001H000?o000070000ol000040003o`0000@000?o000010000ol0000L0003
o`0001H000?o0000@P000ol0000F01oo00?gooL01OL00om`L003L003moog00Gg8?lH0003o`000280
000T0003o`0001D000?o00007@000ol000040003o`0000<000?o00000`000ol0000M0003o`0001D0
00?o0000A0000ol0000E023o00?gooL01?L00om`L003L003ooOg00Cg8OlG0003o`0002<0000U0003
o`0001D000?o00007@000ol000030003o`0000<000?o00000P000ol0000N0003o`0001D000?o0000
A@000ol0000E023o00?gooL00oL00om`L003L003ooOg00?g8OlG0003o`0002@0000V0003o`0001@0
00?o00007@000ol000030003o`00008000?o00000`000ol0000N0003o`0001@000?o0000A`000ol0
000D023o00?gooL01?L00om`L002L003ooOg00?g8OlF0003o`0002D0000W0003o`0001<000?o0000
7P000ol000020003o`00008000?o00000P000ol0000O0003o`0001<000?o0000B@000ol0000C027o
00?gooL00oL01_m`L73go`Cg8_lE0003o`0002H0000X0003o`00018000?o00007`000ol000020005
o`000?l010000ol0000O0003o`00018000?o0000B`000ol0000B02?o1?L01Om`L73o00Cg8olD0003
o`0002L0000Y0003o`00014000?o00007`000ol000020005o`000?l010000ol0000O0003o`000100
0_m?00;o4P0So`Cg00GoL71`o`04mb?o4`000ol0000X0000:P000ol0000@0003o`0000X02ol;0005
o`000?l00`001Ol0003o00/02ol<0003o`0000l000?o0000D@000ol0000?02Co0oL01Om`L73o00?g
9?lB0003o`0002T0000[0003o`0000l000?o00001P04o`/00ol90004o`00o`<000Co003o2@03o`/0
0ol80003o`00010000?o0000D@000ol0000?00go2P0<o`05moogmol00g000oogm`0>o`X03OlA0003
o`0002X0000/00;o3`000ol000050003o`0001000_l70004o`00o`<000Co003o1`02oa400_l60003
o`0000h00_mE00;o3`0:oa002ol2m`05og1`L?l00_L;oa402Ol?00;o;@0002h000?o000030000ol0
000300;o5@000ol000040007o`000?l0o`020003o`0000@00_lE00;o1@000ol0000;00;oF@02o`d0
2?lD00So00OgooOgog3o00;g2_lD00So3P000ol0000]0000;`000ol0000;0004o`0000;o6002o`D0
00Ko003o0?l20003o`0000800_lI0003o`00008000?o00002P000ol0001K0003o`0000X01_lI00Oo
0_L00om`o`02m`So6006o`d000?o0000;P00030000?o00002P001?l00?lL0003o`00008000Ko003o
0?l20005o`000?l07002o`8000?o00002P000ol0001K0003o`0000X01OlK00Ko0_L00om`o`02m`Ko
7004o``000?o0000;`0003400_l:0003o`3o01h000?o00000P001ol0o`3o0?l00`000ol0000M0003
o`3o00X00_mO00;o2P03oah01_l01OOoL?og00Ko7P03o`X00_lb0000<`02o`L000?o0?l080002ol0
003o0?l0o`3o00<000?o00007@000ol0o`0800;oH`02o`P00olO00Go00Ggog3om`05ob000ol700;o
=00003D000?o00001002ob8000[o003o0?l0o`3o0P000ol0000O0003o`3o00H000?o0000I@000ol0
000400?o8@04o`05mom`ooL01?lR00;o1P000ol0000d0000=@000ol000040003o`00028000?o0000
0_l00`3oo`020003o`0002400_l50003o`0006L000?o00000`02ob801_l00g3oo`03ob@000?o0000
10000ol0000d0000=P02o`<000?o00008`000ol00002o`030?oo008000?o00008`000ol00002of/0
00Co00000_lT00Go00=`ool00olU0004o`0000;o=`0003P00_l00`3o000U0003o`3o00;o00@0o`3o
9P000ol0o`1^00;o00<0o`009@03o`03mooo00?o9P001?l0ooli0000>P02obL000?o0?l00_l00`3o
000V00;oL@02obH00_l00oOoo`04obH00_lk0000?002obD000?o0?l00_l00`3o000T00;oM@02obD0
00?omol01?lU00;o?@0003h00_lT00Go9002ogT00_lS00Ko9002ocl0001000;o8P05ob800_mm00;o
8P05ob800_m10000@P02ob400olQ00;oP@02ob001?lQ00;o@`0004@01?lM00?o7@04ohD00_lN0004
ooOooal00_m50000B002oa/00olK00;oR`04oa/000?gool06`04odL0001:00;o6@03oaT00_nA00;o
6@000oOoo`0I00;oB`0004`01?lF0003o`0001@01?nE00Co5@02oaH01?m=0000D005oa4000?o0000
3`05oid01Ol@00;o4P04oe40001E00Co3@000ol0000;00CoY`04o`d000?o00002`05oeD0001I00_o
0P000ol0000;ojl02ol20003o`0000_oFP0006@01Oo500GoI@000?l0V@000?l0V@000?l0V@000?l0
V@000?l0V@000?l0V@000?l0V@000?l0V@000001\
\>"],
  ImageRangeCache->{{{0, 407}, {193, 0}} -> {-0.0544136, -0.0238146, 
  0.0051814, 0.0051814}, {{10.5, 194.25}, {188.375, 4.5625}} -> {-1.17001,
   -1.10323, 0.0114287, 0.0114287}, {{212.688, 396.5}, {188.375, 4.5625}} ->
   {-3.47993, -1.10285, 0.0114248, 0.0114248}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Basic objects"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
p1 = Point[{0.5,0.5}]; p2 = Point[{-0.5,0.5}];
p3 = Point[{0.5,0}]; p4 = Point[{0,-0.9}];
g = Geodesic[p1, p2];
l = Line[p1,p3];
gn = Polygon[{p1,p2,p4}];
HDraw[{PointSize[0.02], p1, p2, p3, p4, g,
\tThickness[0.01], gn, l}]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.02 w
.7381 .7381 Mdot
.2619 .7381 Mdot
.7381 .5 Mdot
.5 .07143 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
.5 1.21429 .5324 228.19 311.81 arc
s
.01 w
newpath
.5 1.21429 .5324 243.435 296.565 arc
s
newpath
-0.69312 .02116 1.19418 2.41236 36.8953 arc
s
newpath
1.69312 .02116 1.19418 143.105 177.588 arc
s
newpath
1.09524 .61905 .37646 161.565 198.435 arc
s
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l06`000?l06`000?l06`000?l06`000?l0
6`000?l06`000?l06`0008<04on40000N@0:oa<02_mj0000M005obL01Ome0000K`05oc401Om`0000
JP05oc/01Om[0000I`03odD00omX0000I003od/00omU0000H@03oe400omR0000GP03oeL00omO0000
F`03oed00omL0000F@02of<00_mJ0000EP03ofL00omG0000E002ocD00ole00?oE00005400olf00Go
=`02oe80001@0003o`0003L01Oli0003o`0004l0001>00;o>P05ocX00om>0000B`03ocd00oln00;o
C00004X000?o0000?P02od4000?o0000B@0004P00_m100;o@P02odT000170003o`0004400_m40003
o`0004H0001500;oA002odD00_m60000A0000ol0001400;oA`000ol000130000@P02odL00_m800;o
@`0004000_m800CoB@02od40000o0003o`0004P01?m;0003o`0003h0000m00;oB`04od`00_ln0000
?0000ol0001;00CoCP000ol0000k0000>`000ol0001<00CoC`000ol0000j0000>P000ol0001=00Co
D0000ol0000i0000>002oe001?mA0003o`0003P0000g0003o`0005001?mB0003o`0003L0000f0003
o`0005401?mC0003o`0003H0000e0003o`0005801?mD00;o=P0003@000?o0000D`04oeH000?o0000
<`0003<000?o0000E004oeL000?o0000<P00038000?o0000E@04oeP000?o0000<@00034000?o0000
E@06oeP000?o0000<000030000?o0000EP02o`800_mI0003o`0002l0000_0003o`0005L00_l200;o
FP000ol0000^0000;P000ol0001H00;o0P02oe/000?o0000;@0002d000?o0000F@02o`800_mL0003
o`0002`0000/0003o`0005X00_l200;oG@000ol0000[0000:`000ol0001K00;o0P02oeh000?o0000
:P0002X000?o0000F`03o`800omN0003o`0002T0000Y0003o`0005`00_l400;oG`000ol0000X0000
:0000ol0001M00;o1002of0000?o00009`0002P000?o0000G@02o`@00_mQ0003o`0002H0000W0003
o`0005h00_l400;oHP000ol0000U00009P000ol0001O00;o1002of<000?o0000900002D000?o0000
H002o`@00_mS0003o`0002@0000T0003o`0006400_l400;oI0000ol0000S00008`000ol0001Q00?o
1003of@000?o00008P00028000?o0000HP02o`H00_mU0003o`000240000Q0003o`0006<00_l600;o
IP000ol0000P00008@000ol0001S00;o1P02ofH000?o00008000020000?o0000I002o`H00_mW0003
o`0001l0000O0003o`0006D00_l600;oJ0000ol0000N00007`000ol0001T00?o1P03ofL000?o0000
7P0001h000?o0000I@02o`P00_mX0003o`0001d0000M0003o`0006H00_l800;oJ@000ol0000L0000
7@000ol0001V00;o2002ofT000?o0000700001`000?o0000I`02o`P00_mZ0003o`0001/0000L0003
o`0006H00ol800?oJ@000ol0000K00006`000ol0001W00;o2P02ofX000?o00006P0001X000?o0000
J002o`X00_m[0003o`0001T0000J0003o`0006P00_l:00;oJ`000ol0000I00006@000ol0001Y00;o
2P02of`000?o0000600001P000?o0000J@03o`X00om/0003o`0001L0000H0003o`0006T00_l<00;o
K0000ol0000G00005`000ol0001Z00;o3002ofd000?o00005P0001H000?o0000J`02o``00_m^0003
o`0001D0000F0003o`0006X00ol<00?oK@000ol0000E00005@000ol0001[00;o3P02ofh000?o0000
500001D000?o0000J`02o`h00_m^0003o`0001@0000E0003o`0006/00_l>00;oKP000ol0000D0000
50000ol0001/00;o3P02ofl000?o00004`0001<000?o0000K003o`h00om_0003o`000180000C0003
o`0006`00_l@00;oK`000ol0000B00004`000ol0001/00;o4002og0000?o00004@00018000?o0000
K@02oa000_m`0003o`000140000A0003o`0006h00_l@00;oL0000ol0000A00004@000ol0001]00?o
4003og0000?o00004000014000?o0000K@02oa800_m`0003o`000100000A0003o`0006d00_lB00;o
L0000ol0000@000040000ol0001]00?o4P02og4000?o00003`0000l000?o0000KP02oa<00oma0003
o`0000h0000?0003o`0006h00_lD00;oL@000ol0000>00003`000ol0001^00;o5002og4000?o0000
3P0000h000?o0000KP03oa@00oma0003o`0000d0000>0003o`0006h00_lF00;oL@000ol0000=0000
3P000ol0001^00;o5P02og4000?o00003@0000d000?o0000KP03oaH00oma0003o`0000`0000=0003
o`0006h00_lH00;oL@000ol0000<00003@000ol0001^00;o6002og4000?o0000300000d000?o0000
KP02oaP00_ma0003o`0000`0000<0003o`0006l00_lH00;oLP000ol0000;000030000ol0001^00?o
6003og4000?o00002`0000`000?o0000KP02oaX00_ma0003o`0000/0000;0003o`0006l00_lJ00;o
LP000ol0000:00002`000ol0001^00?o6P03og4000?o00002P0000/000?o0000KP02oa`00_ma0003
o`0000X0000:0003o`0006l00_lL00;oLP000ol0000900002P000ol0001^00?o7003og4000?o0000
2@0000X000?o0000KP02oah00_ma0003o`0000T0000:0003o`0006h00_lN00;oL@000ol000090000
2P000ol0001]00?o7P03og0000?o00002@0000T000?o0000KP02ob000_ma0003o`0000P000090003
o`0006h00_lP00;oL@000ol0000800002@000ol0001]00?o8003og0000?o0000200000T000?o0000
K@02ob800_m`0003o`0000P000090003o`0006d00_lR00;oL0000ol00008000020000ol0001]00?o
8P03og0000?o00001`0000P000?o0000K@02ob@00_m`0003o`0000L000080003o`0006d00_lT00;o
L0000ol00007000020000ol0001/00?o9003ofl000?o00001`0000P000?o0000K002obH00_m_0003
o`0000L000070003o`0006d00_lV00;oL0000ol0000600001`000ol0001/00?o9P03ofl000?o0000
1P0000L000?o0000K002obP00_m_0003o`0000H000070003o`0006`00_lX00;oK`000ol000060000
1`000ol0001[00?o:003ofh000?o00001P0000L000?o0000JP03obX00om]0003o`0000H000070003
o`0006X00_l/00;oK@000ol0000600001`000ol0001Y00?o;003of`000?o00001P0000L000?o0000
J@02obh00_m/0003o`0000H000070003o`0006T00_l^00;oK0000ol0000600001P000ol0001Y00?o
;P03of`000?o00001@0000H000?o0000J@02oc000_m/0003o`0000D000060003o`0006T00_l`00;o
K0000ol0000500001P000ol0001X00?o<003of/000?o00001@0000H000?o0000J002oc800_m[0003
o`0000D000060003o`0006P00_lb00;oJ`000ol0000500001P000ol0001W00?o<P03obH00om10003
o`0000D000060003o`0006L00_ld00;o9@05od0000?o00001@0000H000?o0000I`02oc@00_lU00Go
@0000ol0000500001P000ol0001V00?o=003ob@01Om00003o`0000D000060003o`0006D00olf00?o
8`04od4000?o00001@0000H000?o0000I@02ocP00_lS00;o@`000ol0000500001P000ol0001T00?o
>003ob800_m30003o`0000D000060003o`0006@00_lj00;o8P02od<000?o00001@0000H000?o0000
I002ocX00_lQ00?o@`000ol0000500001P000ol0001S00?o>P03ob000_m40003o`0000D000060003
o`0006<00_ll00;o8002od@000?o00001@0000H000?o0000HP03oc`00olO00;oA0000ol000050000
1`000ol0001P00?o?P03oad00om30003o`0000H000070003o`0006000_m000;o7@02od@000?o0000
1P0000L000?o0000G`03od000olL00;oA0000ol0000600001`000ol0001O00;o@P02oa`00_m40003
o`0000H000070003o`0005l00_m200;o6`03od@000?o00001P0000L000?o0000GP03od800olJ00;o
A@000ol0000600001`000ol0001N00;oA002oaX00_m50003o`0000H000070003o`0005h00_m400;o
6P02odD000?o00001P0000L000?o0000G@03od@00olI00;oA@000ol0000600001`000ol0001L00?o
AP03oaP00_m50003o`0000H000080003o`0005/00_m800;o6002od@000?o00001`0000P000?o0000
FP03odP00olF00?oA0000ol00007000020000ol0001J00;oBP02oaH00_m50003o`0000L000080003
o`0005T00om:00?o5@02odD000?o00001`0000P000?o0000F003od`00olD00;oA@000ol000070000
2@000ol0001G00;oCP02oa@00_m40003o`0000P000090003o`0005H00om>00?o4`02od@000?o0000
200000T000?o0000EP02oe000_lC00;oA0000ol0000800002@000ol0001F00;oD002oa<00_m40003
o`0000P000090003o`0005D00om@00?o4P02od@000?o0000200000X000?o0000D`03oe800olA00;o
@`000ol0000900002P000ol0001C00;oE002oa000om30003o`0000T0000:0003o`0005800omD00?o
3`02od@000?o00002@0000X000?o0000DP02oeH00_l?00;oA0000ol0000900002P000ol0001A00?o
EP03o`h00_m40003o`0000T0000;0003o`0004l00omH00?o3@02od<000?o00002P0000/000?o0000
C`02oeX00_l=00;o@`000ol0000:00002`000ol0001>00?oFP03o``00_m30003o`0000X0000<0003
o`0004`00omL00?o2`03od4000?o00002`0000`000?o0000C002oeh00_l<00;o@@000ol0000;0000
30000ol0001;00?oGP03o`/00_m10003o`0000/0000=0003o`0004X00_mP00;o2`02od0000?o0000
300000d000?o0000B@03of000ol:00;o@0000ol0000<00003@000ol0001800?oHP03o`T00_m00003
o`0000`0000>0003o`0004L00_mT00;o2@02ocl000?o00003@0000h000?o0000AP03of@00ol800;o
?`000ol0000=00003P000ol0001500?oIP03o`L00_lo0003o`0000d0000?0003o`0004@00_mX00;o
1`02och000?o00003P0000l000?o0000@`03ofP00ol600?o?@000ol0000>00003`000ol0001300;o
JP02o`L00_lm0003o`0000h0000@0003o`0004400omZ00?o1P02oc`000?o00003`00010000?o0000
@003ob/05olZ00?o1@02oc`000?o00003`00014000?o0000?`02ob80:olQ00;o1@02oc/000?o0000
4000014000?o0000?P03oa/04_lD01;o6`03o`@00_lk0003o`000100000A0003o`0003d00olH00co
:@0;oaP00ol300?o>P000ol0000@00004P000ol0000l00;o5@09ocH02_lD00;o1002ocT000?o0000
4@00018000?o0000>`03oa002_ln00[o4003o`<00_li0003o`000140000C0003o`0003T00ol=00[o
AP0:o`d00ol200;o>0000ol0000B00004`000ol0000i00;o3007oe001ol<00;o0P02ocP000?o0000
4P0001<000?o0000>003o`P01omH00Oo2003o`040?ooocL000?o00004P0001@000?o0000=`02o`L0
1omL00Oo1`02o`800_lf0003o`0001<0000E0003o`0003D00ol500GoI005o`D00ol00`3oo`0e0003
o`0001@0000E0003o`0003@00ol200OoJ007o`801Ole0003o`0001@0000F0003o`0003800ol00`3o
o`05of`01ol00`3oo`03oc<000?o00005@0001H000?o0000<@08og@02Olc0003o`0001D0000F0003
o`0002l02?mh00Wo<@000ol0000E00005`000ol0000]00OoO008obl000?o00005P0001P000?o0000
;005oh001_l^0003o`0001L0000H0003o`0002`01On100Ko;@000ol0000G00006@000ol0000Y00;o
00@0ooooP`03o`8000?o0000:@000ol0000H00006P000ol0000V00;oS`03obL000?o00006@0001X0
00?o00008`03oi@00_lU0003o`0001T0000K0003o`00024000?o0000U`000ol0000Q0003o`0001X0
000L0003o`0001h00_nK00;o80000ol0000K000070000ol0000M0003o`0009d000?o00007@000ol0
000K00007@000ol0000J00;oX@02oa`000?o0000700001d000?o00006@000ol0002S0003o`0001T0
00?o0000700001h000?o00005`000ol0002U0003o`0001L000?o00007@0001l000?o00005@000ol0
002W0003o`0001D000?o00007P0001l000?o00004`02oj/00_lE0003o`0001h0000P0003o`000140
00?o0000[@000ol0000A0003o`0001l0000Q0003o`0000h00_na00;o40000ol0000P00008P000ol0
000<0003o`000;<000?o000030000ol0000Q00008`000ol0000900;o]`02o`/000?o00008P0002<0
00?o000020000ol0002i0003o`0000P000?o00008P0002@000?o00001P000ol0002k0003o`0000H0
00?o00008`0002D000?o000010000ol0002m0003o`0000@000?o0000900002H000Co00000_o100;o
0`000ol0000U00009`000ol0o`350003o`3o02P0000X0003o`000<D000?o00009`0002T000?o0000
``000ol0000X0000:P000ol000310003o`0002T0000[0003o`000;l000?o0000:P0002`000?o0000
_@000ol0000[0000;@000ol0002k0003o`0002`0000^0003o`000;T000?o0000;@0002l000?o0000
]`000ol0000^0000<0000ol0002e0003o`0002l0000a0003o`000;<000?o0000<000038000?o0000
/@000ol0000a0000<`02ok0000?o0000<P0003D000?o0000[0000ol0000c0000=P000ol0002Z0003
o`0003@0000g0003o`000:L00_lg0000>0000ol0002U0003o`0003L0000i0003o`000:<000?o0000
>00003X000?o0000X@000ol0000i0000>`02oil00_ll0000?@000ol0002K0003o`0003`0000n00;o
V@02ocl000100003o`0009D000?o0000?`0004400_nC00;o@P0004<00_n?00;oA00004D000?o0000
R`000ol000140000AP02ohT00_m70000B0000ol000250003o`0004L0001900;oP`02odX0001;0003
o`0007l000?o0000BP0004`00oml00;oC@0004l00_mg00?oC`00054000?o0000L`000ol0001@0000
DP03og000_mC0000E@000ol0001[00;oE@0005H01?mU00CoE`0005X000?o0000H@000ol0001I0000
F`03oed00omL0000GP03oeL00omO0000H@04odl01?mR0000I@03odT00omV0000J003od<00omY0000
J`05ocT01Om/0000L005obl01Oma0000M@05obD01Omf0000NP0:oa402_mk0000Q00AohD0003o01/0
003o01/0003o01/0003o01/0003o01/0003o01/00000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-1.05001, -1.05001, 0.00747339, 
  0.00747339}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Inversions of a octagon"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
poly0 = NGP[RegularPolygon[8,2*Pi/3]];
diag0 = Diagonals[poly0];\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
g1 = Geodesic @@ Part[poly0, 1, {1,2}];
inv1 = Inversion[g1];
diag1 = Map[inv1, diag0];
poly1 = inv1[poly0];\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
g2 = Geodesic @@ Part[poly1, 1, {3,4}];
inv2 = Inversion[g2];
diag2 = Map[inv2, diag1];
poly2 = inv2[poly1];\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
SetOptions[PointLabel, DefaultFont -> {\"Times-Roman\", 18}];
octlabel = {PointLabel[ZPoint[-0.2+0.65*I],\"g1\"],
\tPointLabel[ZPoint[0.8+0.05*I],\"g2\"]};\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{Thickness[0.003], 
\t{color1, poly0 /. Polygon -> FilledPolygon}, 
\tdiag0,
\t{color2, poly1 /. Polygon -> FilledPolygon}, 
\tdiag1,
\t{color3, poly2 /. Polygon -> FilledPolygon}, 
\tdiag2, g1, g2, octlabel}]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[.40476 .80952 -11 -9 ]
[.40476 .80952 11 9 ]
[.88095 .52381 -11 -9 ]
[.88095 .52381 11 9 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.7 g
.5 .69315 m
.5086 .68828 L
.51729 .68357 L
.52605 .679 L
.5349 .67459 L
.54382 .67034 L
.55281 .66624 L
.56188 .6623 L
.57101 .65852 L
.5802 .65489 L
.58946 .65143 L
.59878 .64813 L
.60815 .645 L
.61758 .64203 L
.62705 .63922 L
.63658 .63658 L
.63658 .63658 L
.63922 .62705 L
.64203 .61758 L
.645 .60815 L
.64813 .59878 L
.65143 .58946 L
.65489 .5802 L
.65852 .57101 L
.6623 .56188 L
.66624 .55281 L
.67034 .54382 L
.67459 .5349 L
.679 .52605 L
.68357 .51729 L
.68828 .5086 L
.69315 .5 L
.69315 .5 L
.68828 .4914 L
.68357 .48271 L
.679 .47395 L
.67459 .4651 L
.67034 .45618 L
.66624 .44719 L
.6623 .43812 L
.65852 .42899 L
.65489 .4198 L
.65143 .41054 L
.64813 .40122 L
.645 .39185 L
.64203 .38242 L
.63922 .37295 L
.63658 .36342 L
.63658 .36342 L
.62705 .36078 L
.61758 .35797 L
.60815 .355 L
.59878 .35187 L
.58946 .34857 L
.5802 .34511 L
.57101 .34148 L
.56188 .3377 L
.55281 .33376 L
.54382 .32966 L
.5349 .32541 L
.52605 .321 L
.51729 .31643 L
.5086 .31172 L
.5 .30685 L
.5 .30685 L
.4914 .31172 L
.48271 .31643 L
.47395 .321 L
.4651 .32541 L
.45618 .32966 L
.44719 .33376 L
.43812 .3377 L
.42899 .34148 L
.4198 .34511 L
.41054 .34857 L
.40122 .35187 L
.39185 .355 L
.38242 .35797 L
.37295 .36078 L
.36342 .36342 L
.36342 .36342 L
.36078 .37295 L
.35797 .38242 L
.355 .39185 L
.35187 .40122 L
.34857 .41054 L
.34511 .4198 L
.34148 .42899 L
.3377 .43812 L
.33376 .44719 L
.32966 .45618 L
.32541 .4651 L
.321 .47395 L
.31643 .48271 L
.31172 .4914 L
.30685 .5 L
.30685 .5 L
.31172 .5086 L
.31643 .51729 L
.321 .52605 L
.32541 .5349 L
.32966 .54382 L
.33376 .55281 L
.3377 .56188 L
.34148 .57101 L
.34511 .5802 L
.34857 .58946 L
.35187 .59878 L
.355 .60815 L
.35797 .61758 L
.36078 .62705 L
.36342 .63658 L
.36342 .63658 L
.37295 .63922 L
.38242 .64203 L
.39185 .645 L
.40122 .64813 L
.41054 .65143 L
.4198 .65489 L
.42899 .65852 L
.43812 .6623 L
.44719 .66624 L
.45618 .67034 L
.4651 .67459 L
.47395 .679 L
.48271 .68357 L
.4914 .68828 L
.5 .69315 L
F
0 g
.003 w
[ ] 0 setdash
newpath
.78314 1.18357 .56629 240 255 arc
s
newpath
1.18357 .78314 .56629 195 210 arc
s
newpath
1.18357 .21686 .56629 150 165 arc
s
newpath
.78314 -0.18357 .56629 105 120 arc
s
newpath
.21686 -0.18357 .56629 60 75 arc
s
newpath
-0.18357 .21686 .56629 15 30 arc
s
newpath
-0.18357 .78314 .56629 330 345 arc
s
newpath
.21686 1.18357 .56629 285 300 arc
s
.5 .69315 m
.5 .30685 L
s
.63658 .63658 m
.36342 .36342 L
s
.69315 .5 m
.30685 .5 L
s
.63658 .36342 m
.36342 .63658 L
s
.85 g
.5 .69315 m
.5086 .68828 L
.51729 .68357 L
.52605 .679 L
.5349 .67459 L
.54382 .67034 L
.55281 .66624 L
.56188 .6623 L
.57101 .65852 L
.5802 .65489 L
.58946 .65143 L
.59878 .64813 L
.60815 .645 L
.61758 .64203 L
.62705 .63922 L
.63658 .63658 L
.63658 .63658 L
.72243 .72243 L
.72243 .72243 L
.72074 .72914 L
.71925 .73589 L
.71796 .74268 L
.71687 .74951 L
.71598 .75636 L
.71529 .76324 L
.7148 .77014 L
.71452 .77704 L
.71444 .78396 L
.71457 .79087 L
.7149 .79777 L
.71543 .80467 L
.71543 .80467 L
.71087 .80806 L
.70649 .81167 L
.70228 .81548 L
.69826 .8195 L
.69444 .8237 L
.69083 .82809 L
.68743 .83264 L
.68426 .83736 L
.68132 .84222 L
.67863 .84722 L
.67617 .85234 L
.67617 .85234 L
.67106 .853 L
.666 .85392 L
.66099 .85512 L
.65605 .85657 L
.6512 .85829 L
.64644 .86026 L
.64179 .86248 L
.63727 .86494 L
.63288 .86764 L
.62865 .87057 L
.62457 .87372 L
.62457 .87372 L
.61921 .87183 L
.61377 .8702 L
.60825 .86884 L
.60268 .86775 L
.59706 .86693 L
.5914 .86638 L
.58573 .86611 L
.58005 .86611 L
.57437 .86639 L
.56872 .86694 L
.5631 .86776 L
.5631 .86776 L
.5586 .86251 L
.55395 .8574 L
.54915 .85242 L
.54421 .84759 L
.53913 .8429 L
.53391 .83837 L
.52856 .83399 L
.52308 .82978 L
.51748 .82572 L
.51176 .82183 L
.50594 .81811 L
.5 .81457 L
.5 .81457 L
.5 .69315 L
F
0 g
newpath
.78314 1.18357 .56629 240 255 arc
s
.63658 .63658 m
.72243 .72243 L
s
newpath
.94901 .78314 .23456 174.736 195 arc
s
newpath
.78314 .90043 .11728 204.203 234.736 arc
s
newpath
.68598 .94901 .09716 230.797 264.203 arc
s
newpath
.58293 .98336 .11728 260.264 290.797 arc
s
newpath
.38272 1.01771 .23456 300 320.264 arc
s
.5 .81457 m
.5 .69315 L
s
newpath
.21686 1.18357 .56629 300 324.203 arc
s
newpath
1.18357 .78314 .56629 170.797 195 arc
s
newpath
.78314 .94901 .23456 200.264 255 arc
s
newpath
.61728 1.01771 .23456 240 294.736 arc
s
.95 g
.8312 .75953 m
.82863 .75609 L
.82611 .7526 L
.82367 .74907 L
.82129 .74549 L
.81897 .74187 L
.81672 .73821 L
.81454 .73451 L
.81242 .73077 L
.81038 .72699 L
.80841 .72317 L
.8065 .71932 L
.80467 .71543 L
.80467 .71543 L
.79777 .7149 L
.79087 .71457 L
.78396 .71444 L
.77704 .71452 L
.77014 .7148 L
.76324 .71529 L
.75636 .71598 L
.74951 .71687 L
.74268 .71796 L
.73589 .71925 L
.72914 .72074 L
.72243 .72243 L
.72243 .72243 L
.72074 .72914 L
.71925 .73589 L
.71796 .74268 L
.71687 .74951 L
.71598 .75636 L
.71529 .76324 L
.7148 .77014 L
.71452 .77704 L
.71444 .78396 L
.71457 .79087 L
.7149 .79777 L
.71543 .80467 L
.71543 .80467 L
.71932 .8065 L
.72317 .80841 L
.72699 .81038 L
.73077 .81242 L
.73451 .81454 L
.73821 .81672 L
.74187 .81897 L
.74549 .82129 L
.74907 .82367 L
.7526 .82611 L
.75609 .82863 L
.75953 .8312 L
.75953 .8312 L
.76259 .83002 L
.76571 .829 L
.76888 .82815 L
.77209 .82747 L
.77533 .82697 L
.77859 .82664 L
.78187 .82648 L
.78515 .8265 L
.78842 .8267 L
.79168 .82707 L
.79168 .82707 L
.79334 .82507 L
.79513 .82319 L
.79704 .82143 L
.79906 .81979 L
.80118 .81829 L
.80339 .81692 L
.80569 .81571 L
.80805 .81464 L
.81049 .81373 L
.81297 .81297 L
.81297 .81297 L
.81373 .81049 L
.81464 .80805 L
.81571 .80569 L
.81692 .80339 L
.81829 .80118 L
.81979 .79906 L
.82143 .79704 L
.82319 .79513 L
.82507 .79334 L
.82707 .79168 L
.82707 .79168 L
.8267 .78842 L
.8265 .78515 L
.82648 .78187 L
.82664 .77859 L
.82697 .77533 L
.82747 .77209 L
.82815 .76888 L
.829 .76571 L
.83002 .76259 L
.8312 .75953 L
F
0 g
newpath
1.01771 .61728 .23456 142.667 155.264 arc
s
newpath
.78314 .94901 .23456 255 275.264 arc
s
newpath
.94901 .78314 .23456 174.736 195 arc
s
newpath
.61728 1.01771 .23456 294.736 307.333 arc
s
newpath
.78314 .88774 .06127 247.333 278.007 arc
s
newpath
.82339 .85185 .04024 218.007 255 arc
s
newpath
.85185 .82339 .04024 195 231.993 arc
s
newpath
.88774 .78314 .06127 171.993 202.667 arc
s
newpath
.84179 .84179 .08293 187.333 262.667 arc
s
newpath
.90043 .78314 .11728 158.007 215.264 arc
s
.72243 .72243 m
.81297 .81297 L
s
newpath
.78314 .90043 .11728 234.736 291.993 arc
s
newpath
.78314 1.18357 .56629 207.44 287.56 arc
s
newpath
.94901 .78314 .23456 148.46 276.011 arc
s
gsave
.40476 .80952 -72 -13 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26 translate 1 -1 scale
63.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g1) show
81.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.88095 .52381 -72 -13 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26 translate 1 -1 scale
63.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g2) show
81.000000 17.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 18.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l06`000?l06`000?l06`000?l06`000?l0
6`000?l06`000?l06`0008<04on40000N@0:oa<02_mj0000M005obL01Ome0000K`05oc401Om`0000
JP05oc/01Om[0000I`03odD00omX0000I003od/00omU0000H@03oe400omR0000GP03oeL00omO0000
F`03oed00omL0000F@02of<00_mJ0000EP03ofL00omG0000E002ofd00omD0000D@03og800_mB0000
D0000ol0001e0003o`0004l0001>00;oN@03odh0001;00?oOP02od`0001:0003o`00084000?o0000
B@0004P00_n500;oB@0004L000?o0000Q`000ol000160000A@02oh/00_m60000A0000ol0002=0003
o`0004<0001200;oT@02od<0001000;oU@02od40000o0003o`0009L000?o0000?P0003d00_nK00;o
?P0003`000?o0000W@000ol0000k0000>`000ol0002O0003o`0003X0000j0003o`000:4000?o0000
>@0003P00_nU0003o`0003P0000g0003o`000:H000?o0000=`0003H000?o0000Z0000ol0000f0000
=@000ol0002Z00;o=P0003@000?o0000[@000ol0000c0000<`000ol0002_0003o`000380000b0003
o`000;4000?o0000<@00034000?o0000/`000ol0000`0000<0000ol0002e0003o`0002l0000_0003
o`000;L000?o0000;P0002h000?o0000^@000ol0000]0000;@000ol0002k0003o`0002`0000/0003
o`000;d000?o0000:`0002/000?o0000_`000ol0000Z0000:P000ol000310003o`0002T0000Y0003
o`000<<000?o0000:00002P000?o0000a@000ol0000W0000:0000ol000360003o`0002H0000W0003
o`000<P000?o00009@0002H000?o0000bP000ol0000T00009@000ol0003;0003o`0002@0000T0003
o`000<d000?o00008`0002<000?o0000c`000ol0000R00008P000ol0003A0003o`000240000Q0003
o`000=<000?o00008000024000?o0000d`000ol0000P000080000ol0003E0003o`0001l0000O0003
o`000=L000?o00007P0001l000?o0000e`000ol0000N00007P000ol0003I0003o`0001d0000M0003
o`000=/000?o0000700001d000?o0000f`000ol0000L000070000ol0003M0003o`0001/0000L0003
o`000=d000?o00006`0001/000?o0000g`000ol0000J00006P000ol0003Q0003o`0001T0000J0003
o`000>4000?o00006@0001T000?o0000h`000ol0000H000060000ol0003U0003o`0001L0000H0003
o`000>D000?o00005`0001L000?o0000i`000ol0000F00005P000ol0003Y0003o`0001D0000F0003
o`000>T000?o00005@0001D000?o0000j`000ol0000D00005@000ol0003[0003o`0001@0000E0003
o`000>/000?o0000500001@000?o0000k@000ol0000C00004`000ol0003_0003o`000180000C0003
o`000>l000?o00004P0001<000?o0000l0000ol0000A00004P000ol0003a0003o`000140000A0003
o`0007L00omh0003o`000140000A0003o`0007D00_l00o3ol003ogH000?o00004000014000?o0000
LP03o`08h?3Pon3`h?02og@000?o00004000014000?o0000L@000ol0l004l003oo3`00?`00<0o`00
LP000ol0000@000040000ol0001a000Ao`3`h?3Pl>3oh?3Pl>3`0?l0L`000ol0000?00003`000ol0
001`00;o2?000oo`l006l0?oL@000ol0000>00003`000ol0001]00?o01K`h?3Pl>3`h?3Pon3`h?3P
l>3`h?3P0_m_0003o`0000h0000?0003o`0006/00_l=l003oo3`00_`0_m]0003o`0000h0000>0003
o`0006X00_l07n3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>000om[0003o`0000d0000>0003
o`0006L00olAl003oo3`013`0_mY0003o`0000d0000>0003o`0006D00_l0:O3Pl>3`h?3Pl>3`h?3P
l>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`00?oIP000ol0000=00003@000ol0001S00?o5_000oo`
l00El0;oI@000ol0000<00003@000ol0001Q00;o03?Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>000_mS0003o`0000`0000=0003o`0005`01OlKl003oo3`01W`
1OmN0003o`0000`0000=0003o`0005X00_l0@@3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
on3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`00?oF`000ol0000<000030000ol0001H00?o
8_000oo`l00Ql0;oFP000ol0000;000030000ol0001G001=on3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?l0F@000ol0
000;000030000ol0001G00;o9?000oo`l00Rl0;oF@000ol0000;00002`000ol0001G001?oo3Pon3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pon3`o`1I0003o`0000X0000;0003o`0005L000Gol?3`o`0Rl003oo3`023`00Gol?3`
o`1I0003o`0000X0000;0003o`0005H0057oh?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
l>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?l0F0000ol0000:0000
2P000ol0001G0003oo3`00C`00?ol?007_000oo`l00Nl003oo3`00C`00?o0000E`000ol000090000
2P000ol0001G001Aon3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3o05T000?o00002@0000X000?o0000EP000oo`
l007l003oo3`01c`00?ol?007?000oo`l007l003o`0005H000?o00002@0000X000?o0000EP00Doo`
h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pon3`h?3Pl>3`h?3o05P000?o00002@0000X000?o0000EP000oo`l009l003oo3`01[`
00?ol?006_000oo`l009l003o`0005H000?o00002@0000T000?o0000E`00Doo`h?3Pl>3`h?3Pl>3o
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`
h?3Pl>3`h?3o05T000?o0000200000T000?o0000EP000o3ol00<l003oo3`01S`00?ol?006?000oo`
l00;l003o`0005L000?o0000200000T000?o0000EP00EOoPl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?l0
F0000ol0000800002@000ol0001E0003l?o`00o`00?ol?005_000oo`l00Fl003oo3`00k`00?o0000
EP000ol0000800002@000ol0001E001Goo3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3o05L000?o0000
200000P000?o0000EP000oo`l00Al003oo3`01C`00?ol?005?000oo`l00Al003o`0005H000?o0000
1`0000P000?o0000E@00FOoPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
on3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3o05L000?o00001`0000P0
00?o0000E@000oo`l00Dl003oo3`01;`00?ol?004_000oo`l00Dl003o`0005D000?o00001`0000P0
00?o0000E000F^3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`
h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3PoeL000?o00001`0000P000?o0000
E0000oo`l00Gl003oo3`013`00?ol?004?000oo`l00Gl003o`0005@000?o00001`0000L000?o0000
E@00Foo`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`
h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl?l0E`000ol0000600001`000ol0001D0003
oo3`01[`00?ol?003_000oo`l00>l003oo3`01[`00?o0000E0000ol0000600001`000ol0001D001M
on3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3P
l>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3o05H000?o00001P0000L000?o0000E0000oo`
l00Ll003oo3`00c`00?ol?003?000oo`l00Ll003o`0005@000?o00001P0000L000?o0000D`00Goo`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3o
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3o05D000?o00001P0000L000?o0000D`000oo`
l00Ol003oo3`00[`00?ol?002_000oo`l00Ol003o`0005<000?o00001P0000L000?o0000DP00HOoP
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?oP
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?l0E0000ol0000600001`000ol0001B0003
oo3`02;`00?ol?002?000oo`l008l003oo3`02;`00?o0000DP000ol0000600001`000ol0001A001S
oo3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?oPl>3`h?3Pl>3o
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3o05<000?o00001P0000L000?o0000
D@000oo`l00Ul003oo3`00K`00?ol?001_000oo`l00Ul003o`00054000?o00001P0000H000?o0000
D@00IOoPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pon3`h?3P
l>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3o05<000?o00001@0000H0
00?o0000D0000oo`l00Yl003oo3`00C`00?ol?001?000oo`l00Xl0030?l0054000?o00001@0000H0
00?o0000D000Ioo`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`
h?oPl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl?l0DP000ol0
000500001P000ol0001?0003oo3`02c`00?ol?000_000oo`l002l003oo3`02c`00?o0000C`000ol0
000500001P000ol0001?001Yon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
l>3`h?3Pon3`h?oPl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
l>3o054000?o00001@0000H000?o0000CP000oo`l00_l004oo3`o`;`00?ol?00;o000ol0001>0003
o`0000D000060003o`0004h006_ol>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3oh?oPon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`o`1@0003o`0000D000060003o`0004h000?ol?00<O03oc?`00?o0000CP000ol000050000
1P000ol0001=06go:`06oah000?o00001@0000H000?o0000C@000oo`l00bl0?o=?000ol0000X0003
o`0000@000?o00006`000ol0000500001P000ol0001>001[oo3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3oh?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl?l0:`02o`H000?o00006P000ol0000500001P000ol0001>0003
oo3`02o`00Col?3o0_000oo`l00_l003o`0002/01olL0003o`0000D000060003o`0004l006Woh?3P
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pon3`h?oPl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?l0;@07o`801olD0003o`0000D0
00060003o`0004l000?ol?00;?000oo`l002l003oo3`00;`00?ol?00;?000ol0000[00;o2006oa@0
00?o00001@0000H000?o0000C`00JOoPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
l>3`h?3Pl>3oh?3Pl>3oh?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
l>3`h?3Po`0_00Co1@000ol000020003o`00014000?o00001@0000H000?o0000D0000oo`l00Yl003
oo3`00C`00?ol?001?000oo`l00Yl003o`0002d00_l200;o1002oaL000?o00001@0000H000?o0000
D@00IOoPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pon3`h?3P
l>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3o02l00_l300;o1@000ol0
000E0003o`0000D000060003o`00058000?ol?009O000oo`l006l003oo3`00K`00?ol?009O000ol0
000^00;o0`02o`H000?o000050000ol0000500001`000ol0001A001Soo3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?oPl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3o034000?o00001?l500;o50000ol0000600001`000ol0001A0003
l?o`02?`00?ol?002?000oo`l008l003oo3`02;`00?o0000<@03o`T000?o00004P000ol000060000
1`000ol0001B001Qon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3P
on3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Po`0o00;o4`000ol0
000600001`000ol0001B0003oo3`023`00?ol?002_000oo`l00:l003oo3`023`00?o0000>0000ol0
000200;o4`000ol0000600001`000ol0001C001Ooo3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pon3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl?l0>`02o`800ol201;o200000L000?o0000D`000oo`l00Ml003oo3`00c`00?ol?003?000oo`
l00Ml003o`0003X02?lA0003o`0000H000070003o`0005<005kPon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3o?005oaD000?o00001P0000L000?o0000E0000oo`l00Jl003oo3`00k`00?ol?00
3_000oo`l00Jl003o`0003P00_lJ0003o`0000H000070003o`0005@005c`oo3Pl>3`h?3Pl>3`h?3P
l>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3`ocL01?lL0003o`0000H000070003o`0005D000?ol?005o000oo`l00@l003
oo3`013`00?ol?005o000ol0000b00?o80000ol00006000020000ol0001D001Koo3Pl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`o`0b00;o8P000ol00007000020000ol0001D0003l?o`01G`00?ol?00
4_000oo`l00Bl003oo3`01C`00?o0000;`02ob@000?o00001`0000P000?o0000E@00FOoPl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oP
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3o030000?o000090000ol00007000020000ol0001E0003l?o`01;`
00?ol?005?000oo`l00Dl003oo3`017`00?o0000;P000ol0000U0003o`0000L000080003o`0005D0
05S`oo3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3P
l>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3o;P02obP000?o00001`0000T000?o0000E@000oo`
l00?l003oo3`01K`00?ol?005_000oo`l00?l003o`0002/000?o00009`000ol0000800002@000ol0
001E001Fh?oPl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?l]0003o`0002P000?o0000200000T000?o0000
EP000oo`l00<l003oo3`01S`00?ol?006?000oo`l00<l003o`0002X000?o0000:@000ol000080000
2@000ol0001F001Dl?o`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pon3`h?3P
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3o:`02ob`000?o0000200000T000?o0000
EP000o3ol00:l003oo3`01[`00?ol?006_000oo`l009l003o`0002L00_l^0003o`0000P0000:0003
o`0005H005?ol>3`h?3Pl>3`h?oPl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl>3`o`0X0003o`0002d000?o00002@0000X000?o0000
EP000oo`l007l003oo3`01c`00?ol?007?000oo`l007l003o`0002H000?o0000;@000ol000090000
2P000ol0001F001Coo3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3Pl?l09`000ol0000^0003o`0000T0000:0003
o`0005L000?ol?001?000oo`l00Nl003oo3`01k`00?ol?001?000ol0000H01_o90000ol000090000
2P000ol0001G001Aon3`h?3Pon3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3o01402Ol;00;o3P08oa`000?o00002@0000/0
00?o0000E`001Oo`l?3o02;`00?ol?008?001Oo`l?3o00/01olC0003o`0001H01olD0003o`0000X0
000;0003o`0005L004ool>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3o00H01OlJ0003o`0001d01Ol?0003o`0000X0
000;0003o`0005L000?ol?l09?000oo`l00Rl003oo3o00<00olN0003o`0002<01?l;0003o`0000X0
000<0003o`0005L00_l0BO3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`h?3P
l>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?001_lP0003o`0002P01Ol50003o`0000/0000<0003
o`0005T00olQl003oo3`01o`1_lR0003o`0002h00ol20003o`0000/0000<0003o`0005`00_l0?^3`
h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`
1?l3T003oi3o024000?o0000<@03o`d0000=0003o`0005d01OlJl003oo3`01S`1Ol02X2@P920T?n@
P?lO0003o`0003<000?o0000300000d000?o0000H000=O3Pooo`h?3Pl>3`h?3Pl>3`h?3Pl>3`h?3P
l>3oh?3Pl>3`h?3Pl>3`h?3Pl>3`h?3Pl>3`00?o00?`T9001Y000on@T002T003o`0001/000?o0000
=0000ol0000<00003@000ol0001S0004l?oooaG`00?ol?005?03o`0Bl920T82@P920T83oP920T83o
6`000ol0000e0003o`0000`0000>0003o`0006@002_Pl?ooh?3Pl>3`h?3Pl>3`h?3Pl>3`h?oPl>3`
h?3Pl>3`h?3Pl>3`h?3P00?o00?PT9002i000on@T004T003o`0001L000?o0000=@000ol0000=0000
3P000ol0001W0004l?oooa3`00?ol?003o02o`;`01R0T82@P920T82@P920T83oP920T82@P?lH0003
o`0003D000?o00003@0000h000?o0000JP008>3ooo3Pl>3`h?3Pl>3`h?3Pon3`h?3Pl>3`h?3Pl>3`
0ol00o2@T00?T003oi2@00N@00?o000050000ol0000f0003o`0000d0000?0003o`0006/000?`ool0
3?000oo`l00:l0;o027`P920T82@P920T82@P920T82@P93oT82@P920T82@P?l05@000ol0000e0003
o`0000h0000?0003o`0006h00ol05>3`h?3Pl>3`h?oPl>3`h?3Pl>3`0_l00n2@T00DT003oi2@00V@
00?o00004@000ol0000f0003o`0000h0000?0003o`00070000?`oo001o000oo`l006l0?o02J0T82@
P920T82@P920T82@P920T82@P93oT82@P920T82@P920oa8000?o0000=P000ol0000>000040000ol0
001a000?on3`h?3Pl>3oh?3Pl>3`00;o6i000on@T00;T003o`0000h000?o0000=P000ol0000?0000
40000ol0001b00;o1O000oo`l003l0;o02b0T82@P920T82@P920T82@P920T82@P920T82@oi20T82@
P920T82@P920o`l000?o0000=P000ol0000?00004@000ol0001c00?o00K`h?oPl>02oaj@00?oT900
3I000ol0000;0003o`0003H000?o00004000014000?o0000MP06o`0bP920T82@P920T82@P920T82@
P920T82@P920T82@P?n0T82@P920T82@P920T82@P?l<0003o`0003H000?o00004000014000?o0000
M`03ob6@00?oT90049000ol000080003o`0003L000?o00004000018000?o0000M@001?l0oi02o`0d
P920T82@P920T82@P920T82@P920T82@P920T82@P?n0T82@P920T82@P920T82@P920o`T000?o0000
=P000ol0000A00004P000ol0001c00;o0P001On@T93o01j@00?oT9004Y000ol000060003o`0003H0
00?o00004@0001<000?o0000L@000ol00002000joi20T?n@P920T82@P920T82@P920T82@P920T82@
P920T83oP920T82@P920T82@P920T82@P920o`H000?o0000=P000ol0000B00004`000ol0001_00;o
1@000on@T002T0;o79000on@T00DT003o`0000<000?o0000=P000ol0000B00004`000ol0001^0003
o`0000D000OoT82@P92000;o03>@P920T82@P920T82@P920T82@P920T82@oi20T82@P920T82@P920
T82@P920T82@P?l010000ol0000f0003o`000180000D0003o`0006/00_l80003oi2@00J@0_lGT003
oi2@01N@00Go0000o`0800go8P000ol0000C00005@000ol0001Y0003o`0000P0043oT82@P920T82@
P?n0T82@P920T82@P920T82@P920T82@oi20T82@P920T82@P920T82@P920T82@P920o`3o0`06o`a@
0_lP0003o`0001@0000E0003o`0006L00_l;0003oi2@00V@0_lDT003oi2@01V@1OlAD003oe3o0200
00?o0000500001H000?o0000I@000ol0000;000loi20T82@P920T82@P93oT82@P920T82@P920T82@
P920T?n@P920T82@P920T82@P920T82@P920T82@1?lDD003oe3o01l000?o00005@0001H000?o0000
I0000ol0000<0003oi2@00b@00?oT90049000on@T00CT0Co0Y03oa9@00GoD51@o`0N0003o`0001D0
000F0003o`0006<000?o00003@00=_n@P920T82@P920T82@P93oT82@P920T82@P920T82@P93oT82@
P920T82@P920T82@P920T0;o00N0T82@P93o009@00?oD5003e000om@D002D003o`0001/000?o0000
5@0001L000?o0000H002oa0000?oT9003Y02o`n@00?oT9003i02o`R@00GoD51@o`0@D003oe1@009@
00?o00006P000ol0000F000060000ol0001N0003o`000100037oT82@P920T82@P920T82@P920oh2@
P920T82@P920T83oP920T82@P920T82@P92000?o00V0T82@P920T8000_l4D003oe1@00e@00?oD500
0e000ol0000H0003o`0001L0000H0003o`0005`00_lC0003oi2@016@00?oT9002Y000on@T00;T0;o
39000om@D004D003oe1@00]@00?oD5001E000ol0000G0003o`0001L0000I0003o`0005X000?o0000
4`00?_n@P920T82@P920T82@P920T82@P?n0T82@P920T82@P?n0T82@P920T82@P93oT82@P920T82@
P920T83o1e000om@D00:D003oe1@00E@00?o00005P000ol0000H00006P000ol0001H0003o`0001@0
00?oT9004i02o`V@00?oT9002902o`n@00?oD5001U000om@D008D003oe1@00M@00?o000050000ol0
000I00006P000ol0001G0003o`0001D003koT82@P920T82@P920T82@P920T82@P93oT82@P920T83o
P920T82@P920oh2@P920T82@P920T82@P920o`U@00?oD5001e000om@D007D003o`0001@000?o0000
6@0001/000?o0000E@000ol0000F0003oi2@01J@00?oT9001I000on@T006T003oi2@012@00?oD500
25000om@D006D003oe1@00Q@00?o00004P000ol0000J000070000ol0001C0003o`0001L003coT82@
P920T82@P920T82@P920T82@P920T?n@P920T83oP920T82@P?n0T82@P920T82@P920T82@P902o`]@
00?oD5001E000om@D006D0Co4P000ol0000K000070000ol0001B0003o`0001P000?oT9006902o`B@
00?oT9000i02oa>@00?oD5002e000om@D003D003oe1@00A@0ol3D003o`00010000?o00006`0001d0
00?o0000C`02oa/002GoT82@P920T82@P920T82@P920T82@P920T82@P?n0T83oP92000;o01J@P920
T82@P920T82@P920T82@P93o3U000om@D002D003oe1@009@0_l5D003o`00010000?o0000700001d0
00?o0000CP000ol0000K0003oi2@01Z@00GoT92@o`02T003oi2@01F@00?oD5003E001Om@D53o009@
0_l7D003o`00010000?o0000700001h000?o0000C0000ol0000L000moi20T82@P920T82@P920T82@
P920T82@P920T82@oi20oh3oP920T82@P920T82@P920T82@P920T82@o`0@D006oe1@oe3o2E000ol0
000?0003o`0001d0000O0003o`0004/000?o000070000on@T00LT004oi3ooaV@00?oD5003e001Om@
oe3o00U@00?o00003P000ol0000N00007`000ol0001:0003o`0001d0023oT82@P920T82@P920T82@
P920T82@P920T82@P920T0;o01^0T82@P920T82@P920T82@P920T82@P920T?l04U03o`Y@00?o0000
3P000ol0000N000080000ol0001500Ko7P000on@T00BT1Wo3Y000om@D00:D0oo15000ol0000=0003
o`0001l0000Q0003o`0004<000Co003o0`000ol0000K000Aoi20T82@P920T82@P920T8001?l02i20
T82@P920T82@00?o00^@P920T82@P920T003o`0<T82@P920T82@P93o2504o`E@00CoD?oo1U05o`h0
00?o00008000028000?o0000@P03o`D000?o00006P000on@T00;T0?o3Y001On@oi3o00f@1?l7T003
oe1@00A@0_l8D006oe1@oe3o2E000ol0000;0003o`000240000S0003o`0004802?lL000:oi20T82@
P920T0Co01J0T82@P920T82@P920T82@oi20oh2@0_l03h2@P920T82@P920T82@P004o`04T82@o`9@
1?l:D004oe1@o`9@00?oD5001E000ol0000;0003o`000280000S0003o`0004402?l300Ko50000on@
T005T0;o4i001On@T93o00B@00?oT9004902o`04T?m@o`e@00GoD51@o`03D003oe1@00=@00?o0000
30000ol0000R000090000ol0000o0004o`3oo`X00_lF0006oi20T82@0_l0<h2@P920T82@P920T82@
P920T82@oi20T83oP920T?n@P920T82@P920T82@P920T82@P004o`e@00GoD51@o`04D005oe1@D?l0
3P000ol0000S00009@000ol0000m0003o`0000801?l600;o5P001?n@T902oaF@00?oT9000i000on@
T003T003oi2@01:@1?l;D003oe1@009@00?oD5000e001?m@D?l=0003o`0002@0000V0003o`0003/0
00?o00000P02o`800_l500;o5P04o`0fP920T82@P920T82@P920T82@P920T83oP920T83oP920T82@
oi20T82@P920T82@P920T82@0_l01@3o053o00Y@00?oD5000U000om@D004D003oe3o00`000?o0000
9@0002L000?o0000>P001?l00002o`<00_l500;o5P000on@T00GT003oi2@00B@00?oT9001I000on@
T00=T005oi000?l00`02o`M@00?oD50015000om@D003D0;o30000ol0000V0000:0000ol0000h0003
o`0000800_l300;o1@02oaL003WoP920T82@P920T82@P920T82@P920T83oP920T82@P?n0T82@P920
T?n@P920T82@P920T82@P?l00`000ol000030003oe1@00A@00?oD50015001?m@D502o`d000?o0000
9`0002T000?o0000=P000ol000040003o`0000Co1002oaP00_lET003oi2@00F@00?oT9001Y000on@
T00;T003o`00008000?o00001002o`A@00?oD50015001?m@D?l>0003o`0002P0000Z0003o`0003@0
00?o00001P03o`L00_lJ000doi20T82@P920T82@P920T82@P93oT82@P920T83oP920T82@P920oh2@
P920T82@P920o`D000?o00001P02o`03D?m@00I@00?oD?l03P000ol0000Y0000:`000ol0000b0003
o`0001400_lK00;o4I000on@T006T003oi2@00R@00?oT9001i000ol000040003o`0000L000=@ool0
2Ol>0003o`0002X0000/0003o`00030000?o00004P02oa`00320oon@P920T82@P920T82@P?n0T82@
P920T83oP920T82@P920T83oP920T82@P?l80003o`0000P000?oD00050000ol0000[0000;@000ol0
000^0003o`0001<00_lN0003T?n@00^@00?oT90029000on@T00:T003oi2@00B@00?o00001P000ol0
000N0003o`0002`0000^0003o`0002`000?o00004P04ob0002_oT82@P920T82@P93oT82@P920T82@
P93oT82@P920T82@P93oT82@P93o00T000?o00007@000ol0000]0000;`000ol0000[0003o`0001@0
0_lQ0003oi2@00N@00?oT9002Y000on@T00:T005oi2@T?l02P000ol0000L0003o`0002h0000`0003
o`0002T000?o0000>000:93oT82@P920T83oP920T82@P920T82@oi20T82@P920T82@P93oT?l<0003
o`0001X000?o0000;`00034000?o00009`000ol0000j0003T?n@00F@00?oT9002i000on@T00<T0;o
30000ol0000I0003o`000300000b0003o`0002H000?o0000?0008On@P920T?n@P920T82@P920T82@
oi20T82@P920T82@P004o``000?o000060000ol0000a0000<`02obD000?o0000?P001On@T93o00j@
00?oT9001Y04oa0000?o00005`000ol0000b0000=@000ol0000Q0003o`0003l001Z@oi20oh2@P920
T82@P920T82@oi20T82@P0;o5@000ol0000E0003o`0003<0000f0003o`00020000?o0000@0000i3o
o`0?T003oi2@00:@0_lG0003o`0001@000?o0000=00003L000?o00007P000ol0001300go00V@P920
oh2@oi0060000ol0000B00;o=`0003P000?o000070000ol0001@0003T?oo00Go6`000ol0000@0003
o`0003L0000i0003o`0001/000?o0000E@000ol0000K0003o`0000l000?o0000>00003X000?o0000
6@000ol0001e0003o`0000d000?o0000>@0003/00_lH0003o`0007H000?o00002`02oc`0000m0003
o`0001D000?o0000M`000ol000090003o`0003`0000n00;o50000ol0001h0003o`0000L00_lo0000
@0000ol0000@0003o`0007X000?o00001@000ol0000o0000@@02oa0000?o0000NP000ol0000300;o
@P0004<00_l=0003o`0007`000?o00000_m40000A@000ol0000:0003o`0007`000?o0?l0AP0004H0
0_l:0003o`0007`00_m70000B0000ol000060003o`0007`000?o0000A`0004T00_l50003o`0007/0
0_m:0000B`001Ol0003o07d000?o0000BP0004`01?mk00;oC@0004h00omg00?oC`00054000?o0000
L`000ol0001@0000DP03og000_mC0000E@000ol0001[00;oE@0005H01?mU00CoE`0005X000?o0000
H@000ol0001I0000F`03oed00omL0000GP03oeL00omO0000H@04odl01?mR0000I@03odT00omV0000
J003od<00omY0000J`05ocT01Om/0000L005obl01Oma0000M@05obD01Omf0000NP0:oa402_mk0000
Q00AohD0003o01/0003o01/0003o01/0003o01/0003o01/0003o01/00000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-1.05001, -1.05001, 0.00747339, 
  0.00747339}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Inversion of polygon accross the edges"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
poly8 = N[RegularPolygon[8,Pi/2]];
invpolys = HypInvertPolygon[poly8];\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{invpolys, RGBColor[0.6,0.1,0.1], 
\tpoly8 /. Polygon -> FilledPolygon}]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
.71671 1.02318 .30647 225 270 arc
s
newpath
1.02318 .71671 .30647 154.471 180 arc
s
newpath
.76929 .89624 .05258 180 244.471 arc
s
newpath
.71671 .925 .02876 195.722 270 arc
s
newpath
.68247 .94051 .02421 209.278 285.722 arc
s
newpath
.64728 .95375 .02876 225 299.278 arc
s
newpath
.58976 .9706 .05258 250.529 315 arc
s
newpath
.28329 1.02318 .30647 315 340.529 arc
s
newpath
1.02318 .71671 .30647 180 225 arc
s
newpath
1.02318 .28329 .30647 109.471 135 arc
s
newpath
.9706 .58976 .05258 135 199.471 arc
s
newpath
.95375 .64728 .02876 150.722 225 arc
s
newpath
.94051 .68247 .02421 164.278 240.722 arc
s
newpath
.925 .71671 .02876 180 254.278 arc
s
newpath
.89624 .76929 .05258 -154.471 -90 arc
s
newpath
.71671 1.02318 .30647 270 295.529 arc
s
newpath
1.02318 .28329 .30647 135 180 arc
s
newpath
.71671 -0.02318 .30647 64.4712 90 arc
s
newpath
.89624 .23071 .05258 90 154.471 arc
s
newpath
.925 .28329 .02876 105.722 180 arc
s
newpath
.94051 .31753 .02421 119.278 195.722 arc
s
newpath
.95375 .35272 .02876 135 209.278 arc
s
newpath
.9706 .41024 .05258 160.529 225 arc
s
newpath
1.02318 .71671 .30647 225 250.529 arc
s
newpath
.71671 -0.02318 .30647 90 135 arc
s
newpath
.28329 -0.02318 .30647 19.4712 45 arc
s
newpath
.58976 .0294 .05258 45 109.471 arc
s
newpath
.64728 .04625 .02876 60.7224 135 arc
s
newpath
.68247 .05949 .02421 74.2776 150.722 arc
s
newpath
.71671 .075 .02876 90 164.278 arc
s
newpath
.76929 .10376 .05258 115.529 180 arc
s
newpath
1.02318 .28329 .30647 180 205.529 arc
s
newpath
.28329 -0.02318 .30647 45 90 arc
s
newpath
-0.02318 .28329 .30647 -25.5288 0 arc
s
newpath
.23071 .10376 .05258 0 64.4712 arc
s
newpath
.28329 .075 .02876 15.7224 90 arc
s
newpath
.31753 .05949 .02421 29.2776 105.722 arc
s
newpath
.35272 .04625 .02876 45 119.278 arc
s
newpath
.41024 .0294 .05258 70.5288 135 arc
s
newpath
.71671 -0.02318 .30647 135 160.529 arc
s
newpath
-0.02318 .28329 .30647 0 45 arc
s
newpath
-0.02318 .71671 .30647 289.471 315 arc
s
newpath
.0294 .41024 .05258 -45 19.4712 arc
s
newpath
.04625 .35272 .02876 -29.2776 45 arc
s
newpath
.05949 .31753 .02421 -15.7224 60.7224 arc
s
newpath
.075 .28329 .02876 0 74.2776 arc
s
newpath
.10376 .23071 .05258 25.5288 90 arc
s
newpath
.28329 -0.02318 .30647 90 115.529 arc
s
newpath
-0.02318 .71671 .30647 -45 0 arc
s
newpath
.28329 1.02318 .30647 244.471 270 arc
s
newpath
.10376 .76929 .05258 270 334.471 arc
s
newpath
.075 .71671 .02876 285.722 360 arc
s
newpath
.05949 .68247 .02421 -60.7224 15.7224 arc
s
newpath
.04625 .64728 .02876 -45 29.2776 arc
s
newpath
.0294 .58976 .05258 -19.4712 45 arc
s
newpath
-0.02318 .28329 .30647 45 70.5288 arc
s
newpath
.28329 1.02318 .30647 270 315 arc
s
newpath
.71671 1.02318 .30647 199.471 225 arc
s
newpath
.41024 .9706 .05258 225 289.471 arc
s
newpath
.35272 .95375 .02876 240.722 315 arc
s
newpath
.31753 .94051 .02421 254.278 330.722 arc
s
newpath
.28329 .925 .02876 270 344.278 arc
s
newpath
.23071 .89624 .05258 295.529 360 arc
s
newpath
-0.02318 .71671 .30647 0 25.5288 arc
s
.6 .1 .1 r
.5 .80647 m
.51348 .79378 L
.5277 .78193 L
.54261 .77096 L
.55816 .76091 L
.57428 .75181 L
.59093 .74371 L
.60803 .73663 L
.62553 .73059 L
.64337 .72562 L
.66147 .72173 L
.67977 .71894 L
.69821 .71727 L
.71671 .71671 L
.71671 .71671 L
.71727 .69821 L
.71894 .67977 L
.72173 .66147 L
.72562 .64337 L
.73059 .62553 L
.73663 .60803 L
.74371 .59093 L
.75181 .57428 L
.76091 .55816 L
.77096 .54261 L
.78193 .5277 L
.79378 .51348 L
.80647 .5 L
.80647 .5 L
.79378 .48652 L
.78193 .4723 L
.77096 .45739 L
.76091 .44184 L
.75181 .42572 L
.74371 .40907 L
.73663 .39197 L
.73059 .37447 L
.72562 .35663 L
.72173 .33853 L
.71894 .32023 L
.71727 .30179 L
.71671 .28329 L
.71671 .28329 L
.69821 .28273 L
.67977 .28106 L
.66147 .27827 L
.64337 .27438 L
.62553 .26941 L
.60803 .26337 L
.59093 .25629 L
.57428 .24819 L
.55816 .23909 L
.54261 .22904 L
.5277 .21807 L
.51348 .20622 L
.5 .19353 L
.5 .19353 L
.48652 .20622 L
.4723 .21807 L
.45739 .22904 L
.44184 .23909 L
.42572 .24819 L
.40907 .25629 L
.39197 .26337 L
.37447 .26941 L
.35663 .27438 L
.33853 .27827 L
.32023 .28106 L
.30179 .28273 L
.28329 .28329 L
.28329 .28329 L
.28273 .30179 L
.28106 .32023 L
.27827 .33853 L
.27438 .35663 L
.26941 .37447 L
.26337 .39197 L
.25629 .40907 L
.24819 .42572 L
.23909 .44184 L
.22904 .45739 L
.21807 .4723 L
.20622 .48652 L
.19353 .5 L
.19353 .5 L
.20622 .51348 L
.21807 .5277 L
.22904 .54261 L
.23909 .55816 L
.24819 .57428 L
.25629 .59093 L
.26337 .60803 L
.26941 .62553 L
.27438 .64337 L
.27827 .66147 L
.28106 .67977 L
.28273 .69821 L
.28329 .71671 L
.28329 .71671 L
.30179 .71727 L
.32023 .71894 L
.33853 .72173 L
.35663 .72562 L
.37447 .73059 L
.39197 .73663 L
.40907 .74371 L
.42572 .75181 L
.44184 .76091 L
.45739 .77096 L
.4723 .78193 L
.48652 .79378 L
.5 .80647 L
F
0 g
newpath
.71671 1.02318 .30647 225 270 arc
s
newpath
1.02318 .71671 .30647 180 225 arc
s
newpath
1.02318 .28329 .30647 135 180 arc
s
newpath
.71671 -0.02318 .30647 90 135 arc
s
newpath
.28329 -0.02318 .30647 45 90 arc
s
newpath
-0.02318 .28329 .30647 0 45 arc
s
newpath
-0.02318 .71671 .30647 -45 0 arc
s
newpath
.28329 1.02318 .30647 270 315 arc
s
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l06`000?l06`000?l06`000?l06`000?l0
6`000?l06`000?l06`0008<04on40000N@0:oa<02_mj0000M005obL01Ome0000K`05oc401Om`0000
JP05oc/01Om[0000I`03odD00omX0000I003od/00omU0000H@03oe400omR0000GP03oeL00omO0000
F`03oed00omL0000F@02of<00_mJ0000EP03ofL00omG0000E002oa8000?o0000A@000ol0000@00?o
E00005400olC0003o`3o04D000?o0?l05002oe80001@0003o`0000/01_l00`3oo`0300;o@@02o`<0
0_l200Go3@000ol0001?0000CP02o`d000?o000010000ol0000500;o?@02o`L00_l50003o`0000/0
0om>0000B`03o`h000?o00003`06o`030?oo00;o9`04o`030?oo00Co4@000ol0000=00;oC00004X0
00?o00002P05oaP000Go0000o`0W0005o`000?l06005o``000?o0000B@0004P00_l=0003o`0001l0
00?o00008`000ol0000O0003o`0000/00_m90000A`000ol0000<0003o`00020000?o00008`000ol0
000P0003o`0000`000?o0000AP0004D00_l>0003o`00024000?o00008`000ol0000Q0003o`0000`0
0_m60000A0000ol0000<00;o90000ol0000S0003o`0002800_l>0003o`0004<0001200;o3@02obL0
00?o00008@000ol0000U00?o3002od<0001000;o3@02obT000?o00008@000ol0000X0003o`0000/0
0_m10000?`000ol0000=0003o`0002T000?o00007`000ol0000Y0003o`0000d000?o0000?P0003d0
0_l@0003o`0002T000?o00007`000ol0000Y0003o`0000h00_ln0000?0000ol0000@0003o`0002T0
00?o00007`000ol0000Y0003o`00010000?o0000>`0003/000?o00004@000ol0000Z0003o`0001d0
00?o0000:P000ol0000A0003o`0003X0000j0003o`00018000?o0000:`000ol0000K0003o`0002/0
00?o00004P000ol0000i0000>002oa@000?o0000;@000ol0000I0003o`0002d000?o00004P000ol0
000h0000=`000ol0000D0003o`0002d000?o00006@000ol0000]0003o`0001<000?o0000=`0003H0
00?o000050000ol0000_0003o`0001L000?o0000;`000ol0000C0003o`0003H0000e0003o`0001@0
00?o0000<0000ol0000G0003o`00030000?o00004`02ocH0000d0003o`0001@000?o0000<P000ol0
000E0003o`00038000?o000050000ol0000c0000<`000ol0000D0003o`0003<000?o00005@000ol0
000c0003o`0001@000?o0000<P00038000?o00004`02ocL000?o00004`000ol0000e00;o5@000ol0
000a0000<@000ol0000C0003o`0003P000?o00004@000ol0000h0003o`0001<000?o0000<0000300
00?o000050000ol0000i0003o`0000l000?o0000>@000ol0000D0003o`0002l0000_0003o`0001H0
00?o0000>0000ol0000?0003o`0003P000?o00005P000ol0000^0000;P000ol0000G0003o`0003T0
00?o00003@000ol0000i0003o`0001L000?o0000;@0002d000?o00006@000ol0000i0003o`0000/0
00?o0000>@000ol0000I0003o`0002`0000/0003o`0001X000?o0000>P000ol000090003o`0003X0
00?o00006P000ol0000[0000:`000ol0000L0003o`0003T000?o00002@000ol0000i0003o`0001`0
00?o0000:P0002X000?o00007@000ol0000j00;o1`02oc`000?o00007@000ol0000Y0000:@000ol0
000N0003o`0003`000?o00000`000ol0000l0003o`0001h000?o0000:00002P000?o00007`000ol0
000l0003o`0000<000?o0000?0000ol0000O0003o`0002L0000X0003o`0001l000?o0000?@001Ol0
003o03l000?o000080000ol0000V00009`000ol0000Q0003o`0003d000?o0?l0?`000ol0000R0003
o`0002D0000V0003o`00028000?o0000?@03ocl000?o00008`000ol0000T00009@000ol0000T0003
o`0003/000GoFMQIo`0m0003o`0002@000?o0000900002@000?o00009@000ol0000k0005omQIf?l0
?@000ol0000U0003o`0002<0000S0003o`0002H000?o0000>@02o`05f5WHFMP00_lk0003o`0002H0
00?o00008P00028000?o00009`000ol0000h000;oeWHFMQIf5WHFOl0>P000ol0000W0003o`000240
000Q0003o`0002P000?o0000>0002ooHFMQIf5WHFMSo03X000?o0000:0000ol0000P00008@000ol0
000Y0003o`0003D00_l02mQIf5WHFMQIf5WH00;o=`000ol0000Y0003o`000200000P0003o`0002X0
00?o0000<`02o`0?FMQIf5WHFMQIf5WHFMQI00;o=@000ol0000Z0003o`0001l0000O0003o`0002/0
00?o0000<P005OoHFMQIf5WHFMQIf5WHFMQIf5WHo`0d0003o`0002/000?o00007P0001l000?o0000
:`000ol0000a000GomQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0<`000ol0000[0003o`0001h0000N0003
o`0002d000?o0000;`006OoHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0<@000ol0000]0003o`0001d0
000M0003o`0002h000?o0000;@02o`0If5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf002obl000?o0000
;P000ol0000L00007@000ol0000^0003o`0002/00_l07EWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQI00;o;@000ol0000^0003o`0001`0000L0003o`0002l000?o0000:P008ol0FMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHF@3o02`000?o0000;`000ol0000K000070000ol0000_0003o`0002P0
0_l08mQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH00;o:P000ol0000_0003o`0001/0
000K0003o`00034000?o00009@02o`0WFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQI00;o9`000ol0000a0003o`0001X0000J0003o`00038000?o00008`02o`0[f5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf002obD000?o0000<P000ol0000I00006P000ol0
000=00;o8`000ol0000Q00;o02mIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHF@02ob<000?o00008@02o`l000?o00006@0001T000?o00003P001?l0oolQ0003o`0001l0
0_l0<mQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf002ob40
00?o00007`02o`030?l000l000?o0000600001P000?o00003P000ol0000200?o7P000ol0000K00Co
03MIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI00Co
7@000ol0000M00;o10000ol0000>0003o`0001L0000H0003o`0000d000?o00001P04oaX000?o0000
6@02o`8003_HFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf00200;o6`000ol0000H00Go1`000ol0000=0003o`0001L0000G0003o`0000d000?o0000
2`02oaP000?o00005@04o`130=QIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHF@04oaL000?o00005P02o`d000?o00003@000ol0000F0000
5P000ol0000=0003o`0000h01OlC0003o`0001<00_l0B`1If5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI0002oaD000?o0000
4@05oa0000?o00003@000ol0000E00005P000ol0000;00;o5P05o`h000?o00003@06o`1?FMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHF@06o`l000?o00003@04oaH00_l=0003o`0001D0000E0003o`0000X00_lM00Go
2@000ol0000700Ko0`00EUWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH0P06o`T000?o00002005oa`0
0_l<0003o`0001@0000E0003o`0000D01OlT01?o06MIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQI01Co8`05o`L000?o0000500001D000?o00001@000ol0000_001koeWHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo0340
00?o00001@000ol0000D000050000ol000050003o`00030007_of5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0<P000ol000050003o`0001<0
000C0003o`0000H000?o0000<000NomIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0b0003o`0000H000?o00004P0001<000?o00001P000ol0
000`001komQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMSo038000?o00001P000ol0000B00004`000ol000050003o`00034007_oFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0<`000ol0
00060003o`000140000B0003o`0000D000?o0000<P00NooHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0d0003o`0000D000?o00004@000140
00?o00001002ocD007_oFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFOl0=@02o`D000?o00004@00014000?o00000`000ol0000e001komQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo03L0
00?o00000`000ol0000@00004@000ol000030003o`0003@007aIoeWHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo=`000ol000030003o`000100
000A0003o`0000<000?o0000=000O=Sof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?lg0003o`0000<000?o00004000010000?o000010000ol0
000d001momQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf?l0=P000ol000040003o`0000l0000?0003o`0000D000?o0000=000OOmIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo03H0
00?o00001@000ol0000>00003`000ol000040003o`0003D007gof5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0g0003o`0000@000?o0000
3P0000l000?o00000`000ol0000f001moeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0>0000ol000030003o`0000h0000>0003o`0000@0
00?o0000=P00OOoHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMSo03P000?o000010000ol0000=00003P000ol000030003o`0003L007goFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
o`0i0003o`0000<000?o00003@0000h000?o00000`000ol0000f001ooeWHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMP0o`0h0003o`0000<0
00?o00003@0000d000?o000010000ol0000f001oomQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5T0o`0h0003o`0000@000?o0000300000d0
00?o000010000ol0000f001ooeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0h0003o`0000@000?o0000300000d000?o00001@000ol0
000e001oomQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHo`0g0003o`0000D000?o0000300000d000?o00001@000ol0000e001ooeWHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
o`0g0003o`0000D000?o0000300000`000?o00001P000ol0000e001oomQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0g0003o`0000H0
00?o00002`0000`000?o00001@000ol0000e0021omQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo03L000?o00001@000ol0000;0000
30000ol000040003o`0003H0087oFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0>0000ol000040003o`0000/0000;0003o`0000@0
00?o0000=P00PomIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf03o03P000?o000010000ol0000:00002`000ol000050003o`0003D0
08?of5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHo`0g0003o`0000D000?o00002P0000/000?o00001P000ol0000d0023oeWHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFOl0=P000ol000060003o`0000X0000:0003o`0000L000?o0000=000PooHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo03H0
00?o00001`000ol0000900002P000ol000080003o`00038008Gof5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo03@000?o0000
20000ol0000900002P000ol000080003o`00038008GoFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo03@000?o000020000ol0
000900002P000ol000090003o`00030008OoFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH0?l0<P000ol000090003o`0000T0
000:0003o`0000T000?o0000<000QooHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5T0o`0b0003o`0000T000?o00002@0000T0
00?o00002P000ol0000`0027oeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo038000?o00002P000ol0000800002@000ol0
000:0003o`00030008Oof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0<P000ol0000:0003o`0000P000090003o`0000X0
00?o0000;`00ROoHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo034000?o00002P000ol0000800002@000ol0000:0003
o`0002l008WoFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0a0003o`0000X000?o0000200000T000?o00002`000ol0
000]002;oeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0_0003o`0000/000?o0000200000P000?o000030000ol0
000]002;omQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0_0003o`0000`000?o00001`0000P000?o00002`000ol0
000]002=omQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo02l000?o00002`000ol00007000020000ol0000;0003
o`0002d008goFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0;`000ol0000;0003o`0000L000080003o`0000/0
0_l]002?oeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0;@02o`d000?o00001`0000P000?o00003@04obT0
08oof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0Y00Co3`000ol0000700001`000ol0000B00?o9@00TOoH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l09P02oa@000?o00001P0000L000?o00005@02ob8009?of5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQI0?l08P03oaH000?o00001P0000L000?o00005`000ol0000O002C
oeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo024000?o00005`000ol0000600001`000ol0000H0003
o`0001d009GoFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMP0o`0O0003o`0001P000?o00001P0000L0
00?o00006@02oad009Gof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0M00;o6`000ol000060000
1`000ol0000K00;o6P00UooHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l06P02oad000?o0000
1P0000L000?o00007@02oaL009Wof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l05`02oal0
00?o00001P0000L000?o00007`000ol0000C002KomQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQI0?l05@000ol0000O0003o`0000H000070003o`00020000?o00004@00WOl0FMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQI0?l04`000ol0000P0003o`0000H000070003o`0002400_lA002M
oeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0A00;o8`000ol0000600001P000ol0
000T0003o`0000d009ooFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl03`000ol0
000T0003o`0000D000060003o`0002D000?o00003000WooHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHo`0>0003o`0002D000?o00001@0000H000?o00009P02o`X00_l0WmQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf002o`X00_lX0003o`0000D000060003o`0002P0
00?o00001P00YOmIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`080003
o`0002P000?o00001@0000H000?o0000:0000ol00006002UomQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMSo00P000?o0000:0000ol0000500001P000ol0000Y00;o1002o`2U
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH00;o1002ob/000?o0000
1@0000H000?o0000:`00[_l00?l0f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMP0o`8000?o0000:`000ol0000500001P000ol0000/002_o`3of5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0o`0^0003o`0000D000060003o`0002d0
0:gof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0_0003
o`0000D000060003o`0002`00_l0ZeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHF@02obh000?o00001@0000H000?o0000:P02o`800_l0YmQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH00;o0P02ob`000?o00001@0000H000?o0000
:@000ol00003002Yf?oHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo
f0050003o`0002T000?o00001@0000H000?o0000:@000ol00004002WoeWHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl01P000ol0000Y0003o`0000D000060003o`0002L0
0_l800;o0:7HFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf002o`P00_lY0003
o`0000D000060003o`0002H000?o00002@00XmSof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHomP02`000ol0000V0003o`0000D000060003o`0002D000?o00002`00XOmIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo00d000?o00009@000ol0000500001P000ol0
000S00;o3`00WomIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0?00;o9@000ol0
000500001P000ol0000R0003o`0000l009oof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf?l04@000ol0000R0003o`0000D000070003o`00020000?o00004@00WOoHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l04`000ol0000P0003o`0000H000070003o`0001h00_lE002K
omQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l05@02ob0000?o00001P0000L000?o0000
7002oaP009Wof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l06002oah000?o00001P0000L0
00?o00006P02oaX009SHomQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHoa/00_lL0003o`0000H0
00070003o`0001T000?o00006`00UomIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl07@000ol0
000I0003o`0000H000070003o`0001P000?o00007@00UOmIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5Wo01l000?o000060000ol0000600001`000ol0000F00;o8000UOoHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMSo02000_lH0003o`0000H000070003o`0001@00_lS002ComQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMSo02<00olE0003o`0000H000070003o`0001400olV002AomQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHo`0W00;o4`000ol0000600001`000ol0000=00Co:@00TOmIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFOl0:@04o`l000?o00001P0000P000?o00002`000ol0000[002@FOmIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5Wo;P000ol0000;0003o`0000L000080003o`0000/000?o0000;000SooHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMSo02h000?o00002`000ol00007000020000ol0000;0003o`0002`008kHomQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMSo;`000ol0000;0003o`0000L000080003o`0000/000?o0000;@00SOmIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIo`0_0003o`0000/000?o00001`0000P000?o000030000ol0000]002;oeWHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIo`0_0003o`0000`000?o00001`0000T000?o00002`000ol0000]002;omQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHo`0_0003o`0000/000?o0000200000T000?o00002P000ol0000_0029omQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf?l0<@000ol0000:0003o`0000P000090003o`0000X000?o0000;`00ROmIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5Wo034000?o00002P000ol0000800002@000ol0000:0003o`00030008OoFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFOl0<P000ol0000:0003o`0000P000090003o`0000X000?o0000<000QooHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
o`0b0003o`0000X000?o0000200000X000?o00002@000ol0000`0027oeWHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo0380
00?o00002@000ol0000900002P000ol000090003o`00030008Oof5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI0?l0<P000ol0
00090003o`0000T0000:0003o`0000P000?o0000<P00QOoHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0=0000ol000080003
o`0000T0000:0003o`0000P000?o0000<P00QOmIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0=0000ol000080003o`0000T0
000:0003o`0000L000?o0000=000PomIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo03H000?o00001`000ol0000900002`000ol0
00050003o`0003D008?of5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0g0003o`0000D000?o00002P0000/000?o000010000ol0
000f0023oeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFOl0>0000ol000040003o`0000X0000;0003o`0000D000?o0000=@00PooH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMSo03L000?o00001@000ol0000:000030000ol000050003o`0003D0087of5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0
=`000ol000050003o`0000/0000<0003o`0000D000?o0000=@00POmIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0g0003o`0000D0
00?o00002`0000`000?o00001P000ol0000e001ooeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIo`0g0003o`0000H000?o00002`0000d0
00?o00001@000ol0000e001oomQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0g0003o`0000D000?o0000300000d000?o000010000ol0
000f001ooeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIo`0h0003o`0000@000?o0000300000d000?o000010000ol0000f001oomQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
o`0h0003o`0000@000?o0000300000h000?o00000`000ol0000f001ooeWHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMP0o`0h0003o`0000<0
00?o00003@0000h000?o00000`000ol0000f001oomQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5T0o`0h0003o`0000<000?o00003@0000h0
00?o00000`000ol0000g001momQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0>@000ol000030003o`0000d0000?0003o`0000<000?o0000
=P00OOmIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5Wo03P000?o00000`000ol0000>00003`000ol000040003o`0003D007gof5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0g0003
o`0000@000?o00003P0000l000?o00001@000ol0000d001moeWHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0=P000ol000050003o`0000h0
000@0003o`0000@000?o0000=000OOoHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo03H000?o000010000ol0000?000040000ol000040003
o`0003@007goFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIo`0f0003o`0000@000?o00003`00014000?o00000`000ol0000d001lFOmIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIocL0
00?o00000`000ol0000@00004@000ol0000300;o=@00O=Sof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?lf00;o1@000ol0000@00004@000ol0
00050003o`0003<007_oFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFOl0=@000ol000050003o`000100000B0003o`0000D000?o0000<P00NooH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
o`0d0003o`0000D000?o00004@00018000?o00001P000ol0000a001koeWHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5Wo03<000?o00001P000ol0
000A00004`000ol000050003o`00034007_of5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?l0<`000ol000050003o`000180000C0003o`0000H0
00?o0000<000NomIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIo`0b0003o`0000H000?o00004P0001<000?o00001P000ol0000`001komQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo0380
00?o00001P000ol0000B000050000ol000060003o`0002l007_oFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFOl0<@000ol000060003o`0001<0
000E0003o`0000D01_lR01Go06GHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f00Fob401_l70003o`0001@0000E0003o`0000/00_lK00Go2P000ol000060003FMSo00Go05UIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHF@06o`03f5WH00L000?o00002@05oaX00_l=0003o`0001@0
000F0003o`0000`000?o00004`05o`l000?o00003P06o`1=f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMP01_l@0003
o`0000h01?lE0003o`0000`000?o00005@0001H000?o00003@000ol0000=00Go50000ol0000D00;o
04UIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQI00;o5P000ol0000B00Go3`000ol0000=0003o`0001D0000F0003o`0000h0
00?o00002P02oaT000?o00005P04o`11f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMP01?lH0003o`0001L00_l<0003o`0000h000?o0000
5@0001L000?o00003P000ol0000500Co6`000ol0000J00;o03eIf5WHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI00;o70000ol0000I00Go1P000ol0
000>0003o`0001H0000H0003o`0000h000Co00000olO0003o`0001`01?l0=MQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WH00Co7P000ol0000N00;o0`000ol0
000>0003o`0001L0000H0003o`0000h000Co0?oo8P000ol0000P00;o035If5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI00;o8P000ol0000P00;o00<0o`003`000ol0
000G00006@000ol0000>0003o`00028000?o00008P02o`0]f5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMQIf5WHFMQIf5WH00;o90000ol0000R0003o`0000h000?o0000600001X000?o0000
<P000ol0000T00;o02UIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHF@02obH0
00?o0000<P000ol0000I00006P000ol0000b0003o`0002D002QIoooHFMQIf5WHFMQIf5WHFMQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WH0_l00eT0000U0003o`00038000?o00006@0001/000?o0000<0000ol0
000X000Wf?oHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf?oH02X000?o0000<0000ol0
000J000070000ol0000_0003o`0002X00_l07eWHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5WHFMQIf5T0
0_l/0003o`0002l000?o00006`0001`000?o0000;`000ol0000/00;o01_HFMQIf5WHFMQIf5WHFMQI
f5WHFMQIf5WHFMP00_l^0003o`0002l000?o00006`0001d000?o0000;P000ol0000^000KomQIf5WH
FMQIf5WHFMQIf5WHFMQIf5WHFMSo030000?o0000;P000ol0000L00007@000ol0000^0003o`0002l0
01Wof5WHFMQIf5WHFMQIf5WHFMQIf5WHFMSo034000?o0000;P000ol0000L00007P000ol0000/0003
o`00034001Oof5WHFMQIf5WHFMQIf5WHFMQIf5WHo`0c0003o`0002`000?o00007@0001l000?o0000
:`000ol0000b00;o015If5WHFMQIf5WHFMQIf5WHF@02oc@000?o0000:`000ol0000N00007`000ol0
000[0003o`0003@00_l03MQIf5WHFMQIf5WHFMP00_lf0003o`0002/000?o00007P00020000?o0000
:P000ol0000e000?f?oHFMQIf5WHFMQIf?oH03L000?o0000:P000ol0000O00008@000ol0000Y0003
o`0003H000goFMQIf5WHFMQIf5Wo03P000?o0000:@000ol0000P00008P000ol0000W0003o`0003P0
0_l01mQIf5WHFMP00_lj0003o`0002L000?o00008@0002<000?o00009P000ol0000i0009f?oHFMQI
f?oH03/000?o00009P000ol0000R00008`000ol0000V0003o`0003X000OoFMQIf5Wo03`000?o0000
9P000ol0000R000090000ol0000U0003o`0003/00_l00mSoo`0m0003o`0002D000?o00008`0002D0
00?o000090000ol0000m0003o`0003d000?o000090000ol0000T00009P000ol0000R0003o`0003d0
00?o0?l0?`000ol0000R0003o`0002D0000W0003o`00024000?o0000?0001Ol0003o03h000?o0000
8@000ol0000V0000:0000ol0000O0003o`0003d000Go0000o`0o0003o`0001l000?o00009`0002T0
00?o00007P000ol0000k00;o1@02ocd000?o00007P000ol0000X0000:P000ol0000M0003o`0003X0
00?o00001`000ol0000j0003o`0001d000?o0000:@0002/000?o000070000ol0000j0003o`0000L0
00?o0000>P000ol0000L0003o`0002X0000/0003o`0001X000?o0000>P000ol000090003o`0003X0
00?o00006P000ol0000[0000;@000ol0000I0003o`0003T000?o00002`000ol0000i0003o`0001T0
00?o0000;00002h000?o000060000ol0000h0003o`0000d000?o0000>0000ol0000H0003o`0002d0
000_0003o`0001H000?o0000>@000ol0000=0003o`0003T000?o00005P000ol0000^0000<0000ol0
000E0003o`0003P000?o00003`000ol0000h0003o`0001D000?o0000;`00034000?o00004`02ocT0
00?o00004@000ol0000g00;o5@000ol0000`0000<P000ol0000D0003o`0003D000?o00004`000ol0
000e0003o`0001@000?o0000<@0003<00_lE0003o`0003@000?o00004`000ol0000d0003o`0001@0
00?o0000<P0003D000?o00004`000ol0000b0003o`0001D000?o0000<P000ol0000D0003o`0003<0
000f0003o`0001<000?o0000<@000ol0000E0003o`00034000?o000050000ol0000d0000=`000ol0
000C0003o`0002l000?o00005`000ol0000_0003o`0001<00_lg0000>0000ol0000B0003o`0002l0
00?o00005`000ol0000_0003o`00018000?o0000=`0003T000?o00004P000ol0000]0003o`0001T0
00?o0000;@000ol0000B0003o`0003P0000j0003o`00014000?o0000;0000ol0000K0003o`0002`0
00?o00004@000ol0000i0000>`02oa8000?o0000:P000ol0000M0003o`0002X000?o00004002oc`0
000m0003o`0000l000?o0000:P000ol0000M0003o`0002X000?o00003`000ol0000l0000?P02o`l0
00?o0000:@000ol0000O0003o`0002T000?o00003@02ocl000100003o`0000`000?o0000:@000ol0
000O0003o`0002T000?o000030000ol0000o0000@@02o``00olX0003o`00024000?o00009`02o``0
0_m20000@`02o`d00_lV0003o`00024000?o00009003o``00_m40000A@000ol0000<0003o`0002<0
00?o00008@000ol0000S0003o`0000`000?o0000A00004H00_l=0003o`00024000?o00008`000ol0
000Q0003o`0000/00_m70000B0000ol0000;0003o`00020000?o00008`000ol0000P0003o`0000/0
00?o0000A`0004T00_l;0003o`00020000?o00008`000ol0000P0003o`0000T00_m:0000B`000ol0
000900Go5`03o`<000?o00008`001?l00003oaL01Ol;0003o`0004X0001<00?o3@000ol0000>00Ko
0`03obL00ol300Ko40000ol0000<00;oC@0004l00_l<00;o1003o`D00_lo00;o1@04o`<00_l<00?o
C`00054000?o00002`04o`<000Go0000o`130005o`000?l01003o`d000?o0000D00005800olB0003
o`3o04D000?o0?l04`02oe<0001E0003o`00010000?o0000A@000ol0000@00;oE@0005H01?mU00Co
E`0005X000?o0000H@000ol0001I0000F`03oed00omL0000GP03oeL00omO0000H@04odl01?mR0000
I@03odT00omV0000J003od<00omY0000J`05ocT01Om/0000L005obl01Oma0000M@05obD01Omf0000
NP0:oa402_mk0000Q00AohD0003o01/0003o01/0003o01/0003o01/0003o01/0003o01/00000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-1.05001, -1.05001, 0.00747339, 
  0.00747339}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["A triangle tessellation", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
tri = NGP[TriangleFromAngles[Pi/3, Pi/4, Pi/4]] /.
\tPolygon -> FilledPolygon;\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["gp = TriangleGroup[3,4,4,7]; Length[gp]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(187\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
HDraw[{color3, Thickness[0.002], 
\tgp /. Polygon -> FilledPolygon, 
\tcolor2, tri}]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.95 g
.06385 .54444 m
.06513 .53981 L
.06589 .53506 L
.06612 .53026 L
.06581 .52547 L
.06498 .52074 L
.06362 .51612 L
.06176 .51169 L
.05943 .50749 L
.05664 .50358 L
.05344 .5 L
.05344 .5 L
.11119 .5 L
.11119 .5 L
.10806 .5051 L
.10466 .51003 L
.10101 .51477 L
.0971 .51931 L
.09296 .52364 L
.08859 .52774 L
.08402 .5316 L
.07924 .53521 L
.07428 .53856 L
.06914 .54164 L
.06385 .54444 L
F
0 g
.002 w
[ ] 0 setdash
newpath
.01399 .44388 .11224 30 63.6264 arc
s
.11119 .5 m
.05344 .5 L
s
newpath
.02283 .53061 .04329 -45 18.6264 arc
s
.95 g
.1196 .59412 m
.1146 .59241 L
.10954 .59086 L
.10444 .58946 L
.0993 .58823 L
.09413 .58716 L
.08892 .58625 L
.08368 .58551 L
.07843 .58493 L
.07316 .58451 L
.06788 .58426 L
.06259 .58418 L
.06259 .58418 L
.06448 .5805 L
.066 .57665 L
.06714 .57267 L
.06787 .56859 L
.06821 .56447 L
.06814 .56033 L
.06766 .55622 L
.06678 .55217 L
.0655 .54823 L
.06385 .54444 L
.06385 .54444 L
.07037 .54691 L
.0767 .54984 L
.08279 .55324 L
.08862 .55707 L
.09415 .56132 L
.09936 .56596 L
.10421 .57097 L
.10868 .57632 L
.11275 .58198 L
.1164 .58793 L
.1196 .59412 L
F
0 g
newpath
.03343 .63469 .09524 288.626 334.792 arc
s
newpath
.02614 .56313 .04209 -26.3736 30 arc
s
newpath
.06259 .75254 .16836 270 289.792 arc
s
.95 g
.08342 .64431 m
.08274 .6408 L
.08173 .63737 L
.0804 .63406 L
.07876 .63089 L
.07682 .62789 L
.07461 .62508 L
.07214 .62251 L
.06943 .62017 L
.06651 .61811 L
.06341 .61634 L
.06341 .61634 L
.06724 .61508 L
.07106 .61379 L
.07487 .61247 L
.07867 .61111 L
.08245 .60973 L
.08622 .60831 L
.08998 .60686 L
.09373 .60538 L
.09747 .60386 L
.10119 .60232 L
.1049 .60074 L
.1086 .59914 L
.11228 .5975 L
.11595 .59583 L
.1196 .59412 L
.1196 .59412 L
.11753 .59943 L
.1152 .60463 L
.11261 .60971 L
.10976 .61464 L
.10667 .61943 L
.10334 .62405 L
.09978 .62849 L
.096 .63275 L
.092 .63682 L
.08781 .64067 L
.08342 .64431 L
F
0 g
newpath
.01399 .55612 .11224 19.7922 51.7868 arc
s
newpath
-0.08321 .16328 .47619 64.7922 72.0663 arc
s
newpath
.04639 .64965 .03741 297.066 351.787 arc
s
.95 g
.11658 .68112 m
.11282 .67917 L
.10894 .67745 L
.10497 .67599 L
.10091 .67477 L
.09678 .67381 L
.0926 .67311 L
.08838 .67267 L
.08415 .67249 L
.07991 .67258 L
.07568 .67293 L
.07568 .67293 L
.07748 .67047 L
.07907 .66787 L
.08044 .66515 L
.08159 .66232 L
.08251 .65942 L
.08318 .65644 L
.08361 .65343 L
.0838 .65039 L
.08373 .64734 L
.08342 .64431 L
.08342 .64431 L
.08809 .64643 L
.09255 .64896 L
.09676 .6519 L
.10068 .6552 L
.10428 .65885 L
.10754 .66282 L
.11042 .66706 L
.1129 .67155 L
.11496 .67625 L
.11658 .68112 L
F
0 g
newpath
.06259 .69642 .05612 291.787 344.177 arc
s
newpath
.04639 .64965 .03741 -8.21321 38.4693 arc
s
newpath
.08342 .74051 .06803 263.469 299.177 arc
s
.95 g
.11119 .5 m
.10806 .4949 L
.10466 .48997 L
.10101 .48523 L
.0971 .48069 L
.09296 .47636 L
.08859 .47226 L
.08402 .4684 L
.07924 .46479 L
.07428 .46144 L
.06914 .45836 L
.06385 .45556 L
.06385 .45556 L
.07101 .45282 L
.07794 .44951 L
.08457 .44566 L
.09087 .44128 L
.0968 .43641 L
.10231 .43108 L
.10738 .42532 L
.11197 .41918 L
.11605 .41268 L
.1196 .40588 L
.1196 .40588 L
.12227 .41433 L
.12426 .42297 L
.12557 .43173 L
.12618 .44058 L
.12609 .44944 L
.1253 .45827 L
.12382 .46701 L
.12165 .47561 L
.11881 .48401 L
.11532 .49215 L
.11119 .5 L
F
0 g
newpath
.01399 .44388 .11224 -19.7922 30 arc
s
newpath
.03343 .36531 .09524 25.2078 71.3736 arc
s
newpath
.01399 .55612 .11224 296.374 330 arc
s
.95 g
.06385 .54444 m
.06914 .54164 L
.07428 .53856 L
.07924 .53521 L
.08402 .5316 L
.08859 .52774 L
.09296 .52364 L
.0971 .51931 L
.10101 .51477 L
.10466 .51003 L
.10806 .5051 L
.11119 .5 L
.11119 .5 L
.11532 .50785 L
.11881 .51599 L
.12165 .52439 L
.12382 .53299 L
.1253 .54173 L
.12609 .55056 L
.12618 .55942 L
.12557 .56827 L
.12426 .57703 L
.12227 .58567 L
.1196 .59412 L
.1196 .59412 L
.1164 .58793 L
.11275 .58198 L
.10868 .57632 L
.10421 .57097 L
.09936 .56596 L
.09415 .56132 L
.08862 .55707 L
.08279 .55324 L
.0767 .54984 L
.07037 .54691 L
.06385 .54444 L
F
0 g
newpath
.01399 .55612 .11224 -30 19.7922 arc
s
newpath
.03343 .63469 .09524 288.626 334.792 arc
s
newpath
.01399 .44388 .11224 30 63.6264 arc
s
.95 g
.1196 .40588 m
.11753 .40057 L
.1152 .39537 L
.11261 .39029 L
.10976 .38536 L
.10667 .38057 L
.10334 .37595 L
.09978 .37151 L
.096 .36725 L
.092 .36318 L
.08781 .35933 L
.08342 .35569 L
.08342 .35569 L
.08809 .35357 L
.09255 .35104 L
.09676 .3481 L
.10068 .3448 L
.10428 .34115 L
.10754 .33718 L
.11042 .33294 L
.1129 .32845 L
.11496 .32375 L
.11658 .31888 L
.11658 .31888 L
.12028 .32622 L
.12332 .33385 L
.1257 .34172 L
.12739 .34976 L
.12838 .35791 L
.12867 .36612 L
.12824 .37433 L
.12711 .38247 L
.12528 .39048 L
.12277 .3983 L
.1196 .40588 L
F
0 g
newpath
.03343 .36531 .09524 -29.1773 25.2078 arc
s
newpath
.06259 .30358 .05612 15.8227 68.2132 arc
s
newpath
.01399 .44388 .11224 308.213 340.208 arc
s
.95 g
.08342 .64431 m
.08781 .64067 L
.092 .63682 L
.096 .63275 L
.09978 .62849 L
.10334 .62405 L
.10667 .61943 L
.10976 .61464 L
.11261 .60971 L
.1152 .60463 L
.11753 .59943 L
.1196 .59412 L
.1196 .59412 L
.12277 .6017 L
.12528 .60952 L
.12711 .61753 L
.12824 .62567 L
.12867 .63388 L
.12838 .64209 L
.12739 .65024 L
.1257 .65828 L
.12332 .66615 L
.12028 .67378 L
.11658 .68112 L
.11658 .68112 L
.11496 .67625 L
.1129 .67155 L
.11042 .66706 L
.10754 .66282 L
.10428 .65885 L
.10068 .6552 L
.09676 .6519 L
.09255 .64896 L
.08809 .64643 L
.08342 .64431 L
F
0 g
newpath
.03343 .63469 .09524 -25.2078 29.1773 arc
s
newpath
.06259 .69642 .05612 291.787 344.177 arc
s
newpath
.01399 .55612 .11224 19.7922 51.7868 arc
s
.95 g
.15144 .74149 m
.14819 .7384 L
.1447 .73558 L
.14099 .73305 L
.1371 .73082 L
.13304 .72891 L
.12884 .72733 L
.12453 .72609 L
.12013 .72519 L
.11568 .72466 L
.11119 .72448 L
.11119 .72448 L
.11328 .72051 L
.11504 .71638 L
.11647 .71213 L
.11755 .70777 L
.11828 .70334 L
.11866 .69887 L
.11867 .69439 L
.11833 .68991 L
.11763 .68548 L
.11658 .68112 L
.11658 .68112 L
.12277 .68502 L
.1285 .68957 L
.13371 .6947 L
.13834 .70037 L
.14233 .7065 L
.14565 .71302 L
.14824 .71986 L
.15008 .72694 L
.15115 .73418 L
.15144 .74149 L
F
0 g
newpath
.08342 .74051 .06803 -60.8227 .82267 arc
s
newpath
.06259 .69642 .05612 -15.8227 30 arc
s
newpath
.11119 .7806 .05612 270 315.823 arc
s
.95 g
.11658 .31888 m
.12349 .32076 L
.13043 .32249 L
.1374 .32407 L
.14441 .32551 L
.15145 .32679 L
.15851 .32793 L
.16559 .32891 L
.1727 .32974 L
.17982 .33043 L
.18695 .33096 L
.19409 .33134 L
.20124 .33157 L
.20839 .33164 L
.20839 .33164 L
.20273 .34077 L
.1965 .34951 L
.18972 .35784 L
.18242 .36572 L
.17464 .37312 L
.1664 .38001 L
.15774 .38636 L
.14869 .39214 L
.13929 .39733 L
.12958 .40192 L
.1196 .40588 L
.1196 .40588 L
.12277 .3983 L
.12528 .39048 L
.12711 .38247 L
.12824 .37433 L
.12867 .36612 L
.12838 .35791 L
.12739 .34976 L
.1257 .34172 L
.12332 .33385 L
.12028 .32622 L
.11658 .31888 L
F
0 g
newpath
.06259 .24746 .16836 30 70.2078 arc
s
newpath
.03343 .36531 .09524 -29.1773 25.2078 arc
s
newpath
.20839 -0.00508 .33672 90 105.823 arc
s
.95 g
.20839 .66836 m
.20124 .66843 L
.19409 .66866 L
.18695 .66904 L
.17982 .66957 L
.1727 .67026 L
.16559 .67109 L
.15851 .67207 L
.15145 .67321 L
.14441 .67449 L
.1374 .67593 L
.13043 .67751 L
.12349 .67924 L
.11658 .68112 L
.11658 .68112 L
.12061 .67303 L
.12385 .66459 L
.12628 .65589 L
.12787 .64699 L
.12861 .63799 L
.1285 .62895 L
.12752 .61997 L
.12571 .61111 L
.12306 .60247 L
.1196 .59412 L
.1196 .59412 L
.12958 .59808 L
.13929 .60267 L
.14869 .60786 L
.15774 .61364 L
.1664 .61999 L
.17464 .62688 L
.18242 .63428 L
.18972 .64216 L
.1965 .65049 L
.20273 .65923 L
.20839 .66836 L
F
0 g
newpath
.06259 .75254 .16836 289.792 330 arc
s
newpath
.03343 .63469 .09524 -25.2078 29.1773 arc
s
newpath
.20839 1.00508 .33672 254.177 270 arc
s
.95 g
.16674 .78862 m
.16427 .78683 L
.16166 .78525 L
.15893 .78389 L
.15611 .78275 L
.1532 .78185 L
.15022 .78119 L
.1472 .78077 L
.14416 .7806 L
.14111 .78068 L
.13808 .78101 L
.13808 .78101 L
.1405 .77752 L
.14269 .7739 L
.14466 .77014 L
.14638 .76627 L
.14787 .7623 L
.1491 .75824 L
.15007 .75412 L
.15079 .74994 L
.15125 .74572 L
.15144 .74149 L
.15144 .74149 L
.15484 .74533 L
.15788 .74946 L
.16053 .75385 L
.16277 .75847 L
.16457 .76327 L
.16593 .76822 L
.16683 .77327 L
.16727 .77838 L
.16724 .78351 L
.16674 .78862 L
F
0 g
newpath
.11119 .7806 .05612 -44.1773 8.21321 arc
s
newpath
.08342 .74051 .06803 .82267 36.5307 arc
s
newpath
.14359 .81801 .03741 261.531 308.213 arc
s
.95 g
.11658 .31888 m
.12277 .31498 L
.1285 .31043 L
.13371 .3053 L
.13834 .29963 L
.14233 .2935 L
.14565 .28698 L
.14824 .28014 L
.15008 .27306 L
.15115 .26582 L
.15144 .25851 L
.15144 .25851 L
.15652 .26355 L
.16149 .2687 L
.16634 .27394 L
.17109 .2793 L
.17572 .28475 L
.18023 .2903 L
.18463 .29594 L
.1889 .30168 L
.19305 .3075 L
.19708 .31341 L
.20098 .31941 L
.20475 .32549 L
.20839 .33164 L
.20839 .33164 L
.20124 .33157 L
.19409 .33134 L
.18695 .33096 L
.17982 .33043 L
.1727 .32974 L
.16559 .32891 L
.15851 .32793 L
.15145 .32679 L
.14441 .32551 L
.1374 .32407 L
.13043 .32249 L
.12349 .32076 L
.11658 .31888 L
F
0 g
newpath
-0.08321 .5 .33672 314.177 330 arc
s
newpath
.08342 .25949 .06803 -0.82267 60.8227 arc
s
newpath
.20839 -0.00508 .33672 90 105.823 arc
s
.95 g
.20839 .66836 m
.20475 .67451 L
.20098 .68059 L
.19708 .68659 L
.19305 .6925 L
.1889 .69832 L
.18463 .70406 L
.18023 .7097 L
.17572 .71525 L
.17109 .7207 L
.16634 .72606 L
.16149 .7313 L
.15652 .73645 L
.15144 .74149 L
.15144 .74149 L
.15115 .73418 L
.15008 .72694 L
.14824 .71986 L
.14565 .71302 L
.14233 .7065 L
.13834 .70037 L
.13371 .6947 L
.1285 .68957 L
.12277 .68502 L
.11658 .68112 L
.11658 .68112 L
.12349 .67924 L
.13043 .67751 L
.1374 .67593 L
.14441 .67449 L
.15145 .67321 L
.15851 .67207 L
.16559 .67109 L
.1727 .67026 L
.17982 .66957 L
.18695 .66904 L
.19409 .66866 L
.20124 .66843 L
.20839 .66836 L
F
0 g
newpath
-0.08321 .5 .33672 30 45.8227 arc
s
newpath
.08342 .74051 .06803 -60.8227 .82267 arc
s
newpath
.20839 1.00508 .33672 254.177 270 arc
s
.95 g
.11119 .5 m
.11532 .49215 L
.11881 .48401 L
.12165 .47561 L
.12382 .46701 L
.1253 .45827 L
.12609 .44944 L
.12618 .44058 L
.12557 .43173 L
.12426 .42297 L
.12227 .41433 L
.1196 .40588 L
.1196 .40588 L
.12947 .41066 L
.13922 .41567 L
.14886 .4209 L
.15837 .42636 L
.16776 .43203 L
.17701 .43792 L
.18612 .44401 L
.19509 .45032 L
.20392 .45683 L
.21259 .46354 L
.2211 .47045 L
.22946 .47756 L
.23765 .48485 L
.24566 .49234 L
.25351 .5 L
.25351 .5 L
.11119 .5 L
F
0 g
newpath
-0.08321 .83672 .47619 295.208 315 arc
s
.25351 .5 m
.11119 .5 L
s
newpath
.01399 .44388 .11224 -19.7922 30 arc
s
.95 g
.1196 .59412 m
.12227 .58567 L
.12426 .57703 L
.12557 .56827 L
.12618 .55942 L
.12609 .55056 L
.1253 .54173 L
.12382 .53299 L
.12165 .52439 L
.11881 .51599 L
.11532 .50785 L
.11119 .5 L
.11119 .5 L
.25351 .5 L
.25351 .5 L
.2451 .5082 L
.23649 .5162 L
.22768 .52398 L
.21869 .53154 L
.20951 .53888 L
.20015 .54598 L
.19063 .55286 L
.18093 .5595 L
.17108 .56589 L
.16107 .57204 L
.15091 .57795 L
.1406 .5836 L
.13017 .58899 L
.1196 .59412 L
F
0 g
newpath
-0.08321 .16328 .47619 45 64.7922 arc
s
.25351 .5 m
.11119 .5 L
s
newpath
.01399 .55612 .11224 -30 19.7922 arc
s
.95 g
.15144 .25851 m
.15484 .25467 L
.15788 .25054 L
.16053 .24615 L
.16277 .24153 L
.16457 .23673 L
.16593 .23178 L
.16683 .22673 L
.16727 .22162 L
.16724 .21649 L
.16674 .21138 L
.16674 .21138 L
.17208 .21336 L
.17751 .21507 L
.18303 .2165 L
.18861 .21764 L
.19424 .21851 L
.19991 .21908 L
.2056 .21937 L
.2113 .21936 L
.21699 .21907 L
.22265 .21849 L
.22828 .21763 L
.22828 .21763 L
.22331 .22416 L
.21779 .23025 L
.21177 .23584 L
.20529 .24088 L
.19839 .24535 L
.19114 .24921 L
.18358 .25243 L
.17577 .25499 L
.16777 .25686 L
.15964 .25804 L
.15144 .25851 L
F
0 g
newpath
.15007 .16328 .09524 34.7922 89.1773 arc
s
newpath
.20839 .10716 .11224 79.7922 111.787 arc
s
newpath
.11119 .2194 .05612 -8.21321 44.1773 arc
s
.95 g
.16674 .78862 m
.16724 .78351 L
.16727 .77838 L
.16683 .77327 L
.16593 .76822 L
.16457 .76327 L
.16277 .75847 L
.16053 .75385 L
.15788 .74946 L
.15484 .74533 L
.15144 .74149 L
.15144 .74149 L
.15964 .74196 L
.16777 .74314 L
.17577 .74501 L
.18358 .74757 L
.19114 .75079 L
.19839 .75465 L
.20529 .75912 L
.21177 .76416 L
.21779 .76975 L
.22331 .77584 L
.22828 .78237 L
.22828 .78237 L
.22265 .78151 L
.21699 .78093 L
.2113 .78064 L
.2056 .78063 L
.19991 .78092 L
.19424 .78149 L
.18861 .78236 L
.18303 .7835 L
.17751 .78493 L
.17208 .78664 L
.16674 .78862 L
F
0 g
newpath
.15007 .83672 .09524 270.823 325.208 arc
s
newpath
.20839 .89284 .11224 248.213 280.208 arc
s
newpath
.11119 .7806 .05612 -44.1773 8.21321 arc
s
.95 g
.22828 .78237 m
.22475 .78485 L
.22124 .78737 L
.21775 .78991 L
.21428 .79249 L
.21084 .79509 L
.20742 .79773 L
.20402 .8004 L
.20065 .8031 L
.19731 .80583 L
.19399 .80859 L
.19069 .81138 L
.18742 .8142 L
.18418 .81705 L
.18096 .81993 L
.18096 .81993 L
.18097 .81635 L
.18064 .8128 L
.17997 .80929 L
.17898 .80586 L
.17766 .80254 L
.17603 .79936 L
.1741 .79635 L
.1719 .79354 L
.16943 .79096 L
.16674 .78862 L
.16674 .78862 L
.17208 .78664 L
.17751 .78493 L
.18303 .7835 L
.18861 .78236 L
.19424 .78149 L
.19991 .78092 L
.2056 .78063 L
.2113 .78064 L
.21699 .78093 L
.22265 .78151 L
.22828 .78237 L
F
0 g
newpath
.20839 .89284 .11224 248.213 280.208 arc
s
newpath
.14359 .81801 .03741 -51.7868 2.93365 arc
s
newpath
.5 1.17344 .47619 227.934 235.208 arc
s
.95 g
.15144 .25851 m
.15964 .25804 L
.16777 .25686 L
.17577 .25499 L
.18358 .25243 L
.19114 .24921 L
.19839 .24535 L
.20529 .24088 L
.21177 .23584 L
.21779 .23025 L
.22331 .22416 L
.22828 .21763 L
.22828 .21763 L
.22985 .22825 L
.23073 .23895 L
.23094 .24969 L
.23045 .26042 L
.22928 .27109 L
.22744 .28167 L
.22492 .29211 L
.22174 .30237 L
.21792 .3124 L
.21346 .32217 L
.20839 .33164 L
.20839 .33164 L
.20475 .32549 L
.20098 .31941 L
.19708 .31341 L
.19305 .3075 L
.1889 .30168 L
.18463 .29594 L
.18023 .2903 L
.17572 .28475 L
.17109 .2793 L
.16634 .27394 L
.16149 .2687 L
.15652 .26355 L
.15144 .25851 L
F
0 g
newpath
.06259 .24746 .16836 -10.2078 30 arc
s
newpath
-0.08321 .5 .33672 314.177 330 arc
s
newpath
.15007 .16328 .09524 34.7922 89.1773 arc
s
.95 g
.25351 .5 m
.24566 .49234 L
.23765 .48485 L
.22946 .47756 L
.2211 .47045 L
.21259 .46354 L
.20392 .45683 L
.19509 .45032 L
.18612 .44401 L
.17701 .43792 L
.16776 .43203 L
.15837 .42636 L
.14886 .4209 L
.13922 .41567 L
.12947 .41066 L
.1196 .40588 L
.1196 .40588 L
.12958 .40192 L
.13929 .39733 L
.14869 .39214 L
.15774 .38636 L
.1664 .38001 L
.17464 .37312 L
.18242 .36572 L
.18972 .35784 L
.1965 .34951 L
.20273 .34077 L
.20839 .33164 L
.20839 .33164 L
.21494 .34352 L
.221 .35565 L
.22656 .36802 L
.23162 .3806 L
.23618 .39337 L
.24021 .40632 L
.24372 .41942 L
.2467 .43265 L
.24915 .44599 L
.25105 .45941 L
.25241 .47291 L
.25323 .48644 L
.25351 .5 L
F
0 g
newpath
-0.08321 .5 .33672 330 360 arc
s
newpath
.06259 .24746 .16836 30 70.2078 arc
s
newpath
-0.08321 .83672 .47619 295.208 315 arc
s
.95 g
.1196 .59412 m
.13017 .58899 L
.1406 .5836 L
.15091 .57795 L
.16107 .57204 L
.17108 .56589 L
.18093 .5595 L
.19063 .55286 L
.20015 .54598 L
.20951 .53888 L
.21869 .53154 L
.22768 .52398 L
.23649 .5162 L
.2451 .5082 L
.25351 .5 L
.25351 .5 L
.25323 .51356 L
.25241 .52709 L
.25105 .54059 L
.24915 .55401 L
.2467 .56735 L
.24372 .58058 L
.24021 .59368 L
.23618 .60663 L
.23162 .6194 L
.22656 .63198 L
.221 .64435 L
.21494 .65648 L
.20839 .66836 L
.20839 .66836 L
.20273 .65923 L
.1965 .65049 L
.18972 .64216 L
.18242 .63428 L
.17464 .62688 L
.1664 .61999 L
.15774 .61364 L
.14869 .60786 L
.13929 .60267 L
.12958 .59808 L
.1196 .59412 L
F
0 g
newpath
-0.08321 .5 .33672 0 30 arc
s
newpath
.06259 .75254 .16836 289.792 330 arc
s
newpath
-0.08321 .16328 .47619 45 64.7922 arc
s
.95 g
.22828 .78237 m
.22278 .77521 L
.21663 .76859 L
.20987 .76259 L
.20257 .75726 L
.19481 .75264 L
.18664 .74878 L
.17814 .74571 L
.16939 .74346 L
.16046 .74205 L
.15144 .74149 L
.15144 .74149 L
.15652 .73645 L
.16149 .7313 L
.16634 .72606 L
.17109 .7207 L
.17572 .71525 L
.18023 .7097 L
.18463 .70406 L
.1889 .69832 L
.19305 .6925 L
.19708 .68659 L
.20098 .68059 L
.20475 .67451 L
.20839 .66836 L
.20839 .66836 L
.21346 .67783 L
.21792 .6876 L
.22174 .69763 L
.22492 .70789 L
.22744 .71833 L
.22928 .72891 L
.23045 .73958 L
.23094 .75031 L
.23073 .76105 L
.22985 .77175 L
.22828 .78237 L
F
0 g
newpath
.06259 .75254 .16836 -30 10.2078 arc
s
newpath
-0.08321 .5 .33672 30 45.8227 arc
s
newpath
.15007 .83672 .09524 270.823 325.208 arc
s
.95 g
.24344 .8555 m
.24098 .85217 L
.23821 .8491 L
.23514 .84631 L
.23182 .84384 L
.22828 .84171 L
.22453 .83994 L
.22064 .83854 L
.21662 .83753 L
.21253 .83692 L
.20839 .83672 L
.20839 .83672 L
.21097 .8321 L
.21339 .8274 L
.21567 .82263 L
.21779 .81779 L
.21976 .81288 L
.22158 .80792 L
.22324 .8029 L
.22474 .79783 L
.22609 .79272 L
.22727 .78756 L
.22828 .78237 L
.22828 .78237 L
.23241 .78885 L
.23599 .79563 L
.23902 .80268 L
.24147 .80995 L
.24333 .81739 L
.24458 .82496 L
.24522 .8326 L
.24524 .84027 L
.24465 .84792 L
.24344 .8555 L
F
0 g
newpath
.15007 .83672 .09524 -34.7922 11.3736 arc
s
newpath
.06259 .75254 .16836 10.2078 30 arc
s
newpath
.20839 .87881 .04209 270 326.374 arc
s
.95 g
.22828 .21763 m
.23205 .21176 L
.23538 .20563 L
.23825 .19927 L
.24065 .19272 L
.24256 .18601 L
.24397 .17918 L
.24489 .17227 L
.24529 .16531 L
.24518 .15833 L
.24456 .15138 L
.24344 .1445 L
.24344 .1445 L
.24851 .14768 L
.25375 .15059 L
.25913 .15321 L
.26465 .15555 L
.27028 .15758 L
.27601 .15931 L
.28182 .16074 L
.28771 .16185 L
.29364 .16264 L
.29961 .16312 L
.3056 .16328 L
.3056 .16328 L
.30086 .17078 L
.29555 .17788 L
.2897 .18454 L
.28334 .19071 L
.27651 .19637 L
.26926 .20146 L
.26163 .20597 L
.25367 .20987 L
.24542 .21312 L
.23694 .21571 L
.22828 .21763 L
F
0 g
newpath
.20839 .10716 .11224 30 79.7922 arc
s
newpath
.3056 .05104 .11224 90 123.626 arc
s
newpath
.15007 .16328 .09524 -11.3736 34.7922 arc
s
.95 g
.24344 .8555 m
.24465 .84792 L
.24524 .84027 L
.24522 .8326 L
.24458 .82496 L
.24333 .81739 L
.24147 .80995 L
.23902 .80268 L
.23599 .79563 L
.23241 .78885 L
.22828 .78237 L
.22828 .78237 L
.23694 .78429 L
.24542 .78688 L
.25367 .79013 L
.26163 .79403 L
.26926 .79854 L
.27651 .80363 L
.28334 .80929 L
.2897 .81546 L
.29555 .82212 L
.30086 .82922 L
.3056 .83672 L
.3056 .83672 L
.29961 .83688 L
.29364 .83736 L
.28771 .83815 L
.28182 .83926 L
.27601 .84069 L
.27028 .84242 L
.26465 .84445 L
.25913 .84679 L
.25375 .84941 L
.24851 .85232 L
.24344 .8555 L
F
0 g
newpath
.20839 .89284 .11224 280.208 330 arc
s
newpath
.3056 .94896 .11224 236.374 270 arc
s
newpath
.15007 .83672 .09524 -34.7922 11.3736 arc
s
.95 g
.27672 .88673 m
.3056 .83672 L
.3056 .83672 L
.29961 .83688 L
.29364 .83736 L
.28771 .83815 L
.28182 .83926 L
.27601 .84069 L
.27028 .84242 L
.26465 .84445 L
.25913 .84679 L
.25375 .84941 L
.24851 .85232 L
.24344 .8555 L
.24344 .8555 L
.24809 .85671 L
.25258 .85842 L
.25685 .86062 L
.26085 .86329 L
.26453 .86637 L
.26785 .86985 L
.27076 .87368 L
.27322 .8778 L
.27522 .88217 L
.27672 .88673 L
F
0 g
.27672 .88673 m
.3056 .83672 L
s
newpath
.3056 .94896 .11224 236.374 270 arc
s
newpath
.2349 .89794 .04329 281.374 345 arc
s
.95 g
.20839 .33164 m
.21346 .32217 L
.21792 .3124 L
.22174 .30237 L
.22492 .29211 L
.22744 .28167 L
.22928 .27109 L
.23045 .26042 L
.23094 .24969 L
.23073 .23895 L
.22985 .22825 L
.22828 .21763 L
.22828 .21763 L
.23736 .22378 L
.24658 .22972 L
.25593 .23545 L
.26541 .24096 L
.27501 .24625 L
.28474 .25132 L
.29458 .25617 L
.30452 .26078 L
.31457 .26517 L
.32472 .26932 L
.33496 .27324 L
.34529 .27692 L
.35571 .28037 L
.36619 .28357 L
.37675 .28653 L
.37675 .28653 L
.36487 .29307 L
.35274 .29913 L
.34038 .3047 L
.3278 .30976 L
.31502 .31431 L
.30207 .31835 L
.28898 .32186 L
.27575 .32484 L
.26241 .32728 L
.24898 .32919 L
.23549 .33055 L
.22195 .33137 L
.20839 .33164 L
F
0 g
newpath
.20839 -0.00508 .33672 60 90 arc
s
newpath
.5 -0.17344 .47619 105 124.792 arc
s
newpath
.06259 .24746 .16836 -10.2078 30 arc
s
.95 g
.22828 .78237 m
.22985 .77175 L
.23073 .76105 L
.23094 .75031 L
.23045 .73958 L
.22928 .72891 L
.22744 .71833 L
.22492 .70789 L
.22174 .69763 L
.21792 .6876 L
.21346 .67783 L
.20839 .66836 L
.20839 .66836 L
.22195 .66863 L
.23549 .66945 L
.24898 .67081 L
.26241 .67272 L
.27575 .67516 L
.28898 .67814 L
.30207 .68165 L
.31502 .68569 L
.3278 .69024 L
.34038 .6953 L
.35274 .70087 L
.36487 .70693 L
.37675 .71347 L
.37675 .71347 L
.36619 .71643 L
.35571 .71963 L
.34529 .72308 L
.33496 .72676 L
.32472 .73068 L
.31457 .73483 L
.30452 .73922 L
.29458 .74383 L
.28474 .74868 L
.27501 .75375 L
.26541 .75904 L
.25593 .76455 L
.24658 .77028 L
.23736 .77622 L
.22828 .78237 L
F
0 g
newpath
.20839 1.00508 .33672 270 300 arc
s
newpath
.5 1.17344 .47619 235.208 255 arc
s
newpath
.06259 .75254 .16836 -30 10.2078 arc
s
.95 g
.32041 .89994 m
.31734 .89985 L
.31427 .9 L
.31122 .90036 L
.3082 .90095 L
.30523 .90175 L
.30234 .90277 L
.29952 .904 L
.2968 .90543 L
.29419 .90706 L
.29171 .90887 L
.29171 .90887 L
.29119 .90615 L
.29043 .9035 L
.28943 .90092 L
.2882 .89844 L
.28676 .89608 L
.28511 .89386 L
.28326 .8918 L
.28124 .88992 L
.27905 .88822 L
.27672 .88673 L
.27672 .88673 L
.28142 .88575 L
.2862 .88529 L
.29101 .88537 L
.29578 .88598 L
.30044 .88711 L
.30496 .88875 L
.30927 .89089 L
.31331 .89348 L
.31704 .89651 L
.32041 .89994 L
F
0 g
newpath
.28792 .92855 .04329 255 318.626 arc
s
newpath
.26141 .91324 .03061 300 351.787 arc
s
newpath
.31775 .94194 .04209 231.787 273.626 arc
s
.95 g
.3056 .16328 m
.27672 .11327 L
.27672 .11327 L
.28142 .11425 L
.2862 .11471 L
.29101 .11463 L
.29578 .11402 L
.30044 .11289 L
.30496 .11125 L
.30927 .10911 L
.31331 .10652 L
.31704 .10349 L
.32041 .10006 L
.32041 .10006 L
.32063 .10605 L
.32053 .11203 L
.32011 .11801 L
.31937 .12395 L
.31832 .12984 L
.31695 .13567 L
.31528 .14142 L
.3133 .14707 L
.31102 .15261 L
.30845 .15802 L
.3056 .16328 L
F
0 g
newpath
.20839 .10716 .11224 -3.62643 30 arc
s
newpath
.28792 .07145 .04329 41.3736 105 arc
s
.27672 .11327 m
.3056 .16328 L
s
.95 g
.22828 .21763 m
.23694 .21571 L
.24542 .21312 L
.25367 .20987 L
.26163 .20597 L
.26926 .20146 L
.27651 .19637 L
.28334 .19071 L
.2897 .18454 L
.29555 .17788 L
.30086 .17078 L
.3056 .16328 L
.3056 .16328 L
.37675 .28653 L
.37675 .28653 L
.36544 .28335 L
.35421 .27989 L
.34307 .27616 L
.33203 .27215 L
.32109 .26787 L
.31025 .26332 L
.29954 .2585 L
.28894 .25343 L
.27847 .24809 L
.26814 .2425 L
.25795 .23665 L
.24791 .23055 L
.23802 .22421 L
.22828 .21763 L
F
0 g
.3056 .16328 m
.37675 .28653 L
s
newpath
.5 -0.17344 .47619 105 124.792 arc
s
newpath
.20839 .10716 .11224 30 79.7922 arc
s
.95 g
.3056 .83672 m
.37675 .71347 L
.37675 .71347 L
.36619 .71643 L
.35571 .71963 L
.34529 .72308 L
.33496 .72676 L
.32472 .73068 L
.31457 .73483 L
.30452 .73922 L
.29458 .74383 L
.28474 .74868 L
.27501 .75375 L
.26541 .75904 L
.25593 .76455 L
.24658 .77028 L
.23736 .77622 L
.22828 .78237 L
.22828 .78237 L
.23694 .78429 L
.24542 .78688 L
.25367 .79013 L
.26163 .79403 L
.26926 .79854 L
.27651 .80363 L
.28334 .80929 L
.2897 .81546 L
.29555 .82212 L
.30086 .82922 L
.3056 .83672 L
F
0 g
.3056 .83672 m
.37675 .71347 L
s
newpath
.5 1.17344 .47619 235.208 255 arc
s
newpath
.20839 .89284 .11224 280.208 330 arc
s
.95 g
.3056 .83672 m
.30845 .84198 L
.31102 .84739 L
.3133 .85293 L
.31528 .85858 L
.31695 .86433 L
.31832 .87016 L
.31937 .87605 L
.32011 .88199 L
.32053 .88797 L
.32063 .89395 L
.32041 .89994 L
.32041 .89994 L
.31704 .89651 L
.31331 .89348 L
.30927 .89089 L
.30496 .88875 L
.30044 .88711 L
.29578 .88598 L
.29101 .88537 L
.2862 .88529 L
.28142 .88575 L
.27672 .88673 L
.27672 .88673 L
.3056 .83672 L
F
0 g
newpath
.20839 .89284 .11224 -30 3.62643 arc
s
newpath
.28792 .92855 .04329 255 318.626 arc
s
.27672 .88673 m
.3056 .83672 L
s
.95 g
.20839 .33164 m
.22195 .33137 L
.23549 .33055 L
.24898 .32919 L
.26241 .32728 L
.27575 .32484 L
.28898 .32186 L
.30207 .31835 L
.31502 .31431 L
.3278 .30976 L
.34038 .3047 L
.35274 .29913 L
.36487 .29307 L
.37675 .28653 L
.37675 .28653 L
.37217 .30251 L
.36704 .31831 L
.36135 .33393 L
.35512 .34934 L
.34836 .36453 L
.34108 .37947 L
.33327 .39414 L
.32496 .40854 L
.31616 .42263 L
.30686 .43641 L
.29709 .44986 L
.28686 .46296 L
.27617 .47569 L
.26505 .48804 L
.25351 .5 L
.25351 .5 L
.25323 .48644 L
.25241 .47291 L
.25105 .45941 L
.24915 .44599 L
.2467 .43265 L
.24372 .41942 L
.24021 .40632 L
.23618 .39337 L
.23162 .3806 L
.22656 .36802 L
.221 .35565 L
.21494 .34352 L
.20839 .33164 L
F
0 g
newpath
-0.08321 .16328 .47619 15 45 arc
s
newpath
-0.08321 .5 .33672 330 360 arc
s
newpath
.20839 -0.00508 .33672 60 90 arc
s
.95 g
.37675 .71347 m
.36487 .70693 L
.35274 .70087 L
.34038 .6953 L
.3278 .69024 L
.31502 .68569 L
.30207 .68165 L
.28898 .67814 L
.27575 .67516 L
.26241 .67272 L
.24898 .67081 L
.23549 .66945 L
.22195 .66863 L
.20839 .66836 L
.20839 .66836 L
.21494 .65648 L
.221 .64435 L
.22656 .63198 L
.23162 .6194 L
.23618 .60663 L
.24021 .59368 L
.24372 .58058 L
.2467 .56735 L
.24915 .55401 L
.25105 .54059 L
.25241 .52709 L
.25323 .51356 L
.25351 .5 L
.25351 .5 L
.26586 .51283 L
.27773 .5261 L
.28909 .53982 L
.29993 .55395 L
.31024 .56847 L
.31999 .58337 L
.32918 .59862 L
.3378 .61421 L
.34582 .63011 L
.35325 .64629 L
.36006 .66275 L
.36626 .67944 L
.37182 .69636 L
.37675 .71347 L
F
0 g
newpath
-0.08321 .83672 .47619 315 345 arc
s
newpath
-0.08321 .5 .33672 0 30 arc
s
newpath
.20839 1.00508 .33672 270 300 arc
s
.95 g
.3542 .9209 m
.35167 .92099 L
.34915 .92128 L
.34666 .92175 L
.34422 .92241 L
.34183 .92325 L
.33951 .92427 L
.33727 .92546 L
.33513 .92681 L
.3331 .92832 L
.33119 .92998 L
.33119 .92998 L
.33117 .92671 L
.33091 .92346 L
.33041 .92023 L
.32966 .91705 L
.32867 .91393 L
.32745 .9109 L
.32601 .90797 L
.32434 .90515 L
.32247 .90247 L
.32041 .89994 L
.32041 .89994 L
.32452 .9004 L
.32857 .90127 L
.33251 .90253 L
.33631 .90417 L
.33993 .90618 L
.34334 .90853 L
.3465 .9112 L
.34938 .91418 L
.35195 .91742 L
.3542 .9209 L
F
0 g
newpath
.31775 .94194 .04209 273.626 330 arc
s
newpath
.28792 .92855 .04329 -41.3736 1.89823 arc
s
newpath
.3542 .95457 .03367 226.898 270 arc
s
.95 g
.32041 .10006 m
.32581 .10448 L
.33152 .10849 L
.3375 .11207 L
.34373 .1152 L
.35018 .11787 L
.3568 .12006 L
.36356 .12175 L
.37043 .12295 L
.37737 .12365 L
.38435 .12383 L
.39131 .1235 L
.39131 .1235 L
.38533 .13004 L
.37885 .13609 L
.3719 .1416 L
.36455 .14655 L
.35683 .15091 L
.34879 .15464 L
.34048 .15772 L
.33195 .16014 L
.32326 .16188 L
.31445 .16293 L
.3056 .16328 L
.3056 .16328 L
.30845 .15802 L
.31102 .15261 L
.3133 .14707 L
.31528 .14142 L
.31695 .13567 L
.31832 .12984 L
.31937 .12395 L
.32011 .11801 L
.32053 .11203 L
.32063 .10605 L
.32041 .10006 L
F
0 g
newpath
.3056 .05104 .11224 40.2078 90 arc
s
newpath
.20839 .10716 .11224 -3.62643 30 arc
s
newpath
.38336 .0286 .09524 85.2078 131.374 arc
s
.95 g
.39131 .8765 m
.38435 .87617 L
.37737 .87635 L
.37043 .87705 L
.36356 .87825 L
.3568 .87994 L
.35018 .88213 L
.34373 .8848 L
.3375 .88793 L
.33152 .89151 L
.32581 .89552 L
.32041 .89994 L
.32041 .89994 L
.32063 .89395 L
.32053 .88797 L
.32011 .88199 L
.31937 .87605 L
.31832 .87016 L
.31695 .86433 L
.31528 .85858 L
.3133 .85293 L
.31102 .84739 L
.30845 .84198 L
.3056 .83672 L
.3056 .83672 L
.31445 .83707 L
.32326 .83812 L
.33195 .83986 L
.34048 .84228 L
.34879 .84536 L
.35683 .84909 L
.36455 .85345 L
.3719 .8584 L
.37885 .86391 L
.38533 .86996 L
.39131 .8765 L
F
0 g
newpath
.3056 .94896 .11224 270 319.792 arc
s
newpath
.20839 .89284 .11224 -30 3.62643 arc
s
newpath
.38336 .9714 .09524 228.626 274.792 arc
s
.95 g
.32041 .10006 m
.32452 .0996 L
.32857 .09873 L
.33251 .09747 L
.33631 .09583 L
.33993 .09382 L
.34334 .09147 L
.3465 .0888 L
.34938 .08582 L
.35195 .08258 L
.3542 .0791 L
.3542 .0791 L
.35691 .08364 L
.35977 .08809 L
.36276 .09245 L
.36589 .09671 L
.36915 .10087 L
.37255 .10492 L
.37606 .10887 L
.3797 .11271 L
.38346 .11643 L
.38733 .12002 L
.39131 .1235 L
.39131 .1235 L
.38435 .12383 L
.37737 .12365 L
.37043 .12295 L
.36356 .12175 L
.3568 .12006 L
.35018 .11787 L
.34373 .1152 L
.3375 .11207 L
.33152 .10849 L
.32581 .10448 L
.32041 .10006 L
F
0 g
newpath
.38336 .0286 .09524 85.2078 131.374 arc
s
newpath
.5 -0.00508 .16836 130.208 150 arc
s
newpath
.31775 .05806 .04209 30 86.3736 arc
s
.95 g
.3542 .9209 m
.35195 .91742 L
.34938 .91418 L
.3465 .9112 L
.34334 .90853 L
.33993 .90618 L
.33631 .90417 L
.33251 .90253 L
.32857 .90127 L
.32452 .9004 L
.32041 .89994 L
.32041 .89994 L
.32637 .8951 L
.33269 .89076 L
.33935 .88695 L
.34629 .88368 L
.35347 .88098 L
.36084 .87887 L
.36836 .87735 L
.37598 .87645 L
.38365 .87617 L
.39131 .8765 L
.39131 .8765 L
.38733 .87998 L
.38346 .88357 L
.3797 .88729 L
.37606 .89113 L
.37255 .89508 L
.36915 .89913 L
.36589 .90329 L
.36276 .90755 L
.35977 .91191 L
.35691 .91636 L
.3542 .9209 L
F
0 g
newpath
.38336 .9714 .09524 228.626 274.792 arc
s
newpath
.5 1.00508 .16836 210 229.792 arc
s
newpath
.31775 .94194 .04209 273.626 330 arc
s
.95 g
.37675 .28653 m
.3056 .16328 L
.3056 .16328 L
.31445 .16293 L
.32326 .16188 L
.33195 .16014 L
.34048 .15772 L
.34879 .15464 L
.35683 .15091 L
.36455 .14655 L
.3719 .1416 L
.37885 .13609 L
.38533 .13004 L
.39131 .1235 L
.39131 .1235 L
.3921 .13444 L
.39264 .14539 L
.39293 .15635 L
.39296 .16732 L
.39274 .17828 L
.39227 .18924 L
.39155 .20018 L
.39057 .2111 L
.38934 .222 L
.38787 .23287 L
.38614 .2437 L
.38416 .25448 L
.38194 .26522 L
.37947 .27591 L
.37675 .28653 L
F
0 g
newpath
-0.08321 .16328 .47619 -4.79218 15 arc
s
newpath
.3056 .05104 .11224 40.2078 90 arc
s
.3056 .16328 m
.37675 .28653 L
s
.95 g
.5 .5 m
.37675 .28653 L
.37675 .28653 L
.37217 .30251 L
.36704 .31831 L
.36135 .33393 L
.35512 .34934 L
.34836 .36453 L
.34108 .37947 L
.33327 .39414 L
.32496 .40854 L
.31616 .42263 L
.30686 .43641 L
.29709 .44986 L
.28686 .46296 L
.27617 .47569 L
.26505 .48804 L
.25351 .5 L
.25351 .5 L
.5 .5 L
F
0 g
.5 .5 m
.37675 .28653 L
s
newpath
-0.08321 .16328 .47619 15 45 arc
s
.25351 .5 m
.5 .5 L
s
.95 g
.5 .5 m
.37675 .71347 L
.37675 .71347 L
.37182 .69636 L
.36626 .67944 L
.36006 .66275 L
.35325 .64629 L
.34582 .63011 L
.3378 .61421 L
.32918 .59862 L
.31999 .58337 L
.31024 .56847 L
.29993 .55395 L
.28909 .53982 L
.27773 .5261 L
.26586 .51283 L
.25351 .5 L
.25351 .5 L
.5 .5 L
F
0 g
.5 .5 m
.37675 .71347 L
s
newpath
-0.08321 .83672 .47619 315 345 arc
s
.25351 .5 m
.5 .5 L
s
.95 g
.37675 .71347 m
.37965 .72486 L
.38227 .73631 L
.38461 .74782 L
.38666 .75939 L
.38842 .77101 L
.3899 .78267 L
.39109 .79435 L
.39199 .80607 L
.3926 .8178 L
.39292 .82955 L
.39296 .8413 L
.3927 .85304 L
.39215 .86478 L
.39131 .8765 L
.39131 .8765 L
.38533 .86996 L
.37885 .86391 L
.3719 .8584 L
.36455 .85345 L
.35683 .84909 L
.34879 .84536 L
.34048 .84228 L
.33195 .83986 L
.32326 .83812 L
.31445 .83707 L
.3056 .83672 L
.3056 .83672 L
.37675 .71347 L
F
0 g
newpath
-0.08321 .83672 .47619 -15 4.79218 arc
s
newpath
.3056 .94896 .11224 270 319.792 arc
s
.3056 .83672 m
.37675 .71347 L
s
.95 g
.38246 .93626 m
.3805 .93354 L
.37828 .93103 L
.37582 .92875 L
.37314 .92673 L
.37028 .92499 L
.36726 .92353 L
.36411 .92239 L
.36086 .92156 L
.35755 .92106 L
.3542 .9209 L
.3542 .9209 L
.35691 .91636 L
.35977 .91191 L
.36276 .90755 L
.36589 .90329 L
.36915 .89913 L
.37255 .89508 L
.37606 .89113 L
.3797 .88729 L
.38346 .88357 L
.38733 .87998 L
.39131 .8765 L
.39131 .8765 L
.39093 .8808 L
.39051 .8851 L
.39006 .88939 L
.38956 .89368 L
.38902 .89797 L
.38845 .90225 L
.38783 .90652 L
.38718 .91079 L
.38649 .91505 L
.38576 .91931 L
.38499 .92356 L
.38419 .9278 L
.38334 .93204 L
.38246 .93626 L
F
0 g
newpath
-0.08321 .83672 .47619 4.79218 12.0663 arc
s
newpath
.5 1.00508 .16836 210 229.792 arc
s
newpath
.3542 .95457 .03367 270 327.066 arc
s
.95 g
.39131 .1235 m
.39096 .11949 L
.39057 .11547 L
.39015 .11147 L
.3897 .10746 L
.38921 .10346 L
.38868 .09946 L
.38813 .09547 L
.38754 .09149 L
.38691 .0875 L
.38625 .08353 L
.38556 .07956 L
.38483 .07559 L
.38408 .07163 L
.38328 .06768 L
.38246 .06374 L
.38246 .06374 L
.38554 .06553 L
.38879 .06703 L
.39216 .06821 L
.39563 .06906 L
.39916 .06957 L
.40273 .06975 L
.4063 .06959 L
.40984 .06908 L
.41331 .06824 L
.41668 .06708 L
.41668 .06708 L
.41573 .07269 L
.41449 .07825 L
.41297 .08374 L
.41117 .08915 L
.4091 .09446 L
.40676 .09965 L
.40417 .10473 L
.40131 .10966 L
.39822 .11444 L
.39488 .11906 L
.39131 .1235 L
F
0 g
newpath
.3056 .05104 .11224 8.21321 40.2078 arc
s
newpath
.4028 .03234 .03741 68.2132 122.934 arc
s
newpath
-0.08321 .16328 .47619 347.934 355.208 arc
s
.95 g
.38246 .93626 m
.38334 .93204 L
.38419 .9278 L
.38499 .92356 L
.38576 .91931 L
.38649 .91505 L
.38718 .91079 L
.38783 .90652 L
.38845 .90225 L
.38902 .89797 L
.38956 .89368 L
.39006 .88939 L
.39051 .8851 L
.39093 .8808 L
.39131 .8765 L
.39131 .8765 L
.39488 .88094 L
.39822 .88556 L
.40131 .89034 L
.40417 .89527 L
.40676 .90035 L
.4091 .90554 L
.41117 .91085 L
.41297 .91626 L
.41449 .92175 L
.41573 .92731 L
.41668 .93292 L
.41668 .93292 L
.41331 .93176 L
.40984 .93092 L
.4063 .93041 L
.40273 .93025 L
.39916 .93043 L
.39563 .93094 L
.39216 .93179 L
.38879 .93297 L
.38554 .93447 L
.38246 .93626 L
F
0 g
newpath
.3056 .94896 .11224 319.792 351.787 arc
s
newpath
.4028 .96766 .03741 237.066 291.787 arc
s
newpath
-0.08321 .83672 .47619 4.79218 12.0663 arc
s
.95 g
.41668 .93292 m
.41472 .93454 L
.41284 .93624 L
.41103 .93803 L
.40931 .9399 L
.40767 .94184 L
.40613 .94385 L
.40467 .94594 L
.40331 .94808 L
.40205 .95029 L
.40089 .95255 L
.40089 .95255 L
.39993 .95017 L
.39872 .9479 L
.39729 .94576 L
.39565 .94379 L
.39381 .94199 L
.3918 .94039 L
.38964 .939 L
.38734 .93784 L
.38494 .93693 L
.38246 .93626 L
.38246 .93626 L
.38554 .93447 L
.38879 .93297 L
.39216 .93179 L
.39563 .93094 L
.39916 .93043 L
.40273 .93025 L
.4063 .93041 L
.40984 .93092 L
.41331 .93176 L
.41668 .93292 L
F
0 g
newpath
.4028 .96766 .03741 237.066 291.787 arc
s
newpath
.37722 .96077 .02506 282.066 340.848 arc
s
newpath
.4514 .97702 .05612 205.848 231.787 arc
s
.95 g
.39131 .1235 m
.39973 .13017 L
.40856 .13629 L
.41776 .14183 L
.42729 .14677 L
.43712 .1511 L
.4472 .15479 L
.4575 .15783 L
.46797 .16021 L
.47858 .16191 L
.48927 .16294 L
.5 .16328 L
.5 .16328 L
.49298 .17489 L
.48551 .1862 L
.47758 .1972 L
.46922 .20788 L
.46043 .21821 L
.45124 .22818 L
.44165 .23777 L
.43168 .24696 L
.42135 .25575 L
.41067 .26411 L
.39967 .27204 L
.38836 .27951 L
.37675 .28653 L
.37675 .28653 L
.37947 .27591 L
.38194 .26522 L
.38416 .25448 L
.38614 .2437 L
.38787 .23287 L
.38934 .222 L
.39057 .2111 L
.39155 .20018 L
.39227 .18924 L
.39274 .17828 L
.39296 .16732 L
.39293 .15635 L
.39264 .14539 L
.3921 .13444 L
.39131 .1235 L
F
0 g
newpath
.20839 -0.00508 .33672 30 60 arc
s
newpath
-0.08321 .16328 .47619 -4.79218 15 arc
s
newpath
.5 -0.00508 .16836 90 130.208 arc
s
.95 g
.5 .83672 m
.48927 .83706 L
.47858 .83809 L
.46797 .83979 L
.4575 .84217 L
.4472 .84521 L
.43712 .8489 L
.42729 .85323 L
.41776 .85817 L
.40856 .86371 L
.39973 .86983 L
.39131 .8765 L
.39131 .8765 L
.3921 .86556 L
.39264 .85461 L
.39293 .84365 L
.39296 .83268 L
.39274 .82172 L
.39227 .81076 L
.39155 .79982 L
.39057 .7889 L
.38934 .778 L
.38787 .76713 L
.38614 .7563 L
.38416 .74552 L
.38194 .73478 L
.37947 .72409 L
.37675 .71347 L
.37675 .71347 L
.38836 .72049 L
.39967 .72796 L
.41067 .73589 L
.42135 .74425 L
.43168 .75304 L
.44165 .76223 L
.45124 .77182 L
.46043 .78179 L
.46922 .79212 L
.47758 .8028 L
.48551 .8138 L
.49298 .82511 L
.5 .83672 L
F
0 g
newpath
.20839 1.00508 .33672 300 330 arc
s
newpath
-0.08321 .83672 .47619 -15 4.79218 arc
s
newpath
.5 1.00508 .16836 229.792 270 arc
s
.95 g
.4376 .95393 m
.43559 .95319 L
.43352 .95268 L
.4314 .95241 L
.42926 .95237 L
.42713 .95258 L
.42504 .95302 L
.42301 .95369 L
.42107 .95459 L
.41924 .9557 L
.41755 .957 L
.41755 .957 L
.41768 .95481 L
.41778 .95262 L
.41783 .95043 L
.41783 .94823 L
.4178 .94604 L
.41772 .94384 L
.4176 .94165 L
.41743 .93946 L
.41723 .93728 L
.41698 .9351 L
.41668 .93292 L
.41668 .93292 L
.41947 .93417 L
.42214 .93564 L
.42468 .93732 L
.42708 .9392 L
.42931 .94127 L
.43137 .94351 L
.43324 .94592 L
.43491 .94847 L
.43637 .95115 L
.4376 .95393 L
F
0 g
newpath
.4028 .96766 .03741 291.787 338.469 arc
s
newpath
.3056 .94896 .11224 -8.21321 4.11189 arc
s
newpath
.43001 .9714 .01905 229.112 293.469 arc
s
.95 g
.41668 .06708 m
.42086 .07006 L
.42528 .07266 L
.42993 .07483 L
.43475 .07658 L
.43971 .07787 L
.44477 .07871 L
.44989 .07908 L
.45502 .07899 L
.46012 .07842 L
.46514 .07739 L
.46514 .07739 L
.46063 .08426 L
.45555 .09071 L
.44993 .0967 L
.44381 .10219 L
.43724 .10712 L
.43027 .11148 L
.42296 .11521 L
.41534 .1183 L
.40749 .12072 L
.39946 .12246 L
.39131 .1235 L
.39131 .1235 L
.39488 .11906 L
.39822 .11444 L
.40131 .10966 L
.40417 .10473 L
.40676 .09965 L
.4091 .09446 L
.41117 .08915 L
.41297 .08374 L
.41449 .07825 L
.41573 .07269 L
.41668 .06708 L
F
0 g
newpath
.38336 .0286 .09524 30.8227 85.2078 arc
s
newpath
.3056 .05104 .11224 8.21321 40.2078 arc
s
newpath
.4514 .02298 .05612 75.8227 128.213 arc
s
.95 g
.46514 .92261 m
.46012 .92158 L
.45502 .92101 L
.44989 .92092 L
.44477 .92129 L
.43971 .92213 L
.43475 .92342 L
.42993 .92517 L
.42528 .92734 L
.42086 .92994 L
.41668 .93292 L
.41668 .93292 L
.41573 .92731 L
.41449 .92175 L
.41297 .91626 L
.41117 .91085 L
.4091 .90554 L
.40676 .90035 L
.40417 .89527 L
.40131 .89034 L
.39822 .88556 L
.39488 .88094 L
.39131 .8765 L
.39131 .8765 L
.40027 .87768 L
.40908 .87971 L
.41766 .88256 L
.42592 .88621 L
.4338 .89062 L
.44123 .89577 L
.44814 .9016 L
.45447 .90805 L
.46015 .91507 L
.46514 .92261 L
F
0 g
newpath
.38336 .9714 .09524 274.792 329.177 arc
s
newpath
.3056 .94896 .11224 319.792 351.787 arc
s
newpath
.4514 .97702 .05612 231.787 284.177 arc
s
.95 g
.41668 .06708 m
.41947 .06583 L
.42214 .06436 L
.42468 .06268 L
.42708 .0608 L
.42931 .05873 L
.43137 .05649 L
.43324 .05408 L
.43491 .05153 L
.43637 .04885 L
.4376 .04607 L
.4376 .04607 L
.43941 .0499 L
.44145 .05361 L
.44372 .05719 L
.44621 .06062 L
.44891 .06389 L
.45181 .06699 L
.45489 .0699 L
.45815 .07261 L
.46157 .07511 L
.46514 .07739 L
.46514 .07739 L
.46012 .07842 L
.45502 .07899 L
.44989 .07908 L
.44477 .07871 L
.43971 .07787 L
.43475 .07658 L
.42993 .07483 L
.42528 .07266 L
.42086 .07006 L
.41668 .06708 L
F
0 g
newpath
.4514 .02298 .05612 75.8227 128.213 arc
s
newpath
.5 .01897 .06803 120.823 156.531 arc
s
newpath
.4028 .03234 .03741 21.5307 68.2132 arc
s
.95 g
.4376 .95393 m
.43637 .95115 L
.43491 .94847 L
.43324 .94592 L
.43137 .94351 L
.42931 .94127 L
.42708 .9392 L
.42468 .93732 L
.42214 .93564 L
.41947 .93417 L
.41668 .93292 L
.41668 .93292 L
.42086 .92994 L
.42528 .92734 L
.42993 .92517 L
.43475 .92342 L
.43971 .92213 L
.44477 .92129 L
.44989 .92092 L
.45502 .92101 L
.46012 .92158 L
.46514 .92261 L
.46514 .92261 L
.46157 .92489 L
.45815 .92739 L
.45489 .9301 L
.45181 .93301 L
.44891 .93611 L
.44621 .93938 L
.44372 .94281 L
.44145 .94639 L
.43941 .9501 L
.4376 .95393 L
F
0 g
newpath
.4514 .97702 .05612 231.787 284.177 arc
s
newpath
.5 .98103 .06803 203.469 239.177 arc
s
newpath
.4028 .96766 .03741 291.787 338.469 arc
s
.95 g
.39131 .1235 m
.39973 .13017 L
.40856 .13629 L
.41776 .14183 L
.42729 .14677 L
.43712 .1511 L
.4472 .15479 L
.4575 .15783 L
.46797 .16021 L
.47858 .16191 L
.48927 .16294 L
.5 .16328 L
.5 .16328 L
.49649 .15705 L
.49311 .15075 L
.48987 .14437 L
.48676 .13793 L
.48379 .13142 L
.48096 .12485 L
.47828 .11822 L
.47573 .11154 L
.47332 .1048 L
.47106 .09802 L
.46894 .09119 L
.46697 .08431 L
.46514 .07739 L
.46514 .07739 L
.46015 .08493 L
.45447 .09195 L
.44814 .0984 L
.44123 .10423 L
.4338 .10938 L
.42592 .11379 L
.41766 .11744 L
.40908 .12029 L
.40027 .12232 L
.39131 .1235 L
F
0 g
newpath
.79161 -0.00508 .33672 150 165.823 arc
s
newpath
.38336 .0286 .09524 30.8227 85.2078 arc
s
newpath
.5 -0.00508 .16836 90 130.208 arc
s
.95 g
.5 .83672 m
.48927 .83706 L
.47858 .83809 L
.46797 .83979 L
.4575 .84217 L
.4472 .84521 L
.43712 .8489 L
.42729 .85323 L
.41776 .85817 L
.40856 .86371 L
.39973 .86983 L
.39131 .8765 L
.39131 .8765 L
.40027 .87768 L
.40908 .87971 L
.41766 .88256 L
.42592 .88621 L
.4338 .89062 L
.44123 .89577 L
.44814 .9016 L
.45447 .90805 L
.46015 .91507 L
.46514 .92261 L
.46514 .92261 L
.46697 .91569 L
.46894 .90881 L
.47106 .90198 L
.47332 .8952 L
.47573 .88846 L
.47828 .88178 L
.48096 .87515 L
.48379 .86858 L
.48676 .86207 L
.48987 .85563 L
.49311 .84925 L
.49649 .84295 L
.5 .83672 L
F
0 g
newpath
.79161 1.00508 .33672 194.177 210 arc
s
newpath
.38336 .9714 .09524 274.792 329.177 arc
s
newpath
.5 1.00508 .16836 229.792 270 arc
s
.95 g
.46514 .92261 m
.46449 .92522 L
.46387 .92784 L
.46326 .93047 L
.46267 .9331 L
.4621 .93574 L
.46156 .93838 L
.46104 .94102 L
.46053 .94367 L
.46005 .94633 L
.45959 .94898 L
.45916 .95164 L
.45874 .95431 L
.45834 .95697 L
.45834 .95697 L
.45655 .95571 L
.45464 .95464 L
.45262 .95377 L
.45053 .95312 L
.44838 .95269 L
.44619 .95248 L
.444 .95251 L
.44182 .95276 L
.43968 .95324 L
.4376 .95393 L
.4376 .95393 L
.43941 .9501 L
.44145 .94639 L
.44372 .94281 L
.44621 .93938 L
.44891 .93611 L
.45181 .93301 L
.45489 .9301 L
.45815 .92739 L
.46157 .92489 L
.46514 .92261 L
F
0 g
newpath
.5 .98103 .06803 203.469 239.177 arc
s
newpath
.44532 .97351 .02104 248.469 308.213 arc
s
newpath
.79161 1.00508 .33672 188.213 194.177 arc
s
.95 g
.5 .94896 m
.49746 .94907 L
.49493 .94942 L
.49245 .94999 L
.49003 .95079 L
.48769 .9518 L
.48546 .95302 L
.48334 .95444 L
.48136 .95604 L
.47954 .95782 L
.47788 .95975 L
.47788 .95975 L
.47737 .95619 L
.47673 .95265 L
.47596 .94914 L
.47505 .94566 L
.47401 .94222 L
.47285 .93882 L
.47155 .93547 L
.47014 .93216 L
.46859 .92891 L
.46693 .92573 L
.46514 .92261 L
.46514 .92261 L
.46945 .92388 L
.47363 .92549 L
.47768 .92743 L
.48156 .92969 L
.48524 .93225 L
.48871 .9351 L
.49194 .93821 L
.49491 .94157 L
.4976 .94516 L
.5 .94896 L
F
0 g
newpath
.4514 .97702 .05612 284.177 330 arc
s
newpath
.38336 .9714 .09524 329.177 352.972 arc
s
newpath
.5 .97702 .02806 217.972 270 arc
s
.95 g
.46514 .07739 m
.46945 .07612 L
.47363 .07451 L
.47768 .07257 L
.48156 .07031 L
.48524 .06775 L
.48871 .0649 L
.49194 .06179 L
.49491 .05843 L
.4976 .05484 L
.5 .05104 L
.5 .05104 L
.5024 .05484 L
.50509 .05843 L
.50806 .06179 L
.51129 .0649 L
.51476 .06775 L
.51844 .07031 L
.52232 .07257 L
.52637 .07451 L
.53055 .07612 L
.53486 .07739 L
.53486 .07739 L
.52838 .0808 L
.52158 .08349 L
.51453 .08543 L
.50731 .08661 L
.5 .087 L
.49269 .08661 L
.48547 .08543 L
.47842 .08349 L
.47162 .0808 L
.46514 .07739 L
F
0 g
newpath
.5 .01897 .06803 59.1773 120.823 arc
s
newpath
.5486 .02298 .05612 104.177 150 arc
s
newpath
.4514 .02298 .05612 30 75.8227 arc
s
.95 g
.46514 .07739 m
.47162 .0808 L
.47842 .08349 L
.48547 .08543 L
.49269 .08661 L
.5 .087 L
.50731 .08661 L
.51453 .08543 L
.52158 .08349 L
.52838 .0808 L
.53486 .07739 L
.53486 .07739 L
.53303 .08431 L
.53106 .09119 L
.52894 .09802 L
.52668 .1048 L
.52427 .11154 L
.52172 .11822 L
.51904 .12485 L
.51621 .13142 L
.51324 .13793 L
.51013 .14437 L
.50689 .15075 L
.50351 .15705 L
.5 .16328 L
.5 .16328 L
.49649 .15705 L
.49311 .15075 L
.48987 .14437 L
.48676 .13793 L
.48379 .13142 L
.48096 .12485 L
.47828 .11822 L
.47573 .11154 L
.47332 .1048 L
.47106 .09802 L
.46894 .09119 L
.46697 .08431 L
.46514 .07739 L
F
0 g
newpath
.20839 -0.00508 .33672 14.1773 30 arc
s
newpath
.79161 -0.00508 .33672 150 165.823 arc
s
newpath
.5 .01897 .06803 59.1773 120.823 arc
s
.95 g
.37675 .28653 m
.39288 .29055 L
.40914 .29401 L
.42551 .29689 L
.44197 .29921 L
.4585 .30094 L
.47508 .3021 L
.49169 .30268 L
.50831 .30268 L
.52492 .3021 L
.5415 .30094 L
.55803 .29921 L
.57449 .29689 L
.59086 .29401 L
.60712 .29055 L
.62325 .28653 L
.62325 .28653 L
.61164 .27951 L
.60033 .27204 L
.58933 .26411 L
.57865 .25575 L
.56832 .24696 L
.55835 .23777 L
.54876 .22818 L
.53957 .21821 L
.53078 .20788 L
.52242 .1972 L
.51449 .1862 L
.50702 .17489 L
.5 .16328 L
.5 .16328 L
.49298 .17489 L
.48551 .1862 L
.47758 .1972 L
.46922 .20788 L
.46043 .21821 L
.45124 .22818 L
.44165 .23777 L
.43168 .24696 L
.42135 .25575 L
.41067 .26411 L
.39967 .27204 L
.38836 .27951 L
.37675 .28653 L
F
0 g
newpath
.79161 -0.00508 .33672 120 150 arc
s
newpath
.20839 -0.00508 .33672 30 60 arc
s
newpath
.5 -0.17344 .47619 75 105 arc
s
.95 g
.37675 .28653 m
.39288 .29055 L
.40914 .29401 L
.42551 .29689 L
.44197 .29921 L
.4585 .30094 L
.47508 .3021 L
.49169 .30268 L
.50831 .30268 L
.52492 .3021 L
.5415 .30094 L
.55803 .29921 L
.57449 .29689 L
.59086 .29401 L
.60712 .29055 L
.62325 .28653 L
.62325 .28653 L
.5 .5 L
.5 .5 L
.37675 .28653 L
F
0 g
.62325 .28653 m
.5 .5 L
s
.5 .5 m
.37675 .28653 L
s
newpath
.5 -0.17344 .47619 75 105 arc
s
.95 g
.62325 .71347 m
.5 .5 L
.5 .5 L
.37675 .71347 L
.37675 .71347 L
.39404 .70918 L
.41147 .70555 L
.42903 .70256 L
.44668 .70024 L
.46441 .69858 L
.48219 .69758 L
.5 .69724 L
.51781 .69758 L
.53559 .69858 L
.55332 .70024 L
.57097 .70256 L
.58853 .70555 L
.60596 .70918 L
.62325 .71347 L
F
0 g
.62325 .71347 m
.5 .5 L
s
.5 .5 m
.37675 .71347 L
s
newpath
.5 1.17344 .47619 255 285 arc
s
.95 g
.62325 .71347 m
.60712 .70945 L
.59086 .70599 L
.57449 .70311 L
.55803 .70079 L
.5415 .69906 L
.52492 .6979 L
.50831 .69732 L
.49169 .69732 L
.47508 .6979 L
.4585 .69906 L
.44197 .70079 L
.42551 .70311 L
.40914 .70599 L
.39288 .70945 L
.37675 .71347 L
.37675 .71347 L
.38836 .72049 L
.39967 .72796 L
.41067 .73589 L
.42135 .74425 L
.43168 .75304 L
.44165 .76223 L
.45124 .77182 L
.46043 .78179 L
.46922 .79212 L
.47758 .8028 L
.48551 .8138 L
.49298 .82511 L
.5 .83672 L
.5 .83672 L
.50702 .82511 L
.51449 .8138 L
.52242 .8028 L
.53078 .79212 L
.53957 .78179 L
.54876 .77182 L
.55835 .76223 L
.56832 .75304 L
.57865 .74425 L
.58933 .73589 L
.60033 .72796 L
.61164 .72049 L
.62325 .71347 L
F
0 g
newpath
.79161 1.00508 .33672 210 240 arc
s
newpath
.20839 1.00508 .33672 300 330 arc
s
newpath
.5 1.17344 .47619 255 285 arc
s
.95 g
.53486 .92261 m
.52838 .9192 L
.52158 .91651 L
.51453 .91457 L
.50731 .91339 L
.5 .913 L
.49269 .91339 L
.48547 .91457 L
.47842 .91651 L
.47162 .9192 L
.46514 .92261 L
.46514 .92261 L
.46697 .91569 L
.46894 .90881 L
.47106 .90198 L
.47332 .8952 L
.47573 .88846 L
.47828 .88178 L
.48096 .87515 L
.48379 .86858 L
.48676 .86207 L
.48987 .85563 L
.49311 .84925 L
.49649 .84295 L
.5 .83672 L
.5 .83672 L
.50351 .84295 L
.50689 .84925 L
.51013 .85563 L
.51324 .86207 L
.51621 .86858 L
.51904 .87515 L
.52172 .88178 L
.52427 .88846 L
.52668 .8952 L
.52894 .90198 L
.53106 .90881 L
.53303 .91569 L
.53486 .92261 L
F
0 g
newpath
.20839 1.00508 .33672 330 345.823 arc
s
newpath
.79161 1.00508 .33672 194.177 210 arc
s
newpath
.5 .98103 .06803 239.177 300.823 arc
s
.95 g
.5 .94896 m
.4976 .94516 L
.49491 .94157 L
.49194 .93821 L
.48871 .9351 L
.48524 .93225 L
.48156 .92969 L
.47768 .92743 L
.47363 .92549 L
.46945 .92388 L
.46514 .92261 L
.46514 .92261 L
.47162 .9192 L
.47842 .91651 L
.48547 .91457 L
.49269 .91339 L
.5 .913 L
.50731 .91339 L
.51453 .91457 L
.52158 .91651 L
.52838 .9192 L
.53486 .92261 L
.53486 .92261 L
.53055 .92388 L
.52637 .92549 L
.52232 .92743 L
.51844 .92969 L
.51476 .93225 L
.51129 .9351 L
.50806 .93821 L
.50509 .94157 L
.5024 .94516 L
.5 .94896 L
F
0 g
newpath
.5 .98103 .06803 239.177 300.823 arc
s
newpath
.5486 .97702 .05612 210 255.823 arc
s
newpath
.4514 .97702 .05612 284.177 330 arc
s
.95 g
.53486 .92261 m
.53307 .92573 L
.53141 .92891 L
.52986 .93216 L
.52845 .93547 L
.52715 .93882 L
.52599 .94222 L
.52495 .94566 L
.52404 .94914 L
.52327 .95265 L
.52263 .95619 L
.52212 .95975 L
.52212 .95975 L
.52046 .95782 L
.51864 .95604 L
.51666 .95444 L
.51454 .95302 L
.51231 .9518 L
.50997 .95079 L
.50755 .94999 L
.50507 .94942 L
.50254 .94907 L
.5 .94896 L
.5 .94896 L
.5024 .94516 L
.50509 .94157 L
.50806 .93821 L
.51129 .9351 L
.51476 .93225 L
.51844 .92969 L
.52232 .92743 L
.52637 .92549 L
.53055 .92388 L
.53486 .92261 L
F
0 g
newpath
.5486 .97702 .05612 210 255.823 arc
s
newpath
.5 .97702 .02806 270 322.028 arc
s
newpath
.61664 .9714 .09524 187.028 210.823 arc
s
.95 g
.5624 .95393 m
.56032 .95324 L
.55818 .95276 L
.556 .95251 L
.55381 .95248 L
.55162 .95269 L
.54947 .95312 L
.54738 .95377 L
.54536 .95464 L
.54345 .95571 L
.54166 .95697 L
.54166 .95697 L
.54126 .95431 L
.54084 .95164 L
.54041 .94898 L
.53995 .94633 L
.53947 .94367 L
.53896 .94102 L
.53844 .93838 L
.5379 .93574 L
.53733 .9331 L
.53674 .93047 L
.53613 .92784 L
.53551 .92522 L
.53486 .92261 L
.53486 .92261 L
.53843 .92489 L
.54185 .92739 L
.54511 .9301 L
.54819 .93301 L
.55109 .93611 L
.55379 .93938 L
.55628 .94281 L
.55855 .94639 L
.56059 .9501 L
.5624 .95393 L
F
0 g
newpath
.5 .98103 .06803 300.823 336.531 arc
s
newpath
.20839 1.00508 .33672 345.823 351.787 arc
s
newpath
.55468 .97351 .02104 231.787 291.531 arc
s
.95 g
.5 .16328 m
.50351 .15705 L
.50689 .15075 L
.51013 .14437 L
.51324 .13793 L
.51621 .13142 L
.51904 .12485 L
.52172 .11822 L
.52427 .11154 L
.52668 .1048 L
.52894 .09802 L
.53106 .09119 L
.53303 .08431 L
.53486 .07739 L
.53486 .07739 L
.53937 .08426 L
.54445 .09071 L
.55007 .0967 L
.55619 .10219 L
.56276 .10712 L
.56973 .11148 L
.57704 .11521 L
.58466 .1183 L
.59251 .12072 L
.60054 .12246 L
.60869 .1235 L
.60869 .1235 L
.60027 .13017 L
.59144 .13629 L
.58224 .14183 L
.57271 .14677 L
.56288 .1511 L
.5528 .15479 L
.5425 .15783 L
.53203 .16021 L
.52142 .16191 L
.51073 .16294 L
.5 .16328 L
F
0 g
newpath
.5 -0.00508 .16836 49.7922 90 arc
s
newpath
.61664 .0286 .09524 94.7922 149.177 arc
s
newpath
.20839 -0.00508 .33672 14.1773 30 arc
s
.95 g
.53486 .92261 m
.53303 .91569 L
.53106 .90881 L
.52894 .90198 L
.52668 .8952 L
.52427 .88846 L
.52172 .88178 L
.51904 .87515 L
.51621 .86858 L
.51324 .86207 L
.51013 .85563 L
.50689 .84925 L
.50351 .84295 L
.5 .83672 L
.5 .83672 L
.51073 .83706 L
.52142 .83809 L
.53203 .83979 L
.5425 .84217 L
.5528 .84521 L
.56288 .8489 L
.57271 .85323 L
.58224 .85817 L
.59144 .86371 L
.60027 .86983 L
.60869 .8765 L
.60869 .8765 L
.60054 .87754 L
.59251 .87928 L
.58466 .8817 L
.57704 .88479 L
.56973 .88852 L
.56276 .89288 L
.55619 .89781 L
.55007 .9033 L
.54445 .90929 L
.53937 .91574 L
.53486 .92261 L
F
0 g
newpath
.5 1.00508 .16836 270 310.208 arc
s
newpath
.61664 .9714 .09524 210.823 265.208 arc
s
newpath
.20839 1.00508 .33672 330 345.823 arc
s
.95 g
.53486 .07739 m
.53843 .07511 L
.54185 .07261 L
.54511 .0699 L
.54819 .06699 L
.55109 .06389 L
.55379 .06062 L
.55628 .05719 L
.55855 .05361 L
.56059 .0499 L
.5624 .04607 L
.5624 .04607 L
.56363 .04885 L
.56509 .05153 L
.56676 .05408 L
.56863 .05649 L
.57069 .05873 L
.57292 .0608 L
.57532 .06268 L
.57786 .06436 L
.58053 .06583 L
.58332 .06708 L
.58332 .06708 L
.57914 .07006 L
.57472 .07266 L
.57007 .07483 L
.56525 .07658 L
.56029 .07787 L
.55523 .07871 L
.55011 .07908 L
.54498 .07899 L
.53988 .07842 L
.53486 .07739 L
F
0 g
newpath
.5486 .02298 .05612 51.7868 104.177 arc
s
newpath
.5972 .03234 .03741 111.787 158.469 arc
s
newpath
.5 .01897 .06803 23.4693 59.1773 arc
s
.95 g
.5624 .95393 m
.56059 .9501 L
.55855 .94639 L
.55628 .94281 L
.55379 .93938 L
.55109 .93611 L
.54819 .93301 L
.54511 .9301 L
.54185 .92739 L
.53843 .92489 L
.53486 .92261 L
.53486 .92261 L
.53988 .92158 L
.54498 .92101 L
.55011 .92092 L
.55523 .92129 L
.56029 .92213 L
.56525 .92342 L
.57007 .92517 L
.57472 .92734 L
.57914 .92994 L
.58332 .93292 L
.58332 .93292 L
.58053 .93417 L
.57786 .93564 L
.57532 .93732 L
.57292 .9392 L
.57069 .94127 L
.56863 .94351 L
.56676 .94592 L
.56509 .94847 L
.56363 .95115 L
.5624 .95393 L
F
0 g
newpath
.5486 .97702 .05612 255.823 308.213 arc
s
newpath
.5972 .96766 .03741 201.531 248.213 arc
s
newpath
.5 .98103 .06803 300.823 336.531 arc
s
.95 g
.58332 .06708 m
.58427 .07269 L
.58551 .07825 L
.58703 .08374 L
.58883 .08915 L
.5909 .09446 L
.59324 .09965 L
.59583 .10473 L
.59869 .10966 L
.60178 .11444 L
.60512 .11906 L
.60869 .1235 L
.60869 .1235 L
.59973 .12232 L
.59092 .12029 L
.58234 .11744 L
.57408 .11379 L
.5662 .10938 L
.55877 .10423 L
.55186 .0984 L
.54553 .09195 L
.53985 .08493 L
.53486 .07739 L
.53486 .07739 L
.53988 .07842 L
.54498 .07899 L
.55011 .07908 L
.55523 .07871 L
.56029 .07787 L
.56525 .07658 L
.57007 .07483 L
.57472 .07266 L
.57914 .07006 L
.58332 .06708 L
F
0 g
newpath
.61664 .0286 .09524 94.7922 149.177 arc
s
newpath
.5486 .02298 .05612 51.7868 104.177 arc
s
newpath
.6944 .05104 .11224 139.792 171.787 arc
s
.95 g
.58332 .93292 m
.58427 .92731 L
.58551 .92175 L
.58703 .91626 L
.58883 .91085 L
.5909 .90554 L
.59324 .90035 L
.59583 .89527 L
.59869 .89034 L
.60178 .88556 L
.60512 .88094 L
.60869 .8765 L
.60869 .8765 L
.59973 .87768 L
.59092 .87971 L
.58234 .88256 L
.57408 .88621 L
.5662 .89062 L
.55877 .89577 L
.55186 .9016 L
.54553 .90805 L
.53985 .91507 L
.53486 .92261 L
.53486 .92261 L
.53988 .92158 L
.54498 .92101 L
.55011 .92092 L
.55523 .92129 L
.56029 .92213 L
.56525 .92342 L
.57007 .92517 L
.57472 .92734 L
.57914 .92994 L
.58332 .93292 L
F
0 g
newpath
.6944 .94896 .11224 188.213 220.208 arc
s
newpath
.61664 .9714 .09524 210.823 265.208 arc
s
newpath
.5486 .97702 .05612 255.823 308.213 arc
s
.95 g
.58332 .93292 m
.58302 .9351 L
.58277 .93728 L
.58257 .93946 L
.5824 .94165 L
.58228 .94384 L
.5822 .94604 L
.58217 .94823 L
.58217 .95043 L
.58222 .95262 L
.58232 .95481 L
.58245 .957 L
.58245 .957 L
.58076 .9557 L
.57893 .95459 L
.57699 .95369 L
.57496 .95302 L
.57287 .95258 L
.57074 .95237 L
.5686 .95241 L
.56648 .95268 L
.56441 .95319 L
.5624 .95393 L
.5624 .95393 L
.56363 .95115 L
.56509 .94847 L
.56676 .94592 L
.56863 .94351 L
.57069 .94127 L
.57292 .9392 L
.57532 .93732 L
.57786 .93564 L
.58053 .93417 L
.58332 .93292 L
F
0 g
newpath
.5972 .96766 .03741 201.531 248.213 arc
s
newpath
.56999 .9714 .01905 246.531 310.888 arc
s
newpath
.6944 .94896 .11224 175.888 188.213 arc
s
.95 g
.5 .16328 m
.50702 .17489 L
.51449 .1862 L
.52242 .1972 L
.53078 .20788 L
.53957 .21821 L
.54876 .22818 L
.55835 .23777 L
.56832 .24696 L
.57865 .25575 L
.58933 .26411 L
.60033 .27204 L
.61164 .27951 L
.62325 .28653 L
.62325 .28653 L
.62035 .27514 L
.61773 .26369 L
.61539 .25218 L
.61334 .24061 L
.61158 .22899 L
.6101 .21733 L
.60891 .20565 L
.60801 .19393 L
.6074 .1822 L
.60708 .17045 L
.60704 .1587 L
.6073 .14696 L
.60785 .13522 L
.60869 .1235 L
.60869 .1235 L
.60027 .13017 L
.59144 .13629 L
.58224 .14183 L
.57271 .14677 L
.56288 .1511 L
.5528 .15479 L
.5425 .15783 L
.53203 .16021 L
.52142 .16191 L
.51073 .16294 L
.5 .16328 L
F
0 g
newpath
1.08321 .16328 .47619 165 184.792 arc
s
newpath
.79161 -0.00508 .33672 120 150 arc
s
newpath
.5 -0.00508 .16836 49.7922 90 arc
s
.95 g
.60869 .8765 m
.60785 .86478 L
.6073 .85304 L
.60704 .8413 L
.60708 .82955 L
.6074 .8178 L
.60801 .80607 L
.60891 .79435 L
.6101 .78267 L
.61158 .77101 L
.61334 .75939 L
.61539 .74782 L
.61773 .73631 L
.62035 .72486 L
.62325 .71347 L
.62325 .71347 L
.61164 .72049 L
.60033 .72796 L
.58933 .73589 L
.57865 .74425 L
.56832 .75304 L
.55835 .76223 L
.54876 .77182 L
.53957 .78179 L
.53078 .79212 L
.52242 .8028 L
.51449 .8138 L
.50702 .82511 L
.5 .83672 L
.5 .83672 L
.51073 .83706 L
.52142 .83809 L
.53203 .83979 L
.5425 .84217 L
.5528 .84521 L
.56288 .8489 L
.57271 .85323 L
.58224 .85817 L
.59144 .86371 L
.60027 .86983 L
.60869 .8765 L
F
0 g
newpath
1.08321 .83672 .47619 175.208 195 arc
s
newpath
.79161 1.00508 .33672 210 240 arc
s
newpath
.5 1.00508 .16836 270 310.208 arc
s
.95 g
.61754 .93626 m
.61506 .93693 L
.61266 .93784 L
.61036 .939 L
.6082 .94039 L
.60619 .94199 L
.60435 .94379 L
.60271 .94576 L
.60128 .9479 L
.60007 .95017 L
.59911 .95255 L
.59911 .95255 L
.59795 .95029 L
.59669 .94808 L
.59533 .94594 L
.59387 .94385 L
.59233 .94184 L
.59069 .9399 L
.58897 .93803 L
.58716 .93624 L
.58528 .93454 L
.58332 .93292 L
.58332 .93292 L
.58669 .93176 L
.59016 .93092 L
.5937 .93041 L
.59727 .93025 L
.60084 .93043 L
.60437 .93094 L
.60784 .93179 L
.61121 .93297 L
.61446 .93447 L
.61754 .93626 L
F
0 g
newpath
.5972 .96766 .03741 248.213 302.934 arc
s
newpath
.5486 .97702 .05612 308.213 334.152 arc
s
newpath
.62278 .96077 .02506 199.152 257.934 arc
s
.95 g
.58332 .06708 m
.58669 .06824 L
.59016 .06908 L
.5937 .06959 L
.59727 .06975 L
.60084 .06957 L
.60437 .06906 L
.60784 .06821 L
.61121 .06703 L
.61446 .06553 L
.61754 .06374 L
.61754 .06374 L
.61672 .06768 L
.61592 .07163 L
.61517 .07559 L
.61444 .07956 L
.61375 .08353 L
.61309 .0875 L
.61246 .09149 L
.61187 .09547 L
.61132 .09946 L
.61079 .10346 L
.6103 .10746 L
.60985 .11147 L
.60943 .11547 L
.60904 .11949 L
.60869 .1235 L
.60869 .1235 L
.60512 .11906 L
.60178 .11444 L
.59869 .10966 L
.59583 .10473 L
.59324 .09965 L
.5909 .09446 L
.58883 .08915 L
.58703 .08374 L
.58551 .07825 L
.58427 .07269 L
.58332 .06708 L
F
0 g
newpath
.6944 .05104 .11224 139.792 171.787 arc
s
newpath
1.08321 .16328 .47619 184.792 192.066 arc
s
newpath
.5972 .03234 .03741 57.0663 111.787 arc
s
.95 g
.61754 .93626 m
.61446 .93447 L
.61121 .93297 L
.60784 .93179 L
.60437 .93094 L
.60084 .93043 L
.59727 .93025 L
.5937 .93041 L
.59016 .93092 L
.58669 .93176 L
.58332 .93292 L
.58332 .93292 L
.58427 .92731 L
.58551 .92175 L
.58703 .91626 L
.58883 .91085 L
.5909 .90554 L
.59324 .90035 L
.59583 .89527 L
.59869 .89034 L
.60178 .88556 L
.60512 .88094 L
.60869 .8765 L
.60869 .8765 L
.60907 .8808 L
.60949 .8851 L
.60994 .88939 L
.61044 .89368 L
.61098 .89797 L
.61155 .90225 L
.61217 .90652 L
.61282 .91079 L
.61351 .91505 L
.61424 .91931 L
.61501 .92356 L
.61581 .9278 L
.61666 .93204 L
.61754 .93626 L
F
0 g
newpath
.6944 .94896 .11224 188.213 220.208 arc
s
newpath
1.08321 .83672 .47619 167.934 175.208 arc
s
newpath
.5972 .96766 .03741 248.213 302.934 arc
s
.95 g
.6458 .9209 m
.64245 .92106 L
.63914 .92156 L
.63589 .92239 L
.63274 .92353 L
.62972 .92499 L
.62686 .92673 L
.62418 .92875 L
.62172 .93103 L
.6195 .93354 L
.61754 .93626 L
.61754 .93626 L
.61672 .93232 L
.61592 .92837 L
.61517 .92441 L
.61444 .92044 L
.61375 .91647 L
.61309 .9125 L
.61246 .90851 L
.61187 .90453 L
.61132 .90054 L
.61079 .89654 L
.6103 .89254 L
.60985 .88853 L
.60943 .88453 L
.60904 .88051 L
.60869 .8765 L
.60869 .8765 L
.61267 .87998 L
.61654 .88357 L
.6203 .88729 L
.62394 .89113 L
.62745 .89508 L
.63085 .89913 L
.63411 .90329 L
.63724 .90755 L
.64023 .91191 L
.64309 .91636 L
.6458 .9209 L
F
0 g
newpath
.5 1.00508 .16836 310.208 330 arc
s
newpath
1.08321 .83672 .47619 167.934 175.208 arc
s
newpath
.6458 .95457 .03367 212.934 270 arc
s
.95 g
.60869 .1235 m
.60785 .13522 L
.6073 .14696 L
.60704 .1587 L
.60708 .17045 L
.6074 .1822 L
.60801 .19393 L
.60891 .20565 L
.6101 .21733 L
.61158 .22899 L
.61334 .24061 L
.61539 .25218 L
.61773 .26369 L
.62035 .27514 L
.62325 .28653 L
.62325 .28653 L
.6944 .16328 L
.6944 .16328 L
.68555 .16293 L
.67674 .16188 L
.66805 .16014 L
.65952 .15772 L
.65121 .15464 L
.64317 .15091 L
.63545 .14655 L
.6281 .1416 L
.62115 .13609 L
.61467 .13004 L
.60869 .1235 L
F
0 g
.62325 .28653 m
.6944 .16328 L
s
newpath
.6944 .05104 .11224 90 139.792 arc
s
newpath
1.08321 .16328 .47619 165 184.792 arc
s
.95 g
.74649 .5 m
.73495 .48804 L
.72383 .47569 L
.71314 .46296 L
.70291 .44986 L
.69314 .43641 L
.68384 .42263 L
.67504 .40854 L
.66673 .39414 L
.65892 .37947 L
.65164 .36453 L
.64488 .34934 L
.63865 .33393 L
.63296 .31831 L
.62783 .30251 L
.62325 .28653 L
.62325 .28653 L
.5 .5 L
.5 .5 L
.74649 .5 L
F
0 g
newpath
1.08321 .16328 .47619 135 165 arc
s
.62325 .28653 m
.5 .5 L
s
.5 .5 m
.74649 .5 L
s
.95 g
.74649 .5 m
.5 .5 L
.5 .5 L
.62325 .71347 L
.62325 .71347 L
.62818 .69636 L
.63374 .67944 L
.63994 .66275 L
.64675 .64629 L
.65418 .63011 L
.6622 .61421 L
.67082 .59862 L
.68001 .58337 L
.68976 .56847 L
.70007 .55395 L
.71091 .53982 L
.72227 .5261 L
.73414 .51283 L
.74649 .5 L
F
0 g
newpath
1.08321 .83672 .47619 195 225 arc
s
.62325 .71347 m
.5 .5 L
s
.5 .5 m
.74649 .5 L
s
.95 g
.62325 .71347 m
.6944 .83672 L
.6944 .83672 L
.68555 .83707 L
.67674 .83812 L
.66805 .83986 L
.65952 .84228 L
.65121 .84536 L
.64317 .84909 L
.63545 .85345 L
.6281 .8584 L
.62115 .86391 L
.61467 .86996 L
.60869 .8765 L
.60869 .8765 L
.60785 .86478 L
.6073 .85304 L
.60704 .8413 L
.60708 .82955 L
.6074 .8178 L
.60801 .80607 L
.60891 .79435 L
.6101 .78267 L
.61158 .77101 L
.61334 .75939 L
.61539 .74782 L
.61773 .73631 L
.62035 .72486 L
.62325 .71347 L
F
0 g
.62325 .71347 m
.6944 .83672 L
s
newpath
.6944 .94896 .11224 220.208 270 arc
s
newpath
1.08321 .83672 .47619 175.208 195 arc
s
.95 g
.60869 .1235 m
.61267 .12002 L
.61654 .11643 L
.6203 .11271 L
.62394 .10887 L
.62745 .10492 L
.63085 .10087 L
.63411 .09671 L
.63724 .09245 L
.64023 .08809 L
.64309 .08364 L
.6458 .0791 L
.6458 .0791 L
.64805 .08258 L
.65062 .08582 L
.6535 .0888 L
.65666 .09147 L
.66007 .09382 L
.66369 .09583 L
.66749 .09747 L
.67143 .09873 L
.67548 .0996 L
.67959 .10006 L
.67959 .10006 L
.67419 .10448 L
.66848 .10849 L
.6625 .11207 L
.65627 .1152 L
.64982 .11787 L
.6432 .12006 L
.63644 .12175 L
.62957 .12295 L
.62263 .12365 L
.61565 .12383 L
.60869 .1235 L
F
0 g
newpath
.61664 .0286 .09524 48.6264 94.7922 arc
s
newpath
.68225 .05806 .04209 93.6264 150 arc
s
newpath
.5 -0.00508 .16836 30 49.7922 arc
s
.95 g
.6458 .9209 m
.64309 .91636 L
.64023 .91191 L
.63724 .90755 L
.63411 .90329 L
.63085 .89913 L
.62745 .89508 L
.62394 .89113 L
.6203 .88729 L
.61654 .88357 L
.61267 .87998 L
.60869 .8765 L
.60869 .8765 L
.61565 .87617 L
.62263 .87635 L
.62957 .87705 L
.63644 .87825 L
.6432 .87994 L
.64982 .88213 L
.65627 .8848 L
.6625 .88793 L
.66848 .89151 L
.67419 .89552 L
.67959 .89994 L
.67959 .89994 L
.67548 .9004 L
.67143 .90127 L
.66749 .90253 L
.66369 .90417 L
.66007 .90618 L
.65666 .90853 L
.6535 .9112 L
.65062 .91418 L
.64805 .91742 L
.6458 .9209 L
F
0 g
newpath
.61664 .9714 .09524 265.208 311.374 arc
s
newpath
.68225 .94194 .04209 210 266.374 arc
s
newpath
.5 1.00508 .16836 310.208 330 arc
s
.95 g
.67959 .10006 m
.67937 .10605 L
.67947 .11203 L
.67989 .11801 L
.68063 .12395 L
.68168 .12984 L
.68305 .13567 L
.68472 .14142 L
.6867 .14707 L
.68898 .15261 L
.69155 .15802 L
.6944 .16328 L
.6944 .16328 L
.68555 .16293 L
.67674 .16188 L
.66805 .16014 L
.65952 .15772 L
.65121 .15464 L
.64317 .15091 L
.63545 .14655 L
.6281 .1416 L
.62115 .13609 L
.61467 .13004 L
.60869 .1235 L
.60869 .1235 L
.61565 .12383 L
.62263 .12365 L
.62957 .12295 L
.63644 .12175 L
.6432 .12006 L
.64982 .11787 L
.65627 .1152 L
.6625 .11207 L
.66848 .10849 L
.67419 .10448 L
.67959 .10006 L
F
0 g
newpath
.6944 .05104 .11224 90 139.792 arc
s
newpath
.61664 .0286 .09524 48.6264 94.7922 arc
s
newpath
.79161 .10716 .11224 150 183.626 arc
s
.95 g
.67959 .89994 m
.67937 .89395 L
.67947 .88797 L
.67989 .88199 L
.68063 .87605 L
.68168 .87016 L
.68305 .86433 L
.68472 .85858 L
.6867 .85293 L
.68898 .84739 L
.69155 .84198 L
.6944 .83672 L
.6944 .83672 L
.68555 .83707 L
.67674 .83812 L
.66805 .83986 L
.65952 .84228 L
.65121 .84536 L
.64317 .84909 L
.63545 .85345 L
.6281 .8584 L
.62115 .86391 L
.61467 .86996 L
.60869 .8765 L
.60869 .8765 L
.61565 .87617 L
.62263 .87635 L
.62957 .87705 L
.63644 .87825 L
.6432 .87994 L
.64982 .88213 L
.65627 .8848 L
.6625 .88793 L
.66848 .89151 L
.67419 .89552 L
.67959 .89994 L
F
0 g
newpath
.79161 .89284 .11224 176.374 210 arc
s
newpath
.6944 .94896 .11224 220.208 270 arc
s
newpath
.61664 .9714 .09524 265.208 311.374 arc
s
.95 g
.67959 .89994 m
.67753 .90247 L
.67566 .90515 L
.67399 .90797 L
.67255 .9109 L
.67133 .91393 L
.67034 .91705 L
.66959 .92023 L
.66909 .92346 L
.66883 .92671 L
.66881 .92998 L
.66881 .92998 L
.6669 .92832 L
.66487 .92681 L
.66273 .92546 L
.66049 .92427 L
.65817 .92325 L
.65578 .92241 L
.65334 .92175 L
.65085 .92128 L
.64833 .92099 L
.6458 .9209 L
.6458 .9209 L
.64805 .91742 L
.65062 .91418 L
.6535 .9112 L
.65666 .90853 L
.66007 .90618 L
.66369 .90417 L
.66749 .90253 L
.67143 .90127 L
.67548 .9004 L
.67959 .89994 L
F
0 g
newpath
.68225 .94194 .04209 210 266.374 arc
s
newpath
.6458 .95457 .03367 270 313.102 arc
s
newpath
.71208 .92855 .04329 178.102 221.374 arc
s
.95 g
.62325 .28653 m
.62783 .30251 L
.63296 .31831 L
.63865 .33393 L
.64488 .34934 L
.65164 .36453 L
.65892 .37947 L
.66673 .39414 L
.67504 .40854 L
.68384 .42263 L
.69314 .43641 L
.70291 .44986 L
.71314 .46296 L
.72383 .47569 L
.73495 .48804 L
.74649 .5 L
.74649 .5 L
.74677 .48644 L
.74759 .47291 L
.74895 .45941 L
.75085 .44599 L
.7533 .43265 L
.75628 .41942 L
.75979 .40632 L
.76382 .39337 L
.76838 .3806 L
.77344 .36802 L
.779 .35565 L
.78506 .34352 L
.79161 .33164 L
.79161 .33164 L
.77805 .33137 L
.76451 .33055 L
.75102 .32919 L
.73759 .32728 L
.72425 .32484 L
.71102 .32186 L
.69793 .31835 L
.68498 .31431 L
.6722 .30976 L
.65962 .3047 L
.64726 .29913 L
.63513 .29307 L
.62325 .28653 L
F
0 g
newpath
1.08321 .5 .33672 180 210 arc
s
newpath
1.08321 .16328 .47619 135 165 arc
s
newpath
.79161 -0.00508 .33672 90 120 arc
s
.95 g
.79161 .66836 m
.78506 .65648 L
.779 .64435 L
.77344 .63198 L
.76838 .6194 L
.76382 .60663 L
.75979 .59368 L
.75628 .58058 L
.7533 .56735 L
.75085 .55401 L
.74895 .54059 L
.74759 .52709 L
.74677 .51356 L
.74649 .5 L
.74649 .5 L
.73414 .51283 L
.72227 .5261 L
.71091 .53982 L
.70007 .55395 L
.68976 .56847 L
.68001 .58337 L
.67082 .59862 L
.6622 .61421 L
.65418 .63011 L
.64675 .64629 L
.63994 .66275 L
.63374 .67944 L
.62818 .69636 L
.62325 .71347 L
.62325 .71347 L
.63513 .70693 L
.64726 .70087 L
.65962 .6953 L
.6722 .69024 L
.68498 .68569 L
.69793 .68165 L
.71102 .67814 L
.72425 .67516 L
.73759 .67272 L
.75102 .67081 L
.76451 .66945 L
.77805 .66863 L
.79161 .66836 L
F
0 g
newpath
1.08321 .5 .33672 150 180 arc
s
newpath
1.08321 .83672 .47619 195 225 arc
s
newpath
.79161 1.00508 .33672 240 270 arc
s
.95 g
.67959 .10006 m
.67937 .10605 L
.67947 .11203 L
.67989 .11801 L
.68063 .12395 L
.68168 .12984 L
.68305 .13567 L
.68472 .14142 L
.6867 .14707 L
.68898 .15261 L
.69155 .15802 L
.6944 .16328 L
.6944 .16328 L
.72328 .11327 L
.72328 .11327 L
.71858 .11425 L
.7138 .11471 L
.70899 .11463 L
.70422 .11402 L
.69956 .11289 L
.69504 .11125 L
.69073 .10911 L
.68669 .10652 L
.68296 .10349 L
.67959 .10006 L
F
0 g
.6944 .16328 m
.72328 .11327 L
s
newpath
.71208 .07145 .04329 75 138.626 arc
s
newpath
.79161 .10716 .11224 150 183.626 arc
s
.95 g
.6944 .16328 m
.62325 .28653 L
.62325 .28653 L
.63456 .28335 L
.64579 .27989 L
.65693 .27616 L
.66797 .27215 L
.67891 .26787 L
.68975 .26332 L
.70046 .2585 L
.71106 .25343 L
.72153 .24809 L
.73186 .2425 L
.74205 .23665 L
.75209 .23055 L
.76198 .22421 L
.77172 .21763 L
.77172 .21763 L
.76306 .21571 L
.75458 .21312 L
.74633 .20987 L
.73837 .20597 L
.73074 .20146 L
.72349 .19637 L
.71666 .19071 L
.7103 .18454 L
.70445 .17788 L
.69914 .17078 L
.6944 .16328 L
F
0 g
newpath
.79161 .10716 .11224 100.208 150 arc
s
newpath
.5 -0.17344 .47619 55.2078 75 arc
s
.62325 .28653 m
.6944 .16328 L
s
.95 g
.6944 .83672 m
.69914 .82922 L
.70445 .82212 L
.7103 .81546 L
.71666 .80929 L
.72349 .80363 L
.73074 .79854 L
.73837 .79403 L
.74633 .79013 L
.75458 .78688 L
.76306 .78429 L
.77172 .78237 L
.77172 .78237 L
.76264 .77622 L
.75342 .77028 L
.74407 .76455 L
.73459 .75904 L
.72499 .75375 L
.71526 .74868 L
.70542 .74383 L
.69548 .73922 L
.68543 .73483 L
.67528 .73068 L
.66504 .72676 L
.65471 .72308 L
.64429 .71963 L
.63381 .71643 L
.62325 .71347 L
.62325 .71347 L
.6944 .83672 L
F
0 g
newpath
.79161 .89284 .11224 210 259.792 arc
s
newpath
.5 1.17344 .47619 285 304.792 arc
s
.62325 .71347 m
.6944 .83672 L
s
.95 g
.6944 .83672 m
.72328 .88673 L
.72328 .88673 L
.71858 .88575 L
.7138 .88529 L
.70899 .88537 L
.70422 .88598 L
.69956 .88711 L
.69504 .88875 L
.69073 .89089 L
.68669 .89348 L
.68296 .89651 L
.67959 .89994 L
.67959 .89994 L
.67937 .89395 L
.67947 .88797 L
.67989 .88199 L
.68063 .87605 L
.68168 .87016 L
.68305 .86433 L
.68472 .85858 L
.6867 .85293 L
.68898 .84739 L
.69155 .84198 L
.6944 .83672 L
F
0 g
.6944 .83672 m
.72328 .88673 L
s
newpath
.71208 .92855 .04329 221.374 285 arc
s
newpath
.79161 .89284 .11224 176.374 210 arc
s
.95 g
.72328 .88673 m
.72095 .88822 L
.71876 .88992 L
.71674 .8918 L
.71489 .89386 L
.71324 .89608 L
.7118 .89844 L
.71057 .90092 L
.70957 .9035 L
.70881 .90615 L
.70829 .90887 L
.70829 .90887 L
.70581 .90706 L
.7032 .90543 L
.70048 .904 L
.69766 .90277 L
.69477 .90175 L
.6918 .90095 L
.68878 .90036 L
.68573 .9 L
.68266 .89985 L
.67959 .89994 L
.67959 .89994 L
.68296 .89651 L
.68669 .89348 L
.69073 .89089 L
.69504 .88875 L
.69956 .88711 L
.70422 .88598 L
.70899 .88537 L
.7138 .88529 L
.71858 .88575 L
.72328 .88673 L
F
0 g
newpath
.71208 .92855 .04329 221.374 285 arc
s
newpath
.68225 .94194 .04209 266.374 308.213 arc
s
newpath
.73859 .91324 .03061 188.213 240 arc
s
.95 g
.62325 .28653 m
.63513 .29307 L
.64726 .29913 L
.65962 .3047 L
.6722 .30976 L
.68498 .31431 L
.69793 .31835 L
.71102 .32186 L
.72425 .32484 L
.73759 .32728 L
.75102 .32919 L
.76451 .33055 L
.77805 .33137 L
.79161 .33164 L
.79161 .33164 L
.78654 .32217 L
.78208 .3124 L
.77826 .30237 L
.77508 .29211 L
.77256 .28167 L
.77072 .27109 L
.76955 .26042 L
.76906 .24969 L
.76927 .23895 L
.77015 .22825 L
.77172 .21763 L
.77172 .21763 L
.76198 .22421 L
.75209 .23055 L
.74205 .23665 L
.73186 .2425 L
.72153 .24809 L
.71106 .25343 L
.70046 .2585 L
.68975 .26332 L
.67891 .26787 L
.66797 .27215 L
.65693 .27616 L
.64579 .27989 L
.63456 .28335 L
.62325 .28653 L
F
0 g
newpath
.93741 .24746 .16836 150 190.208 arc
s
newpath
.5 -0.17344 .47619 55.2078 75 arc
s
newpath
.79161 -0.00508 .33672 90 120 arc
s
.95 g
.79161 .66836 m
.77805 .66863 L
.76451 .66945 L
.75102 .67081 L
.73759 .67272 L
.72425 .67516 L
.71102 .67814 L
.69793 .68165 L
.68498 .68569 L
.6722 .69024 L
.65962 .6953 L
.64726 .70087 L
.63513 .70693 L
.62325 .71347 L
.62325 .71347 L
.63456 .71665 L
.64579 .72011 L
.65693 .72384 L
.66797 .72785 L
.67891 .73213 L
.68975 .73668 L
.70046 .7415 L
.71106 .74657 L
.72153 .75191 L
.73186 .7575 L
.74205 .76335 L
.75209 .76945 L
.76198 .77579 L
.77172 .78237 L
.77172 .78237 L
.77015 .77175 L
.76927 .76105 L
.76906 .75031 L
.76955 .73958 L
.77072 .72891 L
.77256 .71833 L
.77508 .70789 L
.77826 .69763 L
.78208 .6876 L
.78654 .67783 L
.79161 .66836 L
F
0 g
newpath
.93741 .75254 .16836 169.792 210 arc
s
newpath
.5 1.17344 .47619 285 304.792 arc
s
newpath
.79161 1.00508 .33672 240 270 arc
s
.95 g
.72328 .11327 m
.72478 .11783 L
.72678 .1222 L
.72924 .12632 L
.73215 .13015 L
.73547 .13363 L
.73915 .13671 L
.74315 .13938 L
.74742 .14158 L
.75191 .14329 L
.75656 .1445 L
.75656 .1445 L
.75149 .14768 L
.74625 .15059 L
.74087 .15321 L
.73535 .15555 L
.72972 .15758 L
.72399 .15931 L
.71818 .16074 L
.71229 .16185 L
.70636 .16264 L
.70039 .16312 L
.6944 .16328 L
.6944 .16328 L
.72328 .11327 L
F
0 g
newpath
.6944 .05104 .11224 56.3736 90 arc
s
.6944 .16328 m
.72328 .11327 L
s
newpath
.7651 .10206 .04329 101.374 165 arc
s
.95 g
.75656 .8555 m
.75191 .85671 L
.74742 .85842 L
.74315 .86062 L
.73915 .86329 L
.73547 .86637 L
.73215 .86985 L
.72924 .87368 L
.72678 .8778 L
.72478 .88217 L
.72328 .88673 L
.72328 .88673 L
.6944 .83672 L
.6944 .83672 L
.70039 .83688 L
.70636 .83736 L
.71229 .83815 L
.71818 .83926 L
.72399 .84069 L
.72972 .84242 L
.73535 .84445 L
.74087 .84679 L
.74625 .84941 L
.75149 .85232 L
.75656 .8555 L
F
0 g
newpath
.6944 .94896 .11224 270 303.626 arc
s
.6944 .83672 m
.72328 .88673 L
s
newpath
.7651 .89794 .04329 195 258.626 arc
s
.95 g
.72328 .11327 m
.72574 .11454 L
.7283 .11559 L
.73094 .1164 L
.73365 .11697 L
.73639 .11729 L
.73916 .11736 L
.74192 .11718 L
.74465 .11676 L
.74734 .11609 L
.74995 .11518 L
.74995 .11518 L
.74962 .11824 L
.74952 .12131 L
.74964 .12438 L
.74998 .12743 L
.75055 .13045 L
.75133 .13342 L
.75233 .13633 L
.75354 .13915 L
.75495 .14188 L
.75656 .1445 L
.75656 .1445 L
.75191 .14329 L
.74742 .14158 L
.74315 .13938 L
.73915 .13671 L
.73547 .13363 L
.73215 .13015 L
.72924 .12632 L
.72678 .1222 L
.72478 .11783 L
.72328 .11327 L
F
0 g
newpath
.7651 .10206 .04329 101.374 165 arc
s
newpath
.79161 .12119 .04209 146.374 188.213 arc
s
newpath
.73859 .08676 .03061 68.2132 120 arc
s
.95 g
.74995 .88482 m
.74734 .88391 L
.74465 .88324 L
.74192 .88282 L
.73916 .88264 L
.73639 .88271 L
.73365 .88303 L
.73094 .8836 L
.7283 .88441 L
.72574 .88546 L
.72328 .88673 L
.72328 .88673 L
.72478 .88217 L
.72678 .8778 L
.72924 .87368 L
.73215 .86985 L
.73547 .86637 L
.73915 .86329 L
.74315 .86062 L
.74742 .85842 L
.75191 .85671 L
.75656 .8555 L
.75656 .8555 L
.75495 .85812 L
.75354 .86085 L
.75233 .86367 L
.75133 .86658 L
.75055 .86955 L
.74998 .87257 L
.74964 .87562 L
.74952 .87869 L
.74962 .88176 L
.74995 .88482 L
F
0 g
newpath
.7651 .89794 .04329 195 258.626 arc
s
newpath
.79161 .87881 .04209 171.787 213.626 arc
s
newpath
.73859 .91324 .03061 240 291.787 arc
s
.95 g
.6944 .16328 m
.69914 .17078 L
.70445 .17788 L
.7103 .18454 L
.71666 .19071 L
.72349 .19637 L
.73074 .20146 L
.73837 .20597 L
.74633 .20987 L
.75458 .21312 L
.76306 .21571 L
.77172 .21763 L
.77172 .21763 L
.76759 .21115 L
.76401 .20437 L
.76098 .19732 L
.75853 .19005 L
.75667 .18261 L
.75542 .17504 L
.75478 .1674 L
.75476 .15973 L
.75535 .15208 L
.75656 .1445 L
.75656 .1445 L
.75149 .14768 L
.74625 .15059 L
.74087 .15321 L
.73535 .15555 L
.72972 .15758 L
.72399 .15931 L
.71818 .16074 L
.71229 .16185 L
.70636 .16264 L
.70039 .16312 L
.6944 .16328 L
F
0 g
newpath
.84993 .16328 .09524 145.208 191.374 arc
s
newpath
.6944 .05104 .11224 56.3736 90 arc
s
newpath
.79161 .10716 .11224 100.208 150 arc
s
.95 g
.77172 .78237 m
.76306 .78429 L
.75458 .78688 L
.74633 .79013 L
.73837 .79403 L
.73074 .79854 L
.72349 .80363 L
.71666 .80929 L
.7103 .81546 L
.70445 .82212 L
.69914 .82922 L
.6944 .83672 L
.6944 .83672 L
.70039 .83688 L
.70636 .83736 L
.71229 .83815 L
.71818 .83926 L
.72399 .84069 L
.72972 .84242 L
.73535 .84445 L
.74087 .84679 L
.74625 .84941 L
.75149 .85232 L
.75656 .8555 L
.75656 .8555 L
.75544 .84862 L
.75482 .84167 L
.75471 .83469 L
.75511 .82773 L
.75603 .82082 L
.75744 .81399 L
.75935 .80728 L
.76175 .80073 L
.76462 .79437 L
.76795 .78824 L
.77172 .78237 L
F
0 g
newpath
.84993 .83672 .09524 168.626 214.792 arc
s
newpath
.6944 .94896 .11224 270 303.626 arc
s
newpath
.79161 .89284 .11224 210 259.792 arc
s
.95 g
.74995 .88482 m
.74876 .88585 L
.74766 .88697 L
.74667 .88819 L
.74579 .8895 L
.74503 .89087 L
.7444 .89231 L
.74389 .8938 L
.74352 .89533 L
.74329 .89688 L
.74319 .89845 L
.74319 .89845 L
.74152 .89681 L
.73976 .89527 L
.73793 .89382 L
.73601 .89248 L
.73403 .89124 L
.73199 .89011 L
.72988 .88909 L
.72772 .88819 L
.72552 .8874 L
.72328 .88673 L
.72328 .88673 L
.72574 .88546 L
.7283 .88441 L
.73094 .8836 L
.73365 .88303 L
.73639 .88271 L
.73916 .88264 L
.74192 .88282 L
.74465 .88324 L
.74734 .88391 L
.74995 .88482 L
F
0 g
newpath
.73859 .91324 .03061 240 291.787 arc
s
newpath
.71208 .92855 .04329 285 315.95 arc
s
newpath
.76091 .89874 .01772 180.95 231.787 arc
s
.95 g
.75656 .8555 m
.7571 .85799 L
.7577 .86047 L
.75837 .86292 L
.7591 .86536 L
.7599 .86778 L
.76076 .87018 L
.76169 .87256 L
.76268 .8749 L
.76373 .87722 L
.76485 .87951 L
.76602 .88178 L
.76602 .88178 L
.76437 .88136 L
.76269 .88111 L
.76099 .88102 L
.7593 .8811 L
.75761 .88133 L
.75596 .88173 L
.75435 .88228 L
.7528 .88298 L
.75133 .88383 L
.74995 .88482 L
.74995 .88482 L
.74962 .88176 L
.74952 .87869 L
.74964 .87562 L
.74998 .87257 L
.75055 .86955 L
.75133 .86658 L
.75233 .86367 L
.75354 .86085 L
.75495 .85812 L
.75656 .8555 L
F
0 g
newpath
.79161 .87881 .04209 171.787 213.626 arc
s
newpath
.76091 .89874 .01772 231.787 286.764 arc
s
newpath
.84993 .83672 .09524 151.764 168.626 arc
s
.95 g
.79161 .16328 m
.78903 .1679 L
.78661 .1726 L
.78433 .17737 L
.78221 .18221 L
.78024 .18712 L
.77842 .19208 L
.77676 .1971 L
.77526 .20217 L
.77391 .20728 L
.77273 .21244 L
.77172 .21763 L
.77172 .21763 L
.76759 .21115 L
.76401 .20437 L
.76098 .19732 L
.75853 .19005 L
.75667 .18261 L
.75542 .17504 L
.75478 .1674 L
.75476 .15973 L
.75535 .15208 L
.75656 .1445 L
.75656 .1445 L
.75902 .14783 L
.76179 .1509 L
.76486 .15369 L
.76818 .15616 L
.77172 .15829 L
.77547 .16006 L
.77936 .16146 L
.78338 .16247 L
.78747 .16308 L
.79161 .16328 L
F
0 g
newpath
.84993 .16328 .09524 145.208 191.374 arc
s
newpath
.79161 .12119 .04209 90 146.374 arc
s
newpath
.93741 .24746 .16836 190.208 210 arc
s
.95 g
.79161 .83672 m
.78903 .8321 L
.78661 .8274 L
.78433 .82263 L
.78221 .81779 L
.78024 .81288 L
.77842 .80792 L
.77676 .8029 L
.77526 .79783 L
.77391 .79272 L
.77273 .78756 L
.77172 .78237 L
.77172 .78237 L
.76795 .78824 L
.76462 .79437 L
.76175 .80073 L
.75935 .80728 L
.75744 .81399 L
.75603 .82082 L
.75511 .82773 L
.75471 .83469 L
.75482 .84167 L
.75544 .84862 L
.75656 .8555 L
.75656 .8555 L
.75902 .85217 L
.76179 .8491 L
.76486 .84631 L
.76818 .84384 L
.77172 .84171 L
.77547 .83994 L
.77936 .83854 L
.78338 .83753 L
.78747 .83692 L
.79161 .83672 L
F
0 g
newpath
.93741 .75254 .16836 150 169.792 arc
s
newpath
.84993 .83672 .09524 168.626 214.792 arc
s
newpath
.79161 .87881 .04209 213.626 270 arc
s
.95 g
.78797 .86119 m
.78636 .86165 L
.7848 .86228 L
.78332 .86308 L
.78193 .86402 L
.78064 .8651 L
.77948 .86631 L
.77845 .86764 L
.77756 .86907 L
.77683 .87058 L
.77626 .87216 L
.77626 .87216 L
.77463 .87046 L
.77297 .8688 L
.77127 .86717 L
.76955 .86558 L
.76778 .86403 L
.76599 .86251 L
.76416 .86103 L
.7623 .85959 L
.76042 .85818 L
.7585 .85682 L
.75656 .8555 L
.75656 .8555 L
.75979 .85498 L
.76304 .8547 L
.76631 .85467 L
.76957 .85488 L
.77281 .85534 L
.776 .85604 L
.77913 .85699 L
.78218 .85816 L
.78513 .85956 L
.78797 .86119 L
F
0 g
newpath
.7651 .89794 .04329 258.626 301.898 arc
s
newpath
.6944 .94896 .11224 303.626 316.826 arc
s
newpath
.79161 .8768 .01603 196.826 256.898 arc
s
.95 g
.75656 .1445 m
.75979 .14502 L
.76304 .1453 L
.76631 .14533 L
.76957 .14512 L
.77281 .14466 L
.776 .14396 L
.77913 .14301 L
.78218 .14184 L
.78513 .14044 L
.78797 .13881 L
.78797 .13881 L
.78749 .1413 L
.7872 .14382 L
.78709 .14635 L
.78718 .14888 L
.78746 .15139 L
.78793 .15388 L
.78858 .15633 L
.78941 .15872 L
.79042 .16104 L
.79161 .16328 L
.79161 .16328 L
.78747 .16308 L
.78338 .16247 L
.77936 .16146 L
.77547 .16006 L
.77172 .15829 L
.76818 .15616 L
.76486 .15369 L
.76179 .1509 L
.75902 .14783 L
.75656 .1445 L
F
0 g
newpath
.79161 .12119 .04209 90 146.374 arc
s
newpath
.82077 .14645 .03367 150 193.102 arc
s
newpath
.7651 .10206 .04329 58.1018 101.374 arc
s
.95 g
.78797 .86119 m
.78513 .85956 L
.78218 .85816 L
.77913 .85699 L
.776 .85604 L
.77281 .85534 L
.76957 .85488 L
.76631 .85467 L
.76304 .8547 L
.75979 .85498 L
.75656 .8555 L
.75656 .8555 L
.75902 .85217 L
.76179 .8491 L
.76486 .84631 L
.76818 .84384 L
.77172 .84171 L
.77547 .83994 L
.77936 .83854 L
.78338 .83753 L
.78747 .83692 L
.79161 .83672 L
.79161 .83672 L
.79042 .83896 L
.78941 .84128 L
.78858 .84367 L
.78793 .84612 L
.78746 .84861 L
.78718 .85112 L
.78709 .85365 L
.7872 .85618 L
.78749 .8587 L
.78797 .86119 L
F
0 g
newpath
.79161 .87881 .04209 -146.374 -90 arc
s
newpath
.82077 .85355 .03367 166.898 210 arc
s
newpath
.7651 .89794 .04329 258.626 301.898 arc
s
.95 g
.79161 .16328 m
.79342 .1661 L
.79551 .16872 L
.79785 .17112 L
.80042 .17328 L
.80319 .17517 L
.80613 .17677 L
.80922 .17808 L
.81242 .17907 L
.81571 .17974 L
.81904 .18007 L
.81904 .18007 L
.81582 .18295 L
.81258 .1858 L
.80931 .18862 L
.80601 .19141 L
.80269 .19417 L
.79935 .1969 L
.79598 .1996 L
.79258 .20227 L
.78916 .20491 L
.78572 .20751 L
.78225 .21009 L
.77876 .21263 L
.77525 .21515 L
.77172 .21763 L
.77172 .21763 L
.77273 .21244 L
.77391 .20728 L
.77526 .20217 L
.77676 .1971 L
.77842 .19208 L
.78024 .18712 L
.78221 .18221 L
.78433 .17737 L
.78661 .1726 L
.78903 .1679 L
.79161 .16328 L
F
0 g
newpath
.5 -0.17344 .47619 47.9337 55.2078 arc
s
newpath
.82077 .14645 .03367 92.9337 150 arc
s
newpath
.93741 .24746 .16836 190.208 210 arc
s
.95 g
.77172 .21763 m
.77015 .22825 L
.76927 .23895 L
.76906 .24969 L
.76955 .26042 L
.77072 .27109 L
.77256 .28167 L
.77508 .29211 L
.77826 .30237 L
.78208 .3124 L
.78654 .32217 L
.79161 .33164 L
.79161 .33164 L
.79525 .32549 L
.79902 .31941 L
.80292 .31341 L
.80695 .3075 L
.8111 .30168 L
.81537 .29594 L
.81977 .2903 L
.82428 .28475 L
.82891 .2793 L
.83366 .27394 L
.83851 .2687 L
.84348 .26355 L
.84856 .25851 L
.84856 .25851 L
.84036 .25804 L
.83223 .25686 L
.82423 .25499 L
.81642 .25243 L
.80886 .24921 L
.80161 .24535 L
.79471 .24088 L
.78823 .23584 L
.78221 .23025 L
.77669 .22416 L
.77172 .21763 L
F
0 g
newpath
1.08321 .5 .33672 210 225.823 arc
s
newpath
.93741 .24746 .16836 150 190.208 arc
s
newpath
.84993 .16328 .09524 90.8227 145.208 arc
s
.95 g
.8804 .40588 m
.87042 .40192 L
.86071 .39733 L
.85131 .39214 L
.84226 .38636 L
.8336 .38001 L
.82536 .37312 L
.81758 .36572 L
.81028 .35784 L
.8035 .34951 L
.79727 .34077 L
.79161 .33164 L
.79161 .33164 L
.78506 .34352 L
.779 .35565 L
.77344 .36802 L
.76838 .3806 L
.76382 .39337 L
.75979 .40632 L
.75628 .41942 L
.7533 .43265 L
.75085 .44599 L
.74895 .45941 L
.74759 .47291 L
.74677 .48644 L
.74649 .5 L
.74649 .5 L
.75434 .49234 L
.76235 .48485 L
.77054 .47756 L
.7789 .47045 L
.78741 .46354 L
.79608 .45683 L
.80491 .45032 L
.81388 .44401 L
.82299 .43792 L
.83224 .43203 L
.84163 .42636 L
.85114 .4209 L
.86078 .41567 L
.87053 .41066 L
.8804 .40588 L
F
0 g
newpath
.93741 .24746 .16836 109.792 150 arc
s
newpath
1.08321 .5 .33672 180 210 arc
s
newpath
1.08321 .83672 .47619 225 244.792 arc
s
.95 g
.74649 .5 m
.74677 .51356 L
.74759 .52709 L
.74895 .54059 L
.75085 .55401 L
.7533 .56735 L
.75628 .58058 L
.75979 .59368 L
.76382 .60663 L
.76838 .6194 L
.77344 .63198 L
.779 .64435 L
.78506 .65648 L
.79161 .66836 L
.79161 .66836 L
.79727 .65923 L
.8035 .65049 L
.81028 .64216 L
.81758 .63428 L
.82536 .62688 L
.8336 .61999 L
.84226 .61364 L
.85131 .60786 L
.86071 .60267 L
.87042 .59808 L
.8804 .59412 L
.8804 .59412 L
.87053 .58934 L
.86078 .58433 L
.85114 .5791 L
.84163 .57364 L
.83224 .56797 L
.82299 .56208 L
.81388 .55599 L
.80491 .54968 L
.79608 .54317 L
.78741 .53646 L
.7789 .52955 L
.77054 .52244 L
.76235 .51515 L
.75434 .50766 L
.74649 .5 L
F
0 g
newpath
.93741 .75254 .16836 210 250.208 arc
s
newpath
1.08321 .5 .33672 150 180 arc
s
newpath
1.08321 .16328 .47619 115.208 135 arc
s
.95 g
.84856 .74149 m
.84348 .73645 L
.83851 .7313 L
.83366 .72606 L
.82891 .7207 L
.82428 .71525 L
.81977 .7097 L
.81537 .70406 L
.8111 .69832 L
.80695 .6925 L
.80292 .68659 L
.79902 .68059 L
.79525 .67451 L
.79161 .66836 L
.79161 .66836 L
.78654 .67783 L
.78208 .6876 L
.77826 .69763 L
.77508 .70789 L
.77256 .71833 L
.77072 .72891 L
.76955 .73958 L
.76906 .75031 L
.76927 .76105 L
.77015 .77175 L
.77172 .78237 L
.77172 .78237 L
.77722 .77521 L
.78337 .76859 L
.79013 .76259 L
.79743 .75726 L
.80519 .75264 L
.81336 .74878 L
.82186 .74571 L
.83061 .74346 L
.83954 .74205 L
.84856 .74149 L
F
0 g
newpath
1.08321 .5 .33672 134.177 150 arc
s
newpath
.93741 .75254 .16836 169.792 210 arc
s
newpath
.84993 .83672 .09524 214.792 269.177 arc
s
.95 g
.77172 .78237 m
.77502 .78469 L
.7783 .78703 L
.78156 .7894 L
.7848 .7918 L
.78802 .79422 L
.79122 .79667 L
.79439 .79915 L
.79755 .80165 L
.80069 .80419 L
.8038 .80674 L
.80689 .80933 L
.80997 .81194 L
.81301 .81458 L
.81604 .81724 L
.81904 .81993 L
.81904 .81993 L
.81571 .82026 L
.81242 .82093 L
.80922 .82192 L
.80613 .82323 L
.80319 .82483 L
.80042 .82672 L
.79785 .82888 L
.79551 .83128 L
.79342 .8339 L
.79161 .83672 L
.79161 .83672 L
.78903 .8321 L
.78661 .8274 L
.78433 .82263 L
.78221 .81779 L
.78024 .81288 L
.77842 .80792 L
.77676 .8029 L
.77526 .79783 L
.77391 .79272 L
.77273 .78756 L
.77172 .78237 L
F
0 g
newpath
.5 1.17344 .47619 304.792 312.066 arc
s
newpath
.82077 .85355 .03367 210 267.066 arc
s
newpath
.93741 .75254 .16836 150 169.792 arc
s
.95 g
.79161 .83672 m
.79256 .83835 L
.79354 .83998 L
.79453 .84159 L
.79554 .8432 L
.79657 .84479 L
.79762 .84637 L
.79869 .84794 L
.79977 .84949 L
.80087 .85104 L
.80199 .85257 L
.80312 .85409 L
.80312 .85409 L
.80136 .85395 L
.79959 .85401 L
.79785 .85427 L
.79614 .85474 L
.7945 .85539 L
.79294 .85623 L
.79149 .85725 L
.79017 .85842 L
.78899 .85974 L
.78797 .86119 L
.78797 .86119 L
.78749 .8587 L
.7872 .85618 L
.78709 .85365 L
.78718 .85112 L
.78746 .84861 L
.78793 .84612 L
.78858 .84367 L
.78941 .84128 L
.79042 .83896 L
.79161 .83672 L
F
0 g
newpath
.82077 .85355 .03367 166.898 210 arc
s
newpath
.80101 .8693 .01536 211.898 277.902 arc
s
newpath
.93741 .75254 .16836 142.902 150 arc
s
.95 g
.81904 .18007 m
.81903 .18365 L
.81936 .1872 L
.82003 .19071 L
.82102 .19414 L
.82234 .19746 L
.82397 .20064 L
.8259 .20365 L
.8281 .20646 L
.83057 .20904 L
.83326 .21138 L
.83326 .21138 L
.82792 .21336 L
.82249 .21507 L
.81697 .2165 L
.81139 .21764 L
.80576 .21851 L
.80009 .21908 L
.7944 .21937 L
.7887 .21936 L
.78301 .21907 L
.77735 .21849 L
.77172 .21763 L
.77172 .21763 L
.77525 .21515 L
.77876 .21263 L
.78225 .21009 L
.78572 .20751 L
.78916 .20491 L
.79258 .20227 L
.79598 .1996 L
.79935 .1969 L
.80269 .19417 L
.80601 .19141 L
.80931 .18862 L
.81258 .1858 L
.81582 .18295 L
.81904 .18007 L
F
0 g
newpath
.79161 .10716 .11224 68.2132 100.208 arc
s
newpath
.5 -0.17344 .47619 47.9337 55.2078 arc
s
newpath
.85641 .18199 .03741 128.213 182.934 arc
s
.95 g
.81904 .81993 m
.81903 .81635 L
.81936 .8128 L
.82003 .80929 L
.82102 .80586 L
.82234 .80254 L
.82397 .79936 L
.8259 .79635 L
.8281 .79354 L
.83057 .79096 L
.83326 .78862 L
.83326 .78862 L
.82792 .78664 L
.82249 .78493 L
.81697 .7835 L
.81139 .78236 L
.80576 .78149 L
.80009 .78092 L
.7944 .78063 L
.7887 .78064 L
.78301 .78093 L
.77735 .78151 L
.77172 .78237 L
.77172 .78237 L
.77525 .78485 L
.77876 .78737 L
.78225 .78991 L
.78572 .79249 L
.78916 .79509 L
.79258 .79773 L
.79598 .8004 L
.79935 .8031 L
.80269 .80583 L
.80601 .80859 L
.80931 .81138 L
.81258 .8142 L
.81582 .81705 L
.81904 .81993 L
F
0 g
newpath
.85641 .81801 .03741 177.066 231.787 arc
s
newpath
.79161 .89284 .11224 259.792 291.787 arc
s
newpath
.5 1.17344 .47619 304.792 312.066 arc
s
.95 g
.81904 .81993 m
.81749 .82182 L
.81614 .82386 L
.81498 .82602 L
.81405 .82828 L
.81334 .83063 L
.81286 .83303 L
.81262 .83546 L
.81261 .83791 L
.81285 .84035 L
.81332 .84275 L
.81332 .84275 L
.81134 .84163 L
.80929 .84061 L
.8072 .83971 L
.80506 .83892 L
.80288 .83825 L
.80066 .8377 L
.79842 .83727 L
.79616 .83696 L
.79389 .83678 L
.79161 .83672 L
.79161 .83672 L
.79342 .8339 L
.79551 .83128 L
.79785 .82888 L
.80042 .82672 L
.80319 .82483 L
.80613 .82323 L
.80922 .82192 L
.81242 .82093 L
.81571 .82026 L
.81904 .81993 L
F
0 g
newpath
.82077 .85355 .03367 210 267.066 arc
s
newpath
.79161 .87881 .04209 270 301.064 arc
s
newpath
.83765 .83672 .02506 166.064 222.066 arc
s
.95 g
.77172 .21763 m
.77722 .22479 L
.78337 .23141 L
.79013 .23741 L
.79743 .24274 L
.80519 .24736 L
.81336 .25122 L
.82186 .25429 L
.83061 .25654 L
.83954 .25795 L
.84856 .25851 L
.84856 .25851 L
.84516 .25467 L
.84212 .25054 L
.83947 .24615 L
.83723 .24153 L
.83543 .23673 L
.83407 .23178 L
.83317 .22673 L
.83273 .22162 L
.83276 .21649 L
.83326 .21138 L
.83326 .21138 L
.82792 .21336 L
.82249 .21507 L
.81697 .2165 L
.81139 .21764 L
.80576 .21851 L
.80009 .21908 L
.7944 .21937 L
.7887 .21936 L
.78301 .21907 L
.77735 .21849 L
.77172 .21763 L
F
0 g
newpath
.88881 .2194 .05612 135.823 188.213 arc
s
newpath
.79161 .10716 .11224 68.2132 100.208 arc
s
newpath
.84993 .16328 .09524 90.8227 145.208 arc
s
.95 g
.84856 .74149 m
.83954 .74205 L
.83061 .74346 L
.82186 .74571 L
.81336 .74878 L
.80519 .75264 L
.79743 .75726 L
.79013 .76259 L
.78337 .76859 L
.77722 .77521 L
.77172 .78237 L
.77172 .78237 L
.77735 .78151 L
.78301 .78093 L
.7887 .78064 L
.7944 .78063 L
.80009 .78092 L
.80576 .78149 L
.81139 .78236 L
.81697 .7835 L
.82249 .78493 L
.82792 .78664 L
.83326 .78862 L
.83326 .78862 L
.83276 .78351 L
.83273 .77838 L
.83317 .77327 L
.83407 .76822 L
.83543 .76327 L
.83723 .75847 L
.83947 .75385 L
.84212 .74946 L
.84516 .74533 L
.84856 .74149 L
F
0 g
newpath
.88881 .7806 .05612 171.787 224.177 arc
s
newpath
.79161 .89284 .11224 259.792 291.787 arc
s
newpath
.84993 .83672 .09524 214.792 269.177 arc
s
.95 g
.8804 .40588 m
.87053 .41066 L
.86078 .41567 L
.85114 .4209 L
.84163 .42636 L
.83224 .43203 L
.82299 .43792 L
.81388 .44401 L
.80491 .45032 L
.79608 .45683 L
.78741 .46354 L
.7789 .47045 L
.77054 .47756 L
.76235 .48485 L
.75434 .49234 L
.74649 .5 L
.74649 .5 L
.88881 .5 L
.88881 .5 L
.88468 .49215 L
.88119 .48401 L
.87835 .47561 L
.87618 .46701 L
.8747 .45827 L
.87391 .44944 L
.87382 .44058 L
.87443 .43173 L
.87574 .42297 L
.87773 .41433 L
.8804 .40588 L
F
0 g
newpath
.98601 .44388 .11224 150 199.792 arc
s
.88881 .5 m
.74649 .5 L
s
newpath
1.08321 .83672 .47619 225 244.792 arc
s
.95 g
.74649 .5 m
.75434 .50766 L
.76235 .51515 L
.77054 .52244 L
.7789 .52955 L
.78741 .53646 L
.79608 .54317 L
.80491 .54968 L
.81388 .55599 L
.82299 .56208 L
.83224 .56797 L
.84163 .57364 L
.85114 .5791 L
.86078 .58433 L
.87053 .58934 L
.8804 .59412 L
.8804 .59412 L
.87773 .58567 L
.87574 .57703 L
.87443 .56827 L
.87382 .55942 L
.87391 .55056 L
.8747 .54173 L
.87618 .53299 L
.87835 .52439 L
.88119 .51599 L
.88468 .50785 L
.88881 .5 L
.88881 .5 L
.74649 .5 L
F
0 g
newpath
.98601 .55612 .11224 160.208 210 arc
s
.88881 .5 m
.74649 .5 L
s
newpath
1.08321 .16328 .47619 115.208 135 arc
s
.95 g
.81904 .18007 m
.82086 .18189 L
.82285 .18351 L
.825 .18492 L
.82729 .1861 L
.82968 .18704 L
.83215 .18774 L
.83469 .18817 L
.83725 .18834 L
.83982 .18825 L
.84237 .1879 L
.84237 .1879 L
.84099 .19003 L
.83971 .19223 L
.83853 .19448 L
.83745 .19678 L
.83648 .19912 L
.83562 .20151 L
.83486 .20394 L
.83422 .2064 L
.83368 .20888 L
.83326 .21138 L
.83326 .21138 L
.83057 .20904 L
.8281 .20646 L
.8259 .20365 L
.82397 .20064 L
.82234 .19746 L
.82102 .19414 L
.82003 .19071 L
.81936 .1872 L
.81903 .18365 L
.81904 .18007 L
F
0 g
newpath
.85641 .18199 .03741 128.213 182.934 arc
s
newpath
.88881 .2194 .05612 188.213 214.152 arc
s
newpath
.83765 .16328 .02506 79.1518 137.934 arc
s
.95 g
.84237 .8121 m
.83982 .81175 L
.83725 .81166 L
.83469 .81183 L
.83215 .81226 L
.82968 .81296 L
.82729 .8139 L
.825 .81508 L
.82285 .81649 L
.82086 .81811 L
.81904 .81993 L
.81904 .81993 L
.81903 .81635 L
.81936 .8128 L
.82003 .80929 L
.82102 .80586 L
.82234 .80254 L
.82397 .79936 L
.8259 .79635 L
.8281 .79354 L
.83057 .79096 L
.83326 .78862 L
.83326 .78862 L
.83368 .79112 L
.83422 .7936 L
.83486 .79606 L
.83562 .79849 L
.83648 .80088 L
.83745 .80322 L
.83853 .80552 L
.83971 .80777 L
.84099 .80997 L
.84237 .8121 L
F
0 g
newpath
.85641 .81801 .03741 177.066 231.787 arc
s
newpath
.88881 .7806 .05612 145.848 171.787 arc
s
newpath
.83765 .83672 .02506 222.066 280.848 arc
s
.95 g
.84237 .8121 m
.84128 .81292 L
.84028 .81385 L
.83938 .81488 L
.83858 .81599 L
.83791 .81717 L
.83735 .81842 L
.83693 .81971 L
.83664 .82105 L
.83648 .8224 L
.83647 .82377 L
.83647 .82377 L
.83485 .82297 L
.83319 .82226 L
.83149 .82164 L
.82977 .82111 L
.82801 .82067 L
.82624 .82033 L
.82445 .82008 L
.82265 .81993 L
.82085 .81988 L
.81904 .81993 L
.81904 .81993 L
.82086 .81811 L
.82285 .81649 L
.825 .81508 L
.82729 .8139 L
.82968 .81296 L
.83215 .81226 L
.83469 .81183 L
.83725 .81166 L
.83982 .81175 L
.84237 .8121 L
F
0 g
newpath
.83765 .83672 .02506 222.066 280.848 arc
s
newpath
.82077 .85355 .03367 267.066 297.796 arc
s
newpath
.84993 .82325 .01347 177.796 235.848 arc
s
.95 g
.79161 .33164 m
.79876 .33157 L
.80591 .33134 L
.81305 .33096 L
.82018 .33043 L
.8273 .32974 L
.83441 .32891 L
.84149 .32793 L
.84855 .32679 L
.85559 .32551 L
.8626 .32407 L
.86957 .32249 L
.87651 .32076 L
.88342 .31888 L
.88342 .31888 L
.87723 .31498 L
.8715 .31043 L
.86629 .3053 L
.86166 .29963 L
.85767 .2935 L
.85435 .28698 L
.85176 .28014 L
.84992 .27306 L
.84885 .26582 L
.84856 .25851 L
.84856 .25851 L
.84348 .26355 L
.83851 .2687 L
.83366 .27394 L
.82891 .2793 L
.82428 .28475 L
.81977 .2903 L
.81537 .29594 L
.8111 .30168 L
.80695 .3075 L
.80292 .31341 L
.79902 .31941 L
.79525 .32549 L
.79161 .33164 L
F
0 g
newpath
.91658 .25949 .06803 119.177 180.823 arc
s
newpath
1.08321 .5 .33672 210 225.823 arc
s
newpath
.79161 -0.00508 .33672 74.1773 90 arc
s
.95 g
.88342 .68112 m
.87651 .67924 L
.86957 .67751 L
.8626 .67593 L
.85559 .67449 L
.84855 .67321 L
.84149 .67207 L
.83441 .67109 L
.8273 .67026 L
.82018 .66957 L
.81305 .66904 L
.80591 .66866 L
.79876 .66843 L
.79161 .66836 L
.79161 .66836 L
.79525 .67451 L
.79902 .68059 L
.80292 .68659 L
.80695 .6925 L
.8111 .69832 L
.81537 .70406 L
.81977 .7097 L
.82428 .71525 L
.82891 .7207 L
.83366 .72606 L
.83851 .7313 L
.84348 .73645 L
.84856 .74149 L
.84856 .74149 L
.84885 .73418 L
.84992 .72694 L
.85176 .71986 L
.85435 .71302 L
.85767 .7065 L
.86166 .70037 L
.86629 .6947 L
.8715 .68957 L
.87723 .68502 L
.88342 .68112 L
F
0 g
newpath
.91658 .74051 .06803 179.177 240.823 arc
s
newpath
1.08321 .5 .33672 134.177 150 arc
s
newpath
.79161 1.00508 .33672 270 285.823 arc
s
.95 g
.85455 .79991 m
.85278 .80036 L
.85107 .80102 L
.84946 .80188 L
.84795 .80292 L
.84659 .80414 L
.84537 .8055 L
.84433 .80701 L
.84347 .80862 L
.84282 .81033 L
.84237 .8121 L
.84237 .8121 L
.84099 .80997 L
.83971 .80777 L
.83853 .80552 L
.83745 .80322 L
.83648 .80088 L
.83562 .79849 L
.83486 .79606 L
.83422 .7936 L
.83368 .79112 L
.83326 .78862 L
.83326 .78862 L
.83529 .78945 L
.83731 .79032 L
.8393 .79124 L
.84128 .79219 L
.84324 .79318 L
.84518 .79421 L
.8471 .79527 L
.84899 .79638 L
.85087 .79752 L
.85272 .7987 L
.85455 .79991 L
F
0 g
newpath
.79161 .89284 .11224 291.787 304.112 arc
s
newpath
.88881 .7806 .05612 145.848 171.787 arc
s
newpath
.85745 .81499 .01536 190.848 259.112 arc
s
.95 g
.86192 .21899 m
.8595 .22248 L
.85731 .2261 L
.85534 .22986 L
.85362 .23373 L
.85213 .2377 L
.8509 .24176 L
.84993 .24588 L
.84921 .25006 L
.84875 .25428 L
.84856 .25851 L
.84856 .25851 L
.84516 .25467 L
.84212 .25054 L
.83947 .24615 L
.83723 .24153 L
.83543 .23673 L
.83407 .23178 L
.83317 .22673 L
.83273 .22162 L
.83276 .21649 L
.83326 .21138 L
.83326 .21138 L
.83573 .21317 L
.83834 .21475 L
.84107 .21611 L
.84389 .21725 L
.8468 .21815 L
.84978 .21881 L
.8528 .21923 L
.85584 .2194 L
.85889 .21932 L
.86192 .21899 L
F
0 g
newpath
.88881 .2194 .05612 135.823 188.213 arc
s
newpath
.85641 .18199 .03741 81.5307 128.213 arc
s
newpath
.91658 .25949 .06803 180.823 216.531 arc
s
.95 g
.79161 .33164 m
.79727 .34077 L
.8035 .34951 L
.81028 .35784 L
.81758 .36572 L
.82536 .37312 L
.8336 .38001 L
.84226 .38636 L
.85131 .39214 L
.86071 .39733 L
.87042 .40192 L
.8804 .40588 L
.8804 .40588 L
.87723 .3983 L
.87472 .39048 L
.87289 .38247 L
.87176 .37433 L
.87133 .36612 L
.87162 .35791 L
.87261 .34976 L
.8743 .34172 L
.87668 .33385 L
.87972 .32622 L
.88342 .31888 L
.88342 .31888 L
.87651 .32076 L
.86957 .32249 L
.8626 .32407 L
.85559 .32551 L
.84855 .32679 L
.84149 .32793 L
.83441 .32891 L
.8273 .32974 L
.82018 .33043 L
.81305 .33096 L
.80591 .33134 L
.79876 .33157 L
.79161 .33164 L
F
0 g
newpath
.96657 .36531 .09524 154.792 209.177 arc
s
newpath
.93741 .24746 .16836 109.792 150 arc
s
newpath
.79161 -0.00508 .33672 74.1773 90 arc
s
.95 g
.88342 .68112 m
.87972 .67378 L
.87668 .66615 L
.8743 .65828 L
.87261 .65024 L
.87162 .64209 L
.87133 .63388 L
.87176 .62567 L
.87289 .61753 L
.87472 .60952 L
.87723 .6017 L
.8804 .59412 L
.8804 .59412 L
.87042 .59808 L
.86071 .60267 L
.85131 .60786 L
.84226 .61364 L
.8336 .61999 L
.82536 .62688 L
.81758 .63428 L
.81028 .64216 L
.8035 .65049 L
.79727 .65923 L
.79161 .66836 L
.79161 .66836 L
.79876 .66843 L
.80591 .66866 L
.81305 .66904 L
.82018 .66957 L
.8273 .67026 L
.83441 .67109 L
.84149 .67207 L
.84855 .67321 L
.85559 .67449 L
.8626 .67593 L
.86957 .67751 L
.87651 .67924 L
.88342 .68112 L
F
0 g
newpath
.96657 .63469 .09524 150.823 205.208 arc
s
newpath
.93741 .75254 .16836 210 250.208 arc
s
newpath
.79161 1.00508 .33672 270 285.823 arc
s
.95 g
.86192 .78101 m
.8595 .77752 L
.85731 .7739 L
.85534 .77014 L
.85362 .76627 L
.85213 .7623 L
.8509 .75824 L
.84993 .75412 L
.84921 .74994 L
.84875 .74572 L
.84856 .74149 L
.84856 .74149 L
.84516 .74533 L
.84212 .74946 L
.83947 .75385 L
.83723 .75847 L
.83543 .76327 L
.83407 .76822 L
.83317 .77327 L
.83273 .77838 L
.83276 .78351 L
.83326 .78862 L
.83326 .78862 L
.83573 .78683 L
.83834 .78525 L
.84107 .78389 L
.84389 .78275 L
.8468 .78185 L
.84978 .78119 L
.8528 .78077 L
.85584 .7806 L
.85889 .78068 L
.86192 .78101 L
F
0 g
newpath
.91658 .74051 .06803 143.469 179.177 arc
s
newpath
.88881 .7806 .05612 171.787 224.177 arc
s
newpath
.85641 .81801 .03741 231.787 278.469 arc
s
.95 g
.83326 .21138 m
.83529 .21055 L
.83731 .20968 L
.8393 .20876 L
.84128 .20781 L
.84324 .20682 L
.84518 .20579 L
.8471 .20473 L
.84899 .20362 L
.85087 .20248 L
.85272 .2013 L
.85455 .20009 L
.85455 .20009 L
.85427 .20221 L
.85422 .20435 L
.85441 .20648 L
.85484 .20857 L
.85551 .2106 L
.8564 .21255 L
.85749 .21438 L
.85879 .21608 L
.86027 .21763 L
.86192 .21899 L
.86192 .21899 L
.85889 .21932 L
.85584 .2194 L
.8528 .21923 L
.84978 .21881 L
.8468 .21815 L
.84389 .21725 L
.84107 .21611 L
.83834 .21475 L
.83573 .21317 L
.83326 .21138 L
F
0 g
newpath
.85641 .18199 .03741 81.5307 128.213 arc
s
newpath
.87326 .20369 .01905 126.531 190.888 arc
s
newpath
.79161 .10716 .11224 55.8881 68.2132 arc
s
.95 g
.85455 .79991 m
.85272 .7987 L
.85087 .79752 L
.84899 .79638 L
.8471 .79527 L
.84518 .79421 L
.84324 .79318 L
.84128 .79219 L
.8393 .79124 L
.83731 .79032 L
.83529 .78945 L
.83326 .78862 L
.83326 .78862 L
.83573 .78683 L
.83834 .78525 L
.84107 .78389 L
.84389 .78275 L
.8468 .78185 L
.84978 .78119 L
.8528 .78077 L
.85584 .7806 L
.85889 .78068 L
.86192 .78101 L
.86192 .78101 L
.86027 .78237 L
.85879 .78392 L
.85749 .78562 L
.8564 .78745 L
.85551 .7894 L
.85484 .79143 L
.85441 .79352 L
.85422 .79565 L
.85427 .79779 L
.85455 .79991 L
F
0 g
newpath
.85641 .81801 .03741 231.787 278.469 arc
s
newpath
.87326 .79631 .01905 169.112 233.469 arc
s
newpath
.79161 .89284 .11224 291.787 304.112 arc
s
.95 g
.86192 .21899 m
.86235 .22114 L
.86301 .22324 L
.86388 .22525 L
.86496 .22716 L
.86623 .22895 L
.86768 .2306 L
.86929 .23208 L
.87105 .2334 L
.87293 .23452 L
.87492 .23544 L
.87492 .23544 L
.87281 .23711 L
.87071 .23881 L
.86863 .24052 L
.86656 .24224 L
.8645 .24399 L
.86246 .24574 L
.86043 .24752 L
.85841 .24931 L
.85641 .25112 L
.85443 .25294 L
.85246 .25478 L
.8505 .25664 L
.84856 .25851 L
.84856 .25851 L
.84875 .25428 L
.84921 .25006 L
.84993 .24588 L
.8509 .24176 L
.85213 .2377 L
.85362 .23373 L
.85534 .22986 L
.85731 .2261 L
.8595 .22248 L
.86192 .21899 L
F
0 g
newpath
.91658 .25949 .06803 180.823 216.531 arc
s
newpath
1.08321 .5 .33672 225.823 231.787 arc
s
newpath
.88273 .21589 .02104 111.787 171.531 arc
s
.95 g
.87492 .76456 m
.87293 .76548 L
.87105 .7666 L
.86929 .76792 L
.86768 .7694 L
.86623 .77105 L
.86496 .77284 L
.86388 .77475 L
.86301 .77676 L
.86235 .77886 L
.86192 .78101 L
.86192 .78101 L
.8595 .77752 L
.85731 .7739 L
.85534 .77014 L
.85362 .76627 L
.85213 .7623 L
.8509 .75824 L
.84993 .75412 L
.84921 .74994 L
.84875 .74572 L
.84856 .74149 L
.84856 .74149 L
.8505 .74336 L
.85246 .74522 L
.85443 .74706 L
.85641 .74888 L
.85841 .75069 L
.86043 .75248 L
.86246 .75426 L
.8645 .75601 L
.86656 .75776 L
.86863 .75948 L
.87071 .76119 L
.87281 .76289 L
.87492 .76456 L
F
0 g
newpath
.91658 .74051 .06803 143.469 179.177 arc
s
newpath
1.08321 .5 .33672 128.213 134.177 arc
s
newpath
.88273 .78411 .02104 188.469 248.213 arc
s
.95 g
.86192 .78101 m
.86176 .78241 L
.86169 .78382 L
.86172 .78523 L
.86184 .78664 L
.86206 .78804 L
.86237 .78941 L
.86277 .79077 L
.86326 .79209 L
.86384 .79338 L
.86451 .79463 L
.86451 .79463 L
.86334 .79468 L
.86218 .79486 L
.86104 .79514 L
.85993 .79553 L
.85887 .79603 L
.85786 .79663 L
.85692 .79732 L
.85605 .79811 L
.85525 .79897 L
.85455 .79991 L
.85455 .79991 L
.85427 .79779 L
.85422 .79565 L
.85441 .79352 L
.85484 .79143 L
.85551 .7894 L
.8564 .78745 L
.85749 .78562 L
.85879 .78392 L
.86027 .78237 L
.86192 .78101 L
F
0 g
newpath
.87326 .79631 .01905 169.112 233.469 arc
s
newpath
.86451 .80665 .01203 214.112 270 arc
s
newpath
.88273 .78411 .02104 150 188.469 arc
s
.95 g
.88881 .27552 m
.88672 .27949 L
.88496 .28362 L
.88353 .28787 L
.88245 .29223 L
.88172 .29666 L
.88134 .30113 L
.88133 .30561 L
.88167 .31009 L
.88237 .31452 L
.88342 .31888 L
.88342 .31888 L
.87723 .31498 L
.8715 .31043 L
.86629 .3053 L
.86166 .29963 L
.85767 .2935 L
.85435 .28698 L
.85176 .28014 L
.84992 .27306 L
.84885 .26582 L
.84856 .25851 L
.84856 .25851 L
.85181 .2616 L
.8553 .26442 L
.85901 .26695 L
.8629 .26918 L
.86696 .27109 L
.87116 .27267 L
.87547 .27391 L
.87987 .27481 L
.88432 .27534 L
.88881 .27552 L
F
0 g
newpath
.91658 .25949 .06803 119.177 180.823 arc
s
newpath
.88881 .2194 .05612 90 135.823 arc
s
newpath
.93741 .30358 .05612 164.177 210 arc
s
.95 g
.88881 .72448 m
.88672 .72051 L
.88496 .71638 L
.88353 .71213 L
.88245 .70777 L
.88172 .70334 L
.88134 .69887 L
.88133 .69439 L
.88167 .68991 L
.88237 .68548 L
.88342 .68112 L
.88342 .68112 L
.87723 .68502 L
.8715 .68957 L
.86629 .6947 L
.86166 .70037 L
.85767 .7065 L
.85435 .71302 L
.85176 .71986 L
.84992 .72694 L
.84885 .73418 L
.84856 .74149 L
.84856 .74149 L
.85181 .7384 L
.8553 .73558 L
.85901 .73305 L
.8629 .73082 L
.86696 .72891 L
.87116 .72733 L
.87547 .72609 L
.87987 .72519 L
.88432 .72466 L
.88881 .72448 L
F
0 g
newpath
.93741 .69642 .05612 150 195.823 arc
s
newpath
.91658 .74051 .06803 179.177 240.823 arc
s
newpath
.88881 .7806 .05612 224.177 270 arc
s
.95 g
.8871 .74903 m
.88523 .74991 L
.88346 .75097 L
.88181 .75221 L
.88029 .75362 L
.87894 .75517 L
.87775 .75686 L
.87674 .75867 L
.87593 .76057 L
.87532 .76254 L
.87492 .76456 L
.87492 .76456 L
.87281 .76289 L
.87071 .76119 L
.86863 .75948 L
.86656 .75776 L
.8645 .75601 L
.86246 .75426 L
.86043 .75248 L
.85841 .75069 L
.85641 .74888 L
.85443 .74706 L
.85246 .74522 L
.8505 .74336 L
.84856 .74149 L
.84856 .74149 L
.85216 .74151 L
.85575 .74166 L
.85933 .74194 L
.8629 .74237 L
.86645 .74292 L
.86998 .74361 L
.87348 .74444 L
.87695 .74539 L
.88038 .74648 L
.88376 .74769 L
.8871 .74903 L
F
0 g
newpath
.84993 .83672 .09524 269.177 292.972 arc
s
newpath
1.08321 .5 .33672 128.213 134.177 arc
s
newpath
.89453 .76739 .01981 188.213 247.972 arc
s
.95 g
.87492 .76456 m
.87477 .76593 L
.87472 .76731 L
.87476 .76869 L
.8749 .77006 L
.87513 .77141 L
.87546 .77275 L
.87588 .77406 L
.87638 .77534 L
.87698 .77658 L
.87766 .77778 L
.87766 .77778 L
.87603 .77747 L
.87438 .7773 L
.87272 .77727 L
.87107 .77739 L
.86943 .77765 L
.86782 .77805 L
.86626 .7786 L
.86474 .77927 L
.86329 .78008 L
.86192 .78101 L
.86192 .78101 L
.86235 .77886 L
.86301 .77676 L
.86388 .77475 L
.86496 .77284 L
.86623 .77105 L
.86768 .7694 L
.86929 .76792 L
.87105 .7666 L
.87293 .76548 L
.87492 .76456 L
F
0 g
newpath
.88273 .78411 .02104 188.469 248.213 arc
s
newpath
.87326 .79631 .01905 233.469 283.372 arc
s
newpath
.89453 .76739 .01981 148.372 188.213 arc
s
.95 g
.84856 .25851 m
.85251 .25849 L
.85646 .2583 L
.8604 .25794 L
.86433 .25743 L
.86822 .25675 L
.87209 .25591 L
.87591 .25491 L
.87969 .25375 L
.88342 .25244 L
.8871 .25097 L
.8871 .25097 L
.88625 .25337 L
.88562 .25584 L
.88522 .25835 L
.88505 .2609 L
.88512 .26344 L
.88541 .26597 L
.88593 .26847 L
.88667 .2709 L
.88764 .27326 L
.88881 .27552 L
.88881 .27552 L
.88432 .27534 L
.87987 .27481 L
.87547 .27391 L
.87116 .27267 L
.86696 .27109 L
.8629 .26918 L
.85901 .26695 L
.8553 .26442 L
.85181 .2616 L
.84856 .25851 L
F
0 g
newpath
.88881 .2194 .05612 90 135.823 arc
s
newpath
.91311 .26149 .02806 150 202.028 arc
s
newpath
.84993 .16328 .09524 67.0279 90.8227 arc
s
.95 g
.8871 .74903 m
.88376 .74769 L
.88038 .74648 L
.87695 .74539 L
.87348 .74444 L
.86998 .74361 L
.86645 .74292 L
.8629 .74237 L
.85933 .74194 L
.85575 .74166 L
.85216 .74151 L
.84856 .74149 L
.84856 .74149 L
.85181 .7384 L
.8553 .73558 L
.85901 .73305 L
.8629 .73082 L
.86696 .72891 L
.87116 .72733 L
.87547 .72609 L
.87987 .72519 L
.88432 .72466 L
.88881 .72448 L
.88881 .72448 L
.88764 .72674 L
.88667 .7291 L
.88593 .73153 L
.88541 .73403 L
.88512 .73656 L
.88505 .7391 L
.88522 .74165 L
.88562 .74416 L
.88625 .74663 L
.8871 .74903 L
F
0 g
newpath
.88881 .7806 .05612 224.177 270 arc
s
newpath
.91311 .73851 .02806 157.972 210 arc
s
newpath
.84993 .83672 .09524 269.177 292.972 arc
s
.95 g
.88342 .31888 m
.87972 .32622 L
.87668 .33385 L
.8743 .34172 L
.87261 .34976 L
.87162 .35791 L
.87133 .36612 L
.87176 .37433 L
.87289 .38247 L
.87472 .39048 L
.87723 .3983 L
.8804 .40588 L
.8804 .40588 L
.88247 .40057 L
.8848 .39537 L
.88739 .39029 L
.89024 .38536 L
.89333 .38057 L
.89666 .37595 L
.90022 .37151 L
.904 .36725 L
.908 .36318 L
.91219 .35933 L
.91658 .35569 L
.91658 .35569 L
.91191 .35357 L
.90745 .35104 L
.90324 .3481 L
.89932 .3448 L
.89572 .34115 L
.89246 .33718 L
.88958 .33294 L
.8871 .32845 L
.88504 .32375 L
.88342 .31888 L
F
0 g
newpath
.98601 .44388 .11224 199.792 231.787 arc
s
newpath
.93741 .30358 .05612 111.787 164.177 arc
s
newpath
.96657 .36531 .09524 154.792 209.177 arc
s
.95 g
.8804 .59412 m
.87723 .6017 L
.87472 .60952 L
.87289 .61753 L
.87176 .62567 L
.87133 .63388 L
.87162 .64209 L
.87261 .65024 L
.8743 .65828 L
.87668 .66615 L
.87972 .67378 L
.88342 .68112 L
.88342 .68112 L
.88504 .67625 L
.8871 .67155 L
.88958 .66706 L
.89246 .66282 L
.89572 .65885 L
.89932 .6552 L
.90324 .6519 L
.90745 .64896 L
.91191 .64643 L
.91658 .64431 L
.91658 .64431 L
.91219 .64067 L
.908 .63682 L
.904 .63275 L
.90022 .62849 L
.89666 .62405 L
.89333 .61943 L
.89024 .61464 L
.88739 .60971 L
.8848 .60463 L
.88247 .59943 L
.8804 .59412 L
F
0 g
newpath
.98601 .55612 .11224 128.213 160.208 arc
s
newpath
.93741 .69642 .05612 195.823 248.213 arc
s
newpath
.96657 .63469 .09524 150.823 205.208 arc
s
.95 g
.88881 .27552 m
.89018 .27767 L
.89174 .27968 L
.89348 .28154 L
.89538 .28324 L
.89742 .28476 L
.8996 .28608 L
.90188 .28721 L
.90426 .28812 L
.90671 .28881 L
.90922 .28928 L
.90922 .28928 L
.90639 .2915 L
.90364 .29382 L
.90099 .29625 L
.89843 .29877 L
.89597 .30139 L
.89361 .3041 L
.89135 .3069 L
.8892 .30978 L
.88716 .31274 L
.88523 .31578 L
.88342 .31888 L
.88342 .31888 L
.88237 .31452 L
.88167 .31009 L
.88133 .30561 L
.88134 .30113 L
.88172 .29666 L
.88245 .29223 L
.88353 .28787 L
.88496 .28362 L
.88672 .27949 L
.88881 .27552 L
F
0 g
newpath
.93741 .30358 .05612 164.177 210 arc
s
newpath
.96657 .36531 .09524 209.177 232.972 arc
s
newpath
.91311 .26149 .02806 97.9721 150 arc
s
.95 g
.8804 .40588 m
.87773 .41433 L
.87574 .42297 L
.87443 .43173 L
.87382 .44058 L
.87391 .44944 L
.8747 .45827 L
.87618 .46701 L
.87835 .47561 L
.88119 .48401 L
.88468 .49215 L
.88881 .5 L
.88881 .5 L
.89194 .4949 L
.89534 .48997 L
.89899 .48523 L
.9029 .48069 L
.90704 .47636 L
.91141 .47226 L
.91598 .4684 L
.92076 .46479 L
.92572 .46144 L
.93086 .45836 L
.93615 .45556 L
.93615 .45556 L
.92899 .45282 L
.92206 .44951 L
.91543 .44566 L
.90913 .44128 L
.9032 .43641 L
.89769 .43108 L
.89262 .42532 L
.88803 .41918 L
.88395 .41268 L
.8804 .40588 L
F
0 g
newpath
.98601 .55612 .11224 210 243.626 arc
s
newpath
.96657 .36531 .09524 108.626 154.792 arc
s
newpath
.98601 .44388 .11224 150 199.792 arc
s
.95 g
.88881 .5 m
.88468 .50785 L
.88119 .51599 L
.87835 .52439 L
.87618 .53299 L
.8747 .54173 L
.87391 .55056 L
.87382 .55942 L
.87443 .56827 L
.87574 .57703 L
.87773 .58567 L
.8804 .59412 L
.8804 .59412 L
.88395 .58732 L
.88803 .58082 L
.89262 .57468 L
.89769 .56892 L
.9032 .56359 L
.90913 .55872 L
.91543 .55434 L
.92206 .55049 L
.92899 .54718 L
.93615 .54444 L
.93615 .54444 L
.93086 .54164 L
.92572 .53856 L
.92076 .53521 L
.91598 .5316 L
.91141 .52774 L
.90704 .52364 L
.9029 .51931 L
.89899 .51477 L
.89534 .51003 L
.89194 .5051 L
.88881 .5 L
F
0 g
newpath
.98601 .44388 .11224 116.374 150 arc
s
newpath
.96657 .63469 .09524 205.208 251.374 arc
s
newpath
.98601 .55612 .11224 160.208 210 arc
s
.95 g
.90922 .71072 m
.90671 .71119 L
.90426 .71188 L
.90188 .71279 L
.8996 .71392 L
.89742 .71524 L
.89538 .71676 L
.89348 .71846 L
.89174 .72032 L
.89018 .72233 L
.88881 .72448 L
.88881 .72448 L
.88672 .72051 L
.88496 .71638 L
.88353 .71213 L
.88245 .70777 L
.88172 .70334 L
.88134 .69887 L
.88133 .69439 L
.88167 .68991 L
.88237 .68548 L
.88342 .68112 L
.88342 .68112 L
.88542 .68453 L
.88755 .68786 L
.88983 .69109 L
.89224 .69423 L
.89477 .69726 L
.89743 .70019 L
.90021 .703 L
.90311 .7057 L
.90611 .70827 L
.90922 .71072 L
F
0 g
newpath
.93741 .69642 .05612 150 195.823 arc
s
newpath
.96657 .63469 .09524 127.028 150.823 arc
s
newpath
.91311 .73851 .02806 210 262.028 arc
s
.95 g
.88881 .72448 m
.88979 .72611 L
.89083 .72771 L
.89192 .72928 L
.89306 .7308 L
.89425 .73229 L
.89549 .73374 L
.89679 .73514 L
.89812 .7365 L
.89951 .73781 L
.90094 .73907 L
.90094 .73907 L
.89916 .73931 L
.89742 .73974 L
.89574 .74035 L
.89413 .74115 L
.89262 .74211 L
.89123 .74324 L
.88996 .74451 L
.88884 .74591 L
.88789 .74742 L
.8871 .74903 L
.8871 .74903 L
.88625 .74663 L
.88562 .74416 L
.88522 .74165 L
.88505 .7391 L
.88512 .73656 L
.88541 .73403 L
.88593 .73153 L
.88667 .7291 L
.88764 .72674 L
.88881 .72448 L
F
0 g
newpath
.91311 .73851 .02806 157.972 210 arc
s
newpath
.90222 .75544 .01642 202.972 265.534 arc
s
newpath
.93741 .69642 .05612 130.534 150 arc
s
.95 g
.91658 .69241 m
.91503 .69377 L
.91362 .69528 L
.91238 .69694 L
.91132 .69871 L
.91046 .70058 L
.90979 .70254 L
.90932 .70455 L
.90907 .7066 L
.90904 .70866 L
.90922 .71072 L
.90922 .71072 L
.90639 .7085 L
.90364 .70618 L
.90099 .70375 L
.89843 .70123 L
.89597 .69861 L
.89361 .6959 L
.89135 .6931 L
.8892 .69022 L
.88716 .68726 L
.88523 .68422 L
.88342 .68112 L
.88342 .68112 L
.88601 .68186 L
.88859 .68263 L
.89117 .68342 L
.89374 .68422 L
.89631 .68505 L
.89887 .6859 L
.90142 .68677 L
.90397 .68766 L
.9065 .68857 L
.90903 .6895 L
.91156 .69045 L
.91407 .69142 L
.91658 .69241 L
F
0 g
newpath
.79161 1.00508 .33672 285.823 291.787 arc
s
newpath
.96657 .63469 .09524 127.028 150.823 arc
s
newpath
.92883 .70797 .01981 172.028 231.787 arc
s
.95 g
.90922 .71072 m
.90822 .71221 L
.90739 .71379 L
.90673 .71546 L
.90626 .71719 L
.90599 .71896 L
.90591 .72075 L
.90602 .72254 L
.90633 .72431 L
.90683 .72603 L
.90751 .72769 L
.90751 .72769 L
.9057 .72708 L
.90387 .72654 L
.90203 .72606 L
.90017 .72564 L
.8983 .72529 L
.89641 .725 L
.89452 .72477 L
.89262 .72461 L
.89071 .72451 L
.88881 .72448 L
.88881 .72448 L
.89018 .72233 L
.89174 .72032 L
.89348 .71846 L
.89538 .71676 L
.89742 .71524 L
.8996 .71392 L
.90188 .71279 L
.90426 .71188 L
.90671 .71119 L
.90922 .71072 L
F
0 g
newpath
.91311 .73851 .02806 210 262.028 arc
s
newpath
.88881 .7806 .05612 270 289.466 arc
s
newpath
.92233 .72061 .01642 154.466 217.028 arc
s
.95 g
.92432 .32707 m
.92252 .32953 L
.92093 .33213 L
.91956 .33485 L
.91841 .33768 L
.91749 .34058 L
.91682 .34356 L
.91639 .34657 L
.9162 .34961 L
.91627 .35266 L
.91658 .35569 L
.91658 .35569 L
.91191 .35357 L
.90745 .35104 L
.90324 .3481 L
.89932 .3448 L
.89572 .34115 L
.89246 .33718 L
.88958 .33294 L
.8871 .32845 L
.88504 .32375 L
.88342 .31888 L
.88342 .31888 L
.88718 .32083 L
.89106 .32255 L
.89503 .32401 L
.89909 .32523 L
.90322 .32619 L
.9074 .32689 L
.91162 .32733 L
.91585 .32751 L
.92009 .32742 L
.92432 .32707 L
F
0 g
newpath
.93741 .30358 .05612 111.787 164.177 arc
s
newpath
.91658 .25949 .06803 83.4693 119.177 arc
s
newpath
.95361 .35035 .03741 171.787 218.469 arc
s
.95 g
.92432 .67293 m
.92252 .67047 L
.92093 .66787 L
.91956 .66515 L
.91841 .66232 L
.91749 .65942 L
.91682 .65644 L
.91639 .65343 L
.9162 .65039 L
.91627 .64734 L
.91658 .64431 L
.91658 .64431 L
.91191 .64643 L
.90745 .64896 L
.90324 .6519 L
.89932 .6552 L
.89572 .65885 L
.89246 .66282 L
.88958 .66706 L
.8871 .67155 L
.88504 .67625 L
.88342 .68112 L
.88342 .68112 L
.88718 .67917 L
.89106 .67745 L
.89503 .67599 L
.89909 .67477 L
.90322 .67381 L
.9074 .67311 L
.91162 .67267 L
.91585 .67249 L
.92009 .67258 L
.92432 .67293 L
F
0 g
newpath
.95361 .64965 .03741 141.531 188.213 arc
s
newpath
.93741 .69642 .05612 195.823 248.213 arc
s
newpath
.91658 .74051 .06803 240.823 276.531 arc
s
.95 g
.88342 .31888 m
.88601 .31814 L
.88859 .31737 L
.89117 .31658 L
.89374 .31578 L
.89631 .31495 L
.89887 .3141 L
.90142 .31323 L
.90397 .31234 L
.9065 .31143 L
.90903 .3105 L
.91156 .30955 L
.91407 .30858 L
.91658 .30759 L
.91658 .30759 L
.91638 .30977 L
.91641 .31197 L
.91667 .31415 L
.91715 .31629 L
.91785 .31836 L
.91876 .32036 L
.91988 .32224 L
.92119 .32401 L
.92267 .32562 L
.92432 .32707 L
.92432 .32707 L
.92009 .32742 L
.91585 .32751 L
.91162 .32733 L
.9074 .32689 L
.90322 .32619 L
.89909 .32523 L
.89503 .32401 L
.89106 .32255 L
.88718 .32083 L
.88342 .31888 L
F
0 g
newpath
.91658 .25949 .06803 83.4693 119.177 arc
s
newpath
.93741 .3106 .02104 128.469 188.213 arc
s
newpath
.79161 -0.00508 .33672 68.2132 74.1773 arc
s
.95 g
.91658 .69241 m
.91407 .69142 L
.91156 .69045 L
.90903 .6895 L
.9065 .68857 L
.90397 .68766 L
.90142 .68677 L
.89887 .6859 L
.89631 .68505 L
.89374 .68422 L
.89117 .68342 L
.88859 .68263 L
.88601 .68186 L
.88342 .68112 L
.88342 .68112 L
.88718 .67917 L
.89106 .67745 L
.89503 .67599 L
.89909 .67477 L
.90322 .67381 L
.9074 .67311 L
.91162 .67267 L
.91585 .67249 L
.92009 .67258 L
.92432 .67293 L
.92432 .67293 L
.92267 .67438 L
.92119 .67599 L
.91988 .67776 L
.91876 .67964 L
.91785 .68164 L
.91715 .68371 L
.91667 .68585 L
.91641 .68803 L
.91638 .69023 L
.91658 .69241 L
F
0 g
newpath
.91658 .74051 .06803 240.823 276.531 arc
s
newpath
.93741 .6894 .02104 171.787 231.531 arc
s
newpath
.79161 1.00508 .33672 285.823 291.787 arc
s
.95 g
.93659 .38366 m
.93276 .38492 L
.92894 .38621 L
.92513 .38753 L
.92133 .38889 L
.91755 .39027 L
.91378 .39169 L
.91002 .39314 L
.90627 .39462 L
.90253 .39614 L
.89881 .39768 L
.8951 .39926 L
.8914 .40086 L
.88772 .4025 L
.88405 .40417 L
.8804 .40588 L
.8804 .40588 L
.88247 .40057 L
.8848 .39537 L
.88739 .39029 L
.89024 .38536 L
.89333 .38057 L
.89666 .37595 L
.90022 .37151 L
.904 .36725 L
.908 .36318 L
.91219 .35933 L
.91658 .35569 L
.91658 .35569 L
.91726 .3592 L
.91827 .36263 L
.9196 .36594 L
.92124 .36911 L
.92318 .37211 L
.92539 .37492 L
.92786 .37749 L
.93057 .37983 L
.93349 .38189 L
.93659 .38366 L
F
0 g
newpath
.98601 .44388 .11224 199.792 231.787 arc
s
newpath
.95361 .35035 .03741 117.066 171.787 arc
s
newpath
1.08321 .83672 .47619 244.792 252.066 arc
s
.95 g
.93741 .41582 m
.93552 .4195 L
.934 .42335 L
.93286 .42733 L
.93213 .43141 L
.93179 .43553 L
.93186 .43967 L
.93234 .44378 L
.93322 .44783 L
.9345 .45177 L
.93615 .45556 L
.93615 .45556 L
.92899 .45282 L
.92206 .44951 L
.91543 .44566 L
.90913 .44128 L
.9032 .43641 L
.89769 .43108 L
.89262 .42532 L
.88803 .41918 L
.88395 .41268 L
.8804 .40588 L
.8804 .40588 L
.8854 .40759 L
.89046 .40914 L
.89556 .41054 L
.9007 .41177 L
.90587 .41284 L
.91108 .41375 L
.91632 .41449 L
.92157 .41507 L
.92684 .41549 L
.93212 .41574 L
.93741 .41582 L
F
0 g
newpath
.96657 .36531 .09524 108.626 154.792 arc
s
newpath
.93741 .24746 .16836 90 109.792 arc
s
newpath
.97386 .43687 .04209 153.626 210 arc
s
.95 g
.93741 .58418 m
.93552 .5805 L
.934 .57665 L
.93286 .57267 L
.93213 .56859 L
.93179 .56447 L
.93186 .56033 L
.93234 .55622 L
.93322 .55217 L
.9345 .54823 L
.93615 .54444 L
.93615 .54444 L
.92899 .54718 L
.92206 .55049 L
.91543 .55434 L
.90913 .55872 L
.9032 .56359 L
.89769 .56892 L
.89262 .57468 L
.88803 .58082 L
.88395 .58732 L
.8804 .59412 L
.8804 .59412 L
.8854 .59241 L
.89046 .59086 L
.89556 .58946 L
.9007 .58823 L
.90587 .58716 L
.91108 .58625 L
.91632 .58551 L
.92157 .58493 L
.92684 .58451 L
.93212 .58426 L
.93741 .58418 L
F
0 g
newpath
.97386 .56313 .04209 150 206.374 arc
s
newpath
.96657 .63469 .09524 205.208 251.374 arc
s
newpath
.93741 .75254 .16836 250.208 270 arc
s
.95 g
.8804 .59412 m
.88247 .59943 L
.8848 .60463 L
.88739 .60971 L
.89024 .61464 L
.89333 .61943 L
.89666 .62405 L
.90022 .62849 L
.904 .63275 L
.908 .63682 L
.91219 .64067 L
.91658 .64431 L
.91658 .64431 L
.91726 .6408 L
.91827 .63737 L
.9196 .63406 L
.92124 .63089 L
.92318 .62789 L
.92539 .62508 L
.92786 .62251 L
.93057 .62017 L
.93349 .61811 L
.93659 .61634 L
.93659 .61634 L
.93248 .61499 L
.92839 .6136 L
.92432 .61218 L
.92025 .61072 L
.9162 .60922 L
.91216 .60769 L
.90814 .60612 L
.90413 .60452 L
.90014 .60287 L
.89616 .6012 L
.8922 .59948 L
.88825 .59773 L
.88432 .59595 L
.8804 .59412 L
F
0 g
newpath
.95361 .64965 .03741 188.213 242.934 arc
s
newpath
1.08321 .16328 .47619 107.934 115.208 arc
s
newpath
.98601 .55612 .11224 128.213 160.208 arc
s
.95 g
.93659 .38366 m
.93521 .38672 L
.93415 .3899 L
.9334 .39317 L
.93299 .3965 L
.93291 .39985 L
.93316 .40319 L
.93374 .40649 L
.93465 .40972 L
.93588 .41284 L
.93741 .41582 L
.93741 .41582 L
.93212 .41574 L
.92684 .41549 L
.92157 .41507 L
.91632 .41449 L
.91108 .41375 L
.90587 .41284 L
.9007 .41177 L
.89556 .41054 L
.89046 .40914 L
.8854 .40759 L
.8804 .40588 L
.8804 .40588 L
.88405 .40417 L
.88772 .4025 L
.8914 .40086 L
.8951 .39926 L
.89881 .39768 L
.90253 .39614 L
.90627 .39462 L
.91002 .39314 L
.91378 .39169 L
.91755 .39027 L
.92133 .38889 L
.92513 .38753 L
.92894 .38621 L
.93276 .38492 L
.93659 .38366 L
F
0 g
newpath
.93741 .24746 .16836 90 109.792 arc
s
newpath
.96657 .39898 .03367 150 207.066 arc
s
newpath
1.08321 .83672 .47619 244.792 252.066 arc
s
.95 g
.93741 .58418 m
.93588 .58716 L
.93465 .59028 L
.93374 .59351 L
.93316 .59681 L
.93291 .60015 L
.93299 .6035 L
.9334 .60683 L
.93415 .6101 L
.93521 .61328 L
.93659 .61634 L
.93659 .61634 L
.93276 .61508 L
.92894 .61379 L
.92513 .61247 L
.92133 .61111 L
.91755 .60973 L
.91378 .60831 L
.91002 .60686 L
.90627 .60538 L
.90253 .60386 L
.89881 .60232 L
.8951 .60074 L
.8914 .59914 L
.88772 .5975 L
.88405 .59583 L
.8804 .59412 L
.8804 .59412 L
.8854 .59241 L
.89046 .59086 L
.89556 .58946 L
.9007 .58823 L
.90587 .58716 L
.91108 .58625 L
.91632 .58551 L
.92157 .58493 L
.92684 .58451 L
.93212 .58426 L
.93741 .58418 L
F
0 g
newpath
1.08321 .16328 .47619 107.934 115.208 arc
s
newpath
.93741 .75254 .16836 250.208 270 arc
s
newpath
.96657 .60102 .03367 152.934 210 arc
s
.95 g
.93615 .45556 m
.93487 .46019 L
.93411 .46494 L
.93388 .46974 L
.93419 .47453 L
.93502 .47926 L
.93638 .48388 L
.93824 .48831 L
.94057 .49251 L
.94336 .49642 L
.94656 .5 L
.94656 .5 L
.88881 .5 L
.88881 .5 L
.89194 .4949 L
.89534 .48997 L
.89899 .48523 L
.9029 .48069 L
.90704 .47636 L
.91141 .47226 L
.91598 .4684 L
.92076 .46479 L
.92572 .46144 L
.93086 .45836 L
.93615 .45556 L
F
0 g
.94656 .5 m
.88881 .5 L
s
newpath
.98601 .55612 .11224 210 243.626 arc
s
newpath
.97717 .46939 .04329 135 198.626 arc
s
.95 g
.88881 .5 m
.89194 .5051 L
.89534 .51003 L
.89899 .51477 L
.9029 .51931 L
.90704 .52364 L
.91141 .52774 L
.91598 .5316 L
.92076 .53521 L
.92572 .53856 L
.93086 .54164 L
.93615 .54444 L
.93615 .54444 L
.93487 .53981 L
.93411 .53506 L
.93388 .53026 L
.93419 .52547 L
.93502 .52074 L
.93638 .51612 L
.93824 .51169 L
.94057 .50749 L
.94336 .50358 L
.94656 .5 L
.94656 .5 L
.88881 .5 L
F
0 g
newpath
.97717 .53061 .04329 161.374 225 arc
s
.94656 .5 m
.88881 .5 L
s
newpath
.98601 .44388 .11224 116.374 150 arc
s
.95 g
.92432 .67293 m
.9242 .67458 L
.92423 .67624 L
.9244 .67789 L
.92471 .67952 L
.92517 .68111 L
.92576 .68266 L
.92649 .68415 L
.92734 .68558 L
.92831 .68692 L
.9294 .68817 L
.9294 .68817 L
.92802 .68818 L
.92664 .68829 L
.92528 .68849 L
.92394 .68878 L
.92262 .68917 L
.92132 .68964 L
.92007 .69021 L
.91886 .69086 L
.91769 .6916 L
.91658 .69241 L
.91658 .69241 L
.91638 .69023 L
.91641 .68803 L
.91667 .68585 L
.91715 .68371 L
.91785 .68164 L
.91876 .67964 L
.91988 .67776 L
.92119 .67599 L
.92267 .67438 L
.92432 .67293 L
F
0 g
newpath
.93741 .6894 .02104 171.787 231.531 arc
s
newpath
.92883 .70797 .01981 231.787 271.628 arc
s
newpath
.94324 .67509 .01905 136.628 186.531 arc
s
.95 g
.92432 .32707 m
.92468 .32918 L
.92528 .33123 L
.9261 .33321 L
.92714 .33508 L
.92838 .33682 L
.92981 .33841 L
.9314 .33983 L
.93315 .34106 L
.93503 .34209 L
.937 .3429 L
.937 .3429 L
.93504 .34388 L
.93309 .3449 L
.93117 .34595 L
.92926 .34704 L
.92738 .34817 L
.92552 .34934 L
.92368 .35054 L
.92187 .35177 L
.92008 .35305 L
.91832 .35435 L
.91658 .35569 L
.91658 .35569 L
.91627 .35266 L
.9162 .34961 L
.91639 .34657 L
.91682 .34356 L
.91749 .34058 L
.91841 .33768 L
.91956 .33485 L
.92093 .33213 L
.92252 .32953 L
.92432 .32707 L
F
0 g
newpath
.95361 .35035 .03741 171.787 218.469 arc
s
newpath
.98601 .44388 .11224 231.787 244.112 arc
s
newpath
.94324 .32491 .01905 109.112 173.469 arc
s
.95 g
.937 .6571 m
.93503 .65791 L
.93315 .65894 L
.9314 .66017 L
.92981 .66159 L
.92838 .66318 L
.92714 .66492 L
.9261 .66679 L
.92528 .66877 L
.92468 .67082 L
.92432 .67293 L
.92432 .67293 L
.92252 .67047 L
.92093 .66787 L
.91956 .66515 L
.91841 .66232 L
.91749 .65942 L
.91682 .65644 L
.91639 .65343 L
.9162 .65039 L
.91627 .64734 L
.91658 .64431 L
.91658 .64431 L
.91832 .64565 L
.92008 .64695 L
.92187 .64823 L
.92368 .64946 L
.92552 .65066 L
.92738 .65183 L
.92926 .65296 L
.93117 .65405 L
.93309 .6551 L
.93504 .65612 L
.937 .6571 L
F
0 g
newpath
.95361 .64965 .03741 141.531 188.213 arc
s
newpath
.98601 .55612 .11224 115.888 128.213 arc
s
newpath
.94324 .67509 .01905 186.531 250.888 arc
s
.95 g
.91658 .35569 m
.91896 .35658 L
.92138 .35736 L
.92383 .35803 L
.92631 .35859 L
.92881 .35904 L
.93132 .35937 L
.93386 .35959 L
.93639 .35969 L
.93893 .35968 L
.94147 .35955 L
.94147 .35955 L
.93989 .36158 L
.93853 .36376 L
.9374 .36607 L
.93651 .36848 L
.93587 .37097 L
.93549 .37351 L
.93537 .37608 L
.93551 .37864 L
.93592 .38118 L
.93659 .38366 L
.93659 .38366 L
.93349 .38189 L
.93057 .37983 L
.92786 .37749 L
.92539 .37492 L
.92318 .37211 L
.92124 .36911 L
.9196 .36594 L
.91827 .36263 L
.91726 .3592 L
.91658 .35569 L
F
0 g
newpath
.95361 .35035 .03741 117.066 171.787 arc
s
newpath
.96043 .37595 .02506 162.066 220.848 arc
s
newpath
.93741 .30358 .05612 85.8482 111.787 arc
s
.95 g
.94147 .64045 m
.93893 .64032 L
.93639 .64031 L
.93386 .64041 L
.93132 .64063 L
.92881 .64096 L
.92631 .64141 L
.92383 .64197 L
.92138 .64264 L
.91896 .64342 L
.91658 .64431 L
.91658 .64431 L
.91726 .6408 L
.91827 .63737 L
.9196 .63406 L
.92124 .63089 L
.92318 .62789 L
.92539 .62508 L
.92786 .62251 L
.93057 .62017 L
.93349 .61811 L
.93659 .61634 L
.93659 .61634 L
.93592 .61882 L
.93551 .62136 L
.93537 .62392 L
.93549 .62649 L
.93587 .62903 L
.93651 .63152 L
.9374 .63393 L
.93853 .63624 L
.93989 .63842 L
.94147 .64045 L
F
0 g
newpath
.95361 .64965 .03741 188.213 242.934 arc
s
newpath
.96043 .62405 .02506 139.152 197.934 arc
s
newpath
.93741 .69642 .05612 248.213 274.152 arc
s
.95 g
.937 .6571 m
.93654 .65817 L
.93619 .65929 L
.93595 .66044 L
.93582 .6616 L
.93581 .66278 L
.9359 .66395 L
.93612 .6651 L
.93644 .66623 L
.93687 .66732 L
.93741 .66836 L
.93741 .66836 L
.936 .66841 L
.93459 .66855 L
.9332 .66878 L
.93182 .66911 L
.93048 .66953 L
.92916 .67004 L
.92788 .67064 L
.92664 .67132 L
.92545 .67209 L
.92432 .67293 L
.92432 .67293 L
.92468 .67082 L
.92528 .66877 L
.9261 .66679 L
.92714 .66492 L
.92838 .66318 L
.92981 .66159 L
.9314 .66017 L
.93315 .65894 L
.93503 .65791 L
.937 .6571 L
F
0 g
newpath
.94324 .67509 .01905 186.531 250.888 arc
s
newpath
.93741 .6894 .02104 231.531 270 arc
s
newpath
.94782 .66235 .01203 150 205.888 arc
s
.95 g
.94147 .64045 m
.94016 .64172 L
.93901 .64315 L
.93804 .6447 L
.93726 .64635 L
.93668 .64809 L
.93631 .64988 L
.93616 .6517 L
.93623 .65353 L
.93651 .65533 L
.937 .6571 L
.937 .6571 L
.93504 .65612 L
.93309 .6551 L
.93117 .65405 L
.92926 .65296 L
.92738 .65183 L
.92552 .65066 L
.92368 .64946 L
.92187 .64823 L
.92008 .64695 L
.91832 .64565 L
.91658 .64431 L
.91658 .64431 L
.91896 .64342 L
.92138 .64264 L
.92383 .64197 L
.92631 .64141 L
.92881 .64096 L
.93132 .64063 L
.93386 .64041 L
.93639 .64031 L
.93893 .64032 L
.94147 .64045 L
F
0 g
newpath
.93741 .69642 .05612 248.213 274.152 arc
s
newpath
.98601 .55612 .11224 115.888 128.213 arc
s
newpath
.95152 .65207 .01536 160.888 229.152 arc
s
.95 g
.93615 .45556 m
.93762 .45826 L
.93927 .46085 L
.94112 .46331 L
.94313 .46563 L
.94531 .46779 L
.94765 .46979 L
.95012 .47162 L
.95272 .47326 L
.95543 .4747 L
.95824 .47595 L
.95824 .47595 L
.95614 .47776 L
.95422 .47974 L
.95249 .4819 L
.95095 .4842 L
.94964 .48663 L
.94854 .48917 L
.94768 .4918 L
.94706 .4945 L
.94669 .49724 L
.94656 .5 L
.94656 .5 L
.94336 .49642 L
.94057 .49251 L
.93824 .48831 L
.93638 .48388 L
.93502 .47926 L
.93419 .47453 L
.93388 .46974 L
.93411 .46494 L
.93487 .46019 L
.93615 .45556 L
F
0 g
newpath
.97717 .46939 .04329 135 198.626 arc
s
newpath
.97717 .5 .03061 180 231.787 arc
s
newpath
.97386 .43687 .04209 111.787 153.626 arc
s
.95 g
.95824 .52405 m
.95543 .5253 L
.95272 .52674 L
.95012 .52838 L
.94765 .53021 L
.94531 .53221 L
.94313 .53437 L
.94112 .53669 L
.93927 .53915 L
.93762 .54174 L
.93615 .54444 L
.93615 .54444 L
.93487 .53981 L
.93411 .53506 L
.93388 .53026 L
.93419 .52547 L
.93502 .52074 L
.93638 .51612 L
.93824 .51169 L
.94057 .50749 L
.94336 .50358 L
.94656 .5 L
.94656 .5 L
.94669 .50276 L
.94706 .5055 L
.94768 .5082 L
.94854 .51083 L
.94964 .51337 L
.95095 .5158 L
.95249 .5181 L
.95422 .52026 L
.95614 .52224 L
.95824 .52405 L
F
0 g
newpath
.97717 .53061 .04329 161.374 225 arc
s
newpath
.97717 .5 .03061 128.213 180 arc
s
newpath
.97386 .56313 .04209 206.374 248.213 arc
s
.95 g
.93659 .61634 m
.93745 .61792 L
.9384 .61946 L
.93943 .62094 L
.94053 .62237 L
.94172 .62373 L
.94297 .62503 L
.94429 .62626 L
.94568 .62742 L
.94712 .6285 L
.94862 .62951 L
.94862 .62951 L
.94745 .6302 L
.94636 .63101 L
.94535 .63193 L
.94444 .63295 L
.94363 .63405 L
.94294 .63523 L
.94238 .63647 L
.94194 .63776 L
.94164 .63909 L
.94147 .64045 L
.94147 .64045 L
.93989 .63842 L
.93853 .63624 L
.9374 .63393 L
.93651 .63152 L
.93587 .62903 L
.93549 .62649 L
.93537 .62392 L
.93551 .62136 L
.93592 .61882 L
.93659 .61634 L
F
0 g
newpath
.96043 .62405 .02506 139.152 197.934 arc
s
newpath
.95491 .64142 .01347 184.152 242.204 arc
s
newpath
.96657 .60102 .03367 122.204 152.934 arc
s
.95 g
.93741 .41582 m
.93876 .41796 L
.94026 .42 L
.94192 .42192 L
.94371 .42371 L
.94563 .42536 L
.94767 .42685 L
.94982 .4282 L
.95206 .42937 L
.95439 .43038 L
.95678 .4312 L
.95678 .4312 L
.95396 .43285 L
.95127 .43471 L
.94873 .43676 L
.94634 .439 L
.94414 .44141 L
.94212 .44398 L
.94031 .4467 L
.9387 .44955 L
.93731 .45251 L
.93615 .45556 L
.93615 .45556 L
.9345 .45177 L
.93322 .44783 L
.93234 .44378 L
.93186 .43967 L
.93179 .43553 L
.93213 .43141 L
.93286 .42733 L
.934 .42335 L
.93552 .4195 L
.93741 .41582 L
F
0 g
newpath
.97386 .43687 .04209 153.626 210 arc
s
newpath
.97717 .46939 .04329 198.626 241.898 arc
s
newpath
.96657 .39898 .03367 106.898 150 arc
s
.95 g
.95678 .5688 m
.95439 .56962 L
.95206 .57063 L
.94982 .5718 L
.94767 .57315 L
.94563 .57464 L
.94371 .57629 L
.94192 .57808 L
.94026 .58 L
.93876 .58204 L
.93741 .58418 L
.93741 .58418 L
.93552 .5805 L
.934 .57665 L
.93286 .57267 L
.93213 .56859 L
.93179 .56447 L
.93186 .56033 L
.93234 .55622 L
.93322 .55217 L
.9345 .54823 L
.93615 .54444 L
.93615 .54444 L
.93731 .54749 L
.9387 .55045 L
.94031 .5533 L
.94212 .55602 L
.94414 .55859 L
.94634 .561 L
.94873 .56324 L
.95127 .56529 L
.95396 .56715 L
.95678 .5688 L
F
0 g
newpath
.97386 .56313 .04209 150 206.374 arc
s
newpath
.97717 .53061 .04329 118.102 161.374 arc
s
newpath
.96657 .60102 .03367 210 253.102 arc
s
.95 g
.93741 .58418 m
.9386 .58612 L
.9399 .588 L
.9413 .5898 L
.94279 .59153 L
.94438 .59317 L
.94605 .59473 L
.9478 .59619 L
.94963 .59755 L
.95153 .59881 L
.9535 .59997 L
.9535 .59997 L
.95118 .60076 L
.94895 .60178 L
.94683 .603 L
.94484 .60443 L
.943 .60605 L
.94133 .60783 L
.93983 .60977 L
.93854 .61185 L
.93745 .61405 L
.93659 .61634 L
.93659 .61634 L
.93521 .61328 L
.93415 .6101 L
.9334 .60683 L
.93299 .6035 L
.93291 .60015 L
.93316 .59681 L
.93374 .59351 L
.93465 .59028 L
.93588 .58716 L
.93741 .58418 L
F
0 g
newpath
.96657 .60102 .03367 152.934 210 arc
s
newpath
.96043 .62405 .02506 197.934 253.936 arc
s
newpath
.97386 .56313 .04209 118.936 150 arc
s
.95 g
.93615 .54444 m
.93827 .54546 L
.94041 .54644 L
.94256 .54737 L
.94474 .54826 L
.94693 .5491 L
.94915 .54989 L
.95138 .55064 L
.95362 .55134 L
.95588 .552 L
.95815 .55261 L
.96043 .55317 L
.96043 .55317 L
.95935 .55445 L
.9584 .55584 L
.95761 .55732 L
.95698 .55888 L
.95651 .56049 L
.95621 .56215 L
.95609 .56382 L
.95615 .5655 L
.95638 .56717 L
.95678 .5688 L
.95678 .5688 L
.95396 .56715 L
.95127 .56529 L
.94873 .56324 L
.94634 .561 L
.94414 .55859 L
.94212 .55602 L
.94031 .5533 L
.9387 .55045 L
.93731 .54749 L
.93615 .54444 L
F
0 g
newpath
.97717 .53061 .04329 118.102 161.374 arc
s
newpath
.97212 .56414 .01603 163.102 223.174 arc
s
newpath
.98601 .44388 .11224 103.174 116.374 arc
s
.95 g
.95678 .5688 m
.95604 .5704 L
.95549 .57208 L
.95513 .57382 L
.95498 .57558 L
.95503 .57735 L
.95528 .5791 L
.95573 .58081 L
.95638 .58245 L
.95721 .58401 L
.95821 .58547 L
.95821 .58547 L
.95633 .58525 L
.95444 .58504 L
.95256 .58486 L
.95067 .5847 L
.94878 .58456 L
.94688 .58445 L
.94499 .58435 L
.9431 .58428 L
.9412 .58422 L
.9393 .58419 L
.93741 .58418 L
.93741 .58418 L
.93876 .58204 L
.94026 .58 L
.94192 .57808 L
.94371 .57629 L
.94563 .57464 L
.94767 .57315 L
.94982 .5718 L
.95206 .57063 L
.95439 .56962 L
.95678 .5688 L
F
0 g
newpath
.96657 .60102 .03367 210 253.102 arc
s
newpath
.93741 .75254 .16836 270 277.098 arc
s
newpath
.97033 .57603 .01536 142.098 208.102 arc
s
.95 g
.95824 .52405 m
.95808 .52574 L
.95808 .52744 L
.95824 .52914 L
.95857 .5308 L
.95905 .53243 L
.95969 .53401 L
.96047 .53552 L
.9614 .53694 L
.96246 .53827 L
.96364 .53949 L
.96364 .53949 L
.96109 .53961 L
.95855 .53979 L
.95602 .54004 L
.95349 .54035 L
.95097 .54074 L
.94846 .54119 L
.94597 .5417 L
.94348 .54229 L
.94102 .54294 L
.93858 .54366 L
.93615 .54444 L
.93615 .54444 L
.93762 .54174 L
.93927 .53915 L
.94112 .53669 L
.94313 .53437 L
.94531 .53221 L
.94765 .53021 L
.95012 .52838 L
.95272 .52674 L
.95543 .5253 L
.95824 .52405 L
F
0 g
newpath
.97386 .56313 .04209 206.374 248.213 arc
s
newpath
.96657 .63469 .09524 251.374 268.236 arc
s
newpath
.97578 .52658 .01772 133.236 188.213 arc
s
.95 g
.94656 .5 m
.94826 .50161 L
.95004 .50312 L
.9519 .50454 L
.95384 .50585 L
.95584 .50706 L
.9579 .50815 L
.96003 .50914 L
.9622 .51001 L
.96441 .51076 L
.96666 .51138 L
.96666 .51138 L
.96535 .51225 L
.96412 .51323 L
.96299 .51432 L
.96195 .5155 L
.96102 .51677 L
.96021 .51811 L
.95952 .51953 L
.95896 .52099 L
.95853 .52251 L
.95824 .52405 L
.95824 .52405 L
.95614 .52224 L
.95422 .52026 L
.95249 .5181 L
.95095 .5158 L
.94964 .51337 L
.94854 .51083 L
.94768 .5082 L
.94706 .5055 L
.94669 .50276 L
.94656 .5 L
F
0 g
newpath
.97717 .5 .03061 128.213 180 arc
s
newpath
.97578 .52658 .01772 188.213 239.05 arc
s
newpath
.97717 .46939 .04329 104.05 135 arc
s
.85 g
.5 .5 m
.74649 .5 L
.74649 .5 L
.73495 .51196 L
.72383 .52431 L
.71314 .53704 L
.70291 .55014 L
.69314 .56359 L
.68384 .57737 L
.67504 .59146 L
.66673 .60586 L
.65892 .62053 L
.65164 .63547 L
.64488 .65066 L
.63865 .66607 L
.63296 .68169 L
.62783 .69749 L
.62325 .71347 L
.62325 .71347 L
.5 .5 L
F
0 g
.5 .5 m
.74649 .5 L
s
newpath
1.08321 .83672 .47619 195 225 arc
s
.62325 .71347 m
.5 .5 L
s
.004 w
newpath
.5 .5 .47619 0 365.73 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l06`000?l06`000?l06`000?l06`000?l0
6`000?l06`000?l06`0008<04on40000N@0:oa<02_mj0000M005obL01Ome0000K`05oc401Om`0000
JP05oc/01Om[0000I`03odD00omX0000I003oa<000?o00008@000ol0000A00?oI@0006400olF0003
o`00024000?o00005003of80001N00?o60000om@o`0@0003o`0000h000?o0?l06003oel0001K00?o
6`001?m@D?l>0003oe3o00h000CoD53o6`03oe`0001I00;o7002o`=@00<0o`002`001Om@D03o00`0
00?oD5000U02oa`00_mJ0000EP03oa8000?o000020000ol0D004D0030?l000X000GoD51@o`0;0003
o`1@00=@0P000ol000080003o`0001000omG0000E002oaD00_l700;o00<0D5001E000ol000080003
oe1@00=@00?o000020000om@D005D0040?ooo`H00_lE00?oE00005400olG0003oe3o00Ko00@0oooo
1e000ol0000500;o1e03o`H000?oD5001E03o`801_l00e3o000G00;oDP00050000?o000060000om@
D006D005oe1@D?l01e02o`800ol;D0050?ooo`000_l7D005oe1@D?l025000ol0000H0003o`0004l0
001>00;o70000om@D005D003oe1@009@1?l4D0?o4E03o`A@1?l4D003oe1@00E@00?o00006P03odh0
001;00?o5@000ol000060003oe1@00E@00?oD5001U04o`03D?m@00?o3502o`03D?m@00Co25000om@
D005D003o`0000H000?o00005002od`0001:0003o`0001D000?oD?l01`000om@D005D003oe1@00Y@
00?oD?l00e02o`M@0ol2D003oe3o00a@00?oD5001E000ol000050003oe3o01L000?o0000B@0004P0
0_lG0004oe1@o`L000?oD5001E000om@D009D004oe1@o`E@1ol5D004oe00o`]@00?oD5001E000ol0
00050004oe00oaL00_m90000A`000ol0000F0003oe1@009@00?o000010000om@D004D003oe1@00U@
00GoD51@o`0AD005oe1@0?l02e000om@D004D003o`0000@000?oD5000U000ol0000F0003o`0004H0
001500;o5`02o`E@00?o000010000om@D004D003oe1@00Q@00?oD5000e000om@D00=D003oe1@009@
00<0oe002E000om@D004D003o`0000@000?oD5000e03oaH00_m60000A0000ol0000D00?o2502o`@0
00?oD5000e000om@D008D003oe1@00A@00?oD5003E000om@D003D0030?m@00U@00?oD5000U000`3o
000300;o25000`3oo`0F0003o`0004<0001200;o5@03o`]@00<0o`000`000om@D002D003oe1@00I@
0_l7D003oe1@00e@00?oD5001E02o`Q@00?oD5000U000ol000020003o`1@00Y@0olE00;o@`000400
0_lF0005o`3oD?l02e000ol000020005oe1@D?l025000om@D008D003oe1@00]@00?oD50025000om@
D006D005oe1@D?l010000om@D009D005oe3o0?l05P02od40000o0003o`0001D000CoD53o0U000om@
D009D005o`000?l00e000om@D005D003oe1@00U@00?oD5002e000om@D008D0030?m@00I@00GoD51@
o`030003oe1@00U@00CoD53o0U000ol0000E0003o`0003h0000m00;o3P02o`@01?l3D004oe1@D0;o
2U001?l00?l2D003oe1@00E@00?oD5002U000om@D00;D003oe1@00Y@00?oD5001E001?m@D?l20003
oe1@00Q@0_l3D004oe1@D0Co1003o`d00_ln0000?0000ol0000>0003oe3o00?o00<0D5000e000om@
D004D0?o25001Ol0oe3o00I@0_l>D003oe1@00U@00?oD5003503o`E@00GoD?l0o`09D0;o1U000om@
D003D0030?oo00;o00=@o`001_l90003o`0003/0000k0003o`00010000?oD50025000om@D007D0;o
1e03o`=@1?l@D003oe1@00U@00?oD5003e03o`=@0ol7D0?o25000om@D008D0;o1U000ol000080003
o`0003X0000j0003o`00014000?oD50025000om@D009D0go55000om@D009D003oe1@019@3Ol;D003
oe1@00Q@00?oD?l01E000ol000090003o`0003T0000h00;o5@000om@D007D003oe1@015@0_lGD003
oe1@00U@00?oD5005E02oa=@00?oD5001e001?m@D?l5D003o`0000X000?o0000>00003L000?o0000
5P000om@D006D003oe1@011@00?oD?l00_lFD003oe1@00M@00?oD5005503o`03D?m@015@00?oD500
1U000om@D002D003oe1@009@00?o00002`000ol0000g0000=P000ol0000G0003oe1@00I@00?oD500
3e001?m@D?l2D003oe1@01A@00?oD5001E000om@D00DD004oe1@o`9@00?oD5003e000om@D006D003
oe1@00=@0_l2D003o`0000`000?o0000=P0003D000?o00006@000om@D005D003oe1@00i@00GoD51@
o`03D0;o55000om@D005D003oe1@019@0_l3D005oe1@D?l045000om@D005D003oe1@00I@00CoD53o
3P02ocH0000d0003o`0001X000?oD50015000om@D00=D0;o15000om@D003D0;o4e000om@D003D003
oe1@015@0_l5D003oe1@009@0_l?D003oe1@00A@00?oD5001e000om@o`0800;o1P000ol0000c0000
<`000ol0000>00;o30000om@D003D003oe1@00a@00?oD50015000om@D005D0;o4E000om@D003D003
oe1@00m@0_l7D003oe1@00A@00?oD50035000om@D003D003oe1@00U@2_l00e3o00060003o`000380
000b0003o`0000l000Co0?oo2P000om@D002D003oe1@00]@0_l7D003oe1@00M@0_l?D003oe1@00=@
00?oD5003E02o`U@00?oD5001E03o`a@00?oD5000U000om@D008D0;o00=@ool01e000ol000060003
o`000340000a0003o`00010000CoD5000_l90005oe1@D?l02U03o`U@00?oD5002E04o`a@00GoD51@
o`0<D0Co2e000om@D008D0;o2U001Om@D53o00U@0_l3D003oe3o00I@00?o00001`000ol0000`0000
<0000ol0000A0004oe1@D0800_l80003oe3o00U@0_l<D003oe1@00e@0_l:D005oe1@D?l02U02o`m@
00?oD5002U02o`U@00?oD?l02502o`E@00CoD53o1E000ol000080003o`0002l0000_0003o`000180
00?oD50015000`3oo`060003oe3o00I@0ol>D003oe1@00m@1?l7D003oe3o00M@1?lAD003oe1@00a@
0ol6D003oe3o00I@0_l7D004oe1@D0?o0U000ol000090003o`0002h0000^0003o`0001<000?oD500
1e0?oa5@00?oD5004e0AoaE@00?oD5003e0?o`U@00?oD5001504o`/000?o0000;@0002d000?o0000
50000om@D00>D003oe1@01I@00?oD5006e000om@D00KD003oe1@01I@00?oD5003U000om@D007D003
o`0000X000?o0000;00002`000?o00005@000om@D00=D003oe3o01M@00?oD5006U000om@o`0LD003
oe1@01E@00?oD?l03e000om@D006D003oe3o00`000?o0000:`0002/000?o00005P000om@D00=D003
oe3o01M@00?oD5006E001Om@D53o01]@00?oD5005E001?m@D?l>D003oe1@00I@00CoD53o30000ol0
000Z0000:P000ol0000G0003oe1@00a@00GoD51@o`0FD003oe1@01U@00GoD51@o`0KD003oe1@01A@
00GoD51@o`0>D003oe1@00E@00?oD5000U02o`/000?o0000:@0002T000?o000060000om@D00;D003
oe1@00=@00?oD5004e000om@D00HD003oe1@00=@00?oD50065000om@D00CD003oe1@00=@00?oD500
2e000om@D005D003oe1@00A@1Ol70003o`0002P0000X0003o`0001T000?oD5002U000om@D004D003
oe1@01=@00?oD50065000om@D003D003oe1@01Q@00?oD5004e000om@D004D003oe1@00Y@00?oD500
15000om@D007D0;o00<0o`001P000ol0000W0000:0000ol0000I0003oe1@00U@00?oD5001U000om@
D00BD003oe1@01M@00?oD5001E000om@D00GD003oe1@019@00?oD5001U000om@D009D003oe1@00A@
00?oD5001E02o`04D?m@00Co10000ol0000V00009`000ol0000I0003oe1@00Q@0_l9D003oe1@019@
00?oD5005U000om@D007D003oe1@01I@00?oD5004U000om@D007D0;o2U000om@D002D003oe1@00E@
00GoD51@o`05D003o`0000<000?o00009@0002H000?o00006P000om@D007D003oe1@00Y@00?oD500
4E000om@D00FD003oe1@00M@00?oD5005U000om@D00AD003oe1@00Y@00?oD5001e000om@D002D003
oe1@00A@00?oD5000U000om@D002D003o`0000D000?o0000900002D000?o00006P000om@D006D0;o
3E000om@D00AD003oe1@01E@00?oD5002E000om@D00ED003oe1@015@00?oD5002e02o`Q@00GoD51@
o`05D003oe1@00A@00GoD51@o`070003o`0002@0000T0003o`0001/000?oD5001E000om@D00>D003
oe1@00m@00?oD5005E000om@D00;D003oe1@01E@00?oD5003e000om@D00>D003oe1@00E@00GoD51@
o`03D0;o1e001Om@D53o00<00_l30003o`0002<0000S0003o`0001`000?oD50015000om@D00@D003
oe1@00i@00?oD50055000om@D00=D003oe1@01A@00?oD5003U000om@D00@D003oe1@00A@00CoD53o
0e000om@D008D004oe3o00?o00=@o`000`000ol0000R00008P000ol0000L0003oe1@00=@0_lCD003
oe1@00i@00?oD5004e000om@D00?D003oe1@01=@00?oD5003U000om@D00AD0;o1E001?m@oe02o`a@
0ol01@1@D53o00D000?o00008@00024000?o00002P02oa4000?oD5000olFD003oe1@00e@00?oD500
4U000om@D00AD003oe1@019@00?oD5003E000om@D00DD0?o0U001?m@ool>D0;o1E000ol000040003
o`000200000Q0003o`0000X000?oD?l01?l;00Co6E000om@D00=D003oe1@015@00?oD5004e000om@
D00AD003oe1@00e@00?oD5005e02o`03D?oo00Y@1Ol0153oool3D0030?l000@000?o000080000200
00?o00002`000e3oD004D0go75000om@D00<D003oe1@015@00?oD5004e000om@D00AD003oe1@00a@
00?oD5006U0=o`E@00CoD51@1_l50003o`0001l0000O0003o`0000`000?oD5003U02o`03D?m@01Y@
00?oD50035000om@D00@D003oe1@01E@00?oD50045000om@D00<D003oe1@01U@00CoD?oo45000om@
D005D003o`0000@000?o00007P0001l000?o000030000om@D00<D0;o00E@oe1@o`0KD003oe1@00]@
00?oD5003e000om@D00GD003oe1@00m@00?oD5002e000om@D00ID005oe1@oe000_l>D003oe1@00A@
00?o0?l01@000ol0000N00007P000ol0000=0003oe1@00]@00GoD51@o`03D0?o6E000om@D00:D003
oe1@00i@00?oD5006E000om@D00>D003oe1@00Y@00?oD5006502o`=@00GoD51@o`0=D003oe1@00=@
00CoD53o1P000ol0000M00007@000ol0000>0003oe1@00Y@00?oD5000U000om@D003D0030?m@01M@
00?oD5002E000om@D00>D003oe1@01]@00?oD5003U000om@D009D003oe1@01I@0_l5D003oe1@009@
00?oD5002U000om@D003D005oe1@D?l01P000ol0000L00007@000ol0000>0003oe1@00U@00?oD500
0e000om@D004D0030?m@01M@00?oD50025000om@D00=D003oe1@01e@00?oD5003E000om@D008D003
oe1@01I@00?oD5001E000om@D002D0030?m@00Y@00?oD5000U000om@D002D0;o1@000ol0000L0000
70000ol0000?0003oe1@00M@0_l6D003oe1@00I@0olED003oe1@00Q@00?oD5002e02ob5@0_l=D003
oe1@00Q@00?oD5005502o`Q@00?oD5001502o`U@00?oD5000U001_m@D53oD0L000?o00006`0001`0
00?o00003P000om@D007D003oe1@00I@00?oD5002E000om@D00CD003oe1@00M@00?oD5002U000om@
D00SD003oe1@00Y@00?oD5001e000om@D00CD0;o2U000om@D006D003oe1@00M@00CoD53o15000ol0
00060003o`0001/0000K0003o`0000h000?oD5001U02o`U@00?oD5002U000om@D00BD003oe1@00M@
00?oD5002E000om@D00UD003oe1@00U@00?oD5001e000om@D00BD003oe1@00Y@00?oD5001e03o`M@
00?oD?l00U02o`X000?o00006P0001X000?o00003`000om@D004D0;o2e000om@D00;D0?o4U000om@
D006D003oe1@00Q@00?oD5009e000om@D008D003oe1@00I@00?oD5004E02o`e@00?oD50025000`1@
o`02o`A@00GoD?m@o`0700;o10000ol0000I00006P000ol0000>0003oe1@009@0ol=D003oe1@00i@
0ol@D003oe1@00A@00?oD50025000om@D00YD003oe1@00Q@00?oD50015000om@D00?D0?o3e000om@
D00=D003oe1@009@0ol500?o00=@o`000`000ol0000I00006@000ol0000>00Ko45000om@D00AD0;o
3U000om@D004D003oe1@00M@00?oD500:e000om@D007D003oe1@00A@00?oD5003503oa9@00?oD500
3U0<o`=@00?o000010000ol0000H000060000ol0000?0003D?m@01=@00?oD5004U00103oool<D003
oe1@00=@00?oD5001E02obm@0_l7D003oe1@00=@00?oD5002e02oaE@00?oD5004U03o`Q@00?o0000
1@000ol0000G000060000ol0000?0003oe3o01=@00?oD5005E000`3oo`0:D003oe1@00=@00?oD500
15000om@D00aD003oe1@00A@00?oD5000e000om@D008D0?o5e000om@D00AD004oe3oD0;o1U000ol0
00050003o`0001L0000G0003o`00010000CoD53o4U000om@D00HD003oe1@00Q@00?oD5000U000om@
D003D003oe1@03=@00?oD5000e000om@D002D003oe1@00Q@00?oD50065000om@D00@D004oe1@o`=@
00?oD5000e000`3o00060003o`0001H0000F0003o`00014000GoD51@o`0AD003oe1@01U@0_l8D005
oe1@D?l01E000om@D00eD003oe1@00=@00GoD51@o`08D0;o6e000om@D00?D005oe1@D?l01503o`=@
00?o00001P000ol0000E00005P000ol0000@0003oe1@00=@00?oD5003U000om@D00KD0Ko0e001?m@
D?l3D0;o>E03o`9@00CoD53o1505oae@00?oD5003U000om@D003D003oe1@00A@1?l80003o`0001D0
000E0003o`00014000?oD50015000om@D00=D003oe1@025@0ol00e3oD004oci@0ol0153oD503ob9@
00?oD5003E000om@D004D003oe1@00M@0_l80003o`0001@0000E0003o`00014000?oD5001E000om@
D00;D003oe1@02E@1?m3D0Go9U000om@D00;D003oe1@00E@00?oD5001U001?m@D?l70003o`0001@0
000E0003o`00014000?oD5001E000om@D00;D003oe1@02M@0_m3D0;o:E000om@D00;D003oe1@00E@
00?oD5001U001?m@D503o`@000?o0000500001@000?o00004@000om@D007D003oe1@00Y@00?oD500
9U02o`03D?oo00?o>E05o`03D?oo02Q@00?oD5002U000om@D007D003oe1@00E@00?oD5000e000`3o
00030003o`0001<0000C0003o`00014000?oD5002E000om@D009D003oe1@02A@0_l00e3oo`05D0Ko
;E06o`E@0_l0153ooolUD003oe1@00U@00?oD5002E000om@D004D003oe1@00=@00?o000010000ol0
000B00004`000ol0000A0003oe1@00Y@00?oD5001e000om@D00RD0?o0e02o`]@1olOD0Oo2e02o`A@
0olSD003oe1@00M@00?oD5002U000om@D003D003oe1@00=@00?o00001@000ol0000B00004`000ol0
000@0003oe1@00a@00?oD5001U000om@D00OD0?o1E001?m@D?lAD0go1E0=oa5@00CoD53o1U03ob1@
00?oD5001U000om@D00<D003oe1@009@00?oD5000U000ol000070003o`000140000B0003o`000100
00?oD5003E000om@D006D003oe1@01a@0ol8D005oe1@D?l07E05oae@00GoD51@o`09D0;o7U000om@
D006D003oe1@00e@00GoD51@o`03D003o`0000P000?o00004@00014000?o000040000om@D00?D003
oe1@00E@00?oD5006e000om@D009D005oe1@D?l0?e001Om@D53o00]@00?oD5006e000om@D005D003
oe1@00m@00CoD53o0U000ol0000300;o10000ol0000A00004@000ol0000?0003o`1@015@00?oD500
0e000om@D00JD0;o35000om@D002D003oe1@03]@00?oD5000U000om@D00:D0?o6e000om@D003D003
oe1@015@00GoD?m@o`0400;o00=@o`0010000ol0000@00004@000ol0000=00;o55000om@D003D003
oe1@01M@0ol=D003oe1@00=@00?oD500>e000om@D003D003oe1@00a@0_lID003oe1@00=@00?oD500
4U02o`03D?oo00?o0e000ol000030003o`000100000A0003o`0000`00_lFD005oe1@D?l05E05oa1@
00?oD50015000om@D00iD003oe1@00A@00?oD5003U06oaA@00GoD51@o`0FD0?o1e000ol000030003
o`000100000@0003o`0000d000?oD?l01?lAD005oe1@D?l04U03oaA@00?oD5001U000om@D00gD003
oe1@00I@00?oD5004e03oa5@00GoD51@o`0AD0Go00=@oe000ol5D003o`0000<000?o00003`0000l0
00?o00003P02o`E@1?l=D004oe1@o`e@1_lGD003oe1@00I@00?oD500=e000om@D006D003oe1@01I@
1Ol=D004oe1@o`e@1?l5D0;o1503o`9@0_l50003o`0000h0000?0003o`0000d000CoD53o250:o`A@
00?oD?l01509oaa@00?oD50025000om@D00eD003oe1@00Q@00?oD5006U09o`A@00?oD?l0150:o`Q@
00CoD53o1U02o`03D?l000@000?o00003P0000l000?o00003@001?m@D?lBD0_o9E000om@D008D003
oe1@03E@00?oD50025000om@D00SD0_o4U001?m@D?l8D003oe3o00@000?o00003P0000h000?o0000
3@000om@D002D003oe1@01=@00?oD?l0:E000om@D009D003oe1@03=@00?oD5002E000om@D00WD003
oe3o01E@00?oD5000U000om@D005D004oe3oo`@000?o00003@0000h000?o000030000om@D003D003
oe1@01=@00CoD53o:5000om@D009D003oe1@03=@00?oD5002E000om@D00VD004oe1@oaE@00?oD500
0e000om@D003D006oe1@D03o0`000ol0000=00003P000ol0000;0003oe1@00A@00?oD5004U001Om@
D53o02Q@00?oD5002U000om@D00aD003oe1@00Y@00?oD5009U001Om@D53o01A@00?oD50015000om@
D002D003oe1@009@0_l20003o`0000d0000=0003o`0000/000?oD5001E000om@D00BD003oe1@009@
00?oD50095000om@D00<D003oe1@02m@00?oD50035000om@D00TD003oe1@009@00?oD5004U000om@
D005D006oe1@D?m@0ol50003o`0000`0000=0003o`0000X000?oD5001U000om@D00@D0;o1E000om@
D00TD003oe1@00a@00?oD500;e000om@D00<D003oe1@02A@00?oD5000e02oa9@00?oD5001U000om@
D002o`03D00000D000?o0000300000d000?o00001`03o`U@00?oD5003e000om@D005D003oe1@02=@
00?oD5003U000om@D00]D003oe1@00i@00?oD5008e000om@D005D003oe1@00m@00?oD5001e04o`P0
00?o0000300000d000?o000020000om@D009D003oe1@00i@00?oD5001U000om@D00RD003oe1@00i@
00?oD500;E000om@D00>D003oe1@029@00?oD5001U000om@D00>D003oe1@00U@0_l0103oool50003
o`0000`0000<0003o`0000T000=@oe002E000om@D00=D003oe1@00M@00?oD5008E000om@D00@D003
oe1@02]@00?oD50045000om@D00QD003oe1@00M@00?oD5003E000om@D008D004oe1@o`=@0ol30003
o`0000/0000<0003o`0000X000=@oe0025000om@D00<D003oe1@00Q@00?oD5008E000om@D00AD003
oe1@02U@00?oD5004E000om@D00QD003oe1@00Q@00?oD50035000om@D007D005oe1@D?l015000ol0
00020003o`0000/0000<0003o`0000/000=@oe001e000om@D00;D003oe1@00Y@00?oD5007e000om@
D00BD003oe1@02U@00?oD5004U000om@D00OD003oe1@00Y@00?oD5002e000om@D006D003oe1@009@
00?oD5000U000ol000020003o`0000/0000;0003o`0000h000?oD5001E000om@D009D0;o3U000om@
D00ND003oe1@01=@00?oD5009e000om@D00CD003oe1@01i@00?oD5003502o`]@00?oD5001E000om@
D004D004oe1@o`H000?o00002P0000/000?o00003P000om@D005D003oe1@00Q@00?oD5003U000om@
D00MD003oe1@01A@00?oD5009e000om@D00DD003oe1@01e@00?oD5003U000om@D008D003oe1@00E@
00?oD5001E000om@o`060003o`0000X0000;0003o`0000l000?oD5000e000om@D009D003oe1@00m@
00?oD50075000om@D00ED003oe1@02E@00?oD5005E000om@D00LD003oe1@00m@00?oD5002E000om@
D003D003oe1@00M@0_l60003o`0000X0000:0003o`00010000?oD5000e000om@D007D0;o4U000om@
D00KD003oe1@01I@00?oD5009E000om@D00FD003oe1@01]@00?oD5004502o`U@00?oD5000e000om@
D008D0;o1P000ol0000900002P000ol0000A0003oe1@009@00?oD5001E02oaA@00?oD5006U000om@
D00HD003oe1@02=@00?oD50065000om@D00JD003oe1@019@0_l7D003oe1@009@00?oD5001e02o`03
D?l000D000?o00002@0000X000?o00004@000om@D002D003oe1@00A@00?oD5005E000om@D00ID003
oe1@01U@00?oD5008E000om@D00ID003oe1@01U@00?oD5005E000om@D004D003oe1@009@00?oD500
0e04o`9@00?o00001@000ol0000900002P000ol0000B0005oe1@D?l01502oaQ@00?oD50065000om@
D00JD003oe1@025@00?oD5006U000om@D00HD003oe1@01I@0_l4D005oe1@D?l01502o`I@00?o0000
1@000ol0000900002P000ol0000B0004oe1@o`=@0_lJD003oe1@01Q@00?oD5006e000om@D00OD003
oe1@01]@00?oD50065000om@D00HD0;o0e001?m@D?l2D0;o25000ol000050003o`0000T000090003
o`0001@000CoD?m@0_lMD003oe1@01I@00?oD50075000om@D00OD003oe1@01a@00?oD5005U000om@
D00KD0;o00E@oe3oD002o`Y@00?o00001P000ol0000800002@000ol0000D00Co7e000om@D00FD003
oe1@01e@00?oD5007E000om@D00MD003oe1@01I@00?oD5007E02o`03D?oo00a@00?o00001P000ol0
000800002@000ol0000E00?o7e000om@D00ED003oe1@01m@00?oD5006e000om@D00OD003oe1@01E@
00?oD5007U05o`]@00?o00001P000ol0000800002@000ol0000E0003D?m@00;o7U000om@D00DD003
oe1@01m@00?oD5006e000om@D00OD003oe1@01A@00?oD5007505o`=@1?l7D003o`0000H000?o0000
200000T000?o000050000om@o`03D0?o6e000om@D00CD003oe1@025@00?oD5006E000om@D00QD003
oe1@01=@00?oD5006U02o`=@00?oD?l01U09o`L000?o0000200000P000?o000050001?m@D?l6D003
oe1@01Q@00?oD5004e000om@D00QD003oe1@01U@00?oD5008E000om@D00CD003oe1@01Q@0_l5D004
oe1@o`e@00?o00001P000ol00007000020000ol0000C0005oe1@D?l01e000om@D00GD003oe1@019@
00?oD5008e000om@D00GD003oe1@02=@00?oD5004U000om@D00GD003oe1@00E@00GoD51@o`0;D003
oe3o00L000?o00001`0000P000?o00004`001Om@D53o00Q@0olFD003oe1@015@00?oD50095000om@
D00GD003oe1@02A@00?oD5004E000om@D00ED0;o25001Om@D53o00]@00?oD5000_l50003o`0000L0
00080003o`00018000?oD5000e000om@D008D003oe1@01=@00?oD50045000om@D00VD003oe1@01E@
00?oD5009U000om@D00@D003oe1@01=@0_l9D003oe1@00=@00?oD50025001_m@D500o`@000?o0000
1`0000P000?o00004@000om@D004D003oe1@00U@00?oD5004e000om@D00?D003oe1@02M@00?oD500
4e000om@D00WD003oe1@00m@00?oD5004e000om@D009D003oe1@00A@00?oD5001U000om@D003D0;o
0`000ol0000700001`000ol0000A0003oe1@00E@00?oD5002U02oa=@00?oD5003U000om@D00XD003
oe1@01=@00?oD500:5000om@D00>D003oe1@015@0_l<D003oe1@00E@00?oD5001E000om@D002D003
oe0000@000?o00001P0000L000?o000040000om@D006D003oe1@00a@00?oD50045000om@D00=D003
oe1@02Y@00?oD5004E000om@D00ZD003oe1@00e@00?oD50045000om@D00<D003oe1@00I@00?oD500
15000om@D002D003o`0000@000?o00001P0000L000?o00003P02o`U@00?oD5003E02oa1@00?oD500
3E000om@D00ZD003oe1@015@00?oD500:U000om@D00=D003oe1@00i@0_l?D003oe1@00M@0ol4D004
oe3oo`L000?o00001P0000L000?o00003002o`]@00?oD5003e000om@D00=D003oe1@00a@00?oD500
;5000om@D00?D003oe1@02a@00?oD50035000om@D00=D003oe1@00m@00?oD5002U001?m@D502o`T0
00?o00001P0000L000?o00002`000om@D00;D003oe1@011@00?oD5003E000om@D00:D003oe1@02i@
00?oD5003E000om@D00^D003oe1@00Y@00?oD5003E000om@D00@D003oe1@00]@00?oD5000_l90003
o`0000H000070003o`0000T00_l>D003oe1@015@0_l=D003oe1@00U@00?oD500;e000om@D00=D003
oe1@02m@00?oD5002E000om@D00;D0;o4e000om@D00<D0;o00=@o`0020000ol0000600001`000ol0
000700;o45000om@D00CD003oe1@00Y@00?oD5002E000om@D00`D003oe1@00]@00?oD500<5000om@
D009D003oe1@00Y@00?oD5004e000om@D00>D0;o2@000ol0000600001`000ol0000900;o3U000om@
D00DD0;o2U000om@D008D003oe1@035@00?oD5002e000om@D00aD003oe1@00Q@00?oD5002502oaI@
00?oD5003503o`030?l000L000?o00001P0000L000?o00002`02o`]@00?oD5005e000om@D007D003
oe1@00M@00?oD500<e000om@D009D003oe1@03=@00?oD5001e000om@D007D003oe1@01M@00?oD500
2E02o`9@00?oD?l020000ol0000600001`000ol0000=0003oe1@00Q@00?oD50065000om@D006D003
oe1@00I@00?oD500=5000om@D009D003oe1@03A@00?oD5001U000om@D006D003oe1@01Q@00?oD500
25000om@D002D003oe1@00;o1P000ol0000600001P000ol0000?0003oe1@00M@00?oD5006E000om@
D005D003oe1@00E@00?oD500=U000om@D007D003oe1@03I@00?oD5001E000om@D005D003oe1@01U@
00?oD5001e000om@D003D005oe1@D0000_l50003o`0000D000060003o`0001000_l7D003oe1@01Y@
00?oD50015000om@D005D003oe1@03M@00?oD5001E000om@D00gD003oe1@00E@00?oD50015000om@
D00JD003oe1@00E@0_l6D003oe1@00=@00<0o`000`000ol0000500001P000ol0000A0003D?m@00E@
00?oD5006e02o`E@00?oD5000U02ocY@00?oD5001E000om@D00hD0;o15000om@D003D0;o7E000om@
D004D003oe1@00I@00?oD5000e000ol000030003o`0000D000060003o`00018000?oD5000e000om@
D00ND003oe1@009@00GoD51@o`0mD003oe1@00=@00?oD500>e001Om@D53o00A@00?oD5007U000om@
D003D003oe1@00I@00?oD5000U000ol000040003o`0000D000060003o`0001<000?oD5000U000om@
D00OD005oe1@D?l00e000om@D00kD003oe1@00=@00?oD500>e001Om@D53o00=@00?oD5007e000om@
D002D003oe1@00Q@00CoD53o1`000ol0000500001P000ol0000D0004oe1@ob=@00GoD53oD002ocm@
00GoD51@o`0oD0;o00E@oe1@o`0SD004oe1@o`]@00CoD53o1`000ol0000500001P000ol0000D0004
D?m@obA@00CoD?oo@U000om@o`12D0;o00=@oe008e000om@o`0<D004oe1@o`L000?o00001@0000H0
00?o00005@000om@o`0UD0?o@U000om@o`12D0?o9E000om@o`0=D003oe3o00L000?o00001@0000H0
00?o00001P3lo`L000?o00001@0000H000?o00001P000om@D00=D003oe1@02A@0_m4D015oi20T82@
P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@
P92000;o9U000om@D00=D003o`3o00H000?o00001@0000H000?o00001`000om@D00;D003oe3o02A@
00?oD?l00_m1D003oe3o046@0ol00e3oD00SD003oe3o00e@00CoD?m@0ol30003o`0000D000060003
o`0000P000?oD5002E001?m@D?lSD004oe1@o`9@00?oD500?U00A?m@oh2@P920T82@P920T82@P920
T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P93o0U001?m@D?lSD004
oe1@o`]@00CoD53o0U020004o`00o`L000060003o`0000P000?oD50025001Om@D53o025@0_l3D004
oe1@ocm@00GoD51@o`0oT004oe1@o`=@0_lQD005oe1@D?l02U001?m@D?l4D004o`00o`L000060003
o`0000P000?oD50025000om@D002D003oe1@01e@00?oD5000e001?m@D502oca@00?oD5000e00?On0
T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P900
0_l3D003oe1@00=@00?oD5007E000om@D002D003oe1@00Q@00GoD51@o`02D005o`000?l01`0000H0
00?o00002@000om@D005D0;o1U000om@D00KD003oe1@00A@00?oD5000e000om@D00iD003oe1@00=@
00?oT900>I000on@D003D003oe1@00A@00?oD5006e000om@D004D0;o1e000om@D003D003o`3o00<0
00?o00001@0000H000?o00002@000om@D004D003oe1@00I@00?oD5006U000om@D005D003oe1@00=@
00?oD500>5000om@D005D00loi20T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@
P920T82@P920T82@P920T83o1E000om@D005D003oe1@01Y@00?oD5001U000om@D004D003oe1@00=@
0_l40003o`0000D000060003o`0000T000?oD5000e000om@D007D003oe1@01U@00?oD5001E000om@
D005D003oe1@03M@00?oD5001E000on@T00gT003oe1@00E@00?oD5001E000om@D00ID003oe1@00M@
00?oD5000e001?m@D502o`03D?l000<000?o00001@0000H000?o00002@001?m@D502o`Y@00?oD500
65000om@D006D003oe1@00I@00?oD500=E000om@D007D00ioh2@P920T82@P920T82@P920T82@P920
T82@P920T82@P920T82@P920T82@P920T82@P920T83o00Q@00?oD5001U000om@D00HD003oe1@00Q@
0_l3D004oe1@o`=@00?o00000P000ol0000500001`000ol000080004oe3oo`a@00?oD5005U02o`U@
00?oD5001e000om@D00cD003oe1@00U@00?oT900<i000om@D007D003oe1@00M@0_lHD003oe1@00Y@
0_l01E3oD53o00=@00Go0000o`0800001`000ol0000800;o3e000om@D00CD0;o2e000om@D008D003
oe1@039@00?oD5002E00=_n@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@
P920T82@P920o`Y@00?oD5002E02oaE@00?oD5003E02o`04D?m@D0Co0P000ol0000600001`000ol0
000700?o3e000om@D00BD003oe1@00]@00?oD50025000om@D00aD003oe1@00]@00?oT900<I000om@
D008D003oe1@00]@00?oD5004U000om@D00?D0Co1P000ol0000600001`000ol000070004oe1@o`i@
00?oD5004E000om@D00<D003oe1@00U@00?oD500<5000om@D00;D00doh2@P920T82@P920T82@P920
T82@P920T82@P920T82@P920T82@P920T82@P920T82@o`]@00?oD50035000om@D00AD003oe1@00a@
0_l0153oool70003o`0000H000070003o`0000P000CoD53o3E000om@D00@D003oe1@00e@00?oD500
2U000om@D00^D003oe1@00e@00?oT900;Y000om@D00:D003oe1@00e@00?oD50045000om@D00;D003
oe1@00;o00=@0?l00_l40003o`0000H000070003o`0000P000CoD51@0ol:D003oe1@00i@0_l?D003
oe1@00a@00?oD500;E000om@D00=D00aoi20T82@P920T82@P920T82@P920T82@P920T82@P920T82@
P920T82@P920T82@o`0>D003oe1@00e@0_l@D003oe1@00U@0_l3D0?o0e000`3o00020003o`0000H0
00070003o`0000P000?oD50015000om@D007D003oe1@00a@0_lAD003oe1@00a@00?oD500;5000om@
D00?D003oi2@02b@00?oD50035000om@D00?D0;o3U000om@D007D0;o1E001?m@D?l3D005o`000?l0
200000L000?o00002@000om@D004D003oe1@00I@00?oD5002e000om@D00AD003oe1@00e@00?oD500
:U000om@D00AD00^oi20T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920o`m@
00?oD5004E000om@D00;D003oe1@00I@00?oD50015001Om@D53o009@00?o00000P000ol000060000
1`000ol000090003oe1@00E@00?oD5001E000om@D00:D003oe1@019@00?oD5003U000om@D00YD003
oe1@015@00?oT900:I000om@D00>D003oe1@019@00?oD5002U000om@D005D003oe1@00E@00?oD500
0U03o`@000?o00001P0000L000?o00002@000om@D006D003oe1@00A@00?oD5002E000om@D00CD003
oe1@00i@00?oD500:5000om@D00CD00/oh2@P920T82@P920T82@P920T82@P920T82@P920T82@P920
T82@P920T?l@D003oe1@01=@00?oD5002E000om@D004D003oe1@00I@00?oD50015000ol000020003
o`0000H000080003o`0000L000?oD50025000om@D003D003oe1@00M@0_lED003oe1@011@00?oD500
9e000om@D00CD003oi2@02N@00?oD50045000om@D00CD0?o25000om@D003D003oe1@00Q@00CoD51@
0ol30003o`0000L000080003o`0000L000?oD50025000om@D002D003oe1@00I@0_lGD003oe1@015@
00?oD5009E000om@D00ED00Yoi20T82@P920T82@P920T82@P920T82@P920T82@P920T82@P920T?l0
4e000om@D00FD003oe1@00I@00?oD5000U000om@D008D004oe1@o`9@00Go0000o`09000020000ol0
00070003oe1@00U@00GoD51@o`07D003oe1@01M@00?oD5004U000om@D00SD003oe1@01M@00?oT900
8i000on@D00BD003oe1@01M@00?oD5001E001Om@D53o00]@00CoD53o0U001Ol0003o00T000080003
o`0000H000?oD5002e001?m@D?l5D0;o6U000om@D00BD003oe1@02=@00?oD5005e009on0T82@P920
T82@P920T82@P920T82@P920T82@P920T82@P920o`0DD003oe1@01Q@0ol4D004oe1@o`e@0_l3D005
o`000?l02@0000P000?o00001P0:o`E@00?oD?l00U03oaa@00?oD5004e000om@D00QD003oe1@01U@
00?oT9008I000on@D00CD003oe1@01]@0_l2D003oe3o00E@4?l20003o`0000L000090003o`0000l0
1?l00e3oD003oam@00?oD5004e000om@D00QD003oe1@01U@02GoT82@P920T82@P920T82@P920T82@
P920T82@P920T82@P93o01E@00?oD5007E03o`03D?m@00Co2E02o`H000?o0000200000T000?o0000
4P000e3oo`02ob1@00?oD5005E000om@D00OD003oe1@01]@00?oT9007i000om@D00ED003oe1@01i@
1?l<D004oe00o`D000?o0000200000T000?o00004P02o`030?m@00;o7U000om@D00ED003oe1@01m@
00?oD5006e008on0T82@P920T82@P920T82@P920T82@P920T82@P920T83o01M@00?oD5007502o`03
D?m@00;o2e001Om@D03o00@000?o0000200000T000?o00004002o`05053oD?l00U02oaa@00?oD500
5U000om@D00MD003oe1@01e@00?oT9007I000om@D00FD003oe1@01Y@0_l2D003oe3o009@0_l9D004
oe1@D0;o0`000ol0000800002@000ol0000>00;o00L0D51@oe3o00A@0_lID003oe1@01M@00?oD500
75000om@D00OD00Poh2@P920T82@P920T82@P920T82@P920T82@P920T?lID003oe1@01M@0_l4D003
oe3o00A@0_l7D005oe1@oe0010000ol0000800002P000ol0000;00;o00<0D5000U001?m@D?l6D003
oe1@01I@00?oD50065000om@D00KD003oe1@01m@00?oT9006i000om@D00HD003oe1@01I@00?oD500
15001?m@D?l5D0;o1E000om@o`050003o`0000T0000:0003o`0000L01?l7D005oe1@D?l01U02oaI@
00?oD50065000om@D00JD003oe1@025@01koT82@P920T82@P920T82@P920T82@P920T82@P?lJD003
oe1@01A@0_l6D005oe1@D?l01e04o`04D?m@o`D000?o00002@0000X000?o00001@02o`8025000om@
D002D003oe1@00I@0_lCD003oe1@01Y@00?oD5006E000om@D00QD003oi2@01V@00?oD5006U000om@
D00AD0;o25000om@D002D003oe1@00Q@00?oD?l01P000ol0000900002P000ol0000400;o2e000om@
D002D003oe1@00Q@00?oD50045000om@D00KD003oe1@01M@00?oD5008e006on0T82@P920T82@P920
T82@P920T82@P920o`0MD003oe1@011@00?oD50025000om@D002D003oe1@00U@0_l60003o`0000T0
000:0003o`0000H000?oD5001e000om@D003D003oe1@00Q@00?oD50045000om@D00KD003oe1@01I@
00?oD5009E000on@T00FT003oe1@01]@00?oD50045000om@D008D003oe1@00=@00?oD5001e03o`H0
00?o00002@0000/000?o00001P000om@D006D003oe1@00=@00?oD5002E02o`m@00?oD5007E000om@
D00ED003oe1@02E@01WoT82@P920T82@P920T82@P920T82@P93o01m@00?oD5003E02o`]@00?oD500
0e000om@D006D004oe3oD0;o0`000ol0000:00002`000ol000070003oe1@00A@00?oD5001E000om@
D00:D003oe1@00a@00?oD5007E000om@D00DD003oe1@02M@00?oT90059000om@D00MD003oe1@00a@
00?oD5002U000om@D005D003oe1@00A@00CoD53o0U001@3o003o00`0000;0003o`0000L000?oD500
0e000om@D006D003oe1@00]@00?oD5002e000om@D00ND003oe1@01=@00?oD5009e005on0T82@P920
T82@P920T82@P920T83o021@00?oD5002e000om@D00;D003oe1@00I@00?oD5000e001?m@D?l3D004
o`00o``0000<0003o`0000L000GoD51@o`09D003oe1@00]@00?oD5002U000om@D00OD003oe1@019@
00?oD500:E000on@T00BT003oe1@01m@00?oD5002U000om@D00;D003oe1@00M@00GoD51@o`04D003
oe3o008000?o00002`0000`000?o00001`001?m@D?l:D003oe1@00a@00?oD50025000om@D00QD003
oe1@015@00?oD500:E005On@P920T82@P920T82@P920T82@o`0SD003oe1@00Q@00?oD50035000om@
D008D004oe1@o`9@1?l30003o`0000/0000<0003o`0000P00_l;D003oe1@00e@00?oD5001e000om@
D00QD003oe1@011@00?oD500:e000on@T00@T003oe1@025@00?oD5001e000om@D00=D003oe1@00U@
1Ol3D005o`000?l03@0000d000?o00001`03o`Y@00?oD5003U02o`I@00?oD5008e000om@D00>D003
oe1@02e@01;oT82@P920T82@P920T82@P?lUD003oe1@00A@0_l@D003oe1@00Q@1Ol3D005o`000?l0
3P0000d000?o00001`001?m@D?l8D003oe1@015@00?oD5000e000om@D00SD003oe1@00i@00?oD500
;E000on@T00>T003oe1@02=@00?oD5000e000om@D00AD003oe1@00I@00CoD53o0U02o`03D?l00080
00?o0000300000d000?o00001`001Om@D53o00M@00?oD5004E000om@D003D003oe1@02A@00?oD500
35000om@D00_D00@oh2@P920T82@P920T82@obI@00?oD5000e000om@D00AD003oe1@00E@00GoD51@
o`04D0;o0`000ol0000<00003P000ol000060003oe1@009@00?oD50015000om@D00BD005oe1@D?l0
9e000om@D00<D003oe1@02m@00?oT90039000om@D00UD005oe1@D?l055000om@D004D003oe1@009@
00?oD5000e001?l00?l?00003P000ol000060003oe1@00=@00?oD5000e000om@D00BD005oe1@D?l0
:5000om@D00:D003oe1@035@00koT82@P920T82@P920obQ@00GoD51@o`0DD003oe1@00=@00?oD500
0e001om@D53oD?l00P000ol0000=00003P000ol000060003oe1@00=@00?oD5000e000om@D00CD003
oe3o02U@00?oD5002E000om@D00cD003oi2@00V@00?oD5009e000om@o`0ED003oe1@00=@00?oD500
0e001_m@D?m@o`<000?o00003@0000l000?o000010000om@D005D005oe1@D?l04U0;obE@00?oD500
2E000om@D00cD00=oh2@P920T82@P920o`0UD0_o4U001Om@D53o00M@00CoD?m@0_l00`3o000?0000
3`000ol0000400Go15001?m@D?l8D0[o1E000om@D003D0Wo75000om@D008D003oe1@03E@00?oT900
29000om@D00JD0Wo1E000om@D003D0[o25001?m@D?l5D0Oo0`000ol0000>00003`000ol0000300;o
00@0D51@0ol2D003oe3o00=@1Ol>D003oe3o00e@1olFD003oe1@00M@00?oD500=E002on@P920T82@
P93o01M@1_l=D003oe3o00i@1Ol3D003oe3o00=@0ol4D003o`0000<000?o00003P00010000?o0000
2`08oa9@00CoD53o5503oa=@00?oD5001U000om@D00gD003oi2@00J@00?oD5004U03oa=@00CoD53o
4U09o`I@0_l40003o`0000l0000@0003o`0000d00_lFD005oe1@D?l05U05o`i@00?oD5001U000om@
D00gD00:oh2@P920T82@o`i@1_lED005oe1@D?l05U03o`M@00?oD?l010000ol0000?00004@000ol0
000=00;o55000om@D002D003oe1@01U@0ol<D003oe1@00A@00?oD500>E000on@T004T003oe1@00]@
0_lKD003oe1@009@00?oD5004U03o`03D?oo00?o0U001?m@D?l20003o`000100000A0003o`0000d0
00?oD?l04e000om@D003D003oe1@01]@0_l:D003oe1@00=@00?oD500>e001on0T82@P?l02U03oaa@
00?oD5000e000om@D00AD005oe3oD?l01E07o`030?l00140000A0003o`0000d000CoD53o4U000om@
D003D003oe1@01e@00?oD50025000om@D002D003oe1@03]@00?oT9000Y000om@D008D003oe1@01e@
00?oD5000e000om@D00@D004oe1@o`9@00?oD50015000ol000030003o`000100000B0003o`0000`0
00GoD51@o`0@D003oe1@00E@00?oD5007E03o`M@00GoD51@o`0JD0co6E001On@P93o00Q@0_lOD003
oe1@00E@00?oD5003U001Om@D53o009@00<0oe000e000ol000030003o`000140000B0003o`0000`0
00?oD5000U000om@D00<D003oe1@00I@00?oD5008503o`A@00GoD51@o`0?D0_o350:o`m@00GoT92@
o`05D0?o8E000om@D006D003oe1@00a@00?oD5000U000om@D002D004oe1@o`H000?o00004@0001<0
00?o00002`000om@D002D003oe1@00]@00?oD5001e000om@D00SD0?o00E@oe1@o`09D0Oo8E07o`U@
00CoP93o0U03obA@00?oD5001e000om@D00;D003oe1@009@00?oD5000e000om@o`050003o`000180
000C0003o`0000/000?oD5000e000om@D009D003oe1@00Q@00?oD5009U001?m@ool4D0Ko;e06o`A@
0_l00e3oo`0WD003oe1@00Q@00?oD5002E000om@D003D003oe1@00A@0_l50003o`000180000C0003
o`0000X000?oD5001E000om@D008D003oe1@00U@00?oD5009U07oc]@1olXD003oe1@00U@00?oD500
25000om@D005D003oe1@00=@0_l50003o`000180000D0003o`0000T000?oD5001U000om@D006D003
oe1@00Y@00?oD5009U03od=@0olXD003oe1@00Y@00?oD5001U000om@D006D004oe1@D0;o00=@o`00
0`000ol0000C00005@000ol000080003oe1@00I@00?oD5001E000om@D00;D003oe1@02A@0_l0153o
D?m1D004oe3oD0?o9E000om@D00;D003oe1@00E@00?oD5001U001?m@D?l2D003o`00008000?o0000
500001D000?o00001`000om@D007D003oe1@00A@00?oD50035000om@D00ND0Ko0U001?m@oe03oca@
0_l0153oD?l3D0Ko7e000om@D00<D003oe1@00A@00?oD5001e02o`=@00?o00000P000ol0000D0000
5P000ol0000600Ko15000om@D003D003oe1@00i@00?oD5006U03o`Q@00?oD?l015000om@D00gD0;o
0e000om@o`06D003051@00;o75000om@D00>D003oe1@00=@00?oD5000e0:o`<000?o00005@0001H0
00?o00002@03D0;o0U000om@D002D003oe1@00m@00?oD5006502o`Y@00CoD53o1E000om@D00eD003
oe1@00=@00CoD53o2500101@oolJD003oe1@00m@00?oD5000U000om@D003o`A@0_l20003D03o0080
00?o00005@0001H000?o00003@001E3oD53o009@00?oD50045000om@D00GD003oe1@00U@00?oD500
0U000om@D003D0;o<e02o`E@00?oD5000U000om@D008D0030?m@01Q@00?oD50045001?m@D?l2D003
oe1@00E@00?o0?l01P000ol0000E00005`000ol0000>0005oe3oD?l04e000om@D00ED0;o35000om@
D002D003oe1@00E@00?oD500;e000om@D005D003oe1@009@00?oD5002U03oaI@00?oD5004E001Om@
oe3o00M@00GoD500o`040003o`0001H0000H0003o`0000h00olDD003oe1@019@0ol=D003oe1@00=@
00?oD5001U000om@D00]D003oe1@00I@00?oD5000e000om@D00<D0;o55000om@D00BD0?o25001?m@
D502o`8000?o00005`0001P000?o00003`06oa1@00?oD5004502oa1@00?oD5000e000om@D007D003
oe1@02]@00?oD5001e000om@D003D003oe1@00i@0olAD003oe1@00i@3Ol2D004oe3oo`@000?o0000
5`0001T000?o00003P000om@D003D0?o3E000om@D00=D0?o4E000om@D004D003oe1@00Q@00?oD500
:E000om@D008D003oe1@00A@00?oD5003e00103oool>D003oe1@00a@0_l5D0;o1U03o`03D?l000<0
00?o0000600001X000?o00003@02o`M@0ol:D003oe1@00]@0_lDD003oe1@00E@00?oD50025000om@
D00WD003oe1@00Q@00?oD5001E000om@D00AD003053o00e@00?oD5002E03o`I@0_l00e3oo`07D003
o`00008000?o00006@0001X000?o00003@000om@o`09D0;o25000om@D00:D003oe1@01=@00?oD500
1U000om@D009D0;o9E02o`]@00?oD5001U000om@D00CD003oe1@00Y@00?oD5001U03o`Q@00?oD?l0
0e000om@D002D003o`0000@000?o00006@0001/000?o000030001?m@D?l9D0030?m@00I@00?oD500
2502oaE@00?oD5001e000om@D00;D003oe1@025@00?oD5002e000om@D007D003oe1@01=@0ol9D003
oe1@00E@00?oD50025001?m@D?l3D005oe1@D?l01P000ol0000J000070000ol0000:0005oe1@D?l0
2e000om@D004D003oe1@00I@0_lGD003oe1@00M@00?oD50035000om@D00OD003oe1@00a@00?oD500
1e000om@D00ED0030?m@00M@00?oD50015000om@D009D005oe1@D?l00e02o`03D?l000@000?o0000
6`0001`000?o00002P000om@D002D003oe1@00U@00?oD5000e000om@D005D003oe1@01I@00?oD500
25000om@D00=D003oe1@01e@00?oD5003E000om@D008D003oe1@01I@00?oD5001E000om@D003D003
oe1@00U@00?oD5000U000om@D003D003o`0000@000?o00006`0001d000?o00002@000om@D002D003
oe1@00Y@0_l3D003oe1@00=@0_lID003oe1@00Q@00?oD5003U000om@D00KD003oe1@00i@00?oD500
25000om@D00GD0?o15001?m@D502o`a@00?oD5000U000om@D002D0;o1@000ol0000L00007@000ol0
00080003oe1@00=@00?oD50035001?m@D?l3D0;o6U000om@D00:D003oe1@00i@00?oD5006E000om@
D00>D003oe1@00Y@00?oD5006E001Om@D53o009@00?oD50035000om@D003D006oe1@oe3o1@000ol0
000L00007P000ol000070003oe1@00=@00?oD5003500103oD?l2D003oe1@01Y@00?oD5002U000om@
D00?D003oe1@01M@00?oD5003e000om@D00:D003oe1@01Y@00KoD53oD?l?D003oe1@00=@00KoD53o
D?l40003o`0001d0000O0003o`0000D000?oD50015000om@D00=D0030?oo00;o75000om@D00;D003
oe1@00m@00?oD5005e000om@D00?D003oe1@00]@00?oD5006U04oa1@00?oD5001506o`8000?o0000
7P0001l000?o00001007o`9@00?oD5000U0=oae@00?oD50035000om@D00@D003oe1@01E@00?oD500
45000om@D00<D003oe1@01]@3Ol4D003oe1@00Oo1P000ol0000N000080000ol000090003D?m@00Go
2e06oaU@00?oD50035000om@D00AD003oe1@01=@00?oD5004E000om@D00<D003oe1@01M@1_l;D0Go
00=@oe001502o`D000?o00007`00024000?o00002P000om@D00<D0?o00=@oe000U03oaE@00?oD500
3E000om@D00BD003oe1@015@00?oD5004U000om@D00=D003oe1@01=@0ol3D003oe3o00;o3U000om@
D003D003oe3o00@000?o00008000028000?o00002P000om@D00:D006o`00oe3o1U000om@D00BD003
oe1@00e@00?oD5004e000om@D00?D003oe1@01=@00?oD5003E000om@D00BD003oe1@00A@00?oD?l0
0U000om@D00:D0Co0e000om@o`030003o`000240000S0003o`0000X000?oD5001e02o`<000?oD?l0
1e02oa5@00?oD5003U000om@D00DD003oe1@00e@00?oD50055000om@D00>D003oe1@00m@0_l7D003
oe3o00=@0_l9D003oe3o009@1_l20003o`000280000S0003o`0000X000?oD5001U000om@00030004
oe1@o`Q@00?oD5003U000om@D00>D003oe1@01E@00?oD5002e000om@D00ED003oe1@00i@00?oD500
3U000om@D006D004oe1@o`E@00?oD5001U000om@o`05D003o`00008000?o00008P0002@000?o0000
2P000om@D004D003o`0000<000GoD51@o`09D0;o3E000om@D00@D003oe1@01A@00?oD5002e000om@
D00DD003oe1@011@00?oD5002e02o`U@00GoD51@o`05D003oe1@00A@00KoD51@oe02o`D000?o0000
8`0002D000?o00002@000om@D003D003o`0000@000?oD5000U000om@D008D003oe1@00U@00?oD500
4E000om@D00ED003oe1@00U@00?oD5005E000om@D00AD003oe1@00U@00?oD50025000om@D002D003
oe1@00A@00?oD5000e001om@D53oD?l01@000ol0000T00009P000ol000090003oe1@00;o1`000om@
D002D003oe1@00U@00?oD50025000om@D00AD003oe1@01I@00?oD5001e000om@D00FD003oe1@015@
00?oD50025000om@D009D003oe1@009@00?oD5001E02o`9@00?oD5000U02o`D000?o00009@0002L0
00?o000020000om@o`090003oe1@009@00?oD5002U000om@D006D003oe1@019@00?oD5005e000om@
D005D003oe1@01M@00?oD5004U000om@D006D003oe1@00Y@00?oD5000U000om@D006D0050?m@oe00
1Ol40003o`0002H0000X0003o`0000L00_l90003oe1@00A@00?oD5002U000om@D005D003oe1@019@
00?oD50065000om@D003D003oe1@01Q@00?oD5004U000om@D005D003oe1@00Y@00?oD50015000om@
D007D0?o0e000ol000020003o`0002L0000Y0003o`0000H000?o000020000om@D004D003oe1@00]@
00?oD5000e000om@D00CD003oe1@01Q@00?oD5000e000om@D00HD003oe1@01=@00?oD50015000om@
D00:D003oe1@00A@00?oD500150:o`<000?o0000:00002X000?o00003`000om@D005D003oe1@00a@
00?oD5000U000om@D00CD003oe1@01U@00GoD51@o`0KD003oe1@01=@00?oD5000e000om@D00;D003
oe1@00E@00?oD5000U001_m@D500o`<000E@o`00o`0[0000:`000ol0000>0003oe1@00E@00?oD500
3E001?m@D?lFD003oe1@01U@00GoD51@o`0KD003oe1@01A@00GoD51@o`0>D003oe1@00E@00GoD51@
o`04D003o`0000D000?o0000:P0002`000?o000030000om@D006D003oe1@00e@00?oD?l05e000om@
D00ID005oe1@D?l06e000om@D00ED004oe1@o`i@00?oD5001U000om@o`04D003o`0000D000?o0000
:`0002d000?o00002`000om@D006D003oe1@00i@0_lGD003oe1@01Y@00?oD?l075000om@D00ED003
oe3o00m@00?oD5001U000om@o`04D003o`0000@000?o0000;00002h000?o00002@06o`A@00?oD500
1U0Aoa1@00?oD5004U0CoaA@00?oD5003U0Ao`Q@00?oD5000e0;o`D000?o0000;@0002l000?o0000
3@000e3oD002D003oe1@00A@0_l8D003oe1@00I@0ol=D003oe1@00i@1?l8D003oe3o00Q@1?l@D003
oe1@00]@0ol8D003oe1@00I@0_l6D004oe1@D0;o0e02o`@000=@o`000`000ol0000^0000<0000ol0
000>0004oe1@o`A@0_l9D003oe3o00Y@0_l;D003oe1@00Y@1?l;D005oe1@D?l02e04o`a@00?oD500
2E02o`Y@00?oD?l02E02o`A@00CoD53o1E000om@o`080003o`0002l0000a0003o`0000h000?oD?l0
0U02o`]@00?oD?l03503o`Q@00?oD5002502o`m@00GoD51@o`0?D0;o2U000om@D007D0;o35000om@
o`0;D0;o0U000om@o`06D004oe1@o`H000?o0000<000038000?o00003P04o`a@00GoD51@o`0>D0;o
1U000om@D006D0;o45000om@D003D003oe1@00i@0_l8D003oe1@00A@0ol=D005oe1@D?l03504o`M@
00?oD5000_l40003o`000340000c00;o3`03o`]@00?oD5000U000om@D00>D003oe1@00=@00?oD500
1502oa9@00?oD5000e000om@D00@D0;o1U000om@D003D003oe1@00i@00?oD5000U000om@D009D0ko
1@000ol0000b0000=@000ol0000>0003D?oo00U@00?oD5000e000om@D00>D003oe1@009@00?oD500
0U02oaA@00?oD5000e000om@D00BD0;o15000om@D002D003oe1@00i@00?oD5000e000om@D007D0;o
0U000om@o`06D003o`0000@000?o0000<`0003H000?o000040000om@D005D003oe1@00A@00?oD500
3e001Om@D53o00=@00?oD5004e000om@D005D003oe1@01=@00GoD51@o`03D003oe1@00m@00?oD500
15000om@D005D009oe1@D?m@o`3o00A@00?o000010000ol0000d0000=`000ol0000@0003oe1@00A@
00?oD5001E000om@D00?D005oe1@oe000_lFD003oe1@00E@00?oD5005502o`05D?m@D?l04E000om@
D005D003oe1@00A@00?oD5000U000om@o`020004oe1@o`D00_lg0000>0000ol0000?0003oe1@00=@
00?oD5001U000om@D00?D003oe1@00;o65000om@D005D003oe1@01I@0_l2D003oe1@00m@00?oD500
1U000om@D003D005oe1@D?l00U001ol0003o0?l010000ol0000g0000>@000ol0000?0003oe1@009@
00?oD5001U000om@D00@D0?o65000om@D007D003oe1@01I@0olBD003oe1@00I@00?oD5000U000om@
D002D004oe1@o`@000?o00000P000ol0000h0000>P000ol0000?0004oe1@o`U@00?oD500250>oaA@
00?oD5002E000om@D00BD0ko2U000om@D007D004oe1@o`E@00GoD51@o`070003o`0003T0000k00;o
4002o`Y@00?oD5001U02o`Q@0ol3D0Go3e000om@D009D003oe1@00i@1?l3D0?o2503o`M@00?oD500
2502o`I@1_l400;o?00003d000?o00003@07o`E@00?oD5000e03o`U@00GoD?m@o`07D003oe1@00a@
00?oD5002E000om@D00<D0;o1U001Om@oe3o00Y@0_l5D003oe1@00=@3_l80003o`0003`0000n00;o
3@02o`E@0ol2D003oe1@009@00?o05002E001?m@D?l2D003oe1@00E@00?oD5002U000om@D00;D003
oe1@00Y@00?o05001E001?m@D?l2D003oe1@00U@00?oD5000U000om@D003o`E@1?l4D003o`0000@0
0_lo0000@0000ol0000<0003oe1@00E@0_l01E3oD53o00a@00CoD53o0U000om@D006D0;o2U000om@
D00;D003oe1@00Q@0_l8D004oe1@o`9@00?oD5002U001Om@D?m@00;o1e001_l0001@o`9@00?o0000
10000ol0000o0000@@02o`d000?oD5001U04o`a@00GoD51@o`03D003oe1@00M@00?oD5001e000om@
D00;D003oe1@00M@00?oD5001e001Om@D53o00=@00?oD5002U04o`Q@00?o000010000om@o`0400;o
@P0004<00_l;0003oe1@00=@1_l;D0;o15001Om@D53o00Y@00?oD5001E000om@D00=D003oe1@00E@
00?oD50025001Om@D53o00A@0_l;D0Ko1E000ol000050004o`0000;oA00004D000?o00002@000om@
D002o`06D0000?m@0ol7D003oe1@00A@00?oD5000U000om@D008D003oe1@00A@00?oD5003E000om@
D004D003oe1@00Q@00?oD5000U000om@D004D003oe1@00I@0_l00e3o00020003D?oo009@00?o0000
2@000ol000140000AP02o`T00ol70005oe1@D?l01U000om@D003D003oe1@00=@00?oD5002E000om@
D003D003oe1@00e@00?oD5000e000om@D009D003oe1@00=@00?oD5000e000om@D004D0;o0U000ol0
00040004D?ooo`T00_m70000B0000ol000060003o`0000L000?oD5000U000om@D002D003oe1@00A@
00?oD50015000om@D009D003oe1@009@00?oD5003E000om@D002D003oe1@00U@00?oD50015000om@
D004D003oe1@009@00?oD5000U000ol000070003o`0000H000?o0000A`0004T00_lA0003oe1@009@
00GoD51@o`06D003oe1@00A@00?oD5002U001?m@D?l4D0Wo15001?m@D?l<D003oe1@00A@00?oD500
15001Om@D53o00A@00?o00003`02odX0001;0003o`0000h000?oD5000e000om@o`07D003oe1@00E@
00?oD5002E001?m@D?l2D0;o2E03o`05D?m@D?l02e000om@D005D003oe1@00E@00?oD?l01E000ol0
000>0003o`0004X0001<00?o3@000om@D002D0Co1e000om@D005D003oe1@00E@1_l0153oool>D0;o
00=@ool01?l7D003oe1@00E@00?oD5001E04o`A@00?o00003002odd0001?00;o2`000om@D002o`04
D00000Co0e000om@D005D003oe1@009@0ol5D0Co4503o`E@0ol4D003oe1@00E@00CoD51@1?l30003
D?oo009@00?o00002@03odl0001A0003o`0000P000?oD?l02@001?m@D?l8D003oe1@00;o1e001Om@
oom@00?o2U05o`03D?m@00I@0_l2D003oe1@00I@00CoD53o2@000om@o`0:0003o`000500001B00?o
20000ol000090004oe3oD0Oo00=@ool02E001Om@oe3o00=@00?oD5001E02o`9@00Go0?m@o`09D0;o
00=@ool01Ol0153oD?l;0003o`0000L00_mC0000E@000ol0000B00?o1e02o`U@00KoD53o0?l3D003
oe1@00E@00OoD51@o`3o009@00?oD5001e02o`M@0olD00;oE@0005H01?lA00?o1E000ol0o`02o`I@
00CoD53o0P000e3oD002D003oe1@00=@00GoD51@o`030004oe1@o`I@0ol00e3oD004D0?o4@04oeL0
001J0003o`00014000GoD51@o`020004oe1@o`A@00GoD51@o`030003oe1@009@00GoD51@o`04D005
o`000?l00e000om@D002D007oe1@o`1@o`03D003o`00014000?o0000F@0005/00ol@0005oe1@D?l0
0P001?m@D?l3D003oe1@009@00Go0000o`05D003oe3o00E@00Go0000o`04D005oe1@D?l00U001?l0
0?l3D003o`0000h00omL0000GP03o`h000?oD?l00`001Om@D53o009@00?oD5000U001Ol0003o00A@
1Ol4D005o`000?l015001?m@D?l3D007o`000?m@o`0>00?oG`0006401?l;0003o`00008000?oD?l0
0_l00e3oo`03o`03D?l0008000?oD5000_l500;o0U001Ol0003o009@1?l00e3oo`03o`@000?o0000
2@04of80001U00?o3@02o`<00_l30003D?l000@00_l900;o1@02o`@000Ko0000D?l=00?oIP0006P0
0olK0003o`0000T000?o00006@03ofT0001[00Go>@05of`0001`00Go;`05og40001e00Go9@05ogH0
001j00[o4@0:og/00024017oQ@000?l06`000?l06`000?l06`000?l06`000?l06`000?l06`000001
\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-1.05001, -1.05001, 0.00747339, 
  0.00747339}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A 4-gon tessellation"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
poly4 = NGP[RegularPolygon[4, Pi/3]];
grp4 = PolygonInvGroup[poly4,3]; Length[grp4]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(49\)], "Output"],

Cell["\<\
diag = Map[Diagonals, grp4];
bisect = Map[Bisectors, grp4];\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{Thickness[0.003], grp4, bisect, diag},
\tHyperbolic -> True, DrawUnitCircle -> False]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.503367 0.5 0.503367 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
newpath
.0068 .3767 .07119 -33.6264 44.1773 arc
s
newpath
-0.00441 .44395 .06472 295.848 344.177 arc
s
newpath
.01329 .37021 .01873 -31.064 55.8482 arc
s
newpath
.02856 .31868 .04187 26.3736 88.936 arc
s
newpath
.0068 .6233 .07119 -44.1773 33.6264 arc
s
newpath
.02856 .68132 .04187 271.064 333.626 arc
s
newpath
.01329 .62979 .01873 -55.8482 31.064 arc
s
newpath
-0.00441 .55605 .06472 15.8227 64.1518 arc
s
newpath
.05965 .23579 .1017 19.7922 86.3736 arc
s
newpath
.02856 .31868 .04187 -43.1018 26.3736 arc
s
newpath
.05357 .26616 .02455 -8.46932 76.8982 arc
s
newpath
.1301 .1301 .14237 79.7922 111.531 arc
s
newpath
.05965 .76421 .1017 273.626 340.208 arc
s
newpath
.1301 .8699 .14237 248.469 280.208 arc
s
newpath
.05357 .73384 .02455 -76.8982 8.46932 arc
s
newpath
.02856 .68132 .04187 -26.3736 43.1018 arc
s
newpath
-0.1165 -0.1165 .71187 60 75.8227 arc
s
newpath
-0.00441 .55605 .06472 -60 15.8227 arc
s
newpath
-0.00441 .44395 .06472 -15.8227 60 arc
s
newpath
-0.1165 1.1165 .71187 284.177 300 arc
s
newpath
.05965 .23579 .1017 -32.9337 19.7922 arc
s
newpath
-0.1165 .5 .35593 307.972 319.792 arc
s
newpath
.09487 .20056 .02034 -16.7636 67.9721 arc
s
newpath
.12062 .16804 .02738 27.0663 103.236 arc
s
newpath
.05965 .76421 .1017 -19.7922 32.9337 arc
s
newpath
.12062 .83196 .02738 256.764 332.934 arc
s
newpath
.09487 .79944 .02034 -67.9721 16.7636 arc
s
newpath
-0.1165 .5 .35593 40.2078 52.0279 arc
s
newpath
.14308 .14308 .03747 2.93365 87.0663 arc
s
newpath
.12062 .16804 .02738 -30.8012 27.0663 arc
s
newpath
.144 .144 .01003 .80125 89.1988 arc
s
newpath
.16804 .12062 .02738 62.9337 120.801 arc
s
newpath
.14308 .85692 .03747 272.934 357.066 arc
s
newpath
.16804 .87938 .02738 239.199 297.066 arc
s
newpath
.144 .856 .01003 270.801 359.199 arc
s
newpath
.12062 .83196 .02738 -27.0663 30.8012 arc
s
newpath
-0.1165 .5 .35593 -40.2078 0 arc
s
newpath
.05965 .23579 .1017 19.7922 86.3736 arc
s
newpath
.0068 .3767 .07119 -33.6264 44.1773 arc
s
newpath
-0.1165 1.1165 .71187 284.177 300 arc
s
newpath
-0.1165 .5 .35593 0 40.2078 arc
s
newpath
-0.1165 -0.1165 .71187 60 75.8227 arc
s
newpath
.0068 .6233 .07119 -44.1773 33.6264 arc
s
newpath
.05965 .76421 .1017 273.626 340.208 arc
s
newpath
.1301 .1301 .14237 10.2078 79.7922 arc
s
newpath
.23579 .05965 .1017 70.2078 122.934 arc
s
newpath
.14308 .14308 .03747 2.93365 87.0663 arc
s
newpath
.05965 .23579 .1017 -32.9337 19.7922 arc
s
newpath
.1301 .8699 .14237 280.208 349.792 arc
s
newpath
.05965 .76421 .1017 -19.7922 32.9337 arc
s
newpath
.14308 .85692 .03747 272.934 357.066 arc
s
newpath
.23579 .94035 .1017 237.066 289.792 arc
s
newpath
.23579 .05965 .1017 70.2078 122.934 arc
s
newpath
.16804 .12062 .02738 -13.2363 62.9337 arc
s
newpath
.20056 .09487 .02034 22.0279 106.764 arc
s
newpath
.5 -0.1165 .35593 130.208 142.028 arc
s
newpath
.23579 .94035 .1017 237.066 289.792 arc
s
newpath
.5 1.1165 .35593 217.972 229.792 arc
s
newpath
.20056 .90513 .02034 253.236 337.972 arc
s
newpath
.16804 .87938 .02738 -62.9337 13.2363 arc
s
newpath
.23579 .05965 .1017 3.62643 70.2078 arc
s
newpath
.1301 .1301 .14237 -21.5307 10.2078 arc
s
newpath
.26616 .05357 .02455 13.1018 98.4693 arc
s
newpath
.31868 .02856 .04187 63.6264 133.102 arc
s
newpath
.23579 .94035 .1017 289.792 356.374 arc
s
newpath
.31868 .97144 .04187 226.898 296.374 arc
s
newpath
.26616 .94643 .02455 261.531 346.898 arc
s
newpath
.1301 .8699 .14237 -10.2078 21.5307 arc
s
newpath
-0.1165 -0.1165 .71187 30 60 arc
s
newpath
-0.1165 .5 .35593 -40.2078 0 arc
s
newpath
.1301 .1301 .14237 10.2078 79.7922 arc
s
newpath
.5 -0.1165 .35593 90 130.208 arc
s
newpath
-0.1165 1.1165 .71187 300 330 arc
s
newpath
.5 1.1165 .35593 229.792 270 arc
s
newpath
.1301 .8699 .14237 280.208 349.792 arc
s
newpath
-0.1165 .5 .35593 0 40.2078 arc
s
newpath
.3767 .0068 .07119 45.8227 123.626 arc
s
newpath
.31868 .02856 .04187 1.06402 63.6264 arc
s
newpath
.37021 .01329 .01873 34.1518 121.064 arc
s
newpath
.44395 -0.00441 .06472 105.823 154.152 arc
s
newpath
.3767 .9932 .07119 236.374 314.177 arc
s
newpath
.44395 1.00441 .06472 205.848 254.177 arc
s
newpath
.37021 .98671 .01873 238.936 325.848 arc
s
newpath
.31868 .97144 .04187 296.374 358.936 arc
s
newpath
.5 -0.1165 .35593 90 130.208 arc
s
newpath
1.1165 -0.1165 .71187 150 165.823 arc
s
newpath
.3767 .0068 .07119 45.8227 123.626 arc
s
newpath
.23579 .05965 .1017 3.62643 70.2078 arc
s
newpath
.5 1.1165 .35593 229.792 270 arc
s
newpath
.23579 .94035 .1017 289.792 356.374 arc
s
newpath
.3767 .9932 .07119 236.374 314.177 arc
s
newpath
1.1165 1.1165 .71187 194.177 210 arc
s
newpath
-0.1165 -0.1165 .71187 14.1773 30 arc
s
newpath
1.1165 -0.1165 .71187 150 165.823 arc
s
newpath
.44395 -0.00441 .06472 30 105.823 arc
s
newpath
.55605 -0.00441 .06472 74.1773 150 arc
s
newpath
1.1165 1.1165 .71187 210 240 arc
s
newpath
1.1165 -0.1165 .71187 120 150 arc
s
newpath
-0.1165 -0.1165 .71187 30 60 arc
s
newpath
-0.1165 1.1165 .71187 300 330 arc
s
newpath
-0.1165 1.1165 .71187 330 345.823 arc
s
newpath
.55605 1.00441 .06472 210 285.823 arc
s
newpath
.44395 1.00441 .06472 254.177 330 arc
s
newpath
1.1165 1.1165 .71187 194.177 210 arc
s
newpath
.5 -0.1165 .35593 49.7922 90 arc
s
newpath
.76421 .05965 .1017 109.792 176.374 arc
s
newpath
.6233 .0068 .07119 56.3736 134.177 arc
s
newpath
-0.1165 -0.1165 .71187 14.1773 30 arc
s
newpath
.5 1.1165 .35593 270 310.208 arc
s
newpath
-0.1165 1.1165 .71187 330 345.823 arc
s
newpath
.6233 .9932 .07119 225.823 303.626 arc
s
newpath
.76421 .94035 .1017 183.626 250.208 arc
s
newpath
.6233 .0068 .07119 56.3736 134.177 arc
s
newpath
.55605 -0.00441 .06472 25.8482 74.1773 arc
s
newpath
.62979 .01329 .01873 58.936 145.848 arc
s
newpath
.68132 .02856 .04187 116.374 178.936 arc
s
newpath
.6233 .9932 .07119 225.823 303.626 arc
s
newpath
.68132 .97144 .04187 181.064 243.626 arc
s
newpath
.62979 .98671 .01873 214.152 301.064 arc
s
newpath
.55605 1.00441 .06472 285.823 334.152 arc
s
newpath
1.1165 .5 .35593 180 220.208 arc
s
newpath
1.1165 -0.1165 .71187 120 150 arc
s
newpath
.5 -0.1165 .35593 49.7922 90 arc
s
newpath
.8699 .1301 .14237 100.208 169.792 arc
s
newpath
1.1165 .5 .35593 139.792 180 arc
s
newpath
.8699 .8699 .14237 190.208 259.792 arc
s
newpath
.5 1.1165 .35593 270 310.208 arc
s
newpath
1.1165 1.1165 .71187 210 240 arc
s
newpath
.76421 .05965 .1017 109.792 176.374 arc
s
newpath
.68132 .02856 .04187 46.8982 116.374 arc
s
newpath
.73384 .05357 .02455 81.5307 166.898 arc
s
newpath
.8699 .1301 .14237 169.792 201.531 arc
s
newpath
.76421 .94035 .1017 183.626 250.208 arc
s
newpath
.8699 .8699 .14237 158.469 190.208 arc
s
newpath
.73384 .94643 .02455 193.102 278.469 arc
s
newpath
.68132 .97144 .04187 243.626 313.102 arc
s
newpath
.76421 .05965 .1017 57.0663 109.792 arc
s
newpath
.5 -0.1165 .35593 37.9721 49.7922 arc
s
newpath
.79944 .09487 .02034 73.2364 157.972 arc
s
newpath
.83196 .12062 .02738 117.066 193.236 arc
s
newpath
.76421 .94035 .1017 250.208 302.934 arc
s
newpath
.83196 .87938 .02738 166.764 242.934 arc
s
newpath
.79944 .90513 .02034 202.028 286.764 arc
s
newpath
.5 1.1165 .35593 310.208 322.028 arc
s
newpath
.8699 .1301 .14237 100.208 169.792 arc
s
newpath
.94035 .23579 .1017 160.208 212.934 arc
s
newpath
.85692 .14308 .03747 92.9337 177.066 arc
s
newpath
.76421 .05965 .1017 57.0663 109.792 arc
s
newpath
.8699 .8699 .14237 190.208 259.792 arc
s
newpath
.76421 .94035 .1017 250.208 302.934 arc
s
newpath
.85692 .85692 .03747 182.934 267.066 arc
s
newpath
.94035 .76421 .1017 147.066 199.792 arc
s
newpath
1.1165 .5 .35593 180 220.208 arc
s
newpath
1.1165 1.1165 .71187 240 255.823 arc
s
newpath
.9932 .3767 .07119 135.823 213.626 arc
s
newpath
.94035 .23579 .1017 93.6264 160.208 arc
s
newpath
1.1165 .5 .35593 139.792 180 arc
s
newpath
.94035 .76421 .1017 199.792 266.374 arc
s
newpath
.9932 .6233 .07119 146.374 224.177 arc
s
newpath
1.1165 -0.1165 .71187 104.177 120 arc
s
newpath
.85692 .14308 .03747 92.9337 177.066 arc
s
newpath
.83196 .12062 .02738 59.1987 117.066 arc
s
newpath
.856 .144 .01003 90.8012 179.199 arc
s
newpath
.87938 .16804 .02738 152.934 210.801 arc
s
newpath
.85692 .85692 .03747 182.934 267.066 arc
s
newpath
.87938 .83196 .02738 149.199 207.066 arc
s
newpath
.856 .856 .01003 180.801 269.199 arc
s
newpath
.83196 .87938 .02738 242.934 300.801 arc
s
newpath
.94035 .23579 .1017 160.208 212.934 arc
s
newpath
.87938 .16804 .02738 76.7636 152.934 arc
s
newpath
.90513 .20056 .02034 112.028 196.764 arc
s
newpath
1.1165 .5 .35593 220.208 232.028 arc
s
newpath
.94035 .76421 .1017 147.066 199.792 arc
s
newpath
1.1165 .5 .35593 127.972 139.792 arc
s
newpath
.90513 .79944 .02034 163.236 247.972 arc
s
newpath
.87938 .83196 .02738 207.066 283.236 arc
s
newpath
1.1165 -0.1165 .71187 104.177 120 arc
s
newpath
1.1165 1.1165 .71187 240 255.823 arc
s
newpath
1.00441 .44395 .06472 120 195.823 arc
s
newpath
1.00441 .55605 .06472 164.177 240 arc
s
newpath
.94035 .23579 .1017 93.6264 160.208 arc
s
newpath
.8699 .1301 .14237 68.4693 100.208 arc
s
newpath
.94643 .26616 .02455 103.102 188.469 arc
s
newpath
.97144 .31868 .04187 153.626 223.102 arc
s
newpath
.94035 .76421 .1017 199.792 266.374 arc
s
newpath
.97144 .68132 .04187 136.898 206.374 arc
s
newpath
.94643 .73384 .02455 171.531 256.898 arc
s
newpath
.8699 .8699 .14237 259.792 291.531 arc
s
newpath
.9932 .3767 .07119 135.823 213.626 arc
s
newpath
.97144 .31868 .04187 91.064 153.626 arc
s
newpath
.98671 .37021 .01873 124.152 211.064 arc
s
newpath
1.00441 .44395 .06472 195.823 244.152 arc
s
newpath
.9932 .6233 .07119 146.374 224.177 arc
s
newpath
1.00441 .55605 .06472 115.848 164.177 arc
s
newpath
.98671 .62979 .01873 148.936 235.848 arc
s
newpath
.97144 .68132 .04187 206.374 268.936 arc
s
newpath
.089 .089 .29062 92.1818 101.38 arc
s
newpath
.01194 .37156 .03633 -23.4953 42.0317 arc
s
newpath
.089 .911 .29062 258.62 267.818 arc
s
newpath
.01194 .62844 .03633 -42.0317 23.4953 arc
s
newpath
-0.01375 .39725 .14531 306.77 329.43 arc
s
newpath
.05475 .26025 .04844 11.2799 73.3013 arc
s
newpath
-0.01375 .60275 .14531 30.5696 53.2304 arc
s
newpath
.05475 .73975 .04844 286.699 348.72 arc
s
newpath
-0.01375 .60275 .14531 297.373 340.333 arc
s
newpath
-0.01375 .39725 .14531 19.6671 62.6272 arc
s
newpath
.14038 .14038 .07265 75.7797 111.454 arc
s
newpath
.089 .20643 .04152 -17.1236 41.6451 arc
s
newpath
.14038 .85962 .07265 248.546 284.22 arc
s
newpath
.089 .79357 .04152 -41.6451 17.1236 arc
s
.16957 .16957 m
.15109 .15109 L
s
newpath
.1438 .1438 .01937 10.9886 79.0113 arc
s
.16957 .83043 m
.15109 .84891 L
s
newpath
.1438 .8562 .01937 280.989 349.011 arc
s
newpath
.089 .089 .29062 65.7966 92.1818 arc
s
newpath
-0.01375 .39725 .14531 -30.5696 19.6671 arc
s
newpath
.089 .911 .29062 267.818 294.203 arc
s
newpath
-0.01375 .60275 .14531 -19.6671 30.5696 arc
s
.23078 .23078 m
.16957 .16957 L
s
newpath
.14038 .14038 .07265 14.2203 75.7797 arc
s
.23078 .76922 m
.16957 .83043 L
s
newpath
.14038 .85962 .07265 284.22 345.78 arc
s
newpath
.14038 .14038 .07265 -21.4537 14.2203 arc
s
newpath
.20643 .089 .04152 48.3549 107.124 arc
s
newpath
.14038 .85962 .07265 -14.2203 21.4537 arc
s
newpath
.20643 .911 .04152 252.876 311.645 arc
s
newpath
.39725 -0.01375 .14531 120.57 143.23 arc
s
newpath
.26025 .05475 .04844 16.6987 78.7201 arc
s
newpath
.39725 1.01375 .14531 216.77 239.43 arc
s
newpath
.26025 .94525 .04844 281.28 343.301 arc
s
.38687 .38687 m
.23078 .23078 L
s
newpath
.089 .089 .29062 24.2034 65.7966 arc
s
.38687 .61313 m
.23078 .76922 L
s
newpath
.089 .911 .29062 294.203 335.797 arc
s
newpath
.089 .089 .29062 348.62 357.818 arc
s
newpath
.37156 .01194 .03633 47.9683 113.495 arc
s
newpath
.089 .911 .29062 2.18185 11.3803 arc
s
newpath
.37156 .98806 .03633 246.505 312.032 arc
s
newpath
.089 .089 .29062 -2.18185 24.2034 arc
s
newpath
.39725 -0.01375 .14531 70.3329 120.57 arc
s
newpath
.089 .911 .29062 -24.2034 2.18185 arc
s
newpath
.39725 1.01375 .14531 239.43 289.667 arc
s
newpath
.60275 -0.01375 .14531 109.667 152.627 arc
s
newpath
.39725 -0.01375 .14531 27.3728 70.3329 arc
s
.61313 .61313 m
.38687 .38687 L
s
.61313 .38687 m
.38687 .61313 L
s
newpath
.60275 1.01375 .14531 207.373 250.333 arc
s
newpath
.39725 1.01375 .14531 289.667 332.627 arc
s
newpath
.911 .089 .29062 155.797 182.182 arc
s
newpath
.60275 -0.01375 .14531 59.4304 109.667 arc
s
newpath
.911 .911 .29062 177.818 204.203 arc
s
newpath
.60275 1.01375 .14531 250.333 300.57 arc
s
newpath
.911 .089 .29062 182.182 191.38 arc
s
newpath
.62844 .01194 .03633 66.5046 132.032 arc
s
newpath
.911 .911 .29062 168.62 177.818 arc
s
newpath
.62844 .98806 .03633 227.968 293.495 arc
s
newpath
.911 .089 .29062 114.203 155.797 arc
s
.61313 .38687 m
.76922 .23078 L
s
newpath
.911 .911 .29062 204.203 245.797 arc
s
.76922 .76922 m
.61313 .61313 L
s
newpath
.60275 -0.01375 .14531 36.7696 59.4304 arc
s
newpath
.73975 .05475 .04844 101.28 163.301 arc
s
newpath
.60275 1.01375 .14531 300.57 323.23 arc
s
newpath
.73975 .94525 .04844 196.699 258.72 arc
s
newpath
.85962 .14038 .07265 165.78 201.454 arc
s
newpath
.79357 .089 .04152 72.8764 131.645 arc
s
newpath
.85962 .85962 .07265 158.546 194.22 arc
s
newpath
.79357 .911 .04152 228.355 287.124 arc
s
.76922 .23078 m
.83043 .16957 L
s
newpath
.85962 .14038 .07265 104.22 165.78 arc
s
.76922 .76922 m
.83043 .83043 L
s
newpath
.85962 .85962 .07265 194.22 255.78 arc
s
newpath
.911 .089 .29062 87.8182 114.203 arc
s
newpath
1.01375 .39725 .14531 160.333 210.57 arc
s
newpath
.911 .911 .29062 245.797 272.182 arc
s
newpath
1.01375 .60275 .14531 149.43 199.667 arc
s
.83043 .16957 m
.84891 .15109 L
s
newpath
.8562 .1438 .01937 100.989 169.011 arc
s
.83043 .83043 m
.84891 .84891 L
s
newpath
.8562 .8562 .01937 190.989 259.011 arc
s
newpath
.85962 .14038 .07265 68.5463 104.22 arc
s
newpath
.911 .20643 .04152 138.355 197.124 arc
s
newpath
.85962 .85962 .07265 255.78 291.454 arc
s
newpath
.911 .79357 .04152 162.876 221.645 arc
s
newpath
1.01375 .60275 .14531 199.667 242.627 arc
s
newpath
1.01375 .39725 .14531 117.373 160.333 arc
s
newpath
1.01375 .39725 .14531 210.57 233.23 arc
s
newpath
.94525 .26025 .04844 106.699 168.72 arc
s
newpath
1.01375 .60275 .14531 126.77 149.43 arc
s
newpath
.94525 .73975 .04844 191.28 253.301 arc
s
newpath
.911 .089 .29062 78.6197 87.8182 arc
s
newpath
.98806 .37156 .03633 137.968 203.495 arc
s
newpath
.911 .911 .29062 272.182 281.38 arc
s
newpath
.98806 .62844 .03633 156.505 222.032 arc
s
newpath
.0205 .34017 .04567 -3.62643 85.8482 arc
s
newpath
.00093 .41193 .05871 -61.064 14.1773 arc
s
newpath
.00093 .58807 .05871 -14.1773 61.064 arc
s
newpath
.0205 .65983 .04567 -85.8482 3.62643 arc
s
newpath
.089 .19175 .10275 49.7922 106.898 arc
s
newpath
.03763 .2945 .05137 -38.4693 56.3736 arc
s
newpath
.03763 .7055 .05137 -56.3736 38.4693 arc
s
newpath
.089 .80825 .10275 253.102 310.208 arc
s
.23944 .5 m
.02795 .5 L
s
newpath
-0.01375 .5 .10275 -45.8227 45.8227 arc
s
newpath
.10768 .18241 .03736 -2.93365 97.9721 arc
s
newpath
.0205 .2945 .137 313.236 349.792 arc
s
newpath
.0205 .7055 .137 10.2078 46.7636 arc
s
newpath
.10768 .81759 .03736 -97.9721 2.93365 arc
s
newpath
.1575 .1301 .0274 32.9337 119.199 arc
s
newpath
.1301 .1575 .0274 -29.1988 57.0663 arc
s
newpath
.1301 .8425 .0274 -57.0663 29.1988 arc
s
newpath
.1575 .8699 .0274 240.801 327.066 arc
s
newpath
-0.1165 .7055 .411 296.374 330 arc
s
newpath
.0205 .2945 .137 -10.2078 74.1773 arc
s
newpath
.0205 .7055 .137 -74.1773 10.2078 arc
s
newpath
-0.1165 .2945 .411 30 63.6264 arc
s
newpath
.089 .19175 .10275 -27.0663 49.7922 arc
s
newpath
.19175 .089 .10275 40.2078 117.066 arc
s
newpath
.19175 .911 .10275 242.934 319.792 arc
s
newpath
.089 .80825 .10275 -49.7922 27.0663 arc
s
newpath
.2945 .0205 .137 100.208 136.764 arc
s
newpath
.18241 .10768 .03736 -7.97211 92.9337 arc
s
newpath
.18241 .89232 .03736 -92.9337 7.97211 arc
s
newpath
.2945 .9795 .137 223.236 259.792 arc
s
newpath
.2945 .03763 .05137 33.6264 128.469 arc
s
newpath
.19175 .089 .10275 -16.8982 40.2078 arc
s
newpath
.19175 .911 .10275 -40.2078 16.8982 arc
s
newpath
.2945 .96237 .05137 231.531 326.374 arc
s
newpath
.2945 -0.1165 .411 60 109.792 arc
s
newpath
-0.1165 .2945 .411 -19.7922 30 arc
s
newpath
-0.1165 .7055 .411 -30 19.7922 arc
s
newpath
.2945 1.1165 .411 250.208 300 arc
s
newpath
.41193 .00093 .05871 75.8227 151.064 arc
s
newpath
.34017 .0205 .04567 4.15179 93.6264 arc
s
newpath
.34017 .9795 .04567 266.374 355.848 arc
s
newpath
.41193 .99907 .05871 208.936 284.177 arc
s
newpath
.2945 .0205 .137 15.8227 100.208 arc
s
newpath
.7055 -0.1165 .411 120 153.626 arc
s
newpath
.7055 1.1165 .411 206.374 240 arc
s
newpath
.2945 .9795 .137 259.792 344.177 arc
s
newpath
.5 -0.01375 .10275 44.1773 135.823 arc
s
.5 .23944 m
.5 .02795 L
s
.5 .76056 m
.5 .23944 L
s
.76056 .5 m
.23944 .5 L
s
.5 .76056 m
.5 .97205 L
s
newpath
.5 1.01375 .10275 224.177 315.823 arc
s
newpath
.2945 -0.1165 .411 26.3736 60 arc
s
newpath
.7055 .0205 .137 79.7922 164.177 arc
s
newpath
.7055 .9795 .137 195.823 280.208 arc
s
newpath
.2945 1.1165 .411 300 333.626 arc
s
newpath
.65983 .0205 .04567 86.3736 175.848 arc
s
newpath
.58807 .00093 .05871 28.936 104.177 arc
s
newpath
.58807 .99907 .05871 255.823 331.064 arc
s
newpath
.65983 .9795 .04567 184.152 273.626 arc
s
newpath
.7055 -0.1165 .411 70.2078 120 arc
s
newpath
1.1165 .2945 .411 150 199.792 arc
s
newpath
1.1165 .7055 .411 160.208 210 arc
s
newpath
.7055 1.1165 .411 240 289.792 arc
s
newpath
.80825 .089 .10275 139.792 196.898 arc
s
newpath
.7055 .03763 .05137 51.5307 146.374 arc
s
newpath
.7055 .96237 .05137 213.626 308.469 arc
s
newpath
.80825 .911 .10275 163.102 220.208 arc
s
newpath
.81759 .10768 .03736 87.0663 187.972 arc
s
newpath
.7055 .0205 .137 43.2364 79.7922 arc
s
newpath
.7055 .9795 .137 280.208 316.764 arc
s
newpath
.81759 .89232 .03736 172.028 272.934 arc
s
newpath
.80825 .089 .10275 62.9337 139.792 arc
s
newpath
.911 .19175 .10275 130.208 207.066 arc
s
newpath
.911 .80825 .10275 152.934 229.792 arc
s
newpath
.80825 .911 .10275 220.208 297.066 arc
s
newpath
.9795 .2945 .137 105.823 190.208 arc
s
newpath
1.1165 .7055 .411 210 243.626 arc
s
newpath
1.1165 .2945 .411 116.374 150 arc
s
newpath
.9795 .7055 .137 169.792 254.177 arc
s
newpath
.8699 .1575 .0274 122.934 209.199 arc
s
newpath
.8425 .1301 .0274 60.8013 147.066 arc
s
newpath
.8425 .8699 .0274 212.934 299.199 arc
s
newpath
.8699 .8425 .0274 150.801 237.066 arc
s
newpath
.9795 .2945 .137 190.208 226.764 arc
s
newpath
.89232 .18241 .03736 82.0279 182.934 arc
s
newpath
.89232 .81759 .03736 177.066 277.972 arc
s
newpath
.9795 .7055 .137 133.236 169.792 arc
s
newpath
1.01375 .5 .10275 134.177 225.823 arc
s
.76056 .5 m
.97205 .5 L
s
newpath
.96237 .2945 .05137 123.626 218.469 arc
s
newpath
.911 .19175 .10275 73.1018 130.208 arc
s
newpath
.911 .80825 .10275 229.792 286.898 arc
s
newpath
.96237 .7055 .05137 141.531 236.374 arc
s
newpath
.99907 .41193 .05871 165.823 241.064 arc
s
newpath
.9795 .34017 .04567 94.1518 183.626 arc
s
newpath
.9795 .65983 .04567 176.374 265.848 arc
s
newpath
.99907 .58807 .05871 118.936 194.177 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0ofK<<fHcVC?<oc=V<`3oV@1VoonI<jBTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0c6K<06HcIS?<c3=V003oIP1Vc?l0VIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0VFJIofHc<c?<
VC<co`3o<kjn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0IVJIc01V<c?<IS<cc03o09UV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T0<fJIVFH0o`0coc<cV@3<ofHc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVIT006JIIVH0c3?<03<cIP3<c01V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoofJI<fH0VC>Ioc<c<`3<VC?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoc6JI06H0IS>I
c3<c003<IP2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoVFIVofH0<c>IVC<0o`3<<`00omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKoIVIVc6H003>IIS<0c03<03<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko<fIVVC?ooc>I<`0cIP0cc?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFKo06IVIS?oc3>I03<0IP2Ic?l00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<ofIV<c?oVC=V
oc<0<`2IVOmV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<c6IV03?oIS=Vc3<0002II_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<VFHcoc?o<c=VV@3oo`2I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVJZZZVK<IVHcc3?o03=VIP3oc02I00000?l06`000?l06`000?l06`000?l06`000?l0
6`000?l06`000?l06`0006`000?o0000?@000ol0001[0000J`02oal000?o00007@02of`0001U00Oo
00<0o`007@000ol0000L0003o`3o00KoIP0006D000Oo0000o`3o008000?o00006P03oa`000Ko003o
0?l30003o`0006@0001U00;o0P000ol0o`0200;o6P001Ol0o`3o01X00_l20003o`3o00800_mV0000
I0002_l00?l0o`3o0?l20003o`0001H000Co003o0P000ol0000F000:o`00o`3o0?l0o`8000?o0000
H`0006@00ol00`3oo`03o`@000?o000050001Ol0003o00<000?o000050000ol0000200Go0P02ofD0
001S0004o`0000Co1`02oa<000?o00000P000ol000020003o`0001400_l700Go0P000ol0001R0000
H`000ol0000300Co1`000ol0000>00;o1@000ol0000300?o3`000ol0000600?o1@000ol0001R0000
HP000ol0000200;o00@0o`000_l600;o2`04o`H000?o000010000ol0o`02o`X00_l600?o00<0o`00
0ol30003o`000640001A00;o3@02o`800ol30003o`0000804ol40003o`0000<000?o00000`000ol0
000301;o10000ol0000200;o0P02o`d00_mB0000D@000ol0o`0;0003o`0000;o1P000ol0000900?o
3@000ol000030003o`0000<000?o00002`03o`/000?o00001002o`8000?o00002@000ol0o`1B0000
D002o`800_l800Co20000ol0000700;o00<0ool00ol;0003o`00008000?o00000P000ol0000:00Co
00<0ool02@000ol0000600Co2002o`800_mA0000C`000ol0o`0400Wo00<0o`0020000ol000060006
o`00o`3o0`000ol000090005o`000?l00`000ol0000900;o0P000ol0o`020003o`0000H000?o0000
1`000ol0o`08o`@000?o0?l0D00004d00_l30005o`000?l01@001Ol0ool000?o1P000ol0000300?o
0`000ol0o`040003o`0000P000Go0000o`030003o`0000P000?o00000P000ol0o`0300?o1@000ol0
000400?o00D0ool0o`050005o`000?l00`02odh0001900Co0P001?l00?l20003o`0000<000?o0000
0_l400co1@001Ol0003o00@00ol80004o`00o`8000?o00001`02o`@000Go0000o`0500co1002o`80
00?o00000`001?l00?l20003o`0000CoBP0004T000?o0?l010001Ol0o`3o00@00_l30003o`3o00T0
00?o000020001Ol0003o00L00_l60004o`00o`8000?o00001003o`H000Go0000o`0:0003o`0000L0
00?o0?l00`02o`@000Go0?l0o`040003o`3o04X0001:0003o`3o00;o0P02o`030?l0008000?o0000
0`000ol0o`090003o`0000P000Go0000o`0900?o10001Ol0o`3o00D00_l90005o`000?l02P000ol0
00070003o`3o00D000Ko0000o`02o`<00_l00`3o001:0000BP000ol0000200Wo1@001Ol0003o00P0
00?o00001`000ol000030003o`0000T03_l:0003o`0000<000?o00001`000ol000060005o`000?l0
1@0:o`<000?o0000B@0004X000?o00001003o`T000Go0000o`080003o`0000H000?o000010000ol0
000>00?o40000ol000040003o`0000H000?o00001P001Ol0003o00T00ol60003o`0004T0001;0003
o`00008000Go0?l0o`080003o`00008000?o00001@000ol000060003o`0000@000?o00003@001Ol0
o`3o00l000?o000010000ol000060003o`0000D000?o00000P000ol000060005o`3o0?l010000ol0
001:0000B`000ol00002o`8000Co003o1`000ol000030003o`0000@000?o00001@000ol000060003
o`0000/000Co003o0P000ol0000;0003o`0000H000?o00001@000ol000040003o`0000<000?o0000
1@001?l00?l200;o0P000ol0001:0000?@000ol0000;00?o10001Ol0003o00D000?o00001@000ol0
00030003o`0000@000?o00001`000ol0000:0005o`000?l00`000ol0000:0003o`0000L000?o0000
10000ol000030003o`0000D000?o00000`001Ol0003o00@00ol=0003o`0003`0000l00?o3@000ol0
00030003o`0000800_l30003o`0000H000?o00000P000ol000040003o`0000L000?o00002002o`@0
00?o00000P02o`X000?o00001`000ol000040003o`00008000?o00001P001?l00002o`@000?o0000
10000ol0000:00?o?@0003/000Go0?l0o`0<0003o`0000<000?o000010000ol0o`090003o`000080
00?o00000`000ol000080003o`0000L000?o000010000ol000040003o`0000L000?o000020000ol0
00030003o`00008000?o00001`000ol0o`060003o`0000@000?o00002@001Ol0o`3o03`0000i00;o
0P000ol0o`0<0003o`0000<000?o00001@02o`X000Go0000o`040003o`0000X000?o00001002o`L0
00?o00001@02o`H000?o00002P000ol000020005o`000?l02P02o`L000?o00000`000ol0000:0003
o`3o00800_lj0000=P03o`050?l00?l00P000ol000090003o`00008000?o00001P001?l0ool80005
o`000?l00`000ol0000;0003o`0000800_l90003o`0000L00_l40003o`0000/000Go0000o`030003
o`0000H00_l00`3o00070003o`00008000?o00002@001?l00?l20003o`3o00;o=`0003H00_l20004
o`00o`<000?o000020000ol000020003o`0000D000?o00000P02o`L000Co003o0P000ol0000<0003
o`3o00;o2`000ol0000900?o00<0o`003@001?l00?l20003o`0000D00_l40003o`0000D000?o0000
0P000ol000080005o`000?l00P000ol00002ocL0000f0003o`3o00;o0P001_l00?l0o`T000?o0000
0P000ol000040003o`0000D01Ol30005o`3o0?l03`02o`h000?o00003002o`l000Go0?l0o`0300Go
1`000ol000040003o`00008000?o00001`000ol0o`020003o`0000?o00<0o`00=P0003H000Co0000
0ol00`3oo`030003o`0000H000Go0000o`060003o`0000/00_l01@3oo`3o00`01?l00`3o000=0003
o`0000`000?o0?l01?l;0005o`3oo`000_l=0003o`0000@000Go0000o`080004o`0000Ko0`000ol0
000e0000=P08o`H000?o00001@001Ol0003o00H000?o00003@0Ao`D000?o000030000ol0000<0003
o`0000@04?l?0003o`0000@000Go0000o`070003o`0000D01olg0000=P001?l00003o`P000?o0000
10001?l00?l500;o4@03oa<000?o00002`000ol0000;0003o`0001400olA00;o1@001?l00?l60003
o`0000H00ol30003o`0003D0000e0003o`0000;o00<0o`000ol60003o`0000<000Co003o10000ol0
000?00;o00@0o`3o4P000ol0000;0003o`0000/000?o000040001?l0o`02oa4000?o00000P001?l0
0?l50003o`0000D00_l00`3o0002o`8000?o0000=00003<00_l00`3oo`030003o`0000800ol40003
o`00008000Co003o0P02oa4000Go0000o`020003o`00010000?o00002P000ol0000:0003o`000100
00Co003o0`000ol0000?00;o0P001?l00?l40003o`0000<00ol30004o`0000;o00<0ool0=00002/0
0_l400Go1@000ol0000500;o0`002?l0003o0?l00_l?00Co10001?l00?lB0003o`0000X000?o0000
2P000ol0000@0004o`00o`@01?l?00;o00@0o`3o0`000ol0000200;o1P000ol0000300Go1002ob`0
000[0003o`3o00Go00<0o`001@000ol000070005o`000?l00P04oa0000?o00001P001Ol0003o0140
00?o00002P000ol0000:0003o`0000l000Go0000o`080003o`0000h01?l20003o`00008000?o0000
1P000ol000040003o`3o00Go00<0o`00:`0002T00_l00`3oo`020005o`3oo`000ol30003o`0000P0
2?l>00Co20000ol000030003o`0000l000?o00002@000ol000090003o`0000l000?o00000`000ol0
000600Co3P09o`T000?o00000P02o`050?oo0?l00P02o`030?oo02X0000X00Go0P000ol00002o`@0
0_l00`3o000>00Co2005o``000?o000010000ol0000>0003o`0000T000?o00002@000ol0000>0003
o`0000@000?o00002P05o`P01Ol>0003o`3o00;o0`02o`8000?o00000_l00`3oo`0Y0000:0000ol0
0004o`8000Co003o1@04o`P01ol200So4@000ol000050003o`0000h000?o000020000ol000080003
o`0000h000?o00001@000ol0000?00So0P07o`P01?l50004o`00o`801Ol00`3o000X0000:@02o`03
0?oo00<000Co003o1P000ol00008o`@01OlI0003o`0000H000?o00003@000ol000080003o`0000P0
00?o00003@000ol000060003o`0001L01Ol400So0P000ol000040004o`00o`<00_l20003o`0002P0
000Y0008o`00o`3o0?l30003o`0000<000?o000030001?l0ool200;o5`000ol000070003o`0000`0
00?o000020000ol000080003o`0000`000?o00001`000ol0000E00;o0P02o`030?l000d000?o0000
0`002Ol0003o0?l0o`020003o`0002P0000Y0003o`3o00<000?o00000`000ol000020003o`0000X0
0_l200;o10000ol0000C0003o`0000T000?o000030000ol000070003o`0000L000?o000030000ol0
00090003o`0001<000?o00000P02o`800_l<0003o`00008000?o00000`001ol0003o0?l0:P0002T0
0_l200;o00<0o`000`000ol000020003o`0000P00_l30004o`00o`<000?o00004`000ol000090003
o`0000d000?o00001P000ol000060003o`0000d000?o00002@000ol0000C0005o`000?l00P001?l0
0002o`X000?o00000P000ol000020004o`3oo`800_lZ0000:@001?l0ool40005o`000?l00`000ol0
00080003o`0000<000Co003o1002oa8000?o00002`02o`d000?o00001P000ol000060003o`0000/0
0_l=0003o`0001000_l40004o`00o`D000?o000020001Ol0003o00<000?o00000P02o`030?l002T0
000X00?o1`001?l00?l20003o`0000P000?o000010001?l00?l600;o40000ol0000=0003o`0000X0
00?o00001P000ol000060003o`0000X000?o00003@000ol0000>00;o1P001?l00?l60003o`0000P0
00Co003o0P000ol0000500?o:@0002P000?o0?l00_l60005o`3o0?l01`04o`H000?o00000P000ol0
000500;o3P000ol0000>0003o`0000X000?o00001@000ol000050003o`0000X000?o00003P000ol0
000<00;o1`000ol000020003o`0000@01Ol60005o`3o0?l01`02o`030?l002P0000W00?o0`02o`D0
0ol500?o2P000ol000020003o`0000L00_l<0003o`0000l000?o00002@000ol000050003o`0000D0
00?o00002@000ol0000?0003o`0000X00_l90003o`00008000?o00002@02o`D00ol500?o0P03obP0
000V0005o`3o0?l0100=o`d000?o00000P000ol0000900;o2@000ol0000A0003o`0000T000?o0000
10000ol000040003o`0000T000?o00004@000ol0000700;o2`000ol000020003o`0000/03Ol40005
o`3o0?l09`0002001_l20003o`3o00T00olA0003o`0000@000?o00002P02o`L000?o00004P000ol0
00080003o`0000@000?o000010000ol000080003o`00018000?o00001@02o``000?o000010000ol0
000?00?o2@000ol0o`0200Ko8@0002000_l20004o`00o`<000?o00001@001Ol0o`3o010000?o0000
10000ol0000<00;o1@000ol0000C0003o`0000P000?o00000`000ol000030003o`0000P000?o0000
4`000ol0000300;o3P000ol000040003o`0000h000Go0?l0o`070005o`000?l00P000ol00002ob40
000P0005o`3o0?l00P001Ol0003o00H000Co003o0P000ol0000<0003o`0000D000?o00003P02o`80
00?o00005@02o`P000?o00000`000ol000030003o`0000H00_lG0003o`0000;o40000ol000050003
o`0000`000Co003o0P000ol000040005o`000?l00P001Ol0o`3o0240000P0007o`3o0?l0o`040003
o`0000800_l30005o`000?l030000ol000060003o`0001000olI0003o`0000D000?o00000`000ol0
00030003o`0000D000?o00005`03oa8000?o00001P000ol0000:0005o`000?l00`02o`@000?o0000
0P001ol0o`3o0?l08@0001l01ol60004o`3oo`D000?o00000P000ol000090003o`0000L000?o0000
4003oaT000?o00001@000ol000020003o`00008000?o00001@000ol0000G00?o4P000ol000070003
o`0000T000?o00000P000ol0000300Co1P07ob00000N0003o`0000802ol70003o`0000<000?o0000
1`000ol000080003o`00010000?o00000_lH0003o`0000D000Go0000o`030003o`0000D000?o0000
5P02o`8000?o000040000ol000080003o`0000L000?o00000`000ol0000600[o10000ol0000M0000
7@000ol0000200Co1P000ol000060003o`0000@000?o00001@000ol000090003o`0000l000?o0000
0`02oaL00_l50005o`000?l00`000ol0000300;o5`02o`D000?o00003`000ol000090003o`0000D0
00?o000010000ol000060003o`0000@01?l40003o`0001`0000L00Ko0P000ol0o`050003o`0000D0
00?o00001P000ol000030003o`0000X000?o00003P000ol0000600Co5@02o`@000Co003o0P000ol0
000200;o5@04o`P000?o00003P000ol0000:0003o`0000<000?o00001P000ol000050003o`0000<0
00?o0?l00P06oad0000M0003o`0000<000Co003o1P000ol000040003o`0000L000Go0000o`0=0003
o`0000h000?o00002P02oaD00_l20004o`00o`8000?o00000_lE00;o30000ol0000>0003o`0000/0
00Go0000o`090003o`0000@000?o000010001?l00?l50003o`0001`0000N00;o0`001Ol0003o00D0
00?o00000`000ol000090003o`3o00l000?o00003@000ol0000<00Co4`000ol0o`020006o`00o`3o
4`04o`h000?o00003@000ol0000=0003o`3o00/000?o00000`000ol000030005o`000?l00`02oal0
000P0003o`3o00@000?o00000`000ol000030003o`0000X000?o00003P000ol0000=0003o`000100
1?l?0008o`00o`3o0?l20003o`0000d01?lB0003o`0000d000?o00003P000ol0000:0003o`0000<0
00?o00000`000ol000020003o`3o0240000Q0003o`0000<000?o00000`000ol000030003o`0000T0
00?o0?l03`000ol0000<0003o`0001D01Ol;00?o00<0o`000ol;00Go5`000ol0000<0003o`0000d0
00?o0?l02`000ol000030003o`0000<000?o00000`000ol0000P00008P000ol000030003o`000080
00?o00000`000ol000080005o`000?l03P000ol0000;0003o`0001/02?l500Go1@08oad000?o0000
2`000ol0000<0005o`000?l02P000ol000030003o`00008000?o00000`000ol0000Q00008`000ol0
00020003o`00008000?o00000P000ol000080003o`0000<000?o00002`000ol0000;0003o`0002<0
3olU0003o`0000/000?o00002`000ol000030003o`0000P000?o00000P000ol000020003o`000080
00?o00008P0002@000?o00000P001Ol0003o00<000?o00001`02o`L000?o00002P000ol0000:0003
o`0002L00ol0103o0002obT000?o00002P000ol0000:0003o`0000D00_l90005o`000?l00`000ol0
00020003o`0002<0000U0003o`00008000Co003o0`000ol000060003o`0000P000?o00002@000ol0
00090003o`0002L000Co00000ol30003o`0002L000?o00002@000ol000090003o`0000P000?o0000
1P001Ol0003o008000?o00000P000ol0000T00009P001Ol0003o008000Co003o20000ol0000:0003
o`0000P000?o00002@000ol0000U00;o0`001Ol0o`3o00<00_lW0003o`0000T000?o000020000ol0
000:0003o`0000H000Co003o0P001Ol0003o02L0000W0006o`00o`3o0`000ol000050003o`0000`0
00?o000020000ol000070003o`0002@00_l50005o`3o0?l01@03obD000?o00001`000ol000080003
o`0000`000?o00001@001ol0003o0?l00P000ol0000V0000:0001Ol0o`3o008000?o00001002oa00
00?o00001`000ol000070003o`0002400ol60004o`00o`8000?o00001@02ob<000?o00001`000ol0
00070003o`0000h00ol50008o`00o`3o0?lY00005@03oa400_l0103o0?l400?o4`000ol000060003
o`0000H000?o00008@000ol000070004o`00o`8000?o00001`000ol0000Q0003o`0000H000?o0000
1P000ol0000B00?o0`001?l0o`02oa800_lF00005@000ol00003o`l01?l200?o5`000ol000050003
o`0000D000?o00008002o`T000Go0000o`030003o`0000L00olQ0003o`0000D000?o00001@000ol0
000F00?o00<0ool00_l@00?o00<0o`005@0001D00_l400Go2P06oa/000?o000010000ol000040003
o`0001h00ol:0003o`00008000?o00000P000ol0000900?o7`000ol000040003o`0000@000?o0000
6P06o`X01Ol300;o5P0001D000?o0?l010001?l0000=o`040?oooa/000?o00000`000ol000030003
o`0001`00ol=0003o`00008000?o00000P000ol0000<00?o7@000ol000030003o`0000<000?o0000
6P06o`030?oo00So0P000ol000020003o`3o01H0000E0003o`3o00@000?o00002P03o`030?l00080
0olI0003o`00008000?o00000P000ol0000J00?o3`000ol000030003o`0000<000?o00003P03oa/0
00?o00000P000ol000020003o`0001P00ol20003o`3o00;o30000ol000020003o`3o01H0000D0005
o`000?l00`000ol000090006o`3oo`3o1P02oaP000Go0000o`040003o`0001H01?lA0003o`0000@0
00?o000010000ol0000@00?o60000ol000020005o`000?l06003o`D000Ko0?oo0?l;0005o`000?l0
0`000ol0000C00004`000ol0o`020004o`00o`P01?l01`3o003o0?l01`04oaD000Co003o0`000ol0
000B00Go5@000ol000040003o`0000@000?o00004`05oa@000Go0000o`020003o`0001<01?l70003
o`3o008000?o0?l00ol80004o`00o`8000?o0?l0500001400_l30003o`3o008000?o00001@000ol0
00030006o`00o`3o2`05oa4000Co0?l00_lA00Co6@000ol000050003o`0000D000?o00005`04oa40
0_l0103o0?lA00Go2`000ol0o`020003o`0000<000?o00001@001_l00?l0o`<00_lB00004004o`<0
0_l00`3o000300Co1@001Ol0003o00800_l>00So2P03o`/02?lL0003o`0000H000?o00001P000ol0
000J00So2`03o`X02?l>00;o0P001Ol0003o00D01?l40004o`3oo`<01?lA000040001?l0000;o`T0
00Go0000o`040003o`0001<06?lS0003o`0000L000?o00001`000ol0000Q01So5@000ol000020005
o`000?l02@0;o`<000?o00003`00014000?o00000`03o`d000?o00000P000ol000020003o`0001h0
0_l]0003o`0000P000?o000020000ol0000[00;o80000ol000020003o`00008000?o00002`03o`D0
00?o00004000018000Wo0000o`3o0?l02`000ol000030003o`0000<000?o00007002o`030?l002/0
00?o000020000ol000080003o`0002X000Co0?oo7P000ol000030003o`0000<000?o00002@001Ol0
o`3o00<000?o00004@00018000Co0?oo0P001?l00?l:0003o`0000<000?o00000`000ol0000J00;o
00D0o`00o`0Z0003o`0000T000?o00002@000ol0000X0005o`00o`000_lL0003o`0000<000?o0000
0`000ol000080004o`00o`800_l00`3o000B00004`000ol000020005o`000?l01`02o`H000?o0000
10000ol0000H0005o`000?l00`000ol0000V0003o`0000X000?o00002P000ol0000V0005o`000?l0
0`000ol0000H0003o`0000@000?o00001002o`L000Go0000o`040003o`000180000C0003o`000080
00?o00000P000ol000030003o`0000H000?o000010000ol0000G0003o`00008000?o00000P000ol0
000U0003o`0000X000?o00002P000ol0000U0003o`00008000?o00000P000ol0000G0003o`0000@0
00?o00001P000ol000030003o`00008000?o00000P000ol0000B00004`000ol000020003o`000080
00?o00000P000ol000060003o`0000H000?o00005@000ol000030003o`0000<000?o00008`000ol0
000;0003o`0000/000?o00008`000ol000030003o`0000<000?o00005@000ol000060003o`0000H0
00?o00000P000ol000020003o`00008000?o00004P0001<000Go0000o`060004o`00o`T000?o0000
1P000ol0000D0003o`0000@000?o000010000ol0000Q0003o`0000`000?o000030000ol0000Q0003
o`0000@000?o000010000ol0000D0003o`0000H000?o00001`001?l00?l60005o`000?l0500001<0
00Co003o2002o`X000?o00001`000ol0000A00;o1`000ol000050003o`0001l000?o00003@000ol0
000=0003o`0001l000?o00001@000ol0000500;o4`000ol000070003o`0000P00_l80004o`00oa@0
000C0003o`3o00L00ol;0003o`0000L000?o000040000ol000070003o`0000H000?o00007@000ol0
000>0003o`0000h000?o00007@000ol000060003o`0000L000?o000040000ol000070003o`0000T0
0ol70003o`3o01@0000C00;o1P02o`<000?o000020000ol000080003o`0000d00_l:0003o`0000L0
00?o000070000ol0000>0003o`0000h000?o000070000ol000070003o`0000P00_l?0003o`0000P0
00?o000020001?l00002o`H00_lD00004`001?l00004o`D000?o00001`000ol000090003o`0000`0
00?o00002P000ol000080003o`0001X000?o00003`000ol0000?0003o`0001X000?o000020000ol0
000:0003o`0000`000?o00002@000ol000070003o`0000<01?l30003o`000180000B00Go2P000ol0
00060003o`0000X000?o00002@02o`d000?o00002@000ol0000H0003o`00010000?o000040000ol0
000H0003o`0000T000?o00002`02o`/000?o00002P000ol000060003o`0000P01OlC00004P001?l0
ool;0003o`0000H000?o00002P000ol000080003o`0000d000?o00002P000ol0000F0003o`000140
00?o00004@000ol0000F0003o`0000X000?o00003@000ol000080003o`0000X000?o00001P000ol0
000900;o00<0o`004P0001400ol200;o2P000ol000040003o`0000`000?o00001@02o`l000?o0000
30000ol0000D0003o`00018000?o00004P000ol0000D0003o`0000`000?o00003@02o`L000?o0000
30000ol000040003o`0000P00_l200?o4P00010000Go0?l0o`0300;o20000ol000040003o`0000`0
00?o00000P03oa4000?o00003@000ol0000C0003o`00018000?o00004P000ol0000C0003o`0000d0
00?o00003`03o`@000?o000030000ol000040003o`0000H00_l30005o`3o0?l04@0000l000Ko003o
0?l50003o`0000D000?o00000`000ol0000>0004o`3ooa@000?o00003P000ol0000A0003o`0001<0
00?o00004`000ol0000A0003o`0000h000?o00004P02o`030?l000l000?o00000`000ol000050003
o`0000<000?o0?l00P000ol0000>00003@02o`8000Co003o1P000ol000040003o`0000<000?o0000
3P02oaH000?o00003`000ol0000?0003o`0001@000?o000050000ol0000?0003o`0000l000?o0000
5002oa0000?o00000`000ol000040003o`0000@000Co003o0P03o`d0000:00?o10001Ol0003o00H0
00?o00000`000ol000030003o`0000`00_l00`3o000E0003o`00010000?o00003@000ol0000E0003
o`0001D000?o00003@000ol0000@0003o`0001@000Co0?oo3P000ol000030003o`0000<000?o0000
10001Ol0003o00@00ol;00002002o`8000Go0000o`040003o`0000D00_l40005o`000?l03@02o`<0
00?o000050000ol0000A0003o`0000/000?o00005P000ol0000F0003o`0000/000?o00004@000ol0
000D0004o`0000?o30001Ol0003o00@00_l70003o`00008000Go0000o`0200;o2@0000P000?o0?l0
0P001?l00?l40003o`0000L00_l20005o`000?l02005o`H000?o00004`000ol0000B0003o`0000X0
00?o00005P000ol0000F0003o`0000X000?o00004P000ol0000C0003o`0000D01?l80005o`000?l0
0P02o`T000?o00000P001?l00?l20003o`3o00T000080008o`00o`3o0?l50003o`0000T000Ko003o
0?l700;o2`000ol0000B0003o`0001@000?o000020000ol0000G0003o`0001L000?o000020000ol0
000D0003o`00018000?o00002@02o`L000?o0?l00P000ol000090003o`0000<000Go0?l0o`020003
o`0000L000080004o`0000Co1@000ol0000:00?o00@0o`001Ol>0003o`00014000?o00005@000ol0
00060003o`0001P000?o000060000ol000060003o`0001D000?o00004@000ol0000<00Go0P000ol0
o`02o``000?o00000`04o`<000?o00001`0000P01ol60003o`0000X01olC0003o`00014000?o0000
5P000ol000040003o`0001T000?o00006@000ol000040003o`0001H000?o00004@000ol0000A00Oo
30000ol0000400Oo2@0000P000Co00005_l200;o5`000ol0000@0003o`0001L000Co00000_lL0003
o`0001X00_l30003o`0001L000?o000040000ol0000E00;o0P0Fo`<000?o00001`0000L01Ol00`3o
o`060003o`0000/00_l00`3o000E0003o`00010000?o000060000ol0o`0N0003o`0001`000?o0?l0
6P000ol0000@0003o`0001@000Co0?oo3@000ol0000400;o00<0ool00ol800001P02o`@000Co003o
1@000ol0000:0003o`3o00800_lD0003o`0000l000?o00006P000ol0000M0003o`0001d000?o0000
6P000ol0000?0003o`0001800_l20003o`3o00`000?o00000`001?l00?l400;o1`0000P000Go0000
o`020003o`0000<000?o00002@001?l00?l40003o`00014000?o00003`000ol0000J00;o7P000ol0
000L00;o70000ol0000?0003o`00014000?o00000P001?l00?l;0003o`0000<000Co003o0`000ol0
000700002@000ol0o`030003o`0000<000?o000020001Ol0003o00D000?o00004@000ol0000>0003
o`0001T000Co003o7@000ol0000K0004o`00oa/000?o00003P000ol0000A0003o`0000<000Go0000
o`0:0003o`0000<000Oo0000o`3o00X0000:0003o`0000<000?o00000P000ol0000600;o10000ol0
00040003o`00010000?o00003P000ol0000H0003o`00008000?o00006P000ol0000J0003o`000080
00?o000060000ol0000>0003o`00010000?o000010000ol0000200;o20000ol000020003o`0000<0
00?o00002@0000/000?o00000P001Ol0003o00P000?o000010000ol000050003o`00010000?o0000
3@000ol0000G0003o`0000@000?o00006@000ol0000I0003o`0000@000?o00005`000ol0000=0003
o`00010000?o00001@000ol000040003o`0000H000Go0000o`040003o`0000X0000<0005o`000?l0
0`000ol0000400;o1`000ol000060003o`0000l000?o000030000ol0000F00;o20000ol0000H0003
o`0001P000?o00001P02oaP000?o000030000ol0000?0003o`0000H000?o00001@02o`H000Go0000
o`030003o`0000/0000=0004o`00o`<000?o00000`000ol000070003o`0000L000?o00003P000ol0
000<0003o`0001D000?o00002@000ol0000G0003o`0001L000?o00002@000ol0000E0003o`0000`0
00?o00003P000ol000070003o`0000L000?o00000`001Ol0003o008000?o0000300000d000Co003o
0`000ol000020003o`0000P000?o00002002o`h000?o000030000ol0000D0003o`0000/000?o0000
5P000ol0000F0003o`0000/000?o000050000ol0000<0003o`0000`00_l:0003o`0000P000?o0000
0P001Ol0003o008000?o0000300000h000?o0?l00P001?l00002o`/000?o00002P000ol0000<0003
o`0000X000?o000050000ol0000=0003o`0001D000?o00005@000ol0000=0003o`0001@000?o0000
2P000ol0000<0003o`0000X000?o00002@02o`<000Ko003o0?l?00003`02o`030?l000?o3@000ol0
000:0003o`0000`000?o00002P000ol0000B00;o4@000ol0000D0003o`0001@000?o00003`02oa@0
00?o00002P000ol0000<0003o`0000X000?o00002`03o`030?l000;o400000l01Ol@0003o`0000/0
00?o00002`000ol0000:0003o`00014000?o00004P000ol0000C0003o`0001<000?o00004P000ol0
000A0003o`0000X000?o00002`000ol0000;0003o`0000h01Ol@00004002oa8000?o000030000ol0
000:0003o`0000T000?o00004@000ol0000D0003o`00018000?o00004P000ol0000D0003o`000140
00?o00002@000ol0000:0003o`0000`000?o00004002oa40000@00Go3P000ol0000>0003o`0000X0
00?o000020000ol0000@0003o`0001H000?o00004@000ol0000A0003o`0001H000?o000040000ol0
00080003o`0000X000?o00003P000ol0000<00Go4@00010000?o0?l00P03o`/000?o00003`000ol0
00090003o`0000P000?o00003P02oaX000?o000040000ol0000@0003o`0001P00_l@0003o`0000P0
00?o00002@000ol0000?0003o`0000T00ol20003o`3o0140000@0003o`3o00D00ol80003o`000100
00?o000020000ol000070003o`0000h000?o00006`000ol0000?0003o`0000l000?o00006`000ol0
000>0003o`0000L000?o000020000ol0000@0003o`0000H00ol50003o`3o0140000@0004o`00o`L0
1?l40003o`00014000?o00001`000ol000070003o`0000d000?o00007@000ol0000>0003o`0000h0
00?o00007@000ol0000=0003o`0000L000?o00001`000ol0000A0003o`0000801?l70004o`00oa40
000@0004o`00o`/00ol00`3o000C0003o`0000H000?o00001`000ol0000<0003o`0001l000?o0000
3@000ol0000=0003o`0001l000?o000030000ol000070003o`0000H000?o00004P000ol0o`02o`/0
00Co003o4@00010000Go0000o`0=00?o4`000ol000070003o`0000D000?o00002`02ob<000?o0000
30000ol0000<0003o`0002400_l=0003o`0000D000?o00001`000ol0000A00?o3@001Ol0003o0140
000@0003o`00008000?o00002P000ol00002oa8000?o00001P000ol000050003o`0000X000?o0000
90000ol0000;0003o`0000/000?o000090000ol0000:0003o`0000D000?o00001P000ol0000@00;o
0P000ol0000:0003o`00008000?o00003`00010000?o00000P000ol000090003o`0000<00ol@0003
o`0000D000?o00001@000ol0000800;o:0000ol0000:0003o`0000X000?o00009P02o`X000?o0000
1@000ol000050003o`0000h00ol50003o`0000T000?o00000P000ol0000?000040000ol000030003
o`0000P000?o00001P02o`l000?o000010000ol000040003o`0000P000?o0000:@000ol000090003
o`0000T000?o0000:@000ol000080003o`0000@000?o000010000ol0000=00;o20000ol000080003
o`0000<000?o00003`00010000?o00000`000ol000080003o`0000P00ol=0003o`0000<000?o0000
0`000ol000080003o`0002/000?o000020000ol000080003o`0002/000?o000020000ol000030003
o`0000<000?o00002`03o`X000?o000020000ol000030003o`0000l0000?0003o`0000@000?o0000
1`000ol0000<0003o`0000X000?o00000`000ol000030003o`0000L000?o0000;@000ol000070003
o`0000L000?o0000;@000ol000070003o`0000<000?o00000`000ol0000:0003o`0000`000?o0000
1`000ol000040003o`0000h0000?0003o`0000D000?o00001P000ol0000=00?o2P000ol000020003
o`00008000?o00001P02oc4000?o00001P000ol000060003o`0002l00_l80003o`00008000?o0000
0P000ol0000800?o3`000ol000060003o`0000D000?o00003P0000l000?o00001@000ol000050003
o`0001400_l80003o`00008000?o00000P000ol000050003o`00038000?o00001@000ol000050003
o`00038000?o00001@000ol000020003o`00008000?o00001P02oa<000?o00001@000ol000050003
o`0000h0000>00;o20000ol000030003o`0001@00_l70003o`00008000Go0000o`0500;o=P000ol0
00040003o`0000@000?o0000=002o`D000Go0000o`040003o`0000D00_lF0003o`0000<000?o0000
1P02o`l0000>0004o`3oo`H000?o00000`000ol0000F00?o10000ol000020004o`00o`D000?o0000
=`000ol000030003o`0000<000?o0000=`000ol000030004o`00o`@000?o00000P03oaP000?o0000
0`000ol0000400;o00<0o`003P0000d000?o00000P000ol000030003o`00008000?o00006P000ol0
000200;o0P001?l00?l300;o>`000ol000020003o`00008000?o0000>@02o`<000Co003o0P02o`@0
00?o00006P000ol000020003o`0000<000?o00000P000ol0000<000030000ol0000400;o0`001Ol0
003o01h00_l40005o`3o0?l00`000ol0000l0005o`000?l00`000ol0000l0009o`000?l0o`3o00@0
0_lN0005o`000?l00`02o`H000?o00002`0000/000?o00001`02o`050?l00?l08@03o`030?l000;o
0P02od0000Co003o0P000ol0000n00;o0P02o`030?l000?o8@001Ol00?l000;o2@000ol0000:0000
2@02o``00_l00`3o000T00Oo@`001Ol0o`3o04<01olU0004o`3oo``00_l:000020000ol0000=00?o
9`03odH00om600?o9`03o`l000?o00001`0000L0ool<o`P000090003o`0000/00olW0005o`3o0?l0
A@03odD000Go0?l0o`0W00?o3@000ol0000800002P000ol000090005o`3o0?l09002o`050?ooo`00
0_m20005o`3o0?l0@P02o`050?ooo`000_lT0005o`3o0?l02`000ol0000900002`000ol0000600;o
0P001?l00?lP00?o0`03o`<00_lo0004o`00o`8000?o0000?@02o`<00ol300?o80001?l00?l200;o
20000ol0000:000030000ol000040003o`00008000Go0000o`0N0003o`0000800_l00`3oo`050003
o`0003/000Go0000o`030003o`0003/000?o00000`02o`030?oo00@000?o000070001Ol0003o00@0
00?o000010000ol0000;00003@001?l00002o`D000?o00000P000ol0000I00;o10001ol0003o0?l0
1@02ocX000?o00000P000ol000020003o`0003P00_l50003o`3o00<000?o00000P02oa/000?o0000
0P000ol0000300;o0`000ol0000<00003P03o`L000?o00000P000ol0000F00?o1P001Ol0003o0080
00?o000010000ol0000f0003o`0000<000?o00000`000ol0000f0003o`0000@000Co003o0`000ol0
000400?o60000ol000020003o`0000D00ol?00003P000ol000070003o`0000<000?o00004`02o`P0
00?o00000P001?l00?l700;o=@000ol000040003o`0000@000?o0000<`02o`L000Co003o10000ol0
000600;o5@000ol000030003o`0000L000?o00003@0000l000?o00001@000ol000050003o`000140
00?o000020000ol000020005o`000?l020000ol0000a0003o`0000D000?o00001@000ol0000a0003
o`0000H000Go0000o`040003o`0000P000?o00004@000ol000050003o`0000D000?o00003P0000l0
00?o00001@000ol000050003o`0000h00ol:0003o`00008000?o00000P000ol000070003o`0002l0
00?o00001P000ol000060003o`0002l000?o00001`000ol000020003o`00008000?o00002003oa00
00?o00001@000ol000050003o`0000h0000?0003o`0000D000?o00001P000ol0000;00;o3@000ol0
00020003o`0000<000?o00001`000ol0000]0003o`0000L000?o00001`000ol0000]0003o`0000L0
00?o00000`000ol000020003o`0000/00_l=0003o`0000H000?o00001@000ol0000>000040000ol0
00030003o`0000L000?o00002003o`h000?o00000`000ol000030003o`0000P00_l/0003o`0000P0
00?o000020000ol0000Z00;o2P000ol000030003o`0000<000?o00003003o`X000?o00001`000ol0
00030003o`0000l0000@0003o`0000<000?o000020000ol0000500;o40000ol000040003o`0000<0
00?o00002P000ol0000X0003o`0000T000?o00002@000ol0000X0003o`0000X000?o00000`000ol0
00040003o`0000h00_l70003o`0000P000?o00000`000ol0000?000040000ol000020003o`0000T0
00?o00000P03oa4000?o00001@000ol000040003o`0000X00_lW0003o`0000X000?o00002P000ol0
000U00;o30000ol000040003o`0000D000?o00003`03o`@000?o00002@000ol000020003o`0000l0
000@0003o`00008000?o00002@001Ol0003o01<000?o00001P000ol000050003o`0000/000?o0000
8`000ol0000;0003o`0000/000?o00008`000ol0000;0003o`0000D000?o00001P000ol0000A0005
o`000?l02`000ol000020003o`0000l0000@0005o`000?l03004oa@000?o00001P000ol000050003
o`0000`000?o00008@000ol0000<0003o`0000`000?o00008@000ol0000<0003o`0000D000?o0000
1P000ol0000B00Co30001Ol0003o0140000@0004o`00o`X00ol00`3o000D0003o`0000L000?o0000
1P000ol0000<0003o`0001l000?o00003@000ol0000=0003o`0001l000?o000030000ol000060003
o`0000L000?o00004`000ol0o`02o`X000Co003o4@00010000Co003o1`03o`D000?o00004@000ol0
00070003o`0000L000?o00003@02oah000?o00003P000ol0000>0003o`0001`00_l?0003o`0000L0
00?o00001`000ol0000A0003o`0000<00ol70004o`00oa40000@0003o`3o00@01?l80003o`000100
00?o000020000ol000070003o`0000l000?o00006P000ol0000?0003o`0000l000?o00006P000ol0
000?0003o`0000L000?o000020000ol0000@0003o`0000H01?l40003o`3o0140000@0004o`3o00?o
30000ol0000?0003o`0000T000?o000020000ol0000?0003o`0001P000?o000040000ol0000@0003
o`0001P000?o00003`000ol000080003o`0000T000?o00003`000ol0000:00?o00@0o`3o4@000100
1?l?0003o`0000h000?o00002P000ol000080003o`00010000?o00005P000ol0000A0003o`000140
00?o00005P000ol0000@0003o`0000P000?o00002P000ol0000>0003o`0000d01?lA00004003oa40
00?o000030000ol0000;0003o`0000P000?o00004@02oaD000?o00004P000ol0000B0003o`0001<0
0_lC0003o`0000P000?o00002`000ol0000<0003o`0000l00olA00004002o`030?oo00l000?o0000
2`000ol0000;0003o`0000X000?o00004P000ol0000A0003o`0001<000?o00004`000ol0000A0003
o`00018000?o00002P000ol0000;0003o`0000/000?o00003@02o`030?oo0140000?00;o00@0o`00
0ol<0003o`0000/000?o00002`000ol0000:0003o`0001<000?o00003`000ol0000D0003o`0001@0
00?o00003`000ol0000C0003o`0000X000?o00002`000ol0000;0003o`0000X00ol20004o`3ooa00
000>0005o`3o0?l01@000ol000090003o`0000T00_l>0003o`0000X000?o000050000ol0000=0003
o`0001D000?o00005@000ol0000=0003o`0001@000?o00002P000ol0000<00;o2`000ol000090003
o`0000<000Go0?l0o`0?00003P000ol0o`020003o`0000<00_l90003o`0000P000?o00003P000ol0
000;0003o`0001@00_l<0003o`0001H000?o00005P000ol0000:00;o5P000ol0000;0003o`0000h0
00?o000020000ol0000700;o1@001_l00?l0o`l0000=0004o`00o`<000?o000010000ol000060003
o`0000L000?o00003P000ol0000<0003o`0001H000?o000020000ol0000G0003o`0001L000?o0000
20000ol0000F0003o`0000`000?o00003P000ol000070003o`0000H000?o000010001Ol0003o0080
00?o0000300000`000Go0000o`030003o`0000D00_l60003o`0000H000?o00003`000ol0000<0003
o`0001L000?o00001P000ol0000H0003o`0001P000?o00001P000ol0000G0003o`0000`000?o0000
3`000ol000060003o`0000@00_l70005o`000?l00`000ol0000;00002`000ol000020005o`000?l0
2@000ol000030003o`0000D000?o000040000ol0000<0003o`0001P000?o000010000ol0000I0003
o`0001T000?o000010000ol0000H0003o`0000`000?o000040000ol000050003o`0000<000?o0000
1`001Ol0003o00@000?o00002P0000X000?o00000`000ol000020003o`0000L000?o00000P000ol0
00040003o`00014000?o00003@000ol0000H0003o`00008000?o00006P000ol0000J0003o`000080
00?o000060000ol0000=0003o`00014000?o000010000ol000020003o`0000L000?o00000P000ol0
00030003o`0000T0000900;o1@000ol000020003o`0000P000Go0000o`050003o`00014000?o0000
3P000ol0000H0005o`000?l07@000ol0000K0005o`000?l06P000ol0000>0003o`00014000?o0000
0`001Ol0003o00X000?o00000P000ol0000300;o2P0000L00_l20005o`000?l01@000ol000090004
o`00o`<00_lD0003o`0000h000?o00006@000ol0o`0N0003o`0001`000?o0?l06`000ol0000>0003
o`0001800_l30004o`00o`/000?o00000`001Ol0003o00800_l800001P03o`<000Co003o1@000ol0
000:0003o`3o008000?o00004`000ol0000?0003o`0001X00_lN0003o`0001`00_lL0003o`0000l0
00?o00004`001_l00?l0o``000?o00000`001?l00?l400;o1`0000L000?o0?l00ol00`3o00050003
o`0000/00_l00`3o000E0003o`0000l000?o00006@001?l00?lM0003o`0001/000Co003o6`000ol0
000?0003o`0001@000Co0?oo3@000ol000040003o`3o00Go200000P000Co00005ol00`3oo`0G0003
o`00010000?o00005`000ol000020003o`0001X000?o00006P000ol000020003o`0001L000?o0000
40000ol0000E00;o00<0ool05Ol30003o`0000L0000800Oo1P000ol0000;00Oo4`000ol0000@0003
o`0001H000?o000010000ol0000I0003o`0001T000?o000010000ol0000F0003o`00010000?o0000
4@07o`d000?o00001007o`T000080004o`0000;o00<0o`0010000ol0000:0004o`3oo`@01Ol=0003
o`00014000?o00005@000ol000060003o`0001P000?o000060000ol000060003o`0001D000?o0000
4@000ol0000;00Go1002o`030?l000/000?o00000`001?l0ool30003o`0000L000080008o`00o`3o
0?l50003o`0000P00_l20003o`3o00P00_l;0003o`00014000?o000050000ol000070003o`0001P0
00?o000060000ol000070003o`0001@000?o00004@000ol0000900;o20000ol0o`0200;o2P000ol0
00030005o`3o0?l00P000ol0000700002003o`8000Co003o10000ol0000600;o10000ol0o`0:00Go
1@000ol0000C0003o`00018000?o00002@000ol0000G0003o`0001L000?o00002@000ol0000B0003
o`0001<000?o00001004o`X000?o0?l01002o`P000?o00000P001?l00?l200?o2@0000P00ol00`3o
00020003o`00008000?o00001@000ol000030005o`000?l03P02o`<000?o00004`000ol0000A0003
o`0000/000?o00005P000ol0000F0003o`0000/000?o00004@000ol0000C0004o`0000?o3@001Ol0
003o00D000?o00001@000ol000020006o`000?l00ol900002`03o`8000?o00000P000ol000040003
o`0000@000?o00000P000ol0000=00?o5P000ol0000@0003o`0000d000?o00005@000ol0000E0003
o`0000d000?o000040000ol0000D00?o3`000ol000020003o`0000@000?o000010000ol000020004
o`0000;o300000h000Co003o0P000ol000040003o`0000@000?o00000`000ol0000?00;o5@000ol0
000?0003o`0000l000?o000050000ol0000D0003o`0000l000?o00003`000ol0000C00;o4@000ol0
00030003o`0000@000?o000010001?l00?l200;o3P0000l000?o0?l00P000ol0000200;o1`000ol0
00030003o`0000h000Co003o50000ol0000>0003o`00010000?o000050000ol0000D0003o`000100
00?o00003P000ol0000B0004o`00oa0000?o00000`000ol0000500;o10001_l00?l0oa00000@0005
o`3o0?l00P02o`T000?o00000`000ol0000>0004o`0000Co40000ol0000=0003o`00018000?o0000
4`000ol0000C0003o`00018000?o00003@000ol0000>00Co0`000ol0000>0003o`0000<000?o0000
1`02o`8000Go0?l0o`0A000040001?l0o`03o`/000?o000010000ol0000<0003o`0000H000?o0000
3@000ol0000<0003o`0001@000?o00004P000ol0000B0003o`0001@000?o000030000ol0000=0003
o`0000H000?o000030000ol000040003o`0000T00ol0103o0?lA00004@04o`d000?o00001@000ol0
000;0003o`0000L00_l=0003o`0000/000?o00005P000ol0000A0003o`00014000?o00005P000ol0
000;0003o`0000/00_l90003o`0000/000?o00001@000ol0000;00Co4P0001801_l90003o`0000H0
00?o00002P000ol0000:0003o`0000/000?o00002@000ol0000H0003o`00010000?o000040000ol0
000H0003o`0000T000?o00002`000ol0000:0003o`0000X000?o00001P000ol0000700Ko4`0001<0
00?o00000P04o`D000?o00001P000ol0000:0003o`0000/00_l;0003o`0000P000?o00006@000ol0
000@0003o`00010000?o00006@000ol000080003o`0000T00_l=0003o`0000X000?o00001P000ol0
000300Co10000ol0000B00004`02o`L00_l20003o`0000L000?o00002@000ol0000>00;o2@000ol0
00070003o`0001/000?o00003`000ol0000?0003o`0001/000?o00001`000ol000080003o`0000h0
00?o00002@000ol000070003o`0000;o1`02oa@0000C0003o`3o00P00ol:0003o`0000P000?o0000
40000ol000060003o`0000H000?o00007@000ol0000>0003o`0000h000?o00007@000ol000060003
o`0000H00_lA0003o`0000P000?o00002003o`P000?o0?l0500001<000Co003o2002o`X000?o0000
1`000ol0000B0003o`0000D000?o00001@000ol0000O0003o`0000d000?o00003@000ol0000O0003
o`0000D000?o00001@000ol0000B0003o`0000L000?o00002002o`P000Co003o500001<000Co003o
1`001?l00?l90003o`0000L000?o00004`000ol000040003o`0000@000?o00008@000ol0000<0003
o`0000`000?o00008@000ol000040003o`0000@000?o00004`000ol000070003o`0000L000Co003o
1`001?l00?lD00004`001Ol0003o00H000Go0000o`080003o`0000H000?o00005@000ol000030003
o`0000<000?o00008P000ol0000<0003o`0000`000?o00008P000ol000030003o`0000<000?o0000
5@000ol000060003o`0000H000Go0000o`060005o`000?l0500001<000?o00000P000ol000020003
o`0000<00_l60003o`0000H000?o00005P02o`<000?o00000P000ol0000T0003o`0000/000?o0000
2`000ol0000T0003o`00008000Co00000_lH0003o`0000H000?o00001002o`D000?o00000P000ol0
00020003o`000180000C00;o0`001Ol0003o00P000?o000010000ol000040003o`0001T000Co003o
0`000ol0000V0003o`0000X000?o00002P000ol0000V0005o`000?l00P000ol0000I0003o`0000@0
00?o000010000ol000060005o`000?l00`02oa@0000C0003o`3o008000Co003o2@000ol000040003
o`0000@000?o00006P000ol0o`020003o`0002L000?o00002P000ol0000:0003o`0002L000Ko003o
0?lL0003o`0000@000?o000010000ol000070004o`00o`8000?o0?l05000018000Co00000ol00`3o
000:0003o`0000<000?o00000`000ol0000K0005o`3o0?l0:`000ol000090003o`0000T000?o0000
:@001Ol0o`3o01d000?o00000`000ol000030003o`0000T000?o0?l00_l30003o`000140000B0003
o`0000<00_l=0003o`00008000?o00000`000ol0000L00?o;@000ol000080003o`0000P000?o0000
:`03oah000?o00000`000ol000020003o`0000/00_l50003o`000140000A0003o`3o00co1`000ol0
00020004o`0000;o500Job8000?o00001`000ol000070003o`0002006_lD00;o0`000ol000020003
o`0000D03Ol00`3o000A00004003o`@00ol600?o1@001Ol0003o008000?o00003008o`/00_l00`3o
000:00Oo70000ol000060003o`0000H000?o00006P07o`/000Co0?oo2`08o`h000Co003o0`000ol0
000300?o1P03o`@00olA00004P002Ol0003o0?l0o`0800;o0`001Ol0003o008000?o00002004oa80
00?o0?l00P000ol0000?00Go5`000ol000060003o`0000H000?o00005@05oa4000Ko003o0?lB00Co
2P001?l00?l30004o`0000;o20001Ol0o`3o00<000?o00004@0001<000?o0?l00P001?l00?l900?o
00L0o`00o`3o00H01OlE0004o`00o`8000?o00005005oa<000?o00001@000ol000050003o`000140
1OlF0004o`00o`8000?o00004`05o`H000?o0?l00P000ol0o`02o`T000Co003o0P000ol0o`0D0000
50001Ol0003o008000?o00002P02o`8000?o0?l01002oaT000Go0000o`030003o`0001P01?l@0003
o`0000@000?o000010000ol0000?00?o6P001Ol0003o00<000?o00005`03o`<000?o0?l00P02o``0
00Co003o0`000ol0000C000050001?l00?l40003o`0000X00ol0103o0003oaX000?o00000P000ol0
00020003o`0001/00ol=0003o`0000@000?o000010000ol0000<00?o70000ol000020003o`000080
00?o00006@03o`030?l000?o30000ol000020004o`00oaD0000E0003o`3o00@05?lL0003o`0000<0
00?o00000`000ol0000M00?o2`000ol000030003o`0000<000?o00002P03oah000?o00000`000ol0
00030003o`0001/04ol40003o`3o01H0000E0003o`3o00800ol>00Ko6P000ol000040003o`0000@0
00?o00007`03o`T000?o00000P000ol000020003o`0000P00olP0003o`0000@000?o000010000ol0
000I00Ko3@04o`040?l0oaH0000E00Go4004o`<00olF0003o`0000D000?o00001@000ol0000Q00;o
1`000ol000020003o`00008000?o00001@03ob8000?o00001@000ol000050003o`0001D00ol200Co
4@04oaH0000E00;o4P02o`040?l0o`D00olB0003o`0000H000?o00001@000ol0000S0003o`0000D0
00Go0000o`030003o`0000D000?o00008`000ol000050003o`0000H000?o00004@03o`@000Co0?l0
0_lC0003o`0001@0000X0005o`3o0?l00P000ol000050003o`0000h000?o00001`000ol000060003
o`0002<00ol50004o`00o`8000?o00001002obD000?o00001P000ol000070003o`0000h00_l60008
o`00o`3o0?lY00009`001_l00?l0o`8000?o00001P000ol0000<0003o`0000P000?o00001`000ol0
000U00;o0`001?l00?l20004o`0000?o9P000ol000070003o`0000P000?o000030000ol000060006
o`00o`3o0P000ol0000V00009P001ol0003o0?l00`000ol0000600;o2`000ol000090003o`0000L0
00?o00009`02o`8000Go0?l0o`0200;o:@000ol000070003o`0000T000?o00002@02o`P000Oo0000
o`3o00<000?o00009@0002D000?o00000P001?l00?l20003o`0000P000?o00001`000ol000090003
o`0000T000?o0000:0002Ol0o`3o0?l0o`0Z0003o`0000T000?o00002@000ol000070003o`0000P0
00Co003o0P000ol000020003o`0002@0000T0003o`00008000Go0000o`030003o`0000P000?o0000
1@000ol0000:0003o`0000X000?o0000:007obX000?o00002P000ol0000:0003o`0000D000?o0000
20001Ol0003o00<000?o00000P000ol0000S00008`000ol000020003o`00008000?o00000P000ol0
00080003o`0000<000?o00002`000ol0000:0003o`0002<04OlU0003o`0000X000?o00002`000ol0
00030003o`0000P000?o00000P000ol000020003o`00008000?o00008P00028000?o00000`000ol0
00020003o`0000<000?o000020001Ol0003o00h000?o00002`000ol0000J00So1@02o`030?l000;o
1@08oa`000?o00002`000ol0000<0005o`000?l02P000ol000030003o`00008000?o00000`000ol0
000Q00008@000ol000030003o`0000<000?o00000`000ol000090003o`3o00l000?o000030000ol0
000D00Go30000ol00003o`8000?o00002P05oaH000?o000030000ol0000=0003o`3o00/000?o0000
0`000ol000030003o`0000<000?o0000800001l00_l00`3o00030003o`0000<000?o00000`000ol0
000:0003o`0000h000?o000030000ol0000@00Co4@002Ol0o`3o0?l0o`0A00Co4P000ol0000<0003
o`0000h000?o00002P000ol000030003o`0000<000?o00000P001?l0oolP00007P000ol000020005
o`000?l01@000ol000030003o`0000T000?o0?l03`000ol0000=0003o`0000/01?lC00;o0P001Ol0
o`3o00800_lC00Co3@000ol0000=0003o`0000d000?o0?l02`000ol000030003o`0000<000Go0000
o`040003o`0001d0000M0003o`0000<000Co003o1P000ol000040003o`0000L000Go0000o`0>0003
o`0000d000?o00002@02oaD00_l30004o`00o`8000Co00000_lE00;o2`000ol0000=0003o`0000`0
00Go0000o`090003o`0000@000?o000010001?l00?l50003o`0001`0000L00Oo00@0o`3o1@000ol0
00050003o`0000H000?o00000`000ol0000:0003o`0000h000?o00001@04oaD00_l50004o`00o`80
00?o00000`02oaD01?l70003o`0000h000?o00002P000ol000030003o`0000H000?o00001@000ol0
00030004o`3o00Oo7@0001d000?o00000`03o`H000?o00001@000ol000050003o`0000D000?o0000
2@000ol0000?0003o`0000800_lH0003o`0000D000Co003o0P000ol000050003o`0001H00_l40003
o`0000l000?o00002@000ol000050003o`0000D000?o00001@000ol0000400?o1@000ol0000L0000
7P001?l0000=o`H000?o00000`000ol000060003o`0000T000?o00003`000ol00002oaT000?o0000
1@001Ol0003o00<000?o00001@000ol0000G00;o0P000ol0000?0003o`0000T000?o00001P000ol0
00030003o`0000D03?l30003o`0001d0000O00?o0P02o`H000?o00000_l40003o`00008000?o0000
20000ol000080003o`0001000_lJ0003o`0000D000?o00000P000ol000020003o`0000D000?o0000
6002oa8000?o000020000ol000080003o`00008000?o00000P03o`030?l000D00_l200?o800001l0
00Co00000_l00`3o00040003o`00008000Go0000o`030003o`0000X000?o00001P000ol0000?00?o
6@02o`P000?o00000P000ol000020003o`0000H00_lI00?o4@000ol000060003o`0000X000Go0000
o`030003o`00008000?o00000`001?l0ool30003o`0001h0000P0007o`3o0?l0o`040003o`0000@0
00Co003o0P000ol0000<0003o`0000D000?o00003@02o`<000?o00005@000ol000070003o`0000<0
00?o00000`000ol000070003o`0001D000Co00000_l?0003o`0000D000?o000030001?l00?l20003
o`0000@000?o00000P001ol0o`3o0?l08@0002000_l20004o`00o`<000?o00001@001Ol0o`3o0100
00?o000010000ol0000;00;o1@000ol0000D0003o`0000P000?o00000`000ol000030003o`0000P0
00?o000050000ol0000300;o3@000ol000040003o`0000h000Go0?l0o`070005o`000?l00P000ol0
0002ob40000P00Ko00D0o`00o`0900?o4@000ol000040003o`0000T00_l80003o`00018000?o0000
2@000ol000030003o`0000<000?o00002@000ol0000B0003o`0000H00_l;0003o`0000@000?o0000
3`03o`T000Go003o0006ob40000V0005o`3o0?l00`0?o``000?o00000`000ol0000700;o2P000ol0
000A0003o`0000T000?o000010000ol000040003o`0000T000?o00004@000ol0000800;o2@000ol0
00030003o`0000X03ol30005o`3o0?l09`0002L00_l00`3o0002o`H00ol600?o2@000ol000020003
o`0000H00_l=0003o`0000l000?o00002P000ol000040003o`0000@000?o00002P000ol0000?0003
o`0000/00_l80003o`00008000?o00002002o`H00ol600Co00<0ool0:00002L01Ol70005o`3o0?l0
2003o`H000?o00000P000ol0000400;o3`000ol0000>0003o`0000X000?o00001@000ol000050003
o`0000X000?o00003P000ol0000=00;o1P000ol000020003o`0000@01?l70005o`3o0?l02004obP0
000X00Co1P001?l00?l20003o`0000P000?o000010001?l00?l500;o4@000ol0000<00;o30000ol0
00060003o`0000H000?o00002P02o`h000?o00003`02o`D000Co003o1P000ol000080004o`00o`80
00?o00001004obT0000X00;o0P02o`<000Go0000o`030003o`0000P00_l40004o`00o`@000?o0000
4@000ol0000;0003o`0000`000?o00001P000ol000060003o`0000`000?o00002`000ol0000A0003
o`00008000Co003o1002o`X000Go0000o`030004o`0000;o0P02obT0000Y00;o0`000ol0o`040005
o`000?l03002o`8000Co003o10000ol0000A0003o`0000/000?o000030000ol000060003o`0000H0
00?o000030000ol0000;0003o`00014000?o00000P001?l00?l200;o30001Ol0003o00@000?o0?l0
0`02obX0000Y0003o`3o00<000?o00000`000ol000020003o`0000/000?o00000_l300;o5@000ol0
00090003o`0000`000?o00001`000ol000070003o`0000`000?o00002@000ol0000C00;o0`02o`80
00?o00002`000ol000020003o`0000<000Oo0000o`3o02X0000Y0008o`00o`3o0?l40003o`000080
00?o000030001Ol0ool000;o5`000ol000080003o`0000d000?o00001`000ol000070003o`0000d0
00?o000020000ol0000E00;o00D0ool0o`0>0003o`00008000?o00000P001Ol0o`3o008000?o0000
:00002T01Ol20005o`000?l01P000ol00009o`<01?lJ0003o`0000H000?o00003@000ol000080003
o`0000P000?o00003@000ol000060003o`0001P01?l300Wo0P000ol000040005o`000?l00P02o`03
0?oo02X0000Y00Ko0P001?l00?l400Go2@06o`030?oo00So40000ol000050003o`0000h000?o0000
20000ol000080003o`0000h000?o00001@000ol0000>00[o00<0ool01?l900Go10001?l00?l200Ko
:P0002P00_l00`3oo`020005o`3o0?l00`02o`8000?o00003004o`X01Ol;0003o`0000@000?o0000
3`000ol000080003o`0000P000?o00003`000ol000040003o`0000T01Ol:00Go3@000ol00003o`80
00Go0?l0o`0200;o00<0ool0:@0002X000Co0?oo0P000ol0o`04o`@000?o00001`0:o`h00ol80003
o`0000<000?o00003`000ol000090003o`0000T000?o00003`000ol000030003o`0000H00ol>00Go
00<0ool00_l90003o`0000<01?l0103o0002o`030?l002X0000Z00[o1`000ol000060003o`000080
00?o00000_l00`3oo`0?00;o1P000ol000020003o`00010000?o00002@000ol000090003o`000100
00?o00000P000ol0000400;o3`02o`030?oo008000?o00000P000ol000060003o`0000D02_l[0000
:`000ol0000400Go10000ol0000400;o10001ol0003o0?l00P02o`l00ol40005o`000?l04@000ol0
000:0003o`0000X000?o00003`001Ol0003o00@00ol?00;o0P000ol0o`030003o`0000800ol50003
o`0000801Ol60003o`0002X0000d0003o`0000;o0P001?l00003o`D000?o00000P001?l00?l30003
o`0000l00_l20004o`00oa8000?o00002P000ol0000:0003o`00010000Co003o0P02oa4000Go0000
o`020003o`00008000?o00001003o`8000?o00000_l20003o`0003<0000e0004o`0000?o00<0ool0
1`000ol000030004o`00o`@00_lA00?o00<0o`004P000ol0000:0003o`0000X000?o00004@000ol0
o`02oa400_l40004o`00o`D000?o00001P001Ol0o`3o00<000?o0000=00003H000?o00000P02o`P0
00?o000010001?l00?l60003o`0001000_lC0003o`0000/000?o00002`000ol0000A00;o4P000ol0
00040004o`00o`H000?o00001P03o`<000?o0000=@0003H02Ol50003o`0000D000Co003o1P000ol0
000=01?o10000ol0000<0003o`0000`000?o00000`0Bo`l000?o000010001?l00?l70003o`0000@0
2?lg0000=P001Ol00?l000;o0P001Ol0003o00P000Go0000o`060003o`0000X00_l30003o`3o00d0
1Ol>0003o`0000`01_l<0003o`3o00<00_l<0003o`0000@000Go0000o`080004o`0000;o00D0ool0
o`020003o`0003D0000f0003o`3o00800_l30003o`3o00T000?o00000P000ol000040003o`0000@0
1Ol400;o0P000ol0000>00;o3@000ol0000;00;o40000ol00002o`@01Ol60003o`0000@000?o0000
0P000ol000070003o`3o00<00_l20003o`3o03L0000f00;o0P001?l00?l30003o`0000P000?o0000
0P000ol000050004o`0000;o20001?l00?l20003o`0000d000?o0?l00_l:0003o`0000P00ol00`3o
000>0004o`00o`8000?o00001P02o`<000?o00001@000ol000020003o`0000P000Go0000o`020003
o`0000;o=`0003H01Ol20004o`00o`/000?o00000P000ol0000600?o2P001?l00?l30003o`0000/0
00?o00000`02o`P000?o00001P02o`D000?o00002`001Ol0003o008000?o00002003o`P000?o0000
0P000ol000090004o`00o`801Olg0000>P001?l00?l20003o`0000T000?o00000P000ol000060003
o`0000T000Go0000o`040003o`0000X000?o00001@000ol000050003o`0000D000?o00001@000ol0
000:0003o`00008000Go0000o`0;0003o`0000H000?o00000P000ol000090004o`00o`8000?o0000
>@0003/000Go0?l0o`0<0003o`0000<000?o00000`02o`030?l000T000Go0000o`040003o`0000X0
00?o00001P02o`D000?o00000`02o`P000?o00002P000ol000020005o`000?l02P001?l0ool50003
o`0000@000?o00002@001Ol0o`3o03`0000l00?o3@000ol000030003o`00008000Go0000o`090003
o`00008000?o00000`000ol000080003o`0000T000?o00000P000ol000020003o`0000T000?o0000
20000ol000030003o`00008000?o00001`001Ol0003o00@000?o000010000ol0000:00?o?@0003d0
00?o00002`04o`<000Go0000o`050003o`0000D000?o00000`000ol000040003o`0000L000?o0000
2P001Ol0003o00<000?o00002P000ol000070003o`0000@000?o00000`000ol000050003o`0000<0
00Go0000o`0300Co3@000ol0000l0000B`001?l00002o`050?l00?l01P000ol000040003o`0000@0
00?o000010000ol000070003o`0000/000Co003o0P000ol0000;0003o`0000L000?o000010000ol0
00040003o`0000@000?o000010001Ol00?l000;o0`000ol0001:0000B`000ol0000300;o00<0o`00
1`000ol000020003o`0000D000?o00001@000ol000050003o`0000d01Ol?0003o`0000D000?o0000
1@000ol000050003o`00008000?o00001P001?l0ool50003o`0004X0001:0003o`0000D00_l90003
o`00008000?o00001@000ol000060003o`0000@000?o00003P04o`l000?o000010000ol000060003
o`0000D000?o00000P000ol0000700;o1`000ol000190000BP001?l0000;o`@000Go0000o`080003
o`0000L000?o00000`000ol0000800Wo00<0ool01?l90003o`0000<000?o00001`000ol000060005
o`000?l0100<o`8000?o0000B@0004X01?l300?o1@001Ol0003o00<000?o00001P000ol000070003
o`0000<000?o00001@03o`H00ol700;o1`000ol000030003o`0000L000?o00001P001Ol0003o00<0
00?o00000`03o`@00om;0000B@02o`D000Go0?l0o`050007o`000?l0o`090003o`0000P000Go0000
o`0600;o20001Ol0o`3o00P00ol50005o`000?l02P000ol000070003o`3o00<000?o00000`001Ol0
o`3o00D00_m:0000B@05o`050?l00?l00P000ol000030006o`00o`3o0`0<o`D000Go0000o`0400;o
2@001?l00?l20003o`0000P000?o00000P001Ol0003o00D03?l30003o`3o008000?o00000`001?l0
0?l20003o`3o00CoBP0004h000Go0000o`020003o`0000@000?o0?l01Ol60003o`0000<01?l00`3o
00020005o`000?l02`001?l00?l20003o`0000T000Go0000o`030003o`3o00?o1@000ol0000400Ko
00<0o`001@001?l00?l30003o`0004d0001?0004o`00o`802ol:0003o`0000L000Go0?l0o`0200;o
2`001Ol0003o00<000?o00002@03o`060?l0o`3o2@000ol0000800_o0P001?l00?m@0000D002o`03
0?oo00T01Ol70003o`0000P00_l0103oool<0003o`00008000?o00000P000ol0000;00;o00<0ool0
2P000ol0000500Go2@02o`030?oo0540001@00?o3@000ol00002o`D000?o00002@03o`h000?o0000
0P000ol000020003o`0000`00ol;0003o`0000<00_l20003o`0000/00omA0000D@000ol0000=0004
o`0000?o0P001?l0000Eo`<000?o00000`000ol000030003o`0000805?l30004o`0000;o0`000ol0
000=0003o`000500001R0003o`0000<000Co0?l00_l70003o`0000/01?l50003o`0000<000?o0?l0
0_l<0003o`0000D01?l00`3oo`040003o`000640001S0003o`00008000Co0?oo1`02oa000_l50003
o`0000<00_l@00;o20000ol0o`040003o`000680001S0003o`0000Ko1P000ol0000B0003o`000080
00?o00000P000ol0000B0003o`0000@01ol00`3o001S0000I002o`800ol00`3oo`030003o`0001@0
00Go0000o`030003o`0001@000Co00000_l0103oool30003o`0006<0001T0008o`00o`3o0?l20003
o`3o01P000Co003o0P000ol0000F0003o`3o008000Go0?l0o`020003o`0006<0001T0003o`3o0080
00?o0?l00`000ol0000H0005o`3o0?l06P001ol0003o0?l00P000ol0o`1U0000I@02o`8000?o0?l0
0P000ol0000I0005o`3o0?l06`001_l00?l0o`800_mV0000I@07o`030?l001`00olM0003o`3o00Ko
IP0006/00olN0003o`0001`00om/0000K0000ol0000m0003o`0006/0003o01/0003o01/0003o01/0
003o01/0003o01/0003o01/00000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-0.993321, -0.993321, 0.0070699, 
  0.0070699}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Black and white 4-gon tessellation"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
poly = NGP[RegularPolygon[4, Pi/3]];
tess1 = PolygonInvGroup[poly, 1];
tess2 = PolygonInvGroup[poly, 2];
tess3 = PolygonInvGroup[poly, 3];
Length[tess3]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(49\)], "Output"],

Cell[CellGroupData[{

Cell["\<\
HDraw[{black, tess3 /. 
    Polygon -> PlainFilledPolygon, 
    white, tess2 /. 
    Polygon -> PlainFilledPolygon,
    black, tess1 /. 
    Polygon -> PlainFilledPolygon,
    white, poly /. 
    Polygon -> PlainFilledPolygon},
\tDrawUnitCircle -> False]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.503367 0.5 0.503367 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.02934 .36055 m
.0339 .36021 L
.03839 .35938 L
.04277 .35807 L
.04698 .35629 L
.05097 .35406 L
.05469 .3514 L
.0581 .34836 L
.06116 .34497 L
.06383 .34126 L
.06608 .33728 L
.06608 .33728 L
.07087 .34567 L
.07448 .35463 L
.07685 .36399 L
.07792 .37359 L
.07769 .38325 L
.07615 .39278 L
.07333 .40202 L
.06929 .4108 L
.0641 .41894 L
.05786 .42631 L
.05786 .42631 L
.05615 .42113 L
.05401 .41611 L
.05146 .41128 L
.04851 .40669 L
.04518 .40237 L
.0415 .39834 L
.03749 .39463 L
.03319 .39128 L
.02862 .3883 L
.02381 .38571 L
.02381 .38571 L
.02603 .38395 L
.02796 .38186 L
.02955 .37951 L
.03077 .37695 L
.03159 .37423 L
.03199 .37142 L
.03196 .36858 L
.03149 .36578 L
.03062 .36308 L
.02934 .36055 L
F
.02381 .61429 m
.02862 .6117 L
.03319 .60872 L
.03749 .60537 L
.0415 .60166 L
.04518 .59763 L
.04851 .59331 L
.05146 .58872 L
.05401 .58389 L
.05615 .57887 L
.05786 .57369 L
.05786 .57369 L
.0641 .58106 L
.06929 .5892 L
.07333 .59798 L
.07615 .60722 L
.07769 .61675 L
.07792 .62641 L
.07685 .63601 L
.07448 .64537 L
.07087 .65433 L
.06608 .66272 L
.06608 .66272 L
.06383 .65874 L
.06116 .65503 L
.0581 .65164 L
.05469 .6486 L
.05097 .64594 L
.04698 .64371 L
.04277 .64193 L
.03839 .64062 L
.0339 .63979 L
.02934 .63945 L
.02934 .63945 L
.03062 .63692 L
.03149 .63422 L
.03196 .63142 L
.03199 .62858 L
.03159 .62577 L
.03077 .62305 L
.02955 .62049 L
.02796 .61814 L
.02603 .61605 L
.02381 .61429 L
F
.07785 .26254 m
.08458 .265 L
.09143 .26712 L
.09838 .2689 L
.10541 .27032 L
.11249 .27138 L
.11963 .27209 L
.12679 .27244 L
.13396 .27242 L
.14112 .27205 L
.14825 .27132 L
.15533 .27022 L
.15533 .27022 L
.15117 .28012 L
.14598 .28952 L
.13984 .29833 L
.1328 .30644 L
.12494 .31376 L
.11635 .32021 L
.10713 .32571 L
.09739 .33022 L
.08722 .33367 L
.07674 .33604 L
.06608 .33728 L
.06608 .33728 L
.06805 .3326 L
.06945 .32773 L
.07024 .32271 L
.07042 .31764 L
.06999 .31259 L
.06895 .30762 L
.06732 .30282 L
.06511 .29824 L
.06237 .29397 L
.05914 .29006 L
.05914 .29006 L
.06262 .28897 L
.06591 .28738 L
.06892 .28531 L
.0716 .28282 L
.07387 .27996 L
.0757 .27679 L
.07703 .27339 L
.07784 .26983 L
.07812 .26619 L
.07785 .26254 L
F
.05914 .70994 m
.06237 .70603 L
.06511 .70176 L
.06732 .69718 L
.06895 .69238 L
.06999 .68741 L
.07042 .68236 L
.07024 .67729 L
.06945 .67227 L
.06805 .6674 L
.06608 .66272 L
.06608 .66272 L
.07674 .66396 L
.08722 .66633 L
.09739 .66978 L
.10713 .67429 L
.11635 .67979 L
.12494 .68624 L
.1328 .69356 L
.13984 .70167 L
.14598 .71048 L
.15117 .71988 L
.15533 .72978 L
.15533 .72978 L
.14825 .72868 L
.14112 .72795 L
.13396 .72758 L
.12679 .72756 L
.11963 .72791 L
.11249 .72862 L
.10541 .72968 L
.09838 .7311 L
.09143 .73288 L
.08458 .735 L
.07785 .73746 L
.07785 .73746 L
.07812 .73381 L
.07784 .73017 L
.07703 .72661 L
.0757 .72321 L
.07387 .72004 L
.0716 .71718 L
.06892 .71469 L
.06591 .71262 L
.06262 .71103 L
.05914 .70994 L
F
.23944 .5 m
.22938 .5057 L
.21922 .51124 L
.20898 .51661 L
.19866 .52181 L
.18825 .52685 L
.17776 .53171 L
.16719 .53641 L
.15654 .54093 L
.14583 .54528 L
.13505 .54945 L
.12419 .55345 L
.11328 .55727 L
.10231 .56091 L
.09127 .56438 L
.08019 .56766 L
.06905 .57077 L
.05786 .57369 L
.05786 .57369 L
.05964 .56532 L
.06031 .55679 L
.05984 .54824 L
.05825 .53983 L
.05556 .53171 L
.05182 .52401 L
.04711 .51687 L
.04149 .51042 L
.03506 .50476 L
.02795 .5 L
.02795 .5 L
.03506 .49524 L
.04149 .48958 L
.04711 .48313 L
.05182 .47599 L
.05556 .46829 L
.05825 .46017 L
.05984 .45176 L
.06031 .44321 L
.05964 .43468 L
.05786 .42631 L
.05786 .42631 L
.06905 .42923 L
.08019 .43234 L
.09127 .43562 L
.10231 .43909 L
.11328 .44273 L
.12419 .44655 L
.13505 .45055 L
.14583 .45472 L
.15654 .45907 L
.16719 .46359 L
.17776 .46829 L
.18825 .47315 L
.19866 .47819 L
.20898 .48339 L
.21922 .48876 L
.22938 .4943 L
.23944 .5 L
F
.11435 .19469 m
.11794 .19529 L
.12157 .1954 L
.12519 .19504 L
.12873 .19419 L
.13212 .19289 L
.13532 .19114 L
.13825 .18899 L
.14087 .18647 L
.14313 .18362 L
.145 .1805 L
.145 .1805 L
.14932 .18782 L
.15301 .19549 L
.15606 .20343 L
.15842 .2116 L
.1601 .21994 L
.16107 .22839 L
.16134 .23689 L
.16089 .24538 L
.15973 .25381 L
.15788 .26211 L
.15533 .27022 L
.15533 .27022 L
.15165 .26594 L
.14791 .26171 L
.14409 .25755 L
.14021 .25344 L
.13627 .2494 L
.13226 .24542 L
.12819 .2415 L
.12405 .23765 L
.11986 .23387 L
.11561 .23015 L
.1113 .2265 L
.10693 .22292 L
.1025 .21941 L
.1025 .21941 L
.1052 .21808 L
.10767 .21637 L
.10986 .21431 L
.11172 .21196 L
.11322 .20935 L
.11431 .20655 L
.11498 .20362 L
.11521 .20062 L
.115 .19763 L
.11435 .19469 L
F
.1025 .78059 m
.10693 .77708 L
.1113 .7735 L
.11561 .76985 L
.11986 .76613 L
.12405 .76235 L
.12819 .7585 L
.13226 .75458 L
.13627 .7506 L
.14021 .74656 L
.14409 .74245 L
.14791 .73829 L
.15165 .73406 L
.15533 .72978 L
.15533 .72978 L
.15788 .73789 L
.15973 .74619 L
.16089 .75462 L
.16134 .76311 L
.16107 .77161 L
.1601 .78006 L
.15842 .7884 L
.15606 .79657 L
.15301 .80451 L
.14932 .81218 L
.145 .8195 L
.145 .8195 L
.14313 .81638 L
.14087 .81353 L
.13825 .81101 L
.13532 .80886 L
.13212 .80711 L
.12873 .80581 L
.12519 .80496 L
.12157 .8046 L
.11794 .80471 L
.11435 .80531 L
.11435 .80531 L
.115 .80237 L
.11521 .79938 L
.11498 .79638 L
.11431 .79345 L
.11322 .79065 L
.11172 .78804 L
.10986 .78569 L
.10767 .78363 L
.1052 .78192 L
.1025 .78059 L
F
.15402 .14414 m
.15646 .14543 L
.15902 .14647 L
.16168 .14725 L
.16439 .14775 L
.16715 .14798 L
.16991 .14793 L
.17266 .14761 L
.17535 .147 L
.17798 .14613 L
.1805 .145 L
.1805 .145 L
.17982 .15045 L
.17834 .15575 L
.17611 .16077 L
.17317 .16541 L
.16957 .16957 L
.16541 .17317 L
.16077 .17611 L
.15575 .17834 L
.15045 .17982 L
.145 .1805 L
.145 .1805 L
.14613 .17798 L
.147 .17535 L
.14761 .17266 L
.14793 .16991 L
.14798 .16715 L
.14775 .16439 L
.14725 .16168 L
.14647 .15902 L
.14543 .15646 L
.14414 .15402 L
.14414 .15402 L
.14567 .15388 L
.14717 .1535 L
.1486 .1529 L
.14991 .15209 L
.15109 .15109 L
.15209 .14991 L
.1529 .1486 L
.1535 .14717 L
.15388 .14567 L
.15402 .14414 L
F
.14414 .84598 m
.14543 .84354 L
.14647 .84098 L
.14725 .83832 L
.14775 .83561 L
.14798 .83285 L
.14793 .83009 L
.14761 .82734 L
.147 .82465 L
.14613 .82202 L
.145 .8195 L
.145 .8195 L
.15045 .82018 L
.15575 .82166 L
.16077 .82389 L
.16541 .82683 L
.16957 .83043 L
.17317 .83459 L
.17611 .83923 L
.17834 .84425 L
.17982 .84955 L
.1805 .855 L
.1805 .855 L
.17798 .85387 L
.17535 .853 L
.17266 .85239 L
.16991 .85207 L
.16715 .85202 L
.16439 .85225 L
.16168 .85275 L
.15902 .85353 L
.15646 .85457 L
.15402 .85586 L
.15402 .85586 L
.15388 .85433 L
.1535 .85283 L
.1529 .8514 L
.15209 .85009 L
.15109 .84891 L
.14991 .84791 L
.1486 .8471 L
.14717 .8465 L
.14567 .84612 L
.14414 .84598 L
F
.23944 .5 m
.22938 .4943 L
.21922 .48876 L
.20898 .48339 L
.19866 .47819 L
.18825 .47315 L
.17776 .46829 L
.16719 .46359 L
.15654 .45907 L
.14583 .45472 L
.13505 .45055 L
.12419 .44655 L
.11328 .44273 L
.10231 .43909 L
.09127 .43562 L
.08019 .43234 L
.06905 .42923 L
.05786 .42631 L
.05786 .42631 L
.0641 .41894 L
.06929 .4108 L
.07333 .40202 L
.07615 .39278 L
.07769 .38325 L
.07792 .37359 L
.07685 .36399 L
.07448 .35463 L
.07087 .34567 L
.06608 .33728 L
.06608 .33728 L
.07674 .33604 L
.08722 .33367 L
.09739 .33022 L
.10713 .32571 L
.11635 .32021 L
.12494 .31376 L
.1328 .30644 L
.13984 .29833 L
.14598 .28952 L
.15117 .28012 L
.15533 .27022 L
.15533 .27022 L
.16734 .28522 L
.17851 .30085 L
.18883 .31706 L
.19825 .3338 L
.20676 .35102 L
.21433 .36868 L
.22093 .38672 L
.22655 .40509 L
.23117 .42374 L
.23478 .44261 L
.23737 .46165 L
.23892 .4808 L
.23944 .5 L
F
.15533 .72978 m
.15117 .71988 L
.14598 .71048 L
.13984 .70167 L
.1328 .69356 L
.12494 .68624 L
.11635 .67979 L
.10713 .67429 L
.09739 .66978 L
.08722 .66633 L
.07674 .66396 L
.06608 .66272 L
.06608 .66272 L
.07087 .65433 L
.07448 .64537 L
.07685 .63601 L
.07792 .62641 L
.07769 .61675 L
.07615 .60722 L
.07333 .59798 L
.06929 .5892 L
.0641 .58106 L
.05786 .57369 L
.05786 .57369 L
.06905 .57077 L
.08019 .56766 L
.09127 .56438 L
.10231 .56091 L
.11328 .55727 L
.12419 .55345 L
.13505 .54945 L
.14583 .54528 L
.15654 .54093 L
.16719 .53641 L
.17776 .53171 L
.18825 .52685 L
.19866 .52181 L
.20898 .51661 L
.21922 .51124 L
.22938 .5057 L
.23944 .5 L
.23944 .5 L
.23892 .5192 L
.23737 .53835 L
.23478 .55739 L
.23117 .57626 L
.22655 .59491 L
.22093 .61328 L
.21433 .63132 L
.20676 .64898 L
.19825 .6662 L
.18883 .68294 L
.17851 .69915 L
.16734 .71478 L
.15533 .72978 L
F
.15533 .27022 m
.15788 .26211 L
.15973 .25381 L
.16089 .24538 L
.16134 .23689 L
.16107 .22839 L
.1601 .21994 L
.15842 .2116 L
.15606 .20343 L
.15301 .19549 L
.14932 .18782 L
.145 .1805 L
.145 .1805 L
.15045 .17982 L
.15575 .17834 L
.16077 .17611 L
.16541 .17317 L
.16957 .16957 L
.17317 .16541 L
.17611 .16077 L
.17834 .15575 L
.17982 .15045 L
.1805 .145 L
.1805 .145 L
.18782 .14932 L
.19549 .15301 L
.20343 .15606 L
.2116 .15842 L
.21994 .1601 L
.22839 .16107 L
.23689 .16134 L
.24538 .16089 L
.25381 .15973 L
.26211 .15788 L
.27022 .15533 L
.27022 .15533 L
.26659 .17062 L
.26129 .18541 L
.2544 .19953 L
.24599 .2128 L
.23618 .22507 L
.22507 .23618 L
.2128 .24599 L
.19953 .2544 L
.18541 .26129 L
.17062 .26659 L
.15533 .27022 L
F
.27022 .84467 m
.26211 .84212 L
.25381 .84027 L
.24538 .83911 L
.23689 .83866 L
.22839 .83893 L
.21994 .8399 L
.2116 .84158 L
.20343 .84394 L
.19549 .84699 L
.18782 .85068 L
.1805 .855 L
.1805 .855 L
.17982 .84955 L
.17834 .84425 L
.17611 .83923 L
.17317 .83459 L
.16957 .83043 L
.16541 .82683 L
.16077 .82389 L
.15575 .82166 L
.15045 .82018 L
.145 .8195 L
.145 .8195 L
.14932 .81218 L
.15301 .80451 L
.15606 .79657 L
.15842 .7884 L
.1601 .78006 L
.16107 .77161 L
.16134 .76311 L
.16089 .75462 L
.15973 .74619 L
.15788 .73789 L
.15533 .72978 L
.15533 .72978 L
.17062 .73341 L
.18541 .73871 L
.19953 .7456 L
.2128 .75401 L
.22507 .76382 L
.23618 .77493 L
.24599 .7872 L
.2544 .80047 L
.26129 .81459 L
.26659 .82938 L
.27022 .84467 L
F
.21941 .1025 m
.22292 .10693 L
.2265 .1113 L
.23015 .11561 L
.23387 .11986 L
.23765 .12405 L
.2415 .12819 L
.24542 .13226 L
.2494 .13627 L
.25344 .14021 L
.25755 .14409 L
.26171 .14791 L
.26594 .15165 L
.27022 .15533 L
.27022 .15533 L
.26211 .15788 L
.25381 .15973 L
.24538 .16089 L
.23689 .16134 L
.22839 .16107 L
.21994 .1601 L
.2116 .15842 L
.20343 .15606 L
.19549 .15301 L
.18782 .14932 L
.1805 .145 L
.1805 .145 L
.18362 .14313 L
.18647 .14087 L
.18899 .13825 L
.19114 .13532 L
.19289 .13212 L
.19419 .12873 L
.19504 .12519 L
.1954 .12157 L
.19529 .11794 L
.19469 .11435 L
.19469 .11435 L
.19763 .115 L
.20062 .11521 L
.20362 .11498 L
.20655 .11431 L
.20935 .11322 L
.21196 .11172 L
.21431 .10986 L
.21637 .10767 L
.21808 .1052 L
.21941 .1025 L
F
.19469 .88565 m
.19529 .88206 L
.1954 .87843 L
.19504 .87481 L
.19419 .87127 L
.19289 .86788 L
.19114 .86468 L
.18899 .86175 L
.18647 .85913 L
.18362 .85687 L
.1805 .855 L
.1805 .855 L
.18782 .85068 L
.19549 .84699 L
.20343 .84394 L
.2116 .84158 L
.21994 .8399 L
.22839 .83893 L
.23689 .83866 L
.24538 .83911 L
.25381 .84027 L
.26211 .84212 L
.27022 .84467 L
.27022 .84467 L
.26594 .84835 L
.26171 .85209 L
.25755 .85591 L
.25344 .85979 L
.2494 .86373 L
.24542 .86774 L
.2415 .87181 L
.23765 .87595 L
.23387 .88014 L
.23015 .88439 L
.2265 .8887 L
.22292 .89307 L
.21941 .8975 L
.21941 .8975 L
.21808 .8948 L
.21637 .89233 L
.21431 .89014 L
.21196 .88828 L
.20935 .88678 L
.20655 .88569 L
.20362 .88502 L
.20062 .88479 L
.19763 .885 L
.19469 .88565 L
F
.29006 .05914 m
.29397 .06237 L
.29824 .06511 L
.30282 .06732 L
.30762 .06895 L
.31259 .06999 L
.31764 .07042 L
.32271 .07024 L
.32773 .06945 L
.3326 .06805 L
.33728 .06608 L
.33728 .06608 L
.33604 .07674 L
.33367 .08722 L
.33022 .09739 L
.32571 .10713 L
.32021 .11635 L
.31376 .12494 L
.30644 .1328 L
.29833 .13984 L
.28952 .14598 L
.28012 .15117 L
.27022 .15533 L
.27022 .15533 L
.27132 .14825 L
.27205 .14112 L
.27242 .13396 L
.27244 .12679 L
.27209 .11963 L
.27138 .11249 L
.27032 .10541 L
.2689 .09838 L
.26712 .09143 L
.265 .08458 L
.26254 .07785 L
.26254 .07785 L
.26619 .07812 L
.26983 .07784 L
.27339 .07703 L
.27679 .0757 L
.27996 .07387 L
.28282 .0716 L
.28531 .06892 L
.28738 .06591 L
.28897 .06262 L
.29006 .05914 L
F
.26254 .92215 m
.265 .91542 L
.26712 .90857 L
.2689 .90162 L
.27032 .89459 L
.27138 .88751 L
.27209 .88037 L
.27244 .87321 L
.27242 .86604 L
.27205 .85888 L
.27132 .85175 L
.27022 .84467 L
.27022 .84467 L
.28012 .84883 L
.28952 .85402 L
.29833 .86016 L
.30644 .8672 L
.31376 .87506 L
.32021 .88365 L
.32571 .89287 L
.33022 .90261 L
.33367 .91278 L
.33604 .92326 L
.33728 .93392 L
.33728 .93392 L
.3326 .93195 L
.32773 .93055 L
.32271 .92976 L
.31764 .92958 L
.31259 .93001 L
.30762 .93105 L
.30282 .93268 L
.29824 .93489 L
.29397 .93763 L
.29006 .94086 L
.29006 .94086 L
.28897 .93738 L
.28738 .93409 L
.28531 .93108 L
.28282 .9284 L
.27996 .92613 L
.27679 .9243 L
.27339 .92297 L
.26983 .92216 L
.26619 .92188 L
.26254 .92215 L
F
.27022 .15533 m
.28522 .16734 L
.30085 .17851 L
.31706 .18883 L
.3338 .19825 L
.35102 .20676 L
.36868 .21433 L
.38672 .22093 L
.40509 .22655 L
.42374 .23117 L
.44261 .23478 L
.46165 .23737 L
.4808 .23892 L
.5 .23944 L
.5 .23944 L
.48875 .25825 L
.47692 .27672 L
.46453 .2948 L
.45159 .3125 L
.43811 .32979 L
.4241 .34666 L
.40958 .36309 L
.39456 .37906 L
.37906 .39456 L
.36309 .40958 L
.34666 .4241 L
.32979 .43811 L
.3125 .45159 L
.2948 .46453 L
.27672 .47692 L
.25825 .48875 L
.23944 .5 L
.23944 .5 L
.23892 .4808 L
.23737 .46165 L
.23478 .44261 L
.23117 .42374 L
.22655 .40509 L
.22093 .38672 L
.21433 .36868 L
.20676 .35102 L
.19825 .3338 L
.18883 .31706 L
.17851 .30085 L
.16734 .28522 L
.15533 .27022 L
.15533 .27022 L
.17062 .26659 L
.18541 .26129 L
.19953 .2544 L
.2128 .24599 L
.22507 .23618 L
.23618 .22507 L
.24599 .2128 L
.2544 .19953 L
.26129 .18541 L
.26659 .17062 L
.27022 .15533 L
F
.15533 .72978 m
.16734 .71478 L
.17851 .69915 L
.18883 .68294 L
.19825 .6662 L
.20676 .64898 L
.21433 .63132 L
.22093 .61328 L
.22655 .59491 L
.23117 .57626 L
.23478 .55739 L
.23737 .53835 L
.23892 .5192 L
.23944 .5 L
.23944 .5 L
.25825 .51125 L
.27672 .52308 L
.2948 .53547 L
.3125 .54841 L
.32979 .56189 L
.34666 .5759 L
.36309 .59042 L
.37906 .60544 L
.39456 .62094 L
.40958 .63691 L
.4241 .65334 L
.43811 .67021 L
.45159 .6875 L
.46453 .7052 L
.47692 .72328 L
.48875 .74175 L
.5 .76056 L
.5 .76056 L
.4808 .76108 L
.46165 .76263 L
.44261 .76522 L
.42374 .76883 L
.40509 .77345 L
.38672 .77907 L
.36868 .78567 L
.35102 .79324 L
.3338 .80175 L
.31706 .81117 L
.30085 .82149 L
.28522 .83266 L
.27022 .84467 L
.27022 .84467 L
.26659 .82938 L
.26129 .81459 L
.2544 .80047 L
.24599 .7872 L
.23618 .77493 L
.22507 .76382 L
.2128 .75401 L
.19953 .7456 L
.18541 .73871 L
.17062 .73341 L
.15533 .72978 L
F
.38571 .02381 m
.3883 .02862 L
.39128 .03319 L
.39463 .03749 L
.39834 .0415 L
.40237 .04518 L
.40669 .04851 L
.41128 .05146 L
.41611 .05401 L
.42113 .05615 L
.42631 .05786 L
.42631 .05786 L
.41894 .0641 L
.4108 .06929 L
.40202 .07333 L
.39278 .07615 L
.38325 .07769 L
.37359 .07792 L
.36399 .07685 L
.35463 .07448 L
.34567 .07087 L
.33728 .06608 L
.33728 .06608 L
.34126 .06383 L
.34497 .06116 L
.34836 .0581 L
.3514 .05469 L
.35406 .05097 L
.35629 .04698 L
.35807 .04277 L
.35938 .03839 L
.36021 .0339 L
.36055 .02934 L
.36055 .02934 L
.36308 .03062 L
.36578 .03149 L
.36858 .03196 L
.37142 .03199 L
.37423 .03159 L
.37695 .03077 L
.37951 .02955 L
.38186 .02796 L
.38395 .02603 L
.38571 .02381 L
F
.36055 .97066 m
.36021 .9661 L
.35938 .96161 L
.35807 .95723 L
.35629 .95302 L
.35406 .94903 L
.3514 .94531 L
.34836 .9419 L
.34497 .93884 L
.34126 .93617 L
.33728 .93392 L
.33728 .93392 L
.34567 .92913 L
.35463 .92552 L
.36399 .92315 L
.37359 .92208 L
.38325 .92231 L
.39278 .92385 L
.40202 .92667 L
.4108 .93071 L
.41894 .9359 L
.42631 .94214 L
.42631 .94214 L
.42113 .94385 L
.41611 .94599 L
.41128 .94854 L
.40669 .95149 L
.40237 .95482 L
.39834 .9585 L
.39463 .96251 L
.39128 .96681 L
.3883 .97138 L
.38571 .97619 L
.38571 .97619 L
.38395 .97397 L
.38186 .97204 L
.37951 .97045 L
.37695 .96923 L
.37423 .96841 L
.37142 .96801 L
.36858 .96804 L
.36578 .96851 L
.36308 .96938 L
.36055 .97066 L
F
.27022 .15533 m
.28012 .15117 L
.28952 .14598 L
.29833 .13984 L
.30644 .1328 L
.31376 .12494 L
.32021 .11635 L
.32571 .10713 L
.33022 .09739 L
.33367 .08722 L
.33604 .07674 L
.33728 .06608 L
.33728 .06608 L
.34567 .07087 L
.35463 .07448 L
.36399 .07685 L
.37359 .07792 L
.38325 .07769 L
.39278 .07615 L
.40202 .07333 L
.4108 .06929 L
.41894 .0641 L
.42631 .05786 L
.42631 .05786 L
.42923 .06905 L
.43234 .08019 L
.43562 .09127 L
.43909 .10231 L
.44273 .11328 L
.44655 .12419 L
.45055 .13505 L
.45472 .14583 L
.45907 .15654 L
.46359 .16719 L
.46829 .17776 L
.47315 .18825 L
.47819 .19866 L
.48339 .20898 L
.48876 .21922 L
.4943 .22938 L
.5 .23944 L
.5 .23944 L
.4808 .23892 L
.46165 .23737 L
.44261 .23478 L
.42374 .23117 L
.40509 .22655 L
.38672 .22093 L
.36868 .21433 L
.35102 .20676 L
.3338 .19825 L
.31706 .18883 L
.30085 .17851 L
.28522 .16734 L
.27022 .15533 L
F
.5 .76056 m
.4943 .77062 L
.48876 .78078 L
.48339 .79102 L
.47819 .80134 L
.47315 .81175 L
.46829 .82224 L
.46359 .83281 L
.45907 .84346 L
.45472 .85417 L
.45055 .86495 L
.44655 .87581 L
.44273 .88672 L
.43909 .89769 L
.43562 .90873 L
.43234 .91981 L
.42923 .93095 L
.42631 .94214 L
.42631 .94214 L
.41894 .9359 L
.4108 .93071 L
.40202 .92667 L
.39278 .92385 L
.38325 .92231 L
.37359 .92208 L
.36399 .92315 L
.35463 .92552 L
.34567 .92913 L
.33728 .93392 L
.33728 .93392 L
.33604 .92326 L
.33367 .91278 L
.33022 .90261 L
.32571 .89287 L
.32021 .88365 L
.31376 .87506 L
.30644 .8672 L
.29833 .86016 L
.28952 .85402 L
.28012 .84883 L
.27022 .84467 L
.27022 .84467 L
.28522 .83266 L
.30085 .82149 L
.31706 .81117 L
.3338 .80175 L
.35102 .79324 L
.36868 .78567 L
.38672 .77907 L
.40509 .77345 L
.42374 .76883 L
.44261 .76522 L
.46165 .76263 L
.4808 .76108 L
.5 .76056 L
F
.5 .02795 m
.50476 .03506 L
.51042 .04149 L
.51687 .04711 L
.52401 .05182 L
.53171 .05556 L
.53983 .05825 L
.54824 .05984 L
.55679 .06031 L
.56532 .05964 L
.57369 .05786 L
.57369 .05786 L
.57077 .06905 L
.56766 .08019 L
.56438 .09127 L
.56091 .10231 L
.55727 .11328 L
.55345 .12419 L
.54945 .13505 L
.54528 .14583 L
.54093 .15654 L
.53641 .16719 L
.53171 .17776 L
.52685 .18825 L
.52181 .19866 L
.51661 .20898 L
.51124 .21922 L
.5057 .22938 L
.5 .23944 L
.5 .23944 L
.4943 .22938 L
.48876 .21922 L
.48339 .20898 L
.47819 .19866 L
.47315 .18825 L
.46829 .17776 L
.46359 .16719 L
.45907 .15654 L
.45472 .14583 L
.45055 .13505 L
.44655 .12419 L
.44273 .11328 L
.43909 .10231 L
.43562 .09127 L
.43234 .08019 L
.42923 .06905 L
.42631 .05786 L
.42631 .05786 L
.43468 .05964 L
.44321 .06031 L
.45176 .05984 L
.46017 .05825 L
.46829 .05556 L
.47599 .05182 L
.48313 .04711 L
.48958 .04149 L
.49524 .03506 L
.5 .02795 L
F
.5 .76056 m
.51125 .74175 L
.52308 .72328 L
.53547 .7052 L
.54841 .6875 L
.56189 .67021 L
.5759 .65334 L
.59042 .63691 L
.60544 .62094 L
.62094 .60544 L
.63691 .59042 L
.65334 .5759 L
.67021 .56189 L
.6875 .54841 L
.7052 .53547 L
.72328 .52308 L
.74175 .51125 L
.76056 .5 L
.76056 .5 L
.74175 .48875 L
.72328 .47692 L
.7052 .46453 L
.6875 .45159 L
.67021 .43811 L
.65334 .4241 L
.63691 .40958 L
.62094 .39456 L
.60544 .37906 L
.59042 .36309 L
.5759 .34666 L
.56189 .32979 L
.54841 .3125 L
.53547 .2948 L
.52308 .27672 L
.51125 .25825 L
.5 .23944 L
.5 .23944 L
.48875 .25825 L
.47692 .27672 L
.46453 .2948 L
.45159 .3125 L
.43811 .32979 L
.4241 .34666 L
.40958 .36309 L
.39456 .37906 L
.37906 .39456 L
.36309 .40958 L
.34666 .4241 L
.32979 .43811 L
.3125 .45159 L
.2948 .46453 L
.27672 .47692 L
.25825 .48875 L
.23944 .5 L
.23944 .5 L
.25825 .51125 L
.27672 .52308 L
.2948 .53547 L
.3125 .54841 L
.32979 .56189 L
.34666 .5759 L
.36309 .59042 L
.37906 .60544 L
.39456 .62094 L
.40958 .63691 L
.4241 .65334 L
.43811 .67021 L
.45159 .6875 L
.46453 .7052 L
.47692 .72328 L
.48875 .74175 L
.5 .76056 L
F
.5 .76056 m
.5057 .77062 L
.51124 .78078 L
.51661 .79102 L
.52181 .80134 L
.52685 .81175 L
.53171 .82224 L
.53641 .83281 L
.54093 .84346 L
.54528 .85417 L
.54945 .86495 L
.55345 .87581 L
.55727 .88672 L
.56091 .89769 L
.56438 .90873 L
.56766 .91981 L
.57077 .93095 L
.57369 .94214 L
.57369 .94214 L
.56532 .94036 L
.55679 .93969 L
.54824 .94016 L
.53983 .94175 L
.53171 .94444 L
.52401 .94818 L
.51687 .95289 L
.51042 .95851 L
.50476 .96494 L
.5 .97205 L
.5 .97205 L
.49524 .96494 L
.48958 .95851 L
.48313 .95289 L
.47599 .94818 L
.46829 .94444 L
.46017 .94175 L
.45176 .94016 L
.44321 .93969 L
.43468 .94036 L
.42631 .94214 L
.42631 .94214 L
.42923 .93095 L
.43234 .91981 L
.43562 .90873 L
.43909 .89769 L
.44273 .88672 L
.44655 .87581 L
.45055 .86495 L
.45472 .85417 L
.45907 .84346 L
.46359 .83281 L
.46829 .82224 L
.47315 .81175 L
.47819 .80134 L
.48339 .79102 L
.48876 .78078 L
.4943 .77062 L
.5 .76056 L
F
.5 .23944 m
.5057 .22938 L
.51124 .21922 L
.51661 .20898 L
.52181 .19866 L
.52685 .18825 L
.53171 .17776 L
.53641 .16719 L
.54093 .15654 L
.54528 .14583 L
.54945 .13505 L
.55345 .12419 L
.55727 .11328 L
.56091 .10231 L
.56438 .09127 L
.56766 .08019 L
.57077 .06905 L
.57369 .05786 L
.57369 .05786 L
.58106 .0641 L
.5892 .06929 L
.59798 .07333 L
.60722 .07615 L
.61675 .07769 L
.62641 .07792 L
.63601 .07685 L
.64537 .07448 L
.65433 .07087 L
.66272 .06608 L
.66272 .06608 L
.66396 .07674 L
.66633 .08722 L
.66978 .09739 L
.67429 .10713 L
.67979 .11635 L
.68624 .12494 L
.69356 .1328 L
.70167 .13984 L
.71048 .14598 L
.71988 .15117 L
.72978 .15533 L
.72978 .15533 L
.71478 .16734 L
.69915 .17851 L
.68294 .18883 L
.6662 .19825 L
.64898 .20676 L
.63132 .21433 L
.61328 .22093 L
.59491 .22655 L
.57626 .23117 L
.55739 .23478 L
.53835 .23737 L
.5192 .23892 L
.5 .23944 L
F
.72978 .84467 m
.71988 .84883 L
.71048 .85402 L
.70167 .86016 L
.69356 .8672 L
.68624 .87506 L
.67979 .88365 L
.67429 .89287 L
.66978 .90261 L
.66633 .91278 L
.66396 .92326 L
.66272 .93392 L
.66272 .93392 L
.65433 .92913 L
.64537 .92552 L
.63601 .92315 L
.62641 .92208 L
.61675 .92231 L
.60722 .92385 L
.59798 .92667 L
.5892 .93071 L
.58106 .9359 L
.57369 .94214 L
.57369 .94214 L
.57077 .93095 L
.56766 .91981 L
.56438 .90873 L
.56091 .89769 L
.55727 .88672 L
.55345 .87581 L
.54945 .86495 L
.54528 .85417 L
.54093 .84346 L
.53641 .83281 L
.53171 .82224 L
.52685 .81175 L
.52181 .80134 L
.51661 .79102 L
.51124 .78078 L
.5057 .77062 L
.5 .76056 L
.5 .76056 L
.5192 .76108 L
.53835 .76263 L
.55739 .76522 L
.57626 .76883 L
.59491 .77345 L
.61328 .77907 L
.63132 .78567 L
.64898 .79324 L
.6662 .80175 L
.68294 .81117 L
.69915 .82149 L
.71478 .83266 L
.72978 .84467 L
F
.63945 .02934 m
.63979 .0339 L
.64062 .03839 L
.64193 .04277 L
.64371 .04698 L
.64594 .05097 L
.6486 .05469 L
.65164 .0581 L
.65503 .06116 L
.65874 .06383 L
.66272 .06608 L
.66272 .06608 L
.65433 .07087 L
.64537 .07448 L
.63601 .07685 L
.62641 .07792 L
.61675 .07769 L
.60722 .07615 L
.59798 .07333 L
.5892 .06929 L
.58106 .0641 L
.57369 .05786 L
.57369 .05786 L
.57887 .05615 L
.58389 .05401 L
.58872 .05146 L
.59331 .04851 L
.59763 .04518 L
.60166 .0415 L
.60537 .03749 L
.60872 .03319 L
.6117 .02862 L
.61429 .02381 L
.61429 .02381 L
.61605 .02603 L
.61814 .02796 L
.62049 .02955 L
.62305 .03077 L
.62577 .03159 L
.62858 .03199 L
.63142 .03196 L
.63422 .03149 L
.63692 .03062 L
.63945 .02934 L
F
.61429 .97619 m
.6117 .97138 L
.60872 .96681 L
.60537 .96251 L
.60166 .9585 L
.59763 .95482 L
.59331 .95149 L
.58872 .94854 L
.58389 .94599 L
.57887 .94385 L
.57369 .94214 L
.57369 .94214 L
.58106 .9359 L
.5892 .93071 L
.59798 .92667 L
.60722 .92385 L
.61675 .92231 L
.62641 .92208 L
.63601 .92315 L
.64537 .92552 L
.65433 .92913 L
.66272 .93392 L
.66272 .93392 L
.65874 .93617 L
.65503 .93884 L
.65164 .9419 L
.6486 .94531 L
.64594 .94903 L
.64371 .95302 L
.64193 .95723 L
.64062 .96161 L
.63979 .9661 L
.63945 .97066 L
.63945 .97066 L
.63692 .96938 L
.63422 .96851 L
.63142 .96804 L
.62858 .96801 L
.62577 .96841 L
.62305 .96923 L
.62049 .97045 L
.61814 .97204 L
.61605 .97397 L
.61429 .97619 L
F
.72978 .15533 m
.71478 .16734 L
.69915 .17851 L
.68294 .18883 L
.6662 .19825 L
.64898 .20676 L
.63132 .21433 L
.61328 .22093 L
.59491 .22655 L
.57626 .23117 L
.55739 .23478 L
.53835 .23737 L
.5192 .23892 L
.5 .23944 L
.5 .23944 L
.51125 .25825 L
.52308 .27672 L
.53547 .2948 L
.54841 .3125 L
.56189 .32979 L
.5759 .34666 L
.59042 .36309 L
.60544 .37906 L
.62094 .39456 L
.63691 .40958 L
.65334 .4241 L
.67021 .43811 L
.6875 .45159 L
.7052 .46453 L
.72328 .47692 L
.74175 .48875 L
.76056 .5 L
.76056 .5 L
.76108 .4808 L
.76263 .46165 L
.76522 .44261 L
.76883 .42374 L
.77345 .40509 L
.77907 .38672 L
.78567 .36868 L
.79324 .35102 L
.80175 .3338 L
.81117 .31706 L
.82149 .30085 L
.83266 .28522 L
.84467 .27022 L
.84467 .27022 L
.82938 .26659 L
.81459 .26129 L
.80047 .2544 L
.7872 .24599 L
.77493 .23618 L
.76382 .22507 L
.75401 .2128 L
.7456 .19953 L
.73871 .18541 L
.73341 .17062 L
.72978 .15533 L
F
.76056 .5 m
.74175 .51125 L
.72328 .52308 L
.7052 .53547 L
.6875 .54841 L
.67021 .56189 L
.65334 .5759 L
.63691 .59042 L
.62094 .60544 L
.60544 .62094 L
.59042 .63691 L
.5759 .65334 L
.56189 .67021 L
.54841 .6875 L
.53547 .7052 L
.52308 .72328 L
.51125 .74175 L
.5 .76056 L
.5 .76056 L
.5192 .76108 L
.53835 .76263 L
.55739 .76522 L
.57626 .76883 L
.59491 .77345 L
.61328 .77907 L
.63132 .78567 L
.64898 .79324 L
.6662 .80175 L
.68294 .81117 L
.69915 .82149 L
.71478 .83266 L
.72978 .84467 L
.72978 .84467 L
.73341 .82938 L
.73871 .81459 L
.7456 .80047 L
.75401 .7872 L
.76382 .77493 L
.77493 .76382 L
.7872 .75401 L
.80047 .7456 L
.81459 .73871 L
.82938 .73341 L
.84467 .72978 L
.84467 .72978 L
.83266 .71478 L
.82149 .69915 L
.81117 .68294 L
.80175 .6662 L
.79324 .64898 L
.78567 .63132 L
.77907 .61328 L
.77345 .59491 L
.76883 .57626 L
.76522 .55739 L
.76263 .53835 L
.76108 .5192 L
.76056 .5 L
F
.73746 .07785 m
.735 .08458 L
.73288 .09143 L
.7311 .09838 L
.72968 .10541 L
.72862 .11249 L
.72791 .11963 L
.72756 .12679 L
.72758 .13396 L
.72795 .14112 L
.72868 .14825 L
.72978 .15533 L
.72978 .15533 L
.71988 .15117 L
.71048 .14598 L
.70167 .13984 L
.69356 .1328 L
.68624 .12494 L
.67979 .11635 L
.67429 .10713 L
.66978 .09739 L
.66633 .08722 L
.66396 .07674 L
.66272 .06608 L
.66272 .06608 L
.6674 .06805 L
.67227 .06945 L
.67729 .07024 L
.68236 .07042 L
.68741 .06999 L
.69238 .06895 L
.69718 .06732 L
.70176 .06511 L
.70603 .06237 L
.70994 .05914 L
.70994 .05914 L
.71103 .06262 L
.71262 .06591 L
.71469 .06892 L
.71718 .0716 L
.72004 .07387 L
.72321 .0757 L
.72661 .07703 L
.73017 .07784 L
.73381 .07812 L
.73746 .07785 L
F
.70994 .94086 m
.70603 .93763 L
.70176 .93489 L
.69718 .93268 L
.69238 .93105 L
.68741 .93001 L
.68236 .92958 L
.67729 .92976 L
.67227 .93055 L
.6674 .93195 L
.66272 .93392 L
.66272 .93392 L
.66396 .92326 L
.66633 .91278 L
.66978 .90261 L
.67429 .89287 L
.67979 .88365 L
.68624 .87506 L
.69356 .8672 L
.70167 .86016 L
.71048 .85402 L
.71988 .84883 L
.72978 .84467 L
.72978 .84467 L
.72868 .85175 L
.72795 .85888 L
.72758 .86604 L
.72756 .87321 L
.72791 .88037 L
.72862 .88751 L
.72968 .89459 L
.7311 .90162 L
.73288 .90857 L
.735 .91542 L
.73746 .92215 L
.73746 .92215 L
.73381 .92188 L
.73017 .92216 L
.72661 .92297 L
.72321 .9243 L
.72004 .92613 L
.71718 .9284 L
.71469 .93108 L
.71262 .93409 L
.71103 .93738 L
.70994 .94086 L
F
.80531 .11435 m
.80471 .11794 L
.8046 .12157 L
.80496 .12519 L
.80581 .12873 L
.80711 .13212 L
.80886 .13532 L
.81101 .13825 L
.81353 .14087 L
.81638 .14313 L
.8195 .145 L
.8195 .145 L
.81218 .14932 L
.80451 .15301 L
.79657 .15606 L
.7884 .15842 L
.78006 .1601 L
.77161 .16107 L
.76311 .16134 L
.75462 .16089 L
.74619 .15973 L
.73789 .15788 L
.72978 .15533 L
.72978 .15533 L
.73406 .15165 L
.73829 .14791 L
.74245 .14409 L
.74656 .14021 L
.7506 .13627 L
.75458 .13226 L
.7585 .12819 L
.76235 .12405 L
.76613 .11986 L
.76985 .11561 L
.7735 .1113 L
.77708 .10693 L
.78059 .1025 L
.78059 .1025 L
.78192 .1052 L
.78363 .10767 L
.78569 .10986 L
.78804 .11172 L
.79065 .11322 L
.79345 .11431 L
.79638 .11498 L
.79938 .11521 L
.80237 .115 L
.80531 .11435 L
F
.78059 .8975 m
.77708 .89307 L
.7735 .8887 L
.76985 .88439 L
.76613 .88014 L
.76235 .87595 L
.7585 .87181 L
.75458 .86774 L
.7506 .86373 L
.74656 .85979 L
.74245 .85591 L
.73829 .85209 L
.73406 .84835 L
.72978 .84467 L
.72978 .84467 L
.73789 .84212 L
.74619 .84027 L
.75462 .83911 L
.76311 .83866 L
.77161 .83893 L
.78006 .8399 L
.7884 .84158 L
.79657 .84394 L
.80451 .84699 L
.81218 .85068 L
.8195 .855 L
.8195 .855 L
.81638 .85687 L
.81353 .85913 L
.81101 .86175 L
.80886 .86468 L
.80711 .86788 L
.80581 .87127 L
.80496 .87481 L
.8046 .87843 L
.80471 .88206 L
.80531 .88565 L
.80531 .88565 L
.80237 .885 L
.79938 .88479 L
.79638 .88502 L
.79345 .88569 L
.79065 .88678 L
.78804 .88828 L
.78569 .89014 L
.78363 .89233 L
.78192 .8948 L
.78059 .8975 L
F
.72978 .15533 m
.73789 .15788 L
.74619 .15973 L
.75462 .16089 L
.76311 .16134 L
.77161 .16107 L
.78006 .1601 L
.7884 .15842 L
.79657 .15606 L
.80451 .15301 L
.81218 .14932 L
.8195 .145 L
.8195 .145 L
.82018 .15045 L
.82166 .15575 L
.82389 .16077 L
.82683 .16541 L
.83043 .16957 L
.83459 .17317 L
.83923 .17611 L
.84425 .17834 L
.84955 .17982 L
.855 .1805 L
.855 .1805 L
.85068 .18782 L
.84699 .19549 L
.84394 .20343 L
.84158 .2116 L
.8399 .21994 L
.83893 .22839 L
.83866 .23689 L
.83911 .24538 L
.84027 .25381 L
.84212 .26211 L
.84467 .27022 L
.84467 .27022 L
.82938 .26659 L
.81459 .26129 L
.80047 .2544 L
.7872 .24599 L
.77493 .23618 L
.76382 .22507 L
.75401 .2128 L
.7456 .19953 L
.73871 .18541 L
.73341 .17062 L
.72978 .15533 L
F
.84467 .72978 m
.84212 .73789 L
.84027 .74619 L
.83911 .75462 L
.83866 .76311 L
.83893 .77161 L
.8399 .78006 L
.84158 .7884 L
.84394 .79657 L
.84699 .80451 L
.85068 .81218 L
.855 .8195 L
.855 .8195 L
.84955 .82018 L
.84425 .82166 L
.83923 .82389 L
.83459 .82683 L
.83043 .83043 L
.82683 .83459 L
.82389 .83923 L
.82166 .84425 L
.82018 .84955 L
.8195 .855 L
.8195 .855 L
.81218 .85068 L
.80451 .84699 L
.79657 .84394 L
.7884 .84158 L
.78006 .8399 L
.77161 .83893 L
.76311 .83866 L
.75462 .83911 L
.74619 .84027 L
.73789 .84212 L
.72978 .84467 L
.72978 .84467 L
.73341 .82938 L
.73871 .81459 L
.7456 .80047 L
.75401 .7872 L
.76382 .77493 L
.77493 .76382 L
.7872 .75401 L
.80047 .7456 L
.81459 .73871 L
.82938 .73341 L
.84467 .72978 L
F
.84467 .27022 m
.84883 .28012 L
.85402 .28952 L
.86016 .29833 L
.8672 .30644 L
.87506 .31376 L
.88365 .32021 L
.89287 .32571 L
.90261 .33022 L
.91278 .33367 L
.92326 .33604 L
.93392 .33728 L
.93392 .33728 L
.92913 .34567 L
.92552 .35463 L
.92315 .36399 L
.92208 .37359 L
.92231 .38325 L
.92385 .39278 L
.92667 .40202 L
.93071 .4108 L
.9359 .41894 L
.94214 .42631 L
.94214 .42631 L
.93095 .42923 L
.91981 .43234 L
.90873 .43562 L
.89769 .43909 L
.88672 .44273 L
.87581 .44655 L
.86495 .45055 L
.85417 .45472 L
.84346 .45907 L
.83281 .46359 L
.82224 .46829 L
.81175 .47315 L
.80134 .47819 L
.79102 .48339 L
.78078 .48876 L
.77062 .4943 L
.76056 .5 L
.76056 .5 L
.76108 .4808 L
.76263 .46165 L
.76522 .44261 L
.76883 .42374 L
.77345 .40509 L
.77907 .38672 L
.78567 .36868 L
.79324 .35102 L
.80175 .3338 L
.81117 .31706 L
.82149 .30085 L
.83266 .28522 L
.84467 .27022 L
F
.76056 .5 m
.77062 .5057 L
.78078 .51124 L
.79102 .51661 L
.80134 .52181 L
.81175 .52685 L
.82224 .53171 L
.83281 .53641 L
.84346 .54093 L
.85417 .54528 L
.86495 .54945 L
.87581 .55345 L
.88672 .55727 L
.89769 .56091 L
.90873 .56438 L
.91981 .56766 L
.93095 .57077 L
.94214 .57369 L
.94214 .57369 L
.9359 .58106 L
.93071 .5892 L
.92667 .59798 L
.92385 .60722 L
.92231 .61675 L
.92208 .62641 L
.92315 .63601 L
.92552 .64537 L
.92913 .65433 L
.93392 .66272 L
.93392 .66272 L
.92326 .66396 L
.91278 .66633 L
.90261 .66978 L
.89287 .67429 L
.88365 .67979 L
.87506 .68624 L
.8672 .69356 L
.86016 .70167 L
.85402 .71048 L
.84883 .71988 L
.84467 .72978 L
.84467 .72978 L
.83266 .71478 L
.82149 .69915 L
.81117 .68294 L
.80175 .6662 L
.79324 .64898 L
.78567 .63132 L
.77907 .61328 L
.77345 .59491 L
.76883 .57626 L
.76522 .55739 L
.76263 .53835 L
.76108 .5192 L
.76056 .5 L
F
.85586 .15402 m
.85457 .15646 L
.85353 .15902 L
.85275 .16168 L
.85225 .16439 L
.85202 .16715 L
.85207 .16991 L
.85239 .17266 L
.853 .17535 L
.85387 .17798 L
.855 .1805 L
.855 .1805 L
.84955 .17982 L
.84425 .17834 L
.83923 .17611 L
.83459 .17317 L
.83043 .16957 L
.82683 .16541 L
.82389 .16077 L
.82166 .15575 L
.82018 .15045 L
.8195 .145 L
.8195 .145 L
.82202 .14613 L
.82465 .147 L
.82734 .14761 L
.83009 .14793 L
.83285 .14798 L
.83561 .14775 L
.83832 .14725 L
.84098 .14647 L
.84354 .14543 L
.84598 .14414 L
.84598 .14414 L
.84612 .14567 L
.8465 .14717 L
.8471 .1486 L
.84791 .14991 L
.84891 .15109 L
.85009 .15209 L
.8514 .1529 L
.85283 .1535 L
.85433 .15388 L
.85586 .15402 L
F
.84598 .85586 m
.84354 .85457 L
.84098 .85353 L
.83832 .85275 L
.83561 .85225 L
.83285 .85202 L
.83009 .85207 L
.82734 .85239 L
.82465 .853 L
.82202 .85387 L
.8195 .855 L
.8195 .855 L
.82018 .84955 L
.82166 .84425 L
.82389 .83923 L
.82683 .83459 L
.83043 .83043 L
.83459 .82683 L
.83923 .82389 L
.84425 .82166 L
.84955 .82018 L
.855 .8195 L
.855 .8195 L
.85387 .82202 L
.853 .82465 L
.85239 .82734 L
.85207 .83009 L
.85202 .83285 L
.85225 .83561 L
.85275 .83832 L
.85353 .84098 L
.85457 .84354 L
.85586 .84598 L
.85586 .84598 L
.85433 .84612 L
.85283 .8465 L
.8514 .8471 L
.85009 .84791 L
.84891 .84891 L
.84791 .85009 L
.8471 .8514 L
.8465 .85283 L
.84612 .85433 L
.84598 .85586 L
F
.8975 .21941 m
.89307 .22292 L
.8887 .2265 L
.88439 .23015 L
.88014 .23387 L
.87595 .23765 L
.87181 .2415 L
.86774 .24542 L
.86373 .2494 L
.85979 .25344 L
.85591 .25755 L
.85209 .26171 L
.84835 .26594 L
.84467 .27022 L
.84467 .27022 L
.84212 .26211 L
.84027 .25381 L
.83911 .24538 L
.83866 .23689 L
.83893 .22839 L
.8399 .21994 L
.84158 .2116 L
.84394 .20343 L
.84699 .19549 L
.85068 .18782 L
.855 .1805 L
.855 .1805 L
.85687 .18362 L
.85913 .18647 L
.86175 .18899 L
.86468 .19114 L
.86788 .19289 L
.87127 .19419 L
.87481 .19504 L
.87843 .1954 L
.88206 .19529 L
.88565 .19469 L
.88565 .19469 L
.885 .19763 L
.88479 .20062 L
.88502 .20362 L
.88569 .20655 L
.88678 .20935 L
.88828 .21196 L
.89014 .21431 L
.89233 .21637 L
.8948 .21808 L
.8975 .21941 L
F
.88565 .80531 m
.88206 .80471 L
.87843 .8046 L
.87481 .80496 L
.87127 .80581 L
.86788 .80711 L
.86468 .80886 L
.86175 .81101 L
.85913 .81353 L
.85687 .81638 L
.855 .8195 L
.855 .8195 L
.85068 .81218 L
.84699 .80451 L
.84394 .79657 L
.84158 .7884 L
.8399 .78006 L
.83893 .77161 L
.83866 .76311 L
.83911 .75462 L
.84027 .74619 L
.84212 .73789 L
.84467 .72978 L
.84467 .72978 L
.84835 .73406 L
.85209 .73829 L
.85591 .74245 L
.85979 .74656 L
.86373 .7506 L
.86774 .75458 L
.87181 .7585 L
.87595 .76235 L
.88014 .76613 L
.88439 .76985 L
.8887 .7735 L
.89307 .77708 L
.8975 .78059 L
.8975 .78059 L
.8948 .78192 L
.89233 .78363 L
.89014 .78569 L
.88828 .78804 L
.88678 .79065 L
.88569 .79345 L
.88502 .79638 L
.88479 .79938 L
.885 .80237 L
.88565 .80531 L
F
.97205 .5 m
.96494 .50476 L
.95851 .51042 L
.95289 .51687 L
.94818 .52401 L
.94444 .53171 L
.94175 .53983 L
.94016 .54824 L
.93969 .55679 L
.94036 .56532 L
.94214 .57369 L
.94214 .57369 L
.93095 .57077 L
.91981 .56766 L
.90873 .56438 L
.89769 .56091 L
.88672 .55727 L
.87581 .55345 L
.86495 .54945 L
.85417 .54528 L
.84346 .54093 L
.83281 .53641 L
.82224 .53171 L
.81175 .52685 L
.80134 .52181 L
.79102 .51661 L
.78078 .51124 L
.77062 .5057 L
.76056 .5 L
.76056 .5 L
.77062 .4943 L
.78078 .48876 L
.79102 .48339 L
.80134 .47819 L
.81175 .47315 L
.82224 .46829 L
.83281 .46359 L
.84346 .45907 L
.85417 .45472 L
.86495 .45055 L
.87581 .44655 L
.88672 .44273 L
.89769 .43909 L
.90873 .43562 L
.91981 .43234 L
.93095 .42923 L
.94214 .42631 L
.94214 .42631 L
.94036 .43468 L
.93969 .44321 L
.94016 .45176 L
.94175 .46017 L
.94444 .46829 L
.94818 .47599 L
.95289 .48313 L
.95851 .48958 L
.96494 .49524 L
.97205 .5 L
F
.94086 .29006 m
.93763 .29397 L
.93489 .29824 L
.93268 .30282 L
.93105 .30762 L
.93001 .31259 L
.92958 .31764 L
.92976 .32271 L
.93055 .32773 L
.93195 .3326 L
.93392 .33728 L
.93392 .33728 L
.92326 .33604 L
.91278 .33367 L
.90261 .33022 L
.89287 .32571 L
.88365 .32021 L
.87506 .31376 L
.8672 .30644 L
.86016 .29833 L
.85402 .28952 L
.84883 .28012 L
.84467 .27022 L
.84467 .27022 L
.85175 .27132 L
.85888 .27205 L
.86604 .27242 L
.87321 .27244 L
.88037 .27209 L
.88751 .27138 L
.89459 .27032 L
.90162 .2689 L
.90857 .26712 L
.91542 .265 L
.92215 .26254 L
.92215 .26254 L
.92188 .26619 L
.92216 .26983 L
.92297 .27339 L
.9243 .27679 L
.92613 .27996 L
.9284 .28282 L
.93108 .28531 L
.93409 .28738 L
.93738 .28897 L
.94086 .29006 L
F
.92215 .73746 m
.91542 .735 L
.90857 .73288 L
.90162 .7311 L
.89459 .72968 L
.88751 .72862 L
.88037 .72791 L
.87321 .72756 L
.86604 .72758 L
.85888 .72795 L
.85175 .72868 L
.84467 .72978 L
.84467 .72978 L
.84883 .71988 L
.85402 .71048 L
.86016 .70167 L
.8672 .69356 L
.87506 .68624 L
.88365 .67979 L
.89287 .67429 L
.90261 .66978 L
.91278 .66633 L
.92326 .66396 L
.93392 .66272 L
.93392 .66272 L
.93195 .6674 L
.93055 .67227 L
.92976 .67729 L
.92958 .68236 L
.93001 .68741 L
.93105 .69238 L
.93268 .69718 L
.93489 .70176 L
.93763 .70603 L
.94086 .70994 L
.94086 .70994 L
.93738 .71103 L
.93409 .71262 L
.93108 .71469 L
.9284 .71718 L
.92613 .72004 L
.9243 .72321 L
.92297 .72661 L
.92216 .73017 L
.92188 .73381 L
.92215 .73746 L
F
.97619 .38571 m
.97138 .3883 L
.96681 .39128 L
.96251 .39463 L
.9585 .39834 L
.95482 .40237 L
.95149 .40669 L
.94854 .41128 L
.94599 .41611 L
.94385 .42113 L
.94214 .42631 L
.94214 .42631 L
.9359 .41894 L
.93071 .4108 L
.92667 .40202 L
.92385 .39278 L
.92231 .38325 L
.92208 .37359 L
.92315 .36399 L
.92552 .35463 L
.92913 .34567 L
.93392 .33728 L
.93392 .33728 L
.93617 .34126 L
.93884 .34497 L
.9419 .34836 L
.94531 .3514 L
.94903 .35406 L
.95302 .35629 L
.95723 .35807 L
.96161 .35938 L
.9661 .36021 L
.97066 .36055 L
.97066 .36055 L
.96938 .36308 L
.96851 .36578 L
.96804 .36858 L
.96801 .37142 L
.96841 .37423 L
.96923 .37695 L
.97045 .37951 L
.97204 .38186 L
.97397 .38395 L
.97619 .38571 L
F
.97066 .63945 m
.9661 .63979 L
.96161 .64062 L
.95723 .64193 L
.95302 .64371 L
.94903 .64594 L
.94531 .6486 L
.9419 .65164 L
.93884 .65503 L
.93617 .65874 L
.93392 .66272 L
.93392 .66272 L
.92913 .65433 L
.92552 .64537 L
.92315 .63601 L
.92208 .62641 L
.92231 .61675 L
.92385 .60722 L
.92667 .59798 L
.93071 .5892 L
.9359 .58106 L
.94214 .57369 L
.94214 .57369 L
.94385 .57887 L
.94599 .58389 L
.94854 .58872 L
.95149 .59331 L
.95482 .59763 L
.9585 .60166 L
.96251 .60537 L
.96681 .60872 L
.97138 .6117 L
.97619 .61429 L
.97619 .61429 L
.97397 .61605 L
.97204 .61814 L
.97045 .62049 L
.96923 .62305 L
.96841 .62577 L
.96801 .62858 L
.96804 .63142 L
.96851 .63422 L
.96938 .63692 L
.97066 .63945 L
F
1 g
.23944 .5 m
.22938 .4943 L
.21922 .48876 L
.20898 .48339 L
.19866 .47819 L
.18825 .47315 L
.17776 .46829 L
.16719 .46359 L
.15654 .45907 L
.14583 .45472 L
.13505 .45055 L
.12419 .44655 L
.11328 .44273 L
.10231 .43909 L
.09127 .43562 L
.08019 .43234 L
.06905 .42923 L
.05786 .42631 L
.05786 .42631 L
.0641 .41894 L
.06929 .4108 L
.07333 .40202 L
.07615 .39278 L
.07769 .38325 L
.07792 .37359 L
.07685 .36399 L
.07448 .35463 L
.07087 .34567 L
.06608 .33728 L
.06608 .33728 L
.07674 .33604 L
.08722 .33367 L
.09739 .33022 L
.10713 .32571 L
.11635 .32021 L
.12494 .31376 L
.1328 .30644 L
.13984 .29833 L
.14598 .28952 L
.15117 .28012 L
.15533 .27022 L
.15533 .27022 L
.16734 .28522 L
.17851 .30085 L
.18883 .31706 L
.19825 .3338 L
.20676 .35102 L
.21433 .36868 L
.22093 .38672 L
.22655 .40509 L
.23117 .42374 L
.23478 .44261 L
.23737 .46165 L
.23892 .4808 L
.23944 .5 L
F
.15533 .72978 m
.15117 .71988 L
.14598 .71048 L
.13984 .70167 L
.1328 .69356 L
.12494 .68624 L
.11635 .67979 L
.10713 .67429 L
.09739 .66978 L
.08722 .66633 L
.07674 .66396 L
.06608 .66272 L
.06608 .66272 L
.07087 .65433 L
.07448 .64537 L
.07685 .63601 L
.07792 .62641 L
.07769 .61675 L
.07615 .60722 L
.07333 .59798 L
.06929 .5892 L
.0641 .58106 L
.05786 .57369 L
.05786 .57369 L
.06905 .57077 L
.08019 .56766 L
.09127 .56438 L
.10231 .56091 L
.11328 .55727 L
.12419 .55345 L
.13505 .54945 L
.14583 .54528 L
.15654 .54093 L
.16719 .53641 L
.17776 .53171 L
.18825 .52685 L
.19866 .52181 L
.20898 .51661 L
.21922 .51124 L
.22938 .5057 L
.23944 .5 L
.23944 .5 L
.23892 .5192 L
.23737 .53835 L
.23478 .55739 L
.23117 .57626 L
.22655 .59491 L
.22093 .61328 L
.21433 .63132 L
.20676 .64898 L
.19825 .6662 L
.18883 .68294 L
.17851 .69915 L
.16734 .71478 L
.15533 .72978 L
F
.15533 .27022 m
.15788 .26211 L
.15973 .25381 L
.16089 .24538 L
.16134 .23689 L
.16107 .22839 L
.1601 .21994 L
.15842 .2116 L
.15606 .20343 L
.15301 .19549 L
.14932 .18782 L
.145 .1805 L
.145 .1805 L
.15045 .17982 L
.15575 .17834 L
.16077 .17611 L
.16541 .17317 L
.16957 .16957 L
.17317 .16541 L
.17611 .16077 L
.17834 .15575 L
.17982 .15045 L
.1805 .145 L
.1805 .145 L
.18782 .14932 L
.19549 .15301 L
.20343 .15606 L
.2116 .15842 L
.21994 .1601 L
.22839 .16107 L
.23689 .16134 L
.24538 .16089 L
.25381 .15973 L
.26211 .15788 L
.27022 .15533 L
.27022 .15533 L
.26659 .17062 L
.26129 .18541 L
.2544 .19953 L
.24599 .2128 L
.23618 .22507 L
.22507 .23618 L
.2128 .24599 L
.19953 .2544 L
.18541 .26129 L
.17062 .26659 L
.15533 .27022 L
F
.27022 .84467 m
.26211 .84212 L
.25381 .84027 L
.24538 .83911 L
.23689 .83866 L
.22839 .83893 L
.21994 .8399 L
.2116 .84158 L
.20343 .84394 L
.19549 .84699 L
.18782 .85068 L
.1805 .855 L
.1805 .855 L
.17982 .84955 L
.17834 .84425 L
.17611 .83923 L
.17317 .83459 L
.16957 .83043 L
.16541 .82683 L
.16077 .82389 L
.15575 .82166 L
.15045 .82018 L
.145 .8195 L
.145 .8195 L
.14932 .81218 L
.15301 .80451 L
.15606 .79657 L
.15842 .7884 L
.1601 .78006 L
.16107 .77161 L
.16134 .76311 L
.16089 .75462 L
.15973 .74619 L
.15788 .73789 L
.15533 .72978 L
.15533 .72978 L
.17062 .73341 L
.18541 .73871 L
.19953 .7456 L
.2128 .75401 L
.22507 .76382 L
.23618 .77493 L
.24599 .7872 L
.2544 .80047 L
.26129 .81459 L
.26659 .82938 L
.27022 .84467 L
F
.27022 .15533 m
.28522 .16734 L
.30085 .17851 L
.31706 .18883 L
.3338 .19825 L
.35102 .20676 L
.36868 .21433 L
.38672 .22093 L
.40509 .22655 L
.42374 .23117 L
.44261 .23478 L
.46165 .23737 L
.4808 .23892 L
.5 .23944 L
.5 .23944 L
.48875 .25825 L
.47692 .27672 L
.46453 .2948 L
.45159 .3125 L
.43811 .32979 L
.4241 .34666 L
.40958 .36309 L
.39456 .37906 L
.37906 .39456 L
.36309 .40958 L
.34666 .4241 L
.32979 .43811 L
.3125 .45159 L
.2948 .46453 L
.27672 .47692 L
.25825 .48875 L
.23944 .5 L
.23944 .5 L
.23892 .4808 L
.23737 .46165 L
.23478 .44261 L
.23117 .42374 L
.22655 .40509 L
.22093 .38672 L
.21433 .36868 L
.20676 .35102 L
.19825 .3338 L
.18883 .31706 L
.17851 .30085 L
.16734 .28522 L
.15533 .27022 L
.15533 .27022 L
.17062 .26659 L
.18541 .26129 L
.19953 .2544 L
.2128 .24599 L
.22507 .23618 L
.23618 .22507 L
.24599 .2128 L
.2544 .19953 L
.26129 .18541 L
.26659 .17062 L
.27022 .15533 L
F
.15533 .72978 m
.16734 .71478 L
.17851 .69915 L
.18883 .68294 L
.19825 .6662 L
.20676 .64898 L
.21433 .63132 L
.22093 .61328 L
.22655 .59491 L
.23117 .57626 L
.23478 .55739 L
.23737 .53835 L
.23892 .5192 L
.23944 .5 L
.23944 .5 L
.25825 .51125 L
.27672 .52308 L
.2948 .53547 L
.3125 .54841 L
.32979 .56189 L
.34666 .5759 L
.36309 .59042 L
.37906 .60544 L
.39456 .62094 L
.40958 .63691 L
.4241 .65334 L
.43811 .67021 L
.45159 .6875 L
.46453 .7052 L
.47692 .72328 L
.48875 .74175 L
.5 .76056 L
.5 .76056 L
.4808 .76108 L
.46165 .76263 L
.44261 .76522 L
.42374 .76883 L
.40509 .77345 L
.38672 .77907 L
.36868 .78567 L
.35102 .79324 L
.3338 .80175 L
.31706 .81117 L
.30085 .82149 L
.28522 .83266 L
.27022 .84467 L
.27022 .84467 L
.26659 .82938 L
.26129 .81459 L
.2544 .80047 L
.24599 .7872 L
.23618 .77493 L
.22507 .76382 L
.2128 .75401 L
.19953 .7456 L
.18541 .73871 L
.17062 .73341 L
.15533 .72978 L
F
.27022 .15533 m
.28012 .15117 L
.28952 .14598 L
.29833 .13984 L
.30644 .1328 L
.31376 .12494 L
.32021 .11635 L
.32571 .10713 L
.33022 .09739 L
.33367 .08722 L
.33604 .07674 L
.33728 .06608 L
.33728 .06608 L
.34567 .07087 L
.35463 .07448 L
.36399 .07685 L
.37359 .07792 L
.38325 .07769 L
.39278 .07615 L
.40202 .07333 L
.4108 .06929 L
.41894 .0641 L
.42631 .05786 L
.42631 .05786 L
.42923 .06905 L
.43234 .08019 L
.43562 .09127 L
.43909 .10231 L
.44273 .11328 L
.44655 .12419 L
.45055 .13505 L
.45472 .14583 L
.45907 .15654 L
.46359 .16719 L
.46829 .17776 L
.47315 .18825 L
.47819 .19866 L
.48339 .20898 L
.48876 .21922 L
.4943 .22938 L
.5 .23944 L
.5 .23944 L
.4808 .23892 L
.46165 .23737 L
.44261 .23478 L
.42374 .23117 L
.40509 .22655 L
.38672 .22093 L
.36868 .21433 L
.35102 .20676 L
.3338 .19825 L
.31706 .18883 L
.30085 .17851 L
.28522 .16734 L
.27022 .15533 L
F
.5 .76056 m
.4943 .77062 L
.48876 .78078 L
.48339 .79102 L
.47819 .80134 L
.47315 .81175 L
.46829 .82224 L
.46359 .83281 L
.45907 .84346 L
.45472 .85417 L
.45055 .86495 L
.44655 .87581 L
.44273 .88672 L
.43909 .89769 L
.43562 .90873 L
.43234 .91981 L
.42923 .93095 L
.42631 .94214 L
.42631 .94214 L
.41894 .9359 L
.4108 .93071 L
.40202 .92667 L
.39278 .92385 L
.38325 .92231 L
.37359 .92208 L
.36399 .92315 L
.35463 .92552 L
.34567 .92913 L
.33728 .93392 L
.33728 .93392 L
.33604 .92326 L
.33367 .91278 L
.33022 .90261 L
.32571 .89287 L
.32021 .88365 L
.31376 .87506 L
.30644 .8672 L
.29833 .86016 L
.28952 .85402 L
.28012 .84883 L
.27022 .84467 L
.27022 .84467 L
.28522 .83266 L
.30085 .82149 L
.31706 .81117 L
.3338 .80175 L
.35102 .79324 L
.36868 .78567 L
.38672 .77907 L
.40509 .77345 L
.42374 .76883 L
.44261 .76522 L
.46165 .76263 L
.4808 .76108 L
.5 .76056 L
F
.5 .76056 m
.51125 .74175 L
.52308 .72328 L
.53547 .7052 L
.54841 .6875 L
.56189 .67021 L
.5759 .65334 L
.59042 .63691 L
.60544 .62094 L
.62094 .60544 L
.63691 .59042 L
.65334 .5759 L
.67021 .56189 L
.6875 .54841 L
.7052 .53547 L
.72328 .52308 L
.74175 .51125 L
.76056 .5 L
.76056 .5 L
.74175 .48875 L
.72328 .47692 L
.7052 .46453 L
.6875 .45159 L
.67021 .43811 L
.65334 .4241 L
.63691 .40958 L
.62094 .39456 L
.60544 .37906 L
.59042 .36309 L
.5759 .34666 L
.56189 .32979 L
.54841 .3125 L
.53547 .2948 L
.52308 .27672 L
.51125 .25825 L
.5 .23944 L
.5 .23944 L
.48875 .25825 L
.47692 .27672 L
.46453 .2948 L
.45159 .3125 L
.43811 .32979 L
.4241 .34666 L
.40958 .36309 L
.39456 .37906 L
.37906 .39456 L
.36309 .40958 L
.34666 .4241 L
.32979 .43811 L
.3125 .45159 L
.2948 .46453 L
.27672 .47692 L
.25825 .48875 L
.23944 .5 L
.23944 .5 L
.25825 .51125 L
.27672 .52308 L
.2948 .53547 L
.3125 .54841 L
.32979 .56189 L
.34666 .5759 L
.36309 .59042 L
.37906 .60544 L
.39456 .62094 L
.40958 .63691 L
.4241 .65334 L
.43811 .67021 L
.45159 .6875 L
.46453 .7052 L
.47692 .72328 L
.48875 .74175 L
.5 .76056 L
F
.5 .23944 m
.5057 .22938 L
.51124 .21922 L
.51661 .20898 L
.52181 .19866 L
.52685 .18825 L
.53171 .17776 L
.53641 .16719 L
.54093 .15654 L
.54528 .14583 L
.54945 .13505 L
.55345 .12419 L
.55727 .11328 L
.56091 .10231 L
.56438 .09127 L
.56766 .08019 L
.57077 .06905 L
.57369 .05786 L
.57369 .05786 L
.58106 .0641 L
.5892 .06929 L
.59798 .07333 L
.60722 .07615 L
.61675 .07769 L
.62641 .07792 L
.63601 .07685 L
.64537 .07448 L
.65433 .07087 L
.66272 .06608 L
.66272 .06608 L
.66396 .07674 L
.66633 .08722 L
.66978 .09739 L
.67429 .10713 L
.67979 .11635 L
.68624 .12494 L
.69356 .1328 L
.70167 .13984 L
.71048 .14598 L
.71988 .15117 L
.72978 .15533 L
.72978 .15533 L
.71478 .16734 L
.69915 .17851 L
.68294 .18883 L
.6662 .19825 L
.64898 .20676 L
.63132 .21433 L
.61328 .22093 L
.59491 .22655 L
.57626 .23117 L
.55739 .23478 L
.53835 .23737 L
.5192 .23892 L
.5 .23944 L
F
.72978 .84467 m
.71988 .84883 L
.71048 .85402 L
.70167 .86016 L
.69356 .8672 L
.68624 .87506 L
.67979 .88365 L
.67429 .89287 L
.66978 .90261 L
.66633 .91278 L
.66396 .92326 L
.66272 .93392 L
.66272 .93392 L
.65433 .92913 L
.64537 .92552 L
.63601 .92315 L
.62641 .92208 L
.61675 .92231 L
.60722 .92385 L
.59798 .92667 L
.5892 .93071 L
.58106 .9359 L
.57369 .94214 L
.57369 .94214 L
.57077 .93095 L
.56766 .91981 L
.56438 .90873 L
.56091 .89769 L
.55727 .88672 L
.55345 .87581 L
.54945 .86495 L
.54528 .85417 L
.54093 .84346 L
.53641 .83281 L
.53171 .82224 L
.52685 .81175 L
.52181 .80134 L
.51661 .79102 L
.51124 .78078 L
.5057 .77062 L
.5 .76056 L
.5 .76056 L
.5192 .76108 L
.53835 .76263 L
.55739 .76522 L
.57626 .76883 L
.59491 .77345 L
.61328 .77907 L
.63132 .78567 L
.64898 .79324 L
.6662 .80175 L
.68294 .81117 L
.69915 .82149 L
.71478 .83266 L
.72978 .84467 L
F
.84467 .27022 m
.83266 .28522 L
.82149 .30085 L
.81117 .31706 L
.80175 .3338 L
.79324 .35102 L
.78567 .36868 L
.77907 .38672 L
.77345 .40509 L
.76883 .42374 L
.76522 .44261 L
.76263 .46165 L
.76108 .4808 L
.76056 .5 L
.76056 .5 L
.74175 .48875 L
.72328 .47692 L
.7052 .46453 L
.6875 .45159 L
.67021 .43811 L
.65334 .4241 L
.63691 .40958 L
.62094 .39456 L
.60544 .37906 L
.59042 .36309 L
.5759 .34666 L
.56189 .32979 L
.54841 .3125 L
.53547 .2948 L
.52308 .27672 L
.51125 .25825 L
.5 .23944 L
.5 .23944 L
.5192 .23892 L
.53835 .23737 L
.55739 .23478 L
.57626 .23117 L
.59491 .22655 L
.61328 .22093 L
.63132 .21433 L
.64898 .20676 L
.6662 .19825 L
.68294 .18883 L
.69915 .17851 L
.71478 .16734 L
.72978 .15533 L
.72978 .15533 L
.73341 .17062 L
.73871 .18541 L
.7456 .19953 L
.75401 .2128 L
.76382 .22507 L
.77493 .23618 L
.7872 .24599 L
.80047 .2544 L
.81459 .26129 L
.82938 .26659 L
.84467 .27022 L
F
.72978 .84467 m
.71478 .83266 L
.69915 .82149 L
.68294 .81117 L
.6662 .80175 L
.64898 .79324 L
.63132 .78567 L
.61328 .77907 L
.59491 .77345 L
.57626 .76883 L
.55739 .76522 L
.53835 .76263 L
.5192 .76108 L
.5 .76056 L
.5 .76056 L
.51125 .74175 L
.52308 .72328 L
.53547 .7052 L
.54841 .6875 L
.56189 .67021 L
.5759 .65334 L
.59042 .63691 L
.60544 .62094 L
.62094 .60544 L
.63691 .59042 L
.65334 .5759 L
.67021 .56189 L
.6875 .54841 L
.7052 .53547 L
.72328 .52308 L
.74175 .51125 L
.76056 .5 L
.76056 .5 L
.76108 .5192 L
.76263 .53835 L
.76522 .55739 L
.76883 .57626 L
.77345 .59491 L
.77907 .61328 L
.78567 .63132 L
.79324 .64898 L
.80175 .6662 L
.81117 .68294 L
.82149 .69915 L
.83266 .71478 L
.84467 .72978 L
.84467 .72978 L
.82938 .73341 L
.81459 .73871 L
.80047 .7456 L
.7872 .75401 L
.77493 .76382 L
.76382 .77493 L
.75401 .7872 L
.7456 .80047 L
.73871 .81459 L
.73341 .82938 L
.72978 .84467 L
F
.72978 .15533 m
.73789 .15788 L
.74619 .15973 L
.75462 .16089 L
.76311 .16134 L
.77161 .16107 L
.78006 .1601 L
.7884 .15842 L
.79657 .15606 L
.80451 .15301 L
.81218 .14932 L
.8195 .145 L
.8195 .145 L
.82018 .15045 L
.82166 .15575 L
.82389 .16077 L
.82683 .16541 L
.83043 .16957 L
.83459 .17317 L
.83923 .17611 L
.84425 .17834 L
.84955 .17982 L
.855 .1805 L
.855 .1805 L
.85068 .18782 L
.84699 .19549 L
.84394 .20343 L
.84158 .2116 L
.8399 .21994 L
.83893 .22839 L
.83866 .23689 L
.83911 .24538 L
.84027 .25381 L
.84212 .26211 L
.84467 .27022 L
.84467 .27022 L
.82938 .26659 L
.81459 .26129 L
.80047 .2544 L
.7872 .24599 L
.77493 .23618 L
.76382 .22507 L
.75401 .2128 L
.7456 .19953 L
.73871 .18541 L
.73341 .17062 L
.72978 .15533 L
F
.84467 .72978 m
.84212 .73789 L
.84027 .74619 L
.83911 .75462 L
.83866 .76311 L
.83893 .77161 L
.8399 .78006 L
.84158 .7884 L
.84394 .79657 L
.84699 .80451 L
.85068 .81218 L
.855 .8195 L
.855 .8195 L
.84955 .82018 L
.84425 .82166 L
.83923 .82389 L
.83459 .82683 L
.83043 .83043 L
.82683 .83459 L
.82389 .83923 L
.82166 .84425 L
.82018 .84955 L
.8195 .855 L
.8195 .855 L
.81218 .85068 L
.80451 .84699 L
.79657 .84394 L
.7884 .84158 L
.78006 .8399 L
.77161 .83893 L
.76311 .83866 L
.75462 .83911 L
.74619 .84027 L
.73789 .84212 L
.72978 .84467 L
.72978 .84467 L
.73341 .82938 L
.73871 .81459 L
.7456 .80047 L
.75401 .7872 L
.76382 .77493 L
.77493 .76382 L
.7872 .75401 L
.80047 .7456 L
.81459 .73871 L
.82938 .73341 L
.84467 .72978 L
F
.84467 .27022 m
.84883 .28012 L
.85402 .28952 L
.86016 .29833 L
.8672 .30644 L
.87506 .31376 L
.88365 .32021 L
.89287 .32571 L
.90261 .33022 L
.91278 .33367 L
.92326 .33604 L
.93392 .33728 L
.93392 .33728 L
.92913 .34567 L
.92552 .35463 L
.92315 .36399 L
.92208 .37359 L
.92231 .38325 L
.92385 .39278 L
.92667 .40202 L
.93071 .4108 L
.9359 .41894 L
.94214 .42631 L
.94214 .42631 L
.93095 .42923 L
.91981 .43234 L
.90873 .43562 L
.89769 .43909 L
.88672 .44273 L
.87581 .44655 L
.86495 .45055 L
.85417 .45472 L
.84346 .45907 L
.83281 .46359 L
.82224 .46829 L
.81175 .47315 L
.80134 .47819 L
.79102 .48339 L
.78078 .48876 L
.77062 .4943 L
.76056 .5 L
.76056 .5 L
.76108 .4808 L
.76263 .46165 L
.76522 .44261 L
.76883 .42374 L
.77345 .40509 L
.77907 .38672 L
.78567 .36868 L
.79324 .35102 L
.80175 .3338 L
.81117 .31706 L
.82149 .30085 L
.83266 .28522 L
.84467 .27022 L
F
.76056 .5 m
.77062 .5057 L
.78078 .51124 L
.79102 .51661 L
.80134 .52181 L
.81175 .52685 L
.82224 .53171 L
.83281 .53641 L
.84346 .54093 L
.85417 .54528 L
.86495 .54945 L
.87581 .55345 L
.88672 .55727 L
.89769 .56091 L
.90873 .56438 L
.91981 .56766 L
.93095 .57077 L
.94214 .57369 L
.94214 .57369 L
.9359 .58106 L
.93071 .5892 L
.92667 .59798 L
.92385 .60722 L
.92231 .61675 L
.92208 .62641 L
.92315 .63601 L
.92552 .64537 L
.92913 .65433 L
.93392 .66272 L
.93392 .66272 L
.92326 .66396 L
.91278 .66633 L
.90261 .66978 L
.89287 .67429 L
.88365 .67979 L
.87506 .68624 L
.8672 .69356 L
.86016 .70167 L
.85402 .71048 L
.84883 .71988 L
.84467 .72978 L
.84467 .72978 L
.83266 .71478 L
.82149 .69915 L
.81117 .68294 L
.80175 .6662 L
.79324 .64898 L
.78567 .63132 L
.77907 .61328 L
.77345 .59491 L
.76883 .57626 L
.76522 .55739 L
.76263 .53835 L
.76108 .5192 L
.76056 .5 L
F
0 g
.27022 .15533 m
.28522 .16734 L
.30085 .17851 L
.31706 .18883 L
.3338 .19825 L
.35102 .20676 L
.36868 .21433 L
.38672 .22093 L
.40509 .22655 L
.42374 .23117 L
.44261 .23478 L
.46165 .23737 L
.4808 .23892 L
.5 .23944 L
.5 .23944 L
.48875 .25825 L
.47692 .27672 L
.46453 .2948 L
.45159 .3125 L
.43811 .32979 L
.4241 .34666 L
.40958 .36309 L
.39456 .37906 L
.37906 .39456 L
.36309 .40958 L
.34666 .4241 L
.32979 .43811 L
.3125 .45159 L
.2948 .46453 L
.27672 .47692 L
.25825 .48875 L
.23944 .5 L
.23944 .5 L
.23892 .4808 L
.23737 .46165 L
.23478 .44261 L
.23117 .42374 L
.22655 .40509 L
.22093 .38672 L
.21433 .36868 L
.20676 .35102 L
.19825 .3338 L
.18883 .31706 L
.17851 .30085 L
.16734 .28522 L
.15533 .27022 L
.15533 .27022 L
.17062 .26659 L
.18541 .26129 L
.19953 .2544 L
.2128 .24599 L
.22507 .23618 L
.23618 .22507 L
.24599 .2128 L
.2544 .19953 L
.26129 .18541 L
.26659 .17062 L
.27022 .15533 L
F
.15533 .72978 m
.16734 .71478 L
.17851 .69915 L
.18883 .68294 L
.19825 .6662 L
.20676 .64898 L
.21433 .63132 L
.22093 .61328 L
.22655 .59491 L
.23117 .57626 L
.23478 .55739 L
.23737 .53835 L
.23892 .5192 L
.23944 .5 L
.23944 .5 L
.25825 .51125 L
.27672 .52308 L
.2948 .53547 L
.3125 .54841 L
.32979 .56189 L
.34666 .5759 L
.36309 .59042 L
.37906 .60544 L
.39456 .62094 L
.40958 .63691 L
.4241 .65334 L
.43811 .67021 L
.45159 .6875 L
.46453 .7052 L
.47692 .72328 L
.48875 .74175 L
.5 .76056 L
.5 .76056 L
.4808 .76108 L
.46165 .76263 L
.44261 .76522 L
.42374 .76883 L
.40509 .77345 L
.38672 .77907 L
.36868 .78567 L
.35102 .79324 L
.3338 .80175 L
.31706 .81117 L
.30085 .82149 L
.28522 .83266 L
.27022 .84467 L
.27022 .84467 L
.26659 .82938 L
.26129 .81459 L
.2544 .80047 L
.24599 .7872 L
.23618 .77493 L
.22507 .76382 L
.2128 .75401 L
.19953 .7456 L
.18541 .73871 L
.17062 .73341 L
.15533 .72978 L
F
.5 .76056 m
.51125 .74175 L
.52308 .72328 L
.53547 .7052 L
.54841 .6875 L
.56189 .67021 L
.5759 .65334 L
.59042 .63691 L
.60544 .62094 L
.62094 .60544 L
.63691 .59042 L
.65334 .5759 L
.67021 .56189 L
.6875 .54841 L
.7052 .53547 L
.72328 .52308 L
.74175 .51125 L
.76056 .5 L
.76056 .5 L
.74175 .48875 L
.72328 .47692 L
.7052 .46453 L
.6875 .45159 L
.67021 .43811 L
.65334 .4241 L
.63691 .40958 L
.62094 .39456 L
.60544 .37906 L
.59042 .36309 L
.5759 .34666 L
.56189 .32979 L
.54841 .3125 L
.53547 .2948 L
.52308 .27672 L
.51125 .25825 L
.5 .23944 L
.5 .23944 L
.48875 .25825 L
.47692 .27672 L
.46453 .2948 L
.45159 .3125 L
.43811 .32979 L
.4241 .34666 L
.40958 .36309 L
.39456 .37906 L
.37906 .39456 L
.36309 .40958 L
.34666 .4241 L
.32979 .43811 L
.3125 .45159 L
.2948 .46453 L
.27672 .47692 L
.25825 .48875 L
.23944 .5 L
.23944 .5 L
.25825 .51125 L
.27672 .52308 L
.2948 .53547 L
.3125 .54841 L
.32979 .56189 L
.34666 .5759 L
.36309 .59042 L
.37906 .60544 L
.39456 .62094 L
.40958 .63691 L
.4241 .65334 L
.43811 .67021 L
.45159 .6875 L
.46453 .7052 L
.47692 .72328 L
.48875 .74175 L
.5 .76056 L
F
.84467 .27022 m
.83266 .28522 L
.82149 .30085 L
.81117 .31706 L
.80175 .3338 L
.79324 .35102 L
.78567 .36868 L
.77907 .38672 L
.77345 .40509 L
.76883 .42374 L
.76522 .44261 L
.76263 .46165 L
.76108 .4808 L
.76056 .5 L
.76056 .5 L
.74175 .48875 L
.72328 .47692 L
.7052 .46453 L
.6875 .45159 L
.67021 .43811 L
.65334 .4241 L
.63691 .40958 L
.62094 .39456 L
.60544 .37906 L
.59042 .36309 L
.5759 .34666 L
.56189 .32979 L
.54841 .3125 L
.53547 .2948 L
.52308 .27672 L
.51125 .25825 L
.5 .23944 L
.5 .23944 L
.5192 .23892 L
.53835 .23737 L
.55739 .23478 L
.57626 .23117 L
.59491 .22655 L
.61328 .22093 L
.63132 .21433 L
.64898 .20676 L
.6662 .19825 L
.68294 .18883 L
.69915 .17851 L
.71478 .16734 L
.72978 .15533 L
.72978 .15533 L
.73341 .17062 L
.73871 .18541 L
.7456 .19953 L
.75401 .2128 L
.76382 .22507 L
.77493 .23618 L
.7872 .24599 L
.80047 .2544 L
.81459 .26129 L
.82938 .26659 L
.84467 .27022 L
F
.72978 .84467 m
.71478 .83266 L
.69915 .82149 L
.68294 .81117 L
.6662 .80175 L
.64898 .79324 L
.63132 .78567 L
.61328 .77907 L
.59491 .77345 L
.57626 .76883 L
.55739 .76522 L
.53835 .76263 L
.5192 .76108 L
.5 .76056 L
.5 .76056 L
.51125 .74175 L
.52308 .72328 L
.53547 .7052 L
.54841 .6875 L
.56189 .67021 L
.5759 .65334 L
.59042 .63691 L
.60544 .62094 L
.62094 .60544 L
.63691 .59042 L
.65334 .5759 L
.67021 .56189 L
.6875 .54841 L
.7052 .53547 L
.72328 .52308 L
.74175 .51125 L
.76056 .5 L
.76056 .5 L
.76108 .5192 L
.76263 .53835 L
.76522 .55739 L
.76883 .57626 L
.77345 .59491 L
.77907 .61328 L
.78567 .63132 L
.79324 .64898 L
.80175 .6662 L
.81117 .68294 L
.82149 .69915 L
.83266 .71478 L
.84467 .72978 L
.84467 .72978 L
.82938 .73341 L
.81459 .73871 L
.80047 .7456 L
.7872 .75401 L
.77493 .76382 L
.76382 .77493 L
.75401 .7872 L
.7456 .80047 L
.73871 .81459 L
.73341 .82938 L
.72978 .84467 L
F
1 g
.5 .76056 m
.51125 .74175 L
.52308 .72328 L
.53547 .7052 L
.54841 .6875 L
.56189 .67021 L
.5759 .65334 L
.59042 .63691 L
.60544 .62094 L
.62094 .60544 L
.63691 .59042 L
.65334 .5759 L
.67021 .56189 L
.6875 .54841 L
.7052 .53547 L
.72328 .52308 L
.74175 .51125 L
.76056 .5 L
.76056 .5 L
.74175 .48875 L
.72328 .47692 L
.7052 .46453 L
.6875 .45159 L
.67021 .43811 L
.65334 .4241 L
.63691 .40958 L
.62094 .39456 L
.60544 .37906 L
.59042 .36309 L
.5759 .34666 L
.56189 .32979 L
.54841 .3125 L
.53547 .2948 L
.52308 .27672 L
.51125 .25825 L
.5 .23944 L
.5 .23944 L
.48875 .25825 L
.47692 .27672 L
.46453 .2948 L
.45159 .3125 L
.43811 .32979 L
.4241 .34666 L
.40958 .36309 L
.39456 .37906 L
.37906 .39456 L
.36309 .40958 L
.34666 .4241 L
.32979 .43811 L
.3125 .45159 L
.2948 .46453 L
.27672 .47692 L
.25825 .48875 L
.23944 .5 L
.23944 .5 L
.25825 .51125 L
.27672 .52308 L
.2948 .53547 L
.3125 .54841 L
.32979 .56189 L
.34666 .5759 L
.36309 .59042 L
.37906 .60544 L
.39456 .62094 L
.40958 .63691 L
.4241 .65334 L
.43811 .67021 L
.45159 .6875 L
.46453 .7052 L
.47692 .72328 L
.48875 .74175 L
.5 .76056 L
F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0c6K<06HcIS?<c3=V003oIP1Voooo0:BTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0VFJIofHc<c?<VC<co`3o<`1Vc?ooEIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0IVJIc01V<c?<
IS<cc03o0;jn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0<fJIVFH0o`0coc<cV@3<oiUV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T006JIIVH0c3?<03<cIP3<c6Hc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVFKoofJI<fH0VC>Ioc<c<`3<V@1V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoc6JI06H0IS>Ic3<c003<IS?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoVFIVofH0<c>I
VC<0o`3<<`2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoIVIVc6H003>IIS<0c03<0000omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKo<fIVVC?ooc>I<`0cIP0cc3<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko06IVIS?oc3>I03<0IP2Ic?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFK<ofIV<c?oVC=Voc<0<`2IVOl00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<c6IV03?oIS=V
c3<0002II_mV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<VFHcoc?o<c=VV@3oojZZZ_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<IVHcc3?o03=VIP3oc02I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVIT0ofK<<fHcVC?<oc=V<`3oV@2I00000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@0006h000?o0000?`000ol0001]0000I`000ol0000200Co
?`04o`<000?o0000I`0006L02_lN0003o`0001`02OmY0000I`0;oa/01OlK00[oJ@0006L03?lI00Oo
6@0<ofP0001V00ko5`09oaL03OmX0000IP0@oa<03OlC013oI`0006D04_l@017o400BofH0001T01Co
3@0Eo`d05?mU0000D`000ol0000=01Wo1`0Jo`H000?o0?l05Ol@0003o`000580001B00?o3@0Go`80
:Ol201Oo3@02oe@0001B00Co300Eo`@0:?l601Co00<0o`002@04oe<0001A00So1003o`<04_l602So
1`0Bo`801?l400OoD`0005403ol500oo1`0Xo`P03ol4013oDP0004l04Ol800Oo3@0Wo`h01ol601;o
D00004/05OlL02Ko700Eodd0001<01Co700Voad05?m=0000C00Coah09OlM01?oCP0004`04olN02Co
7P0Codh0001<01?o7P0Toal04_m>0000C@0Aob008olO01;oCP0004d04OlP02;o8@0@odl0000n0003
o`0000`04?lQ02;o8@0@odl0000n00?o300@ob808OlQ013o3@03ocl0000m00Co300@ob808?lS00oo
3005och0000j00So2`0?ob<08?lT00ko3008oc/0000h00_o2`0=obD07olT00ko2`0:ocX0000h00co
2P0=obD07_lV00co2`0<ocT0000g00ko2@0<obH07_lW00_o2P0=ocT0000g00oo200;obP07OlX00[o
2@0>ocT0000g00oo200:obT07?lZ00Wo200@ocP0000f017o1`09obX07?l[00So200@ocP0000f01;o
1P08ob`06ol/00Oo1`0BocL0000e01Co1@06obh06_l_00Go1P0DocH0000/0003o`0000H05_l300Co
<00Joc401?l301Ko00<0o`00<`0002/02?l501Co00<0ool00_lb01Wo<P03o`805Ol300So;@0002X0
2Ol701Go=00HocL04ol600Wo;00002X02Ol9013o00<0o`00=00HocP04?l800[o:`0002X02Ol>00Ko
1P02ocD05ole0003o`0000D01_l>00So;00002X02?lK00?o=@0EocD00olK00Oo;00002X01olK00Go
=00DocD01?lL00Ko;00002X01_lL00Oo<P0Doc<01_lM00Go;00002X01OlM00Wo<@0Coc402OlM00Co
;00002X00olN00_o<00Boc402_lO00?o:`0004/03Ol^01;o;`0<odd0000Y0003o`0001l03_l^017o
;P0>ob4000?o0000:00002P00_lP013o;@0@obh03olP00?o:@0002H01OlO01;o:`0@ob`04OlP00Go
9`0002<02?lO01Go:@0?obT05OlN00Wo900002402_lN01So:00=obP05olN00[o8`0002402olM01[o
9P0<obL06OlN00_o8P0002402olM01_o9P0;obH06olL00co8P0002003OlK01ko900:obD07_lK00co
8P0002003OlJ02;o8P09ob808_lI00ko8@0001l03_lI02Go8@07ob409OlH00oo800001h03olH02Wo
7P06oal0:OlG013o7`0001h03olG02go7005oad0;?lF00oo800001l03olE037o6@04oa/0<?lE00oo
800002403OlD03Ko5@04oaL0=OlC00ko8P0002803?lC03co4@03oa40??lB00go8`0002<02olB04?o
30000ol0000;04;o4@0<ob@0000T00[o4@2Qoa002olU00009@09oa00DOl00`3oo`1?o`l02_lV0000
9`07o`h0D_l205?o3@08obP0000X00Ko3@1Co`<0Dol=00Ko:@0002T01?l=05?o101Do``01OlZ0000
:@04o`X0E_l505Ko2@04ob/0000Z00?o1`1Ho`H0FOl600Co:`0001H00_lC00;o101Ko`L0Fol300?o
4`000ol0000F00005P06oa0000?o0?l0G?l905go00<0o`003`05oaP0000F00co1`03o`030?oo05_o
2`1Qo`L02olH00005P0Fo`80Fol=05_o0P0FoaL0000E01Ko101Io`h0F_l301Ko5`0001D05_l505So
3`1Ho`@05olF00004`0Ho`D0EolA05Ko1P0Hoa@0000A01Wo1`1Eoa80E_l701Wo4P0001406?l905Co
4`1Do`P06OlB00004P0Go`T0DolD05?o2P0Goa<0000C01Go2`1BoaD0D_l;01Go500001<05?l<057o
5`1@o`d04olE00004`0Co`h0ColI04oo3P0BoaD0000D017o401=oa/0COl@017o5@0001@04?lB04_o
701<oa803olF0000500>oa@0BolM04[o5@0=oaH0000D00co5`19oal0BOlG00_o5P0001@02olH04So
8@17oaT02_lF00005009oaX0AolS04Ko7008oaD0000C00Oo7P15ob@0A_lN00Ko5@0001<01OlP04Go
9@14ob801?lD0000>@13obL0@olj00004P000ol0000U047o:@11oc/0000B00;o9P10ob/0?olW00;o
4`0001001?lW03ko;00oobH01OlA00003`06obH0?_l]03go9`06oa00000>00Oo9`0lobl0??lV00So
3`0000`02_lV03_o<@0jobL02_l=0000200>obH0>_lc03Wo9P0>o`X0000900go9`0hocD0>?lV00go
2`0000T03OlW03Oo=`0fobL03Ol;00002@0=obP0=Oli03Go9`0=o`/0000900go:00doc/0<olX00ko
2P0000P03_lX03?o?@0bobP03_l:0000200>obT0<Olo037o:00?o`T0000800ko:@0`od40;olZ00ko
2@0000T03?l[02ko@`0^obX03Ol:00002P0;ob/0;Om502co:`0<o`/0000;00[o:`0/odL0:ol[00_o
300000`02Ol/02[oB@0Zob/02_l=00003@08ob`0:Om;02So;@08o`h0000=00Oo;@0Xodd09ol^00Ko
3`0000h01Ol^02KoD@0Uobh01_l?00003`04obl09?mC02Co;`04oa00000@00;o<00SoeD08_l`00?o
4@0001000_l`02;oE`0Qoc4000?o00004000010000?o0000;`0Poe/07om400004003obl07omM01ko
<@000ol0000@00004@05ob`07_mO01go;@05oa80000A00Wo:@0Lof407?lZ00Oo4`0001403?lV01[o
I@0IobP02_lC00004@0?ob<06OmW01So9@0=oa<0000A01;o800HofT05olR013o4`0001405OlM01Oo
J`0Foal04olC00004@0Hoa/05?m_01Co700Foa<0000A01_o600Cog404_lJ01[o4P0001007_lF01;o
L`0AoaL07OlB0000400OoaD04Ome013o5P0Noa80000@02;o4P0?ogT03_lC02;o4@0000l09ol>00go
O@0<oa009OlA00003`0Yo``03?mo00_o3@0Yoa00000>02_o2`0:oh<02Ol<02[o400000h0;Ol900Wo
Q@08o`X0;Ol?00003@0`o`L02?n700Oo200`o`h0000<03;o1P07ohT01_l703;o3@0000/0=_l300Go
S@04o`D0=?l=00002`0ho`040?oooi400_l203So300000T0??nF03_o2P0000X0>Ol00`3oo`2C0003
o`0003Wo2`0000X0>?l200CoS`03o`<0=ol<00002`0eo`@01_n;00Go1P0do``0000<037o1`08ohL0
1ol8037o3@0000d0;ol800WoQ@08o`T0;ol>00003@0]o`X02_n300Wo2`0/o`l0000>02[o300;oh40
2_l=02[o3`0000h0:Ol=00goO@0<o`h0:?l@00003`0Vo`l03omi00ko4@0Uoa00000?02;o4`0@ogL0
3olD027o4@0001007_lF01;oL`0AoaL07_lA0000400MoaL04oma01;o600Loa80000A01[o6@0Dofl0
4olK01Wo4P0001405olL01GoK@0Eoad05OlC00004@0Doah06?mY01Oo800Boa<0000A017o8@0IofL0
6?lS00oo4`0001403_lT01[oI@0IobH03?lC00004@0;obL06omS01[o:@09oa<0000A00So:P0Moel0
7?l/00Ko4`0001401?l^01koG@0Nobh00olC00004@000ol0000^023oF`0Ood@0000@0003o`0002l0
8OmI023oA00001000_l`02?oE@0Roc4000?o0000400001000_l`02CoD`0Soc000olA00003`04obl0
9OmA02Go;`04oa00000>00Go;P0Wodl09_l^00Go400000h01_l]02SoC@0Wobh01_l?00003@08ob`0
:Om;02So;@08o`h0000<00Wo;00ZodT0:_l[00[o3@0000/02_l[02coA`0[ob/02ol<00002P0;ob/0
;Om502co:`0<o`/0000900co:`0^od<0;_lZ00go2P0000L03olY033o@@0_obX03ol80000200>obT0
<Olo033o:@0?o`T0000800ko:@0bocd0<_lX00ko2P0000T03OlX03Co>`0cobP03_l:00002@0=obP0
=Oli03Co:00=o`/0000900go:00focL0=_lW00go2`0000T03OlW03So=@0gobL03Ol;0000200>obL0
>?ld03Wo9P0>o`X0000<00[o9P0joc<0>OlW00[o3@0000h01olW03_o<@0jobL02?l?00003`06obL0
??l_03co9P07oa00000@00Go9P0nobd0?OlW00Go4@0001400olW03ko;00oobH00olC00004P02obH0
@?l[043o9P02oa<0000B0003o`0002@0@_lY047o>`0001<01_lP04?o9`13ob401OlD00004`08oad0
AOlU04Co7P07oaD0000C00_o6P15ob@0A_lK00Wo5@0001@03?lG04Oo8`16oaP03?lE0000500=oaH0
B?lQ04Oo5`0<oaH0000D00oo5019oal0BOlD00ko5P0001@04?lB04_o7@1:oa<03olF0000500Aoa40
BolL04co4@0AoaD0000C01?o3`1=oa/0COl?01;o5@0001<05?l=04oo6@1?o`d04olE00004`0Eo`/0
DOlG053o300Eoa@0000B01Ko2`1BoaD0D_l:01Oo4`0001406?l905?o501Do`T06?lB00004@0Ho`P0
EOlC05Co200Ioa80000C01Oo1`1Foa40E_l701Oo500001D05_l505Oo401Ho`D05_lF00005@0Fo`@0
FOl?05Wo0`0FoaL0000F01Ko0P1Jo`h0Fol201Ko5`0001H02ol900;o00<0ool0F_l=05oo2@0:oaP0
000F00Go501Ko`/0Fol20003o`0000l01?lH00005P000ol0000B00;o1@1Io`T0FOl500;o;00002X0
0ol805Oo1`1Go`L00ol/0000:P03o`/0E?l605Go2P04ob/0000Y00Co3P1Bo`D0D_l=00Go:P0002P0
1Ol?057o101Bo`h01_lY00009P08o`l0DOl3057o3`08obL0000U00Wo401@o`80DOl?00[o9P0002@0
2_lA053o00<0ool0C_l@00_o9@0002<02olB04;o7011oa403?lT00008P0<oa<0>olC0003o`000140
>olB00go8`0002003_lD03Go5`03oaP0=?lC00oo8@0001l03olE033o6P04oa`0;olD00oo8@0001l0
3olF02co7@05oah0:olF00oo800001h03olH02So7`06ob00:?lG013o7`0001l03_lI02Co8P06ob<0
9?lH00oo800002003OlI02;o9007ob@08OlI00ko8@0002003OlJ01ko9P09obH07_lI00go8P000240
3?lK01_o9`0:obP06olK00co8P0002402olM01So:@0;obT06?lL00co8P0002402olM01Oo:@0<obX0
5_lN00[o8`0002<02?lN01Go:`0=ob/05?lN00Wo900002H01OlO017o;@0?obd04OlO00Go9`0002P0
0_lP00oo;P0@obl03_lP00?o:@0002T000?o00007P0>obl04Ol_00go8002obX0000Y0003o`0001l0
3?l_01;o<00<od`0000Z00Co7@0:oc404_lb00Wo7P04ob/0000Z00Go7008oc<04_ld00Oo7@04ob`0
000Z00Ko7006oc@04old00Ko7005ob`0000Z00Oo6`05oc@05?le00Co7006ob`0000Z00So6P04ocD0
5?lf00?o6`07ob`0000Z00So3P08o`D00_lf01Go=P02o`D02?l=00So;00002X02Ol801?o=P0GocL0
4_l800Wo:`0002X02Ol601Oo<`0HocD000?o0?l04ol500Wo;00002/02?l401Go00<0ool00ola01Wo
<@04o`805_l200So;@0002`000?o00001@0Fo`<01_l_01[o<005o`@05old0000=@0Do`D01ol]01[o
;P07o`D05?lf0000=P0Bo`H02?l/01_o;007o`L04_lg0000=P0Ao`L02OlZ01co:`08o`L04Olh0000
=`0@o`L02_lY01co:P09o`P04?lh0000=`0?o`P02olX01go:00:o`T03_li0000=`0>o`T03?lV01ko
9`0;o`X03Oli0000>00<o`X03?lV01ko9P0<o`/03?li0000>00;o`/03OlU01oo9@0<o``02_lj0000
>`07o``03OlT023o900>o`/02?ll0000?@05o`/03olS023o900>o``01Oln0000?P02o`d04?lR027o
8P0?o`h00_lo0000?P000ol0000<013o8@0Rob404?m?0000C@0Aob008_lQ013oC`0004d04OlP02?o
7`0Aodl0001=017o7`0Toal04_m>0000C00Coah09?lO01;oCP0004`04olN02Go7@0Codh0001<01Co
700Voad04om>0000C00Doa`09_lL01GoC@0004l04Ol700Wo300Vo`h02Ol501;oD00005403ol4013o
200Wo`P04?l3013oDP0005402?l500;o0P0Co`H0:?l701?o00@0oooo1@07oe<0001B00Co2`0Go`<0
:?l501Oo2P04oe<0001B00?o3P0Fo`80:Ol201Ko3P02oe@0001C0003o`0000d06?l901So2@0Foa00
00?o0000DP0006@05?l>01?o3P0DofD0001U01;o4@0?oa404_mV0000IP0?oaD02olE00ooI`0006H0
3_lG00Wo5`0=ofP0001W00co6@07oaT03?mX0000I`0;oa`00olL00[oJ@0006L02_lM00;o7P09ofT0
001W0003o`0000801?lO0003o`0001d01?l30003o`0006L0001^0003o`0003h00_m_0000KP000ol0
002_0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.993321, -0.993321, 0.0069221, 
  0.0069221}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A 8-gon tessellation"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
poly8 = NGP[RegularPolygon[8, 2*Pi/3]];
grp8 = PolygonInvGroup[poly8,2]; Length[grp8]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(41\)], "Output"],

Cell["diag8 = Map[Diagonals, grp8];", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{Thickness[0.003], grp8, diag8},
\tDrawUnitCircle -> False]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.510003 0.5 0.510003 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
newpath
-0.01768 .41118 .12561 -20.7966 9.73561 arc
s
newpath
.19675 -0.23211 .6065 99.2034 103.326 arc
s
newpath
.01911 .32236 .05203 43.3257 71.6215 arc
s
newpath
.00709 .36589 .02902 11.6215 48.7373 arc
s
newpath
.00072 .39279 .02601 -11.2627 27.4121 arc
s
newpath
-0.00542 .42344 .03469 -32.5879 1.89617 arc
s
newpath
-0.01768 .5 .08882 301.896 322.333 arc
s
newpath
.01911 .19675 .25122 69.7356 82.3329 arc
s
newpath
-0.01768 .58882 .12561 -9.73561 20.7966 arc
s
newpath
.01911 .80325 .25122 277.667 290.264 arc
s
newpath
-0.01768 .5 .08882 37.6671 58.1038 arc
s
newpath
-0.00542 .57656 .03469 -1.89617 32.5879 arc
s
newpath
.00072 .60721 .02601 -27.4121 11.2627 arc
s
newpath
.00709 .63411 .02902 311.263 348.378 arc
s
newpath
.01911 .67764 .05203 288.378 316.674 arc
s
newpath
.19675 1.23211 .6065 256.674 260.797 arc
s
newpath
.01911 .30081 .10406 5.79657 39.2034 arc
s
newpath
-0.23211 .80325 .6065 301.674 305.797 arc
s
newpath
.05935 .23699 .05691 61.6743 86.7216 arc
s
newpath
.03833 .28159 .02718 26.7216 62.9723 arc
s
newpath
.02837 .30464 .02235 2.97235 42.0277 arc
s
newpath
.01911 .32799 .02718 -17.9723 18.2784 arc
s
newpath
.00244 .37439 .05691 318.278 343.326 arc
s
newpath
.19675 -0.23211 .6065 99.2034 103.326 arc
s
newpath
.01911 .69919 .10406 320.797 354.203 arc
s
newpath
.19675 1.23211 .6065 256.674 260.797 arc
s
newpath
.00244 .62561 .05691 16.6743 41.7216 arc
s
newpath
.01911 .67201 .02718 -18.2784 17.9723 arc
s
newpath
.02837 .69536 .02235 317.972 357.028 arc
s
newpath
.03833 .71841 .02718 297.028 333.278 arc
s
newpath
.05935 .76301 .05691 273.278 298.326 arc
s
newpath
-0.23211 .19675 .6065 54.2034 58.3257 arc
s
newpath
-0.05447 .37439 .25122 30 50.2644 arc
s
newpath
-0.05447 .62561 .25122 309.736 330 arc
s
newpath
.01911 .19675 .25122 69.7356 82.3329 arc
s
newpath
-0.00807 .42079 .06562 22.3329 53.0071 arc
s
newpath
-0.01137 .47845 .0431 -6.99287 30 arc
s
newpath
-0.01137 .52155 .0431 -30 6.99287 arc
s
newpath
-0.00807 .57921 .06562 306.993 337.667 arc
s
newpath
.01911 .80325 .25122 277.667 290.264 arc
s
newpath
.07114 .19675 .12561 35.2644 65.7966 arc
s
newpath
-0.05447 .37439 .25122 322.667 335.264 arc
s
newpath
.13395 .13395 .08882 82.6671 103.104 arc
s
newpath
.08848 .19675 .03469 43.1038 77.588 arc
s
newpath
.07114 .22277 .02601 17.5879 56.2627 arc
s
newpath
.05663 .24629 .02902 -3.73727 33.3785 arc
s
newpath
.03435 .28557 .05203 -26.6215 1.67428 arc
s
newpath
-0.23211 .80325 .6065 301.674 305.797 arc
s
newpath
.07114 .80325 .12561 294.203 324.736 arc
s
newpath
-0.23211 .19675 .6065 54.2034 58.3257 arc
s
newpath
.03435 .71443 .05203 -1.67428 26.6215 arc
s
newpath
.05663 .75371 .02902 -33.3785 3.73727 arc
s
newpath
.07114 .77723 .02601 303.737 342.412 arc
s
newpath
.08848 .80325 .03469 282.412 316.896 arc
s
newpath
.13395 .86605 .08882 256.896 277.333 arc
s
newpath
-0.05447 .62561 .25122 24.7356 37.3329 arc
s
newpath
.01911 .19675 .25122 -5.26439 15 arc
s
newpath
.37439 -0.05447 .25122 114.736 127.333 arc
s
newpath
.19675 .08473 .06562 67.3329 98.0071 arc
s
newpath
.15365 .12317 .0431 38.0071 75 arc
s
newpath
.12317 .15365 .0431 15 51.9929 arc
s
newpath
.08473 .19675 .06562 -8.00713 22.6671 arc
s
newpath
-0.05447 .37439 .25122 322.667 335.264 arc
s
newpath
.19675 .01911 .25122 75 95.2644 arc
s
newpath
.01911 .80325 .25122 -15 5.26439 arc
s
newpath
.19675 .98089 .25122 264.736 285 arc
s
newpath
-0.05447 .62561 .25122 24.7356 37.3329 arc
s
newpath
.08473 .80325 .06562 -22.6671 8.00713 arc
s
newpath
.12317 .84635 .0431 308.007 345 arc
s
newpath
.15365 .87683 .0431 285 321.993 arc
s
newpath
.19675 .91527 .06562 261.993 292.667 arc
s
newpath
.37439 1.05447 .25122 232.667 245.264 arc
s
newpath
-0.23211 .19675 .6065 15 30 arc
s
.29313 .5 m
.16309 .5 L
s
newpath
-0.05447 .62561 .25122 309.736 330 arc
s
newpath
-0.01768 .41118 .12561 -20.7966 9.73561 arc
s
newpath
.01911 .30081 .10406 5.79657 39.2034 arc
s
newpath
.07114 .19675 .12561 35.2644 65.7966 arc
s
newpath
.19675 .01911 .25122 75 95.2644 arc
s
.26177 .26177 m
.35372 .35372 L
s
newpath
-0.23211 .80325 .6065 330 345 arc
s
.35372 .64628 m
.26177 .73823 L
s
newpath
.19675 .98089 .25122 264.736 285 arc
s
newpath
.07114 .80325 .12561 294.203 324.736 arc
s
newpath
.01911 .69919 .10406 320.797 354.203 arc
s
newpath
-0.01768 .58882 .12561 -9.73561 20.7966 arc
s
newpath
-0.05447 .37439 .25122 30 50.2644 arc
s
.16309 .5 m
.29313 .5 L
s
newpath
.19675 .07114 .12561 24.2034 54.7356 arc
s
newpath
.80325 -0.23211 .6065 144.203 148.326 arc
s
newpath
.28557 .03435 .05203 88.3257 116.622 arc
s
newpath
.24629 .05663 .02902 56.6215 93.7373 arc
s
newpath
.22277 .07114 .02601 33.7373 72.412 arc
s
newpath
.19675 .08848 .03469 12.4121 46.8962 arc
s
newpath
.13395 .13395 .08882 -13.1038 7.33289 arc
s
newpath
.37439 -0.05447 .25122 114.736 127.333 arc
s
newpath
.19675 .92886 .12561 305.264 335.797 arc
s
newpath
.37439 1.05447 .25122 232.667 245.264 arc
s
newpath
.13395 .86605 .08882 -7.33289 13.1038 arc
s
newpath
.19675 .91152 .03469 313.104 347.588 arc
s
newpath
.22277 .92886 .02601 287.588 326.263 arc
s
newpath
.24629 .94337 .02902 266.263 303.378 arc
s
newpath
.28557 .96565 .05203 243.378 271.674 arc
s
newpath
.80325 1.23211 .6065 211.674 215.797 arc
s
newpath
.30081 .01911 .10406 50.7966 84.2034 arc
s
newpath
-0.23211 .19675 .6065 346.674 350.797 arc
s
newpath
.37439 .00244 .05691 106.674 131.722 arc
s
newpath
.32799 .01911 .02718 71.7216 107.972 arc
s
newpath
.30464 .02837 .02235 47.9723 87.0276 arc
s
newpath
.28159 .03833 .02718 27.0277 63.2784 arc
s
newpath
.23699 .05935 .05691 3.27844 28.3257 arc
s
newpath
.80325 -0.23211 .6065 144.203 148.326 arc
s
newpath
.30081 .98089 .10406 275.797 309.203 arc
s
newpath
.80325 1.23211 .6065 211.674 215.797 arc
s
newpath
.23699 .94065 .05691 331.674 356.722 arc
s
newpath
.28159 .96167 .02718 296.722 332.972 arc
s
newpath
.30464 .97163 .02235 272.972 312.028 arc
s
newpath
.32799 .98089 .02718 252.028 288.278 arc
s
newpath
.37439 .99756 .05691 228.278 253.326 arc
s
newpath
-0.23211 .80325 .6065 9.20343 13.3257 arc
s
.5 .29313 m
.5 .16309 L
s
newpath
.62561 -0.05447 .25122 120 140.264 arc
s
newpath
.41118 -0.01768 .12561 80.2644 110.797 arc
s
newpath
.30081 .01911 .10406 50.7966 84.2034 arc
s
newpath
.19675 .07114 .12561 24.2034 54.7356 arc
s
newpath
.01911 .19675 .25122 -5.26439 15 arc
s
.26177 .26177 m
.35372 .35372 L
s
newpath
.19675 -0.23211 .6065 60 75 arc
s
.5 .83691 m
.5 .70687 L
s
newpath
.19675 1.23211 .6065 285 300 arc
s
.35372 .64628 m
.26177 .73823 L
s
newpath
.01911 .80325 .25122 -15 5.26439 arc
s
newpath
.19675 .92886 .12561 305.264 335.797 arc
s
newpath
.30081 .98089 .10406 275.797 309.203 arc
s
newpath
.41118 1.01768 .12561 249.203 279.736 arc
s
newpath
.62561 1.05447 .25122 219.736 240 arc
s
newpath
.41118 -0.01768 .12561 80.2644 110.797 arc
s
newpath
.19675 .01911 .25122 7.66711 20.2644 arc
s
newpath
.5 -0.01768 .08882 127.667 148.104 arc
s
newpath
.42344 -0.00542 .03469 88.1038 122.588 arc
s
newpath
.39279 .00072 .02601 62.5879 101.263 arc
s
newpath
.36589 .00709 .02902 41.2627 78.3785 arc
s
newpath
.32236 .01911 .05203 18.3785 46.6743 arc
s
newpath
-0.23211 .19675 .6065 346.674 350.797 arc
s
newpath
.41118 1.01768 .12561 249.203 279.736 arc
s
newpath
-0.23211 .80325 .6065 9.20343 13.3257 arc
s
newpath
.32236 .98089 .05203 313.326 341.622 arc
s
newpath
.36589 .99291 .02902 281.622 318.737 arc
s
newpath
.39279 .99928 .02601 258.737 297.412 arc
s
newpath
.42344 1.00542 .03469 237.412 271.896 arc
s
newpath
.5 1.01768 .08882 211.896 232.333 arc
s
newpath
.19675 .98089 .25122 339.736 352.333 arc
s
newpath
.37439 -0.05447 .25122 39.7356 60 arc
s
newpath
.80325 .01911 .25122 159.736 172.333 arc
s
newpath
.57921 -0.00807 .06562 112.333 143.007 arc
s
newpath
.52155 -0.01137 .0431 83.0071 120 arc
s
newpath
.47845 -0.01137 .0431 60 96.9929 arc
s
newpath
.42079 -0.00807 .06562 36.9929 67.6671 arc
s
newpath
.19675 .01911 .25122 7.66711 20.2644 arc
s
newpath
.62561 -0.05447 .25122 120 140.264 arc
s
newpath
1.23211 .80325 .6065 195 210 arc
s
newpath
1.23211 .19675 .6065 150 165 arc
s
newpath
.80325 -0.23211 .6065 105 120 arc
s
newpath
.19675 -0.23211 .6065 60 75 arc
s
newpath
-0.23211 .19675 .6065 15 30 arc
s
newpath
-0.23211 .80325 .6065 330 345 arc
s
newpath
.19675 1.23211 .6065 285 300 arc
s
newpath
.80325 1.23211 .6065 240 255 arc
s
newpath
.37439 1.05447 .25122 300 320.264 arc
s
newpath
.62561 1.05447 .25122 219.736 240 arc
s
newpath
.19675 .98089 .25122 339.736 352.333 arc
s
newpath
.42079 1.00807 .06562 292.333 323.007 arc
s
newpath
.47845 1.01137 .0431 263.007 300 arc
s
newpath
.52155 1.01137 .0431 240 276.993 arc
s
newpath
.57921 1.00807 .06562 216.993 247.667 arc
s
newpath
.80325 .98089 .25122 187.667 200.264 arc
s
newpath
.58882 -0.01768 .12561 69.2034 99.7356 arc
s
newpath
1.23211 .19675 .6065 189.203 193.326 arc
s
newpath
.67764 .01911 .05203 133.326 161.622 arc
s
newpath
.63411 .00709 .02902 101.622 138.737 arc
s
newpath
.60721 .00072 .02601 78.7373 117.412 arc
s
newpath
.57656 -0.00542 .03469 57.4121 91.8962 arc
s
newpath
.5 -0.01768 .08882 31.8962 52.3329 arc
s
newpath
.80325 .01911 .25122 159.736 172.333 arc
s
newpath
.58882 1.01768 .12561 260.264 290.797 arc
s
newpath
.80325 .98089 .25122 187.667 200.264 arc
s
newpath
.5 1.01768 .08882 307.667 328.104 arc
s
newpath
.57656 1.00542 .03469 268.104 302.588 arc
s
newpath
.60721 .99928 .02601 242.588 281.263 arc
s
newpath
.63411 .99291 .02902 221.263 258.378 arc
s
newpath
.67764 .98089 .05203 198.378 226.674 arc
s
newpath
1.23211 .80325 .6065 166.674 170.797 arc
s
.64628 .35372 m
.73823 .26177 L
s
newpath
.98089 .19675 .25122 165 185.264 arc
s
newpath
.80325 .07114 .12561 125.264 155.797 arc
s
newpath
.69919 .01911 .10406 95.7966 129.203 arc
s
newpath
.58882 -0.01768 .12561 69.2034 99.7356 arc
s
newpath
.37439 -0.05447 .25122 39.7356 60 arc
s
.5 .16309 m
.5 .29313 L
s
newpath
.80325 -0.23211 .6065 105 120 arc
s
.73823 .73823 m
.64628 .64628 L
s
newpath
.80325 1.23211 .6065 240 255 arc
s
.5 .70687 m
.5 .83691 L
s
newpath
.37439 1.05447 .25122 300 320.264 arc
s
newpath
.58882 1.01768 .12561 260.264 290.797 arc
s
newpath
.69919 .98089 .10406 230.797 264.203 arc
s
newpath
.80325 .92886 .12561 204.203 234.736 arc
s
newpath
.98089 .80325 .25122 174.736 195 arc
s
newpath
.69919 .01911 .10406 95.7966 129.203 arc
s
newpath
.19675 -0.23211 .6065 31.6743 35.7966 arc
s
newpath
.76301 .05935 .05691 151.674 176.722 arc
s
newpath
.71841 .03833 .02718 116.722 152.972 arc
s
newpath
.69536 .02837 .02235 92.9724 132.028 arc
s
newpath
.67201 .01911 .02718 72.0276 108.278 arc
s
newpath
.62561 .00244 .05691 48.2784 73.3257 arc
s
newpath
1.23211 .19675 .6065 189.203 193.326 arc
s
newpath
.69919 .98089 .10406 230.797 264.203 arc
s
newpath
1.23211 .80325 .6065 166.674 170.797 arc
s
newpath
.62561 .99756 .05691 286.674 311.722 arc
s
newpath
.67201 .98089 .02718 251.722 287.972 arc
s
newpath
.69536 .97163 .02235 227.972 267.028 arc
s
newpath
.71841 .96167 .02718 207.028 243.278 arc
s
newpath
.76301 .94065 .05691 183.278 208.326 arc
s
newpath
.19675 1.23211 .6065 324.203 328.326 arc
s
newpath
.80325 .07114 .12561 125.264 155.797 arc
s
newpath
.62561 -0.05447 .25122 52.6671 65.2644 arc
s
newpath
.86605 .13395 .08882 172.667 193.104 arc
s
newpath
.80325 .08848 .03469 133.104 167.588 arc
s
newpath
.77723 .07114 .02601 107.588 146.263 arc
s
newpath
.75371 .05663 .02902 86.2627 123.378 arc
s
newpath
.71443 .03435 .05203 63.3785 91.6743 arc
s
newpath
.19675 -0.23211 .6065 31.6743 35.7966 arc
s
newpath
.80325 .92886 .12561 204.203 234.736 arc
s
newpath
.19675 1.23211 .6065 324.203 328.326 arc
s
newpath
.71443 .96565 .05203 268.326 296.622 arc
s
newpath
.75371 .94337 .02902 236.622 273.737 arc
s
newpath
.77723 .92886 .02601 213.737 252.412 arc
s
newpath
.80325 .91152 .03469 192.412 226.896 arc
s
newpath
.86605 .86605 .08882 166.896 187.333 arc
s
newpath
.62561 1.05447 .25122 294.736 307.333 arc
s
.70687 .5 m
.83691 .5 L
s
newpath
1.05447 .62561 .25122 210 230.264 arc
s
newpath
1.01768 .41118 .12561 170.264 200.797 arc
s
newpath
.98089 .30081 .10406 140.797 174.203 arc
s
newpath
.92886 .19675 .12561 114.203 144.736 arc
s
newpath
.80325 .01911 .25122 84.7356 105 arc
s
.73823 .26177 m
.64628 .35372 L
s
newpath
1.23211 .19675 .6065 150 165 arc
s
.83691 .5 m
.70687 .5 L
s
newpath
1.23211 .80325 .6065 195 210 arc
s
.64628 .64628 m
.73823 .73823 L
s
newpath
.80325 .98089 .25122 255 275.264 arc
s
newpath
.92886 .80325 .12561 215.264 245.797 arc
s
newpath
.98089 .69919 .10406 185.797 219.203 arc
s
newpath
1.01768 .58882 .12561 159.203 189.736 arc
s
newpath
1.05447 .37439 .25122 129.736 150 arc
s
newpath
.80325 .01911 .25122 84.7356 105 arc
s
newpath
1.05447 .37439 .25122 204.736 217.333 arc
s
newpath
.91527 .19675 .06562 157.333 188.007 arc
s
newpath
.87683 .15365 .0431 128.007 165 arc
s
newpath
.84635 .12317 .0431 105 141.993 arc
s
newpath
.80325 .08473 .06562 81.9929 112.667 arc
s
newpath
.62561 -0.05447 .25122 52.6671 65.2644 arc
s
newpath
.98089 .19675 .25122 165 185.264 arc
s
newpath
.80325 .98089 .25122 255 275.264 arc
s
newpath
.98089 .80325 .25122 174.736 195 arc
s
newpath
.62561 1.05447 .25122 294.736 307.333 arc
s
newpath
.80325 .91527 .06562 247.333 278.007 arc
s
newpath
.84635 .87683 .0431 218.007 255 arc
s
newpath
.87683 .84635 .0431 195 231.993 arc
s
newpath
.91527 .80325 .06562 171.993 202.667 arc
s
newpath
1.05447 .62561 .25122 142.667 155.264 arc
s
newpath
.92886 .19675 .12561 114.203 144.736 arc
s
newpath
1.23211 .80325 .6065 234.203 238.326 arc
s
newpath
.96565 .28557 .05203 178.326 206.622 arc
s
newpath
.94337 .24629 .02902 146.622 183.737 arc
s
newpath
.92886 .22277 .02601 123.737 162.412 arc
s
newpath
.91152 .19675 .03469 102.412 136.896 arc
s
newpath
.86605 .13395 .08882 76.8962 97.3329 arc
s
newpath
1.05447 .37439 .25122 204.736 217.333 arc
s
newpath
.92886 .80325 .12561 215.264 245.797 arc
s
newpath
1.05447 .62561 .25122 142.667 155.264 arc
s
newpath
.86605 .86605 .08882 262.667 283.104 arc
s
newpath
.91152 .80325 .03469 223.104 257.588 arc
s
newpath
.92886 .77723 .02601 197.588 236.263 arc
s
newpath
.94337 .75371 .02902 176.263 213.378 arc
s
newpath
.96565 .71443 .05203 153.378 181.674 arc
s
newpath
1.23211 .19675 .6065 121.674 125.797 arc
s
newpath
1.05447 .37439 .25122 129.736 150 arc
s
newpath
.98089 .80325 .25122 249.736 262.333 arc
s
newpath
1.00807 .57921 .06562 202.333 233.007 arc
s
newpath
1.01137 .52155 .0431 173.007 210 arc
s
newpath
1.01137 .47845 .0431 150 186.993 arc
s
newpath
1.00807 .42079 .06562 126.993 157.667 arc
s
newpath
.98089 .19675 .25122 97.6671 110.264 arc
s
newpath
1.05447 .62561 .25122 210 230.264 arc
s
newpath
.98089 .30081 .10406 140.797 174.203 arc
s
newpath
.80325 -0.23211 .6065 76.6743 80.7966 arc
s
newpath
.99756 .37439 .05691 196.674 221.722 arc
s
newpath
.98089 .32799 .02718 161.722 197.972 arc
s
newpath
.97163 .30464 .02235 137.972 177.028 arc
s
newpath
.96167 .28159 .02718 117.028 153.278 arc
s
newpath
.94065 .23699 .05691 93.2784 118.326 arc
s
newpath
1.23211 .80325 .6065 234.203 238.326 arc
s
newpath
.98089 .69919 .10406 185.797 219.203 arc
s
newpath
1.23211 .19675 .6065 121.674 125.797 arc
s
newpath
.94065 .76301 .05691 241.674 266.722 arc
s
newpath
.96167 .71841 .02718 206.722 242.972 arc
s
newpath
.97163 .69536 .02235 182.972 222.028 arc
s
newpath
.98089 .67201 .02718 162.028 198.278 arc
s
newpath
.99756 .62561 .05691 138.278 163.326 arc
s
newpath
.80325 1.23211 .6065 279.203 283.326 arc
s
newpath
1.01768 .41118 .12561 170.264 200.797 arc
s
newpath
.98089 .19675 .25122 97.6671 110.264 arc
s
newpath
1.01768 .5 .08882 217.667 238.104 arc
s
newpath
1.00542 .42344 .03469 178.104 212.588 arc
s
newpath
.99928 .39279 .02601 152.588 191.263 arc
s
newpath
.99291 .36589 .02902 131.263 168.378 arc
s
newpath
.98089 .32236 .05203 108.378 136.674 arc
s
newpath
.80325 -0.23211 .6065 76.6743 80.7966 arc
s
newpath
1.01768 .58882 .12561 159.203 189.736 arc
s
newpath
.80325 1.23211 .6065 279.203 283.326 arc
s
newpath
.98089 .67764 .05203 223.326 251.622 arc
s
newpath
.99291 .63411 .02902 191.622 228.737 arc
s
newpath
.99928 .60721 .02601 168.737 207.412 arc
s
newpath
1.00542 .57656 .03469 147.412 181.896 arc
s
newpath
1.01768 .5 .08882 121.896 142.333 arc
s
newpath
.98089 .80325 .25122 249.736 262.333 arc
s
newpath
-0.05447 .62561 .25122 288.737 309.736 arc
s
newpath
.01911 .30081 .10406 39.2034 87.412 arc
s
newpath
.00244 .37439 .05691 -16.6743 61.8962 arc
s
newpath
-0.00807 .42079 .06562 -48.3785 22.3329 arc
s
newpath
.01911 .69919 .10406 272.588 320.797 arc
s
newpath
-0.05447 .37439 .25122 50.2644 71.2627 arc
s
newpath
-0.00807 .57921 .06562 -22.3329 48.3785 arc
s
newpath
.00244 .62561 .05691 -61.8962 16.6743 arc
s
newpath
-0.01768 .41118 .12561 302.972 339.203 arc
s
newpath
.07114 .19675 .12561 65.7966 102.028 arc
s
newpath
.03435 .28557 .05203 1.67428 78.2784 arc
s
newpath
.01911 .32236 .05203 -33.2784 43.3257 arc
s
newpath
.07114 .80325 .12561 257.972 294.203 arc
s
newpath
-0.01768 .58882 .12561 20.7966 57.0277 arc
s
newpath
.01911 .67764 .05203 -43.3257 33.2784 arc
s
newpath
.03435 .71443 .05203 281.722 358.326 arc
s
newpath
-0.01768 .58882 .12561 293.007 350.264 arc
s
.16309 .5 m
.02596 .5 L
s
newpath
-0.01768 .41118 .12561 9.73561 66.9929 arc
s
newpath
-0.01768 .5 .08882 -37.6671 37.6671 arc
s
newpath
.01911 .30081 .10406 -42.4121 5.79657 arc
s
newpath
.19675 .01911 .25122 95.2644 116.263 arc
s
newpath
.08473 .19675 .06562 22.6671 93.3785 arc
s
newpath
.05935 .23699 .05691 -16.8962 61.6743 arc
s
newpath
.19675 .98089 .25122 243.737 264.736 arc
s
newpath
.01911 .69919 .10406 -5.79657 42.4121 arc
s
newpath
.05935 .76301 .05691 -61.6743 16.8962 arc
s
newpath
.08473 .80325 .06562 266.622 337.333 arc
s
.26177 .26177 m
.1648 .1648 L
s
newpath
.19675 .07114 .12561 54.7356 111.993 arc
s
newpath
.13395 .13395 .08882 7.33289 82.6671 arc
s
newpath
.07114 .19675 .12561 -21.9929 35.2644 arc
s
newpath
.19675 .92886 .12561 248.007 305.264 arc
s
.26177 .73823 m
.1648 .8352 L
s
newpath
.07114 .80325 .12561 -35.2644 21.9929 arc
s
newpath
.13395 .86605 .08882 277.333 352.667 arc
s
newpath
.19675 -0.23211 .6065 75 99.2034 arc
s
newpath
-0.23211 .80325 .6065 305.797 330 arc
s
newpath
-0.05447 .37439 .25122 -24.7356 30 arc
s
newpath
.01911 .19675 .25122 15 69.7356 arc
s
newpath
-0.23211 .19675 .6065 30 54.2034 arc
s
newpath
.19675 1.23211 .6065 260.797 285 arc
s
newpath
.01911 .80325 .25122 290.264 345 arc
s
newpath
-0.05447 .62561 .25122 -30 24.7356 arc
s
newpath
.01911 .19675 .25122 333.737 354.736 arc
s
newpath
.30081 .01911 .10406 84.2034 132.412 arc
s
newpath
.23699 .05935 .05691 28.3257 106.896 arc
s
newpath
.19675 .08473 .06562 -3.37848 67.3329 arc
s
newpath
.30081 .98089 .10406 227.588 275.797 arc
s
newpath
.01911 .80325 .25122 5.26439 26.2627 arc
s
newpath
.19675 .91527 .06562 -67.3329 3.37848 arc
s
newpath
.23699 .94065 .05691 253.104 331.674 arc
s
newpath
.19675 .07114 .12561 -12.0276 24.2034 arc
s
newpath
.41118 -0.01768 .12561 110.797 147.028 arc
s
newpath
.32236 .01911 .05203 46.6743 123.278 arc
s
newpath
.28557 .03435 .05203 11.7216 88.3257 arc
s
newpath
.41118 1.01768 .12561 212.972 249.203 arc
s
newpath
.19675 .92886 .12561 -24.2034 12.0276 arc
s
newpath
.28557 .96565 .05203 271.674 348.278 arc
s
newpath
.32236 .98089 .05203 236.722 313.326 arc
s
newpath
.80325 -0.23211 .6065 120 144.203 arc
s
newpath
.37439 -0.05447 .25122 60 114.736 arc
s
newpath
.19675 .01911 .25122 20.2644 75 arc
s
newpath
-0.23211 .19675 .6065 -9.20343 15 arc
s
newpath
.37439 1.05447 .25122 245.264 300 arc
s
newpath
.80325 1.23211 .6065 215.797 240 arc
s
newpath
-0.23211 .80325 .6065 -15 9.20343 arc
s
newpath
.19675 .98089 .25122 285 339.736 arc
s
newpath
.30081 .01911 .10406 2.58795 50.7966 arc
s
newpath
.62561 -0.05447 .25122 140.264 161.263 arc
s
newpath
.42079 -0.00807 .06562 67.6671 138.378 arc
s
newpath
.37439 .00244 .05691 28.1038 106.674 arc
s
newpath
.62561 1.05447 .25122 198.737 219.736 arc
s
newpath
.30081 .98089 .10406 309.203 357.412 arc
s
newpath
.37439 .99756 .05691 253.326 331.896 arc
s
newpath
.42079 1.00807 .06562 221.622 292.333 arc
s
.5 .16309 m
.5 .02596 L
s
newpath
.58882 -0.01768 .12561 99.7356 156.993 arc
s
newpath
.5 -0.01768 .08882 52.3329 127.667 arc
s
newpath
.41118 -0.01768 .12561 23.0071 80.2644 arc
s
.64628 .64628 m
.35372 .35372 L
s
.70687 .5 m
.29313 .5 L
s
.64628 .35372 m
.35372 .64628 L
s
.5 .29313 m
.5 .70687 L
s
newpath
.58882 1.01768 .12561 203.007 260.264 arc
s
.5 .83691 m
.5 .97404 L
s
newpath
.41118 1.01768 .12561 279.736 336.993 arc
s
newpath
.5 1.01768 .08882 232.333 307.667 arc
s
newpath
.37439 -0.05447 .25122 18.7373 39.7356 arc
s
newpath
.69919 .01911 .10406 129.203 177.412 arc
s
newpath
.62561 .00244 .05691 73.3257 151.896 arc
s
newpath
.57921 -0.00807 .06562 41.6215 112.333 arc
s
newpath
.69919 .98089 .10406 182.588 230.797 arc
s
newpath
.37439 1.05447 .25122 320.264 341.263 arc
s
newpath
.57921 1.00807 .06562 247.667 318.378 arc
s
newpath
.62561 .99756 .05691 208.104 286.674 arc
s
newpath
1.23211 .19675 .6065 165 189.203 arc
s
newpath
.80325 .01911 .25122 105 159.736 arc
s
newpath
.62561 -0.05447 .25122 65.2644 120 arc
s
newpath
.19675 -0.23211 .6065 35.7966 60 arc
s
newpath
.80325 .98089 .25122 200.264 255 arc
s
newpath
1.23211 .80325 .6065 170.797 195 arc
s
newpath
.19675 1.23211 .6065 300 324.203 arc
s
newpath
.62561 1.05447 .25122 240 294.736 arc
s
newpath
.58882 -0.01768 .12561 32.9723 69.2034 arc
s
newpath
.80325 .07114 .12561 155.797 192.028 arc
s
newpath
.71443 .03435 .05203 91.6743 168.278 arc
s
newpath
.67764 .01911 .05203 56.7216 133.326 arc
s
newpath
.80325 .92886 .12561 167.972 204.203 arc
s
newpath
.58882 1.01768 .12561 290.797 327.028 arc
s
newpath
.67764 .98089 .05203 226.674 303.278 arc
s
newpath
.71443 .96565 .05203 191.722 268.326 arc
s
newpath
.69919 .01911 .10406 47.5879 95.7966 arc
s
newpath
.98089 .19675 .25122 185.264 206.263 arc
s
newpath
.80325 .08473 .06562 112.667 183.378 arc
s
newpath
.76301 .05935 .05691 73.1038 151.674 arc
s
newpath
.98089 .80325 .25122 153.737 174.736 arc
s
newpath
.69919 .98089 .10406 264.203 312.412 arc
s
newpath
.76301 .94065 .05691 208.326 286.896 arc
s
newpath
.80325 .91527 .06562 176.622 247.333 arc
s
newpath
1.23211 .80325 .6065 210 234.203 arc
s
newpath
1.05447 .37439 .25122 150 204.736 arc
s
newpath
.98089 .19675 .25122 110.264 165 arc
s
newpath
.80325 -0.23211 .6065 80.7966 105 arc
s
newpath
1.05447 .62561 .25122 155.264 210 arc
s
newpath
1.23211 .19675 .6065 125.797 150 arc
s
newpath
.80325 1.23211 .6065 255 279.203 arc
s
newpath
.98089 .80325 .25122 195 249.736 arc
s
.73823 .26177 m
.8352 .1648 L
s
newpath
.92886 .19675 .12561 144.736 201.993 arc
s
newpath
.86605 .13395 .08882 97.3329 172.667 arc
s
newpath
.80325 .07114 .12561 68.0071 125.264 arc
s
newpath
.92886 .80325 .12561 158.007 215.264 arc
s
.73823 .73823 m
.8352 .8352 L
s
newpath
.80325 .92886 .12561 234.736 291.993 arc
s
newpath
.86605 .86605 .08882 187.333 262.667 arc
s
newpath
.80325 .01911 .25122 63.7373 84.7356 arc
s
newpath
.98089 .30081 .10406 174.203 222.412 arc
s
newpath
.94065 .23699 .05691 118.326 196.896 arc
s
newpath
.91527 .19675 .06562 86.6215 157.333 arc
s
newpath
.98089 .69919 .10406 137.588 185.797 arc
s
newpath
.80325 .98089 .25122 275.264 296.263 arc
s
newpath
.91527 .80325 .06562 202.667 273.378 arc
s
newpath
.94065 .76301 .05691 163.104 241.674 arc
s
.83691 .5 m
.97404 .5 L
s
newpath
1.01768 .58882 .12561 189.736 246.993 arc
s
newpath
1.01768 .5 .08882 142.333 217.667 arc
s
newpath
1.01768 .41118 .12561 113.007 170.264 arc
s
newpath
.92886 .19675 .12561 77.9724 114.203 arc
s
newpath
1.01768 .41118 .12561 200.797 237.028 arc
s
newpath
.98089 .32236 .05203 136.674 213.278 arc
s
newpath
.96565 .28557 .05203 101.722 178.326 arc
s
newpath
1.01768 .58882 .12561 122.972 159.203 arc
s
newpath
.92886 .80325 .12561 245.797 282.028 arc
s
newpath
.96565 .71443 .05203 181.674 258.278 arc
s
newpath
.98089 .67764 .05203 146.722 223.326 arc
s
newpath
.98089 .30081 .10406 92.588 140.797 arc
s
newpath
1.05447 .62561 .25122 230.264 251.263 arc
s
newpath
1.00807 .42079 .06562 157.667 228.378 arc
s
newpath
.99756 .37439 .05691 118.104 196.674 arc
s
newpath
1.05447 .37439 .25122 108.737 129.736 arc
s
newpath
.98089 .69919 .10406 219.203 267.412 arc
s
newpath
.99756 .62561 .05691 163.326 241.896 arc
s
newpath
1.00807 .57921 .06562 131.622 202.333 arc
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016PP10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIYT0c6K<06HcIS?<c3=V003oIP1Voooo0:BTY3/k>oo<VOlcolco<laVVIWooiVI
<iT0VFJIofHc<c?<VC<co`3o<`1Vc?ooEIfMWC@d=?o<I_lcc<co0<aVIYWoc9VI09T0IVJIc01V<c?<
IS<cc03o0;jn__oooiJFURd];Oo<<olcVLc<olaV<iWoVIUVoiT0<fJIVFH0o`0coc<cV@3<oiUV<oWi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIYUVc9T006JIIVH0c3?<03<cIP3<c6Hc0?;blXV9RB0P8?nIoolc
<lc<VL`coiWo<iUVVFKoofJI<fH0VC>Ioc<c<`3<V@1V0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo09UV
IVKoc6JI06H0IS>Ic3<c003<IS?<<nGUiGalO1<C4onIVOl0olc<<l`cVIW<o`1VIVKoVFIVofH0<c>I
VC<0o`3<<`2IomoOggIfMPd=3OnIIP0c<lc<0<`cIYW<c9UV06KoIVIVc6H003>IIS<0c03<0000omSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VITcofKo<fIVVC?ooc>I<`0cIP0cc3<0VM;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IYTcc6Ko06IVIS?oc3>I03<0IP2Ic?l0c<_;bf9RH_ooVOmVool0<lbIVL`0oiW<<iTc
VFK<ofIV<c?oVC=Voc<0<`2IVOl00<C4a5]KFoooI_mVc00c0<bII/`0c9W<09TcIVK<c6IV03?oIS=V
c3<0002II_mV001VV@00VOoo<omVVLcoolbI<l`0VIVIoiTc<fK<VFHcoc?o<c=VV@3oojZZZ_oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc9Tc06K<IVHcc3?o03=VIP3oc02I<eEEEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVIT0ofK<<fHcVC?<oc=V<`3oV@2I00000?l06`000?l06`000?l06`000?l06`000?l0
6`000?l06`000?l06`0007001?lb00?oL@0006`01?l0103o0003oa@00olE00?o00<0o`001?m]0000
J`000ol0o`030003o`0000<000?o00002P07o`030?l000Oo3002o`@000Oo0000o`3o06`0001X00?o
0P001Ol0003o00@00_l<0003o`0000D000?o00001@000ol0000:00;o10001Ol0003o00800omY0000
J002o`@000Co003o0`001?l00?l:0003o`3o00H000?o000010000ol0o`0:0004o`00o`<000Co003o
1002ofT0001W0004o`00o`<000?o0?l00`000ol000020003o`0000H000Co003o1P000ol000040004
o`00o`P000?o00000P001ol0003o0?l00`001?l00?mX0000F@03o`040?ooo`L000Go0000o`0300;o
0P000ol000040003o`0000<00_l40003o`0000<000?o00000`000ol0000200;o1@000ol000040003
o`0000;o0`001Ol0003o00L00ol200;oFP0005L00ol20005o`3o0?l01@000ol0000300Go00<0o`00
1`02o`030?oo00L000?o00000P000ol000020003o`0000D00_l00`3oo`080005o`3oo`000_l50003
o`0000<000Co0?l00_l00`3oo`02oeL0001E00;o0`001?l00?l30003o`00008000?o00001P03o`X0
0_l:0005o`000?l00`000ol0000800?o2@04o`L000?o00000P001Ol0003o008000?o00000P000ol0
001D0000E@02o`<000Co003o1002o`030?l000L00ol00`3oo`0500?o00<0ool02@001Ol0003o00<0
00?o00001`02o`800ol400Oo1`001?l0ool40004o`00o`<00_mF0000D`02o`8000Ko003o0?l600_o
00<0ool00`05o`<000Co003o2@001?l00?l20003o`0000L000Co003o1004o`<00_l200[o1P000ol0
o`020003o`0000;oE00005800_l40005o`3o0?l01002o`030?l000P000?o0?l02`001?l00004o`D0
00Co003o0P000ol0000300Co0`000ol000090003o`3o00T000Co0?oo10001Ol0o`3o00@00_mC0000
DP000ol0o`02o`800_l0103o0002o`@000?o00001P001?l00?l:0003o`0000D00_l400Go1002o`L0
00?o000020001?l00?l80003o`0000800_l20004o`3oo`<00_l00`3o001B0000DP000ol0000200So
1P000ol000060005o`000?l02@000ol0000700go2@000ol000070005o`000?l020000ol0000400Wo
0`000ol0001A0000DP000ol0000400?o2@000ol000050003o`00008000?o00001`000ol0000=0003
o`0000d000?o00001`000ol000020003o`0000D000?o00001`03o`H000?o0000D@00054000?o0000
10001Ol0o`3o00P000?o00001@000ol000030003o`0000H000?o00002`05o`d000?o00001P000ol0
00030003o`0000D000?o00001P001Ol0o`3o00H000?o0000D00004P00ol60003o`0000800_l20004
o`00o`L000?o000010000ol000040003o`0000D000?o00002`001?l00?l20003o`0000/000?o0000
1@000ol000040003o`0000@000?o00001@001?l00?l200;o10000ol0000400?oB@0004H00_l00`3o
0003o`<01Ol40005o`000?l01P000ol000030003o`0000H000?o000010000ol0000:0005o`000?l0
0`000ol0000:0003o`0000@000?o00001P000ol000030003o`0000@000Go0000o`0400Go0`03o`03
0?l000?oAP0004<00ol30003o`0000801?l80003o`0000800_l50005o`000?l02P000ol000030003
o`0000P00_l40003o`0000800_l:0003o`0000<000?o000020001Ol0003o00D00_l40003o`0000L0
0ol40003o`0000800_m40000@@02o`8000Go0000o`0600;o1`000ol0000500?o0P001?l00?l;0003
o`0000<000?o00001P02o`H000?o00001002o`P000?o00000`000ol000090004o`00o`<00_l70003
o`0000D00_l60005o`000?l00P02od80001000;o10001?l00?l50004o`00o`H000?o00002003o`80
00?o00002P001Ol0003o00L00_l80003o`0000H00_l70005o`000?l030000ol00004o`T000?o0000
10001?l00?l50004o`00o`@00_m10000@0000ol0o`030004o`00o`@000Go0000o`060003o`0000X0
0ol>0004o`00o`D00_l:0003o`0000P00_l50004o`00o`h00ol<0003o`0000@000Go0000o`040004
o`00o`<000?o0?l0@@0003l000Go0000o`030003o`3o00<000?o00000`000ol000030003o`0000X0
1Ol=0004o`3o00Co30000ol0000:00Co00@0o`3o3@05o``000?o00000`000ol000030007o`000?l0
o`030005o`000?l0@00003l000?o00000P001_l00?l0o`8000?o000010000ol000030003o`0000P0
0_l00`3o000200Go2004oa0000?o00003P04o`T01?l30004o`3oo`X000?o00000`000ol000040006
o`00o`3o0P000ol000020003o`0003h0000n0003o`0000@01?l00`3oo`080003o`00008000?o0000
1P02o`<000?o00001P08o`030?l0014000?o000040000ol0o`08o`L000Co00000_l80003o`000080
00?o00001P07o`H000?o0000?@0003d00ol700?o2`001?l00?l700;o1@000ol0000>0003o`3o0140
00?o00003`000ol0o`0@0003o`0000<00_l70004o`00o``00_l800;o?P0003d000?o00002ol:0004
o`00o`D00_l70003o`0000h000Co003o40000ol0000>0004o`00oa0000?o00001@02o`D000Co003o
2`0;o`030?l003d0000n0003o`0000D000?o0?l00P04o`L00_l200Co2@000ol0000=0003o`000080
00?o00003@000ol0000=0003o`00008000?o00003@000ol0000700Co0P02o`H01_l0103o0?l70003
o`0003d0000n0003o`0000D000?o0?l01P0;o`d000?o00003@000ol000030003o`0000`000?o0000
30000ol000030003o`0000d000?o00002`0:o`L000?o0?l01`000ol0000m0000?P000ol000040004
o`00o`h000?o00003@000ol0000=0003o`0000@000?o00002`000ol0000;0003o`0000@000?o0000
3@000ol0000=0003o`0000`000Co003o1P000ol0000m0000?P000ol000030003o`00008000?o0000
2P000ol0o`0?0003o`0000`000?o00001@02o`/000?o00002@02o`L000?o000030000ol0000=0003
o`3o00`000?o00000P000ol000030003o`0003d0000n0004o`0000;o1@000ol0000:0004o`00o`h0
00?o00002`000ol000080003o`0000P000?o000020000ol000080003o`0000/000?o000030001?l0
0?l<0003o`0000<00_l30003o`0003d0000n0004o`00o`L000?o00002@000ol000020003o`0000/0
00?o00002`000ol000090003o`0000L000?o00001`000ol000090003o`0000/000?o00002`000ol0
00020003o`0000T000?o00001@001?l00?lo0000?P03o`T000?o00001`000ol000040003o`0000X0
00?o00002P000ol0000;0003o`0000H000?o00001P000ol0000;0003o`0000X000?o00002P000ol0
00040003o`0000L000?o00001`03ocl0000m00;o2`000ol000060003o`0000D000?o00002P000ol0
000:0003o`0000`00_l60003o`0000@00_l>0003o`0000X000?o00002P000ol000050003o`0000H0
00?o00002@02och0000k00;o00<0ool02P000ol000060003o`0000H000?o00002@000ol000090003
o`0000l000?o00000`000ol000030003o`0000l000?o00002@000ol000090003o`0000H000?o0000
1P000ol0000800;o00@0oooo>`0003<02?l30003o`3o00T000?o00001@000ol000080003o`0000P0
00?o000020000ol0000A0003o`00008000?o00000P000ol0000A0003o`0000P000?o000020000ol0
00080003o`0000D000?o00001`000ol0o`0400Oo=000038000?o0?l02@000ol00002o`P000?o0000
0`000ol0000:0003o`0000L000?o00001`000ol0000C0005o`000?l00`000ol0000C0003o`0000L0
00?o00001`000ol0000:0003o`0000<000?o00001P02o`8000?o00001`000ol0o`0c0000<@001Ol0
003o00L000?o00000`000ol000050003o`00008000?o00002`000ol000070003o`0000H000?o0000
5@04o`030?oo01L000?o00001P000ol000070003o`0000/000?o00000P000ol000050003o`0000<0
00?o00001@001Ol0003o0380000_00;o10000ol000050003o`0000@00_l50005o`000?l03`02o`L0
00?o00001P000ol0000G00?o6@000ol000060003o`0000D00_l?0005o`000?l01@02o`H000?o0000
1@000ol0000200;o<00002h000?o00001@000ol000030003o`0000L00_l30004o`00oa8000?o0000
10000ol000050003o`0001H00_l00`3o0002oaP000?o00001@000ol000040003o`00010000Co003o
0`02o`T000?o00000`000ol000050003o`0002d0000^00;o1P000ol000030003o`0000T01_lC0003
o`0000D000?o000010000ol0000D00;o0`001?l00002oaH000?o000010000ol000050003o`000140
1_l;0003o`0000<000?o00001002obl0000]0004o`00o`D000?o00000`000ol0000<00;o5@000ol0
00040003o`0000<000?o00004`02o`D000?o00000`02oaD000?o00000`000ol000040003o`0001<0
0_l>0003o`0000<000?o00000`001?l00?l^0000;0000ol000020003o`00008000?o00000`000ol0
000;00;o00<0ool050000ol000030003o`00008000?o00004`000ol000050003o`0000D000?o0000
4`000ol000020003o`0000<000?o00004P02o`030?oo00d000?o00000`000ol000020003o`000080
00?o0000:`0002`000?o00000`001Ol0003o00@000?o00002P02o`030?l000800_lC0003o`000080
00Go0000o`0D00;o20000ol0000600;o50001Ol0003o00@000?o00004@02o`<000Co0?oo30000ol0
00020005o`000?l01@000ol0000[0000:`000ol000050004o`00o`<000?o00002@02o`<000?o0000
0`04oa0000Go0000o`020003o`0000l01?l:0003o`0000P01?lA0004o`00o`<000?o00003P04o`D0
00Co00000_l;0005o`000?l00P000ol000050003o`0002X0000Z00;o20001_l00?l0o`P01?l50003
o`0000L00_l?0004o`00o`8000?o00003@02o`h000?o00003002o`l000Co003o0P000ol0000=00;o
2@000ol0000300Co20000ol0o`020003o`0000H00_l[0000:P001?l0ool70004o`3oo`L00_l90003
o`0000T01_l:0003o`3o00;o2@07oa0000?o00003P07o`T00ol00`3o000900Ko2`000ol0000700;o
1`02o`030?l000H00_l00`3o000Z0000:P001?l00006o`800ol300Co2`000ol0000?00Oo0`000ol0
o`0500Ko5`000ol0000E00Ko1@000ol0o`0400Ko4@000ol0000900Co0`03o`801_l30003o`0002T0
000Z0003o`0000L02?l?0003o`0001H02olM0003o`0001/03?lG0003o`0000d02?l90003o`0002T0
000Z0003o`0000P000Co0?oo4P000ol0000I0004o`3oob4000?o00007`02o`030?l001X000?o0000
4002o`030?l000T000?o0000:@0002X000?o00001`001_l00?l0oa4000?o000060001_l00?l0ob00
00?o00007P000ol0o`020003o`0001P000?o00003`000ol0o`020003o`0000L000?o0000:@0002X0
00?o00001P001Ol0003o008000?o00003P000ol0000G0005o`000?l00P000ol0000M0003o`0001d0
00Co003o0`000ol0000G0003o`0000h000Co003o0`000ol000060003o`0002T0000Y0003o`0000D0
0_l40005o`000?l03`000ol0000F0003o`00008000Go0000o`0N0003o`0001`000Go0000o`040003
o`0001H000?o00003@001Ol0003o00@00_l70003o`0002P0000Y0004o`0000Co1P000ol000020003
o`0000`000?o00005@000ol000030003o`00008000?o00006`000ol0000K0003o`00008000?o0000
0`000ol0000E0003o`0000`000?o00000P000ol0000400Co0`000ol0000X00007`03o`L000Co0?oo
2@000ol000040003o`0000/000?o00004`02o`H000?o00000`02oa/000?o00006@02o`D000?o0000
1002oaD000?o00002`000ol000040003o`0000L00_l00`3o000700;o800001h00_l200Wo2`000ol0
00050003o`0000X000?o00004P000ol000060003o`0000D000?o000060000ol0000H0003o`0000D0
00?o00001P000ol0000B0003o`0000X000?o00001@000ol0000900[o00<0ool07`0001`00_l20003
o`0000D00_l<0003o`0000H000?o00002@000ol0000A0003o`0000H000?o00001P000ol0000H0003
o`0001P000?o00001P000ol000060003o`00014000?o00002@000ol000060003o`0000X00_l70003
o`0000?o700001X00_l40003o`0000@000Co003o2`000ol000070003o`0000P000?o00003`02o`T0
00?o00001`02oaP000?o00005P02o`T000?o00001`02oa4000?o000020000ol000070003o`0000T0
00Co003o1P000ol000030003o`0001T0000J0003o`0000<000?o000010001Ol0003o00T000?o0000
2@000ol000070003o`0000h000?o00002@000ol000090003o`0001D000?o00005@000ol000090003
o`0000T000?o00003P000ol000070003o`0000T000?o00001`001Ol0003o00H000?o00000`000ol0
000I00006@000ol0o`040003o`0000<000?o00000P000ol000070003o`0000X000?o00001P000ol0
000<00;o30000ol0000:0003o`0001@000?o000050000ol0000:0003o`0000X00_l>0003o`0000H0
00?o00002P000ol000070003o`00008000?o00000`000ol000020003o`3o01X0000I0004o`00o`<0
00?o00000P000ol000040003o`0000D000?o000030000ol000040003o`0000/00_l>0003o`0000/0
0_lD0003o`0001800_l=0003o`0000`00_l=0003o`0000@000?o000030000ol000050003o`0000@0
00?o00000P001Ol0003o008000?o0000600001P000?o00000P001?l00?l30003o`0000H000?o0000
10000ol0000=0003o`0000<000?o00002@02oa0000?o00003@000ol0000A0003o`00014000?o0000
3@000ol0000>00;o2`000ol000030003o`0000d000?o000010000ol000060005o`000?l00P000ol0
00020003o`0001L0000H00;o10001?l0o`02o`T000?o000010000ol0000>0003o`00008000?o0000
1`02oa8000?o00003P000ol0000@0003o`00010000?o00003P000ol0000@00;o2@000ol000020003
o`0000h000?o000010000ol0000700;o00@0o`3o1002oaT0000G0003o`0000?o00<0o`000_l<0003
o`0000<000?o00003`001Ol0003o00D01?lD0003o`0000l000?o00003`000ol0000?0003o`0000l0
00?o00004P04o`D000Go0000o`0A0003o`0000<000?o00002P02o`040?l000;o0P000ol0000F0000
5`000ol0000300Co3@000ol000020003o`00014000Co003o0`02oaP000?o00004002o`l000?o0000
3@02oa8000?o00005P02o`<000Co003o4`000ol000020003o`0000/01Ol40003o`0001H0000G0003
o`0000@01_l;0005o`000?l05006oaX000?o00004P02o`d000?o00002`02oa@000?o00006006oa@0
00Go0000o`0;00Oo1@000ol0000F00005P08o`030?oo00<00ol80004o`00oa@00olN0003o`0001@0
00?o00002P000ol0000:0003o`0001@000?o00007003oa@000Co003o2003o`<00_l200Oo5`0001H0
00?o00001@001?l00?l500Go0`000ol0o`0@00Go0P02oad000?o00005@000ol000090003o`0000T0
00?o00005@000ol0000K00;o0P05oa0000?o0?l01004o`D000Co003o1`000ol0000E00005`000ol0
00040004o`00o`X05_l60004o`00oa`000?o00005P000ol000080003o`0000P000?o00005P000ol0
000J0004o`00o`H05ol90004o`00o`H000?o00005P0001L000?o00000`001Ol0003o00h000?o0000
5@001Ol0003o01/000?o00005`02o`P000?o00001P02oaT000?o00006@001Ol0003o01L000?o0000
30001Ol0003o00D000?o00005P0001L000?o00000P000ol000020003o`0000/000?o0?l05P000ol0
00020003o`0001L000?o00006P02o`H000?o00001002oa`000?o00005`000ol000020003o`0001@0
00?o0?l03@000ol000020003o`00008000?o00005P0001P000Co003o1@000ol0000:0004o`00oaH0
00?o00000`000ol0000F0003o`0001`000?o00000`000ol000030003o`0001`000?o00005P000ol0
00030003o`0001@000Co003o30000ol000030004o`00oaT0000H00?o1`000ol000080003o`000080
00?o00004P000ol000050003o`0001D000?o00007@000ol000020003o`00008000?o00007@000ol0
000E0003o`0000D000?o00004P000ol000020003o`0000P000?o00001@03oaT0000G00;o2@000ol0
00070003o`0000<000?o00004P000ol000060003o`0001@000?o00007P02o`8000?o00000_lP0003
o`0001@000?o00001P000ol0000B0003o`0000<000?o00001`000ol0000700;o600001@00ol00`3o
o`080003o`0000H000?o00001@000ol0000@0003o`0000P000?o00004`000ol0000P00Go8P000ol0
000C0003o`0000P000?o000040000ol000050003o`0000H000?o00001P02o`040?oooaD0000A00?o
0`000ol00003o`D000?o00001002o`P000?o000040000ol000090003o`00018000?o00008@03ob<0
00?o00004P000ol000090003o`00010000?o00001P02o`H000?o00001002o`8000Co00000olB0000
4@000ol000030003o`0000<000?o00000P000ol000030003o`0000P000?o000040000ol0000:0003
o`00010000?o00008002o`030?l000;o8P000ol0000@0003o`0000X000?o000040000ol000080003
o`0000<000?o00000P02o`@000?o00000`000ol0000@00003`02o`030?l000<000?o000010001Ol0
003o00@000?o00002@000ol0000@0003o`0000/000?o00003`000ol0000O0005o`000?l00`000ol0
000O0003o`0000l000?o00002`000ol0000@0003o`0000T000?o00000P001Ol0003o00H000?o0000
0P001?l0ool@00003P001Ol0003o00@000?o00001@02o`040?l000;o3@000ol0000>0003o`0000d0
00?o00003P000ol0000M00;o10000ol0000200;o7`000ol0000>0003o`0000d000?o00003P000ol0
000;00;o0P001?l0ool70003o`00008000Go0000o`0?00003P02o`<000Go0000o`0900Co3`000ol0
000>0003o`0000h000?o00003@000ol0000K00;o1P000ol0000400?o70000ol0000=0003o`0000h0
00?o00003P000ol0000=00Co2@001Ol0003o00<00_l?00003@001?l00?l20004o`00o`X00olA0003
o`0000`000?o000040000ol0000<0003o`0001P00ol80003o`0000L00_lJ0003o`0000`000?o0000
40000ol0000<0003o`0000l01?l90004o`00o`8000Co003o3P0000d000Wo0000o`3o0?l02003o`04
0?l0oa0000?o000030000ol0000A0003o`0000X000?o00005`02o`/000?o00002@02oaT000?o0000
2P000ol0000A0003o`0000`000?o00003P000ol0o`0200;o20001Ol0o`3o00<000?o0000300000`0
0ol300?o1005o`@000Co003o3`000ol0000;0003o`0001<000?o00002@000ol0000F0003o`0000/0
00?o00002`000ol0000F0003o`0000T000?o00004`000ol0000;0003o`0000d000Co003o1006o`<0
0ol400;o3@0000`000?o00002_l90005o`000?l03P000ol0000;0003o`0001@000?o000020000ol0
000D00;o3P000ol0000<00;o5P000ol000080003o`0001@000?o00002`000ol0000<0005o`000?l0
2P0:o`030?l000`0000=0003o`0000800ol<0003o`0000<00_l<0003o`0000X000?o00005P000ol0
00070003o`0001800_l@0003o`0000h00olC0003o`0000L000?o00005P000ol0000:0003o`0000X0
0_l50003o`0000X00ol40003o`0000`0000=0003o`0000;o00@0o`3o2`000ol000050003o`0000T0
00?o00002@000ol0000H0003o`0000H000?o00003`03oa8000?o00004@03oa0000?o00001P000ol0
000H0003o`0000T000?o00002@000ol000050003o`0000T000Co0?l00ol00`3o000=00003@03o`<0
00Co003o2P000ol000060003o`0000T000?o000020000ol0000I0003o`0000D000?o00003003oaD0
00?o00005002o`h000?o00001@000ol0000I0003o`0000P000?o00002@000ol000060003o`0000P0
00Co003o1002o`h0000<0003o`0000@000Go0000o`090003o`0000L00_l90003o`0000L000?o0000
6`000ol000030003o`0000/00_lH0003o`0001H00ol<0003o`0000<000?o00006`000ol000070003
o`0000L00_l90003o`0000L000Go0000o`060003o`0000/0000<0003o`0000@000?o00000P000ol0
00050003o`0000X000?o00001P000ol000060003o`0001d000?o00000P000ol0000800?o6P000ol0
000I00;o2P000ol000020003o`0001d000?o00001P000ol000060003o`0000X000?o00001@000ol0
00020003o`0000@000?o00002`0000d000?o00000P000ol000030003o`0000D000?o00002P000ol0
00060003o`0000D000?o00007`001Ol0003o00P00_lM0003o`0001/00ol70005o`000?l08@000ol0
00050003o`0000H000?o00002P000ol000050003o`0000<000?o00000P000ol0000<00003P001Ol0
003o00H000?o00000`000ol0000<00;o1P000ol000050003o`00020000?o0?l00`06oal000?o0000
7P05o`<000?o0?l08P000ol000050003o`0000@00_l>0003o`0000<000?o000010001Ol0003o00l0
000?0003o`3o00L000?o00000`000ol0000>0003o`0000<000?o000010000ol0000R00;o00<0ool0
9@000ol0000S00Go90000ol000040003o`0000<000?o00003P000ol000030003o`0000D000?o0?l0
400000l000?o0?l020001Ol0003o018000?o00000`000ol000020003o`0002401OlW0003o`0002H0
1?lS0003o`00008000?o00000`000ol0000@0005o`000?l020000ol0o`0@00003`03o`P000Go0000
o`0C0003o`00008000Go0000o`0R00;o0`02obL000?o00009@02o`<00olQ0005o`000?l010000ol0
000A0005o`000?l02003oa00000>0004o`3o00Ko0P001?l00?lE0005o`000?l00P000ol0000J00Oo
10001?l00?lV0003o`0002@000Co003o1@06oa`000Co003o0`000ol0000C0004o`00o`801_l0103o
0?l?00003002o`8000?o00001@04o`030?l001D000Ko003o0?lI00Co2`001Ol0003o02D000?o0000
8`001Ol0003o00/01OlH0003o`3o008000?o000050000ol0o`03o`L000?o00000_l=00002P02o`@0
00?o00002009oa401?lC00Oo3`000ol000020003o`00028000?o00008P000ol000020003o`0000h0
1_lC00Co4@09o`X000?o00000P02o`/000090003o`0000@000?o00001`000ol0o`0700co1`000ol0
000400ko5@000ol000040003o`00024000?o00008@000ol000040003o`0001<03_l60003o`0000H0
2ol70003o`3o00T000?o000010000ol0000800002@02o`D000?o00001P001?l00?lC00ko8`000ol0
00050003o`00020000?o000080000ol000050003o`0002403olB0004o`00o`P000?o00000`02o`X0
00090003o`3o00@000?o00001@001Ol0003o01T00olX0003o`0000H000?o00007`000ol0000O0003
o`0000H000?o00009P03oaT000Go0000o`070003o`00008000?o0?l02P0000P000Go0000o`030003
o`0000@000?o00000`000ol0000D00;o00@0o`3o9`000ol000070003o`0001h000?o00007P000ol0
00070003o`0002D000Co0?l00_lF0003o`0000<000?o000010001Ol0003o00<000?o00001`0000L0
00?o00000`001?l00?l50003o`0000@000?o00004`001Ol0003o008000?o000090000ol000080003
o`0001d000?o00007@000ol000080003o`0002@000Co003o0`000ol0000C0003o`0000@000?o0000
0`001?l00?l50003o`0000H0000700?o0`001?l00?l300;o1`000ol0000B0003o`00008000Go0000
o`0T0003o`0000X000?o000070000ol0000L0003o`0000X000?o00008P001Ol0003o00@000?o0000
4P000ol0000500?o0P001?l00?l300?o200000L000?o00000ol0103oo`03o`T000?o00004@000ol0
00030003o`00008000?o00008@000ol0000;0003o`0001/000?o00006`000ol0000;0003o`000240
00?o00000P000ol000030003o`00014000?o00002005o`800_l20003o`0000H000070003o`0000<0
1?l=0003o`0000h00_l60003o`0000<000?o000080000ol0000<0003o`0001X000?o00006P000ol0
000<0003o`00020000?o00000`000ol0000400;o40000ol0000<00Co10000ol0000600001`001?l0
0007o``000?o00003002o`L000?o000010000ol0000O0003o`0000h000?o00006@000ol0000I0003
o`0000h000?o00007`000ol000040003o`0000D00_l>0003o`0000X01?l0103oool20003o`0000H0
000600Go0`02o`8000?o00002@000ol0000;0003o`0000L000?o00001@02oal000?o00003`000ol0
000H0003o`0001P000?o00003`000ol0000M00;o1`000ol000070003o`0000/000?o00002@000ol0
0002o`@01?l700001P000ol000040003o`3o00<00_l90003o`0000X000?o000020000ol000070003
o`0001/000?o00004@000ol0000G0003o`0001L000?o00004@000ol0000K0003o`0000L000?o0000
20000ol0000:0003o`0000L00_l30003o`3o00H000?o00001@0000L000?o00000P001?l00?l500;o
1`000ol000090003o`0000T000?o00001`000ol0000K0003o`00018000?o00005P000ol0000F0003
o`00018000?o00006`000ol000070003o`0000T000?o00002@000ol0000500;o1@001?l00?l40003
o`0000H000070005o`000?l010000ol000040003o`0000@000?o00001`02o``000?o000020000ol0
000J0003o`0001<000?o00005@000ol0000E0003o`0001<000?o00006P000ol000080003o`0000X0
0_l90003o`0000@000?o000010000ol000020005o`000?l0200000L000Co003o1@000ol0000500;o
10000ol0000500;o3P000ol000090003o`0001P000?o00005@000ol0000D0003o`0001@000?o0000
5@000ol0000H0003o`0000T000?o00003002o`L000?o00000P02o`L000?o00000`001?l00?l80000
2002o`H000?o00001`001Ol0003o00D00_l?0003o`0000/000?o00005`000ol0000F0003o`0001<0
00?o00004`000ol0000F0003o`0001L000?o00002`000ol0000=00;o1@001Ol0003o00T000?o0000
1002o`T0000800;o1P000ol000080005o`00o`001?lA0003o`0000/000?o00005P000ol0000H0003
o`00018000?o00004P000ol0000H0003o`0001H000?o00002`000ol0000?00Co00D0o`00o`0:0003
o`0000@00_l900002P000ol000030003o`0000T000Co0?oo5@000ol0000<0003o`0001D000?o0000
6@000ol0000A0003o`00014000?o00006@000ol0000E0003o`0000`000?o00004`02o`030?l000X0
00?o00000`000ol0000900002`001Ol0003o00`00olF0003o`0000d000?o000050000ol0000J0003
o`00010000?o000040000ol0000J0003o`0001@000?o00003@000ol0000D00?o30001Ol0003o00`0
000<0004o`00o`T00ol0103o0?lE0003o`0000h000?o00004P000ol0000L0003o`0000l000?o0000
3`000ol0000L0003o`00018000?o00003P000ol0000C0004o`3o00?o2@001?l00?l=00003@000ol0
o`0500Co10001?l00?lD0003o`0000l000?o00004@000ol0000M0003o`0000h000?o00003P000ol0
000M0003o`00014000?o00003`000ol0000B0004o`00o`@01?l50003o`3o00h0000=00So20001Ol0
003o01<000?o00003`000ol0000A0003o`0001h000?o00003@000ol0000=0003o`0001h000?o0000
4@000ol0000?0003o`00014000Go0000o`0800So3P0000h000?o00002`000ol000030003o`0000l0
00?o00004@000ol0000?0003o`00020000?o000030000ol0000<0003o`00020000?o00003`000ol0
000A0003o`0000l000?o00000`000ol0000;0003o`0000d0000>00;o30000ol000040003o`0000h0
00?o00004@000ol0000?0003o`00024000?o00002`000ol0000;0003o`00024000?o00003`000ol0
000A0003o`0000h000?o000010000ol0000:00;o3`0000d000Co003o2`000ol000050003o`0000`0
00?o00004`000ol0000=0003o`0002<000?o00002P000ol0000:0003o`0002<000?o00003@000ol0
000C0003o`0000`000?o00001@000ol000090004o`00o`h0000=0005o`000?l02P000ol000050003
o`0000`000?o000050000ol0000;0003o`0002D000?o00002@000ol000090003o`0002D000?o0000
2`000ol0000D0003o`0000`000?o00001@000ol000080005o`000?l03P0000`000?o00000P000ol0
00070003o`0000L000?o00002`000ol0000E0003o`0000X000?o00009P000ol000080003o`0000P0
00?o00009P000ol0000:0003o`0001D000?o00002`000ol000070003o`0000L000?o00000P000ol0
000;00002`000ol000030003o`0000L000?o000020000ol0000:0003o`0001H000?o000020000ol0
000X0003o`0000L000?o00001`000ol0000X0003o`0000P000?o00005P000ol0000:0003o`0000P0
00?o00001`000ol000030003o`0000X0000900;o1P000ol000060003o`0000X000?o000020000ol0
000G0003o`0000P000?o0000:@000ol000060003o`0000H000?o0000:@000ol000080003o`0001L0
00?o000020000ol0000:0003o`0000H000?o00001002o`X0000800;o20000ol000050003o`0000/0
00?o00001P000ol0000I0003o`0000H000?o0000:`000ol000050003o`0000D000?o0000:`000ol0
00060003o`0001T000?o00001P000ol0000;0003o`0000D000?o00001P02o`T000080004o`3oo`H0
00?o000010000ol0000<0003o`0000H000?o00006@000ol000060003o`0002`000?o000010000ol0
00040003o`0002`000?o00001P000ol0000I0003o`0000H000?o000030000ol000040003o`0000@0
0_l00`3o0008000020001Ol0003o00H000?o00000`000ol0000=0003o`0000@000?o00006`000ol0
00050003o`0002d000?o00000`000ol000030003o`0002d000?o00001@000ol0000K0003o`0000@0
00?o00003@000ol000030003o`0000@000Go0000o`09000020000ol000020003o`0000<000?o0000
0P000ol0000?0003o`0000<000?o000070000ol000030003o`0002l000?o00000P000ol000020003
o`0002l000?o00000`000ol0000L0003o`0000<000?o00003`000ol000020003o`0000<000?o0000
0P000ol00007000020000ol0000300;o0`001Ol0003o01<000Go0000o`0P0003o`00008000?o0000
<0001Ol0003o00<000?o0000<0000ol000020003o`0001h000Go0000o`0C0005o`000?l00`02o`D0
00?o00001`0000P000?o00001@02o`050?l00?l05@001?l00?lP0005o`000?l0=0001?l00?l20003
o`00038000Go0000o`0P0004o`00oaD000Go003o0002o`L000?o00001`0000P000?o00001`02o`80
00?o00004`000ol0o`0R0003o`3o03H000Go0?l0o`0f0003o`3o028000?o0?l05@000ol00002o`T0
00?o00001`0000P000?o00001`04oaL00_lR0003o`3o03L00olg0003o`3o02800_lG00Co2@000ol0
000700001`3oo`co200000L000?o00002@000ol0o`0G0003o`00028000?o0000=P03ocP000?o0000
8P000ol0000E0003o`3o00/000?o00001P0000P000?o00001P03o`030?l001D000?o0?l08P000ol0
o`0f0005o`3o0?l0=P000ol0o`0R0003o`3o01H000?o0?l00_l80003o`0000L000080003o`0000@0
0_l20004o`00oaD000?o0?l08P000ol0o`0e0004o`00o`8000?o0000<`000ol0o`0R0003o`3o01D0
00Co003o0P02o`H000?o00001`0000P000?o00000`000ol000020005o`000?l04`001Ol0003o0200
00Go0000o`0c0005o`000?l00`000ol0000a0005o`000?l080001Ol0003o01<000Go0000o`040003
o`0000<000?o00001`0000P000?o00000P000ol000030003o`00008000?o00003`000ol000020003
o`0001d000?o00000`000ol0000_0003o`00008000?o00000P000ol0000_0003o`0000<000?o0000
7@000ol000020003o`0000l000?o00000P000ol000030003o`00008000?o00001`0000P000?o0000
0_l60003o`00008000?o00003`000ol000030003o`0001/000?o000010000ol0000^0003o`0000<0
00?o00000`000ol0000^0003o`0000@000?o00006`000ol000030003o`0000l000?o00000P000ol0
000400;o0P000ol0000700002003o`P000?o00000`000ol0000=0003o`0000@000?o00006`000ol0
00050003o`0002`000?o000010000ol000040003o`0002`000?o00001@000ol0000K0003o`0000@0
00?o00003@000ol000030003o`0000H00ol900002002o`P000?o000010000ol0000<0003o`0000H0
00?o00006@000ol000060003o`0002/000?o00001@000ol000050003o`0002/000?o00001P000ol0
000I0003o`0000H000?o000030000ol000040003o`0000H00_l900002P000ol000050003o`0000D0
00?o00002P000ol000080003o`0001P000?o00001`000ol0000Y0003o`0000H000?o00001P000ol0
000Y0003o`0000L000?o000060000ol000080003o`0000X000?o00001@000ol000050003o`0000T0
000;0003o`0000<000?o00001P000ol000090003o`0000T000?o00005`000ol000080003o`0002P0
00?o00001`000ol000070003o`0002P000?o000020000ol0000G0003o`0000T000?o00002@000ol0
00060003o`0000<000?o00002P0000`000?o00000P000ol000070003o`0000P000?o00002P000ol0
000E0003o`0000T000?o00009`000ol000080003o`0000P000?o00009`000ol000090003o`0001D0
00?o00002P000ol000080003o`0000L000?o00000P000ol0000;000030000ol000020003o`0000L0
00?o00001`000ol0000;0003o`0001@000?o00002`000ol0000U0003o`0000T000?o00002@000ol0
000U0003o`0000/000?o000050000ol0000;0003o`0000L000?o00001`000ol000020003o`0000/0
000=0004o`00o`/000?o00001@000ol0000<0003o`0001<000?o000030000ol0000T0003o`0000X0
00?o00002P000ol0000T0003o`0000`000?o00004`000ol0000<0003o`0000D000?o00002@001?l0
0?l>00003@000ol0o`0<0003o`0000@000?o00003@000ol0000C0003o`0000d000?o00008P000ol0
000;0003o`0000/000?o00008P000ol0000=0003o`0001<000?o00003@000ol000040003o`0000X0
00?o0?l03P0000h00_l<0003o`0000<000?o00003`000ol0000A0003o`0000l000?o000080000ol0
000<0003o`0000`000?o000080000ol0000?0003o`00014000?o00003`000ol000030003o`0000X0
0_l?00003P000ol0o`05o`H000?o00000P000ol0000@0003o`00014000?o00003`000ol0000O0003
o`0000d000?o00003@000ol0000O0003o`0000l000?o00004@000ol0000@0003o`00008000?o0000
1006o`030?l000h0000=0003o`3o00H01?l30004o`3ooa@000?o00003`000ol0000A0003o`0001d0
00?o00003P000ol0000>0003o`0001d000?o00004@000ol0000?0003o`0001800_l00`3o000200Co
1P000ol0o`0>000030001?l00?l:00Go5P000ol0000>0003o`00018000?o000070000ol0000?0003
o`0000l000?o000070000ol0000B0003o`0000h000?o00005005o`X000Co003o3@0000/000Go0000
o`0=00;o5P000ol0000=0003o`0001@000?o00006P000ol0000@0003o`00010000?o00006P000ol0
000D0003o`0000d000?o00005002o`d000Go0000o`0<00002@02o`D000?o00002@02o`030?oo01@0
00?o000030000ol0000E0003o`0001T000?o00004@000ol0000A0003o`0001T000?o00005@000ol0
000<0003o`0001800_l00`3oo`0;0003o`0000<00_l:000020000ol000050003o`0000L00_l20003
o`0000Co40000ol0000<0003o`0001D000?o000060000ol0000B0003o`00018000?o000060000ol0
000E0003o`0000`000?o00003P04o`8000?o00000_l90003o`0000D000?o00001`0000P00_l60003
o`0000H000?o00000P000ol0000400;o3P000ol0000;0003o`0001L000?o00005P000ol0000C0003
o`0001<000?o00005P000ol0000G0003o`0000/000?o00003002o`H000?o00000P000ol000060003
o`0000@00_l900001`001?l00?l50003o`0000@00_l50003o`0000H00_l<0003o`0000X000?o0000
60000ol0000E0003o`0001@000?o000050000ol0000E0003o`0001P000?o00002P000ol0000:00;o
20000ol0000300;o1P000ol000030004o`00o`P000070005o`000?l010000ol000030003o`0000D0
00?o000020000ol0000:0003o`0000P000?o00006@000ol0000D0003o`0001D000?o00005@000ol0
000D0003o`0001T000?o000020000ol0000:0003o`0000P000?o00001@000ol000030003o`000080
00Go0000o`0800001`000ol000020005o`000?l00`02o`P000?o00002@000ol000090003o`0000P0
00?o00006P000ol0000B0003o`0001H000?o00005P000ol0000B0003o`0001X000?o000020000ol0
00090003o`0000T000?o00001P02o`<000Go0000o`040003o`0000H000060003o`0000@000?o0?l0
0P02o`X000?o00002P000ol000080003o`0000H00_lM0003o`00014000?o00005`000ol0000G0003
o`00014000?o00006`02o`P000?o000020000ol0000:0003o`0000P00_l20003o`3o00H000?o0000
1@0000H01_l200;o00<0o`002`000ol0000;00;o20000ol000050003o`0001h000?o00003`000ol0
000H0003o`0001P000?o00003`000ol0000N0003o`0000D000?o00001P02o`d000?o00002P001?l0
ool300Go1`0000H000?o00000`05o`d000?o00003@02o`H000?o00001@000ol0000N0003o`0000h0
00?o00006@000ol0000I0003o`0000h000?o00007P000ol000050003o`0000@00_l?0003o`0000/0
1_l40003o`0000D000070003o`0000801_l<0003o`0000l000?o00000`000ol000040003o`0001l0
00?o00003@000ol0000J0003o`0001X000?o00003@000ol0000O0003o`0000@000?o00000`000ol0
000?0003o`0000/01_l30003o`0000H000070003o`3o00;o0P02o`800ol80003o`00014000?o0000
0`000ol000020003o`00024000?o00002`000ol0000K0003o`0001/000?o00002`000ol0000Q0003
o`00008000?o00000`000ol0000A0003o`0000L00ol00`3oo`0300;o00<0o`001`0000L00_l40004
o`00o`@000?o00001@000ol0000B0003o`00008000Go0000o`0T0003o`0000X000?o000070000ol0
000L0003o`0000X000?o00008P001Ol0003o00@000?o00004P000ol0000500;o0`001?l00?l400;o
200000L000?o00000`001?l00?l50003o`0000@000?o00004`02o`8000Co003o9P000ol000080003
o`0001d000?o00007@000ol000080003o`0002@000Co003o0P02oaD000?o000010000ol000030004
o`00o`D000?o00001P0000P000Go0000o`030003o`0000@000?o00000`000ol0000E0005o`3o0?l0
9`000ol000070003o`0001h000?o00007P000ol000070003o`0002D000Go0?l0o`0G0003o`0000<0
00?o000010001Ol0003o00<000?o00001`0000T000?o0?l010000ol000050003o`00008000?o0000
5@001?l0oolX0003o`0000H000?o00007`000ol0000O0003o`0000H000?o00009P02o`030?l001H0
00?o00000P000ol000050003o`00008000?o0?l02P0000T00_l50003o`0000H00_l00`3o000A013o
8P000ol000050003o`00020000?o000080000ol000050003o`0002004OlA0004o`3oo`P000?o0000
0`02o`X0000900;o1@000ol0000800;o1P0<o`L00_l700ko50000ol000040003o`00024000?o0000
8@000ol000040003o`0001803_l700;o200;o`H00_l:0003o`0000<00_l:00002`02o`<000?o0000
2008oa8000Co0?oo5007o`d000?o00000`000ol0000R0003o`00028000?o00000`000ol0000<00Ko
5002o`030?l001402Ol90004o`0000;o300000d00_l00`3o000500Co00<0o`005P001_l00?l0oaX0
1?l:0005o`000?l09@000ol0000S0005o`000?l02P05oaT000?o0?l00P000ol0000E0003o`0000?o
1P001?l0ool>00003`08o`@000?o0?l05@001Ol0003o008000?o00006`07o`<000Co003o9P000ol0
000T0004o`00o`@01_lM0004o`00o`<000?o00004`000ol0o`0400So4000010000?o00001`001?l0
0?lD0003o`00008000Go0000o`0S00;o0P02obL000?o00009@02o`800olR0005o`000?l010000ol0
000B0004o`00o`T000?o00003`00010000?o00001`001Ol0003o018000?o00000`000ol000020003
o`0002801OlV0003o`0002D01?lT0003o`00008000?o00000`000ol0000@0005o`000?l02@000ol0
000?00003`000ol0o`070003o`00008000?o00003P02o`D000?o000010000ol0000R00;o0P02ob@0
00?o00008P03o`030?oo02@000?o000010000ol0000300;o40000ol000020003o`0000D000?o0?l0
400000h000Co003o1`000ol000030003o`0000`000?o00001@000ol000040003o`00024000?o0?l0
1006oah000?o00007@05o`@000?o0?l08`000ol000040003o`0000D000?o000030000ol000030003
o`0000D000Co003o3`0000h000Go0000o`060003o`0000<000?o000030000ol000050003o`0000D0
00?o00007`001?l00?l:00;o70000ol0000J00?o2@001?l00?lQ0003o`0000D000?o00001@000ol0
000<0003o`0000<000?o000010001Ol0003o00l0000=0003o`00008000?o00000`000ol000050003
o`0000T00_l80003o`0000H000?o00007@000ol000020003o`0000T00olI0003o`0001P00_l;0003
o`00008000?o00007@000ol000060003o`0000H00_l;0003o`0000D000?o00000`000ol000020003
o`0000`0000<00;o1@001Ol0003o00P000?o000020000ol000080003o`0000L000?o00006`000ol0
00030003o`0000`00_lG0003o`0001D00ol=0003o`0000<000?o00006`000ol000070003o`0000P0
00?o000020000ol000060005o`000?l01@02o`d0000<0003o`3o00;o0P001?l00?l:0003o`0000H0
00?o00002@000ol000070003o`0001X000?o00001@000ol0000=00?o50000ol0000C00;o3`000ol0
00050003o`0001X000?o00001`000ol000090003o`0000H000?o000020001?l00?l300;o00<0o`00
300000d000Co00000ol00`3o000:0003o`0000@00_l<0003o`0000P000?o000060000ol000060003
o`0001000olA0003o`0001000olA0003o`0000H000?o000060000ol000080003o`0000X00_l60003
o`0000T000?o0?l00ol20003o`0000`0000=0003o`0000<00_l<0003o`0000<000?o00002`000ol0
000:0003o`0001H000?o00001`000ol0000C00;o3`000ol0000=00?o50000ol000070003o`0001H0
00?o00002P000ol0000;0003o`0000<000?o00002P02o`D000?o0000300000`000?o0?l02ol70003
o`00008000?o000030000ol0000:0003o`0001D000?o000020000ol0000E00;o3@000ol0000;00;o
5`000ol000080003o`0001D000?o00002P000ol0000<0003o`00008000?o00001P0=o`d0000<00;o
1003o`D01Ol30004o`00o`l000?o00002`000ol0000C0003o`0000T000?o00005`000ol0000:0003
o`0000X000?o00005`000ol000090003o`0001<000?o00002`000ol0000=0004o`00o`<01_l400?o
1@000ol0000;00003@002Ol0003o0?l0o`0900Ko40000ol0000;0003o`00018000?o00002P000ol0
000H00;o2P000ol0000800;o6P000ol0000:0003o`00018000?o00002`000ol0000>00?o00<0ool0
2@001Ol0o`3o00<000?o0000300000d000Co003o0P001?l00?l:00?o4@000ol0000<0003o`000100
00?o00002`000ol0000J00?o1`000ol0000600;o70000ol0000;0003o`00010000?o000030000ol0
000?00?o2P001?l00?l20004o`00o`h0000>00;o0`001?l00?l90004o`3o00;o3`000ol0000<0003
o`0000l000?o00003@000ol0000L00;o1@000ol0000300?o7@000ol0000=0003o`0000l000?o0000
30000ol0000=00;o00@0o`3o2@001?l00?l300;o3`0000h00_l20003o`00008000?o00001@001?l0
0?l30003o`0000/000?o00003P000ol0000=0003o`0000h000?o00007P02o`<000Co00000_lP0003
o`0000h000?o00003@000ol0000>0003o`0000/000Go0000o`020003o`0000D000?o00000P000ol0
0002o`l0000@0003o`3o00@000?o000010001Ol0003o00@000?o00002P000ol0000>0003o`0000`0
00?o00003`000ol0000P0004o`00o`8000?o000080000ol0000?0003o`0000`000?o00003P000ol0
000:0003o`00008000Go0000o`060003o`00008000?o0?l04@00010000?o0?l010000ol0000200;o
10000ol0000300;o2@000ol0000@0003o`0000X000?o000040000ol0000Q00Go8`000ol0000@0003
o`0000X000?o000040000ol0000700;o1@000ol0000200?o0`000ol000020003o`3o0140000A00Co
0P000ol00002o`H000?o00001@000ol000060003o`00010000?o00002@000ol0000B0003o`000240
0olS0003o`00018000?o00002@000ol0000@0003o`0000H000?o00001@000ol000050004o`00o`80
1?lB00005@05o`P000?o00001P000ol000050003o`00010000?o000020000ol0000C0003o`0001l0
0_l00`3o0002ob4000?o00004`000ol000080003o`00010000?o00001@000ol000060003o`0000H0
1OlF00006002o`P000?o00001`000ol000040003o`00010000?o00001`000ol0000D0003o`0001h0
00Go0000o`030003o`0001h000?o000050000ol000070003o`00010000?o000010000ol000070003
o`0000H00_lI000060000ol0o`070003o`0000P000?o00000P000ol0000B0003o`0000D000?o0000
5@000ol0000M0003o`00008000?o00000P000ol0000M0003o`0001D000?o00001@000ol0000B0003
o`00008000?o000020000ol000050003o`3o01T0000H0004o`00o`D000?o00002P001Ol0003o01@0
00?o000010000ol0000F0003o`0001/00_l50003o`0000<00_lM0003o`0001H000?o000010000ol0
000B0005o`000?l030000ol000030004o`00oaT0000G0003o`00008000?o00000P000ol0000;0003
o`3o01H000?o00000P000ol0000G0003o`0001T00_l70003o`0000D00_lK0003o`0001L000?o0000
0P000ol0000D0003o`3o00d000?o00000P000ol000020003o`0001H0000G0003o`0000<000Go0000
o`0=0003o`3o01H000Go0000o`0J0003o`0001P000?o00001`000ol000070003o`0001P000?o0000
60001Ol0003o01H000?o0?l03@001Ol0003o00D000?o00005P0001L000?o000010001?l00?l901So
1@001?l00?lL0003o`0001H000?o000020000ol000080003o`0001H000?o00006P001?l00?l501So
2@001?l00?l60003o`0001H0000G0003o`0000@000Co003o1005o`D00_lA00Ko00<0o`0070000ol0
000E0003o`0000T000?o00002@000ol0000E0003o`0001/000?o0?l01OlA00;o1@05o`@000Co003o
1P000ol0000F00005P0;o`800ol90004o`00oaD00olM0003o`0001<00_l<0003o`0000X00_lE0003
o`0001/00olE0004o`00o`T00ol200;o00<0ool01_lG00005P000ol0000600Co30001?l00?lE00;o
00<0ool00_lI0003o`0001400_l>0003o`0000`00_lC0003o`0001L01?l00`3oo`0E0004o`00o``0
1Ol70003o`0001D0000G0003o`0000801Ol>0005o`000?l04`000ol0o`0500;o5`000ol0000@0003
o`0000h000?o00003P000ol0000@0003o`0001D00_l50003o`3o01<000Go0000o`0>00Ko0`000ol0
000F00005`000ol00002o`<01?l;0003o`00008000?o000040001Ol0003o00H01?lC0003o`0000l0
00?o00003`000ol0000?0003o`0000l000?o00004@04o`H000Go0000o`0B0003o`00008000?o0000
2@04o`@000Co003o600001P00_l40003o`3o008000?o000020000ol000030003o`0000h000?o0000
0P000ol0000800;o4@000ol0000>0003o`00010000?o000040000ol0000>0003o`0000l00_l:0003
o`00008000?o00003P000ol000030003o`0000P000Ko003o0?l400;o6@0001P000?o00000P001?l0
0?l30003o`0000H000?o000010000ol0000=0003o`0000<000?o00002P02o`l000?o00003002oa<0
00?o00004@02o`h000?o00003@02o``000?o00000`000ol0000=0003o`0000@000?o00001P001Ol0
003o008000?o00000P000ol0000G000060001Ol0003o00<000?o00000P000ol000040003o`0000D0
00?o000030000ol000040003o`0000`00_l=0003o`0000/000?o00004`000ol0000C0003o`0000/0
00?o00002`02o`h000?o000010000ol0000<0003o`0000D000?o000010000ol000020005o`000?l0
0`000ol0000G00006@001?l00?l30003o`00008000?o000010000ol000050003o`0000/000?o0000
1@000ol0000>0003o`0000X000?o00002P000ol0000D0003o`0001@000?o00002P000ol0000:0003
o`0000h000?o00001@000ol0000;0003o`0000D000?o000010000ol000020005o`000?l00P000ol0
000H00006@000ol0o`040003o`0000<000?o00000P000ol000070003o`0000T000?o00001`000ol0
000>00;o2P000ol0000800;o5`000ol0000E00;o2P000ol0000800;o40000ol000070003o`0000T0
00?o00001`000ol000020003o`0000<000?o00000P000ol0o`0J00006P03o`<000?o000010001?l0
0?l:0003o`0000P000?o000020000ol0000@0003o`0000L000?o00001`000ol0000G0003o`0001L0
00?o00001`000ol000070003o`00010000?o000020000ol000080003o`0000P000Co003o1P000ol0
000200;o6`0001d000Co003o1P000ol0o`0<0003o`0000H000?o00002@000ol0000A0003o`0000H0
00?o00001`000ol0000G0003o`0001L000?o00001`000ol000060003o`00014000?o00002@000ol0
00060003o`0000X000?o0?l01P000ol00002oad0000N00;o00<0ool02Ol:0003o`0000D000?o0000
2P000ol0000B00;o1P000ol0000500;o6P000ol0000H00;o1`000ol0000400;o50000ol0000:0003
o`0000D000?o0000200>oal0000O00;o1`001?l00002o`P000?o000010000ol0000;0003o`0001@0
00?o000010000ol000030003o`0001X000?o00006P000ol000030003o`0000@000?o000050000ol0
000;0003o`0000@000?o00001P02o`<000?o00001P000ol0000N0000:@000ol0000200Co10000ol0
00030003o`0000`000?o00005@000ol000030003o`00008000?o00006`000ol0000K0003o`000080
00?o00000`000ol0000E0003o`0000`000?o00000`000ol0000200Co10000ol0000X0000:@000ol0
00060003o`00008000Go0000o`0?0003o`0001H000?o00000P001Ol0003o01h000?o000070001Ol0
003o00@000?o00005P000ol0000=0005o`000?l010000ol000060003o`0002P0000Z0003o`0000H0
00Go0000o`020003o`0000h000?o00005`001Ol0003o008000?o00007@000ol0000M0004o`00o`<0
00?o00005`000ol0000>0004o`00o`<000?o00001P000ol0000Y0000:P000ol000070006o`00o`3o
4@000ol0000H0006o`00o`3o80000ol0000N0003o`3o008000?o000060000ol0000?0003o`3o0080
00?o00001`000ol0000Y0000:P000ol0000800Co4P000ol0000I0004o`3oob4000?o00007`02o`03
0?l001X000?o00004004o`X000?o0000:@0002X000?o00001P0:o`h000?o00005@0=oa`000?o0000
6P0>oaH000?o0000300:o`P000?o0000:@0002X000?o00001_l300;o1@04o`X000?o00003P07o`D0
0ol500Ko5P000ol0000D00Ko1@03o`H01_l@0003o`0000P01?l500;o0`06o`8000?o0000:@0002X0
0ol80004o`3oo`P00_l80003o`0000P01_l;0005o`3o0?l02P07o`l000?o00003@07o`X000Go0?l0
o`0;00Ko2P000ol0000600;o2002o`030?l000L00ol[0000:P000ol000070006o`00o`3o2@04o`@0
00?o00001P02oa0000Ko003o0?lA00;o3@000ol0000;00;o4@000ol0o`020003o`0000h00_l80003
o`0000801?l90003o`3o008000?o00001`000ol0000Y0000:P000ol000060005o`000?l00P000ol0
000:00;o0P000ol0000200Co4@001Ol0003o008000?o00004004o`T000?o00001`04oa8000Co003o
0`000ol0000?00Co10000ol00002o``000Co003o0`000ol000060003o`0002T0000[0003o`0000@0
00Go0000o`040003o`0000/000?o0?l00P02oa@000?o00000P001Ol0003o01D000?o00001P000ol0
00060003o`0001<000Go0000o`040003o`0001800_l20003o`3o00d000?o00000P001Ol0003o00H0
00?o0000:P0002`000?o00000P000ol000020003o`00008000?o00003004oaD000?o00000`000ol0
00020003o`0001<00_l60003o`0000@00_lE0003o`00008000?o00000`000ol0000C00Co3P000ol0
00020003o`00008000?o00000P000ol0000[0000;@001?l00?l50003o`0000<000?o00002`03oaD0
00?o000010000ol000030003o`0001@00_l40003o`0000800_lF0003o`0000<000?o000010000ol0
000C00?o3@000ol000030003o`0000<000Co003o;P0002d000?o0?l01P000ol000030003o`0000P0
0ol0103o0?lD0003o`0000@000?o00000`000ol0000F00;o0P000ol00002oaP000?o00000`000ol0
00040003o`00018000Co0?l00ol:0003o`0000<000?o000010000ol0o`0^0000;P02o`H000?o0000
0`000ol0000600;o10001?l00?lA00;o1P000ol000050003o`0001L01OlI0003o`0000D000?o0000
1002oa4000Co003o1002o`P000?o00000`000ol0000400;o;`00030000?o00000`000ol000030003
o`0000D000?o000010001Ol0003o00l000?o00001P000ol000050003o`0001P01?lI0003o`0000D0
00?o00001P000ol0000=0005o`000?l01P000ol000050003o`0000<000?o00000`000ol0000_0000
<@02o`8000?o00001@000ol0000200;o1`000ol000020003o`0000`000?o00001P000ol000060003
o`0001D00_l01@3o003o01L000?o00001P000ol000060003o`0000`000?o00000P000ol0000500;o
10000ol000050003o`0000;o<P0003<000?o0?l01`001Ol0003o00T000?o00000`000ol0000:0003
o`0000L000?o00001`000ol0000C0005o`000?l00`000ol0000C0003o`0000L000?o00001`000ol0
000:0003o`0000<000?o00001`001Ol0003o00L000?o0?l0=00003@02?l20003o`3o00T000?o0000
1@000ol000080003o`0000P000?o000020000ol0000@00;o10000ol0000200;o4P000ol000080003
o`0000P000?o000020000ol000050003o`0000L000?o0?l00`07ocD0000l00Co2P000ol000050003
o`0000L000?o00002@000ol000090003o`0000h000?o000010000ol000040003o`0000h000?o0000
2@000ol000090003o`0000L000?o00001@000ol0000800Go?00003h00_l:0003o`0000H000?o0000
1P000ol000090003o`0000T000?o00003@000ol000050003o`0000D000?o00003@000ol000090003
o`0000T000?o00001P000ol000060003o`0000P00_lo0000?P001?l0ool80003o`0000L000?o0000
10000ol0000:0003o`0000X000?o00002`000ol000060003o`0000H000?o00002`000ol0000:0003
o`0000X000?o000010000ol000070003o`0000H00_l00`3o000n0000?P001Ol0003o00L000?o0000
20000ol000020003o`0000/000?o00002P000ol0000900;o2@000ol0000700;o2`000ol0000:0003
o`0000/000?o00000P000ol000080003o`0000D000Go0000o`0o0000?P000ol000020003o`0000<0
00?o00002@001Ol0003o00h000?o00002`000ol000070003o`0000T000?o00002@000ol000070003
o`0000/000?o000030001Ol0003o00/000?o00000`000ol000020003o`0003d0000n0003o`0000<0
00?o00000P000ol0000:0003o`3o00l000?o00002`000ol000060003o`0000X000?o00002P000ol0
00060003o`0000/000?o00003@000ol0o`0<0003o`00008000?o00000`000ol0000m0000?P000ol0
00040005o`000?l030000ol0o`0?0003o`0000`000?o000010000ol0000;0003o`0000/000?o0000
10000ol0000<0003o`0000d000?o0?l030001Ol0003o00H000?o0000?@0003h000?o000010001?l0
0?l600co30000ol0000=0003o`0000<000?o000030000ol0000<0003o`0000<000?o00003@000ol0
000:00co1P001?l00?l60003o`0003d0000n0003o`0000D000Co0?l01Ol80004o`0000Co20000ol0
000=0003o`00008000?o00003@000ol0000=0003o`00008000?o00003@000ol0000600Co0`000ol0
000600Oo00<0o`001P000ol0000m0000?@000ol0o`0:o``000?o0?l01P02o`H000?o00003@001Ol0
003o010000?o00003P001Ol0003o00l000?o00001002o`H000?o0?l03@0<och0000m00;o1`000ol0
o`02o`X000Co003o2002o`@000?o00003P001?l00?l@0003o`0000h000Co003o40000ol0000200;o
20001?l00?l;00Co20000ol0000l0000?P000ol000040004o`3oo`8000?o00001P001Ol0003o00X0
0_l20003o`0000D02_l00`3o000@0003o`0000l000?o0?l02_l60003o`0000;o2P001Ol0003o00P0
0_l01@3oo`3o00H000?o0000?@0003l000?o00000P001_l00?l0o`8000?o000010000ol000030003
o`0000T00ol200Go2P04o`l000?o00003@04o`/01?l200?o2`000ol000030003o`0000@000Ko003o
0?l20003o`00008000?o0000?P0003l000?o00000_l30003o`3o00<000?o00000`000ol000030003
o`0000X01?l>00;o0`04o`/000?o00002@04o`<00_l>00Co30000ol000030003o`0000<000Oo0000
o`3o00<00_l20003o`0003h0001000;o10001?l00?l40005o`000?l01P000ol000090003o`3o00l0
00Co003o1P02o`T000?o00001`02o`H000Co003o3`000ol0o`0;0003o`0000@000Go0000o`040004
o`00o`@00_m10000@002o`@000Co003o1@001?l00?l60003o`0000L00_l0103o0?l>0004o`00o`P0
0_l70003o`0000D00_l80004o`00o`h000Co0?l00ol80003o`0000@000Co003o1@001?l00?l400;o
@@0004800_l00`3o00020003o`0000<000?o0?l01`000ol0000400?o0`001?l00?l<0005o`000?l0
2P02o`D000?o00000`02o`X000Go0000o`0<0004o`00o`@00_l60003o`0000D000?o0?l01@001_l0
003o00;o@`0004@00ol20003o`0000801Ol70003o`00008000?o000010001Ol0003o00X000?o0000
0`000ol000090003o`00008000?o00000P000ol000090003o`0000<000?o000020001Ol0003o00H0
00?o00000P000ol0000600Co10001?l00002odD0001700Oo0P000ol00004o`<000Go0000o`070003
o`00008000?o00001`000ol000030003o`0000X000Go0000o`030003o`0000X000?o00000`000ol0
00070003o`00008000?o00001@001Ol0003o00<01Ol0103o0008odL000190003o`0000D000?o0000
0`001?l00?l20003o`0000D000?o000010000ol000050003o`0000@000?o00002`02o`030?l000;o
3@000ol000040003o`0000D000?o000010000ol000050004o`00o`8000?o00000`000ol000050003
o`0004P0001A0003o`0000@000Go0?l0o`080003o`0000D000?o00000`000ol000050003o`0000d0
0ol?0003o`0000D000?o00000`000ol000050003o`0000H000Go0?l0o`060003o`000500001A0003
o`0000D00ol90003o`0000D000?o00000`000ol000060003o`0000`00ol>0003o`0000H000?o0000
0`000ol000050003o`0000L00ol70003o`000500001B0004o`0000[o1@000ol000060005o`000?l0
2@000ol0000600oo20000ol000070005o`000?l020000ol0000300_o0P000ol0001A0000DP04o`<0
0ol400;o0`000ol000060005o`000?l02@000ol0000400;o1@001Ol0o`3o00D00_l60003o`0000L0
00Go0000o`080004o`0000;o1003o`@00omC0000DP02o`@000Go0?l0o`0500;o00<0o`001`001?l0
0?l:0004o`0000?o1`001Ol0o`3o00L00ol30003o`0000P000Co003o20001?l0ool50005o`3o0?l0
1002oe<0001D0004o`00o`8000?o0?l01P0>o`801ol20004o`00o`T000Co003o0P000ol000070004
o`00o`<01_l200;o00<0ool02Ol60003o`3o008000Co003oE@0005@000?o0?l00`001?l00?l40003
o`3o00X01?l700?o00<0o`002@001?l00?l20003o`0000P000?o0?l00ol600Go2@000ol0o`040004
o`00o`<000?o0?l0E@0005D00ol20004o`00o`800_l30003o`0000H01?l:00?o2@001Ol0003o00<0
00?o00001`03o`X000?o0?l00_l70004o`0000;o0P001?l00?l300;oEP0005P00_l01P3oool0o`H0
00?o00000`02o`050?oo0?l020001?l00002o`H000?o00000P000ol000020003o`0000@00_l30003
o`0000H000Co0?oo0P000ol000030003o`0000@000?o0?l01_mH0000F@02o`<000?o00001@000ol0
00020004o`0000;o0P000ol000040003o`0000@000?o00000P000ol000030003o`0000<000?o0000
0P000ol000040003o`0000@000?o00000_l30003o`00008000?o00001@000ol000020003o`0005P0
001W0004o`00o`<000?o0?l00`000ol000020003o`0000H000Go0000o`050003o`0000<000Go0000
o`080003o`00008000Oo0000o`3o00<000Co003oJ00006L000?o0?l010001?l00?l30004o`00o`X0
00?o0?l01P000ol000040003o`3o00X000Co003o0`001?l00?l40003o`3o06P0001X00?o0`001?l0
0?l40003o`3o00X000?o0?l01P000ol000040003o`3o00X000?o0?l010001?l00?l300?oJ@0006/0
00?o0?l00`000ol0000200;o300Ao``00ol30007o`000?l0o`1/0000K006o`040?oooaH000?o0000
5@09ofd0001a00;o=0000ol0001`0000o`0K0000o`0K0000o`0K0000o`0K0000o`0K0000o`0K0000
\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-0.980396, -0.980396, 0.00697791,
   0.00697791}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A 6-gon"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
poly = NGP[RegularPolygon[6,Pi/4]];
pg = PolygonInvGroup[poly,3];\
\>", "Input",
  AspectRatioFixed->True],

Cell["diag = Map[Diagonals, pg];", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{Thickness[0.003], pg, Diagonals[poly]}, 
\tDrawUnitCircle -> False]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .99164 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47627 0.495821 0.47627 [
[ 0 0 0 0 ]
[ 1 .99164 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
newpath
.02373 .49582 .00209 -63.5503 63.5503 arc
s
newpath
.02373 .49738 .00098 -81.408 18.5503 arc
s
newpath
.02373 .49622 .00025 -71.2437 53.592 arc
s
newpath
.02373 .49582 .00018 -63.7563 63.7563 arc
s
newpath
.02373 .49542 .00025 -53.592 71.2437 arc
s
newpath
.02373 .49426 .00098 -18.5503 81.408 arc
s
newpath
.02374 .49123 .00287 -52.8342 71.4497 arc
s
newpath
.02373 .49349 .00103 -79.6295 26.4497 arc
s
newpath
.02374 .49222 .00031 -70.0227 55.3705 arc
s
newpath
.02375 .49171 .00024 -62.5027 64.9773 arc
s
newpath
.02375 .49116 .00035 -51.6325 72.4973 arc
s
newpath
.02377 .48917 .00172 -7.83421 83.3675 arc
s
newpath
.02374 .50042 .00287 -71.4497 52.8342 arc
s
newpath
.02377 .50247 .00172 -83.3675 7.83421 arc
s
newpath
.02375 .50048 .00035 -72.4973 51.6325 arc
s
newpath
.02375 .49993 .00024 -64.9773 62.5027 arc
s
newpath
.02374 .49942 .00031 -55.3705 70.0227 arc
s
newpath
.02373 .49815 .00103 -26.4497 79.6295 arc
s
newpath
.02609 .54327 .00278 -69.9181 57.0146 arc
s
newpath
.02631 .54533 .00133 -87.2628 12.0146 arc
s
newpath
.02615 .54376 .00033 -77.027 47.7372 arc
s
newpath
.0261 .54323 .00024 -69.5266 57.973 arc
s
newpath
.02604 .54271 .00033 -59.3985 65.4734 arc
s
newpath
.02589 .5412 .00127 -24.9181 75.6015 arc
s
newpath
.02609 .44837 .00278 -57.0146 69.9181 arc
s
newpath
.02589 .45045 .00127 -75.6015 24.9181 arc
s
newpath
.02604 .44893 .00033 -65.4734 59.3985 arc
s
newpath
.0261 .44841 .00024 -57.973 69.5266 arc
s
newpath
.02615 .44788 .00033 -47.7372 77.027 arc
s
newpath
.02631 .44631 .00133 -12.0146 87.2628 arc
s
newpath
.02554 .45423 .00359 -65.0819 59.6136 arc
s
newpath
.02533 .4568 .00209 -77.6577 14.6136 arc
s
newpath
.02554 .45439 .00044 -66.8511 57.3424 arc
s
newpath
.0256 .4537 .0003 -59.3219 68.1489 arc
s
newpath
.02565 .45306 .00039 -49.6393 75.6781 arc
s
newpath
.0258 .45144 .00133 -20.0819 85.3607 arc
s
newpath
.02554 .53741 .00359 -59.6136 65.0819 arc
s
newpath
.0258 .54021 .00133 -85.3607 20.0819 arc
s
newpath
.02565 .53858 .00039 -75.6781 49.6393 arc
s
newpath
.0256 .53794 .0003 -68.1489 59.3219 arc
s
newpath
.02554 .53725 .00044 -57.3424 66.8511 arc
s
newpath
.02533 .53484 .00209 -14.6136 77.6577 arc
s
newpath
.02676 .5496 .00408 -77.9854 45.3743 arc
s
newpath
.02711 .55248 .00252 -89.4833 .37429 arc
s
newpath
.02678 .54961 .0005 -78.4934 45.5167 arc
s
newpath
.02669 .54883 .00034 -70.9473 56.5066 arc
s
newpath
.02661 .54812 .00043 -61.3746 64.0527 arc
s
newpath
.02642 .54638 .00142 -32.9854 73.6254 arc
s
newpath
.02676 .44205 .00408 -45.3743 77.9854 arc
s
newpath
.02642 .44526 .00142 -73.6254 32.9854 arc
s
newpath
.02661 .44352 .00043 -64.0527 61.3746 arc
s
newpath
.02669 .44281 .00034 -56.5066 70.9473 arc
s
newpath
.02678 .44203 .0005 -45.5167 78.4934 arc
s
newpath
.02711 .43916 .00252 -0.37429 89.4833 arc
s
newpath
.02394 .47775 .01129 -16.1933 82.1658 arc
s
newpath
.02379 .48766 .00211 -76.5262 37.1658 arc
s
newpath
.02385 .4849 .00083 -67.6743 58.4738 arc
s
newpath
.02389 .48347 .00072 -59.8938 67.3257 arc
s
newpath
.02394 .48166 .00122 -47.0536 75.1062 arc
s
newpath
.02434 .46886 .01191 28.8067 87.9464 arc
s
newpath
.02394 .51389 .01129 -82.1658 16.1933 arc
s
newpath
.02434 .52278 .01191 272.054 331.193 arc
s
newpath
.02394 .50998 .00122 -75.1062 47.0536 arc
s
newpath
.02389 .50817 .00072 -67.3257 59.8938 arc
s
newpath
.02385 .50674 .00083 -58.4738 67.6743 arc
s
newpath
.02379 .50398 .00211 -37.1658 76.5262 arc
s
newpath
.02434 .52278 .01191 -28.8067 75.3864 arc
s
newpath
.02518 .53304 .00252 -82.2749 30.3864 arc
s
newpath
.02494 .52979 .00095 -73.2815 52.7251 arc
s
newpath
.02483 .52816 .00082 -65.5161 61.7185 arc
s
newpath
.02469 .52615 .00135 -52.9759 69.4839 arc
s
newpath
.02394 .51389 .01129 16.1933 82.0241 arc
s
newpath
.02434 .46886 .01191 -75.3864 28.8067 arc
s
newpath
.02394 .47775 .01129 277.976 343.807 arc
s
newpath
.02469 .46549 .00135 -69.4839 52.9759 arc
s
newpath
.02483 .46348 .00082 -61.7185 65.5161 arc
s
newpath
.02494 .46185 .00095 -52.7251 73.2815 arc
s
newpath
.02518 .4586 .00252 -30.3864 82.2749 arc
s
newpath
.02949 .41935 .01979 .73674 89.6257 arc
s
newpath
.02737 .43693 .00316 -69.8995 44.6257 arc
s
newpath
.02792 .43279 .00129 -61.0763 65.1005 arc
s
newpath
.02822 .43056 .00115 -53.157 73.9237 arc
s
newpath
.02863 .42765 .002 -39.7482 81.843 arc
s
newpath
.03238 .40226 .02422 45.7367 95.2518 arc
s
newpath
.02949 .57229 .01979 270.374 359.263 arc
s
newpath
.03238 .58938 .02422 264.748 314.263 arc
s
newpath
.02863 .56399 .002 -81.843 39.7482 arc
s
newpath
.02822 .56109 .00115 -73.9237 53.157 arc
s
newpath
.02792 .55885 .00129 -65.1005 61.0763 arc
s
newpath
.02737 .55472 .00316 -44.6257 69.8995 arc
s
newpath
.04011 .37163 .00942 -52.9684 71.3279 arc
s
newpath
.03844 .37824 .00522 -67.3966 26.3279 arc
s
newpath
.04001 .37235 .00115 -56.5843 67.6034 arc
s
newpath
.04048 .3706 .0008 -48.9535 78.4157 arc
s
newpath
.04094 .36895 .00105 -39.0233 86.0465 arc
s
newpath
.04214 .36463 .00367 -7.96835 95.9767 arc
s
newpath
.04011 .62001 .00942 -71.3279 52.9684 arc
s
newpath
.04214 .62701 .00367 -95.9767 7.96835 arc
s
newpath
.04094 .6227 .00105 -86.0465 39.0233 arc
s
newpath
.04048 .62104 .0008 -78.4157 48.9535 arc
s
newpath
.04001 .61929 .00115 -67.6034 56.5843 arc
s
newpath
.03844 .6134 .00522 -26.3279 67.3966 arc
s
newpath
.02311 .49582 .02422 -61.1933 61.1933 arc
s
newpath
.02394 .47775 .01129 -16.1933 82.1658 arc
s
newpath
.02374 .49123 .00287 -52.8342 71.4497 arc
s
newpath
.02373 .49582 .00209 -63.5503 63.5503 arc
s
newpath
.02374 .50042 .00287 -71.4497 52.8342 arc
s
newpath
.02394 .51389 .01129 -82.1658 16.1933 arc
s
newpath
.04464 .356 .0082 -43.5937 82.0316 arc
s
newpath
.04291 .36196 .00359 -64.2463 37.0316 arc
s
newpath
.04416 .35782 .00096 -54.0865 70.7537 arc
s
newpath
.04461 .35635 .00071 -46.4842 80.9135 arc
s
newpath
.04507 .35485 .00099 -36.0038 88.5158 arc
s
newpath
.0465 .35024 .00408 1.40632 98.9962 arc
s
newpath
.04464 .63564 .0082 -82.0316 43.5937 arc
s
newpath
.0465 .6414 .00408 261.004 358.594 arc
s
newpath
.04507 .63679 .00099 -88.5158 36.0038 arc
s
newpath
.04461 .63529 .00071 -80.9135 46.4842 arc
s
newpath
.04416 .63382 .00096 -70.7537 54.0865 arc
s
newpath
.04291 .62968 .00359 -37.0316 64.2463 arc
s
newpath
.03238 .40226 .02422 -63.6721 45.7367 arc
s
newpath
.02949 .41935 .01979 -73.0833 .73674 arc
s
newpath
.0339 .39788 .00287 -60.702 61.9167 arc
s
newpath
.03482 .39364 .0018 -52.7709 74.298 arc
s
newpath
.03562 .39006 .00216 -43.3249 82.2291 arc
s
newpath
.03737 .3825 .00608 -18.6721 91.6751 arc
s
newpath
.03238 .58938 .02422 -45.7367 63.6721 arc
s
newpath
.03737 .60914 .00608 -91.6751 18.6721 arc
s
newpath
.03562 .60159 .00216 -82.2291 43.3249 arc
s
newpath
.03482 .59801 .0018 -74.298 52.7709 arc
s
newpath
.0339 .59376 .00287 -61.9167 60.702 arc
s
newpath
.02949 .57229 .01979 -0.73674 73.0833 arc
s
newpath
.02554 .44275 .03316 -44.2633 73.8067 arc
s
newpath
.02949 .41935 .01979 .73674 89.6257 arc
s
newpath
.02676 .44205 .00408 -45.3743 77.9854 arc
s
newpath
.02609 .44837 .00278 -57.0146 69.9181 arc
s
newpath
.02554 .45423 .00359 -65.0819 59.6136 arc
s
newpath
.02434 .46886 .01191 -75.3864 28.8067 arc
s
newpath
.02554 .54889 .03316 -73.8067 44.2633 arc
s
newpath
.02434 .52278 .01191 -28.8067 75.3864 arc
s
newpath
.02554 .53741 .00359 -59.6136 65.0819 arc
s
newpath
.02609 .54327 .00278 -69.9181 57.0146 arc
s
newpath
.02676 .5496 .00408 -77.9854 45.3743 arc
s
newpath
.02949 .57229 .01979 270.374 359.263 arc
s
newpath
.05092 .33661 .01374 -28.2966 91.4063 arc
s
newpath
.04751 .34712 .00445 -60.8677 46.4063 arc
s
newpath
.04929 .34188 .00142 -51.21 74.1323 arc
s
newpath
.05006 .33966 .00112 -43.4829 83.79 arc
s
newpath
.05092 .3372 .00169 -32.0525 91.5171 arc
s
newpath
.05437 .32751 .00902 16.7034 102.947 arc
s
newpath
.05092 .65503 .01374 -91.4063 28.2966 arc
s
newpath
.05437 .66413 .00902 257.053 343.297 arc
s
newpath
.05092 .65444 .00169 -91.5171 32.0525 arc
s
newpath
.05006 .65198 .00112 -83.79 43.4829 arc
s
newpath
.04929 .64976 .00142 -74.1323 51.21 arc
s
newpath
.04751 .64452 .00445 -46.4063 60.8677 arc
s
newpath
.09951 .20849 .12697 52.5 106.703 arc
s
newpath
.05737 .31961 .01191 -53.3479 61.7034 arc
s
newpath
.0637 .30476 .00535 -43.9396 81.6521 arc
s
newpath
.06765 .29599 .00505 -35.0414 91.0604 arc
s
newpath
.07341 .28382 .00942 -18.9746 99.9587 arc
s
newpath
.21681 .00532 .30652 97.5 116.025 arc
s
newpath
.09951 .78315 .12697 253.297 307.5 arc
s
newpath
.21681 .98632 .30652 243.975 262.5 arc
s
newpath
.07341 .70782 .00942 -99.9587 18.9746 arc
s
newpath
.06765 .69565 .00505 -91.0604 35.0414 arc
s
newpath
.0637 .68688 .00535 -81.6521 43.9396 arc
s
newpath
.05737 .67203 .01191 -61.7034 53.3479 arc
s
newpath
.05092 .29265 .12697 7.5 90.7367 arc
s
newpath
.09951 .20849 .12697 52.5 106.703 arc
s
newpath
.05092 .33661 .01374 -28.2966 91.4063 arc
s
newpath
.04464 .356 .0082 -43.5937 82.0316 arc
s
newpath
.04011 .37163 .00942 -52.9684 71.3279 arc
s
newpath
.03238 .40226 .02422 -63.6721 45.7367 arc
s
newpath
.05092 .69899 .12697 269.263 352.5 arc
s
newpath
.03238 .58938 .02422 -45.7367 63.6721 arc
s
newpath
.04011 .62001 .00942 -71.3279 52.9684 arc
s
newpath
.04464 .63564 .0082 -82.0316 43.5937 arc
s
newpath
.05092 .65503 .01374 -91.4063 28.2966 arc
s
newpath
.09951 .78315 .12697 253.297 307.5 arc
s
newpath
.13758 .18651 .01374 -31.4063 88.2966 arc
s
newpath
.13142 .19405 .00902 -42.9475 43.2966 arc
s
newpath
.13809 .18622 .00169 -31.5171 92.0525 arc
s
newpath
.13979 .18424 .00112 -23.79 103.483 arc
s
newpath
.14133 .18247 .00142 -14.1323 111.21 arc
s
newpath
.14498 .17831 .00445 13.5937 120.868 arc
s
newpath
.13758 .80513 .01374 -88.2966 31.4063 arc
s
newpath
.14498 .81334 .00445 239.132 346.406 arc
s
newpath
.14133 .80917 .00142 -111.21 14.1323 arc
s
newpath
.13979 .8074 .00112 -103.483 23.79 arc
s
newpath
.13809 .80543 .00169 -92.0525 31.5171 arc
s
newpath
.13142 .79759 .00902 -43.2966 42.9475 arc
s
newpath
.15123 .17138 .0082 -22.0316 103.594 arc
s
newpath
.14718 .17587 .00408 -38.9962 58.5937 arc
s
newpath
.15045 .17232 .00099 -28.5158 96.0038 arc
s
newpath
.15152 .17117 .00071 -20.9135 106.484 arc
s
newpath
.15257 .17005 .00096 -10.7537 114.086 arc
s
newpath
.15553 .1669 .00359 22.9684 124.246 arc
s
newpath
.15123 .82026 .0082 -103.594 22.0316 arc
s
newpath
.15553 .82474 .00359 235.754 337.032 arc
s
newpath
.15257 .82159 .00096 -114.086 10.7537 arc
s
newpath
.15152 .82047 .00071 -106.484 20.9135 arc
s
newpath
.15045 .81932 .00099 -96.0038 28.5158 arc
s
newpath
.14718 .81577 .00408 -58.5937 38.9962 arc
s
newpath
.05092 .29265 .12697 -46.7034 7.5 arc
s
newpath
-0.06638 .49582 .30652 303.975 322.5 arc
s
newpath
.10311 .23238 .00942 -39.9586 78.9746 arc
s
newpath
.11077 .22131 .00505 -31.0604 95.0413 arc
s
newpath
.11638 .21351 .00535 -21.6521 103.94 arc
s
newpath
.12608 .20059 .01191 -1.70343 113.348 arc
s
newpath
.05092 .69899 .12697 -7.5 46.7034 arc
s
newpath
.12608 .79105 .01191 -113.348 1.70343 arc
s
newpath
.11638 .77813 .00535 -103.94 21.6521 arc
s
newpath
.11077 .77034 .00505 -95.0413 31.0604 arc
s
newpath
.10311 .75926 .00942 -78.9746 39.9586 arc
s
newpath
-0.06638 .49582 .30652 37.5 56.0254 arc
s
newpath
.16251 .15964 .00942 -11.3279 112.968 arc
s
newpath
.15745 .1649 .00367 -35.9767 67.9684 arc
s
newpath
.16059 .1617 .00105 -26.0465 99.0233 arc
s
newpath
.1618 .16048 .0008 -18.4157 108.953 arc
s
newpath
.16308 .15919 .00115 -7.60341 116.584 arc
s
newpath
.16739 .15489 .00522 33.6721 127.397 arc
s
newpath
.16251 .83201 .00942 -112.968 11.3279 arc
s
newpath
.16739 .83675 .00522 232.603 326.328 arc
s
newpath
.16308 .83245 .00115 -116.584 7.60341 arc
s
newpath
.1618 .83116 .0008 -108.953 18.4157 arc
s
newpath
.16059 .82994 .00105 -99.0233 26.0465 arc
s
newpath
.15745 .82674 .00367 -67.9684 35.9767 arc
s
newpath
.18517 .13763 .02422 14.2633 123.672 arc
s
newpath
.17054 .15183 .00608 -31.6751 78.6721 arc
s
newpath
.17621 .14654 .00216 -22.2291 103.325 arc
s
newpath
.17891 .14405 .0018 -14.298 112.771 arc
s
newpath
.18213 .14114 .00287 -1.91666 120.702 arc
s
newpath
.19852 .12658 .01979 59.2633 133.083 arc
s
newpath
.18517 .85401 .02422 236.328 345.737 arc
s
newpath
.19852 .86506 .01979 226.917 300.737 arc
s
newpath
.18213 .8505 .00287 -120.702 1.91666 arc
s
newpath
.17891 .84759 .0018 -112.771 14.298 arc
s
newpath
.17621 .84511 .00216 -103.325 22.2291 arc
s
newpath
.17054 .83981 .00608 -78.6721 31.6751 arc
s
newpath
.19852 .12658 .01979 -29.6257 59.2633 arc
s
newpath
.18517 .13763 .02422 -35.2518 14.2633 arc
s
newpath
.20528 .12168 .002 -21.843 99.7482 arc
s
newpath
.20759 .11988 .00115 -13.9237 113.157 arc
s
newpath
.20937 .1185 .00129 -5.10055 121.076 arc
s
newpath
.21268 .11596 .00316 15.3743 129.899 arc
s
newpath
.19852 .86506 .01979 -59.2633 29.6257 arc
s
newpath
.21268 .87568 .00316 230.101 344.626 arc
s
newpath
.20937 .87314 .00129 -121.076 5.10055 arc
s
newpath
.20759 .87176 .00115 -113.157 13.9237 arc
s
newpath
.20528 .86996 .002 -99.7482 21.843 arc
s
newpath
.18517 .85401 .02422 -14.2633 35.2518 arc
s
newpath
.21681 .87877 .00408 -105.374 17.9854 arc
s
newpath
.21942 .88067 .00142 226.375 332.985 arc
s
newpath
.21801 .87964 .00043 -124.053 1.37456 arc
s
newpath
.21744 .87921 .00034 -116.507 10.9473 arc
s
newpath
.21681 .87875 .0005 -105.517 18.4934 arc
s
newpath
.21448 .87703 .00252 -60.3743 29.4833 arc
s
newpath
.21681 .11287 .00408 -17.9854 105.374 arc
s
newpath
.21448 .11461 .00252 -29.4833 60.3743 arc
s
newpath
.21681 .11289 .0005 -18.4934 105.517 arc
s
newpath
.21744 .11243 .00034 -10.9473 116.507 arc
s
newpath
.21801 .112 .00043 -1.37456 124.053 arc
s
newpath
.21942 .11097 .00142 27.0146 133.625 arc
s
newpath
.09951 .20849 .12697 -30.7367 52.5 arc
s
newpath
.18517 .13763 .02422 14.2633 123.672 arc
s
newpath
.16251 .15964 .00942 -11.3279 112.968 arc
s
newpath
.15123 .17138 .0082 -22.0316 103.594 arc
s
newpath
.13758 .18651 .01374 -31.4063 88.2966 arc
s
newpath
.05092 .29265 .12697 -46.7034 7.5 arc
s
newpath
.09951 .78315 .12697 -52.5 30.7367 arc
s
newpath
.05092 .69899 .12697 -7.5 46.7034 arc
s
newpath
.13758 .80513 .01374 -88.2966 31.4063 arc
s
newpath
.15123 .82026 .0082 -103.594 22.0316 arc
s
newpath
.16251 .83201 .00942 -112.968 11.3279 arc
s
newpath
.18517 .85401 .02422 236.328 345.737 arc
s
newpath
.22195 .10913 .00278 -9.91809 117.015 arc
s
newpath
.22028 .11035 .00133 -27.2628 72.0146 arc
s
newpath
.22156 .10942 .00033 -17.027 107.737 arc
s
newpath
.22199 .10911 .00024 -9.52661 117.973 arc
s
newpath
.22241 .10881 .00033 .60154 125.473 arc
s
newpath
.22365 .10792 .00127 35.0819 135.602 arc
s
newpath
.22195 .88251 .00278 -117.015 9.91809 arc
s
newpath
.22365 .88372 .00127 224.398 324.918 arc
s
newpath
.22241 .88283 .00033 234.527 359.398 arc
s
newpath
.22199 .88253 .00024 -117.973 9.52661 arc
s
newpath
.22156 .88222 .00033 -107.737 17.027 arc
s
newpath
.22028 .88129 .00133 -72.0146 27.2628 arc
s
newpath
.02311 .49582 .02422 -61.1933 61.1933 arc
s
newpath
.02554 .44275 .03316 -44.2633 73.8067 arc
s
newpath
.05092 .29265 .12697 7.5 90.7367 arc
s
newpath
-0.06638 .49582 .30652 -37.5 37.5 arc
s
newpath
.05092 .69899 .12697 269.263 352.5 arc
s
newpath
.02554 .54889 .03316 -73.8067 44.2633 arc
s
newpath
.22675 .10571 .00359 .38639 125.082 arc
s
newpath
.22446 .10734 .00133 -25.3607 80.0819 arc
s
newpath
.22579 .10641 .00039 -15.6781 109.639 arc
s
newpath
.22632 .10603 .0003 -8.14887 119.322 arc
s
newpath
.22689 .10564 .00044 2.65765 126.851 arc
s
newpath
.22887 .10425 .00209 45.3864 137.658 arc
s
newpath
.22675 .88593 .00359 234.918 359.614 arc
s
newpath
.22887 .88739 .00209 222.342 314.614 arc
s
newpath
.22689 .886 .00044 233.149 357.342 arc
s
newpath
.22632 .88561 .0003 -119.322 8.14887 arc
s
newpath
.22579 .88524 .00039 -109.639 15.6781 arc
s
newpath
.22446 .8843 .00133 -80.0819 25.3607 arc
s
newpath
.23882 .09737 .01191 31.1933 135.386 arc
s
newpath
.23036 .10322 .00252 -22.2749 90.3864 arc
s
newpath
.23305 .10139 .00095 -13.2815 112.725 arc
s
newpath
.23441 .10048 .00082 -5.51608 121.718 arc
s
newpath
.23608 .09936 .00135 7.02414 129.484 arc
s
newpath
.24632 .09258 .01129 76.1933 142.024 arc
s
newpath
.23882 .89427 .01191 224.614 328.807 arc
s
newpath
.24632 .89907 .01129 217.976 283.807 arc
s
newpath
.23608 .89228 .00135 230.516 352.976 arc
s
newpath
.23441 .89116 .00082 -121.718 5.51608 arc
s
newpath
.23305 .89025 .00095 -112.725 13.2815 arc
s
newpath
.23036 .88842 .00252 -90.3864 22.2749 arc
s
newpath
.21681 .11146 .03316 -13.8067 104.263 arc
s
newpath
.23882 .09737 .01191 31.1933 135.386 arc
s
newpath
.22675 .10571 .00359 .38639 125.082 arc
s
newpath
.22195 .10913 .00278 -9.91809 117.015 arc
s
newpath
.21681 .11287 .00408 -17.9854 105.374 arc
s
newpath
.19852 .12658 .01979 -29.6257 59.2633 arc
s
newpath
.21681 .88018 .03316 -104.263 13.8067 arc
s
newpath
.19852 .86506 .01979 -59.2633 29.6257 arc
s
newpath
.21681 .87877 .00408 -105.374 17.9854 arc
s
newpath
.22195 .88251 .00278 -117.015 9.91809 arc
s
newpath
.22675 .88593 .00359 234.918 359.614 arc
s
newpath
.23882 .89427 .01191 224.614 328.807 arc
s
newpath
.24632 .09258 .01129 -22.1658 76.1933 arc
s
newpath
.23882 .09737 .01191 -27.9464 31.1933 arc
s
newpath
.24971 .09062 .00122 -15.1062 107.054 arc
s
newpath
.25125 .08967 .00072 -7.32566 119.894 arc
s
newpath
.25247 .08893 .00083 1.52624 127.674 arc
s
newpath
.25483 .08749 .00211 22.8342 136.526 arc
s
newpath
.24632 .89907 .01129 -76.1933 22.1658 arc
s
newpath
.25483 .90415 .00211 223.474 337.166 arc
s
newpath
.25247 .90272 .00083 232.326 358.474 arc
s
newpath
.25125 .90197 .00072 -119.894 7.32566 arc
s
newpath
.24971 .90102 .00122 -107.054 15.1062 arc
s
newpath
.23882 .89427 .01191 -31.1933 27.9464 arc
s
newpath
.25789 .90597 .00287 -112.834 11.4497 arc
s
newpath
.25985 .90711 .00103 220.371 326.45 arc
s
newpath
.25875 .90647 .00031 229.977 355.371 arc
s
newpath
.25831 .90621 .00024 -122.503 4.97733 arc
s
newpath
.25784 .90593 .00035 -111.632 12.4973 arc
s
newpath
.25613 .90492 .00172 -67.8342 23.3675 arc
s
newpath
.25789 .08567 .00287 -11.4497 112.834 arc
s
newpath
.25613 .08672 .00172 -23.3675 67.8342 arc
s
newpath
.25784 .08571 .00035 -12.4973 111.632 arc
s
newpath
.25831 .08543 .00024 -4.97733 122.503 arc
s
newpath
.25875 .08517 .00031 4.62946 130.023 arc
s
newpath
.25985 .08453 .00103 33.5503 139.629 arc
s
newpath
.26186 .90829 .00209 -123.55 3.55028 arc
s
newpath
.26322 .90906 .00098 218.592 318.55 arc
s
newpath
.26221 .90848 .00025 228.756 353.592 arc
s
newpath
.26186 .90828 .00018 -123.756 3.75629 arc
s
newpath
.26152 .90808 .00025 -113.592 11.2437 arc
s
newpath
.26051 .9075 .00098 -78.5503 21.408 arc
s
newpath
.26186 .08335 .00209 -3.55028 123.55 arc
s
newpath
.26051 .08414 .00098 -21.408 78.5503 arc
s
newpath
.26152 .08356 .00025 -11.2437 113.592 arc
s
newpath
.26186 .08336 .00018 -3.75629 123.756 arc
s
newpath
.26221 .08316 .00025 6.40798 131.244 arc
s
newpath
.26322 .08258 .00098 41.4497 141.408 arc
s
newpath
.26585 .08107 .00287 7.16579 131.45 arc
s
newpath
.26389 .0822 .00103 -19.6295 86.4497 arc
s
newpath
.26499 .08157 .00031 -10.0227 115.371 arc
s
newpath
.26543 .08132 .00024 -2.5027 124.977 arc
s
newpath
.26591 .08105 .00035 8.36752 132.497 arc
s
newpath
.26764 .08007 .00172 52.1658 143.368 arc
s
newpath
.26585 .91057 .00287 228.55 352.834 arc
s
newpath
.26764 .91157 .00172 216.632 307.834 arc
s
newpath
.26591 .91059 .00035 227.503 351.632 arc
s
newpath
.26543 .91032 .00024 -124.977 2.5027 arc
s
newpath
.26499 .91007 .00031 -115.371 10.0227 arc
s
newpath
.26389 .90944 .00103 -86.4497 19.6295 arc
s
newpath
.26156 .08283 .02422 -1.19334 121.193 arc
s
newpath
.27762 .0745 .01129 43.8067 142.166 arc
s
newpath
.26585 .08107 .00287 7.16579 131.45 arc
s
newpath
.26186 .08335 .00209 -3.55028 123.55 arc
s
newpath
.25789 .08567 .00287 -11.4497 112.834 arc
s
newpath
.24632 .09258 .01129 -22.1658 76.1933 arc
s
newpath
.26156 .90882 .02422 -121.193 1.19334 arc
s
newpath
.24632 .89907 .01129 -76.1933 22.1658 arc
s
newpath
.25789 .90597 .00287 -112.834 11.4497 arc
s
newpath
.26186 .90829 .00209 -123.55 3.55028 arc
s
newpath
.26585 .91057 .00287 228.55 352.834 arc
s
newpath
.27762 .91714 .01129 217.834 316.193 arc
s
newpath
.27762 .0745 .01129 43.8067 142.166 arc
s
newpath
.26896 .07934 .00211 -16.5262 97.1658 arc
s
newpath
.27138 .07801 .00083 -7.67434 118.474 arc
s
newpath
.27264 .07732 .00072 .10621 127.326 arc
s
newpath
.27423 .07646 .00122 12.9464 135.106 arc
s
newpath
.28552 .07041 .01191 88.8067 147.946 arc
s
newpath
.27762 .91714 .01129 217.834 316.193 arc
s
newpath
.28552 .92123 .01191 212.054 271.193 arc
s
newpath
.27423 .91518 .00122 224.894 347.054 arc
s
newpath
.27264 .91432 .00072 232.674 359.894 arc
s
newpath
.27138 .91363 .00083 -118.474 7.67434 arc
s
newpath
.26896 .91231 .00211 -97.1658 16.5262 arc
s
newpath
.28552 .07041 .01191 -15.3864 88.8067 arc
s
newpath
.27762 .0745 .01129 -22.0241 43.8067 arc
s
newpath
.28861 .06903 .00135 -9.48392 112.976 arc
s
newpath
.29042 .06814 .00082 -1.71848 125.516 arc
s
newpath
.29189 .06742 .00095 7.27491 133.282 arc
s
newpath
.29482 .06601 .00252 29.6136 142.275 arc
s
newpath
.28552 .92123 .01191 -88.8067 15.3864 arc
s
newpath
.29482 .92564 .00252 217.725 330.386 arc
s
newpath
.29189 .92422 .00095 226.718 352.725 arc
s
newpath
.29042 .9235 .00082 -125.516 1.71848 arc
s
newpath
.28861 .92261 .00135 -112.976 9.48392 arc
s
newpath
.27762 .91714 .01129 -43.8067 22.0241 arc
s
newpath
.29878 .92751 .00359 -119.614 5.08191 arc
s
newpath
.30134 .92868 .00133 214.639 320.082 arc
s
newpath
.29986 .928 .00039 224.322 349.639 arc
s
newpath
.29927 .92773 .0003 231.851 359.322 arc
s
newpath
.29865 .92744 .00044 -117.342 6.85113 arc
s
newpath
.29645 .92641 .00209 -74.6136 17.6577 arc
s
newpath
.29878 .06413 .00359 -5.08191 119.614 arc
s
newpath
.29645 .06523 .00209 -17.6577 74.6136 arc
s
newpath
.29865 .06421 .00044 -6.85113 117.342 arc
s
newpath
.29927 .06391 .0003 .67812 128.149 arc
s
newpath
.29986 .06364 .00039 10.3607 135.678 arc
s
newpath
.30134 .06296 .00133 39.9181 145.361 arc
s
newpath
.30414 .06168 .00278 2.98538 129.918 arc
s
newpath
.30224 .06255 .00127 -15.6015 84.9181 arc
s
newpath
.30363 .06192 .00033 -5.47339 119.398 arc
s
newpath
.30411 .0617 .00024 2.02704 129.527 arc
s
newpath
.30459 .06148 .00033 12.2628 137.027 arc
s
newpath
.30603 .06084 .00133 47.9854 147.263 arc
s
newpath
.30414 .92996 .00278 230.082 357.015 arc
s
newpath
.30603 .93081 .00133 212.737 312.015 arc
s
newpath
.30459 .93016 .00033 222.973 347.737 arc
s
newpath
.30411 .92994 .00024 230.473 357.973 arc
s
newpath
.30363 .92972 .00033 -119.398 5.47339 arc
s
newpath
.30224 .9291 .00127 -84.9181 15.6015 arc
s
newpath
.30995 .93255 .00408 222.015 345.374 arc
s
newpath
.31262 .93369 .00252 210.517 300.374 arc
s
newpath
.30997 .93254 .0005 221.507 345.517 arc
s
newpath
.30925 .93223 .00034 229.053 356.507 arc
s
newpath
.3086 .93194 .00043 -121.375 4.05273 arc
s
newpath
.30699 .93123 .00142 -92.9854 13.6254 arc
s
newpath
.30995 .05909 .00408 14.6257 137.985 arc
s
newpath
.30699 .06041 .00142 -13.6254 92.9854 arc
s
newpath
.3086 .0597 .00043 -4.05273 121.375 arc
s
newpath
.30925 .05942 .00034 3.49338 130.947 arc
s
newpath
.30997 .0591 .0005 14.4833 138.493 arc
s
newpath
.31262 .05795 .00252 59.6257 149.483 arc
s
newpath
.30873 .05839 .03316 15.7367 133.807 arc
s
newpath
.33097 .05011 .01979 60.7367 149.626 arc
s
newpath
.30995 .05909 .00408 14.6257 137.985 arc
s
newpath
.30414 .06168 .00278 2.98538 129.918 arc
s
newpath
.29878 .06413 .00359 -5.08191 119.614 arc
s
newpath
.28552 .07041 .01191 -15.3864 88.8067 arc
s
newpath
.30873 .93325 .03316 226.193 344.263 arc
s
newpath
.28552 .92123 .01191 -88.8067 15.3864 arc
s
newpath
.29878 .92751 .00359 -119.614 5.08191 arc
s
newpath
.30414 .92996 .00278 230.082 357.015 arc
s
newpath
.30995 .93255 .00408 222.015 345.374 arc
s
newpath
.33097 .94153 .01979 210.374 299.263 arc
s
newpath
.33097 .05011 .01979 60.7367 149.626 arc
s
newpath
.31469 .05707 .00316 -9.89945 104.626 arc
s
newpath
.31854 .05547 .00129 -1.07628 125.101 arc
s
newpath
.32063 .05462 .00115 6.84301 133.924 arc
s
newpath
.32335 .05352 .002 20.2518 141.843 arc
s
newpath
.34722 .04407 .02422 105.737 155.252 arc
s
newpath
.33097 .94153 .01979 210.374 299.263 arc
s
newpath
.34722 .94757 .02422 204.748 254.263 arc
s
newpath
.32335 .93812 .002 218.157 339.748 arc
s
newpath
.32063 .93703 .00115 226.076 353.157 arc
s
newpath
.31854 .93617 .00129 -125.101 1.07628 arc
s
newpath
.31469 .93457 .00316 -104.626 9.89945 arc
s
newpath
.30873 .93325 .03316 226.193 344.263 arc
s
newpath
.26156 .90882 .02422 -121.193 1.19334 arc
s
newpath
.21681 .88018 .03316 -104.263 13.8067 arc
s
newpath
.09951 .78315 .12697 -52.5 30.7367 arc
s
newpath
.21681 .98632 .30652 262.5 337.5 arc
s
newpath
.45141 .98632 .12697 209.263 292.5 arc
s
newpath
.21681 .11146 .03316 -13.8067 104.263 arc
s
newpath
.26156 .08283 .02422 -1.19334 121.193 arc
s
newpath
.30873 .05839 .03316 15.7367 133.807 arc
s
newpath
.45141 .00532 .12697 67.5 150.737 arc
s
newpath
.21681 .00532 .30652 22.5 97.5 arc
s
newpath
.09951 .20849 .12697 -30.7367 52.5 arc
s
newpath
.21681 .88018 .03316 -104.263 13.8067 arc
s
newpath
.09951 .78315 .12697 -52.5 30.7367 arc
s
newpath
.21681 .98632 .30652 262.5 337.5 arc
s
newpath
.45141 .98632 .12697 209.263 292.5 arc
s
newpath
.30873 .93325 .03316 226.193 344.263 arc
s
newpath
.26156 .90882 .02422 -121.193 1.19334 arc
s
newpath
.21681 .00532 .30652 22.5 97.5 arc
s
newpath
.09951 .20849 .12697 -30.7367 52.5 arc
s
newpath
.21681 .11146 .03316 -13.8067 104.263 arc
s
newpath
.26156 .08283 .02422 -1.19334 121.193 arc
s
newpath
.30873 .05839 .03316 15.7367 133.807 arc
s
newpath
.45141 .00532 .12697 67.5 150.737 arc
s
newpath
.21681 .98632 .30652 262.5 337.5 arc
s
newpath
.45141 .98632 .12697 209.263 292.5 arc
s
newpath
.30873 .93325 .03316 226.193 344.263 arc
s
newpath
.26156 .90882 .02422 -121.193 1.19334 arc
s
newpath
.21681 .88018 .03316 -104.263 13.8067 arc
s
newpath
.09951 .78315 .12697 -52.5 30.7367 arc
s
newpath
.30873 .05839 .03316 15.7367 133.807 arc
s
newpath
.45141 .00532 .12697 67.5 150.737 arc
s
newpath
.21681 .00532 .30652 22.5 97.5 arc
s
newpath
.09951 .20849 .12697 -30.7367 52.5 arc
s
newpath
.21681 .11146 .03316 -13.8067 104.263 arc
s
newpath
.26156 .08283 .02422 -1.19334 121.193 arc
s
newpath
.34722 .04407 .02422 -3.67214 105.737 arc
s
newpath
.33097 .05011 .01979 -13.0833 60.7367 arc
s
newpath
.35177 .0432 .00287 -0.70199 121.917 arc
s
newpath
.3559 .04187 .0018 7.22913 134.298 arc
s
newpath
.3594 .04077 .00216 16.6751 142.229 arc
s
newpath
.36682 .03851 .00608 41.3279 151.675 arc
s
newpath
.34722 .94757 .02422 -105.737 3.67214 arc
s
newpath
.36682 .95313 .00608 208.325 318.672 arc
s
newpath
.3594 .95087 .00216 217.771 343.325 arc
s
newpath
.3559 .94977 .0018 225.702 352.771 arc
s
newpath
.35177 .94845 .00287 -121.917 .70199 arc
s
newpath
.33097 .94153 .01979 -60.7367 13.0833 arc
s
newpath
.3776 .03545 .00942 7.03165 131.328 arc
s
newpath
.37105 .03731 .00522 -7.39659 86.3279 arc
s
newpath
.37693 .03572 .00115 3.41567 127.603 arc
s
newpath
.37868 .03526 .0008 11.0465 138.416 arc
s
newpath
.38035 .03482 .00105 20.9767 146.047 arc
s
newpath
.38469 .03371 .00367 52.0316 155.977 arc
s
newpath
.3776 .95619 .00942 228.672 352.968 arc
s
newpath
.38469 .95794 .00367 204.023 307.968 arc
s
newpath
.38035 .95682 .00105 213.953 339.023 arc
s
newpath
.37868 .95638 .0008 221.584 348.953 arc
s
newpath
.37693 .95592 .00115 232.397 356.584 arc
s
newpath
.37105 .95433 .00522 -86.3279 7.39659 arc
s
newpath
.39341 .03156 .0082 16.4063 142.032 arc
s
newpath
.38739 .03304 .00359 -4.2463 97.0316 arc
s
newpath
.39159 .03205 .00096 5.91354 130.754 arc
s
newpath
.39309 .0317 .00071 13.5158 140.914 arc
s
newpath
.39462 .03135 .00099 23.9962 148.516 arc
s
newpath
.39932 .03029 .00408 61.4063 158.996 arc
s
newpath
.39341 .96008 .0082 217.968 343.594 arc
s
newpath
.39932 .96135 .00408 201.004 298.594 arc
s
newpath
.39462 .96029 .00099 211.484 336.004 arc
s
newpath
.39309 .95994 .00071 219.086 346.484 arc
s
newpath
.39159 .95959 .00096 229.246 354.086 arc
s
newpath
.38739 .9586 .00359 -97.0316 4.2463 arc
s
newpath
.45141 .00532 .12697 67.5 150.737 arc
s
newpath
.54859 .00532 .12697 112.5 166.703 arc
s
newpath
.41334 .0273 .01374 31.7034 151.406 arc
s
newpath
.39341 .03156 .0082 16.4063 142.032 arc
s
newpath
.3776 .03545 .00942 7.03165 131.328 arc
s
newpath
.34722 .04407 .02422 -3.67214 105.737 arc
s
newpath
.45141 .98632 .12697 209.263 292.5 arc
s
newpath
.34722 .94757 .02422 -105.737 3.67214 arc
s
newpath
.3776 .95619 .00942 228.672 352.968 arc
s
newpath
.39341 .96008 .0082 217.968 343.594 arc
s
newpath
.41334 .96434 .01374 208.594 328.297 arc
s
newpath
.54859 .98632 .12697 193.297 247.5 arc
s
newpath
.41334 .0273 .01374 31.7034 151.406 arc
s
newpath
.40253 .02961 .00445 -0.8677 106.406 arc
s
newpath
.40796 .02853 .00142 8.78996 134.132 arc
s
newpath
.41027 .02808 .00112 16.5171 143.79 arc
s
newpath
.41283 .02759 .00169 27.9475 151.517 arc
s
newpath
.42295 .02574 .00902 76.7034 162.947 arc
s
newpath
.41334 .96434 .01374 208.594 328.297 arc
s
newpath
.42295 .9659 .00902 197.053 283.297 arc
s
newpath
.41283 .96405 .00169 208.483 332.053 arc
s
newpath
.41027 .96356 .00112 216.21 343.483 arc
s
newpath
.40796 .96312 .00142 225.868 351.21 arc
s
newpath
.40253 .96203 .00445 -106.406 .8677 arc
s
newpath
.54859 .00532 .12697 112.5 166.703 arc
s
newpath
.43129 .02438 .01191 6.65209 121.703 arc
s
newpath
.44732 .02244 .00535 16.0604 141.652 arc
s
newpath
.45688 .02148 .00505 24.9586 151.06 arc
s
newpath
.4703 .02038 .00942 41.0254 159.959 arc
s
newpath
.78319 .00532 .30652 157.5 176.025 arc
s
newpath
.54859 .98632 .12697 193.297 247.5 arc
s
newpath
.78319 .98632 .30652 183.975 202.5 arc
s
newpath
.4703 .97126 .00942 200.041 318.975 arc
s
newpath
.45688 .97016 .00505 208.94 335.041 arc
s
newpath
.44732 .9692 .00535 218.348 343.94 arc
s
newpath
.43129 .96726 .01191 238.297 353.348 arc
s
newpath
1.06638 .49582 .30652 142.5 217.5 arc
s
newpath
.78319 .00532 .30652 82.5 157.5 arc
s
newpath
.21681 .00532 .30652 22.5 97.5 arc
s
newpath
-0.06638 .49582 .30652 -37.5 37.5 arc
s
newpath
.21681 .98632 .30652 262.5 337.5 arc
s
newpath
.78319 .98632 .30652 202.5 277.5 arc
s
newpath
.45141 .00532 .12697 13.2966 67.5 arc
s
newpath
.21681 .00532 .30652 3.97457 22.5 arc
s
newpath
.5297 .02038 .00942 20.0414 138.975 arc
s
newpath
.54312 .02148 .00505 28.9396 155.041 arc
s
newpath
.55268 .02244 .00535 38.3479 163.94 arc
s
newpath
.56871 .02438 .01191 58.2966 173.348 arc
s
newpath
.45141 .98632 .12697 292.5 346.703 arc
s
newpath
.56871 .96726 .01191 186.652 301.703 arc
s
newpath
.55268 .9692 .00535 196.06 321.652 arc
s
newpath
.54312 .97016 .00505 204.959 331.06 arc
s
newpath
.5297 .97126 .00942 221.025 339.959 arc
s
newpath
.21681 .98632 .30652 337.5 356.025 arc
s
newpath
.58666 .0273 .01374 28.5937 148.297 arc
s
newpath
.57705 .02574 .00902 17.0525 103.297 arc
s
newpath
.58717 .02759 .00169 28.4829 152.053 arc
s
newpath
.58973 .02808 .00112 36.21 163.483 arc
s
newpath
.59204 .02853 .00142 45.8677 171.21 arc
s
newpath
.59747 .02961 .00445 73.5937 180.868 arc
s
newpath
.58666 .96434 .01374 211.703 331.406 arc
s
newpath
.59747 .96203 .00445 179.132 286.406 arc
s
newpath
.59204 .96312 .00142 188.79 314.132 arc
s
newpath
.58973 .96356 .00112 196.517 323.79 arc
s
newpath
.58717 .96405 .00169 207.947 331.517 arc
s
newpath
.57705 .9659 .00902 256.703 342.947 arc
s
newpath
.54859 .00532 .12697 29.2633 112.5 arc
s
newpath
.65278 .04407 .02422 74.2633 183.672 arc
s
newpath
.6224 .03545 .00942 48.6721 172.968 arc
s
newpath
.60659 .03156 .0082 37.9684 163.594 arc
s
newpath
.58666 .0273 .01374 28.5937 148.297 arc
s
newpath
.45141 .00532 .12697 13.2966 67.5 arc
s
newpath
.54859 .98632 .12697 247.5 330.737 arc
s
newpath
.45141 .98632 .12697 292.5 346.703 arc
s
newpath
.58666 .96434 .01374 211.703 331.406 arc
s
newpath
.60659 .96008 .0082 196.406 322.032 arc
s
newpath
.6224 .95619 .00942 187.032 311.328 arc
s
newpath
.65278 .94757 .02422 176.328 285.737 arc
s
newpath
.60659 .03156 .0082 37.9684 163.594 arc
s
newpath
.60068 .03029 .00408 21.0038 118.594 arc
s
newpath
.60538 .03135 .00099 31.4842 156.004 arc
s
newpath
.60691 .0317 .00071 39.0865 166.484 arc
s
newpath
.60841 .03205 .00096 49.2463 174.086 arc
s
newpath
.61261 .03304 .00359 82.9684 184.246 arc
s
newpath
.60659 .96008 .0082 196.406 322.032 arc
s
newpath
.61261 .9586 .00359 175.754 277.032 arc
s
newpath
.60841 .95959 .00096 185.914 310.754 arc
s
newpath
.60691 .95994 .00071 193.516 320.914 arc
s
newpath
.60538 .96029 .00099 203.996 328.516 arc
s
newpath
.60068 .96135 .00408 241.406 338.996 arc
s
newpath
.6224 .03545 .00942 48.6721 172.968 arc
s
newpath
.61531 .03371 .00367 24.0233 127.968 arc
s
newpath
.61965 .03482 .00105 33.9535 159.023 arc
s
newpath
.62132 .03526 .0008 41.5843 168.953 arc
s
newpath
.62307 .03572 .00115 52.3966 176.584 arc
s
newpath
.62895 .03731 .00522 93.6721 187.397 arc
s
newpath
.6224 .95619 .00942 187.032 311.328 arc
s
newpath
.62895 .95433 .00522 172.603 266.328 arc
s
newpath
.62307 .95592 .00115 183.416 307.603 arc
s
newpath
.62132 .95638 .0008 191.047 318.416 arc
s
newpath
.61965 .95682 .00105 200.977 326.047 arc
s
newpath
.61531 .95794 .00367 232.032 335.977 arc
s
newpath
.65278 .04407 .02422 74.2633 183.672 arc
s
newpath
.63318 .03851 .00608 28.3249 138.672 arc
s
newpath
.6406 .04077 .00216 37.7709 163.325 arc
s
newpath
.6441 .04187 .0018 45.702 172.771 arc
s
newpath
.64823 .0432 .00287 58.0833 180.702 arc
s
newpath
.66903 .05011 .01979 119.263 193.083 arc
s
newpath
.65278 .94757 .02422 176.328 285.737 arc
s
newpath
.66903 .94153 .01979 166.917 240.737 arc
s
newpath
.64823 .94845 .00287 179.298 301.917 arc
s
newpath
.6441 .94977 .0018 187.229 314.298 arc
s
newpath
.6406 .95087 .00216 196.675 322.229 arc
s
newpath
.63318 .95313 .00608 221.328 331.675 arc
s
newpath
.73844 .90882 .02422 178.807 301.193 arc
s
newpath
.69127 .93325 .03316 195.737 313.807 arc
s
newpath
.54859 .98632 .12697 247.5 330.737 arc
s
newpath
.78319 .98632 .30652 202.5 277.5 arc
s
newpath
.90049 .78315 .12697 149.263 232.5 arc
s
newpath
.78319 .88018 .03316 166.193 284.263 arc
s
newpath
.90049 .20849 .12697 127.5 210.737 arc
s
newpath
.78319 .00532 .30652 82.5 157.5 arc
s
newpath
.54859 .00532 .12697 29.2633 112.5 arc
s
newpath
.69127 .05839 .03316 46.1933 164.263 arc
s
newpath
.73844 .08283 .02422 58.8067 181.193 arc
s
newpath
.78319 .11146 .03316 75.7367 193.807 arc
s
newpath
.90049 .78315 .12697 149.263 232.5 arc
s
newpath
.78319 .88018 .03316 166.193 284.263 arc
s
newpath
.73844 .90882 .02422 178.807 301.193 arc
s
newpath
.69127 .93325 .03316 195.737 313.807 arc
s
newpath
.54859 .98632 .12697 247.5 330.737 arc
s
newpath
.78319 .98632 .30652 202.5 277.5 arc
s
newpath
.78319 .11146 .03316 75.7367 193.807 arc
s
newpath
.90049 .20849 .12697 127.5 210.737 arc
s
newpath
.78319 .00532 .30652 82.5 157.5 arc
s
newpath
.54859 .00532 .12697 29.2633 112.5 arc
s
newpath
.69127 .05839 .03316 46.1933 164.263 arc
s
newpath
.73844 .08283 .02422 58.8067 181.193 arc
s
newpath
.78319 .88018 .03316 166.193 284.263 arc
s
newpath
.73844 .90882 .02422 178.807 301.193 arc
s
newpath
.69127 .93325 .03316 195.737 313.807 arc
s
newpath
.54859 .98632 .12697 247.5 330.737 arc
s
newpath
.78319 .98632 .30652 202.5 277.5 arc
s
newpath
.90049 .78315 .12697 149.263 232.5 arc
s
newpath
.69127 .05839 .03316 46.1933 164.263 arc
s
newpath
.73844 .08283 .02422 58.8067 181.193 arc
s
newpath
.78319 .11146 .03316 75.7367 193.807 arc
s
newpath
.90049 .20849 .12697 127.5 210.737 arc
s
newpath
.78319 .00532 .30652 82.5 157.5 arc
s
newpath
.54859 .00532 .12697 29.2633 112.5 arc
s
newpath
.66903 .05011 .01979 30.3743 119.263 arc
s
newpath
.65278 .04407 .02422 24.7482 74.2633 arc
s
newpath
.67665 .05352 .002 38.157 159.748 arc
s
newpath
.67937 .05462 .00115 46.0763 173.157 arc
s
newpath
.68146 .05547 .00129 54.8995 181.076 arc
s
newpath
.68531 .05707 .00316 75.3743 189.899 arc
s
newpath
.66903 .94153 .01979 240.737 329.626 arc
s
newpath
.68531 .93457 .00316 170.101 284.626 arc
s
newpath
.68146 .93617 .00129 178.924 305.101 arc
s
newpath
.67937 .93703 .00115 186.843 313.924 arc
s
newpath
.67665 .93812 .002 200.252 321.843 arc
s
newpath
.65278 .94757 .02422 285.737 335.252 arc
s
newpath
.69127 .05839 .03316 46.1933 164.263 arc
s
newpath
.71448 .07041 .01191 91.1933 195.386 arc
s
newpath
.70122 .06413 .00359 60.3864 185.082 arc
s
newpath
.69586 .06168 .00278 50.0819 177.015 arc
s
newpath
.69005 .05909 .00408 42.0146 165.374 arc
s
newpath
.66903 .05011 .01979 30.3743 119.263 arc
s
newpath
.69127 .93325 .03316 195.737 313.807 arc
s
newpath
.66903 .94153 .01979 240.737 329.626 arc
s
newpath
.69005 .93255 .00408 194.626 317.985 arc
s
newpath
.69586 .92996 .00278 182.985 309.918 arc
s
newpath
.70122 .92751 .00359 174.918 299.614 arc
s
newpath
.71448 .92123 .01191 164.614 268.807 arc
s
newpath
.69005 .93255 .00408 194.626 317.985 arc
s
newpath
.69301 .93123 .00142 166.375 272.985 arc
s
newpath
.6914 .93194 .00043 175.947 301.375 arc
s
newpath
.69075 .93223 .00034 183.493 310.947 arc
s
newpath
.69003 .93254 .0005 194.483 318.493 arc
s
newpath
.68738 .93369 .00252 239.626 329.483 arc
s
newpath
.69005 .05909 .00408 42.0146 165.374 arc
s
newpath
.68738 .05795 .00252 30.5167 120.374 arc
s
newpath
.69003 .0591 .0005 41.5066 165.517 arc
s
newpath
.69075 .05942 .00034 49.0527 176.507 arc
s
newpath
.6914 .0597 .00043 58.6254 184.053 arc
s
newpath
.69301 .06041 .00142 87.0146 193.625 arc
s
newpath
.69586 .06168 .00278 50.0819 177.015 arc
s
newpath
.69397 .06084 .00133 32.7372 132.015 arc
s
newpath
.69541 .06148 .00033 42.973 167.737 arc
s
newpath
.69589 .0617 .00024 50.4734 177.973 arc
s
newpath
.69637 .06192 .00033 60.6015 185.473 arc
s
newpath
.69776 .06255 .00127 95.0819 195.602 arc
s
newpath
.69586 .92996 .00278 182.985 309.918 arc
s
newpath
.69776 .9291 .00127 164.398 264.918 arc
s
newpath
.69637 .92972 .00033 174.527 299.398 arc
s
newpath
.69589 .92994 .00024 182.027 309.527 arc
s
newpath
.69541 .93016 .00033 192.263 317.027 arc
s
newpath
.69397 .93081 .00133 227.985 327.263 arc
s
newpath
.70122 .92751 .00359 174.918 299.614 arc
s
newpath
.70355 .92641 .00209 162.342 254.614 arc
s
newpath
.70135 .92744 .00044 173.149 297.342 arc
s
newpath
.70073 .92773 .0003 180.678 308.149 arc
s
newpath
.70014 .928 .00039 190.361 315.678 arc
s
newpath
.69866 .92868 .00133 219.918 325.361 arc
s
newpath
.70122 .06413 .00359 60.3864 185.082 arc
s
newpath
.69866 .06296 .00133 34.6393 140.082 arc
s
newpath
.70014 .06364 .00039 44.3219 169.639 arc
s
newpath
.70073 .06391 .0003 51.8511 179.322 arc
s
newpath
.70135 .06421 .00044 62.6576 186.851 arc
s
newpath
.70355 .06523 .00209 105.386 197.658 arc
s
newpath
.71448 .07041 .01191 91.1933 195.386 arc
s
newpath
.70518 .06601 .00252 37.7251 150.386 arc
s
newpath
.70811 .06742 .00095 46.7185 172.725 arc
s
newpath
.70958 .06814 .00082 54.4839 181.718 arc
s
newpath
.71139 .06903 .00135 67.0241 189.484 arc
s
newpath
.72238 .0745 .01129 136.193 202.024 arc
s
newpath
.71448 .92123 .01191 164.614 268.807 arc
s
newpath
.72238 .91714 .01129 157.976 223.807 arc
s
newpath
.71139 .92261 .00135 170.516 292.976 arc
s
newpath
.70958 .9235 .00082 178.282 305.516 arc
s
newpath
.70811 .92422 .00095 187.275 313.282 arc
s
newpath
.70518 .92564 .00252 209.614 322.275 arc
s
newpath
.72238 .0745 .01129 37.8342 136.193 arc
s
newpath
.71448 .07041 .01191 32.0536 91.1933 arc
s
newpath
.72577 .07646 .00122 44.8938 167.054 arc
s
newpath
.72736 .07732 .00072 52.6743 179.894 arc
s
newpath
.72862 .07801 .00083 61.5262 187.674 arc
s
newpath
.73104 .07934 .00211 82.8342 196.526 arc
s
newpath
.72238 .91714 .01129 223.807 322.166 arc
s
newpath
.73104 .91231 .00211 163.474 277.166 arc
s
newpath
.72862 .91363 .00083 172.326 298.474 arc
s
newpath
.72736 .91432 .00072 180.106 307.326 arc
s
newpath
.72577 .91518 .00122 192.946 315.106 arc
s
newpath
.71448 .92123 .01191 268.807 327.946 arc
s
newpath
.73844 .08283 .02422 58.8067 181.193 arc
s
newpath
.75368 .09258 .01129 103.807 202.166 arc
s
newpath
.74211 .08567 .00287 67.1658 191.45 arc
s
newpath
.73814 .08335 .00209 56.4497 183.55 arc
s
newpath
.73415 .08107 .00287 48.5503 172.834 arc
s
newpath
.72238 .0745 .01129 37.8342 136.193 arc
s
newpath
.73844 .90882 .02422 178.807 301.193 arc
s
newpath
.72238 .91714 .01129 223.807 322.166 arc
s
newpath
.73415 .91057 .00287 187.166 311.45 arc
s
newpath
.73814 .90829 .00209 176.45 303.55 arc
s
newpath
.74211 .90597 .00287 168.55 292.834 arc
s
newpath
.75368 .89907 .01129 157.834 256.193 arc
s
newpath
.73415 .08107 .00287 48.5503 172.834 arc
s
newpath
.73236 .08007 .00172 36.6325 127.834 arc
s
newpath
.73409 .08105 .00035 47.5027 171.632 arc
s
newpath
.73457 .08132 .00024 55.0227 182.503 arc
s
newpath
.73501 .08157 .00031 64.6295 190.023 arc
s
newpath
.73611 .0822 .00103 93.5503 199.629 arc
s
newpath
.73415 .91057 .00287 187.166 311.45 arc
s
newpath
.73611 .90944 .00103 160.371 266.45 arc
s
newpath
.73501 .91007 .00031 169.977 295.371 arc
s
newpath
.73457 .91032 .00024 177.497 304.977 arc
s
newpath
.73409 .91059 .00035 188.368 312.497 arc
s
newpath
.73236 .91157 .00172 232.166 323.368 arc
s
newpath
.73814 .90829 .00209 176.45 303.55 arc
s
newpath
.73949 .9075 .00098 158.592 258.55 arc
s
newpath
.73848 .90808 .00025 168.756 293.592 arc
s
newpath
.73814 .90828 .00018 176.244 303.756 arc
s
newpath
.73779 .90848 .00025 186.408 311.244 arc
s
newpath
.73678 .90906 .00098 221.45 321.408 arc
s
newpath
.73814 .08335 .00209 56.4497 183.55 arc
s
newpath
.73678 .08258 .00098 38.592 138.55 arc
s
newpath
.73779 .08316 .00025 48.7563 173.592 arc
s
newpath
.73814 .08336 .00018 56.2437 183.756 arc
s
newpath
.73848 .08356 .00025 66.408 191.244 arc
s
newpath
.73949 .08414 .00098 101.45 201.408 arc
s
newpath
.74211 .90597 .00287 168.55 292.834 arc
s
newpath
.74387 .90492 .00172 156.632 247.834 arc
s
newpath
.74216 .90593 .00035 167.503 291.632 arc
s
newpath
.74169 .90621 .00024 175.023 302.503 arc
s
newpath
.74125 .90647 .00031 184.629 310.023 arc
s
newpath
.74015 .90711 .00103 213.55 319.629 arc
s
newpath
.74211 .08567 .00287 67.1658 191.45 arc
s
newpath
.74015 .08453 .00103 40.3705 146.45 arc
s
newpath
.74125 .08517 .00031 49.9773 175.371 arc
s
newpath
.74169 .08543 .00024 57.4973 184.977 arc
s
newpath
.74216 .08571 .00035 68.3675 192.497 arc
s
newpath
.74387 .08672 .00172 112.166 203.368 arc
s
newpath
.75368 .09258 .01129 103.807 202.166 arc
s
newpath
.74517 .08749 .00211 43.4738 157.166 arc
s
newpath
.74753 .08893 .00083 52.3257 178.474 arc
s
newpath
.74875 .08967 .00072 60.1062 187.326 arc
s
newpath
.75029 .09062 .00122 72.9464 195.106 arc
s
newpath
.76118 .09737 .01191 148.807 207.946 arc
s
newpath
.75368 .89907 .01129 157.834 256.193 arc
s
newpath
.76118 .89427 .01191 152.054 211.193 arc
s
newpath
.75029 .90102 .00122 164.894 287.054 arc
s
newpath
.74875 .90197 .00072 172.674 299.894 arc
s
newpath
.74753 .90272 .00083 181.526 307.674 arc
s
newpath
.74517 .90415 .00211 202.834 316.526 arc
s
newpath
.78319 .11146 .03316 75.7367 193.807 arc
s
newpath
.80148 .12658 .01979 120.737 209.626 arc
s
newpath
.78319 .11287 .00408 74.6257 197.985 arc
s
newpath
.77805 .10913 .00278 62.9854 189.918 arc
s
newpath
.77325 .10571 .00359 54.9181 179.614 arc
s
newpath
.76118 .09737 .01191 44.6136 148.807 arc
s
newpath
.78319 .88018 .03316 166.193 284.263 arc
s
newpath
.76118 .89427 .01191 211.193 315.386 arc
s
newpath
.77325 .88593 .00359 180.386 305.082 arc
s
newpath
.77805 .88251 .00278 170.082 297.015 arc
s
newpath
.78319 .87877 .00408 162.015 285.374 arc
s
newpath
.80148 .86506 .01979 150.374 239.263 arc
s
newpath
.76118 .09737 .01191 44.6136 148.807 arc
s
newpath
.75368 .09258 .01129 37.9759 103.807 arc
s
newpath
.76392 .09936 .00135 50.5161 172.976 arc
s
newpath
.76559 .10048 .00082 58.2815 185.516 arc
s
newpath
.76695 .10139 .00095 67.2749 193.282 arc
s
newpath
.76964 .10322 .00252 89.6136 202.275 arc
s
newpath
.76118 .89427 .01191 211.193 315.386 arc
s
newpath
.76964 .88842 .00252 157.725 270.386 arc
s
newpath
.76695 .89025 .00095 166.718 292.725 arc
s
newpath
.76559 .89116 .00082 174.484 301.718 arc
s
newpath
.76392 .89228 .00135 187.024 309.484 arc
s
newpath
.75368 .89907 .01129 256.193 322.024 arc
s
newpath
.77325 .10571 .00359 54.9181 179.614 arc
s
newpath
.77113 .10425 .00209 42.3424 134.614 arc
s
newpath
.77311 .10564 .00044 53.1489 177.342 arc
s
newpath
.77368 .10603 .0003 60.6781 188.149 arc
s
newpath
.77421 .10641 .00039 70.3607 195.678 arc
s
newpath
.77554 .10734 .00133 99.9181 205.361 arc
s
newpath
.77325 .88593 .00359 180.386 305.082 arc
s
newpath
.77554 .8843 .00133 154.639 260.082 arc
s
newpath
.77421 .88524 .00039 164.322 289.639 arc
s
newpath
.77368 .88561 .0003 171.851 299.322 arc
s
newpath
.77311 .886 .00044 182.658 306.851 arc
s
newpath
.77113 .88739 .00209 225.386 317.658 arc
s
newpath
.97446 .44275 .03316 106.193 224.263 arc
s
newpath
.97689 .49582 .02422 118.807 241.193 arc
s
newpath
.97446 .54889 .03316 135.737 253.807 arc
s
newpath
.94908 .69899 .12697 187.5 270.737 arc
s
newpath
1.06638 .49582 .30652 142.5 217.5 arc
s
newpath
.94908 .29265 .12697 89.2633 172.5 arc
s
newpath
.77805 .10913 .00278 62.9854 189.918 arc
s
newpath
.77635 .10792 .00127 44.3985 144.918 arc
s
newpath
.77759 .10881 .00033 54.5266 179.398 arc
s
newpath
.77801 .10911 .00024 62.027 189.527 arc
s
newpath
.77844 .10942 .00033 72.2628 197.027 arc
s
newpath
.77972 .11035 .00133 107.985 207.263 arc
s
newpath
.77805 .88251 .00278 170.082 297.015 arc
s
newpath
.77972 .88129 .00133 152.737 252.015 arc
s
newpath
.77844 .88222 .00033 162.973 287.737 arc
s
newpath
.77801 .88253 .00024 170.473 297.973 arc
s
newpath
.77759 .88283 .00033 180.602 305.473 arc
s
newpath
.77635 .88372 .00127 215.082 315.602 arc
s
newpath
.90049 .20849 .12697 127.5 210.737 arc
s
newpath
.94908 .29265 .12697 172.5 226.703 arc
s
newpath
.86242 .18651 .01374 91.7034 211.406 arc
s
newpath
.84877 .17138 .0082 76.4063 202.032 arc
s
newpath
.83749 .15964 .00942 67.0316 191.328 arc
s
newpath
.81483 .13763 .02422 56.3279 165.737 arc
s
newpath
.90049 .78315 .12697 149.263 232.5 arc
s
newpath
.81483 .85401 .02422 194.263 303.672 arc
s
newpath
.83749 .83201 .00942 168.672 292.968 arc
s
newpath
.84877 .82026 .0082 157.968 283.594 arc
s
newpath
.86242 .80513 .01374 148.594 268.297 arc
s
newpath
.94908 .69899 .12697 133.297 187.5 arc
s
newpath
.78319 .87877 .00408 162.015 285.374 arc
s
newpath
.78552 .87703 .00252 150.517 240.374 arc
s
newpath
.78319 .87875 .0005 161.507 285.517 arc
s
newpath
.78256 .87921 .00034 169.053 296.507 arc
s
newpath
.78199 .87964 .00043 178.625 304.053 arc
s
newpath
.78058 .88067 .00142 207.015 313.625 arc
s
newpath
.78319 .11287 .00408 74.6257 197.985 arc
s
newpath
.78058 .11097 .00142 46.3746 152.985 arc
s
newpath
.78199 .112 .00043 55.9473 181.375 arc
s
newpath
.78256 .11243 .00034 63.4934 190.947 arc
s
newpath
.78319 .11289 .0005 74.4833 198.493 arc
s
newpath
.78552 .11461 .00252 119.626 209.483 arc
s
newpath
.80148 .12658 .01979 120.737 209.626 arc
s
newpath
.78732 .11596 .00316 50.1005 164.626 arc
s
newpath
.79063 .1185 .00129 58.9237 185.101 arc
s
newpath
.79241 .11988 .00115 66.843 193.924 arc
s
newpath
.79472 .12168 .002 80.2518 201.843 arc
s
newpath
.81483 .13763 .02422 165.737 215.252 arc
s
newpath
.80148 .86506 .01979 150.374 239.263 arc
s
newpath
.81483 .85401 .02422 144.748 194.263 arc
s
newpath
.79472 .86996 .002 158.157 279.748 arc
s
newpath
.79241 .87176 .00115 166.076 293.157 arc
s
newpath
.79063 .87314 .00129 174.899 301.076 arc
s
newpath
.78732 .87568 .00316 195.374 309.899 arc
s
newpath
.81483 .13763 .02422 56.3279 165.737 arc
s
newpath
.80148 .12658 .01979 46.9167 120.737 arc
s
newpath
.81787 .14114 .00287 59.298 181.917 arc
s
newpath
.82109 .14405 .0018 67.2291 194.298 arc
s
newpath
.82379 .14654 .00216 76.6751 202.229 arc
s
newpath
.82946 .15183 .00608 101.328 211.675 arc
s
newpath
.81483 .85401 .02422 194.263 303.672 arc
s
newpath
.82946 .83981 .00608 148.325 258.672 arc
s
newpath
.82379 .84511 .00216 157.771 283.325 arc
s
newpath
.82109 .84759 .0018 165.702 292.771 arc
s
newpath
.81787 .8505 .00287 178.083 300.702 arc
s
newpath
.80148 .86506 .01979 239.263 313.083 arc
s
newpath
.83749 .15964 .00942 67.0316 191.328 arc
s
newpath
.83261 .15489 .00522 52.6034 146.328 arc
s
newpath
.83692 .15919 .00115 63.4157 187.603 arc
s
newpath
.8382 .16048 .0008 71.0465 198.416 arc
s
newpath
.83941 .1617 .00105 80.9767 206.047 arc
s
newpath
.84255 .1649 .00367 112.032 215.977 arc
s
newpath
.83749 .83201 .00942 168.672 292.968 arc
s
newpath
.84255 .82674 .00367 144.023 247.968 arc
s
newpath
.83941 .82994 .00105 153.953 279.023 arc
s
newpath
.8382 .83116 .0008 161.584 288.953 arc
s
newpath
.83692 .83245 .00115 172.397 296.584 arc
s
newpath
.83261 .83675 .00522 213.672 307.397 arc
s
newpath
.94908 .29265 .12697 172.5 226.703 arc
s
newpath
.87392 .20059 .01191 66.6521 181.703 arc
s
newpath
.88362 .21351 .00535 76.0604 201.652 arc
s
newpath
.88923 .22131 .00505 84.9587 211.06 arc
s
newpath
.89689 .23238 .00942 101.025 219.959 arc
s
newpath
1.06638 .49582 .30652 217.5 236.025 arc
s
newpath
.94908 .69899 .12697 133.297 187.5 arc
s
newpath
1.06638 .49582 .30652 123.975 142.5 arc
s
newpath
.89689 .75926 .00942 140.041 258.975 arc
s
newpath
.88923 .77034 .00505 148.94 275.041 arc
s
newpath
.88362 .77813 .00535 158.348 283.94 arc
s
newpath
.87392 .79105 .01191 178.297 293.348 arc
s
newpath
.84877 .17138 .0082 76.4063 202.032 arc
s
newpath
.84447 .1669 .00359 55.7537 157.032 arc
s
newpath
.84743 .17005 .00096 65.9135 190.754 arc
s
newpath
.84848 .17117 .00071 73.5158 200.914 arc
s
newpath
.84955 .17232 .00099 83.9962 208.516 arc
s
newpath
.85282 .17587 .00408 121.406 218.996 arc
s
newpath
.84877 .82026 .0082 157.968 283.594 arc
s
newpath
.85282 .81577 .00408 141.004 238.594 arc
s
newpath
.84955 .81932 .00099 151.484 276.004 arc
s
newpath
.84848 .82047 .00071 159.086 286.484 arc
s
newpath
.84743 .82159 .00096 169.246 294.086 arc
s
newpath
.84447 .82474 .00359 202.968 304.246 arc
s
newpath
.86242 .18651 .01374 91.7034 211.406 arc
s
newpath
.85502 .17831 .00445 59.1323 166.406 arc
s
newpath
.85867 .18247 .00142 68.79 194.132 arc
s
newpath
.86021 .18424 .00112 76.5171 203.79 arc
s
newpath
.86191 .18622 .00169 87.9475 211.517 arc
s
newpath
.86858 .19405 .00902 136.703 222.947 arc
s
newpath
.86242 .80513 .01374 148.594 268.297 arc
s
newpath
.86858 .79759 .00902 137.053 223.297 arc
s
newpath
.86191 .80543 .00169 148.483 272.053 arc
s
newpath
.86021 .8074 .00112 156.21 283.483 arc
s
newpath
.85867 .80917 .00142 165.868 291.21 arc
s
newpath
.85502 .81334 .00445 193.594 300.868 arc
s
newpath
.94908 .29265 .12697 89.2633 172.5 arc
s
newpath
.96762 .40226 .02422 134.263 243.672 arc
s
newpath
.95989 .37163 .00942 108.672 232.968 arc
s
newpath
.95536 .356 .0082 97.9684 223.594 arc
s
newpath
.94908 .33661 .01374 88.5937 208.297 arc
s
newpath
.90049 .20849 .12697 73.2966 127.5 arc
s
newpath
.94908 .69899 .12697 187.5 270.737 arc
s
newpath
.90049 .78315 .12697 232.5 286.703 arc
s
newpath
.94908 .65503 .01374 151.703 271.406 arc
s
newpath
.95536 .63564 .0082 136.406 262.032 arc
s
newpath
.95989 .62001 .00942 127.032 251.328 arc
s
newpath
.96762 .58938 .02422 116.328 225.737 arc
s
newpath
.90049 .20849 .12697 73.2966 127.5 arc
s
newpath
.78319 .00532 .30652 63.9746 82.5 arc
s
newpath
.92659 .28382 .00942 80.0413 198.975 arc
s
newpath
.93235 .29599 .00505 88.9396 215.041 arc
s
newpath
.9363 .30476 .00535 98.3479 223.94 arc
s
newpath
.94263 .31961 .01191 118.297 233.348 arc
s
newpath
.90049 .78315 .12697 232.5 286.703 arc
s
newpath
.94263 .67203 .01191 126.652 241.703 arc
s
newpath
.9363 .68688 .00535 136.06 261.652 arc
s
newpath
.93235 .69565 .00505 144.959 271.06 arc
s
newpath
.92659 .70782 .00942 161.025 279.959 arc
s
newpath
.78319 .98632 .30652 277.5 296.025 arc
s
newpath
.94908 .33661 .01374 88.5937 208.297 arc
s
newpath
.94563 .32751 .00902 77.0525 163.297 arc
s
newpath
.94908 .3372 .00169 88.4829 212.053 arc
s
newpath
.94994 .33966 .00112 96.21 223.483 arc
s
newpath
.95071 .34188 .00142 105.868 231.21 arc
s
newpath
.95249 .34712 .00445 133.594 240.868 arc
s
newpath
.94908 .65503 .01374 151.703 271.406 arc
s
newpath
.95249 .64452 .00445 119.132 226.406 arc
s
newpath
.95071 .64976 .00142 128.79 254.132 arc
s
newpath
.94994 .65198 .00112 136.517 263.79 arc
s
newpath
.94908 .65444 .00169 147.947 271.517 arc
s
newpath
.94563 .66413 .00902 196.703 282.947 arc
s
newpath
.97446 .44275 .03316 106.193 224.263 arc
s
newpath
.97566 .46886 .01191 151.193 255.386 arc
s
newpath
.97446 .45423 .00359 120.386 245.082 arc
s
newpath
.97391 .44837 .00278 110.082 237.015 arc
s
newpath
.97324 .44205 .00408 102.015 225.374 arc
s
newpath
.97051 .41935 .01979 90.3743 179.263 arc
s
newpath
.97446 .54889 .03316 135.737 253.807 arc
s
newpath
.97051 .57229 .01979 180.737 269.626 arc
s
newpath
.97324 .5496 .00408 134.626 257.985 arc
s
newpath
.97391 .54327 .00278 122.985 249.918 arc
s
newpath
.97446 .53741 .00359 114.918 239.614 arc
s
newpath
.97566 .52278 .01191 104.614 208.807 arc
s
newpath
.96762 .40226 .02422 134.263 243.672 arc
s
newpath
.96263 .3825 .00608 88.3249 198.672 arc
s
newpath
.96438 .39006 .00216 97.7709 223.325 arc
s
newpath
.96518 .39364 .0018 105.702 232.771 arc
s
newpath
.9661 .39788 .00287 118.083 240.702 arc
s
newpath
.97051 .41935 .01979 179.263 253.083 arc
s
newpath
.96762 .58938 .02422 116.328 225.737 arc
s
newpath
.97051 .57229 .01979 106.917 180.737 arc
s
newpath
.9661 .59376 .00287 119.298 241.917 arc
s
newpath
.96518 .59801 .0018 127.229 254.298 arc
s
newpath
.96438 .60159 .00216 136.675 262.229 arc
s
newpath
.96263 .60914 .00608 161.328 271.675 arc
s
newpath
.95536 .356 .0082 97.9684 223.594 arc
s
newpath
.9535 .35024 .00408 81.0038 178.594 arc
s
newpath
.95493 .35485 .00099 91.4842 216.004 arc
s
newpath
.95539 .35635 .00071 99.0865 226.484 arc
s
newpath
.95584 .35782 .00096 109.246 234.086 arc
s
newpath
.95709 .36196 .00359 142.968 244.246 arc
s
newpath
.95536 .63564 .0082 136.406 262.032 arc
s
newpath
.95709 .62968 .00359 115.754 217.032 arc
s
newpath
.95584 .63382 .00096 125.914 250.754 arc
s
newpath
.95539 .63529 .00071 133.516 260.914 arc
s
newpath
.95493 .63679 .00099 143.996 268.516 arc
s
newpath
.9535 .6414 .00408 181.406 278.996 arc
s
newpath
.97689 .49582 .02422 118.807 241.193 arc
s
newpath
.97606 .51389 .01129 163.807 262.166 arc
s
newpath
.97626 .50042 .00287 127.166 251.45 arc
s
newpath
.97627 .49582 .00209 116.45 243.55 arc
s
newpath
.97626 .49123 .00287 108.55 232.834 arc
s
newpath
.97606 .47775 .01129 97.8342 196.193 arc
s
newpath
.95989 .37163 .00942 108.672 232.968 arc
s
newpath
.95786 .36463 .00367 84.0233 187.968 arc
s
newpath
.95906 .36895 .00105 93.9535 219.023 arc
s
newpath
.95952 .3706 .0008 101.584 228.953 arc
s
newpath
.95999 .37235 .00115 112.397 236.584 arc
s
newpath
.96156 .37824 .00522 153.672 247.397 arc
s
newpath
.95989 .62001 .00942 127.032 251.328 arc
s
newpath
.96156 .6134 .00522 112.603 206.328 arc
s
newpath
.95999 .61929 .00115 123.416 247.603 arc
s
newpath
.95952 .62104 .0008 131.047 258.416 arc
s
newpath
.95906 .6227 .00105 140.977 266.047 arc
s
newpath
.95786 .62701 .00367 172.032 275.977 arc
s
newpath
.97051 .41935 .01979 90.3743 179.263 arc
s
newpath
.96762 .40226 .02422 84.7482 134.263 arc
s
newpath
.97137 .42765 .002 98.157 219.748 arc
s
newpath
.97178 .43056 .00115 106.076 233.157 arc
s
newpath
.97208 .43279 .00129 114.899 241.076 arc
s
newpath
.97263 .43693 .00316 135.374 249.899 arc
s
newpath
.97051 .57229 .01979 180.737 269.626 arc
s
newpath
.97263 .55472 .00316 110.101 224.626 arc
s
newpath
.97208 .55885 .00129 118.924 245.101 arc
s
newpath
.97178 .56109 .00115 126.843 253.924 arc
s
newpath
.97137 .56399 .002 140.252 261.843 arc
s
newpath
.96762 .58938 .02422 225.737 275.252 arc
s
newpath
.97566 .52278 .01191 104.614 208.807 arc
s
newpath
.97606 .51389 .01129 97.9759 163.807 arc
s
newpath
.97531 .52615 .00135 110.516 232.976 arc
s
newpath
.97517 .52816 .00082 118.282 245.516 arc
s
newpath
.97506 .52979 .00095 127.275 253.282 arc
s
newpath
.97482 .53304 .00252 149.614 262.275 arc
s
newpath
.97566 .46886 .01191 151.193 255.386 arc
s
newpath
.97482 .4586 .00252 97.7251 210.386 arc
s
newpath
.97506 .46185 .00095 106.718 232.725 arc
s
newpath
.97517 .46348 .00082 114.484 241.718 arc
s
newpath
.97531 .46549 .00135 127.024 249.484 arc
s
newpath
.97606 .47775 .01129 196.193 262.024 arc
s
newpath
.97606 .47775 .01129 97.8342 196.193 arc
s
newpath
.97566 .46886 .01191 92.0536 151.193 arc
s
newpath
.97606 .48166 .00122 104.894 227.054 arc
s
newpath
.97611 .48347 .00072 112.674 239.894 arc
s
newpath
.97615 .4849 .00083 121.526 247.674 arc
s
newpath
.97621 .48766 .00211 142.834 256.526 arc
s
newpath
.97606 .51389 .01129 163.807 262.166 arc
s
newpath
.97621 .50398 .00211 103.474 217.166 arc
s
newpath
.97615 .50674 .00083 112.326 238.474 arc
s
newpath
.97611 .50817 .00072 120.106 247.326 arc
s
newpath
.97606 .50998 .00122 132.946 255.106 arc
s
newpath
.97566 .52278 .01191 208.807 267.946 arc
s
newpath
.97324 .5496 .00408 134.626 257.985 arc
s
newpath
.97358 .54638 .00142 106.375 212.985 arc
s
newpath
.97339 .54812 .00043 115.947 241.375 arc
s
newpath
.97331 .54883 .00034 123.493 250.947 arc
s
newpath
.97322 .54961 .0005 134.483 258.493 arc
s
newpath
.97289 .55248 .00252 179.626 269.483 arc
s
newpath
.97324 .44205 .00408 102.015 225.374 arc
s
newpath
.97289 .43916 .00252 90.5167 180.374 arc
s
newpath
.97322 .44203 .0005 101.507 225.517 arc
s
newpath
.97331 .44281 .00034 109.053 236.507 arc
s
newpath
.97339 .44352 .00043 118.625 244.053 arc
s
newpath
.97358 .44526 .00142 147.015 253.625 arc
s
newpath
.97446 .45423 .00359 120.386 245.082 arc
s
newpath
.9742 .45144 .00133 94.6393 200.082 arc
s
newpath
.97435 .45306 .00039 104.322 229.639 arc
s
newpath
.9744 .4537 .0003 111.851 239.322 arc
s
newpath
.97446 .45439 .00044 122.658 246.851 arc
s
newpath
.97467 .4568 .00209 165.386 257.658 arc
s
newpath
.97446 .53741 .00359 114.918 239.614 arc
s
newpath
.97467 .53484 .00209 102.342 194.614 arc
s
newpath
.97446 .53725 .00044 113.149 237.342 arc
s
newpath
.9744 .53794 .0003 120.678 248.149 arc
s
newpath
.97435 .53858 .00039 130.361 255.678 arc
s
newpath
.9742 .54021 .00133 159.918 265.361 arc
s
newpath
.97391 .54327 .00278 122.985 249.918 arc
s
newpath
.97411 .5412 .00127 104.398 204.918 arc
s
newpath
.97396 .54271 .00033 114.527 239.398 arc
s
newpath
.9739 .54323 .00024 122.027 249.527 arc
s
newpath
.97385 .54376 .00033 132.263 257.027 arc
s
newpath
.97369 .54533 .00133 167.985 267.263 arc
s
newpath
.97391 .44837 .00278 110.082 237.015 arc
s
newpath
.97369 .44631 .00133 92.7372 192.015 arc
s
newpath
.97385 .44788 .00033 102.973 227.737 arc
s
newpath
.9739 .44841 .00024 110.473 237.973 arc
s
newpath
.97396 .44893 .00033 120.602 245.473 arc
s
newpath
.97411 .45045 .00127 155.082 255.602 arc
s
newpath
.97626 .49123 .00287 108.55 232.834 arc
s
newpath
.97623 .48917 .00172 96.6325 187.834 arc
s
newpath
.97625 .49116 .00035 107.503 231.632 arc
s
newpath
.97625 .49171 .00024 115.023 242.503 arc
s
newpath
.97626 .49222 .00031 124.629 250.023 arc
s
newpath
.97627 .49349 .00103 153.55 259.629 arc
s
newpath
.97626 .50042 .00287 127.166 251.45 arc
s
newpath
.97627 .49815 .00103 100.371 206.45 arc
s
newpath
.97626 .49942 .00031 109.977 235.371 arc
s
newpath
.97625 .49993 .00024 117.497 244.977 arc
s
newpath
.97625 .50048 .00035 128.368 252.497 arc
s
newpath
.97623 .50247 .00172 172.166 263.368 arc
s
newpath
.97627 .49582 .00209 116.45 243.55 arc
s
newpath
.97627 .49426 .00098 98.592 198.55 arc
s
newpath
.97627 .49542 .00025 108.756 233.592 arc
s
newpath
.97627 .49582 .00018 116.244 243.756 arc
s
newpath
.97627 .49622 .00025 126.408 251.244 arc
s
newpath
.97627 .49738 .00098 161.45 261.408 arc
s
.5 .86902 m
.5 .12262 L
s
.8232 .68242 m
.1768 .30922 L
s
.8232 .30922 m
.1768 .68242 L
s
0 0 m
1 0 L
1 .99164 L
0 .99164 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{283, 280},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004K000160P10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIS/k>gYjN[Vi^OShn03ooeGooj[ooooo0:BTY3/k>oo<VOlcolco<laVVIWooiVI
<clo?ginO[fm_Oclo5D00:X00?l00?ooEIfMWC@d=?o<I_lcc<co0<aVIYWoc0<30d92@X61PL30`000
EED0EJX0EOl0EOoooiJFURd];Oo<<olcVLc<olaV<iWoV@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z_Wi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIP/;2dY:BXV9RLS8b000oeD0ojX0ool0oo;blXV9RB0P8?nIoolc
<lc<VL`coiWo<`l?3di>CXf=SLc<c01E05EE0:YE0?mE0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEENGUiGalO1<C4onIVOl0olc<<l`cVIW<oaLG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZ]oOggIfMPd=3OnIIP0c<lc<0<`cIYW<c1/K6eYJFYVIVMSHf01EoeEEojYEoomEomSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VAlO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ0=;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IR<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEL_;bf9RH_ooZ_mVool0<lbIVL`0oiW<<bLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZ/C4a5]KFoooI_mVc00c0<bII/`0c9W<02/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`1VV@00VOoo<omVVLcoolbI<l`0VIVIobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc3<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVCLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l070000?l070000?l070000?l070000?l0
70000?l070000?l0700007l000Co0?oo5002o`030?l007l0001d0003o`0000D00ol01P3o003o00;o
3002o`060?l00?l00ol70003o`0007<0001_0003o`0000Co1P000ol000050003o`3o00`000?o0?l0
1`000ol0000400Co0P000ol0001^0000J`000ol00005o`<00ol00`3oo`0:0003o`0000X000?o0000
2002o`040?ooo`<01Ol20003o`0006X0001Z00Go00<0o`000_l30003o`3o00`000?o00002P000ol0
000:0003o`3o00<00_l00`3o0005of/0001T0004o`3o00?o00D0o`00o`0400?o00<0o`0030000ol0
000:0003o`0000/000?o0?l00_l40004o`00o`800_l0103o0?mU0000HP04o`030?oo008000?o0000
2P000ol0000<0003o`0000P000?o000030000ol0000:00;o00@0ool01?mS0000HP000ol000030003
o`0000h000?o00002`000ol000080003o`0000/000?o00003P000ol000030003o`000640001R0003
o`0000<000?o00003P000ol0000;0003o`0000P000?o00002`000ol0000>0003o`0000<000?o0000
H@0005T00ol60003o`0000<000?o00003P000ol0000;0003o`0000P000?o00002`000ol0000>0003
o`0000<000?o00001003oeX0001G00?o0P000ol000030003o`00008000?o00003`000ol0000;0003
o`0000P000?o00002`000ol0000?0003o`00008000?o00000`000ol00003oeP0001D00Co00<0o`00
0P03o`030?l000800_lC0003o`0000/000?o00001`000ol0000:0003o`0001400_l30003o`0000;o
0`000ol0o`03oeD0001C00Co0`000ol0000200;o0`000ol0000C0003o`0000/000?o00001`000ol0
000:0003o`0001<000Co00000_l40004o`0000CoE00005400ol700Co00<0ool00_lG0003o`0000X0
00?o00001P000ol0000:0003o`0001D01?l00`3oo`02o`L00omB0000D@000ol0o`0;0003o`3o01T0
00?o00002P000ol000060003o`0000X000?o00005`000ol0o`0;0003o`3o0580001<00?o0P03o`/0
00?o0?l06P000ol000090003o`0000H000?o00002@000ol0000H0003o`3o00/00ol200?oC@0004X0
0ol20003o`3o00`000Co003o6`000ol000090003o`0000@000?o00002@000ol0000I0004o`00o``0
00?o0?l00P03od/0001900?o00<0o`000ol:00;o10000ol0000I0003o`0000P000?o000010000ol0
00080003o`0001T000?o00000P02o`X00ol00`3o0003odX0001800;o10001?l0o`02o`H00_l700;o
6P000ol000070003o`0000@000?o00001`000ol0000H00;o1`02o`H00_l0103o0?l400;oB@0004H0
0ol70004o`0000Ko2`000ol0000G0003o`0000L000?o000010000ol000070003o`0001L000?o0000
2@06o`<000?o00001@03odL000160003o`3o00H000?o000050000ol0000G00;o20000ol000020003
o`0000H00_lI0003o`0001@000?o000010000ol0o`170000AP000ol0o`060003o`0001D000?o0000
60000ol000050003o`00008000?o00001@000ol0000H0003o`0001D000?o000010000ol0o`170000
@@03o`800_l60003o`0001L000?o00005`000ol000050003o`00008000?o00001@000ol0000G0003
o`0001L000?o00001002o`800om20000?`04o`030?oo00?o00<0ool00_lK0003o`0001L00_l60004
o`00o`H00_lI0003o`0001T01?l00`3oo`03o`030?oo00;o@00003h00ol200;o00D0o`00o`0P00;o
6@02o`@000Co003o1002oaT00_lP0004o`00o`8000?o00000olo0000?@03o`H000?o00008`000ol0
000H00;o0P001?l00?l200;o6P000ol0000S0003o`0000@00oln0000?@02o`L000?o00009002oaX0
0_l0103oo`02oaX00_lV0003o`0000D00_ln0000>P04o`P000?o00009P000ol0000I00Co6`000ol0
000V0003o`0000H01?lk0000>@02o`8000?o00001P000ol0000W00?o6003oaX00_lY0003o`0000H0
00?o00000_lj0000>@001Ol0003o00L000?o0000:`03oa<00_l200Co4`04ob`000?o00001@001Ol0
003o03X0000j0004o`00o`H00_l`00Go2006o`<00_l300Ko2005oc000_l60004o`00oc/0000k0003
o`3o00D000?o0000=@08o`P000Co0?oo2008ocL000?o00000`000ol0o`0l0000>`02o`D000?o0000
AP001?l0oom80003o`0000<00_ll0000=0000ol0000400;o0`02odP000Ko003o0?m800;o0`02o`H0
00?o0000<`0003800_l00`3oo`0300KoBP001_l00?l0odX01_l300;o00<0ool0<`0003400_l400?o
00<0o`00C@001_l00?l0odh000?o0?l00_l400;o<P00034000?o00001P000ol0o`1<0005o`000?l0
0P000ol0001:0003o`3o00P000?o0000<000034000?o00001002o`8000?o0000BP001Ol0003o0080
00?o0000BP000ol00002o`H000?o0000<00002h000Co0?oo1@000ol000020003o`0004T000?o0000
0P001Ol0003o04/000?o00000P000ol0000300;o00<0o`00;P0002d01?l00`3oo`03o`H000?o0000
B0000ol000020005o`000?l0BP000ol0000400Go00<0ool00_l^0000;@03o`d000?o0000A`000ol0
00030003o`00008000?o0000A`000ol0000;00?o;P0002/00ol@0003o`0004D000?o000010000ol0
00030003o`0004D000?o00003P03ob`0000Z00;o00<0o`003`000ol000140003o`0000D000?o0000
10000ol000140003o`0000h000Co0?oo:`0002X00olA0003o`0004<000?o00001P000ol000050003
o`0004<000?o00003`03ob/0000Z0003o`00018000?o0000@P000ol000060003o`0000D000?o0000
@P000ol0000B0003o`0002T0000W00Co50000ol000110003o`0000L000?o00001P000ol000110003
o`0001801?lX00009`001?l00?lD0003o`00040000?o000020000ol000070003o`00040000?o0000
4P001?l00?lX00009`001?l00?lD0003o`00040000?o000020000ol000070003o`00040000?o0000
4P001?l00?lX00009`001?l00?lD0003o`0003l000?o00002@000ol000080003o`0003l000?o0000
4P001?l00?lX00009`03oaD000?o0000?P000ol0000:0003o`0000T000?o0000?P000ol0000C00?o
:00002L000?o00005@000ol0000n0003o`0000X000?o00002@000ol0000n0003o`0001D000?o0000
9P0002L00_lG0003o`0003`000?o00002`000ol0000:0003o`0003`000?o00005@02obP0000V0004
o`00oaH000?o0000>P02o`h000?o00002`02oc`000?o000050001?l00?lW00008P04o`@000?o0000
4`000ol0000i0003o`0000h000?o00003@000ol0000i0003o`0001<000?o00000P04ob<0000R0003
o`0000D000?o00004P000ol0000i0003o`0000l000?o00003P000ol0000i0003o`00018000?o0000
1@000ol0000Q00008003o`P000?o00004@000ol0000i0003o`0000l000?o00003P000ol0000i0003
o`00014000?o00001P03ob40000P0003o`0000T000?o000040000ol0000h0003o`00010000?o0000
3`000ol0000h0003o`00010000?o00002@000ol0000O00007`02o`/000?o000040000ol0000f00;o
4`000ol0000@00;o>0000ol0000@0003o`0000T00_lP00007`000ol0000;0003o`0000l000?o0000
=@000ol0000C0003o`00018000?o0000=@000ol0000?0003o`0000/000?o00007P0001l000?o0000
2`000ol0000?0003o`0003@000?o000050000ol0000C0003o`0003@000?o00003`000ol0000;0003
o`0001h0000N00;o3P000ol0000>0003o`0003@000?o000050000ol0000C0003o`0003@000?o0000
3P000ol0000<00;o7`0001d00_l?0003o`0000h000?o0000<`000ol0000E0003o`0001@000?o0000
<`000ol0000>0003o`0000d00_lN00007`000ol0000=0003o`0000`000?o0000<P02oaP000?o0000
5@02oc@000?o000030000ol0000=0003o`0001h0000P0003o`0000`000?o000030000ol0000a0003
o`0001P000?o00005`000ol0000a0003o`0000`000?o000030000ol0000O00008@000ol0000<0003
o`0000/000?o0000;`02oa/000?o00006002oc4000?o00002`000ol0000<0003o`000200000R0003
o`0000/000?o00002P000ol0000_0003o`0001/000?o00006P000ol0000_0003o`0000X000?o0000
2`000ol0000Q00008`02o`/000?o00002P000ol0000]00;o7P000ol0000K00;o;`000ol0000:0003
o`0000T00_lT00009@000ol000080003o`0000T000?o0000;@000ol0000N0003o`0001d000?o0000
;@000ol000090003o`0000P000?o0000900002H000?o000020000ol000080003o`0002/00_lQ0003
o`0001h00_l]0003o`0000P000?o000020000ol0000U00009`000ol000070003o`0000P000?o0000
:P000ol0000Q0003o`00020000?o0000:P000ol000080003o`0000L000?o00009P0002P000?o0000
1P000ol000070003o`0002T00_lT0003o`0002400_l[0003o`0000L000?o00001P000ol0000W0000
:@000ol000050003o`0000H000?o00009`03obH000?o00008`03obT000?o00001P000ol000050003
o`0002P0000G00;o4@000ol000050003o`0000D000?o00009P000ol0000W0003o`0002H000?o0000
9P000ol000050003o`0000D000?o00003`02oaP0000G0003o`3o014000?o000010000ol000040003
o`0002D00_lZ0003o`0002L00_lW0003o`0000@000?o000010000ol0000?0003o`3o01P0000F0004
o`0000;o40000ol000030003o`0000<000?o00008`03ob`000?o0000:@03obD000?o00000`000ol0
00030003o`0000h00_l30003o`0001D0000E00;o1@03o`h000?o00000P000ol000020003o`000280
0_l_0003o`0002`00_lT0003o`00008000?o00000P000ol0000<00?o1@02oaH0000D0003o`0000P0
0ol;0003o`00008000Go0000o`0R00?o<@000ol0000^00?o8P001Ol0003o00@000?o00002@03o`X0
00?o00004`0001@000?o00002`02o`X000Go0000o`020003o`0001h00old0003o`0003400olP0004
o`00o`<000?o00002002o`d000?o00004`0001<000?o00003P03o`P00_l0103o0?lM00Co=`000ol0
000d00Co7@001?l0o`02o`P00ol@0003o`000180000C0003o`0001401Ol500?o6`03oc/000?o0000
>003oa/00ol500Go4`000ol0000B00004`000ol0000F00So5007och000?o0000>`07oa@02?lH0003
o`000180000B0003o`0001`05om50003o`0004805olN0003o`000140000B0003o`0001X00ol01@3o
003o05H000?o0000D`001Ol00?l000?o70000ol0000A00004`000ol0000G00;o0P001?l00?l200;o
E0000ol0001A00;o0P001?l00?l200;o6@000ol0000B00004`000ol0000E00;o10001?l00?l400;o
DP000ol0001?00;o10001?l00?l400;o5`000ol0000B00004`000ol0000C00;o1P001Ol0003o00D0
00?o0000C`000ol0001>0003o`0000<000Go0000o`0600;o5@000ol0000B00004P02oa401?l80003
o`00008000?o00000`02odl000?o0000C002o`D000?o00000P000ol0000600Co4@02oa<0000A00;o
00<0ool00_l900Co2`000ol000030003o`0000D00_m=0003o`0004X00_l70003o`0000<000?o0000
2@04o`T01?l00`3oo`0B00003`02o`030?l000@02Ol?0003o`0000@000?o00001P02od/000?o0000
B002o`P000?o000010000ol0000=00Wo1@001?l0ool@00003P02o`8000?o00006`000ol000040003
o`0000P000?o0000B0000ol000170003o`0000P000?o000010000ol0000K0003o`0000;o3`0000h0
00Co003o7@000ol000050003o`0000T00_m80003o`0004D00_l;0003o`0000D000?o00006`001?l0
0?l?00003P001?l00?lM0003o`0000H000?o00002P02odH000?o0000@`02o``000?o00001P000ol0
000K0004o`00o`l0000>00?o7@000ol000080003o`0000/00_m40003o`0004400_l=0003o`0000P0
00?o00006`03o`l0000=00;o7`000ol000080003o`0000d000?o0000@@000ol000100003o`0000d0
00?o000020000ol0000M00;o3P0000`00_l00`3o000M0003o`0000T000?o00003@02od4000?o0000
?P02o`l000?o00002@000ol0000L0004o`3oo`d0000=00;o7P000ol0000;0003o`0000h00_lo0003
o`0003`00_l@0003o`0000/000?o00007002o`h0000=0003o`0001`000?o000030000ol0000@0003
o`0003`000?o0000>`000ol0000@0003o`0000`000?o000070000ol0000<00003002oad000?o0000
3P000ol0000@00;o?0000ol0000i00;o4P000ol0000>0003o`0001/00_l=00002`001?l00?lK0003
o`0000l000?o00004P02ocX000?o0000=`02oa@000?o00003`000ol0000I0004o`00o``0000;00;o
00<0o`006P000ol0000?0003o`0001@00_lh0003o`0003D00_lF0003o`0000l000?o00006@001?l0
ool<00003002oa/000?o00004@000ol0000E0003o`0003D000?o0000=0000ol0000E0003o`000140
00?o00006@02o`d0000<0003o`0001T000?o00004P000ol0000F00;o=@000ol0000b00;o60000ol0
000B0003o`0001T000?o00002`0000/00olI0003o`0001@000?o00005`02oc<000?o0000<002oaT0
00?o000050000ol0000G00?o300000X000Go0000o`0F00;o5`000ol0000I00;o<@000ol0000^00;o
6`000ol0000E00;o5P001Ol0003o00/0000:0005o`000?l05@000ol0000G0003o`0001/000?o0000
;P000ol0000]0003o`0001/000?o00005`000ol0000C0005o`000?l02`0000X000?o00000P000ol0
000@00;o6`000ol0000K00;o;P000ol0000[00;o7@000ol0000I00;o4P000ol000020003o`0000T0
000:00;o10000ol0000>0003o`0001/000?o00007@02ob`000?o0000:@02oal000?o00006`000ol0
000>0003o`0000800_l;000030001Ol0003o00h00_lN0003o`0001l000?o0000:@000ol0000X0003
o`0001l000?o00007003o`d000Go0000o`0=00003@001?l00?l;00?o80000ol0000P00;o:@000ol0
000V00;o8P000ol0000O00?o2P001?l00?l>00003@000ol0o`0:00;o90000ol0000Q00;o9`000ol0
000T00;o8`000ol0000S0003o`0000P000?o0?l03P0000d000?o0?l01`03obH000?o00008`02obD0
00?o00008P02obD000?o00009003o`L000?o0?l03P0000d00_l00`3oo`05obT000?o00009@000ol0
000R0003o`00024000?o00009@000ol0000W00Oo00<0ool03P0000d00ola0003o`0002D00_lR0003
o`0001l00_lW0003o`0002l01?l=00002005o`030?oo034000?o00009`02ob0000?o00007@02obT0
00?o0000;`02o`801?l9000020000ol000020003o`3o034000?o0000:@000ol0000M0003o`0001`0
00?o0000:@000ol0000_0003o`3o00@000?o00001`0000P000Go0000o`030003o`0002l000?o0000
:@02oad000?o00006P02ob/000?o0000;`001Ol0003o00<000?o00001`0000P000Co003o10000ol0
000_0003o`0002/00_lK0003o`0001P00_l]0003o`0002l000?o00000P001?l00?l900002003o`D0
00?o0000;`000ol0000]00;o6@000ol0000F00;o;`000ol0000_0003o`0000<00ol900001`02o`L0
00?o0000;`000ol0000_0003o`0001H000?o00005@000ol0000_0003o`0002l000?o00001@02o`P0
000700;o1`000ol0000_0003o`0003000_lF0003o`0001<00_lb0003o`0002l000?o00001@02o`P0
000700;o1`000ol0000_0003o`0003800_lD0003o`0001400_ld0003o`0002l000?o00001@02o`P0
000700;o1`000ol0000`0003o`0003<00_lB0003o`0000l00_le0003o`00030000?o00001@02o`P0
000700;o1P000ol0000a0003o`0003D000?o00003`000ol0000>0003o`0003D000?o0000<@000ol0
000400;o200000L00ol50003o`00034000?o0000=P02o`l000?o00003002ocP000?o0000<@000ol0
000300?o200000L000Co003o10000ol0000a0003o`0003P00_l=0003o`0000X00_lj0003o`000340
00?o00000P001?l00?l800001`02o`040?l000;o=0000ol0000j0003o`0000X000?o00002@000ol0
000j0003o`0003800_l20004o`3oo`P0000900Co=P000ol0000k00;o2P000ol0000700;o?@000ol0
000d00Co2P0000T00_lh0003o`0003d00_l80003o`0000D00_lo0003o`0003H00_l:000020000ol0
o`0h0003o`0003l00_l60003o`0000<00_m10003o`0003H000?o0?l02@0000L000Go0?l0o`0g0003
o`00044000?o00000`000ol000020003o`00044000?o0000=@001Ol0o`3o00P0000700?o0P000ol0
000d0003o`0004800_l30003o`0000;oA0000ol0000d0003o`0000?o200000L000?o00000`000ol0
000c0003o`0004@00_l0103ooom60003o`0003<000?o00000`000ol0000600001`000ol000030003
o`0003<000?o0000AP02odP000?o0000<`000ol000030003o`0000H000070003o`0000<000?o0000
<`000ol000150004o`3oodL000?o0000<`000ol0000300;o1`0000L000?o00000`000ol0000c0003
o`0004<00_l20004o`3oodD000?o0000<`000ol000030003o`0000H0000700;o10000ol0000c0003
o`0004400_l40004o`0000;o@`000ol0000c0003o`0000800_l800001`000ol0o`020003o`0003@0
00?o0000@0000ol000040003o`0000<000?o0000@0000ol0000d0006o`00o`3o200000L000?o0?l0
0P000ol0000d0003o`0003h00_l70003o`0000@00_m00003o`0003@000Ko003o0?l800002004ocL0
00?o0000?002o`T000?o00001P02och000?o0000=@04o`T0000:00;o=`000ol0000j00;o2`000ol0
000800;o?0000ol0000e00;o2`0000P00ol00`3oo`0e0003o`0003T000?o00002`000ol0000:0003
o`0003T000?o0000<`02o`040?ooo`T000070004o`00o`<000?o0000<P000ol0000g00;o3P000ol0
000;00;o>@000ol0000b0005o`000?l00P000ol0000600001`001?l00?l30003o`00038000?o0000
=@02oa0000?o00003@02ocL000?o0000<P001Ol0003o008000?o00001P0000L00ol50003o`000340
00?o0000=0000ol0000@0003o`0000l000?o0000=0000ol0000a0003o`0000<00ol800001`02o`H0
00?o0000<@000ol0000b00;o4`000ol0000@00;o=0000ol0000a0003o`0000@00_l800001`02o`L0
00?o0000<0000ol0000`00;o5@000ol0000B00;o<P000ol0000`0003o`0000D00_l800001`02o`L0
00?o0000<0000ol0000^00;o5`000ol0000D00;o<0000ol0000`0003o`0000D00_l800001`02o`L0
00?o0000;`000ol0000^0003o`0001L000?o00005P000ol0000^0003o`0002l000?o00001@02o`P0
000700;o1`000ol0000_0003o`0002`00_lJ0003o`0001L00_l^0003o`0002l000?o00001@02o`P0
000800?o1@000ol0000_0003o`0002X00_lL0003o`0001T00_l/0003o`0002l000?o00000`03o`T0
00080004o`00o`@000?o0000;`000ol0000X00;o7P000ol0000K00;o:P000ol0000_0003o`000080
00Co003o2@0000P000Go0000o`030003o`0002l000?o00009`000ol0000N0003o`0001d000?o0000
9`000ol0000_0005o`000?l00`000ol00007000020000ol000020003o`3o034000?o00009P02ob40
00?o00007P02obP000?o0000;`000ol0o`040003o`0000L0000800Ko00<0o`00<0000ol0000T00;o
8`000ol0000P00;o9P000ol0000_0003o`3o00Go2@0000h00ol`0003o`0002<000?o00008`000ol0
000R0003o`0002<000?o0000;P04o`h0000>0003o`0000Ko:P000ol0000Q00;o9P000ol0000S00;o
8`000ol0000X00Ko0P000ol0000=00003@000ol0o`0700?o9P000ol0000P00;o:0000ol0000U00;o
8P000ol0000T00?o1`000ol0o`0>00003@000ol0o`0:00?o8`000ol0000N00;o:P000ol0000W00;o
80000ol0000R00;o2P000ol0o`0>00003002o`030?l000`00olP0003o`0001d000?o0000:P000ol0
000Y0003o`0001d000?o00007`03o``000Co0?oo3@0000/000?o00000P000ol0000=00;o7@000ol0
000L00;o;@000ol0000Z00;o7P000ol0000K00?o3P000ol000020003o`0000X0000:0003o`0000<0
00?o00003`000ol0000J0003o`0001X00_l_0003o`0002`00_lL0003o`0001X000?o00003`000ol0
00030003o`0000T0000:0003o`0000<000?o00004002oaX000?o00006@000ol0000_0003o`0002h0
00?o00006@000ol0000H00;o4P000ol000030003o`0000T0000:0003o`00008000?o00004`000ol0
000F0003o`0001P00_lb0003o`0002l00_lJ0003o`0001H000?o00004`000ol000020003o`0000T0
000:00;o0P000ol0000E0003o`0001D000?o00005P02oc@000?o0000<@02oaP000?o00005@000ol0
000E0003o`0000;o2`0000`00_lI0003o`0001@000?o00005002ocH000?o0000<`02oaH000?o0000
50000ol0000G00;o3@0000`000?o00006@000ol0000C0003o`0001<000?o0000=P000ol0000e0003
o`0001<000?o00004`000ol0000I0003o`0000/0000<0003o`0001T000?o00004P000ol0000B00;o
>@000ol0000f00;o50000ol0000B0003o`0001T000?o00002`0000/00olK0003o`00010000?o0000
4@02oc/000?o0000>002oa<000?o000040000ol0000I00?o300000/000Co003o6`000ol0000?0003
o`0000l00_lm0003o`0003X00_lA0003o`0000l000?o00006@001?l00?l<000030000ol0o`0L0003
o`0000h000?o00003P000ol0000m0003o`0003`000?o00003P000ol0000>0003o`0001X000?o0?l0
3@0000d000?o000070000ol0000=0003o`0000`00_m00003o`0003d00_l>0003o`0000d000?o0000
70000ol0000<00003@02oad000?o000030000ol0000;00;o@P000ol0000o00;o3@000ol0000<0003
o`0001/00_l>00003002o`030?l001`000?o00002P000ol0000;0003o`00048000?o0000@@000ol0
000;0003o`0000X000?o00006`001?l0ool=00003@03oah000?o00002@000ol0000900;oA@000ol0
001200;o2`000ol000090003o`0001`00ol>00003P03oad000?o000020000ol0000800;oA`000ol0
001400;o2P000ol000080003o`0001/00ol?00003P000ol0o`0N0003o`0000H000?o00001`02odT0
00?o0000AP02o`T000?o00001P000ol0000L0003o`3o00l0000>0004o`00oad000?o00001P000ol0
00060003o`0004T000?o0000B0000ol000060003o`0000H000?o00006`001?l00?l?00003P02o`03
0?l001`000?o00001@000ol0000500;oC0000ol0001900;o1`000ol000050003o`0001/000Co0?oo
3`0000l00_l00`3o000300_o3P000ol000040003o`0000<00_m>0003o`0004/00_l50003o`0000@0
00?o0000300;o`@000Co0?oo400001401_l;00Co2P000ol000030003o`0000800_m@0003o`0004d0
0_l40003o`0000<000?o00002004o`/01_lB00004P000ol0000A00Co1P000ol000030005o`000?l0
DP000ol0001?0005o`000?l01@000ol0000400Co4`000ol0000A00004P000ol0000E00;o1@000ol0
00020004o`3ooe<000?o0000D002o`030?l000<000?o00000`02oaL000?o00004@0001<000?o0000
5P02o`<000Co00000omE0003o`0005800ol30004o`0000;o60000ol0000B00004`000ol0000H00;o
00@0o`000_mG0003o`0005@00_l20004o`3ooaX000?o00004P00018000?o00006`02o`030?oo05P0
00?o0000E@02o`030?oo01d000?o00004@00018000?o0000700GodD000?o0000@P0Goah000?o0000
4@0001<000?o00005P07oaD01oln0003o`0003/01olE00Oo60000ol0000B00004`000ol0000A00Go
10001?l0oolK00Co>P000ol0000g00Co6`02o`030?l000<01OlC0003o`000180000C0003o`0000d0
1?l80006o`00o`3o7P03ocL000?o0000=003oah000?o0?l00P000ol0000600Co3`000ol0000B0000
50000ol0000900?o30001?l00?l20003o`0001h01?lc0003o`0003001?lP0004o`00o`8000?o0000
2P03o`/000?o00004`0001@00_l800;o3P001Ol0003o00<000?o00008@03oc0000?o0000;@03ob<0
00Go0000o`030003o`0000`00_l800;o5@0001H000?o00000P03o`l000?o00000P000ol000020003
o`0002<000?o0000;@000ol0000/0003o`0002<000?o00000P000ol000020003o`0000d00ol40003
o`0001D0000F0005o`000?l04@000ol000030003o`0000<000?o00008`04ob/000?o0000:004obD0
00?o00000`000ol000030003o`0000l000Go0000o`0G00005`03oa4000?o000010000ol000030003
o`0002L000?o0000:0000ol0000W0003o`0002L000?o00000`000ol000040003o`0000l00olH0000
5`000ol0000@0003o`0000D000?o000010000ol0000W00;o:0000ol0000U00;o:@000ol000040003
o`0000D000?o000040000ol0000F0000:@000ol000060003o`0000D000?o0000:003obD000?o0000
8P03obX000?o00001@000ol000060003o`0002P0000X0003o`0000H000?o00001P000ol0000[00;o
8`000ol0000Q0003o`0002/000?o00001P000ol000060003o`0002L0000W0003o`0000L000?o0000
1`000ol0000/0003o`00020000?o00007`02obd000?o00001`000ol000070003o`0002H0000U00;o
2P000ol000080003o`0002`00_lP0003o`0001d00_l^0003o`0000P000?o00002002obH0000T0003
o`0000X000?o000020000ol0000^0003o`0001d000?o000070000ol0000^0003o`0000P000?o0000
2P000ol0000S00008`000ol0000:0003o`0000X000?o0000;P02oad000?o00006P02oc0000?o0000
2P000ol0000:0003o`000280000R0003o`0000/000?o00002P000ol0000`0003o`0001X000?o0000
6@000ol0000`0003o`0000X000?o00002`000ol0000Q00008@000ol0000<0003o`0000/000?o0000
<002oaX000?o00005`02oc8000?o00002`000ol0000<0003o`000200000O00;o3`000ol0000;0003
o`00038000?o00005`000ol0000F0003o`00038000?o00002`000ol0000=00;o800001h000?o0000
3P000ol0000<0003o`0003<000?o00005P000ol0000E0003o`0003<000?o000030000ol0000>0003
o`0001d0000M00;o40000ol0000<0003o`0003<000?o00005P000ol0000E0003o`0003<000?o0000
30000ol0000>00;o7P0001l000?o000030000ol0000>0003o`0003<000?o00005@000ol0000D0003
o`0003<000?o00003P000ol0000<0003o`0001h0000O0003o`0000`000?o00003P000ol0000d00;o
5@000ol0000B00;o=P000ol0000>0003o`0000`000?o00007P0001l000?o00002`000ol0000?0003
o`0003H000?o00004P000ol0000A0003o`0003H000?o00003`000ol0000;0003o`0001h0000O00;o
30000ol0000?0003o`0003L000?o00004@000ol0000@0003o`0003L000?o00003`000ol0000:00;o
8000020000?o00002@000ol0000@0003o`0003L000?o00004@000ol0000@0003o`0003L000?o0000
40000ol000090003o`0001l0000P00?o20000ol0000A0003o`0003P000?o000040000ol0000?0003
o`0003P000?o00004@000ol0000600?o8@00028000?o00001P000ol0000A0003o`0003T00_l@0003
o`0000d00_lk0003o`00014000?o00001P000ol0000Q00008P04o`@000?o00004P000ol0000k0003
o`0000d000?o000030000ol0000k0003o`00018000?o00000P04ob<0000U0005o`000?l05P000ol0
000k0003o`0000`000?o00002`000ol0000k0003o`0001@000Go0000o`0V00009P000ol0o`0G0003
o`0003/000?o000030000ol0000;0003o`0003/000?o00005@000ol0o`0W00009`02oaL000?o0000
?0000ol0000;0003o`0000X000?o0000?0000ol0000E00;o:00002L000?o0?l05@000ol0000n0003
o`0000X000?o00002@000ol0000n0003o`0001<000?o0?l0:00002L000Co003o50000ol0000n0003
o`0000X000?o00002@000ol0000n0003o`00018000Co003o:00002L000Co003o50000ol0000o0003
o`0000T000?o000020000ol0000o0003o`00018000Co003o:00002L000Co003o50000ol000100003
o`0000P000?o00001`000ol000100003o`00018000Co003o:00002L01?lD0003o`00040000?o0000
20000ol000070003o`00040000?o00004P04obP0000Z00;o4`000ol000110003o`0000L000?o0000
1P000ol000110003o`0001400_l[0000:P000ol0o`0A0003o`0004<000?o00001P000ol000050003
o`0004<000?o00003`000ol0o`0[0000:P03oa4000?o0000A0000ol000050003o`0000@000?o0000
A0000ol0000?00?o:`0002/01?l?0003o`0004D000?o000010000ol000030003o`0004D000?o0000
3@04ob`0000]0003o`3o00d000?o0000AP000ol000040003o`0000<000?o0000AP000ol0000;0003
o`3o02h0000]00?o00<0ool01Ol50003o`0004L000?o00000`000ol000020003o`0004L000?o0000
0`07o`040?ooobh0000^0003o`3o00L000Go0000o`1;0003o`00008000Go0000o`1;0005o`000?l0
1`000ol0o`0_0000<@000ol000050004o`00od/000?o00000P001Ol0003o04/000Co003o1`000ol0
000`0000<@000ol000050004o`00od`000Go0000o`020003o`0004X000Co003o1`000ol0000`0000
<@02o`<01_m=0005o`000?l00P000ol0001;00Ko0`02oc80000b00;o00<0o`001006odT000Ko003o
0?m900Ko1@001?l0oolc0000=0000ol000040003o`0000<000?o0000AP001_l00?l0odP000?o0000
0`000ol000040003o`0003<0000k00;o1@000ol000150006o`00o`3oA`000ol0000300;o?00003/0
00?o0?l01@02ocD02Ol80004o`3oo`P02Ole00;o1@000ol0o`0l0000>`000ol0o`070003o`0002h0
1?l900Ko0`02o`<01_l900Co<0000ol000050003o`3o03`0000j0004o`00o`L000?o0000:P04oa<0
2?lC00Go:`000ol000050004o`00oc/0000i00;o0P000ol000060003o`0002H00olJ00;o6`02obP0
00?o00001P000ol00002ocX0000j00Co20000ol0000U0003o`0001T00_l0103ooolK0003o`0002D0
00?o00001P04oc/0000m00;o1`000ol0000S00;o6P02o`800_l200;o6P02obD000?o00001@02och0
000m00?o1P000ol0000R0003o`0001P00_l30004o`00o`<00_lJ0003o`00028000?o00001003och0
000n00?o00<0ool00ol200;o7`000ol0000G00;o1@001?l00?l500;o6@000ol0000M00;o0P000ol0
o`02o`040?ooocl0000o00?o0P05o`800olK0003o`0001L000?o00001@001?l00?l70003o`0001L0
00?o00006@03o`801Ol200?o@00004400ol200;o1@000ol0000H0003o`0001P000?o00001@001?l0
0?l70003o`0001P000?o000060000ol0000300;o0P03od8000160003o`3o00D000?o00005P000ol0
000G00;o1`000ol000020003o`0000D00_lI0003o`0001H000?o00000`000ol0o`170000AP000ol0
o`060003o`0001<00_lI0003o`0000L000?o00000P000ol000070003o`0001L00_lE0003o`0000@0
00?o0?l0A`0004H00ol60004o`0000So2@000ol0000I0003o`0000L000?o00000P000ol000070003
o`0001T000?o00001`08o`<000?o00001003odL0001800;o0`06o`P00_l60003o`0001T000?o0000
1`000ol000040003o`0000L000?o00006@000ol0000400;o2006o`<00_m90000B@04o`<00_l;0003
o`0000<000?o000060000ol000080003o`0000@000?o000020000ol0000H0003o`0000<000?o0000
2@02o`<01?m:0000BP03o`060?ooo`3o2`001Ol0003o01X000?o00002@000ol000040003o`0000T0
00?o000060001Ol0003o00/000?o0?l00_l0103ooom;0000C002o`<000?o0?l02`000ol0o`0J0003
o`0000T000?o00001P000ol000090003o`0001P000?o0?l02`000ol0o`0300;oC@00054000?o0?l0
2`000ol0o`0J0003o`0000T000?o00001P000ol000090003o`0001P000?o0?l02`000ol0o`1B0000
D@03o`L02_lF0003o`0000X000?o00001P000ol0000:0003o`0001@02_l700?oDP0005<01?l30003
o`0000800_l40003o`0001<000?o00002P000ol000060003o`0000X000?o00004`000ol0000200?o
0`001?l00004oe@0001D00Co00<0o`000P02o`8000?o00000P000ol0000A0003o`0000/000?o0000
1`000ol0000:0003o`00014000?o00000P001Ol0003o00<000?o0?l00omE0000E`03o`8000?o0000
0`000ol000020003o`00010000?o00002P000ol000080003o`0000X000?o000040000ol000020003
o`0000<000?o00000omH0000F@03o`H000?o00000`000ol0000>0003o`0000/000?o000020000ol0
000;0003o`0000h000?o00000`000ol0000400?oFP00068000?o00000`000ol0000>0003o`0000/0
00?o000020000ol0000;0003o`0000h000?o00000`000ol0001Q0000HP000ol000030003o`0000h0
00?o00002`000ol000080003o`0000/000?o00003P000ol000030003o`000640001R00Co00@0ool0
0_l=0003o`0000/000?o000020000ol0000;0003o`0000/01Ol00`3oo`02of<0001T0004o`3o00;o
0P001?l0ool300Co00<0o`003@000ol000080003o`0000`000?o0?l00ol300;o00@0o`000_l0103o
0?mU0000JP05o`040?l0o`<000?o0?l00_l;0003o`0000X000?o00002@03o`030?l0008000Co0?l0
1Om[0000J`000ol00005o`<00_l30003o`0000P000?o00002P000ol000080004o`0000;o0`05o`80
00?o0000JP0006l000?o00001?l50003o`0000H00ol<00?o20000ol0000300Co0P000ol0001^0000
M0000ol0000500?o00D0ool0o`020003o`0000X000Go003o0002o`040?ooo`L000?o0000L`0007l0
00Co003o50001?l00?n00000o`0L0000o`0L0000o`0L0000o`0L0000o`0L0000o`0L0000\
\>"],
  ImageRangeCache->{{{0, 282}, {279, 0}} -> {-1.05225, -1.04106, 0.00746279, 
  0.00746279}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["An 18-gon"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
gon18 = NGP[RegularPolygon[18, 2*Pi/3, 0]];
group18 = PolygonInvGroup[gon18,1];
inv = PolygonInversion[gon18];
z = ZPoint[0.0];
imp = Map[#[z]&, inv];\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
angles = Map[Angle, imp];
lpos = Map[1.15*{Cos[#], Sin[#]}&, angles];
lab = {\"CDCiDi\",\"CD\",\"C\",\"Di\",\"DiCi\",\"CiDi\",\"Ci\",\"D\",\"DC\",\"\
DCDiCi\",
        \"BA\",\"B\",\"Ai\",\"AiBi\",\"BiAi\",\"Bi\",\"A\",\"AB\"};
ptl = Table[Text[FontForm[lab[[i]],
        {\"Times-Roman\", 16}], lpos[[i]],
        {0,0}, lpos[[i]]], {i,1,Length[imp]}];\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{Thickness[0.004], {GrayLevel[0.85], 
\tgroup18 /. Polygon -> FilledPolygon,
\tGrayLevel[0.6], gon18 /. Polygon -> FilledPolygon}, 
\tptl}]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .98481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.414079 0.492404 0.414079 [
[.58269 .96136 -2.35026 -29.8618 ]
[.58269 .96136 2.35026 29.8618 ]
[.7381 .9048 -0.25481 -15.4413 ]
[.7381 .9048 .25481 15.4413 ]
[.86478 .79849 -0.92443 -10.5662 ]
[.86478 .79849 .92443 10.5662 ]
[.94747 .65527 -6.83178 -10.4679 ]
[.94747 .65527 6.83178 10.4679 ]
[.97619 .4924 -17.5 -7.5 ]
[.97619 .4924 17.5 7.5 ]
[.94747 .32954 -19.0098 -1.06234 ]
[.94747 .32954 19.0098 1.06234 ]
[.86478 .18631 -12.0983 -0.36115 ]
[.86478 .18631 12.0983 .36115 ]
[.7381 .08001 -10.4952 -3.1782 ]
[.7381 .08001 10.4952 3.1782 ]
[.58269 .02345 -9.73031 -11.9925 ]
[.58269 .02345 9.73031 11.9925 ]
[.41731 .02345 -2.35026 -29.8618 ]
[.41731 .02345 2.35026 29.8618 ]
[.2619 .08001 -0.25481 -15.4413 ]
[.2619 .08001 .25481 15.4413 ]
[.13522 .18631 -0.92443 -10.5662 ]
[.13522 .18631 .92443 10.5662 ]
[.05253 .32954 -6.83178 -10.4679 ]
[.05253 .32954 6.83178 10.4679 ]
[.02381 .4924 -17.5 -7.5 ]
[.02381 .4924 17.5 7.5 ]
[.05253 .65527 -19.0098 -1.06234 ]
[.05253 .65527 19.0098 1.06234 ]
[.13522 .79849 -12.0983 -0.36115 ]
[.13522 .79849 12.0983 .36115 ]
[.2619 .9048 -10.4952 -3.1782 ]
[.2619 .9048 10.4952 3.1782 ]
[.41731 .96136 -9.73031 -11.9925 ]
[.41731 .96136 9.73031 11.9925 ]
[ 0 0 0 0 ]
[ 1 .98481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.85 g
.20254 .43995 m
.20558 .4492 L
.20802 .45862 L
.20986 .46817 L
.2111 .47783 L
.21171 .48754 L
.21171 .49727 L
.2111 .50698 L
.20986 .51663 L
.20802 .52619 L
.20558 .53561 L
.20254 .54485 L
.20254 .54485 L
.13511 .55674 L
.13511 .55674 L
.13302 .5544 L
.13079 .55217 L
.12844 .55009 L
.12597 .54815 L
.12339 .54635 L
.1207 .54471 L
.11792 .54324 L
.11507 .54193 L
.11213 .54079 L
.10914 .53982 L
.10914 .53982 L
.10867 .5382 L
.10807 .53661 L
.10734 .53508 L
.1065 .53361 L
.10553 .53222 L
.10446 .53091 L
.10329 .52969 L
.10202 .52856 L
.10067 .52754 L
.09924 .52664 L
.09924 .52664 L
.09919 .52556 L
.09904 .52449 L
.0988 .52344 L
.09847 .52241 L
.09805 .52142 L
.09754 .52047 L
.09694 .51956 L
.09627 .51872 L
.09553 .51794 L
.09472 .51722 L
.09472 .51722 L
.0948 .51645 L
.09481 .51567 L
.09475 .51489 L
.09461 .51413 L
.0944 .51338 L
.09413 .51265 L
.09378 .51195 L
.09338 .51129 L
.09291 .51066 L
.09239 .51009 L
.09239 .51009 L
.09252 .50949 L
.09259 .50887 L
.0926 .50826 L
.09256 .50764 L
.09245 .50703 L
.09229 .50644 L
.09207 .50586 L
.0918 .50531 L
.09148 .50478 L
.0911 .50429 L
.0911 .50429 L
.09126 .50379 L
.09136 .50327 L
.09142 .50275 L
.09142 .50222 L
.09138 .5017 L
.09128 .50118 L
.09113 .50067 L
.09094 .50018 L
.09069 .49971 L
.09041 .49927 L
.09041 .49927 L
.09058 .49882 L
.09071 .49836 L
.0908 .49788 L
.09084 .4974 L
.09083 .49692 L
.09077 .49644 L
.09067 .49597 L
.09053 .49551 L
.09033 .49507 L
.0901 .49465 L
.0901 .49465 L
.0903 .49423 L
.09046 .49379 L
.09057 .49333 L
.09064 .49287 L
.09066 .4924 L
.09064 .49194 L
.09057 .49147 L
.09046 .49102 L
.0903 .49058 L
.0901 .49016 L
.0901 .49016 L
.09033 .48974 L
.09053 .48929 L
.09067 .48883 L
.09077 .48836 L
.09083 .48789 L
.09084 .4874 L
.0908 .48692 L
.09071 .48645 L
.09058 .48599 L
.09041 .48554 L
.09041 .48554 L
.09069 .48509 L
.09094 .48463 L
.09113 .48414 L
.09128 .48363 L
.09138 .48311 L
.09142 .48259 L
.09142 .48206 L
.09136 .48153 L
.09126 .48102 L
.0911 .48051 L
.0911 .48051 L
.09148 .48002 L
.0918 .4795 L
.09207 .47895 L
.09229 .47837 L
.09245 .47777 L
.09256 .47717 L
.0926 .47655 L
.09259 .47593 L
.09252 .47532 L
.09239 .47472 L
.09239 .47472 L
.09291 .47414 L
.09338 .47352 L
.09378 .47286 L
.09413 .47216 L
.0944 .47143 L
.09461 .47068 L
.09475 .46991 L
.09481 .46914 L
.0948 .46836 L
.09472 .46759 L
.09472 .46759 L
.09553 .46687 L
.09627 .46609 L
.09694 .46524 L
.09754 .46434 L
.09805 .46339 L
.09847 .4624 L
.0988 .46137 L
.09904 .46032 L
.09919 .45925 L
.09924 .45817 L
.09924 .45817 L
.10067 .45726 L
.10202 .45625 L
.10329 .45512 L
.10446 .4539 L
.10553 .45259 L
.1065 .45119 L
.10734 .44973 L
.10807 .4482 L
.10867 .44661 L
.10914 .44498 L
.10914 .44498 L
.11213 .44402 L
.11507 .44288 L
.11792 .44157 L
.1207 .44009 L
.12339 .43846 L
.12597 .43666 L
.12844 .43472 L
.13079 .43263 L
.13302 .43041 L
.13511 .42806 L
.13511 .42806 L
.20254 .43995 L
F
0 g
.004 w
[ ] 0 setdash
newpath
.05844 .4924 .15335 -20 20 arc
s
.20254 .54485 m
.13511 .55674 L
s
newpath
.09431 .59098 .05326 286.165 320 arc
s
newpath
.08872 .54485 .02103 300 346.165 arc
s
newpath
.08716 .52664 .01207 308.747 360 arc
s
newpath
.08651 .51596 .00831 -44.9685 8.7474 arc
s
newpath
.08618 .50842 .00642 -40 15.0315 arc
s
newpath
.08601 .50244 .00542 -35.756 20 arc
s
newpath
.08592 .49725 .00492 -31.8808 24.244 arc
s
newpath
.08589 .4924 .00477 -28.1192 28.1192 arc
s
newpath
.08592 .48756 .00492 -24.244 31.8808 arc
s
newpath
.08601 .48237 .00542 -20 35.756 arc
s
newpath
.08618 .47639 .00642 -15.0315 40 arc
s
newpath
.08651 .46885 .00831 -8.7474 44.9685 arc
s
newpath
.08716 .45817 .01207 0 51.2526 arc
s
newpath
.08872 .43995 .02103 13.835 60 arc
s
newpath
.09431 .39383 .05326 40 73.835 arc
s
.13511 .42806 m
.20254 .43995 L
s
.85 g
.23842 .34138 m
.23811 .35111 L
.23719 .36079 L
.23565 .3704 L
.2335 .37989 L
.23076 .38923 L
.22743 .39838 L
.22353 .40729 L
.21907 .41594 L
.21408 .42429 L
.20856 .4323 L
.20254 .43995 L
.20254 .43995 L
.13511 .42806 L
.13511 .42806 L
.13395 .42514 L
.13262 .42229 L
.13112 .41953 L
.12946 .41686 L
.12765 .41429 L
.12568 .41183 L
.12358 .40949 L
.12134 .40729 L
.11898 .40521 L
.11649 .40328 L
.11649 .40328 L
.11661 .40159 L
.11659 .3999 L
.11643 .39821 L
.11613 .39654 L
.11571 .3949 L
.11515 .3933 L
.11446 .39175 L
.11366 .39026 L
.11273 .38884 L
.1117 .3875 L
.1117 .3875 L
.11202 .38647 L
.11225 .38542 L
.11238 .38435 L
.11242 .38327 L
.11237 .38219 L
.11221 .38112 L
.11196 .38007 L
.11162 .37905 L
.11119 .37806 L
.11067 .37711 L
.11067 .37711 L
.11101 .37641 L
.11129 .37568 L
.11149 .37493 L
.11163 .37417 L
.11169 .37339 L
.11168 .37261 L
.1116 .37184 L
.11144 .37107 L
.11121 .37033 L
.11092 .36961 L
.11092 .36961 L
.11125 .36909 L
.11153 .36854 L
.11175 .36796 L
.11192 .36737 L
.11203 .36676 L
.11208 .36615 L
.11207 .36553 L
.112 .36492 L
.11188 .36431 L
.1117 .36373 L
.1117 .36373 L
.11201 .36331 L
.11229 .36286 L
.11252 .36238 L
.11271 .36189 L
.11284 .36138 L
.11293 .36086 L
.11296 .36033 L
.11295 .3598 L
.11288 .35928 L
.11276 .35877 L
.11276 .35877 L
.11308 .35841 L
.11336 .35802 L
.1136 .3576 L
.1138 .35716 L
.11396 .35671 L
.11407 .35624 L
.11414 .35576 L
.11416 .35528 L
.11413 .3548 L
.11405 .35432 L
.11405 .35432 L
.11438 .35399 L
.11468 .35363 L
.11494 .35324 L
.11517 .35283 L
.11535 .3524 L
.11549 .35196 L
.11558 .3515 L
.11563 .35103 L
.11563 .35056 L
.11559 .3501 L
.11559 .3501 L
.11595 .34978 L
.11628 .34943 L
.11658 .34905 L
.11684 .34864 L
.11705 .34821 L
.11722 .34776 L
.11735 .3473 L
.11743 .34682 L
.11747 .34634 L
.11746 .34586 L
.11746 .34586 L
.11788 .34554 L
.11827 .34519 L
.11862 .34479 L
.11893 .34437 L
.1192 .34392 L
.11942 .34344 L
.1196 .34294 L
.11973 .34243 L
.1198 .34191 L
.11983 .34138 L
.11983 .34138 L
.12035 .34105 L
.12083 .34066 L
.12128 .34024 L
.12168 .33977 L
.12204 .33927 L
.12234 .33873 L
.12259 .33817 L
.12279 .33758 L
.12293 .33698 L
.12302 .33637 L
.12302 .33637 L
.12371 .33601 L
.12436 .33559 L
.12497 .3351 L
.12553 .33456 L
.12604 .33397 L
.12649 .33334 L
.12688 .33267 L
.1272 .33196 L
.12746 .33122 L
.12765 .33047 L
.12765 .33047 L
.12865 .33008 L
.12962 .32959 L
.13054 .32903 L
.13141 .32838 L
.13221 .32766 L
.13295 .32688 L
.13361 .32602 L
.1342 .32512 L
.1347 .32416 L
.13511 .32316 L
.13511 .32316 L
.13677 .3228 L
.13839 .32231 L
.13997 .32169 L
.14149 .32094 L
.14294 .32007 L
.14432 .31909 L
.14562 .318 L
.14683 .31681 L
.14793 .31553 L
.14893 .31416 L
.14893 .31416 L
.15207 .31428 L
.15522 .31421 L
.15835 .31396 L
.16147 .31352 L
.16455 .3129 L
.16759 .3121 L
.17058 .31112 L
.1735 .30996 L
.17636 .30864 L
.17912 .30715 L
.17912 .30715 L
.23842 .34138 L
F
0 g
newpath
.08507 .34138 .15335 0 40 arc
s
.20254 .43995 m
.13511 .42806 L
s
newpath
.08507 .44628 .05326 306.165 340 arc
s
newpath
.09558 .40102 .02103 -40 6.16498 arc
s
newpath
.10035 .38337 .01207 -31.2526 20 arc
s
newpath
.10339 .37312 .00831 -24.9685 28.7474 arc
s
newpath
.10566 .36592 .00642 -20 35.0315 arc
s
newpath
.10754 .36024 .00542 -15.756 40 arc
s
newpath
.10924 .35533 .00492 -11.8808 44.244 arc
s
newpath
.11087 .35077 .00477 -8.11919 48.1192 arc
s
newpath
.11255 .34623 .00492 -4.24403 51.8808 arc
s
newpath
.11441 .34138 .00542 0 55.756 arc
s
newpath
.11662 .33582 .00642 4.96851 60 arc
s
newpath
.1195 .32885 .00831 11.2526 64.9685 arc
s
newpath
.12377 .31904 .01207 20 71.2526 arc
s
newpath
.13146 .30245 .02103 33.835 80 arc
s
newpath
.15249 .26102 .05326 60 93.835 arc
s
.17912 .30715 m
.23842 .34138 L
s
.85 g
.20254 .54485 m
.20856 .5525 L
.21408 .56052 L
.21907 .56887 L
.22353 .57752 L
.22743 .58643 L
.23076 .59558 L
.2335 .60491 L
.23565 .61441 L
.23719 .62401 L
.23811 .6337 L
.23842 .64343 L
.23842 .64343 L
.17912 .67766 L
.17912 .67766 L
.17636 .67617 L
.1735 .67485 L
.17058 .67369 L
.16759 .67271 L
.16455 .67191 L
.16147 .67129 L
.15835 .67085 L
.15522 .6706 L
.15207 .67053 L
.14893 .67065 L
.14893 .67065 L
.14793 .66928 L
.14683 .66799 L
.14562 .6668 L
.14432 .66571 L
.14294 .66473 L
.14149 .66387 L
.13997 .66312 L
.13839 .6625 L
.13677 .662 L
.13511 .66164 L
.13511 .66164 L
.1347 .66065 L
.1342 .65969 L
.13361 .65878 L
.13295 .65793 L
.13221 .65714 L
.13141 .65642 L
.13054 .65578 L
.12962 .65521 L
.12865 .65473 L
.12765 .65434 L
.12765 .65434 L
.12746 .65358 L
.1272 .65285 L
.12688 .65214 L
.12649 .65147 L
.12604 .65083 L
.12553 .65024 L
.12497 .64971 L
.12436 .64922 L
.12371 .6488 L
.12302 .64843 L
.12302 .64843 L
.12293 .64782 L
.12279 .64722 L
.12259 .64664 L
.12234 .64608 L
.12204 .64554 L
.12168 .64504 L
.12128 .64457 L
.12083 .64414 L
.12035 .64376 L
.11983 .64343 L
.11983 .64343 L
.1198 .6429 L
.11973 .64238 L
.1196 .64187 L
.11942 .64137 L
.1192 .64089 L
.11893 .64044 L
.11862 .64001 L
.11827 .63962 L
.11788 .63926 L
.11746 .63895 L
.11746 .63895 L
.11747 .63846 L
.11743 .63798 L
.11735 .63751 L
.11722 .63704 L
.11705 .63659 L
.11684 .63616 L
.11658 .63576 L
.11628 .63538 L
.11595 .63503 L
.11559 .63471 L
.11559 .63471 L
.11563 .63424 L
.11563 .63378 L
.11558 .63331 L
.11549 .63285 L
.11535 .63241 L
.11517 .63197 L
.11494 .63156 L
.11468 .63118 L
.11438 .63082 L
.11405 .63049 L
.11405 .63049 L
.11413 .63001 L
.11416 .62953 L
.11414 .62905 L
.11407 .62857 L
.11396 .6281 L
.1138 .62765 L
.1136 .62721 L
.11336 .62679 L
.11308 .6264 L
.11276 .62604 L
.11276 .62604 L
.11288 .62553 L
.11295 .625 L
.11296 .62448 L
.11293 .62395 L
.11284 .62343 L
.11271 .62292 L
.11252 .62243 L
.11229 .62195 L
.11201 .6215 L
.1117 .62108 L
.1117 .62108 L
.11188 .62049 L
.112 .61989 L
.11207 .61928 L
.11208 .61866 L
.11203 .61805 L
.11192 .61744 L
.11175 .61684 L
.11153 .61627 L
.11125 .61572 L
.11092 .6152 L
.11092 .6152 L
.11121 .61448 L
.11144 .61373 L
.1116 .61297 L
.11168 .6122 L
.11169 .61142 L
.11163 .61064 L
.11149 .60987 L
.11129 .60912 L
.11101 .6084 L
.11067 .6077 L
.11067 .6077 L
.11119 .60675 L
.11162 .60576 L
.11196 .60474 L
.11221 .60369 L
.11237 .60262 L
.11242 .60154 L
.11238 .60046 L
.11225 .59939 L
.11202 .59833 L
.1117 .5973 L
.1117 .5973 L
.11273 .59596 L
.11366 .59454 L
.11446 .59305 L
.11515 .5915 L
.11571 .5899 L
.11613 .58826 L
.11643 .5866 L
.11659 .58491 L
.11661 .58322 L
.11649 .58152 L
.11649 .58152 L
.11898 .57959 L
.12134 .57752 L
.12358 .57531 L
.12568 .57298 L
.12765 .57052 L
.12946 .56795 L
.13112 .56528 L
.13262 .56251 L
.13395 .55967 L
.13511 .55674 L
.13511 .55674 L
.20254 .54485 L
F
0 g
newpath
.08507 .64343 .15335 -40 0 arc
s
.23842 .64343 m
.17912 .67766 L
s
newpath
.15249 .72379 .05326 266.165 300 arc
s
newpath
.13146 .68236 .02103 280 326.165 arc
s
newpath
.12377 .66577 .01207 288.747 340 arc
s
newpath
.1195 .65596 .00831 295.031 348.747 arc
s
newpath
.11662 .64899 .00642 300 355.031 arc
s
newpath
.11441 .64343 .00542 -55.756 0 arc
s
newpath
.11255 .63858 .00492 -51.8808 4.24403 arc
s
newpath
.11087 .63404 .00477 -48.1192 8.11919 arc
s
newpath
.10924 .62947 .00492 -44.244 11.8808 arc
s
newpath
.10754 .62457 .00542 -40 15.756 arc
s
newpath
.10566 .61889 .00642 -35.0315 20 arc
s
newpath
.10339 .61169 .00831 -28.7474 24.9685 arc
s
newpath
.10035 .60143 .01207 -20 31.2526 arc
s
newpath
.09558 .58378 .02103 -6.16498 40 arc
s
newpath
.08507 .53853 .05326 20 53.835 arc
s
.13511 .55674 m
.20254 .54485 L
s
.85 g
.30585 .26102 m
.30223 .27006 L
.29805 .27884 L
.29332 .28735 L
.28806 .29553 L
.28229 .30337 L
.27603 .31082 L
.26932 .31787 L
.26217 .32447 L
.25461 .33061 L
.24669 .33625 L
.23842 .34138 L
.23842 .34138 L
.17912 .30715 L
.17912 .30715 L
.17903 .304 L
.17875 .30087 L
.17829 .29776 L
.17764 .29468 L
.17682 .29165 L
.17582 .28867 L
.17464 .28575 L
.17329 .28291 L
.17178 .28015 L
.1701 .27749 L
.1701 .27749 L
.17079 .27594 L
.17135 .27434 L
.17178 .2727 L
.17207 .27103 L
.17223 .26935 L
.17225 .26765 L
.17214 .26596 L
.17189 .26429 L
.17151 .26264 L
.17099 .26102 L
.17099 .26102 L
.17165 .26017 L
.17222 .25925 L
.17272 .25829 L
.17312 .25729 L
.17344 .25626 L
.17366 .2552 L
.17378 .25413 L
.17381 .25305 L
.17375 .25197 L
.17358 .25091 L
.17358 .25091 L
.17414 .25037 L
.17465 .24978 L
.1751 .24914 L
.17549 .24847 L
.17581 .24776 L
.17607 .24702 L
.17626 .24627 L
.17637 .2455 L
.17641 .24472 L
.17638 .24394 L
.17638 .24394 L
.17687 .24356 L
.17732 .24314 L
.17773 .24268 L
.17809 .24218 L
.1784 .24165 L
.17866 .24109 L
.17886 .2405 L
.17901 .2399 L
.17909 .23929 L
.17912 .23868 L
.17912 .23868 L
.17957 .23839 L
.17998 .23806 L
.18036 .2377 L
.1807 .2373 L
.181 .23686 L
.18126 .23641 L
.18148 .23592 L
.18164 .23542 L
.18176 .23491 L
.18182 .23438 L
.18182 .23438 L
.18224 .23415 L
.18264 .23388 L
.18301 .23357 L
.18335 .23323 L
.18365 .23286 L
.18392 .23245 L
.18414 .23203 L
.18432 .23158 L
.18446 .23112 L
.18455 .23065 L
.18455 .23065 L
.18498 .23045 L
.18538 .23021 L
.18576 .22994 L
.18611 .22963 L
.18643 .22929 L
.18671 .22891 L
.18696 .22852 L
.18716 .22809 L
.18732 .22766 L
.18744 .2272 L
.18744 .2272 L
.18789 .22703 L
.18832 .22682 L
.18873 .22656 L
.18911 .22626 L
.18946 .22593 L
.18978 .22557 L
.19006 .22518 L
.1903 .22476 L
.19049 .22432 L
.19065 .22386 L
.19065 .22386 L
.19115 .22371 L
.19164 .22351 L
.1921 .22326 L
.19254 .22296 L
.19295 .22263 L
.19332 .22226 L
.19366 .22185 L
.19395 .22141 L
.1942 .22095 L
.19441 .22046 L
.19441 .22046 L
.19501 .22033 L
.1956 .22013 L
.19616 .21988 L
.1967 .21958 L
.19721 .21923 L
.19768 .21883 L
.19811 .21839 L
.19849 .21791 L
.19883 .21739 L
.19912 .21685 L
.19912 .21685 L
.19989 .21674 L
.20065 .21657 L
.20138 .21632 L
.2021 .21601 L
.20278 .21563 L
.20342 .21518 L
.20401 .21468 L
.20456 .21413 L
.20505 .21353 L
.20549 .21288 L
.20549 .21288 L
.20657 .21286 L
.20764 .21274 L
.2087 .21252 L
.20973 .21221 L
.21074 .21181 L
.2117 .21132 L
.21261 .21075 L
.21347 .21009 L
.21427 .20937 L
.215 .20857 L
.215 .20857 L
.21668 .2088 L
.21837 .20889 L
.22007 .20884 L
.22175 .20866 L
.22342 .20835 L
.22505 .2079 L
.22664 .20732 L
.22818 .20661 L
.22966 .20578 L
.23107 .20484 L
.23107 .20484 L
.23398 .20602 L
.23696 .20704 L
.23999 .20787 L
.24306 .20852 L
.24617 .20899 L
.24931 .20928 L
.25245 .20938 L
.25559 .2093 L
.25873 .20903 L
.26184 .20857 L
.26184 .20857 L
.30585 .26102 L
F
0 g
newpath
.16174 .20857 .15335 20 60 arc
s
.23842 .34138 m
.17912 .30715 L
s
newpath
.12586 .30715 .05326 326.165 360 arc
s
newpath
.15123 .26822 .02103 -20 26.165 arc
s
newpath
.16174 .25326 .01207 -11.2526 40 arc
s
newpath
.16811 .24466 .00831 -4.96851 48.7474 arc
s
newpath
.1727 .23868 .00642 0 55.0315 arc
s
newpath
.17641 .23398 .00542 4.24403 60 arc
s
newpath
.17968 .22995 .00492 8.11919 64.244 arc
s
newpath
.18278 .22622 .00477 11.8808 68.1192 arc
s
newpath
.18591 .22253 .00492 15.756 71.8808 arc
s
newpath
.18931 .21861 .00542 20 75.756 arc
s
newpath
.19329 .21414 .00642 24.9685 80 arc
s
newpath
.19839 .20857 .00831 31.2526 84.9685 arc
s
newpath
.20575 .20081 .01207 40 91.2526 arc
s
newpath
.21865 .18786 .02103 53.835 100 arc
s
newpath
.25259 .15612 .05326 80 113.835 arc
s
.26184 .20857 m
.30585 .26102 L
s
.85 g
.23842 .64343 m
.24669 .64856 L
.25461 .6542 L
.26217 .66034 L
.26932 .66694 L
.27603 .67398 L
.28229 .68144 L
.28806 .68927 L
.29332 .69746 L
.29805 .70596 L
.30223 .71475 L
.30585 .72379 L
.30585 .72379 L
.26184 .77624 L
.26184 .77624 L
.25873 .77578 L
.25559 .77551 L
.25245 .77543 L
.24931 .77553 L
.24617 .77581 L
.24306 .77628 L
.23999 .77694 L
.23696 .77777 L
.23398 .77878 L
.23107 .77997 L
.23107 .77997 L
.22966 .77902 L
.22818 .7782 L
.22664 .77749 L
.22505 .77691 L
.22342 .77646 L
.22175 .77615 L
.22007 .77596 L
.21837 .77592 L
.21668 .77601 L
.215 .77624 L
.215 .77624 L
.21427 .77544 L
.21347 .77471 L
.21261 .77406 L
.2117 .77349 L
.21074 .773 L
.20973 .7726 L
.2087 .77229 L
.20764 .77207 L
.20657 .77195 L
.20549 .77193 L
.20549 .77193 L
.20505 .77128 L
.20456 .77068 L
.20401 .77012 L
.20342 .76962 L
.20278 .76918 L
.2021 .7688 L
.20138 .76849 L
.20065 .76824 L
.19989 .76807 L
.19912 .76796 L
.19912 .76796 L
.19883 .76741 L
.19849 .7669 L
.19811 .76642 L
.19768 .76598 L
.19721 .76558 L
.1967 .76523 L
.19616 .76492 L
.1956 .76468 L
.19501 .76448 L
.19441 .76435 L
.19441 .76435 L
.1942 .76386 L
.19395 .7634 L
.19366 .76296 L
.19332 .76255 L
.19295 .76218 L
.19254 .76184 L
.1921 .76155 L
.19164 .7613 L
.19115 .7611 L
.19065 .76095 L
.19065 .76095 L
.19049 .76049 L
.1903 .76005 L
.19006 .75963 L
.18978 .75924 L
.18946 .75887 L
.18911 .75854 L
.18873 .75825 L
.18832 .75799 L
.18789 .75778 L
.18744 .7576 L
.18744 .7576 L
.18732 .75715 L
.18716 .75671 L
.18696 .75629 L
.18671 .75589 L
.18643 .75552 L
.18611 .75518 L
.18576 .75487 L
.18538 .75459 L
.18498 .75436 L
.18455 .75416 L
.18455 .75416 L
.18446 .75369 L
.18432 .75323 L
.18414 .75278 L
.18392 .75235 L
.18365 .75195 L
.18335 .75158 L
.18301 .75123 L
.18264 .75093 L
.18224 .75066 L
.18182 .75042 L
.18182 .75042 L
.18176 .7499 L
.18164 .74939 L
.18148 .74889 L
.18126 .7484 L
.181 .74794 L
.1807 .74751 L
.18036 .74711 L
.17998 .74674 L
.17957 .74642 L
.17912 .74613 L
.17912 .74613 L
.17909 .74551 L
.17901 .7449 L
.17886 .7443 L
.17866 .74372 L
.1784 .74316 L
.17809 .74263 L
.17773 .74213 L
.17732 .74167 L
.17687 .74124 L
.17638 .74087 L
.17638 .74087 L
.17641 .74009 L
.17637 .73931 L
.17626 .73854 L
.17607 .73779 L
.17581 .73705 L
.17549 .73634 L
.1751 .73567 L
.17465 .73503 L
.17414 .73444 L
.17358 .7339 L
.17358 .7339 L
.17375 .73283 L
.17381 .73176 L
.17378 .73068 L
.17366 .72961 L
.17344 .72855 L
.17312 .72752 L
.17272 .72652 L
.17222 .72556 L
.17165 .72464 L
.17099 .72379 L
.17099 .72379 L
.17151 .72217 L
.17189 .72052 L
.17214 .71885 L
.17225 .71715 L
.17223 .71546 L
.17207 .71377 L
.17178 .71211 L
.17135 .71047 L
.17079 .70887 L
.1701 .70732 L
.1701 .70732 L
.17178 .70465 L
.17329 .7019 L
.17464 .69906 L
.17582 .69614 L
.17682 .69316 L
.17764 .69013 L
.17829 .68705 L
.17875 .68394 L
.17903 .68081 L
.17912 .67766 L
.17912 .67766 L
.23842 .64343 L
F
0 g
newpath
.16174 .77624 .15335 300 340 arc
s
.30585 .72379 m
.26184 .77624 L
s
newpath
.25259 .82869 .05326 246.165 280 arc
s
newpath
.21865 .79695 .02103 260 306.165 arc
s
newpath
.20575 .784 .01207 268.747 320 arc
s
newpath
.19839 .77624 .00831 275.031 328.747 arc
s
newpath
.19329 .77067 .00642 280 335.031 arc
s
newpath
.18931 .7662 .00542 284.244 340 arc
s
newpath
.18591 .76228 .00492 288.119 344.244 arc
s
newpath
.18278 .75859 .00477 291.881 348.119 arc
s
newpath
.17968 .75486 .00492 295.756 351.881 arc
s
newpath
.17641 .75083 .00542 300 355.756 arc
s
newpath
.1727 .74613 .00642 -55.0315 0 arc
s
newpath
.16811 .74015 .00831 -48.7474 4.96851 arc
s
newpath
.16174 .73155 .01207 -40 11.2526 arc
s
newpath
.15123 .71659 .02103 -26.165 20 arc
s
newpath
.12586 .67766 .05326 0 33.835 arc
s
.17912 .67766 m
.23842 .64343 L
s
.85 g
.39669 .20857 m
.39021 .21582 L
.38327 .22265 L
.37592 .22902 L
.36817 .23492 L
.36007 .24031 L
.35164 .24517 L
.34292 .24949 L
.33395 .25325 L
.32475 .25644 L
.31537 .25903 L
.30585 .26102 L
.30585 .26102 L
.26184 .20857 L
.26184 .20857 L
.26282 .20559 L
.26363 .20255 L
.26426 .19947 L
.26471 .19635 L
.26497 .19322 L
.26505 .19008 L
.26494 .18693 L
.26464 .1838 L
.26417 .1807 L
.2635 .17762 L
.2635 .17762 L
.26468 .1764 L
.26575 .17509 L
.26671 .17369 L
.26756 .17223 L
.26829 .17069 L
.26889 .16911 L
.26936 .16748 L
.2697 .16582 L
.2699 .16414 L
.26997 .16245 L
.26997 .16245 L
.27088 .16187 L
.27173 .16121 L
.27253 .16047 L
.27325 .15967 L
.2739 .15881 L
.27447 .15789 L
.27495 .15693 L
.27535 .15592 L
.27565 .15489 L
.27587 .15383 L
.27587 .15383 L
.27658 .15351 L
.27726 .15313 L
.2779 .15269 L
.27849 .15219 L
.27904 .15163 L
.27953 .15103 L
.27996 .15038 L
.28034 .1497 L
.28064 .14898 L
.28088 .14824 L
.28088 .14824 L
.28146 .14805 L
.28203 .14781 L
.28257 .14751 L
.28308 .14717 L
.28356 .14677 L
.28399 .14634 L
.28438 .14586 L
.28472 .14534 L
.28502 .1448 L
.28525 .14423 L
.28525 .14423 L
.28577 .14412 L
.28627 .14395 L
.28675 .14374 L
.28721 .14348 L
.28764 .14317 L
.28804 .14283 L
.28841 .14245 L
.28873 .14203 L
.28902 .14159 L
.28926 .14112 L
.28926 .14112 L
.28973 .14105 L
.2902 .14093 L
.29065 .14077 L
.29109 .14056 L
.2915 .14031 L
.29189 .14002 L
.29225 .1397 L
.29257 .13934 L
.29286 .13896 L
.2931 .13854 L
.2931 .13854 L
.29357 .1385 L
.29403 .13842 L
.29448 .13829 L
.29491 .13812 L
.29533 .13791 L
.29572 .13765 L
.29609 .13736 L
.29643 .13704 L
.29673 .13668 L
.297 .1363 L
.297 .1363 L
.29748 .13629 L
.29796 .13623 L
.29843 .13613 L
.29889 .13598 L
.29933 .13579 L
.29975 .13556 L
.30015 .13529 L
.30051 .13498 L
.30085 .13463 L
.30115 .13425 L
.30115 .13425 L
.30168 .13428 L
.3022 .13426 L
.30273 .13418 L
.30324 .13406 L
.30374 .13388 L
.30421 .13366 L
.30467 .13339 L
.3051 .13308 L
.30549 .13273 L
.30585 .13234 L
.30585 .13234 L
.30646 .13242 L
.30708 .13244 L
.30769 .1324 L
.3083 .1323 L
.3089 .13214 L
.30948 .13193 L
.31003 .13166 L
.31056 .13134 L
.31105 .13097 L
.31151 .13056 L
.31151 .13056 L
.31227 .13072 L
.31304 .13082 L
.31382 .13084 L
.3146 .13079 L
.31537 .13066 L
.31612 .13046 L
.31685 .1302 L
.31755 .12987 L
.31822 .12947 L
.31885 .12901 L
.31885 .12901 L
.31988 .12936 L
.32092 .12961 L
.32199 .12977 L
.32307 .12983 L
.32415 .1298 L
.32522 .12967 L
.32628 .12944 L
.32731 .12912 L
.32831 .12871 L
.32927 .12821 L
.32927 .12821 L
.33077 .129 L
.33232 .12967 L
.33393 .1302 L
.33558 .13061 L
.33725 .13088 L
.33894 .13102 L
.34063 .13102 L
.34232 .13088 L
.34399 .13061 L
.34564 .1302 L
.34564 .1302 L
.34797 .13231 L
.35042 .13428 L
.35299 .1361 L
.35565 .13777 L
.35841 .13927 L
.36126 .14061 L
.36418 .14178 L
.36716 .14278 L
.3702 .1436 L
.37328 .14423 L
.37328 .14423 L
.39669 .20857 L
F
0 g
newpath
.27922 .11 .15335 40 80 arc
s
.30585 .26102 m
.26184 .20857 L
s
newpath
.21179 .19036 .05326 -13.835 20 arc
s
newpath
.24894 .16245 .02103 0 46.165 arc
s
newpath
.26393 .15199 .01207 8.7474 60 arc
s
newpath
.27285 .14609 .00831 15.0315 68.7474 arc
s
newpath
.27922 .14204 .00642 20 75.0315 arc
s
newpath
.28431 .13889 .00542 24.244 80 arc
s
newpath
.28876 .13622 .00492 28.1192 84.244 arc
s
newpath
.29295 .13378 .00477 31.8808 88.1192 arc
s
newpath
.29716 .13138 .00492 35.756 91.8808 arc
s
newpath
.30169 .12886 .00542 40 95.756 arc
s
newpath
.30696 .12602 .00642 44.9685 100 arc
s
newpath
.31365 .12253 .00831 51.2526 104.969 arc
s
newpath
.32323 .11776 .01207 60 111.253 arc
s
newpath
.33978 .11 .02103 73.835 120 arc
s
newpath
.38252 .09178 .05326 100 133.835 arc
s
.37328 .14423 m
.39669 .20857 L
s
.85 g
.30585 .72379 m
.31537 .72578 L
.32475 .72837 L
.33395 .73155 L
.34292 .73531 L
.35164 .73964 L
.36007 .7445 L
.36817 .74989 L
.37592 .75578 L
.38327 .76216 L
.39021 .76898 L
.39669 .77624 L
.39669 .77624 L
.37328 .84057 L
.37328 .84057 L
.3702 .84121 L
.36716 .84203 L
.36418 .84303 L
.36126 .8442 L
.35841 .84554 L
.35565 .84704 L
.35299 .84871 L
.35042 .85053 L
.34797 .8525 L
.34564 .85461 L
.34564 .85461 L
.34399 .8542 L
.34232 .85393 L
.34063 .85379 L
.33894 .85379 L
.33725 .85393 L
.33558 .8542 L
.33393 .85461 L
.33232 .85514 L
.33077 .85581 L
.32927 .85659 L
.32927 .85659 L
.32831 .8561 L
.32731 .85569 L
.32628 .85537 L
.32522 .85514 L
.32415 .85501 L
.32307 .85498 L
.32199 .85504 L
.32092 .8552 L
.31988 .85545 L
.31885 .8558 L
.31885 .8558 L
.31822 .85534 L
.31755 .85494 L
.31685 .85461 L
.31612 .85434 L
.31537 .85415 L
.3146 .85402 L
.31382 .85397 L
.31304 .85399 L
.31227 .85409 L
.31151 .85425 L
.31151 .85425 L
.31105 .85384 L
.31056 .85347 L
.31003 .85315 L
.30948 .85288 L
.3089 .85266 L
.3083 .85251 L
.30769 .85241 L
.30708 .85237 L
.30646 .85239 L
.30585 .85246 L
.30585 .85246 L
.30549 .85208 L
.3051 .85173 L
.30467 .85142 L
.30421 .85115 L
.30374 .85093 L
.30324 .85075 L
.30273 .85063 L
.3022 .85055 L
.30168 .85053 L
.30115 .85055 L
.30115 .85055 L
.30085 .85018 L
.30051 .84983 L
.30015 .84952 L
.29975 .84925 L
.29933 .84901 L
.29889 .84882 L
.29843 .84868 L
.29796 .84857 L
.29748 .84852 L
.297 .84851 L
.297 .84851 L
.29673 .84813 L
.29643 .84777 L
.29609 .84745 L
.29572 .84715 L
.29533 .8469 L
.29491 .84669 L
.29448 .84652 L
.29403 .84639 L
.29357 .8463 L
.2931 .84626 L
.2931 .84626 L
.29286 .84585 L
.29257 .84546 L
.29225 .84511 L
.29189 .84478 L
.2915 .8445 L
.29109 .84425 L
.29065 .84404 L
.2902 .84388 L
.28973 .84376 L
.28926 .84369 L
.28926 .84369 L
.28902 .84322 L
.28873 .84277 L
.28841 .84236 L
.28804 .84198 L
.28764 .84163 L
.28721 .84133 L
.28675 .84107 L
.28627 .84086 L
.28577 .84069 L
.28525 .84057 L
.28525 .84057 L
.28502 .84001 L
.28472 .83946 L
.28438 .83895 L
.28399 .83847 L
.28356 .83803 L
.28308 .83764 L
.28257 .83729 L
.28203 .837 L
.28146 .83675 L
.28088 .83657 L
.28088 .83657 L
.28064 .83582 L
.28034 .83511 L
.27996 .83442 L
.27953 .83378 L
.27904 .83317 L
.27849 .83262 L
.2779 .83212 L
.27726 .83168 L
.27658 .83129 L
.27587 .83098 L
.27587 .83098 L
.27565 .82992 L
.27535 .82888 L
.27495 .82788 L
.27447 .82692 L
.2739 .826 L
.27325 .82514 L
.27253 .82433 L
.27173 .8236 L
.27088 .82294 L
.26997 .82236 L
.26997 .82236 L
.2699 .82067 L
.2697 .81898 L
.26936 .81732 L
.26889 .8157 L
.26829 .81411 L
.26756 .81258 L
.26671 .81112 L
.26575 .80972 L
.26468 .80841 L
.2635 .80719 L
.2635 .80719 L
.26417 .80411 L
.26464 .801 L
.26494 .79787 L
.26505 .79473 L
.26497 .79159 L
.26471 .78845 L
.26426 .78534 L
.26363 .78226 L
.26282 .77922 L
.26184 .77624 L
.26184 .77624 L
.30585 .72379 L
F
0 g
newpath
.27922 .87481 .15335 280 320 arc
s
.39669 .77624 m
.37328 .84057 L
s
newpath
.38252 .89302 .05326 226.165 260 arc
s
newpath
.33978 .87481 .02103 240 286.165 arc
s
newpath
.32323 .86705 .01207 248.747 300 arc
s
newpath
.31365 .86228 .00831 255.031 308.747 arc
s
newpath
.30696 .85879 .00642 260 315.031 arc
s
newpath
.30169 .85595 .00542 264.244 320 arc
s
newpath
.29716 .85343 .00492 268.119 324.244 arc
s
newpath
.29295 .85103 .00477 271.881 328.119 arc
s
newpath
.28876 .84858 .00492 275.756 331.881 arc
s
newpath
.28431 .84591 .00542 280 335.756 arc
s
newpath
.27922 .84277 .00642 284.969 340 arc
s
newpath
.27285 .83872 .00831 291.253 344.969 arc
s
newpath
.26393 .83281 .01207 300 351.253 arc
s
newpath
.24894 .82236 .02103 -46.165 0 arc
s
newpath
.21179 .79445 .05326 -20 13.835 arc
s
.26184 .77624 m
.30585 .72379 L
s
.85 g
.5 .19036 m
.49142 .19495 L
.48257 .19899 L
.47348 .20247 L
.46419 .20536 L
.45473 .20765 L
.44515 .20934 L
.43548 .21042 L
.42576 .21088 L
.41603 .21073 L
.40633 .20996 L
.39669 .20857 L
.39669 .20857 L
.37328 .14423 L
.37328 .14423 L
.37523 .14177 L
.37703 .13919 L
.37867 .13651 L
.38015 .13373 L
.38147 .13088 L
.38262 .12795 L
.38359 .12496 L
.38439 .12192 L
.385 .11883 L
.38543 .11572 L
.38543 .11572 L
.38695 .11497 L
.38841 .11411 L
.38979 .11312 L
.39108 .11204 L
.39229 .11085 L
.3934 .10956 L
.3944 .10819 L
.39528 .10675 L
.39605 .10524 L
.39669 .10367 L
.39669 .10367 L
.39775 .10344 L
.39878 .10311 L
.39977 .10269 L
.40072 .10219 L
.40163 .1016 L
.40248 .10093 L
.40326 .10019 L
.40398 .09938 L
.40462 .09851 L
.40518 .09759 L
.40518 .09759 L
.40596 .09754 L
.40673 .09741 L
.40748 .09721 L
.40821 .09695 L
.40891 .09661 L
.40958 .09621 L
.41021 .09575 L
.41079 .09524 L
.41133 .09467 L
.4118 .09405 L
.4118 .09405 L
.41242 .09408 L
.41303 .09404 L
.41364 .09395 L
.41424 .0938 L
.41482 .09359 L
.41538 .09333 L
.41591 .09301 L
.41641 .09265 L
.41687 .09224 L
.41729 .09178 L
.41729 .09178 L
.41781 .09185 L
.41834 .09186 L
.41886 .09183 L
.41938 .09174 L
.41989 .0916 L
.42039 .09142 L
.42086 .09118 L
.42131 .09091 L
.42173 .09059 L
.42211 .09023 L
.42211 .09023 L
.42258 .09032 L
.42306 .09037 L
.42355 .09037 L
.42403 .09033 L
.4245 .09024 L
.42496 .0901 L
.42541 .08991 L
.42583 .08969 L
.42623 .08942 L
.42661 .08912 L
.42661 .08912 L
.42706 .08924 L
.42752 .08932 L
.42799 .08936 L
.42846 .08934 L
.42892 .08928 L
.42938 .08918 L
.42982 .08903 L
.43025 .08884 L
.43065 .08861 L
.43103 .08834 L
.43103 .08834 L
.43149 .0885 L
.43196 .08861 L
.43244 .08868 L
.43292 .08869 L
.4334 .08867 L
.43387 .08859 L
.43434 .08847 L
.43479 .0883 L
.43523 .08809 L
.43564 .08784 L
.43564 .08784 L
.43612 .08805 L
.43663 .0882 L
.43714 .08831 L
.43767 .08837 L
.43819 .08838 L
.43872 .08833 L
.43924 .08824 L
.43975 .08809 L
.44024 .08789 L
.4407 .08765 L
.4407 .08765 L
.44125 .08794 L
.44183 .08816 L
.44242 .08834 L
.44302 .08845 L
.44364 .08851 L
.44425 .08851 L
.44487 .08844 L
.44547 .08832 L
.44606 .08814 L
.44663 .08791 L
.44663 .08791 L
.44729 .08833 L
.44799 .08868 L
.44871 .08896 L
.44946 .08918 L
.45022 .08933 L
.451 .0894 L
.45178 .0894 L
.45255 .08933 L
.45332 .08919 L
.45407 .08897 L
.45407 .08897 L
.45491 .08964 L
.45581 .09024 L
.45676 .09076 L
.45775 .09118 L
.45877 .09152 L
.45983 .09176 L
.46089 .09191 L
.46197 .09197 L
.46305 .09192 L
.46412 .09178 L
.46412 .09178 L
.46526 .09304 L
.4665 .09419 L
.46783 .09525 L
.46923 .09619 L
.47071 .09702 L
.47225 .09772 L
.47385 .0983 L
.47548 .09875 L
.47714 .09907 L
.47883 .09925 L
.47883 .09925 L
.4803 .10203 L
.48193 .10472 L
.48372 .10731 L
.48565 .10978 L
.48773 .11214 L
.48995 .11438 L
.49229 .11647 L
.49475 .11843 L
.49732 .12024 L
.5 .12189 L
.5 .12189 L
.5 .19036 L
F
0 g
newpath
.42332 .05755 .15335 60 100 arc
s
.39669 .20857 m
.37328 .14423 L
s
newpath
.33248 .11 .05326 6.16498 40 arc
s
newpath
.37693 .09648 .02103 20 66.165 arc
s
newpath
.3946 .09178 .01207 28.7474 80 arc
s
newpath
.405 .08928 .00831 35.0315 88.7474 arc
s
newpath
.41237 .08765 .00642 40 95.0315 arc
s
newpath
.41823 .08644 .00542 44.244 100 arc
s
newpath
.42332 .08546 .00492 48.1192 104.244 arc
s
newpath
.42809 .08459 .00477 51.8808 108.119 arc
s
newpath
.43287 .08377 .00492 55.756 111.881 arc
s
newpath
.43799 .08296 .00542 60 115.756 arc
s
newpath
.44392 .08209 .00642 64.9685 120 arc
s
newpath
.4514 .0811 .00831 71.2526 124.969 arc
s
newpath
.46203 .07989 .01207 80 131.253 arc
s
newpath
.48023 .07826 .02103 93.835 140 arc
s
newpath
.52663 .07576 .05326 120 153.835 arc
s
.5 .12189 m
.5 .19036 L
s
.85 g
.39669 .77624 m
.40633 .77485 L
.41603 .77408 L
.42576 .77393 L
.43548 .77439 L
.44515 .77547 L
.45473 .77716 L
.46419 .77945 L
.47348 .78234 L
.48257 .78581 L
.49142 .78986 L
.5 .79445 L
.5 .79445 L
.5 .86292 L
.5 .86292 L
.49732 .86457 L
.49475 .86638 L
.49229 .86833 L
.48995 .87043 L
.48773 .87266 L
.48565 .87502 L
.48372 .8775 L
.48193 .88009 L
.4803 .88278 L
.47883 .88556 L
.47883 .88556 L
.47714 .88574 L
.47548 .88606 L
.47385 .88651 L
.47225 .88708 L
.47071 .88779 L
.46923 .88862 L
.46783 .88956 L
.4665 .89061 L
.46526 .89177 L
.46412 .89302 L
.46412 .89302 L
.46305 .89289 L
.46197 .89284 L
.46089 .89289 L
.45983 .89304 L
.45877 .89329 L
.45775 .89362 L
.45676 .89405 L
.45581 .89457 L
.45491 .89516 L
.45407 .89584 L
.45407 .89584 L
.45332 .89562 L
.45255 .89548 L
.45178 .89541 L
.451 .89541 L
.45022 .89548 L
.44946 .89563 L
.44871 .89584 L
.44799 .89613 L
.44729 .89648 L
.44663 .8969 L
.44663 .8969 L
.44606 .89666 L
.44547 .89648 L
.44487 .89636 L
.44425 .8963 L
.44364 .8963 L
.44302 .89636 L
.44242 .89647 L
.44183 .89664 L
.44125 .89687 L
.4407 .89715 L
.4407 .89715 L
.44024 .89691 L
.43975 .89672 L
.43924 .89657 L
.43872 .89648 L
.43819 .89643 L
.43767 .89644 L
.43714 .89649 L
.43663 .8966 L
.43612 .89676 L
.43564 .89697 L
.43564 .89697 L
.43523 .89671 L
.43479 .89651 L
.43434 .89634 L
.43387 .89622 L
.4334 .89614 L
.43292 .89611 L
.43244 .89613 L
.43196 .8962 L
.43149 .89631 L
.43103 .89647 L
.43103 .89647 L
.43065 .8962 L
.43025 .89597 L
.42982 .89577 L
.42938 .89563 L
.42892 .89552 L
.42846 .89546 L
.42799 .89545 L
.42752 .89549 L
.42706 .89556 L
.42661 .89569 L
.42661 .89569 L
.42623 .89538 L
.42583 .89512 L
.42541 .89489 L
.42496 .89471 L
.4245 .89457 L
.42403 .89448 L
.42355 .89444 L
.42306 .89444 L
.42258 .89449 L
.42211 .89458 L
.42211 .89458 L
.42173 .89422 L
.42131 .8939 L
.42086 .89362 L
.42039 .89339 L
.41989 .8932 L
.41938 .89307 L
.41886 .89298 L
.41834 .89294 L
.41781 .89296 L
.41729 .89302 L
.41729 .89302 L
.41687 .89257 L
.41641 .89216 L
.41591 .8918 L
.41538 .89148 L
.41482 .89122 L
.41424 .89101 L
.41364 .89086 L
.41303 .89077 L
.41242 .89073 L
.4118 .89075 L
.4118 .89075 L
.41133 .89014 L
.41079 .88957 L
.41021 .88905 L
.40958 .88859 L
.40891 .8882 L
.40821 .88786 L
.40748 .8876 L
.40673 .8874 L
.40596 .88727 L
.40518 .88722 L
.40518 .88722 L
.40462 .8863 L
.40398 .88543 L
.40326 .88462 L
.40248 .88388 L
.40163 .88321 L
.40072 .88262 L
.39977 .88212 L
.39878 .8817 L
.39775 .88137 L
.39669 .88114 L
.39669 .88114 L
.39605 .87957 L
.39528 .87806 L
.3944 .87661 L
.3934 .87525 L
.39229 .87396 L
.39108 .87277 L
.38979 .87168 L
.38841 .8707 L
.38695 .86984 L
.38543 .86909 L
.38543 .86909 L
.385 .86597 L
.38439 .86289 L
.38359 .85985 L
.38262 .85686 L
.38147 .85393 L
.38015 .85107 L
.37867 .8483 L
.37703 .84562 L
.37523 .84304 L
.37328 .84057 L
.37328 .84057 L
.39669 .77624 L
F
0 g
newpath
.42332 .92726 .15335 260 300 arc
s
.5 .79445 m
.5 .86292 L
s
newpath
.52663 .90904 .05326 206.165 240 arc
s
newpath
.48023 .90655 .02103 220 266.165 arc
s
newpath
.46203 .90491 .01207 228.747 280 arc
s
newpath
.4514 .9037 .00831 235.031 288.747 arc
s
newpath
.44392 .90272 .00642 240 295.031 arc
s
newpath
.43799 .90185 .00542 244.244 300 arc
s
newpath
.43287 .90103 .00492 248.119 304.244 arc
s
newpath
.42809 .90022 .00477 251.881 308.119 arc
s
newpath
.42332 .89935 .00492 255.756 311.881 arc
s
newpath
.41823 .89836 .00542 260 315.756 arc
s
newpath
.41237 .89715 .00642 264.969 320 arc
s
newpath
.405 .89552 .00831 271.253 324.969 arc
s
newpath
.3946 .89302 .01207 280 331.253 arc
s
newpath
.37693 .88833 .02103 293.835 340 arc
s
newpath
.33248 .87481 .05326 320 353.835 arc
s
.37328 .84057 m
.39669 .77624 L
s
.85 g
.5 .79445 m
.50858 .78986 L
.51743 .78581 L
.52652 .78234 L
.53581 .77945 L
.54527 .77716 L
.55485 .77547 L
.56452 .77439 L
.57424 .77393 L
.58397 .77408 L
.59367 .77485 L
.60331 .77624 L
.60331 .77624 L
.60979 .76898 L
.61673 .76216 L
.62408 .75578 L
.63183 .74989 L
.63993 .7445 L
.64836 .73964 L
.65708 .73531 L
.66605 .73155 L
.67525 .72837 L
.68463 .72578 L
.69415 .72379 L
.69415 .72379 L
.69777 .71475 L
.70195 .70596 L
.70668 .69746 L
.71194 .68927 L
.71771 .68144 L
.72397 .67398 L
.73068 .66694 L
.73783 .66034 L
.74539 .6542 L
.75331 .64856 L
.76158 .64343 L
.76158 .64343 L
.76189 .6337 L
.76281 .62401 L
.76435 .61441 L
.7665 .60491 L
.76924 .59558 L
.77257 .58643 L
.77647 .57752 L
.78093 .56887 L
.78592 .56052 L
.79144 .5525 L
.79746 .54485 L
.79746 .54485 L
.79442 .53561 L
.79198 .52619 L
.79014 .51663 L
.7889 .50698 L
.78829 .49727 L
.78829 .48754 L
.7889 .47783 L
.79014 .46817 L
.79198 .45862 L
.79442 .4492 L
.79746 .43995 L
.79746 .43995 L
.79144 .4323 L
.78592 .42429 L
.78093 .41594 L
.77647 .40729 L
.77257 .39838 L
.76924 .38923 L
.7665 .37989 L
.76435 .3704 L
.76281 .36079 L
.76189 .35111 L
.76158 .34138 L
.76158 .34138 L
.75331 .33625 L
.74539 .33061 L
.73783 .32447 L
.73068 .31787 L
.72397 .31082 L
.71771 .30337 L
.71194 .29553 L
.70668 .28735 L
.70195 .27884 L
.69777 .27006 L
.69415 .26102 L
.69415 .26102 L
.68463 .25903 L
.67525 .25644 L
.66605 .25325 L
.65708 .24949 L
.64836 .24517 L
.63993 .24031 L
.63183 .23492 L
.62408 .22902 L
.61673 .22265 L
.60979 .21582 L
.60331 .20857 L
.60331 .20857 L
.59367 .20996 L
.58397 .21073 L
.57424 .21088 L
.56452 .21042 L
.55485 .20934 L
.54527 .20765 L
.53581 .20536 L
.52652 .20247 L
.51743 .19899 L
.50858 .19495 L
.5 .19036 L
.5 .19036 L
.49142 .19495 L
.48257 .19899 L
.47348 .20247 L
.46419 .20536 L
.45473 .20765 L
.44515 .20934 L
.43548 .21042 L
.42576 .21088 L
.41603 .21073 L
.40633 .20996 L
.39669 .20857 L
.39669 .20857 L
.39021 .21582 L
.38327 .22265 L
.37592 .22902 L
.36817 .23492 L
.36007 .24031 L
.35164 .24517 L
.34292 .24949 L
.33395 .25325 L
.32475 .25644 L
.31537 .25903 L
.30585 .26102 L
.30585 .26102 L
.30223 .27006 L
.29805 .27884 L
.29332 .28735 L
.28806 .29553 L
.28229 .30337 L
.27603 .31082 L
.26932 .31787 L
.26217 .32447 L
.25461 .33061 L
.24669 .33625 L
.23842 .34138 L
.23842 .34138 L
.23811 .35111 L
.23719 .36079 L
.23565 .3704 L
.2335 .37989 L
.23076 .38923 L
.22743 .39838 L
.22353 .40729 L
.21907 .41594 L
.21408 .42429 L
.20856 .4323 L
.20254 .43995 L
.20254 .43995 L
.20558 .4492 L
.20802 .45862 L
.20986 .46817 L
.2111 .47783 L
.21171 .48754 L
.21171 .49727 L
.2111 .50698 L
.20986 .51663 L
.20802 .52619 L
.20558 .53561 L
.20254 .54485 L
.20254 .54485 L
.20856 .5525 L
.21408 .56052 L
.21907 .56887 L
.22353 .57752 L
.22743 .58643 L
.23076 .59558 L
.2335 .60491 L
.23565 .61441 L
.23719 .62401 L
.23811 .6337 L
.23842 .64343 L
.23842 .64343 L
.24669 .64856 L
.25461 .6542 L
.26217 .66034 L
.26932 .66694 L
.27603 .67398 L
.28229 .68144 L
.28806 .68927 L
.29332 .69746 L
.29805 .70596 L
.30223 .71475 L
.30585 .72379 L
.30585 .72379 L
.31537 .72578 L
.32475 .72837 L
.33395 .73155 L
.34292 .73531 L
.35164 .73964 L
.36007 .7445 L
.36817 .74989 L
.37592 .75578 L
.38327 .76216 L
.39021 .76898 L
.39669 .77624 L
.39669 .77624 L
.40633 .77485 L
.41603 .77408 L
.42576 .77393 L
.43548 .77439 L
.44515 .77547 L
.45473 .77716 L
.46419 .77945 L
.47348 .78234 L
.48257 .78581 L
.49142 .78986 L
.5 .79445 L
F
0 g
newpath
.57668 .92726 .15335 240 280 arc
s
newpath
.72078 .87481 .15335 220 260 arc
s
newpath
.83826 .77624 .15335 200 240 arc
s
newpath
.91493 .64343 .15335 180 220 arc
s
newpath
.94156 .4924 .15335 160 200 arc
s
newpath
.91493 .34138 .15335 140 180 arc
s
newpath
.83826 .20857 .15335 120 160 arc
s
newpath
.72078 .11 .15335 100 140 arc
s
newpath
.57668 .05755 .15335 80 120 arc
s
newpath
.42332 .05755 .15335 60 100 arc
s
newpath
.27922 .11 .15335 40 80 arc
s
newpath
.16174 .20857 .15335 20 60 arc
s
newpath
.08507 .34138 .15335 0 40 arc
s
newpath
.05844 .4924 .15335 -20 20 arc
s
newpath
.08507 .64343 .15335 -40 0 arc
s
newpath
.16174 .77624 .15335 300 340 arc
s
newpath
.27922 .87481 .15335 280 320 arc
s
newpath
.42332 .92726 .15335 260 300 arc
s
.85 g
.60331 .20857 m
.59367 .20996 L
.58397 .21073 L
.57424 .21088 L
.56452 .21042 L
.55485 .20934 L
.54527 .20765 L
.53581 .20536 L
.52652 .20247 L
.51743 .19899 L
.50858 .19495 L
.5 .19036 L
.5 .19036 L
.5 .12189 L
.5 .12189 L
.50268 .12024 L
.50525 .11843 L
.50771 .11647 L
.51005 .11438 L
.51227 .11214 L
.51435 .10978 L
.51628 .10731 L
.51807 .10472 L
.5197 .10203 L
.52117 .09925 L
.52117 .09925 L
.52286 .09907 L
.52452 .09875 L
.52615 .0983 L
.52775 .09772 L
.52929 .09702 L
.53077 .09619 L
.53217 .09525 L
.5335 .09419 L
.53474 .09304 L
.53588 .09178 L
.53588 .09178 L
.53695 .09192 L
.53803 .09197 L
.53911 .09191 L
.54017 .09176 L
.54123 .09152 L
.54225 .09118 L
.54324 .09076 L
.54419 .09024 L
.54509 .08964 L
.54593 .08897 L
.54593 .08897 L
.54668 .08919 L
.54745 .08933 L
.54822 .0894 L
.549 .0894 L
.54978 .08933 L
.55054 .08918 L
.55129 .08896 L
.55201 .08868 L
.55271 .08833 L
.55337 .08791 L
.55337 .08791 L
.55394 .08814 L
.55453 .08832 L
.55513 .08844 L
.55575 .08851 L
.55636 .08851 L
.55698 .08845 L
.55758 .08834 L
.55817 .08816 L
.55875 .08794 L
.5593 .08765 L
.5593 .08765 L
.55976 .08789 L
.56025 .08809 L
.56076 .08824 L
.56128 .08833 L
.56181 .08838 L
.56233 .08837 L
.56286 .08831 L
.56337 .0882 L
.56388 .08805 L
.56436 .08784 L
.56436 .08784 L
.56477 .08809 L
.56521 .0883 L
.56566 .08847 L
.56613 .08859 L
.5666 .08867 L
.56708 .08869 L
.56756 .08868 L
.56804 .08861 L
.56851 .0885 L
.56897 .08834 L
.56897 .08834 L
.56935 .08861 L
.56975 .08884 L
.57018 .08903 L
.57062 .08918 L
.57108 .08928 L
.57154 .08934 L
.57201 .08936 L
.57248 .08932 L
.57294 .08924 L
.57339 .08912 L
.57339 .08912 L
.57377 .08942 L
.57417 .08969 L
.57459 .08991 L
.57504 .0901 L
.5755 .09024 L
.57597 .09033 L
.57645 .09037 L
.57694 .09037 L
.57742 .09032 L
.57789 .09023 L
.57789 .09023 L
.57827 .09059 L
.57869 .09091 L
.57914 .09118 L
.57961 .09142 L
.58011 .0916 L
.58062 .09174 L
.58114 .09183 L
.58166 .09186 L
.58219 .09185 L
.58271 .09178 L
.58271 .09178 L
.58313 .09224 L
.58359 .09265 L
.58409 .09301 L
.58462 .09333 L
.58518 .09359 L
.58576 .0938 L
.58636 .09395 L
.58697 .09404 L
.58758 .09408 L
.5882 .09405 L
.5882 .09405 L
.58867 .09467 L
.58921 .09524 L
.58979 .09575 L
.59042 .09621 L
.59109 .09661 L
.59179 .09695 L
.59252 .09721 L
.59327 .09741 L
.59404 .09754 L
.59482 .09759 L
.59482 .09759 L
.59538 .09851 L
.59602 .09938 L
.59674 .10019 L
.59752 .10093 L
.59837 .1016 L
.59928 .10219 L
.60023 .10269 L
.60122 .10311 L
.60225 .10344 L
.60331 .10367 L
.60331 .10367 L
.60395 .10524 L
.60472 .10675 L
.6056 .10819 L
.6066 .10956 L
.60771 .11085 L
.60892 .11204 L
.61021 .11312 L
.61159 .11411 L
.61305 .11497 L
.61457 .11572 L
.61457 .11572 L
.615 .11883 L
.61561 .12192 L
.61641 .12496 L
.61738 .12795 L
.61853 .13088 L
.61985 .13373 L
.62133 .13651 L
.62297 .13919 L
.62477 .14177 L
.62672 .14423 L
.62672 .14423 L
.60331 .20857 L
F
0 g
newpath
.57668 .05755 .15335 80 120 arc
s
.5 .19036 m
.5 .12189 L
s
newpath
.47337 .07576 .05326 26.165 60 arc
s
newpath
.51977 .07826 .02103 40 86.165 arc
s
newpath
.53797 .07989 .01207 48.7474 100 arc
s
newpath
.5486 .0811 .00831 55.0315 108.747 arc
s
newpath
.55608 .08209 .00642 60 115.031 arc
s
newpath
.56201 .08296 .00542 64.244 120 arc
s
newpath
.56713 .08377 .00492 68.1192 124.244 arc
s
newpath
.57191 .08459 .00477 71.8808 128.119 arc
s
newpath
.57668 .08546 .00492 75.756 131.881 arc
s
newpath
.58177 .08644 .00542 80 135.756 arc
s
newpath
.58763 .08765 .00642 84.9685 140 arc
s
newpath
.595 .08928 .00831 91.2526 144.969 arc
s
newpath
.6054 .09178 .01207 100 151.253 arc
s
newpath
.62307 .09648 .02103 113.835 160 arc
s
newpath
.66752 .11 .05326 140 173.835 arc
s
.62672 .14423 m
.60331 .20857 L
s
.85 g
.5 .79445 m
.50858 .78986 L
.51743 .78581 L
.52652 .78234 L
.53581 .77945 L
.54527 .77716 L
.55485 .77547 L
.56452 .77439 L
.57424 .77393 L
.58397 .77408 L
.59367 .77485 L
.60331 .77624 L
.60331 .77624 L
.62672 .84057 L
.62672 .84057 L
.62477 .84304 L
.62297 .84562 L
.62133 .8483 L
.61985 .85107 L
.61853 .85393 L
.61738 .85686 L
.61641 .85985 L
.61561 .86289 L
.615 .86597 L
.61457 .86909 L
.61457 .86909 L
.61305 .86984 L
.61159 .8707 L
.61021 .87168 L
.60892 .87277 L
.60771 .87396 L
.6066 .87525 L
.6056 .87661 L
.60472 .87806 L
.60395 .87957 L
.60331 .88114 L
.60331 .88114 L
.60225 .88137 L
.60122 .8817 L
.60023 .88212 L
.59928 .88262 L
.59837 .88321 L
.59752 .88388 L
.59674 .88462 L
.59602 .88543 L
.59538 .8863 L
.59482 .88722 L
.59482 .88722 L
.59404 .88727 L
.59327 .8874 L
.59252 .8876 L
.59179 .88786 L
.59109 .8882 L
.59042 .88859 L
.58979 .88905 L
.58921 .88957 L
.58867 .89014 L
.5882 .89075 L
.5882 .89075 L
.58758 .89073 L
.58697 .89077 L
.58636 .89086 L
.58576 .89101 L
.58518 .89122 L
.58462 .89148 L
.58409 .8918 L
.58359 .89216 L
.58313 .89257 L
.58271 .89302 L
.58271 .89302 L
.58219 .89296 L
.58166 .89294 L
.58114 .89298 L
.58062 .89307 L
.58011 .8932 L
.57961 .89339 L
.57914 .89362 L
.57869 .8939 L
.57827 .89422 L
.57789 .89458 L
.57789 .89458 L
.57742 .89449 L
.57694 .89444 L
.57645 .89444 L
.57597 .89448 L
.5755 .89457 L
.57504 .89471 L
.57459 .89489 L
.57417 .89512 L
.57377 .89538 L
.57339 .89569 L
.57339 .89569 L
.57294 .89556 L
.57248 .89549 L
.57201 .89545 L
.57154 .89546 L
.57108 .89552 L
.57062 .89563 L
.57018 .89577 L
.56975 .89597 L
.56935 .8962 L
.56897 .89647 L
.56897 .89647 L
.56851 .89631 L
.56804 .8962 L
.56756 .89613 L
.56708 .89611 L
.5666 .89614 L
.56613 .89622 L
.56566 .89634 L
.56521 .89651 L
.56477 .89671 L
.56436 .89697 L
.56436 .89697 L
.56388 .89676 L
.56337 .8966 L
.56286 .89649 L
.56233 .89644 L
.56181 .89643 L
.56128 .89648 L
.56076 .89657 L
.56025 .89672 L
.55976 .89691 L
.5593 .89715 L
.5593 .89715 L
.55875 .89687 L
.55817 .89664 L
.55758 .89647 L
.55698 .89636 L
.55636 .8963 L
.55575 .8963 L
.55513 .89636 L
.55453 .89648 L
.55394 .89666 L
.55337 .8969 L
.55337 .8969 L
.55271 .89648 L
.55201 .89613 L
.55129 .89584 L
.55054 .89563 L
.54978 .89548 L
.549 .89541 L
.54822 .89541 L
.54745 .89548 L
.54668 .89562 L
.54593 .89584 L
.54593 .89584 L
.54509 .89516 L
.54419 .89457 L
.54324 .89405 L
.54225 .89362 L
.54123 .89329 L
.54017 .89304 L
.53911 .89289 L
.53803 .89284 L
.53695 .89289 L
.53588 .89302 L
.53588 .89302 L
.53474 .89177 L
.5335 .89061 L
.53217 .88956 L
.53077 .88862 L
.52929 .88779 L
.52775 .88708 L
.52615 .88651 L
.52452 .88606 L
.52286 .88574 L
.52117 .88556 L
.52117 .88556 L
.5197 .88278 L
.51807 .88009 L
.51628 .8775 L
.51435 .87502 L
.51227 .87266 L
.51005 .87043 L
.50771 .86833 L
.50525 .86638 L
.50268 .86457 L
.5 .86292 L
.5 .86292 L
.5 .79445 L
F
0 g
newpath
.57668 .92726 .15335 240 280 arc
s
.60331 .77624 m
.62672 .84057 L
s
newpath
.66752 .87481 .05326 186.165 220 arc
s
newpath
.62307 .88833 .02103 200 246.165 arc
s
newpath
.6054 .89302 .01207 208.747 260 arc
s
newpath
.595 .89552 .00831 215.031 268.747 arc
s
newpath
.58763 .89715 .00642 220 275.031 arc
s
newpath
.58177 .89836 .00542 224.244 280 arc
s
newpath
.57668 .89935 .00492 228.119 284.244 arc
s
newpath
.57191 .90022 .00477 231.881 288.119 arc
s
newpath
.56713 .90103 .00492 235.756 291.881 arc
s
newpath
.56201 .90185 .00542 240 295.756 arc
s
newpath
.55608 .90272 .00642 244.969 300 arc
s
newpath
.5486 .9037 .00831 251.253 304.969 arc
s
newpath
.53797 .90491 .01207 260 311.253 arc
s
newpath
.51977 .90655 .02103 273.835 320 arc
s
newpath
.47337 .90904 .05326 300 333.835 arc
s
.5 .86292 m
.5 .79445 L
s
.85 g
.69415 .26102 m
.68463 .25903 L
.67525 .25644 L
.66605 .25325 L
.65708 .24949 L
.64836 .24517 L
.63993 .24031 L
.63183 .23492 L
.62408 .22902 L
.61673 .22265 L
.60979 .21582 L
.60331 .20857 L
.60331 .20857 L
.62672 .14423 L
.62672 .14423 L
.6298 .1436 L
.63284 .14278 L
.63582 .14178 L
.63874 .14061 L
.64159 .13927 L
.64435 .13777 L
.64701 .1361 L
.64958 .13428 L
.65203 .13231 L
.65436 .1302 L
.65436 .1302 L
.65601 .13061 L
.65768 .13088 L
.65937 .13102 L
.66106 .13102 L
.66275 .13088 L
.66442 .13061 L
.66607 .1302 L
.66768 .12967 L
.66923 .129 L
.67073 .12821 L
.67073 .12821 L
.67169 .12871 L
.67269 .12912 L
.67372 .12944 L
.67478 .12967 L
.67585 .1298 L
.67693 .12983 L
.67801 .12977 L
.67908 .12961 L
.68012 .12936 L
.68115 .12901 L
.68115 .12901 L
.68178 .12947 L
.68245 .12987 L
.68315 .1302 L
.68388 .13046 L
.68463 .13066 L
.6854 .13079 L
.68618 .13084 L
.68696 .13082 L
.68773 .13072 L
.68849 .13056 L
.68849 .13056 L
.68895 .13097 L
.68944 .13134 L
.68997 .13166 L
.69052 .13193 L
.6911 .13214 L
.6917 .1323 L
.69231 .1324 L
.69292 .13244 L
.69354 .13242 L
.69415 .13234 L
.69415 .13234 L
.69451 .13273 L
.6949 .13308 L
.69533 .13339 L
.69579 .13366 L
.69626 .13388 L
.69676 .13406 L
.69727 .13418 L
.6978 .13426 L
.69832 .13428 L
.69885 .13425 L
.69885 .13425 L
.69915 .13463 L
.69949 .13498 L
.69985 .13529 L
.70025 .13556 L
.70067 .13579 L
.70111 .13598 L
.70157 .13613 L
.70204 .13623 L
.70252 .13629 L
.703 .1363 L
.703 .1363 L
.70327 .13668 L
.70357 .13704 L
.70391 .13736 L
.70428 .13765 L
.70467 .13791 L
.70509 .13812 L
.70552 .13829 L
.70597 .13842 L
.70643 .1385 L
.7069 .13854 L
.7069 .13854 L
.70714 .13896 L
.70743 .13934 L
.70775 .1397 L
.70811 .14002 L
.7085 .14031 L
.70891 .14056 L
.70935 .14077 L
.7098 .14093 L
.71027 .14105 L
.71074 .14112 L
.71074 .14112 L
.71098 .14159 L
.71127 .14203 L
.71159 .14245 L
.71196 .14283 L
.71236 .14317 L
.71279 .14348 L
.71325 .14374 L
.71373 .14395 L
.71423 .14412 L
.71475 .14423 L
.71475 .14423 L
.71498 .1448 L
.71528 .14534 L
.71562 .14586 L
.71601 .14634 L
.71644 .14677 L
.71692 .14717 L
.71743 .14751 L
.71797 .14781 L
.71854 .14805 L
.71912 .14824 L
.71912 .14824 L
.71936 .14898 L
.71966 .1497 L
.72004 .15038 L
.72047 .15103 L
.72096 .15163 L
.72151 .15219 L
.7221 .15269 L
.72274 .15313 L
.72342 .15351 L
.72413 .15383 L
.72413 .15383 L
.72435 .15489 L
.72465 .15592 L
.72505 .15693 L
.72553 .15789 L
.7261 .15881 L
.72675 .15967 L
.72747 .16047 L
.72827 .16121 L
.72912 .16187 L
.73003 .16245 L
.73003 .16245 L
.7301 .16414 L
.7303 .16582 L
.73064 .16748 L
.73111 .16911 L
.73171 .17069 L
.73244 .17223 L
.73329 .17369 L
.73425 .17509 L
.73532 .1764 L
.7365 .17762 L
.7365 .17762 L
.73583 .1807 L
.73536 .1838 L
.73506 .18693 L
.73495 .19008 L
.73503 .19322 L
.73529 .19635 L
.73574 .19947 L
.73637 .20255 L
.73718 .20559 L
.73816 .20857 L
.73816 .20857 L
.69415 .26102 L
F
0 g
newpath
.72078 .11 .15335 100 140 arc
s
.60331 .20857 m
.62672 .14423 L
s
newpath
.61748 .09178 .05326 46.165 80 arc
s
newpath
.66022 .11 .02103 60 106.165 arc
s
newpath
.67677 .11776 .01207 68.7474 120 arc
s
newpath
.68635 .12253 .00831 75.0315 128.747 arc
s
newpath
.69304 .12602 .00642 80 135.031 arc
s
newpath
.69831 .12886 .00542 84.244 140 arc
s
newpath
.70284 .13138 .00492 88.1192 144.244 arc
s
newpath
.70705 .13378 .00477 91.8808 148.119 arc
s
newpath
.71124 .13622 .00492 95.756 151.881 arc
s
newpath
.71569 .13889 .00542 100 155.756 arc
s
newpath
.72078 .14204 .00642 104.969 160 arc
s
newpath
.72715 .14609 .00831 111.253 164.969 arc
s
newpath
.73607 .15199 .01207 120 171.253 arc
s
newpath
.75106 .16245 .02103 133.835 180 arc
s
newpath
.78821 .19036 .05326 160 193.835 arc
s
.73816 .20857 m
.69415 .26102 L
s
.85 g
.60331 .77624 m
.60979 .76898 L
.61673 .76216 L
.62408 .75578 L
.63183 .74989 L
.63993 .7445 L
.64836 .73964 L
.65708 .73531 L
.66605 .73155 L
.67525 .72837 L
.68463 .72578 L
.69415 .72379 L
.69415 .72379 L
.73816 .77624 L
.73816 .77624 L
.73718 .77922 L
.73637 .78226 L
.73574 .78534 L
.73529 .78845 L
.73503 .79159 L
.73495 .79473 L
.73506 .79787 L
.73536 .801 L
.73583 .80411 L
.7365 .80719 L
.7365 .80719 L
.73532 .80841 L
.73425 .80972 L
.73329 .81112 L
.73244 .81258 L
.73171 .81411 L
.73111 .8157 L
.73064 .81732 L
.7303 .81898 L
.7301 .82067 L
.73003 .82236 L
.73003 .82236 L
.72912 .82294 L
.72827 .8236 L
.72747 .82433 L
.72675 .82514 L
.7261 .826 L
.72553 .82692 L
.72505 .82788 L
.72465 .82888 L
.72435 .82992 L
.72413 .83098 L
.72413 .83098 L
.72342 .83129 L
.72274 .83168 L
.7221 .83212 L
.72151 .83262 L
.72096 .83317 L
.72047 .83378 L
.72004 .83442 L
.71966 .83511 L
.71936 .83582 L
.71912 .83657 L
.71912 .83657 L
.71854 .83675 L
.71797 .837 L
.71743 .83729 L
.71692 .83764 L
.71644 .83803 L
.71601 .83847 L
.71562 .83895 L
.71528 .83946 L
.71498 .84001 L
.71475 .84057 L
.71475 .84057 L
.71423 .84069 L
.71373 .84086 L
.71325 .84107 L
.71279 .84133 L
.71236 .84163 L
.71196 .84198 L
.71159 .84236 L
.71127 .84277 L
.71098 .84322 L
.71074 .84369 L
.71074 .84369 L
.71027 .84376 L
.7098 .84388 L
.70935 .84404 L
.70891 .84425 L
.7085 .8445 L
.70811 .84478 L
.70775 .84511 L
.70743 .84546 L
.70714 .84585 L
.7069 .84626 L
.7069 .84626 L
.70643 .8463 L
.70597 .84639 L
.70552 .84652 L
.70509 .84669 L
.70467 .8469 L
.70428 .84715 L
.70391 .84745 L
.70357 .84777 L
.70327 .84813 L
.703 .84851 L
.703 .84851 L
.70252 .84852 L
.70204 .84857 L
.70157 .84868 L
.70111 .84882 L
.70067 .84901 L
.70025 .84925 L
.69985 .84952 L
.69949 .84983 L
.69915 .85018 L
.69885 .85055 L
.69885 .85055 L
.69832 .85053 L
.6978 .85055 L
.69727 .85063 L
.69676 .85075 L
.69626 .85093 L
.69579 .85115 L
.69533 .85142 L
.6949 .85173 L
.69451 .85208 L
.69415 .85246 L
.69415 .85246 L
.69354 .85239 L
.69292 .85237 L
.69231 .85241 L
.6917 .85251 L
.6911 .85266 L
.69052 .85288 L
.68997 .85315 L
.68944 .85347 L
.68895 .85384 L
.68849 .85425 L
.68849 .85425 L
.68773 .85409 L
.68696 .85399 L
.68618 .85397 L
.6854 .85402 L
.68463 .85415 L
.68388 .85434 L
.68315 .85461 L
.68245 .85494 L
.68178 .85534 L
.68115 .8558 L
.68115 .8558 L
.68012 .85545 L
.67908 .8552 L
.67801 .85504 L
.67693 .85498 L
.67585 .85501 L
.67478 .85514 L
.67372 .85537 L
.67269 .85569 L
.67169 .8561 L
.67073 .85659 L
.67073 .85659 L
.66923 .85581 L
.66768 .85514 L
.66607 .85461 L
.66442 .8542 L
.66275 .85393 L
.66106 .85379 L
.65937 .85379 L
.65768 .85393 L
.65601 .8542 L
.65436 .85461 L
.65436 .85461 L
.65203 .8525 L
.64958 .85053 L
.64701 .84871 L
.64435 .84704 L
.64159 .84554 L
.63874 .8442 L
.63582 .84303 L
.63284 .84203 L
.6298 .84121 L
.62672 .84057 L
.62672 .84057 L
.60331 .77624 L
F
0 g
newpath
.72078 .87481 .15335 220 260 arc
s
.69415 .72379 m
.73816 .77624 L
s
newpath
.78821 .79445 .05326 166.165 200 arc
s
newpath
.75106 .82236 .02103 180 226.165 arc
s
newpath
.73607 .83281 .01207 188.747 240 arc
s
newpath
.72715 .83872 .00831 195.031 248.747 arc
s
newpath
.72078 .84277 .00642 200 255.031 arc
s
newpath
.71569 .84591 .00542 204.244 260 arc
s
newpath
.71124 .84858 .00492 208.119 264.244 arc
s
newpath
.70705 .85103 .00477 211.881 268.119 arc
s
newpath
.70284 .85343 .00492 215.756 271.881 arc
s
newpath
.69831 .85595 .00542 220 275.756 arc
s
newpath
.69304 .85879 .00642 224.969 280 arc
s
newpath
.68635 .86228 .00831 231.253 284.969 arc
s
newpath
.67677 .86705 .01207 240 291.253 arc
s
newpath
.66022 .87481 .02103 253.835 300 arc
s
newpath
.61748 .89302 .05326 280 313.835 arc
s
.62672 .84057 m
.60331 .77624 L
s
.85 g
.76158 .34138 m
.75331 .33625 L
.74539 .33061 L
.73783 .32447 L
.73068 .31787 L
.72397 .31082 L
.71771 .30337 L
.71194 .29553 L
.70668 .28735 L
.70195 .27884 L
.69777 .27006 L
.69415 .26102 L
.69415 .26102 L
.73816 .20857 L
.73816 .20857 L
.74127 .20903 L
.74441 .2093 L
.74755 .20938 L
.75069 .20928 L
.75383 .20899 L
.75694 .20852 L
.76001 .20787 L
.76304 .20704 L
.76602 .20602 L
.76893 .20484 L
.76893 .20484 L
.77034 .20578 L
.77182 .20661 L
.77336 .20732 L
.77495 .2079 L
.77658 .20835 L
.77825 .20866 L
.77993 .20884 L
.78163 .20889 L
.78332 .2088 L
.785 .20857 L
.785 .20857 L
.78573 .20937 L
.78653 .21009 L
.78739 .21075 L
.7883 .21132 L
.78926 .21181 L
.79027 .21221 L
.7913 .21252 L
.79236 .21274 L
.79343 .21286 L
.79451 .21288 L
.79451 .21288 L
.79495 .21353 L
.79544 .21413 L
.79599 .21468 L
.79658 .21518 L
.79722 .21563 L
.7979 .21601 L
.79862 .21632 L
.79935 .21657 L
.80011 .21674 L
.80088 .21685 L
.80088 .21685 L
.80117 .21739 L
.80151 .21791 L
.80189 .21839 L
.80232 .21883 L
.80279 .21923 L
.8033 .21958 L
.80384 .21988 L
.8044 .22013 L
.80499 .22033 L
.80559 .22046 L
.80559 .22046 L
.8058 .22095 L
.80605 .22141 L
.80634 .22185 L
.80668 .22226 L
.80705 .22263 L
.80746 .22296 L
.8079 .22326 L
.80836 .22351 L
.80885 .22371 L
.80935 .22386 L
.80935 .22386 L
.80951 .22432 L
.8097 .22476 L
.80994 .22518 L
.81022 .22557 L
.81054 .22593 L
.81089 .22626 L
.81127 .22656 L
.81168 .22682 L
.81211 .22703 L
.81256 .2272 L
.81256 .2272 L
.81268 .22766 L
.81284 .22809 L
.81304 .22852 L
.81329 .22891 L
.81357 .22929 L
.81389 .22963 L
.81424 .22994 L
.81462 .23021 L
.81502 .23045 L
.81545 .23065 L
.81545 .23065 L
.81554 .23112 L
.81568 .23158 L
.81586 .23203 L
.81608 .23245 L
.81635 .23286 L
.81665 .23323 L
.81699 .23357 L
.81736 .23388 L
.81776 .23415 L
.81818 .23438 L
.81818 .23438 L
.81824 .23491 L
.81836 .23542 L
.81852 .23592 L
.81874 .23641 L
.819 .23686 L
.8193 .2373 L
.81964 .2377 L
.82002 .23806 L
.82043 .23839 L
.82088 .23868 L
.82088 .23868 L
.82091 .23929 L
.82099 .2399 L
.82114 .2405 L
.82134 .24109 L
.8216 .24165 L
.82191 .24218 L
.82227 .24268 L
.82268 .24314 L
.82313 .24356 L
.82362 .24394 L
.82362 .24394 L
.82359 .24472 L
.82363 .2455 L
.82374 .24627 L
.82393 .24702 L
.82419 .24776 L
.82451 .24847 L
.8249 .24914 L
.82535 .24978 L
.82586 .25037 L
.82642 .25091 L
.82642 .25091 L
.82625 .25197 L
.82619 .25305 L
.82622 .25413 L
.82634 .2552 L
.82656 .25626 L
.82688 .25729 L
.82728 .25829 L
.82778 .25925 L
.82835 .26017 L
.82901 .26102 L
.82901 .26102 L
.82849 .26264 L
.82811 .26429 L
.82786 .26596 L
.82775 .26765 L
.82777 .26935 L
.82793 .27103 L
.82822 .2727 L
.82865 .27434 L
.82921 .27594 L
.8299 .27749 L
.8299 .27749 L
.82822 .28015 L
.82671 .28291 L
.82536 .28575 L
.82418 .28867 L
.82318 .29165 L
.82236 .29468 L
.82171 .29776 L
.82125 .30087 L
.82097 .304 L
.82088 .30715 L
.82088 .30715 L
.76158 .34138 L
F
0 g
newpath
.83826 .20857 .15335 120 160 arc
s
.69415 .26102 m
.73816 .20857 L
s
newpath
.74741 .15612 .05326 66.165 100 arc
s
newpath
.78135 .18786 .02103 80 126.165 arc
s
newpath
.79425 .20081 .01207 88.7474 140 arc
s
newpath
.80161 .20857 .00831 95.0315 148.747 arc
s
newpath
.80671 .21414 .00642 100 155.031 arc
s
newpath
.81069 .21861 .00542 104.244 160 arc
s
newpath
.81409 .22253 .00492 108.119 164.244 arc
s
newpath
.81722 .22622 .00477 111.881 168.119 arc
s
newpath
.82032 .22995 .00492 115.756 171.881 arc
s
newpath
.82359 .23398 .00542 120 175.756 arc
s
newpath
.8273 .23868 .00642 124.969 180 arc
s
newpath
.83189 .24466 .00831 131.253 184.969 arc
s
newpath
.83826 .25326 .01207 140 191.253 arc
s
newpath
.84877 .26822 .02103 153.835 200 arc
s
newpath
.87414 .30715 .05326 180 213.835 arc
s
.82088 .30715 m
.76158 .34138 L
s
.85 g
.69415 .72379 m
.69777 .71475 L
.70195 .70596 L
.70668 .69746 L
.71194 .68927 L
.71771 .68144 L
.72397 .67398 L
.73068 .66694 L
.73783 .66034 L
.74539 .6542 L
.75331 .64856 L
.76158 .64343 L
.76158 .64343 L
.82088 .67766 L
.82088 .67766 L
.82097 .68081 L
.82125 .68394 L
.82171 .68705 L
.82236 .69013 L
.82318 .69316 L
.82418 .69614 L
.82536 .69906 L
.82671 .7019 L
.82822 .70465 L
.8299 .70732 L
.8299 .70732 L
.82921 .70887 L
.82865 .71047 L
.82822 .71211 L
.82793 .71377 L
.82777 .71546 L
.82775 .71715 L
.82786 .71885 L
.82811 .72052 L
.82849 .72217 L
.82901 .72379 L
.82901 .72379 L
.82835 .72464 L
.82778 .72556 L
.82728 .72652 L
.82688 .72752 L
.82656 .72855 L
.82634 .72961 L
.82622 .73068 L
.82619 .73176 L
.82625 .73283 L
.82642 .7339 L
.82642 .7339 L
.82586 .73444 L
.82535 .73503 L
.8249 .73567 L
.82451 .73634 L
.82419 .73705 L
.82393 .73779 L
.82374 .73854 L
.82363 .73931 L
.82359 .74009 L
.82362 .74087 L
.82362 .74087 L
.82313 .74124 L
.82268 .74167 L
.82227 .74213 L
.82191 .74263 L
.8216 .74316 L
.82134 .74372 L
.82114 .7443 L
.82099 .7449 L
.82091 .74551 L
.82088 .74613 L
.82088 .74613 L
.82043 .74642 L
.82002 .74674 L
.81964 .74711 L
.8193 .74751 L
.819 .74794 L
.81874 .7484 L
.81852 .74889 L
.81836 .74939 L
.81824 .7499 L
.81818 .75042 L
.81818 .75042 L
.81776 .75066 L
.81736 .75093 L
.81699 .75123 L
.81665 .75158 L
.81635 .75195 L
.81608 .75235 L
.81586 .75278 L
.81568 .75323 L
.81554 .75369 L
.81545 .75416 L
.81545 .75416 L
.81502 .75436 L
.81462 .75459 L
.81424 .75487 L
.81389 .75518 L
.81357 .75552 L
.81329 .75589 L
.81304 .75629 L
.81284 .75671 L
.81268 .75715 L
.81256 .7576 L
.81256 .7576 L
.81211 .75778 L
.81168 .75799 L
.81127 .75825 L
.81089 .75854 L
.81054 .75887 L
.81022 .75924 L
.80994 .75963 L
.8097 .76005 L
.80951 .76049 L
.80935 .76095 L
.80935 .76095 L
.80885 .7611 L
.80836 .7613 L
.8079 .76155 L
.80746 .76184 L
.80705 .76218 L
.80668 .76255 L
.80634 .76296 L
.80605 .7634 L
.8058 .76386 L
.80559 .76435 L
.80559 .76435 L
.80499 .76448 L
.8044 .76468 L
.80384 .76492 L
.8033 .76523 L
.80279 .76558 L
.80232 .76598 L
.80189 .76642 L
.80151 .7669 L
.80117 .76741 L
.80088 .76796 L
.80088 .76796 L
.80011 .76807 L
.79935 .76824 L
.79862 .76849 L
.7979 .7688 L
.79722 .76918 L
.79658 .76962 L
.79599 .77012 L
.79544 .77068 L
.79495 .77128 L
.79451 .77193 L
.79451 .77193 L
.79343 .77195 L
.79236 .77207 L
.7913 .77229 L
.79027 .7726 L
.78926 .773 L
.7883 .77349 L
.78739 .77406 L
.78653 .77471 L
.78573 .77544 L
.785 .77624 L
.785 .77624 L
.78332 .77601 L
.78163 .77592 L
.77993 .77596 L
.77825 .77615 L
.77658 .77646 L
.77495 .77691 L
.77336 .77749 L
.77182 .7782 L
.77034 .77902 L
.76893 .77997 L
.76893 .77997 L
.76602 .77878 L
.76304 .77777 L
.76001 .77694 L
.75694 .77628 L
.75383 .77581 L
.75069 .77553 L
.74755 .77543 L
.74441 .77551 L
.74127 .77578 L
.73816 .77624 L
.73816 .77624 L
.69415 .72379 L
F
0 g
newpath
.83826 .77624 .15335 200 240 arc
s
.76158 .64343 m
.82088 .67766 L
s
newpath
.87414 .67766 .05326 146.165 180 arc
s
newpath
.84877 .71659 .02103 160 206.165 arc
s
newpath
.83826 .73155 .01207 168.747 220 arc
s
newpath
.83189 .74015 .00831 175.031 228.747 arc
s
newpath
.8273 .74613 .00642 180 235.031 arc
s
newpath
.82359 .75083 .00542 184.244 240 arc
s
newpath
.82032 .75486 .00492 188.119 244.244 arc
s
newpath
.81722 .75859 .00477 191.881 248.119 arc
s
newpath
.81409 .76228 .00492 195.756 251.881 arc
s
newpath
.81069 .7662 .00542 200 255.756 arc
s
newpath
.80671 .77067 .00642 204.969 260 arc
s
newpath
.80161 .77624 .00831 211.253 264.969 arc
s
newpath
.79425 .784 .01207 220 271.253 arc
s
newpath
.78135 .79695 .02103 233.835 280 arc
s
newpath
.74741 .82869 .05326 260 293.835 arc
s
.73816 .77624 m
.69415 .72379 L
s
.85 g
.79746 .43995 m
.79144 .4323 L
.78592 .42429 L
.78093 .41594 L
.77647 .40729 L
.77257 .39838 L
.76924 .38923 L
.7665 .37989 L
.76435 .3704 L
.76281 .36079 L
.76189 .35111 L
.76158 .34138 L
.76158 .34138 L
.82088 .30715 L
.82088 .30715 L
.82364 .30864 L
.8265 .30996 L
.82942 .31112 L
.83241 .3121 L
.83545 .3129 L
.83853 .31352 L
.84165 .31396 L
.84478 .31421 L
.84793 .31428 L
.85107 .31416 L
.85107 .31416 L
.85207 .31553 L
.85317 .31681 L
.85438 .318 L
.85568 .31909 L
.85706 .32007 L
.85851 .32094 L
.86003 .32169 L
.86161 .32231 L
.86323 .3228 L
.86489 .32316 L
.86489 .32316 L
.8653 .32416 L
.8658 .32512 L
.86639 .32602 L
.86705 .32688 L
.86779 .32766 L
.86859 .32838 L
.86946 .32903 L
.87038 .32959 L
.87135 .33008 L
.87235 .33047 L
.87235 .33047 L
.87254 .33122 L
.8728 .33196 L
.87312 .33267 L
.87351 .33334 L
.87396 .33397 L
.87447 .33456 L
.87503 .3351 L
.87564 .33559 L
.87629 .33601 L
.87698 .33637 L
.87698 .33637 L
.87707 .33698 L
.87721 .33758 L
.87741 .33817 L
.87766 .33873 L
.87796 .33927 L
.87832 .33977 L
.87872 .34024 L
.87917 .34066 L
.87965 .34105 L
.88017 .34138 L
.88017 .34138 L
.8802 .34191 L
.88027 .34243 L
.8804 .34294 L
.88058 .34344 L
.8808 .34392 L
.88107 .34437 L
.88138 .34479 L
.88173 .34519 L
.88212 .34554 L
.88254 .34586 L
.88254 .34586 L
.88253 .34634 L
.88257 .34682 L
.88265 .3473 L
.88278 .34776 L
.88295 .34821 L
.88316 .34864 L
.88342 .34905 L
.88372 .34943 L
.88405 .34978 L
.88441 .3501 L
.88441 .3501 L
.88437 .35056 L
.88437 .35103 L
.88442 .3515 L
.88451 .35196 L
.88465 .3524 L
.88483 .35283 L
.88506 .35324 L
.88532 .35363 L
.88562 .35399 L
.88595 .35432 L
.88595 .35432 L
.88587 .3548 L
.88584 .35528 L
.88586 .35576 L
.88593 .35624 L
.88604 .35671 L
.8862 .35716 L
.8864 .3576 L
.88664 .35802 L
.88692 .35841 L
.88724 .35877 L
.88724 .35877 L
.88712 .35928 L
.88705 .3598 L
.88704 .36033 L
.88707 .36086 L
.88716 .36138 L
.88729 .36189 L
.88748 .36238 L
.88771 .36286 L
.88799 .36331 L
.8883 .36373 L
.8883 .36373 L
.88812 .36431 L
.888 .36492 L
.88793 .36553 L
.88792 .36615 L
.88797 .36676 L
.88808 .36737 L
.88825 .36796 L
.88847 .36854 L
.88875 .36909 L
.88908 .36961 L
.88908 .36961 L
.88879 .37033 L
.88856 .37107 L
.8884 .37184 L
.88832 .37261 L
.88831 .37339 L
.88837 .37417 L
.88851 .37493 L
.88871 .37568 L
.88899 .37641 L
.88933 .37711 L
.88933 .37711 L
.88881 .37806 L
.88838 .37905 L
.88804 .38007 L
.88779 .38112 L
.88763 .38219 L
.88758 .38327 L
.88762 .38435 L
.88775 .38542 L
.88798 .38647 L
.8883 .3875 L
.8883 .3875 L
.88727 .38884 L
.88634 .39026 L
.88554 .39175 L
.88485 .3933 L
.88429 .3949 L
.88387 .39654 L
.88357 .39821 L
.88341 .3999 L
.88339 .40159 L
.88351 .40328 L
.88351 .40328 L
.88102 .40521 L
.87866 .40729 L
.87642 .40949 L
.87432 .41183 L
.87235 .41429 L
.87054 .41686 L
.86888 .41953 L
.86738 .42229 L
.86605 .42514 L
.86489 .42806 L
.86489 .42806 L
.79746 .43995 L
F
0 g
newpath
.91493 .34138 .15335 140 180 arc
s
.76158 .34138 m
.82088 .30715 L
s
newpath
.84751 .26102 .05326 86.165 120 arc
s
newpath
.86854 .30245 .02103 100 146.165 arc
s
newpath
.87623 .31904 .01207 108.747 160 arc
s
newpath
.8805 .32885 .00831 115.031 168.747 arc
s
newpath
.88338 .33582 .00642 120 175.031 arc
s
newpath
.88559 .34138 .00542 124.244 180 arc
s
newpath
.88745 .34623 .00492 128.119 184.244 arc
s
newpath
.88913 .35077 .00477 131.881 188.119 arc
s
newpath
.89076 .35533 .00492 135.756 191.881 arc
s
newpath
.89246 .36024 .00542 140 195.756 arc
s
newpath
.89434 .36592 .00642 144.969 200 arc
s
newpath
.89661 .37312 .00831 151.253 204.969 arc
s
newpath
.89965 .38337 .01207 160 211.253 arc
s
newpath
.90442 .40102 .02103 173.835 220 arc
s
newpath
.91493 .44628 .05326 200 233.835 arc
s
.86489 .42806 m
.79746 .43995 L
s
.85 g
.76158 .64343 m
.76189 .6337 L
.76281 .62401 L
.76435 .61441 L
.7665 .60491 L
.76924 .59558 L
.77257 .58643 L
.77647 .57752 L
.78093 .56887 L
.78592 .56052 L
.79144 .5525 L
.79746 .54485 L
.79746 .54485 L
.86489 .55674 L
.86489 .55674 L
.86605 .55967 L
.86738 .56251 L
.86888 .56528 L
.87054 .56795 L
.87235 .57052 L
.87432 .57298 L
.87642 .57531 L
.87866 .57752 L
.88102 .57959 L
.88351 .58152 L
.88351 .58152 L
.88339 .58322 L
.88341 .58491 L
.88357 .5866 L
.88387 .58826 L
.88429 .5899 L
.88485 .5915 L
.88554 .59305 L
.88634 .59454 L
.88727 .59596 L
.8883 .5973 L
.8883 .5973 L
.88798 .59833 L
.88775 .59939 L
.88762 .60046 L
.88758 .60154 L
.88763 .60262 L
.88779 .60369 L
.88804 .60474 L
.88838 .60576 L
.88881 .60675 L
.88933 .6077 L
.88933 .6077 L
.88899 .6084 L
.88871 .60912 L
.88851 .60987 L
.88837 .61064 L
.88831 .61142 L
.88832 .6122 L
.8884 .61297 L
.88856 .61373 L
.88879 .61448 L
.88908 .6152 L
.88908 .6152 L
.88875 .61572 L
.88847 .61627 L
.88825 .61684 L
.88808 .61744 L
.88797 .61805 L
.88792 .61866 L
.88793 .61928 L
.888 .61989 L
.88812 .62049 L
.8883 .62108 L
.8883 .62108 L
.88799 .6215 L
.88771 .62195 L
.88748 .62243 L
.88729 .62292 L
.88716 .62343 L
.88707 .62395 L
.88704 .62448 L
.88705 .625 L
.88712 .62553 L
.88724 .62604 L
.88724 .62604 L
.88692 .6264 L
.88664 .62679 L
.8864 .62721 L
.8862 .62765 L
.88604 .6281 L
.88593 .62857 L
.88586 .62905 L
.88584 .62953 L
.88587 .63001 L
.88595 .63049 L
.88595 .63049 L
.88562 .63082 L
.88532 .63118 L
.88506 .63156 L
.88483 .63197 L
.88465 .63241 L
.88451 .63285 L
.88442 .63331 L
.88437 .63378 L
.88437 .63424 L
.88441 .63471 L
.88441 .63471 L
.88405 .63503 L
.88372 .63538 L
.88342 .63576 L
.88316 .63616 L
.88295 .63659 L
.88278 .63704 L
.88265 .63751 L
.88257 .63798 L
.88253 .63846 L
.88254 .63895 L
.88254 .63895 L
.88212 .63926 L
.88173 .63962 L
.88138 .64001 L
.88107 .64044 L
.8808 .64089 L
.88058 .64137 L
.8804 .64187 L
.88027 .64238 L
.8802 .6429 L
.88017 .64343 L
.88017 .64343 L
.87965 .64376 L
.87917 .64414 L
.87872 .64457 L
.87832 .64504 L
.87796 .64554 L
.87766 .64608 L
.87741 .64664 L
.87721 .64722 L
.87707 .64782 L
.87698 .64843 L
.87698 .64843 L
.87629 .6488 L
.87564 .64922 L
.87503 .64971 L
.87447 .65024 L
.87396 .65083 L
.87351 .65147 L
.87312 .65214 L
.8728 .65285 L
.87254 .65358 L
.87235 .65434 L
.87235 .65434 L
.87135 .65473 L
.87038 .65521 L
.86946 .65578 L
.86859 .65642 L
.86779 .65714 L
.86705 .65793 L
.86639 .65878 L
.8658 .65969 L
.8653 .66065 L
.86489 .66164 L
.86489 .66164 L
.86323 .662 L
.86161 .6625 L
.86003 .66312 L
.85851 .66387 L
.85706 .66473 L
.85568 .66571 L
.85438 .6668 L
.85317 .66799 L
.85207 .66928 L
.85107 .67065 L
.85107 .67065 L
.84793 .67053 L
.84478 .6706 L
.84165 .67085 L
.83853 .67129 L
.83545 .67191 L
.83241 .67271 L
.82942 .67369 L
.8265 .67485 L
.82364 .67617 L
.82088 .67766 L
.82088 .67766 L
.76158 .64343 L
F
0 g
newpath
.91493 .64343 .15335 180 220 arc
s
.79746 .54485 m
.86489 .55674 L
s
newpath
.91493 .53853 .05326 126.165 160 arc
s
newpath
.90442 .58378 .02103 140 186.165 arc
s
newpath
.89965 .60143 .01207 148.747 200 arc
s
newpath
.89661 .61169 .00831 155.031 208.747 arc
s
newpath
.89434 .61889 .00642 160 215.031 arc
s
newpath
.89246 .62457 .00542 164.244 220 arc
s
newpath
.89076 .62947 .00492 168.119 224.244 arc
s
newpath
.88913 .63404 .00477 171.881 228.119 arc
s
newpath
.88745 .63858 .00492 175.756 231.881 arc
s
newpath
.88559 .64343 .00542 180 235.756 arc
s
newpath
.88338 .64899 .00642 184.969 240 arc
s
newpath
.8805 .65596 .00831 191.253 244.969 arc
s
newpath
.87623 .66577 .01207 200 251.253 arc
s
newpath
.86854 .68236 .02103 213.835 260 arc
s
newpath
.84751 .72379 .05326 240 273.835 arc
s
.82088 .67766 m
.76158 .64343 L
s
.85 g
.79746 .54485 m
.79442 .53561 L
.79198 .52619 L
.79014 .51663 L
.7889 .50698 L
.78829 .49727 L
.78829 .48754 L
.7889 .47783 L
.79014 .46817 L
.79198 .45862 L
.79442 .4492 L
.79746 .43995 L
.79746 .43995 L
.86489 .42806 L
.86489 .42806 L
.86698 .43041 L
.86921 .43263 L
.87156 .43472 L
.87403 .43666 L
.87661 .43846 L
.8793 .44009 L
.88208 .44157 L
.88493 .44288 L
.88787 .44402 L
.89086 .44498 L
.89086 .44498 L
.89133 .44661 L
.89193 .4482 L
.89266 .44973 L
.8935 .45119 L
.89447 .45259 L
.89554 .4539 L
.89671 .45512 L
.89798 .45625 L
.89933 .45726 L
.90076 .45817 L
.90076 .45817 L
.90081 .45925 L
.90096 .46032 L
.9012 .46137 L
.90153 .4624 L
.90195 .46339 L
.90246 .46434 L
.90306 .46524 L
.90373 .46609 L
.90447 .46687 L
.90528 .46759 L
.90528 .46759 L
.9052 .46836 L
.90519 .46914 L
.90525 .46991 L
.90539 .47068 L
.9056 .47143 L
.90587 .47216 L
.90622 .47286 L
.90662 .47352 L
.90709 .47414 L
.90761 .47472 L
.90761 .47472 L
.90748 .47532 L
.90741 .47593 L
.9074 .47655 L
.90744 .47717 L
.90755 .47777 L
.90771 .47837 L
.90793 .47895 L
.9082 .4795 L
.90852 .48002 L
.9089 .48051 L
.9089 .48051 L
.90874 .48102 L
.90864 .48153 L
.90858 .48206 L
.90858 .48259 L
.90862 .48311 L
.90872 .48363 L
.90887 .48414 L
.90906 .48463 L
.90931 .48509 L
.90959 .48554 L
.90959 .48554 L
.90942 .48599 L
.90929 .48645 L
.9092 .48692 L
.90916 .4874 L
.90917 .48789 L
.90923 .48836 L
.90933 .48883 L
.90947 .48929 L
.90967 .48974 L
.9099 .49016 L
.9099 .49016 L
.9097 .49058 L
.90954 .49102 L
.90943 .49147 L
.90936 .49194 L
.90934 .4924 L
.90936 .49287 L
.90943 .49333 L
.90954 .49379 L
.9097 .49423 L
.9099 .49465 L
.9099 .49465 L
.90967 .49507 L
.90947 .49551 L
.90933 .49597 L
.90923 .49644 L
.90917 .49692 L
.90916 .4974 L
.9092 .49788 L
.90929 .49836 L
.90942 .49882 L
.90959 .49927 L
.90959 .49927 L
.90931 .49971 L
.90906 .50018 L
.90887 .50067 L
.90872 .50118 L
.90862 .5017 L
.90858 .50222 L
.90858 .50275 L
.90864 .50327 L
.90874 .50379 L
.9089 .50429 L
.9089 .50429 L
.90852 .50478 L
.9082 .50531 L
.90793 .50586 L
.90771 .50644 L
.90755 .50703 L
.90744 .50764 L
.9074 .50826 L
.90741 .50887 L
.90748 .50949 L
.90761 .51009 L
.90761 .51009 L
.90709 .51066 L
.90662 .51129 L
.90622 .51195 L
.90587 .51265 L
.9056 .51338 L
.90539 .51413 L
.90525 .51489 L
.90519 .51567 L
.9052 .51645 L
.90528 .51722 L
.90528 .51722 L
.90447 .51794 L
.90373 .51872 L
.90306 .51956 L
.90246 .52047 L
.90195 .52142 L
.90153 .52241 L
.9012 .52344 L
.90096 .52449 L
.90081 .52556 L
.90076 .52664 L
.90076 .52664 L
.89933 .52754 L
.89798 .52856 L
.89671 .52969 L
.89554 .53091 L
.89447 .53222 L
.8935 .53361 L
.89266 .53508 L
.89193 .53661 L
.89133 .5382 L
.89086 .53982 L
.89086 .53982 L
.88787 .54079 L
.88493 .54193 L
.88208 .54324 L
.8793 .54471 L
.87661 .54635 L
.87403 .54815 L
.87156 .55009 L
.86921 .55217 L
.86698 .5544 L
.86489 .55674 L
.86489 .55674 L
.79746 .54485 L
F
0 g
newpath
.94156 .4924 .15335 160 200 arc
s
.79746 .43995 m
.86489 .42806 L
s
newpath
.90569 .39383 .05326 106.165 140 arc
s
newpath
.91128 .43995 .02103 120 166.165 arc
s
newpath
.91284 .45817 .01207 128.747 180 arc
s
newpath
.91349 .46885 .00831 135.031 188.747 arc
s
newpath
.91382 .47639 .00642 140 195.031 arc
s
newpath
.91399 .48237 .00542 144.244 200 arc
s
newpath
.91408 .48756 .00492 148.119 204.244 arc
s
newpath
.91411 .4924 .00477 151.881 208.119 arc
s
newpath
.91408 .49725 .00492 155.756 211.881 arc
s
newpath
.91399 .50244 .00542 160 215.756 arc
s
newpath
.91382 .50842 .00642 164.969 220 arc
s
newpath
.91349 .51596 .00831 171.253 224.969 arc
s
newpath
.91284 .52664 .01207 180 231.253 arc
s
newpath
.91128 .54485 .02103 193.835 240 arc
s
newpath
.90569 .59098 .05326 220 253.835 arc
s
.86489 .55674 m
.79746 .54485 L
s
.6 g
.5 .79445 m
.50858 .78986 L
.51743 .78581 L
.52652 .78234 L
.53581 .77945 L
.54527 .77716 L
.55485 .77547 L
.56452 .77439 L
.57424 .77393 L
.58397 .77408 L
.59367 .77485 L
.60331 .77624 L
.60331 .77624 L
.60979 .76898 L
.61673 .76216 L
.62408 .75578 L
.63183 .74989 L
.63993 .7445 L
.64836 .73964 L
.65708 .73531 L
.66605 .73155 L
.67525 .72837 L
.68463 .72578 L
.69415 .72379 L
.69415 .72379 L
.69777 .71475 L
.70195 .70596 L
.70668 .69746 L
.71194 .68927 L
.71771 .68144 L
.72397 .67398 L
.73068 .66694 L
.73783 .66034 L
.74539 .6542 L
.75331 .64856 L
.76158 .64343 L
.76158 .64343 L
.76189 .6337 L
.76281 .62401 L
.76435 .61441 L
.7665 .60491 L
.76924 .59558 L
.77257 .58643 L
.77647 .57752 L
.78093 .56887 L
.78592 .56052 L
.79144 .5525 L
.79746 .54485 L
.79746 .54485 L
.79442 .53561 L
.79198 .52619 L
.79014 .51663 L
.7889 .50698 L
.78829 .49727 L
.78829 .48754 L
.7889 .47783 L
.79014 .46817 L
.79198 .45862 L
.79442 .4492 L
.79746 .43995 L
.79746 .43995 L
.79144 .4323 L
.78592 .42429 L
.78093 .41594 L
.77647 .40729 L
.77257 .39838 L
.76924 .38923 L
.7665 .37989 L
.76435 .3704 L
.76281 .36079 L
.76189 .35111 L
.76158 .34138 L
.76158 .34138 L
.75331 .33625 L
.74539 .33061 L
.73783 .32447 L
.73068 .31787 L
.72397 .31082 L
.71771 .30337 L
.71194 .29553 L
.70668 .28735 L
.70195 .27884 L
.69777 .27006 L
.69415 .26102 L
.69415 .26102 L
.68463 .25903 L
.67525 .25644 L
.66605 .25325 L
.65708 .24949 L
.64836 .24517 L
.63993 .24031 L
.63183 .23492 L
.62408 .22902 L
.61673 .22265 L
.60979 .21582 L
.60331 .20857 L
.60331 .20857 L
.59367 .20996 L
.58397 .21073 L
.57424 .21088 L
.56452 .21042 L
.55485 .20934 L
.54527 .20765 L
.53581 .20536 L
.52652 .20247 L
.51743 .19899 L
.50858 .19495 L
.5 .19036 L
.5 .19036 L
.49142 .19495 L
.48257 .19899 L
.47348 .20247 L
.46419 .20536 L
.45473 .20765 L
.44515 .20934 L
.43548 .21042 L
.42576 .21088 L
.41603 .21073 L
.40633 .20996 L
.39669 .20857 L
.39669 .20857 L
.39021 .21582 L
.38327 .22265 L
.37592 .22902 L
.36817 .23492 L
.36007 .24031 L
.35164 .24517 L
.34292 .24949 L
.33395 .25325 L
.32475 .25644 L
.31537 .25903 L
.30585 .26102 L
.30585 .26102 L
.30223 .27006 L
.29805 .27884 L
.29332 .28735 L
.28806 .29553 L
.28229 .30337 L
.27603 .31082 L
.26932 .31787 L
.26217 .32447 L
.25461 .33061 L
.24669 .33625 L
.23842 .34138 L
.23842 .34138 L
.23811 .35111 L
.23719 .36079 L
.23565 .3704 L
.2335 .37989 L
.23076 .38923 L
.22743 .39838 L
.22353 .40729 L
.21907 .41594 L
.21408 .42429 L
.20856 .4323 L
.20254 .43995 L
.20254 .43995 L
.20558 .4492 L
.20802 .45862 L
.20986 .46817 L
.2111 .47783 L
.21171 .48754 L
.21171 .49727 L
.2111 .50698 L
.20986 .51663 L
.20802 .52619 L
.20558 .53561 L
.20254 .54485 L
.20254 .54485 L
.20856 .5525 L
.21408 .56052 L
.21907 .56887 L
.22353 .57752 L
.22743 .58643 L
.23076 .59558 L
.2335 .60491 L
.23565 .61441 L
.23719 .62401 L
.23811 .6337 L
.23842 .64343 L
.23842 .64343 L
.24669 .64856 L
.25461 .6542 L
.26217 .66034 L
.26932 .66694 L
.27603 .67398 L
.28229 .68144 L
.28806 .68927 L
.29332 .69746 L
.29805 .70596 L
.30223 .71475 L
.30585 .72379 L
.30585 .72379 L
.31537 .72578 L
.32475 .72837 L
.33395 .73155 L
.34292 .73531 L
.35164 .73964 L
.36007 .7445 L
.36817 .74989 L
.37592 .75578 L
.38327 .76216 L
.39021 .76898 L
.39669 .77624 L
.39669 .77624 L
.40633 .77485 L
.41603 .77408 L
.42576 .77393 L
.43548 .77439 L
.44515 .77547 L
.45473 .77716 L
.46419 .77945 L
.47348 .78234 L
.48257 .78581 L
.49142 .78986 L
.5 .79445 L
F
0 g
newpath
.57668 .92726 .15335 240 280 arc
s
newpath
.72078 .87481 .15335 220 260 arc
s
newpath
.83826 .77624 .15335 200 240 arc
s
newpath
.91493 .64343 .15335 180 220 arc
s
newpath
.94156 .4924 .15335 160 200 arc
s
newpath
.91493 .34138 .15335 140 180 arc
s
newpath
.83826 .20857 .15335 120 160 arc
s
newpath
.72078 .11 .15335 100 140 arc
s
newpath
.57668 .05755 .15335 80 120 arc
s
newpath
.42332 .05755 .15335 60 100 arc
s
newpath
.27922 .11 .15335 40 80 arc
s
newpath
.16174 .20857 .15335 20 60 arc
s
newpath
.08507 .34138 .15335 0 40 arc
s
newpath
.05844 .4924 .15335 -20 20 arc
s
newpath
.08507 .64343 .15335 -40 0 arc
s
newpath
.16174 .77624 .15335 300 340 arc
s
newpath
.27922 .87481 .15335 280 320 arc
s
newpath
.42332 .92726 .15335 260 300 arc
s
gsave
.58269 .96136 -90 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
90 11.5 translate
80 rotate
-90 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CDCiDi) show
117.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.7381 .9048 -74.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
74.5 11.5 translate
60 rotate
-74.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CD) show
86.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.86478 .79849 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
68.5 11.5 translate
40 rotate
-68.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(C) show
74.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.94747 .65527 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
71 11.5 translate
20 rotate
-71 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Di) show
79.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.97619 .4924 -78.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(DiCi) show
94.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.94747 .32954 -78.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
78.5 11.5 translate
340 rotate
-78.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CiDi) show
94.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.86478 .18631 -70.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
70.5 11.5 translate
320 rotate
-70.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Ci) show
78.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.7381 .08001 -69 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
69 11.5 translate
300 rotate
-69 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(D) show
75.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.58269 .02345 -74.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
74.5 11.5 translate
280 rotate
-74.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(DC) show
86.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.41731 .02345 -90 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
90 11.5 translate
260 rotate
-90 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(DCDiCi) show
117.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.2619 .08001 -74.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
74.5 11.5 translate
240 rotate
-74.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(BA) show
86.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.13522 .18631 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
68.5 11.5 translate
220 rotate
-68.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(B) show
74.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.05253 .32954 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
71 11.5 translate
200 rotate
-71 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Ai) show
79.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.02381 .4924 -78.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
78.5 11.5 translate
180 rotate
-78.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(AiBi) show
94.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.05253 .65527 -78.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
78.5 11.5 translate
160 rotate
-78.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(BiAi) show
94.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.13522 .79849 -70.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
70.5 11.5 translate
140 rotate
-70.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Bi) show
78.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.2619 .9048 -69 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
69 11.5 translate
120 rotate
-69 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(A) show
75.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.41731 .96136 -74.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
74.5 11.5 translate
100 rotate
-74.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(AB) show
86.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 16.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
newpath
.5 .4924 .41408 0 365.73 arc
s
0 0 m
1 0 L
1 .98481 L
0 .98481 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281, 277},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I00015@P10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIS/k>gYjN[Vi^OShn03ooeGooj[ooooo0:BTY3/k>oo<VOlcolco<laVVIWooiVI
<clo?ginO[fm_Oclo5D00:X00?l00?ooEIfMWC@d=?o<I_lcc<co0<aVIYWoc0<30d92@X61PL30`000
EED0EJX0EOl0EOoooiJFURd];Oo<<olcVLc<olaV<iWoV@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z_Wi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIP/;2dY:BXV9RLS8b000oeD0ojX0ool0oo;blXV9RB0P8?nIoolc
<lc<VL`coiWo<`l?3di>CXf=SLc<c01E05EE0:YE0?mE0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEENGUiGalO1<C4onIVOl0olc<<l`cVIW<oaLG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZ]oOggIfMPd=3OnIIP0c<lc<0<`cIYW<c1/K6eYJFYVIVMSHf01EoeEEojYEoomEomSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VAlO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ0=;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IR<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEL_;bf9RH_ooZ_mVool0<lbIVL`0oiW<<bLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZ/C4a5]KFoooI_mVc00c0<bII/`0c9W<02/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`1VV@00VOoo<omVVLcoolbI<l`0VIVIobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc3<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVCLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l06P000?l06P000?l06P000?l06P000?l0
6P000?l06P000?l06P000?l06P000?l06P000?l06P000?l06P0007000onV0000L@000ol0002U0000
L@000ol0002U0000L@000ol0002U0000L@000ol0002U0000L@000ol0002U0000L002ojL0001a0003
o`000:D0003o01X0003o01X0001a0004o`0000GoW`0007@000?o00000`000ol0002L0000L`000ol0
00050003o`0009/0001c0003o`000:<0001c0003o`000:<0001c00?oX`0007<00_nT0000L`02o`H0
00?o0000V`0007<00_l60003o`0009/0001d0003o`0000<00_nM0000M006o`030?l002001Omg0000
L`02obL000?o00000`000ol0001d0000M0000ol0000T0003o`0000D000?o0000L`0009/000?o0000
N`0009/000?o0000N`0007@000?o000090000ol0001k0000MP08oad000?o0000N`0007L000?o0000
10000ol0000J0003o`0000D000?o0000L`0007L000?o00001@000ol0000I0003o`0000D000?o0000
L`0007L000?o00001@000ol0000J0003o`0000<00_me0000M`000ol000050003o`0001/01Ol00`3o
001d0000M`000ol000050003o`0001L02?mh0000M`000ol000050003o`3o01Go0`000ol000040003
o`0007D0001g0003o`0000Oo5P07o`@000?o0000M00007D01Ol200Co00<0o`004`000ol0o`03o`80
1Omf0000L`02o`801Ol2T004oi3o00?o3P03o`060?n@T?n@1?l200?oM00005400ol500?o4P05o`<0
2Ol01Y20T82@00;o2P02o`0<082@P920T?n@P9201?l200Go4P08oeD0001B0003o`0000D000?o0000
3`02o`L000GoT92@o`05T003oi2@00>@0P000ol000060003o`2@00N@00?oT90019000`3o000600;o
4@000ol000040003o`000580001C0003o`0000<000?o00003P02o`P001CoT82@oi20T82@P93oT82@
P920o`P001;oT82@P920T82@oi20T82@P902o`P00_l?0003o`0000D000?o0000D@0005<000?o0000
0`000ol0000<00;o2P001On@T93o00n@00?o000010000on@T008T003oi2@00F@0_l:00?o30000ol0
00050003o`000540001C00Oo2@05o`X00_l05H2@P93oT82@P920T82@P920T82@P002o`<001KoT82@
P920T82@P93oT82@P920oh2@0_l;00Co20000ol000050003o`000540001D0005o`000?l02@000ol0
000<0003oi2@00B@00?oT9003i00103o0?l;T0So1I000ol0000<0003o`0000D000?o00001@000ol0
001A0000E0001Ol0003o00P000?o00003@00=_n0T82@P93oT82@P920T82@P920T82@P9200?n@P920
T82@P920T82@P920T82@P920T82@o`l000?o000010000ol000050003o`000540001E0003o`3o00L0
0_l@0003oi2@00B@00?oT9001I000on@T009T003oi2@01N@00?o00003P02o`@000?o00001@000ol0
001A0000E@000ol0o`0500go1P00>?n@P920T82@oi20T82@P93oT82@P920T82@P93oT82@P920T82@
P920T82@P920T82@P920T83o1P0=o`8000?o00001@000ol0001A0000E@000ol0o`0300Co2Y000`3o
00040003oi2@00J@00?oT9000i02o`^@00?oT90069000ol000030003o`2@00R@00<0ool00ol60003
o`000580001F00Wo00b@P920T82@P920T002o`8000_oP920T82@P920T005o`0ZT?n@P920T82@P920
T?n@P920T82@P920T82@P920T82@P920T82@P93o0P02o`0>T82@P920T82@P920T009oeD0001H0004
o`3oo`>@00?oT9002Y000`3oo`0MT003oi2@01V@00<0ool04I02o`030?l005P0001G00Co01n@P920
oh2@P920T82@P920T82@oi20T82@P920T82@00So03^0T82@P920T82@oi20T82@P920T82@P920T82@
P920T82@P920T83oP920T82@P920T82@P920T82@P002o`030?l005L0001E00;o00<0ool01I000on@
T00=T003oi2@00V@00?oT90019000on@T007T003oi2@01V@00?oT9004i02o`030?oo05H0001C00;o
0`001_n@P920T0;o0620T82@P920T82@P920T83oP920T82@P920T83oP920T82@P?n0T82@P920T?n@
P920T82@P920T82@P920T82@P920T82@P93oT82@P920T82@P920T82@P920T82@P?l300;oE0000580
00Co00002?lAT003oi2@00V@00?oT9001I000on@T006T003oi2@01V@00?oT9005I02o`<000?o0000
D@00054000?o00000P002?n@oi20T82@0_l0HX2@P920T82@P920T82@P93oT82@P920T82@P?n0T82@
P920oh2@P920T82@oi20T82@P920T82@P920T82@P920T82@P920oh2@P920T82@P920T82@P920T82@
P920T83o10000ol0000F00?o=`0004l00_l50003oi3o00J@00?oT9003Y000on@T008T003oi2@00F@
00?oT9001Y000on@T00HT003oi2@01N@00?o00000`02oaL000?o0000=P0004h000?o00001@00K?n@
oi20T82@P?n0T82@P920T82@P920T82@P?n0T82@P920T83oP920T82@P?n0T82@P920T?n@P920T82@
P920T82@P920T82@P920T82@oi20T82@P920T82@P920T82@P920T82@P920o`L000?o000050000ol0
000f0000C@000ol000050004oi2@o`J@00?oT9003i000on@T007T003oi2@00F@00?oT9001Y000on@
T00GT003oi2@01V@00?o00001@000ol0000C0003o`0003H0001<0003o`0000H000?oP?l01ol0I920
T82@P920T82@P920T82@P?n0T82@P920T83oP920T82@P?n0T82@P920T?n@P920T82@P920T82@P920
T82@P920T82@oi20T82@P920T82@P920T82@P920T82@P920T?l80003o`00018000?o0000=P0004/0
00?o00001`000on@T00JT003oi2@00J@00?oT90019000on@T007T003oi2@01J@00?oT9006Y000ol0
00060003o`00018000?o0000=P0004X000?o000020009On0T82@P920T82@P920T82@P920T82@P920
T82@oi20T82@P9002?l02H2@P920T82@P003o`0eP920T82@P920T82@P920T82@P920T83oP920T82@
P920T82@P920T82@P920T82@P920T?l02@02oa400_lh0000B@000ol000090003oi2@01^@00?oT900
4Y03o`;g00B@oooo4i000on@T00KT003o`0000T000?o00002@05o`030?l003L000180003o`0000X0
033oP920T82@P920T82@P920T82@P920T82@P920T83oP920T82@P920T82@P920T803o`03P?Og00Gg
03>0ooooP920T82@P920T82@P920T?n@P920T82@P920T82@P920T82@P920T82@P920T?l030000ol0
00070003o`0000<000?o0000=`0004L000?o00000`02o`H000?oT9006i000on@T00<T0?o00>@moL0
2_L2T0;o3Y000on@T00KT003o`0000@00_l50003o`0000D000?o00001@000ol0000f0000A`000ol0
0003o`03T83o00Ko01j0T82@P920T82@P920T82@P920T82@P920T82@P904o`04P920T0Ko5?L6o`04
P920T0Co01j0T82@P920T82@P920T82@P920T82@P920T82@P907o`03T03o00;o0`000ol000040003
o`0000D000?o0000=P0004D00_l00`3oo`0;T003oi2@01^@00?omoL00_L4ob3g1?l4m`03oi2@01^@
00?oT9002I02o`8000?o00000`000ol0000n0000A000;Ol0oon0T82@P920T82@P920T?n@P920T82@
P920T82@P920T82@P920T82@P002oc;g0_l0:I20T82@P920T82@P920T82@P920T82@P920oh2@P920
T82@P920T82@00;o00<0o`000`000ol0000n0000>P08o`030?l000;o49000on@T00FT003oi3g03?g
00>@oi005i000on@T00>T0;o00<0o`000P000ol0000n0000>`000ol0000400?o02b@P920T82@P920
T82@P920T82@oi20T82@P920T82@P920T82@P920T83oP3Kg02b@oi20T82@P920T82@P920T82@P920
T83oP920T82@P920T82@P920T82@P0?o0P000ol000050003o`0003H0000k0003o`0000@00_lET003
oi2@01:@00?oT?L0=oL00i3oT00CT003oi2@01>@0_l20003o`0000D000?o0000=P0003/000?o0000
0`03o`0XP920T82@P920T82@P920T82@P920T?n@P920T82@P920T82@P920T0;o??L2o`0XP920T82@
P920T82@P920T83oP920T82@P920T82@P920T82@P920T0?o0P000ol0000300;o>00003/000?o0000
0P03oaN@00?oT9003Y000oogm`0nm`03oi2@00j@00?oT9005I000ol0o`0200Go00<0o`00=`0003/0
1ol09h2@P920T82@P920T82@P920T82@P920T83oP920T82@P920T82@P002od;g0_l0:Y20T82@P920
T82@P93oT82@P920T82@P920T82@P920T82@P920T?l0od00000k0006o`000?l00_lIT003oi2@00R@
0_m6m`;o2Y000on@T00HT003o`3o0400000k000/o`00o`3oT?n@P920T82@P920T82@P920T82@P920
T82@P?n0T82@P920T?m:m`0Yoh2@P920T82@oi20T82@P920T82@P920T82@P920T82@P920T83o0?l0
?`0003/000So003o0?n@oa^@00?oT9001Om<m`Go0Y000on@T00KT003o`3o03l0000k0003o`3o0080
01ooT?n@P920T82@P920T82@P920T82@P920T82@P92000;o00>@moL0D_L08X3ooi20T82@P920T82@
P920T82@P920T82@P920T82@P?l20003o`0003`0000j00So7I000oogm`1Fm`03oi2@01b@00Go0000
o`0m0000>`000ol00002000Ooi20T82@P920T82@P920T82@P920T82@P920T82@o`1Jm`0Ooh2@P920
T82@P920T82@P920T82@P920T82@P920o`040003o`0003X0000k0003o`00008000?oT9006i000oog
m`1Hm`03oi2@01^@00?o00000P000ol0000j0000>P000ol00002000Poh2@P920T82@P920T82@P920
T82@P920T82@P920T?mJm`0Poh2@P920T82@P920T82@P920T82@P920T82@P9200?l40003o`0003T0
000j0003o`00008000?oT9006i000oogm`1Jm`03oi2@01^@00?o00000P000ol0000i0000>@000ol0
0004000Moi20T82@P920T82@P920T82@P920T82@P920T?l0G_L07On0T82@P920T82@P920T82@P920
T82@P920T83o00H000?o0000>00003T000?o00001@000on@T00GT003ooOg05gg00>@oi0069000ol0
00050003o`0003P0000h0003o`0000H001_oP920T82@P920T82@P920T82@P920T82@oi00H?L06h3o
P920T82@P920T82@P920T82@P920T82@o`080003o`0003L0000h0003o`0000H000?oT9005Y000oog
m`1Pm`03oi2@01J@00?o00001P000ol0000J00?o6P0003L000?o00001`006On0T82@P920T82@P920
T82@P920T82@P?l0I?L06On@P920T82@P920T82@P920T82@P920T?l02@000ol0000J0003o`0001T0
000f0003o`0000P00olET003ooOg06;g00?oT9004i03o`X000?o00006@000ol0000I0000=@000ol0
000300Ko01R@P93oT82@P920T82@P920T82@P920T?mVm`0Hoh2@P920T82@P920T82@P920T83oP920
1_l50003o`0001P000?o00006@0003D000?o00000P000on@T008T0;o3i02ofSg0_l?T0;o2Y000ol0
00020003o`0000d02?l30003o`0001T0000d0003o`0000?o00f0T82@P920T82@P92000;o00f@P920
T82@P920T83o06_g00j@oi20T82@P920T82@P0;o00f@P920T82@P920T82@00?o0P000ol0000600?o
10000ol000040004o`00oa/0000d0004o`00oa6@00?oT90029000on@m`1[m`03T?n@00V@00?oT900
3i001?l00?l90003o`0000<000?o00001@03oa/0000d000Fo`3ooh2@P920T82@P920T82@P920T0;o
00R0T82@P920og3g00SoT82@P920T0;o01:0T82@P920T82@P920T82@P902o`030?l000P000?o0000
0`000ol000050003o`3o01/0000d00;o5Y02o`>@0_mbm`;o0i02oaF@00<0ool02@000ol000030003
o`0000D000?o00006`0003<00ol06h2@P920T82@P920T82@P920T82@P920T?n@o`1fm`0Koh3oP920
T82@P920T82@P920T82@P920T82@00?o00<0ool00ol20003o`0000<000?o00001@000ol0000K0000
<`02oaZ@00?omoL0M_L00on@T00HT0?o1@000ol0o`050003o`0000D000?o0?l06`0002000ol@000M
oh2@P920T82@P920T82@P920T82@P920T82@P?l0N?L07On@P920T82@P920T82@P920T82@P920T82@
P93o00L00_l50003o`0000D000?o00006`00024000?o00003P02oa^@00?omoL0M_L00on@T00IT0;o
1`000ol000030003o`0000D000?o00006`00024000?o00003P02o`0LP920T82@P920T82@P920T82@
P920T82@P920ogSg01coT82@P920T82@P920T82@P920T82@P920T82@0_l=0003o`0000@000?o0000
7000024000?o00003@02oab@00?omoL0M_L00on@T00IT0?o2`08oal0000Q0003o`0000H00ol400Co
01^@P920T82@P920T82@P920T82@P920T82@P?l0N?L07?n@P920T82@P920T82@P920T82@P920T82@
P903o`H000?o0000:@00024000?o00001`000ol000020004o`3ooa^@00?omoL0M_L00on@T00IT0;o
00<0o`000`000ol0000Z00008002o`X002Co0000o`3oT82@P920T82@P920T82@P920T82@P920T82@
P?mhm`0Loi20T82@P920T82@P920T82@P920T82@P920T0;o00<0o`000`000ol0000Z00008@000ol0
00080007o`000?l0o`0KT003ooOg07Sg00?oT9006I000ol0o`0300;o;00002`01ol07920T82@P920
T82@P920T82@P920T82@P920T?mjm`0Loh2@P920T82@P920T82@P920T82@P920T82@P0Ko00<0o`00
:`0002d000?o00000olKT003ooOg07Sg00?oT9006I000ol0o`0a00008@000ol000090004o`3o00;o
01^@P920T82@P920T82@P920T82@P920T82@P?l0O?L07?n@P920T82@P920T82@P920T82@P920T82@
P?l20003o`0002h0000^00?o0P000on@T00GT003ooOg07[g00?oT9005i001Ol0003o0300000^0003
o`3o008001_oP920T82@P920T82@P920T82@P920T82@P?l0O?L06on@P920T82@P920T82@P920T82@
P920T82@o`040003o`0002d0000^0003o`3o00800_lGT003ooOg07_g00>@oi005Y02o`@000?o0000
;@0002h00_l4000IP?n0T82@P920T82@P920T82@P920T82@o`1nm`0Hoh2@P920T82@P920T82@P920
T82@P93o1P000ol0000]0000;P000ol000040003T?n@01>@00?omoL0OOL00i3oT00CT003o`0000D0
00?o0000;@0002h000?o00001@005_n@P920T82@P920T82@P920T82@oi20m`0FP?n0T82@P920T82@
P920T82@P920o`L000?o0000;@0002d000?o00001P000i3oT00AT003ooOg07og00>@oi004I000ol0
00070003o`0002`0000]0003o`0000L001CoP920T82@P920T82@P920T83oP8;g01B@oi20T82@P920
T82@P920T82@o`T000?o0000;00002d000?o00001`05o`f@00?omoL0P_L00on@T00;T0Go2@000ol0
000/0000;@000ol000060006oi20T82@2?l01H2@P93o08Kg00GoP920T008o`06P920T83o20000ol0
000/0000;@000ol0000400;o3Y04ohSg1?l>T0;o1P000ol0000/0000;@000ol0000200;o01B0T82@
P920T82@P920T82@P920ohSg01CoT82@P920T82@P920T82@P920T0;o10000ol0000/0000;@001Ol0
003o01J@00?omoL0Q?L00on@T00DT005o`000?l0;P0002`000?o00000P006?n0T82@P920T82@P920
T82@P920T82@ohKg01SoP920T82@P920T82@P920T82@P920T?l40003o`0002/0000/0005o`000?l0
5i000oogm`24m`03oi2@01F@00Go0000o`0]0000;0007Ol00?n0T82@P920T82@P920T82@P920T82@
P93o08Kg01[oP920T82@P920T82@P920T82@P920T82@o`8000?o0000:`0002`000Co003o69000oOo
m`23m`03oi2@01N@00Co003o;@0002`001ko0?n@P920T82@P920T82@P920T82@P920T82@P?n4m`0N
oi20T82@P920T82@P920T82@P920T82@P920o`3o;@0002`000?o0?l06Y000oogm`22m`03oi2@01R@
00?o0?l0;@0002`001ko0?n@P920T82@P920T82@P920T82@P920T82@P?n4m`0Moi20T82@P920T82@
P920T82@P920T82@P920o`002?l300?o1005o`<00olA0000;002oa^@00?omoL0P_L00on@T00IT0?o
1P001Ol0003o00@000?o00000`001Ol0003o0180000/00;o01b0T82@P920T82@P920T82@P920T82@
P920T83oQ?L07?n@P920T82@P920T82@P920T82@P920T82@P903o`L000Co003o0`000ol000050004
o`00oa80000/00;o6i000oogm`22m`03oi2@01V@0ol70004o`00o`<000?o000020000ol0000@0000
;002o`0LP920T82@P920T82@P920T82@P920T82@P920ohCg01coT82@P920T82@P920T82@P920T82@
P920T82@0ol70004o`00o`<000?o000020000ol0000@0000;002oa^@00?omoL0P_L00on@T00IT0?o
1`001?l00?l30003o`0000P000?o0000400002`00_l0782@P920T82@P920T82@P920T82@P920T82@
P?n4m`0Loi20T82@P920T82@P920T82@P920T82@P920T0?o1`001?l0ool30003o`0000L00_lB0000
;0000on@o`0JT003ooOg08;g00?oT90069001?l0ool70004o`00o`<000?o00001@001?l00?lB0000
;0007_l0oi20T82@P920T82@P920T82@P920T82@P920ohCg01goT82@P920T82@P920T82@P920T82@
P920T83o0002o`L000?o000010000ol000050003o`0001<0000C00?o2008o`H01?l5T0?o4I000oog
m`22m`03oi2@01R@00Co0?oo1P000ol000060003o`0000<00_lE000050000ol000080005o`000?l0
0P000ol00003000No`3ooh2@P920T?n@P920T82@P920T82@P920T83oQ?L06on@P920T82@P920T82@
P920T82@P920T82@o`0200So10000ol0000300Go00D0o`00o`0B000050000ol000080005o`000?l0
0P000ol000030004o`00o`F@00?oT9004I000oogm`22m`03oi2@01N@00Co003o;@0001@000?o0000
20001Ol0003o008000?o00000`000ol00002o`0HT82@P?n0T82@P920T82@P920T82@P93oQ_L06On0
T82@P920T82@P920T82@P920T82@P?l00`000ol0000[000050000ol000080006o`000?l00_l50003
o`0000Oo4Y000oogm`24m`03oi2@01B@00?o00000P000ol0000[000050000ol0000800Ko1`001?l0
0003o`0FT?n@P920T82@P920T82@P920T82@ohKg01KoP920T82@P920T82@P920T82@P9200_l40003
o`0002/0000C00;o2P000ol00002o`030?oo00H000Ko003o0902oa:@00?omoL0Q_L00on@T00@T0;o
00>@00000P000ol0000/000050000ol000080005o`000?l00P000ol00004000Fo`000?l0oh3oP920
T82@P920T82@P0GoR?L5o`0?T82@P920T82@P920T?n@00H000?o0000;00001l000?o000010000ol0
00040007o`000?l0o`020003oi2@00:@2?l5T003ooOg08Cg00?oT9000i08o`B@00?o00001P000ol0
000/00007`000ol000040003o`0000@000Oo0000o`3o00<01?l03i20T82@P920T82@P920o`24m`0?
oi20T82@P920T82@P92000Co2@000ol0000/000050000ol0000700So1`000ol000020003o`000080
00?oT9003i000oogm`22m`03oi2@00n@00?o00001`000ol0000/0000;@000ol00007000Doh2@P920
T82@P920T82@P920T?n2m`0Doh2@P920T82@P920T82@P920T?l90003o`0002`0000]0003o`0000H0
00>@oi004I000oogm`20m`03oi2@012@00?o00001`000ol0000/0000;P000ol0000400;o01F@P920
T82@P920T82@P920T82@P?l0P?L05On@P920T82@P920T82@P920T82@P002o`H000?o0000;@0002h0
00?o00000`000on@T00ET003ooOg07cg00?oT90059000`3o00040003o`0002d0000^0003o`000080
01[oP920T82@P920T82@P920T82@P920T82@ogkg01[oP920T82@P920T82@P920T82@P920T800o`@0
00?o0000;@0002h000?o00000P000on@T00GT003ooOg07[g00?oT9005i000ol000020003o`0002d0
000^0003o`00008001_oP920T82@P920T82@P920T82@P920T82@P?l0O?L06on@P920T82@P920T82@
P920T82@P920T82@o`040003o`0002d0000_0005o`000?l06I000oogm`1jm`03oi2@01N@00Go0000
o`0`0000;`008?l00?n@P920T82@P920T82@P920T82@P920T82@P?OoN_L07On0T82@P920T82@P920
T82@P920T82@P920T83o008000?o0000;P00030000?o0?l06i000oogm`1hm`03oi2@01V@00?o0?l0
<@00030001oo0?n@P920T82@P920T82@P920T82@P920T82@P93o07[g01ooP920T82@P920T82@P920
T82@P920T82@P920o`3o0340000`0003o`3o01^@00?omoL0N?L00on@T00IT003o`3o0340000`000P
o`3oT82@P920T82@P920T82@P920T82@P920T82@P?mhm`0Poi20T82@P920T82@P920T82@P920T82@
P920T83o0?la0000<0000ol0o`0LT003ooOg07Kg00?oT9006Y000ol0o`0a0000<@02o`0MT82@P920
T82@P920T82@P920T82@P920T82@P?l0N?L07On@P920T82@P920T82@P920T82@P920T82@P92000;o
<P0003400olKT003ooOg07Kg00?oT9006I03o`L02?lS0000<P02o`0LP920T82@P920T82@P920T82@
P920T82@P920ogSg01coT82@P920T82@P920T82@P920T82@P920T82@0_l90003o`0000@000?o0000
800003800_lKT003ooOg07Kg00?oT9006I02o`T000?o00001@000ol0000O0000<`02o`0IT82@P920
T82@P920T82@P920T82@P920T003ogKg0ol06H2@P920T82@P920T82@P920T82@P920T8000_l:0003
o`0000D000?o00007`0003<00olGT005oi2@mol0M?L01OogT93o01N@0ol:0003o`0000D00olO0000
=002o`0EP920T82@P920T82@P920T82@P92000;o00J@P920mombm`06ooN@P9200_l05I20T82@P920
T82@P920T82@P920T002o`/000?o00001@02ob00000d00Wo3902o`R@00?omoL0K_L00on@T006T0;o
4I02o`030?l000X000?o00001@02ob00000d000Po`3ooh2@P920oh2@P920T82@P93oT82@P920T82@
P902ofcg0_l07H2@P920T82@P920oh2@P920T82@P920T82@P93o008000?o00002@000ol0000500;o
800003@000?o0?l00ol3T003oi2@00J@0_l=T003moog06Wg00?oT9003902o`b@0ol20003o`0000T0
00?o00001@02ob00000d0003o`3o00<000[oT83oP920T82@0_l04X2@P920T82@P920T82@P93gofSg
01;omh2@P920T82@P920T82@P902o`0:P920T82@P920o`D000?o00002@000ol000040003o`3o0200
000Z00?o2002o`@01ol00i3oT00CT003ooOg06Cg00?oT9004Y000on@o`06o`D000?o00002@08o`03
0?oo0200000V00?o0P000ol00003o`D01_l4000JP93oT82@P920T82@P920T82@P920T82@momTm`0I
oi20T82@P920T82@P920T82@P920T83oP00:0003o`0001@000?o00007P0002L000Go0000o`030003
o`0000@00_l400;o10000on@T00DT003ooOg06;g00?oT90059000ol000080003o`0003H0000X0004
o`00o`8000?o00001@02o`D001ko0000oh2@P920T82@P920T82@P920T82@P920T?mRm`0Joh2@P920
T82@P920T82@P920T82@P920T?l90003o`0003H0000X0004o`00o`8000?o00001@000ol0o`040005
o`000?l069000oogm`1Pm`03oi2@01J@00?o00001P000ol0000F0003o`0001h0000K00?o2P07o`L0
00?o0?l010007ol0003oP920T82@P920T82@P920T82@P920T82@P?l0H?L06on@P920T82@P920T82@
P920T82@P920T82@o`080003o`0003L0000L0003o`0000X00ol00`3o000600So0`000on@T00IT003
ooOg05cg00?oT9006I000ol000040003o`0003P0000L0003o`0000X000Go0?l0o`0;0003o`0000@0
01goT82@P920T82@P920T82@P920T82@P920T82@o`1Nm`0Moh2@P920T82@P920T82@P920T82@P920
T82@P?l01P000ol0000h000070000ol0000;0003o`3o00d000?o00000P000on@T00KT003ooOg05[g
00?oT9006i000ol000020003o`0003T0000L0003o`0000/000?o0?l03@000ol00002000Poh2@P920
T82@P920T82@P920T82@P920T82@P920momJm`0Poh2@P920T82@P920T82@P920T82@P920T82@P920
0?l40003o`0003T0000L0003o`0000/00ol>0003o`00008000?oT9006i000oogm`1Hm`03oi2@01^@
00?o00000P000ol0000j00006`02o`h000?o00003P009?l0003oT82@P920T82@P920T82@P920T82@
P920T82@P93goeSg023oT82@P920T82@P920T82@P920T82@P920T82@P920o`<000?o0000>`0001`0
00?o00007P001?l00?lNT0?oE?L3oaj@00Co003o?P0003d002Go003oT82@P920T82@P920T82@P920
T82@P920T82@P920oh2@00GoB_L5o`0RP93oT82@P920T82@P920T82@P920T82@P920T82@P920o`80
00?o0000?00003h000?o0?l07I000on@T004T0;g00?omoL0A_L00oogm`06T003oi2@01^@00?o0?l0
?`0001`000?o00007`00:_l00?n0T82@P920T82@P920T82@P920T82@P920T83oP920T82@P920m`;o
A?L2o`0Wmi20T82@P920T?n@P920T82@P920T82@P920T82@P920T82@P93o008000?o0000?@0003l0
00?o0?l06Y000on@T00:T003mooo043g0_l00oN@T00:T003oi2@01R@00?o0?l0@000040002goT?n@
P920T82@P920T82@P920T82@P920T83oP920T82@P920T82@P920mol0?_L0;OogT82@P920T82@P920
T82@oi20T82@P920T82@P920T82@P920T82@P?l0o`110000@@03oaJ@00?oT90049000oogm`0jm`03
oi2@012@00?oT9005903od800011000^o`3oP920T82@P920T82@P920T82@P920T?n@P920T82@P920
T82@P920T82@oc[g02koP920T82@P920T82@P920T82@P?n0T82@P920T82@P920T82@P920T82@o`3o
@P0004800olDT003oi2@01>@0_lfm`;o5I000on@T00BT0?o@`0004<002ooP?ooT82@P920T82@P920
T82@P93oT82@P920T82@P920T82@P920T82@P920o`0dm`0[oi20T82@P920T82@P920T82@P920T82@
P?n0T82@P920T82@P920T82@P002o`030?l004<0001400Co3i000on@T00HT003ooOg033g00?oT900
69000on@T00=T0CoA@0004H002koT?ooP920T82@P920T82@oi20T82@P920T82@P920T82@P920T82@
P920T83o1?L5oakg1Ol4m`0Zoi20T82@P920T82@P920T82@P920T82@P920T83oP920T82@P920T82@
0_l00`3o000>00Go<`0004H000Co002@0ol00i3oo`06oaj@1?l5T0Ko4_L6o`03mi2@00:@1?lNT0So
00B@oooo0`000ol0000<0003o`0000<000?o0000<00004L000?o00000`000on00005000^oh2@P920
T82@P920T82@P920T82@P920T82@P920T?n@P920T82@P920T82@P0?o3OL2o`0^T82@P920T82@P920
T83oP920T82@P920T82@P920T82@P920T82@P920T82@o`H000>@o`0010000ol0000<0003o`0000D0
00?o0000;`0004P000?o00002P000on@T00KT003oi2@012@0ol7m`?o4I000on@T00KT003o`0000X0
00?o00003@000ol0000g0000B@02o`X003CoP920T82@P920T82@P920T82@P920T82@P920T83oP920
T82@P920T82@P920T82@P9200ol0=oOooon0T82@P920T82@P920T82@P920T?n@P920T82@P920T82@
P920T82@P920T82@P920T?l02P02oa0000?o0000=`0004/000?o00001`000on@T00KT003oi2@01J@
00?oT9005I000on@T00KT003o`0000L000?o000040000ol0000g0000@@08o`8000?o00001`00K_n0
T82@P920T82@P920T82@P920T82@P920T82@oi20T82@P920T82@P920T82@P920T82@P93oT82@P920
T82@P920T82@P920T82@P920oh2@P920T82@P920T82@P920T82@P920T82@P93o2@000ol0000@0003
o`0003L000120003o`0000@000Co003o20000on@T00JT003oi2@01N@00?oT9005Y000on@T00JT003
o`0000H000?o00004@000ol000050003o`0002l000120003o`0000@000Go0000o`07001^oh2@P920
T82@P920T82@P920T82@P920T82@P?n0T82@P920T82@P920T82@P920T82@P920T?n@P920T82@P920
T82@P920T82@P920T82@oi20T82@P920T82@P920T82@P920T82@P920T?l70003o`00018000?o0000
1@000ol0000_0000@P000ol000040003o`0000800_l50003oi2@01V@00?oT90069000on@T00GT003
oi2@01V@00?o00000`02oaH000?o00000`02oc4000120003o`0000<00_l60003o`0000<006coT82@
P920T82@P920T82@P920T82@P920T83oP920T82@P920T82@P920T82@P920T82@P93oT82@P920T82@
P920T82@P920T82@P920T?n@P920T82@P920T82@P920T82@P920T82@P?l50003o`0001L01Ol00`3o
000`0000@P06o`T000?o00000P000on@T00GT003oi2@01V@00?oT90069000on@T00GT003o`000080
00?o0000D000048000?o00000`02o`P00_l200;o06R0T82@P920T82@P920T82@P920T82@P93oT82@
P920T82@P920T82@P920T82@P920T82@oi20T82@P920T82@P920T82@P920T82@P920oh2@P920T82@
P920T82@P920T82@P920T0;o0P02oe<0000h00?o1`000ol000040003o`0000P00_l00`3oT00FT003
oi2@01Z@00?oT9006I000on@T00ET004o`3ooeD0000i0003o`0000H000?o000010000ol0000:001X
o`3ooh2@P920T82@P920T82@P920T82@P?n0T82@P920T82@P920T82@P920T82@P920T82@oi20T82@
P920T82@P920T82@P920T82@P920T?n@P920T82@P920T82@P920T82@P902o`030?l005H0000i0003
o`0000H000?o000010000ol0000;0004o`3ooaB@00?oT9006Y000on@T00IT003oi2@01:@0_l00`3o
001G0000>@000ol0000500So3`04o`0@P920T82@P920T82@P920T0?o03Z@P920T82@P920T82@P920
T82@P920T82@P920T?n@P920T82@P920T82@P920T82@P920T82@P9200ol0482@P920T82@P920T82@
P904oeT0000i0003o`0001h00ol=T0;o0`000on@T00JT003oi2@01:@1Ol2T004o`00T0;o3I03oe/0
000i0003o`0002000ol02i20T82@P920T83o00D003[oP920T82@P920T82@P920T82@P920T82@P920
T?n@P920T82@P920T82@P920T82@oi20T82@oi3o1000393oT82@P920T82@P0?oG@0003P00_lT00_o
1`000on@T00IT003oi2@012@00?oT9001I000ol0000500_o2P05oe00000i0003o`0002@000?o0000
3@00>?n@P920T82@P920T82@P920T82@P920T82@P93oT82@P920T82@P920T82@P920oh2@P920T83o
3`000ol000090003o`0000<000?o0000C@00064000?o00003@000on@T00GT0;o4Y000on@T004T003
o`0000d000?o00002@000ol000050003o`0004`0001R00;o3@02o`0HT82@P920T82@P920T82@P920
T82@P93o0P006?n0T82@P920T82@P920T82@P?n0T82@P0;o3@02o``000?o0000E00003T000?o0000
:005o`P00Y000on@T00CT003o`00008000?oT9003Y000on@T002T003oi0000T01?l>0003o`0005@0
001Y00;o20005on0T82@P920T82@P920T82@P920T83o00@001OoT82@P920T82@P920T82@P?n0T82@
o`020003o`0000<00olB0003o`0005@0001[00;o1`000on@T00AT003o`0000@000?oT9003I001On@
T93o00<000Co00000_lE0003o`0005@0001]00;o1P004On0T82@P920T82@P920T82@00;o2002o`0A
P920T82@P920T82@P93oT?l00`02o`030?oo01L000?o00001@000ol0001<0000K`05o`800ol;T0;o
3002o`^@2_lI0003o`0000D000?o0000C00007@00_l200Co00J0T82@oi02oa000_l01X3oP920T0Co
00<0ool01_lJ0003o`0000<00_m>0000F`03o`D00ol@00Go00>@ool00_l00`3o000C0003oi3o00?o
00<0ool01?l60003o`0001P02om:0000G0000ol000050003o`0001@01olD00Oo1@000ol000050003
o`0001/000?o000010000ol000170000G@000ol000030003o`0001`05?l<0003o`0000D000?o0000
6`000ol000050003o`0004H0001M0003o`0000<000?o0000?0000ol000050003o`0001/000?o0000
1@000ol000160000G@07och000?o00001@000ol0000K0003o`0000D000?o0000AP0005h000Go0000
o`0L00?o1@03oaP000?o00001@000ol0000K0003o`0000D000?o0000AP0005h000Go0000o`0M0003
o`0000D000?o00005`000ol000050003o`0001/000?o00001@000ol000160000G`000ol0o`0O0003
o`0000<000?o000060000ol000050003o`0001/000?o00001@000ol000160000G`000ol0o`0O0003
o`0000<000?o000060000ol000040003o`0001`000?o00001@000ol000160000G`000ol0o`0O00Oo
6@08oal000?o000010000ol000170000H0000ol0000O0005o`000?l07P05oad02?m:0000PP001Ol0
003o01d000?o00000`000ol0001/0000P`000ol0o`0M0003o`0000D000?o0000J`0008<000?o0?l0
7@000ol0001c0000P`000ol0o`0M0003o`0007<000240003o`0001`000?o0000L`000:<000?o0000
L`0007h02?lM0003o`0000D000?o0000J`0007l000?o000010000ol0000J0003o`0000D000?o0000
J`0007l000?o000010000ol0000K0003o`0000<00_m]0000O`000ol000040003o`0001`01Ol00`3o
001/0000O`000ol0000300;o7@03og80001o00Ko80000ol0001a0000O`000ol0000300;o7P000ol0
001a0000O`000ol000040003o`0001`000?o0000L@0007l000?o000010000ol0000L00WoJ`0007l0
00?o000010000ol0000L0003o`3o00H000?o0000J00007h02?lN00;o00<0o`001P000ol0001W0000
Y@000ol0o`070003o`0006L0002W0003o`0000D000?o0000I`000:L000?o00001@000ol0001W0000
Y@000ol0o`070003o`0006L0002W0003o`0000D000?o0000I`000:L000?o00001@000ol0001W0000
Y`000ol000040003o`0006P0002V00SoJ`000?l06P000:L00om_0000Z0000ol0001^0000Z0000ol0
001^0000Z0000ol0001^0000Z0000ol0001^0000Z0000ol0001^0000Y`02og00002X0003o`0006h0
0000\
\>"],
  ImageRangeCache->{{{0, 280}, {276, 0}} -> {-1.46623, -1.44528, 0.010473, 
  0.010473}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Drawing a set of filled polygons"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["p = Map[N[UnitPolygon[#]]&, {64, 32, 16, 8, 4}];", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
HDraw[{{
\tGrayLevel[0], p[[1]],
\tRGBColor[0.0,0.4,0.9], p[[2]],
\tRGBColor[0,0.9,0.4], p[[3]],
\tRGBColor[0.9,0.9,0.1], p[[4]],
\tRGBColor[0.9,0.1,0.1], p[[5]]} /. 
\t\tPolygon -> PlainFilledPolygon}, 
\tDrawUnitCircle -> False]\
\>", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 .97619 m
.50108 .96918 L
.5042 .96281 L
.50909 .95768 L
.5153 .95424 L
.52225 .95282 L
.5293 .95355 L
.53581 .95636 L
.54118 .961 L
.54492 .96703 L
.54667 .9739 L
.54667 .9739 L
.54706 .96682 L
.54954 .96017 L
.55391 .95458 L
.55975 .95056 L
.56652 .94846 L
.57362 .9485 L
.58037 .95066 L
.58617 .95474 L
.59048 .96037 L
.5929 .96704 L
.5929 .96704 L
.59259 .95996 L
.59441 .9531 L
.59821 .94711 L
.60362 .94253 L
.61016 .93978 L
.61722 .93912 L
.62416 .94061 L
.63033 .94411 L
.63517 .94929 L
.63823 .95569 L
.63823 .95569 L
.63722 .94867 L
.63837 .94167 L
.64156 .93533 L
.6465 .93024 L
.65274 .92687 L
.6597 .92552 L
.66675 .92632 L
.67323 .92919 L
.67855 .93388 L
.68223 .93994 L
.68223 .93994 L
.68054 .93305 L
.68099 .92598 L
.68355 .91936 L
.68796 .91381 L
.69384 .90984 L
.70064 .90782 L
.70773 .90792 L
.71446 .91015 L
.72022 .91429 L
.72447 .91996 L
.72447 .91996 L
.72212 .91327 L
.72187 .90619 L
.72377 .89935 L
.72762 .8934 L
.73308 .88887 L
.73964 .88619 L
.74671 .8856 L
.75363 .88715 L
.75977 .89071 L
.76456 .89594 L
.76456 .89594 L
.76156 .88951 L
.76062 .88248 L
.76183 .87549 L
.76508 .86919 L
.77007 .86415 L
.77634 .86084 L
.78332 .85956 L
.79036 .86043 L
.79681 .86336 L
.80209 .8681 L
.80209 .8681 L
.79848 .862 L
.79685 .85509 L
.79738 .84802 L
.79999 .84143 L
.80447 .83593 L
.81038 .83201 L
.8172 .83006 L
.82429 .83023 L
.831 .83252 L
.83672 .83672 L
.83672 .83672 L
.83252 .831 L
.83023 .82429 L
.83006 .8172 L
.83201 .81038 L
.83593 .80447 L
.84143 .79999 L
.84802 .79738 L
.85509 .79685 L
.862 .79848 L
.8681 .80209 L
.8681 .80209 L
.86336 .79681 L
.86043 .79036 L
.85956 .78332 L
.86084 .77634 L
.86415 .77007 L
.86919 .76508 L
.87549 .76183 L
.88248 .76062 L
.88951 .76156 L
.89594 .76456 L
.89594 .76456 L
.89071 .75977 L
.88715 .75363 L
.8856 .74671 L
.88619 .73964 L
.88887 .73308 L
.8934 .72762 L
.89935 .72377 L
.90619 .72187 L
.91327 .72212 L
.91996 .72447 L
.91996 .72447 L
.91429 .72022 L
.91015 .71446 L
.90792 .70773 L
.90782 .70064 L
.90984 .69384 L
.91381 .68796 L
.91936 .68355 L
.92598 .68099 L
.93305 .68054 L
.93994 .68223 L
.93994 .68223 L
.93388 .67855 L
.92919 .67323 L
.92632 .66675 L
.92552 .6597 L
.92687 .65274 L
.93024 .6465 L
.93533 .64156 L
.94167 .63837 L
.94867 .63722 L
.95569 .63823 L
.95569 .63823 L
.94929 .63517 L
.94411 .63033 L
.94061 .62416 L
.93912 .61722 L
.93978 .61016 L
.94253 .60362 L
.94711 .59821 L
.9531 .59441 L
.95996 .59259 L
.96704 .5929 L
.96704 .5929 L
.96037 .59048 L
.95474 .58617 L
.95066 .58037 L
.9485 .57362 L
.94846 .56652 L
.95056 .55975 L
.95458 .55391 L
.96017 .54954 L
.96682 .54706 L
.9739 .54667 L
.9739 .54667 L
.96703 .54492 L
.961 .54118 L
.95637 .53581 L
.95355 .5293 L
.95282 .52225 L
.95424 .5153 L
.95768 .50909 L
.96281 .5042 L
.96918 .50108 L
.97619 .5 L
.97619 .5 L
.96918 .49892 L
.96281 .4958 L
.95768 .49091 L
.95424 .4847 L
.95282 .47775 L
.95355 .4707 L
.95636 .46419 L
.961 .45882 L
.96703 .45508 L
.9739 .45333 L
.9739 .45333 L
.96682 .45294 L
.96017 .45046 L
.95458 .44609 L
.95056 .44025 L
.94846 .43348 L
.9485 .42638 L
.95066 .41963 L
.95474 .41383 L
.96037 .40952 L
.96704 .4071 L
.96704 .4071 L
.95996 .40741 L
.9531 .40559 L
.94711 .40179 L
.94253 .39638 L
.93978 .38984 L
.93912 .38278 L
.94061 .37584 L
.94411 .36967 L
.94929 .36483 L
.95569 .36177 L
.95569 .36177 L
.94867 .36278 L
.94167 .36163 L
.93533 .35844 L
.93024 .3535 L
.92687 .34726 L
.92552 .3403 L
.92632 .33325 L
.92919 .32677 L
.93388 .32145 L
.93994 .31777 L
.93994 .31777 L
.93305 .31946 L
.92598 .31901 L
.91936 .31645 L
.91381 .31204 L
.90984 .30616 L
.90782 .29936 L
.90792 .29227 L
.91015 .28554 L
.91429 .27978 L
.91996 .27553 L
.91996 .27553 L
.91327 .27788 L
.90619 .27813 L
.89935 .27623 L
.8934 .27238 L
.88887 .26692 L
.88619 .26036 L
.8856 .25329 L
.88715 .24637 L
.89071 .24023 L
.89594 .23544 L
.89594 .23544 L
.88951 .23844 L
.88248 .23938 L
.87549 .23817 L
.86919 .23492 L
.86415 .22993 L
.86084 .22366 L
.85956 .21668 L
.86043 .20964 L
.86336 .20319 L
.8681 .19791 L
.8681 .19791 L
.862 .20152 L
.85509 .20315 L
.84802 .20262 L
.84143 .20001 L
.83593 .19553 L
.83201 .18962 L
.83006 .1828 L
.83023 .17571 L
.83252 .169 L
.83672 .16328 L
.83672 .16328 L
.831 .16748 L
.82429 .16977 L
.8172 .16994 L
.81038 .16799 L
.80447 .16407 L
.79999 .15857 L
.79738 .15198 L
.79685 .14491 L
.79848 .138 L
.80209 .1319 L
.80209 .1319 L
.79681 .13664 L
.79036 .13957 L
.78332 .14044 L
.77634 .13916 L
.77007 .13585 L
.76508 .13081 L
.76183 .12451 L
.76062 .11752 L
.76156 .11049 L
.76456 .10406 L
.76456 .10406 L
.75977 .10929 L
.75363 .11285 L
.74671 .1144 L
.73964 .11381 L
.73308 .11113 L
.72762 .1066 L
.72377 .10065 L
.72187 .09381 L
.72212 .08673 L
.72447 .08004 L
.72447 .08004 L
.72022 .08571 L
.71446 .08985 L
.70773 .09208 L
.70064 .09218 L
.69384 .09016 L
.68796 .08619 L
.68355 .08064 L
.68099 .07402 L
.68054 .06695 L
.68223 .06006 L
.68223 .06006 L
.67855 .06612 L
.67323 .07081 L
.66675 .07368 L
.6597 .07448 L
.65274 .07313 L
.6465 .06976 L
.64156 .06467 L
.63837 .05833 L
.63722 .05133 L
.63823 .04431 L
.63823 .04431 L
.63517 .05071 L
.63033 .05589 L
.62416 .05939 L
.61722 .06088 L
.61016 .06022 L
.60362 .05747 L
.59821 .05289 L
.59441 .0469 L
.59259 .04004 L
.5929 .03296 L
.5929 .03296 L
.59048 .03963 L
.58617 .04526 L
.58037 .04934 L
.57362 .0515 L
.56652 .05154 L
.55975 .04944 L
.55391 .04542 L
.54954 .03983 L
.54706 .03318 L
.54667 .0261 L
.54667 .0261 L
.54492 .03297 L
.54118 .039 L
.53581 .04363 L
.5293 .04645 L
.52225 .04718 L
.5153 .04576 L
.50909 .04232 L
.5042 .03719 L
.50108 .03082 L
.5 .02381 L
.5 .02381 L
.49892 .03082 L
.4958 .03719 L
.49091 .04232 L
.4847 .04576 L
.47775 .04718 L
.4707 .04645 L
.46419 .04364 L
.45882 .039 L
.45508 .03297 L
.45333 .0261 L
.45333 .0261 L
.45294 .03318 L
.45046 .03983 L
.44609 .04542 L
.44025 .04944 L
.43348 .05154 L
.42638 .0515 L
.41963 .04934 L
.41383 .04526 L
.40952 .03963 L
.4071 .03296 L
.4071 .03296 L
.40741 .04004 L
.40559 .0469 L
.40179 .05289 L
.39638 .05747 L
.38984 .06022 L
.38278 .06088 L
.37584 .05939 L
.36967 .05589 L
.36483 .05071 L
.36177 .04431 L
.36177 .04431 L
.36278 .05133 L
.36163 .05833 L
.35844 .06467 L
.3535 .06976 L
.34726 .07313 L
.3403 .07448 L
.33325 .07368 L
.32677 .07081 L
.32145 .06612 L
.31777 .06006 L
.31777 .06006 L
.31946 .06695 L
.31901 .07402 L
.31645 .08064 L
.31204 .08619 L
.30616 .09016 L
.29936 .09218 L
.29227 .09208 L
.28554 .08985 L
.27978 .08571 L
.27553 .08004 L
.27553 .08004 L
.27788 .08673 L
.27813 .09381 L
.27623 .10065 L
.27238 .1066 L
.26692 .11113 L
.26036 .11381 L
.25329 .1144 L
.24637 .11285 L
.24023 .10929 L
.23544 .10406 L
.23544 .10406 L
.23844 .11049 L
.23938 .11752 L
.23817 .12451 L
.23492 .13081 L
.22993 .13585 L
.22366 .13916 L
.21668 .14044 L
.20964 .13957 L
.20319 .13664 L
.19791 .1319 L
.19791 .1319 L
.20152 .138 L
.20315 .14491 L
.20262 .15198 L
.20001 .15857 L
.19553 .16407 L
.18962 .16799 L
.1828 .16994 L
.17571 .16977 L
.169 .16748 L
.16328 .16328 L
.16328 .16328 L
.16748 .169 L
.16977 .17571 L
.16994 .1828 L
.16799 .18962 L
.16407 .19553 L
.15857 .20001 L
.15198 .20262 L
.14491 .20315 L
.138 .20152 L
.1319 .19791 L
.1319 .19791 L
.13664 .20319 L
.13957 .20964 L
.14044 .21668 L
.13916 .22366 L
.13585 .22993 L
.13081 .23492 L
.12451 .23817 L
.11752 .23938 L
.11049 .23844 L
.10406 .23544 L
.10406 .23544 L
.10929 .24023 L
.11285 .24637 L
.1144 .25329 L
.11381 .26036 L
.11113 .26692 L
.1066 .27238 L
.10065 .27623 L
.09381 .27813 L
.08673 .27788 L
.08004 .27553 L
.08004 .27553 L
.08571 .27978 L
.08985 .28554 L
.09208 .29227 L
.09218 .29936 L
.09016 .30616 L
.08619 .31204 L
.08064 .31645 L
.07402 .31901 L
.06695 .31946 L
.06006 .31777 L
.06006 .31777 L
.06612 .32145 L
.07081 .32677 L
.07368 .33325 L
.07448 .3403 L
.07313 .34726 L
.06976 .3535 L
.06467 .35844 L
.05833 .36163 L
.05133 .36278 L
.04431 .36177 L
.04431 .36177 L
.05071 .36483 L
.05589 .36967 L
.05939 .37584 L
.06088 .38278 L
.06022 .38984 L
.05747 .39638 L
.05289 .40179 L
.0469 .40559 L
.04004 .40741 L
.03296 .4071 L
.03296 .4071 L
.03963 .40952 L
.04526 .41383 L
.04934 .41963 L
.0515 .42638 L
.05154 .43348 L
.04944 .44025 L
.04542 .44609 L
.03983 .45046 L
.03318 .45294 L
.0261 .45333 L
.0261 .45333 L
.03297 .45508 L
.039 .45882 L
.04364 .46419 L
.04645 .4707 L
.04718 .47775 L
.04576 .4847 L
.04232 .49091 L
.03719 .4958 L
.03082 .49892 L
.02381 .5 L
.02381 .5 L
.03082 .50108 L
.03719 .5042 L
.04232 .50909 L
.04576 .5153 L
.04718 .52225 L
.04645 .5293 L
.04364 .53581 L
.039 .54118 L
.03297 .54492 L
.0261 .54667 L
.0261 .54667 L
.03318 .54706 L
.03983 .54954 L
.04542 .55391 L
.04944 .55975 L
.05154 .56652 L
.0515 .57362 L
.04934 .58037 L
.04526 .58617 L
.03963 .59048 L
.03296 .5929 L
.03296 .5929 L
.04004 .59259 L
.0469 .59441 L
.05289 .59821 L
.05747 .60362 L
.06022 .61016 L
.06088 .61722 L
.05939 .62416 L
.05589 .63033 L
.05071 .63517 L
.04431 .63823 L
.04431 .63823 L
.05133 .63722 L
.05833 .63837 L
.06467 .64156 L
.06976 .6465 L
.07313 .65274 L
.07448 .6597 L
.07368 .66675 L
.07081 .67323 L
.06612 .67855 L
.06006 .68223 L
.06006 .68223 L
.06695 .68054 L
.07402 .68099 L
.08064 .68355 L
.08619 .68796 L
.09016 .69384 L
.09218 .70064 L
.09208 .70773 L
.08985 .71446 L
.08571 .72022 L
.08004 .72447 L
.08004 .72447 L
.08673 .72212 L
.09381 .72187 L
.10065 .72377 L
.1066 .72762 L
.11113 .73308 L
.11381 .73964 L
.1144 .74671 L
.11285 .75363 L
.10929 .75977 L
.10406 .76456 L
.10406 .76456 L
.11049 .76156 L
.11752 .76062 L
.12451 .76183 L
.13081 .76508 L
.13585 .77007 L
.13916 .77634 L
.14044 .78332 L
.13957 .79036 L
.13664 .79681 L
.1319 .80209 L
.1319 .80209 L
.138 .79848 L
.14491 .79685 L
.15198 .79738 L
.15857 .79999 L
.16407 .80447 L
.16799 .81038 L
.16994 .8172 L
.16977 .82429 L
.16748 .831 L
.16328 .83672 L
.16328 .83672 L
.169 .83252 L
.17571 .83023 L
.1828 .83006 L
.18962 .83201 L
.19553 .83593 L
.20001 .84143 L
.20262 .84802 L
.20315 .85509 L
.20152 .862 L
.19791 .8681 L
.19791 .8681 L
.20319 .86336 L
.20964 .86043 L
.21668 .85956 L
.22366 .86084 L
.22993 .86415 L
.23492 .86919 L
.23817 .87549 L
.23938 .88248 L
.23844 .88951 L
.23544 .89594 L
.23544 .89594 L
.24023 .89071 L
.24637 .88715 L
.25329 .8856 L
.26036 .88619 L
.26692 .88887 L
.27238 .8934 L
.27623 .89935 L
.27813 .90619 L
.27788 .91327 L
.27553 .91996 L
.27553 .91996 L
.27978 .91429 L
.28554 .91015 L
.29227 .90792 L
.29936 .90782 L
.30616 .90984 L
.31204 .91381 L
.31645 .91936 L
.31901 .92598 L
.31946 .93305 L
.31777 .93994 L
.31777 .93994 L
.32145 .93388 L
.32677 .92919 L
.33325 .92632 L
.3403 .92552 L
.34726 .92687 L
.3535 .93024 L
.35844 .93533 L
.36163 .94167 L
.36278 .94867 L
.36177 .95569 L
.36177 .95569 L
.36483 .94929 L
.36967 .94411 L
.37584 .94061 L
.38278 .93912 L
.38984 .93978 L
.39638 .94253 L
.40179 .94711 L
.40559 .9531 L
.40741 .95996 L
.4071 .96704 L
.4071 .96704 L
.40952 .96037 L
.41383 .95474 L
.41963 .95066 L
.42638 .9485 L
.43348 .94846 L
.44025 .95056 L
.44609 .95458 L
.45046 .96017 L
.45294 .96682 L
.45333 .9739 L
.45333 .9739 L
.45508 .96703 L
.45882 .961 L
.46419 .95636 L
.4707 .95355 L
.47775 .95282 L
.4847 .95424 L
.49091 .95768 L
.4958 .96281 L
.49892 .96918 L
.5 .97619 L
F
0 .4 .9 r
.5 .97619 m
.50202 .96258 L
.5079 .95013 L
.51715 .93994 L
.52895 .93286 L
.5423 .92952 L
.55605 .93019 L
.56901 .93483 L
.58006 .94303 L
.58826 .95408 L
.5929 .96704 L
.5929 .96704 L
.59222 .95329 L
.59557 .93994 L
.60264 .92814 L
.61284 .91889 L
.62529 .91301 L
.6389 .91099 L
.65251 .91301 L
.66496 .91889 L
.67515 .92814 L
.68223 .93994 L
.68223 .93994 L
.67889 .92659 L
.67956 .91284 L
.6842 .89989 L
.6924 .88883 L
.70345 .88063 L
.71641 .876 L
.73016 .87532 L
.74351 .87866 L
.75531 .88574 L
.76456 .89594 L
.76456 .89594 L
.75867 .8835 L
.75665 .86988 L
.75867 .85627 L
.76456 .84382 L
.7738 .83363 L
.78561 .82655 L
.79896 .82321 L
.8127 .82388 L
.82566 .82852 L
.83672 .83672 L
.83672 .83672 L
.82852 .82566 L
.82388 .8127 L
.82321 .79896 L
.82655 .78561 L
.83363 .7738 L
.84382 .76456 L
.85627 .75867 L
.86988 .75665 L
.8835 .75867 L
.89594 .76456 L
.89594 .76456 L
.88574 .75531 L
.87866 .74351 L
.87532 .73016 L
.876 .71641 L
.88063 .70345 L
.88883 .6924 L
.89989 .6842 L
.91284 .67956 L
.92659 .67889 L
.93994 .68223 L
.93994 .68223 L
.92814 .67515 L
.91889 .66496 L
.91301 .65251 L
.91099 .6389 L
.91301 .62529 L
.91889 .61284 L
.92814 .60264 L
.93994 .59557 L
.95329 .59222 L
.96704 .5929 L
.96704 .5929 L
.95408 .58826 L
.94303 .58006 L
.93483 .56901 L
.93019 .55605 L
.92952 .5423 L
.93286 .52895 L
.93994 .51715 L
.95013 .5079 L
.96258 .50202 L
.97619 .5 L
.97619 .5 L
.96258 .49798 L
.95013 .4921 L
.93994 .48285 L
.93286 .47105 L
.92952 .4577 L
.93019 .44395 L
.93483 .43099 L
.94303 .41994 L
.95408 .41174 L
.96704 .4071 L
.96704 .4071 L
.95329 .40778 L
.93994 .40443 L
.92814 .39736 L
.91889 .38716 L
.91301 .37471 L
.91099 .3611 L
.91301 .34749 L
.91889 .33504 L
.92814 .32485 L
.93994 .31777 L
.93994 .31777 L
.92659 .32111 L
.91284 .32044 L
.89989 .3158 L
.88883 .3076 L
.88063 .29655 L
.876 .28359 L
.87532 .26984 L
.87866 .25649 L
.88574 .24469 L
.89594 .23544 L
.89594 .23544 L
.8835 .24133 L
.86988 .24335 L
.85627 .24133 L
.84382 .23544 L
.83363 .2262 L
.82655 .21439 L
.82321 .20104 L
.82388 .1873 L
.82852 .17434 L
.83672 .16328 L
.83672 .16328 L
.82566 .17148 L
.8127 .17612 L
.79896 .17679 L
.78561 .17345 L
.7738 .16637 L
.76456 .15618 L
.75867 .14373 L
.75665 .13012 L
.75867 .1165 L
.76456 .10406 L
.76456 .10406 L
.75531 .11426 L
.74351 .12134 L
.73016 .12468 L
.71641 .124 L
.70345 .11937 L
.6924 .11117 L
.6842 .10011 L
.67956 .08716 L
.67889 .07341 L
.68223 .06006 L
.68223 .06006 L
.67515 .07186 L
.66496 .08111 L
.65251 .08699 L
.6389 .08901 L
.62529 .08699 L
.61284 .08111 L
.60264 .07186 L
.59557 .06006 L
.59222 .04671 L
.5929 .03296 L
.5929 .03296 L
.58826 .04592 L
.58006 .05697 L
.56901 .06517 L
.55605 .06981 L
.5423 .07048 L
.52895 .06714 L
.51715 .06006 L
.5079 .04987 L
.50202 .03742 L
.5 .02381 L
.5 .02381 L
.49798 .03742 L
.4921 .04987 L
.48285 .06006 L
.47105 .06714 L
.4577 .07048 L
.44395 .06981 L
.43099 .06517 L
.41994 .05697 L
.41174 .04592 L
.4071 .03296 L
.4071 .03296 L
.40778 .04671 L
.40443 .06006 L
.39736 .07186 L
.38716 .08111 L
.37471 .08699 L
.3611 .08901 L
.34749 .08699 L
.33504 .08111 L
.32485 .07186 L
.31777 .06006 L
.31777 .06006 L
.32111 .07341 L
.32044 .08716 L
.3158 .10011 L
.3076 .11117 L
.29655 .11937 L
.28359 .124 L
.26984 .12468 L
.25649 .12134 L
.24469 .11426 L
.23544 .10406 L
.23544 .10406 L
.24133 .1165 L
.24335 .13012 L
.24133 .14373 L
.23544 .15618 L
.2262 .16637 L
.21439 .17345 L
.20104 .17679 L
.1873 .17612 L
.17434 .17148 L
.16328 .16328 L
.16328 .16328 L
.17148 .17434 L
.17612 .1873 L
.17679 .20104 L
.17345 .21439 L
.16637 .2262 L
.15618 .23544 L
.14373 .24133 L
.13012 .24335 L
.1165 .24133 L
.10406 .23544 L
.10406 .23544 L
.11426 .24469 L
.12134 .25649 L
.12468 .26984 L
.124 .28359 L
.11937 .29655 L
.11117 .3076 L
.10011 .3158 L
.08716 .32044 L
.07341 .32111 L
.06006 .31777 L
.06006 .31777 L
.07186 .32485 L
.08111 .33504 L
.08699 .34749 L
.08901 .3611 L
.08699 .37471 L
.08111 .38716 L
.07186 .39736 L
.06006 .40443 L
.04671 .40778 L
.03296 .4071 L
.03296 .4071 L
.04592 .41174 L
.05697 .41994 L
.06517 .43099 L
.06981 .44395 L
.07048 .4577 L
.06714 .47105 L
.06006 .48285 L
.04987 .4921 L
.03742 .49798 L
.02381 .5 L
.02381 .5 L
.03742 .50202 L
.04987 .5079 L
.06006 .51715 L
.06714 .52895 L
.07048 .5423 L
.06981 .55605 L
.06517 .56901 L
.05697 .58006 L
.04592 .58826 L
.03296 .5929 L
.03296 .5929 L
.04671 .59222 L
.06006 .59557 L
.07186 .60264 L
.08111 .61284 L
.08699 .62529 L
.08901 .6389 L
.08699 .65251 L
.08111 .66496 L
.07186 .67515 L
.06006 .68223 L
.06006 .68223 L
.07341 .67889 L
.08716 .67956 L
.10011 .6842 L
.11117 .6924 L
.11937 .70345 L
.124 .71641 L
.12468 .73016 L
.12134 .74351 L
.11426 .75531 L
.10406 .76456 L
.10406 .76456 L
.1165 .75867 L
.13012 .75665 L
.14373 .75867 L
.15618 .76456 L
.16637 .7738 L
.17345 .78561 L
.17679 .79896 L
.17612 .8127 L
.17148 .82566 L
.16328 .83672 L
.16328 .83672 L
.17434 .82852 L
.1873 .82388 L
.20104 .82321 L
.21439 .82655 L
.2262 .83363 L
.23544 .84382 L
.24133 .85627 L
.24335 .86988 L
.24133 .8835 L
.23544 .89594 L
.23544 .89594 L
.24469 .88574 L
.25649 .87866 L
.26984 .87532 L
.28359 .876 L
.29655 .88063 L
.3076 .88883 L
.3158 .89989 L
.32044 .91284 L
.32111 .92659 L
.31777 .93994 L
.31777 .93994 L
.32485 .92814 L
.33504 .91889 L
.34749 .91301 L
.3611 .91099 L
.37471 .91301 L
.38716 .91889 L
.39736 .92814 L
.40443 .93994 L
.40778 .95329 L
.4071 .96704 L
.4071 .96704 L
.41174 .95408 L
.41994 .94303 L
.43099 .93483 L
.44395 .93019 L
.4577 .92952 L
.47105 .93286 L
.48285 .93994 L
.4921 .95013 L
.49798 .96258 L
.5 .97619 L
F
0 .9 .4 r
.5 .97619 m
.50356 .95048 L
.51396 .9267 L
.53042 .90664 L
.55172 .89179 L
.57624 .88329 L
.60215 .88176 L
.6275 .88732 L
.6504 .89956 L
.66911 .91755 L
.68223 .93994 L
.68223 .93994 L
.67568 .91483 L
.67619 .88888 L
.68372 .86404 L
.69771 .84218 L
.71712 .82494 L
.74047 .81361 L
.76602 .80905 L
.79185 .81159 L
.81602 .82105 L
.83672 .83672 L
.83672 .83672 L
.82105 .81602 L
.81159 .79185 L
.80905 .76602 L
.81361 .74047 L
.82494 .71712 L
.84218 .69771 L
.86404 .68372 L
.88888 .67619 L
.91483 .67568 L
.93994 .68223 L
.93994 .68223 L
.91755 .66911 L
.89956 .6504 L
.88732 .6275 L
.88176 .60215 L
.88329 .57624 L
.89179 .55172 L
.90664 .53042 L
.9267 .51396 L
.95048 .50356 L
.97619 .5 L
.97619 .5 L
.95048 .49644 L
.9267 .48604 L
.90664 .46958 L
.89179 .44828 L
.88329 .42376 L
.88176 .39785 L
.88732 .3725 L
.89956 .3496 L
.91755 .33089 L
.93994 .31777 L
.93994 .31777 L
.91483 .32432 L
.88888 .32381 L
.86404 .31628 L
.84218 .30229 L
.82494 .28288 L
.81361 .25953 L
.80905 .23398 L
.81159 .20815 L
.82105 .18398 L
.83672 .16328 L
.83672 .16328 L
.81602 .17895 L
.79185 .18841 L
.76602 .19095 L
.74047 .18639 L
.71712 .17506 L
.69771 .15782 L
.68372 .13596 L
.67619 .11112 L
.67568 .08517 L
.68223 .06006 L
.68223 .06006 L
.66911 .08245 L
.6504 .10044 L
.6275 .11268 L
.60215 .11824 L
.57624 .11671 L
.55172 .10821 L
.53042 .09336 L
.51396 .0733 L
.50356 .04952 L
.5 .02381 L
.5 .02381 L
.49644 .04952 L
.48604 .0733 L
.46958 .09336 L
.44828 .10821 L
.42376 .11671 L
.39785 .11824 L
.3725 .11268 L
.3496 .10044 L
.33089 .08245 L
.31777 .06006 L
.31777 .06006 L
.32432 .08517 L
.32381 .11112 L
.31628 .13596 L
.30229 .15782 L
.28288 .17506 L
.25953 .18639 L
.23398 .19095 L
.20815 .18841 L
.18398 .17895 L
.16328 .16328 L
.16328 .16328 L
.17895 .18398 L
.18841 .20815 L
.19095 .23398 L
.18639 .25953 L
.17506 .28288 L
.15782 .30229 L
.13596 .31628 L
.11112 .32381 L
.08517 .32432 L
.06006 .31777 L
.06006 .31777 L
.08245 .33089 L
.10044 .3496 L
.11268 .3725 L
.11824 .39785 L
.11671 .42376 L
.10821 .44828 L
.09336 .46958 L
.0733 .48604 L
.04952 .49644 L
.02381 .5 L
.02381 .5 L
.04952 .50356 L
.0733 .51396 L
.09336 .53042 L
.10821 .55172 L
.11671 .57624 L
.11824 .60215 L
.11268 .6275 L
.10044 .6504 L
.08245 .66911 L
.06006 .68223 L
.06006 .68223 L
.08517 .67568 L
.11112 .67619 L
.13596 .68372 L
.15782 .69771 L
.17506 .71712 L
.18639 .74047 L
.19095 .76602 L
.18841 .79185 L
.17895 .81602 L
.16328 .83672 L
.16328 .83672 L
.18398 .82105 L
.20815 .81159 L
.23398 .80905 L
.25953 .81361 L
.28288 .82494 L
.30229 .84218 L
.31628 .86404 L
.32381 .88888 L
.32432 .91483 L
.31777 .93994 L
.31777 .93994 L
.33089 .91755 L
.3496 .89956 L
.3725 .88732 L
.39785 .88176 L
.42376 .88329 L
.44828 .89179 L
.46958 .90664 L
.48604 .9267 L
.49644 .95048 L
.5 .97619 L
F
.9 .9 .1 r
.5 .97619 m
.50379 .93771 L
.51501 .90071 L
.53324 .86661 L
.55777 .83672 L
.58766 .81219 L
.62176 .79396 L
.65876 .78274 L
.69724 .77895 L
.73573 .78274 L
.77273 .79396 L
.80683 .81219 L
.83672 .83672 L
.83672 .83672 L
.81219 .80683 L
.79396 .77273 L
.78274 .73573 L
.77895 .69724 L
.78274 .65876 L
.79396 .62176 L
.81219 .58766 L
.83672 .55777 L
.86661 .53324 L
.90071 .51501 L
.93771 .50379 L
.97619 .5 L
.97619 .5 L
.93771 .49621 L
.90071 .48499 L
.86661 .46676 L
.83672 .44223 L
.81219 .41234 L
.79396 .37824 L
.78274 .34124 L
.77895 .30276 L
.78274 .26427 L
.79396 .22727 L
.81219 .19317 L
.83672 .16328 L
.83672 .16328 L
.80683 .18781 L
.77273 .20604 L
.73573 .21726 L
.69724 .22105 L
.65876 .21726 L
.62176 .20604 L
.58766 .18781 L
.55777 .16328 L
.53324 .13339 L
.51501 .09929 L
.50379 .06229 L
.5 .02381 L
.5 .02381 L
.49621 .06229 L
.48499 .09929 L
.46676 .13339 L
.44223 .16328 L
.41234 .18781 L
.37824 .20604 L
.34124 .21726 L
.30276 .22105 L
.26427 .21726 L
.22727 .20604 L
.19317 .18781 L
.16328 .16328 L
.16328 .16328 L
.18781 .19317 L
.20604 .22727 L
.21726 .26427 L
.22105 .30276 L
.21726 .34124 L
.20604 .37824 L
.18781 .41234 L
.16328 .44223 L
.13339 .46676 L
.09929 .48499 L
.06229 .49621 L
.02381 .5 L
.02381 .5 L
.06229 .50379 L
.09929 .51501 L
.13339 .53324 L
.16328 .55777 L
.18781 .58766 L
.20604 .62176 L
.21726 .65876 L
.22105 .69724 L
.21726 .73573 L
.20604 .77273 L
.18781 .80683 L
.16328 .83672 L
.16328 .83672 L
.19317 .81219 L
.22727 .79396 L
.26427 .78274 L
.30276 .77895 L
.34124 .78274 L
.37824 .79396 L
.41234 .81219 L
.44223 .83672 L
.46676 .86661 L
.48499 .90071 L
.49621 .93771 L
.5 .97619 L
F
.9 .1 .1 r
.5 .97619 m
.50261 .92642 L
.51041 .87718 L
.52331 .82904 L
.54117 .78251 L
.5638 .7381 L
.59094 .69629 L
.62231 .65756 L
.65756 .62231 L
.69629 .59094 L
.7381 .5638 L
.78251 .54117 L
.82904 .52331 L
.87718 .51041 L
.92642 .50261 L
.97619 .5 L
.97619 .5 L
.92642 .49739 L
.87718 .48959 L
.82904 .47669 L
.78251 .45883 L
.7381 .4362 L
.69629 .40906 L
.65756 .37769 L
.62231 .34244 L
.59094 .30371 L
.5638 .2619 L
.54117 .21749 L
.52331 .17096 L
.51041 .12282 L
.50261 .07358 L
.5 .02381 L
.5 .02381 L
.49739 .07358 L
.48959 .12282 L
.47669 .17096 L
.45883 .21749 L
.4362 .2619 L
.40906 .30371 L
.37769 .34244 L
.34244 .37769 L
.30371 .40906 L
.2619 .4362 L
.21749 .45883 L
.17096 .47669 L
.12282 .48959 L
.07358 .49739 L
.02381 .5 L
.02381 .5 L
.07358 .50261 L
.12282 .51041 L
.17096 .52331 L
.21749 .54117 L
.2619 .5638 L
.30371 .59094 L
.34244 .62231 L
.37769 .65756 L
.40906 .69629 L
.4362 .7381 L
.45883 .78251 L
.47669 .82904 L
.48959 .87718 L
.49739 .92642 L
.5 .97619 L
F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`00<d51@Oo<c00c
VLcoI/aVc<`009VIIS/k>gYjN[Vi^OShn03ooeGooj[ooooo0:BTY3/k>oo<VOlcolco<laVVIWooiVI
<clo?ginO[fm_Oclo5D00:X00?l00?ooEIfMWC@d=?o<I_lcc<co0<aVIYWoc0<30d92@X61PL30`000
EED0EJX0EOl0EOoooiJFURd];Oo<<olcVLc<olaV<iWoV@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z_Wi
nI2@T2LW9oo<0?lcI/c<c<aV09WoIP/;2dY:BXV9RLS8b000oeD0ojX0ool0oo;blXV9RB0P8?nIoolc
<lc<VL`coiWo<`l?3di>CXf=SLc<c01E05EE0:YE0?mE0>c/k8>3PaXJ6_nIc?lc0<c<I/`cc9Wo01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEENGUiGalO1<C4onIVOl0olc<<l`cVIW<oaLG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZ]oOggIfMPd=3OnIIP0c<lc<0<`cIYW<c1/K6eYJFYVIVMSHf01EoeEEojYEoomEomSH
f6m_K`H61_nI<ol0VLbIol`c<iW<VAlO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ0=;BdVUYJOooc?nI0?l0
I/bIc<`c09W<IR<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEL_;bf9RH_ooZ_mVool0<lbIVL`0oiW<<bLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZ/C4a5]KFoooI_mVc00c0<bII/`0c9W<02/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`1VV@00VOoo<omVVLcoolbI<l`0VIVIobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0;Ng
]di>CP00c?mVI/coc<bI0<`0IYVIc3<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEK6a/DQ8B?o<oomV<lco
VLaVol`0<iVIVCLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@0008l000?<00002P000ol000210000P@000ol0
000:0003S7`000/000?o0000P@0007@000><00002P02o`/000><o?l02`000ol000210000M002o`/0
1?l80003onae00;o2003o``000=l0000M00007@000?oc?l02P06o`D00_l00gD@S002o`D01_l:00;o
MP0007@000CoO?oo1`0>o`04O12FS0oo1`000on<o`1f0000J0000ol000090003olb<01Ko00G<UQn<
c00Fo`03S?oo07D0001X00;o2003o`03O8al01Co00N<O1nFk7b<01Co00=lS7`00ol800;oJ@0006L0
1?l500Co00J<c8c<S<`Ao`09c8clUQo/c8c<017o00G<S<b<c005o`D00omY0000F`000ol0000900go
00N<O8alS7b<00ko00elS7b<[1nFk:b<O8al00ko00J<O8alS7`>ofP0001K0003o00000P03_l02Hc<
S<b<c8c<S00;o`0?S<b<c>clUQo/o8c<S<b<00_o00V<c8c<S<b<c8`03Ol:0003o`0005/0001K0003
oh`000P03Ol037b<O8alS7b<O8alS0Ko01ElS7b<O8alk:`OUQ2/S7b<O8alS7`01_l038alS7b<O8al
S7b<O0go2@000n`0001K0000F`001?o/c?l3013o03^<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c>`@
UQmeo>c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S00@o`<000?oc?l0G@0005/000Cok7b<4_l0?Gb<
O8alS7b<O8alS7b<O8alS7b<O8alS7b<[>ae7iH@[>b/S7b<O8alS7b<O8alS7b<O8alS7b<O8alS7`0
4_l00hb/o`1M0000F`001On<o8c<013o03n<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c>clk12F7gD@
k?c/c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8`04?l00lb<o002oe`0001?0003o`0000P00_l01hb/
k:b<O8`02_l0AGb<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8b/k:`@MAnF47G/[>b/S7b<O8alS7b<
O8alS7b<O8alS7b<O8alS7b<O00;o`06O8b/k7b<0_mK0000C`02o`L00ol02lb<o>clk<b<c8c<00?o
04g<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<k?c/o7D@UQnF4>clk?c/c8c<S<b<c8c<S<b<
c8c<S<b<c8c<S<b<c8c<S<b<c003o`0:c8c<S<c/o>c<S0Co1`000ol0001?0000C`04o`<01Ol0J7b<
[>b/k:b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<[>b/k:`@UQnF7gG/[>b/k:b<
O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<[>b/k7b<1_l300?oD@0004l03?l0JLb<
o>clk?c/c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?ae7iHOUQ1eo>clk?c/
o8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<c/o>clk<b<c00;oe40001?00_o06Z<O8b/
k:c/[>b/S7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alS7c/[>b/k:c/MA2F7iHOMA2/k:c/[>b/
k7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<[>b/k:c/[8al2omA0000C`0;o`1ZS<c/o>cl
k?c/o>clS<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8clk?c/o>clk11e7iHOUQ1eo>clk?c/o>cl
S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8clk?c/o>clk?b<c0_oD@0004<000=l00002@0;o`1[
S7c/[>b/k:c/[>b/k7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k7D@UQnF7gD@MNb/
k:c/[>b/k7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k:b<O8`02om@0000A0000h`0
000600co06g<S<c/o>clk?c/o>clk?c/c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>clMA1e
7iHOUQ1e47Glk?c/o>clk?b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<c/o>clk?c/o>clk?b<c8c<00co
20000h`000130000A0000hal000400go06n<O8alk:c/[>b/k:c/[>b/k:b<O8alS7b<O8alS7b<O8al
S7b<O>b/k:c/[>b/k:c/MA1e49HOUQnF47D@[>b/k:c/[>b/k:c/O8alS7b<O8alS7b<O8alS7b<O8b/
k:c/[>b/k:c/[>b/S7b<O8`03Ol50003O00004@000140004olb<c0oo077<S<b<c>clk?c/o>clk?c/
o>clk?c/o>c<S<b<c8c<S<b<c8clk?c/o>clk?c/o>clk11e49HOUQnF7gD@MA3/o>clk?c/o>clk?c/
o8c<S<b<c8c<S<b<c>clk?c/o>clk?c/o>clk?c/o8c<S<b<c00?o`03c8c<04H000140005ogb<O8`0
3Ol0LhalS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/47D@MAnF
7iHOUQ1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8`0
3Ol018alS?m60000A0002?o<S<b<c8c<1ol0NLb<c8c<S<b<o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clMA1e49HOUQnF7gD@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>c<S<b<c8c<S<`01ol01lb<c8c<S?l0AP0004@009KoO8alS7b<O8al
S7b<O8alS7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e
47DOUQnF7iH@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/O8al
S7b<O8alS7b<O8alS7b<O8alS?m60000A000UOo<S<b<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e49HOUQnF7gD@MA1e4>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<00;o
A@0003P000?o00001`03o`2DO8alS7b<O8alS7b<O8alS7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47DOUQnF7iHOMA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[8alS7b<O8alS7b<O8alS7b<O8alS0Co@`0003T000?o0000
1@04o`2Dc8c<S<b<c8c<S<b<c8c<S<b<c8c<k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk11e47D@MAnF7iHOUQnF47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?c/o8c<S<b<c8c<S<b<c8c<S<b<c8c<S0Go1`000ol0000h0000>@03o`<01_l0U7b<
O8alS7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>ae47D@MA2F7iHOUQnF7gD@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:b<O8alS7b<O8alS7b<O8alS7b<O8`7o`<00_lk0000>P0;o`2Dc8c<S<b<c8c<S<b<c8c<S<b<
c8c<k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clMA1e47D@MAnF7iHOUQnF
7gD@MA1e47Glk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>c<S<b<c8c<S<b<
c8c<S<b<c8c<S0co>`0003X02ol0U7b<O8alS7b<O8alS7b<O8alS7b<[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MAnF7iHOUQnF7iH@MA1e47D@MNb/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[8alS7b<O8alS7b<O8alS7b<O8`;oc`0000j00_o
09G<S<b<c8c<S<b<c8c<S<b<c8c<k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clMA1e47D@MA2F7iHOUQnF7iHOMA1e47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?b<c8c<S<b<c8c<S<b<c8c<S<b<c00:oc`0000j00[o09N<O8alS7b<O8alS7b<O8al
S7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e7iHOUQnF
7iHOUQ1e47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7b<O8al
S7b<O8alS7b<O8alS7b<00Wo?00003X02Ol0VLb<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@UQnF7iHOUQnF7iH@MA1e47D@MA1e
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?b<c8c<S<b<c8c<S<b<c8c<S<b<
c009oc/0000i00Wo09^<O8alS7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e49HOUQnF7iHOUQnF7gD@MA1e47D@MA1ek:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O8alS7b<O8alS008oc/0000^0003
MA0000P02?l0WLb<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk11e47D@MA1e47D@MAnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clS<b<c8c<S<b<c8c<S<b<c8c<S<`02?l90003400002h0
000_0003MA0000D02?l0XGb<O8alS7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA2/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/O8alS7b<O8alS7b<O8alS7b<O8al00So
1P000a1e000_0000<0000gD@o`0;o`2SS<b<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk11e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7gD@MA1e47D@
MA1e47D@k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o8c<S<b<c8c<S<b<c8c<
S<b<c8c<S00<o`0347D00300000`0005ogD@MH`01_l0ZGb<O8alS7b<O8alS7b<O8alS7b<O8alk:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e7iHOUQnF7iHO
UQnF7iH@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
O8alS7b<O8alS7b<O8alS7b<O8alS7`01ol00gD@M@0b0000<000__o<MA1ec8c<S<b<c8c<S<b<c8c<
S<b<c8c<S<b<c8c<k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@MA1e47D@
MA1e47D@MA2F7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c7D@MOlb0000<002o`2l
47D@MHalS7b<O8alS7b<O8alS7b<O8alS7b<[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[11e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[8alS7b<O8alS7b<O8alS7b<O8al
S7b<MA1eS?lb0000<002o`2jS11e47Glk<b<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iH@
MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
S<b<c8c<S<b<c8c<S<b<c8c<k?ae47D@0_lb0000<002o`2jS7`@MA1e4:c/O8alS7b<O8alS7b<[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e
49HOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O>b/47D@MA1l0_lb0000<002o`2jS<c/47D@
MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@
MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA3/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e48c<
0_lb0000<002o`2jS7b<MA1e47D@MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e
47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/MA1e47D@[8al0ola00009P000ol0000500Co0;Z<c8clMA1e47D@MA3/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@
MAnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/47D@MA1e47G<S<`5o`L000?o00009@0002L0
0_l300Ko0;Z<O8b/k7D@MA1e47D@MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e
47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k7D@MA1e47D@MNalS7`7o`<00_lX00009`0;o`2jS<b<c>`@MA1e47D@MA1eo>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHO
UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@MOc/c8c<2olY0000:00:o`2kS7b<O>b/47D@MA1e
47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e4:b<O8alS00:obT0
000X00Wo0;c<S<b<c>clMA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e
47D@MA1e47D@k?b<c8c<S0Wo:P0002P02Ol0_7b<O8alk:c/MA1e47D@MA1e47D@MA1e47G/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47G/[8alS7b<2OlZ0000:009o`2mc8c<S<c/o>clMA1e
47D@MA1e47D@MA1e47D@MA1e47D@k?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@k?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clS<b<c8c<00So
:P0002P02?l0_halS7b<O>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MNb/k:b<O8alS7b<00So:@0002L02?l0`Lb<c8c<S<c/o>clk11e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clS<b<c8c<S<`02?lX00009P08o`33
S7b<O8alS7c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
4:c/[>b/S7b<O8alS7b<00Oo:00002H01ol0aLb<c8c<S<b<c>clk?c/47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?b<c8c<S<b<c8c<00Oo9`0001h000><0000
0`07o`39O8alS7b<O8alS7c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e4:c/[>b/S7b<O8alS7b<O8al00Oo1@000h`0000M00007`000lb<o`08o`3;S<b<c8c<
S<b<c8c<k?c/o>clMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>cl
k?c/o8c<S<b<c8c<S<b<c8`02Ol00hc<000O00008000ghalS7b<O8alS7b<O8alS7b<O8alS7c/[>b/
k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/S7b<O8al
S7b<O8alS7b<O8alS7b<O8`08@0002000=j<c8c<S<b<c8c<S<b<c8c<S<b<c8c<k?c/o>clk11e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>c<S<b<c8c<S<b<c8c<
S<b<c8c<S<`R00008000g_mlS7b<O8alS7b<O8alS7b<O8alS:c/[>b/k:c/MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k7b<O8alS7b<O8alS7b<O8alS7b<O280
000P00;o0=b<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/c8c<S<b<c8c<S<b<c8c<S<b<c8co8P0002000_l0fXal
S7b<O8alS7b<O8alS7b<O8b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@[>b/k:c/[>alS7b<O8alS7b<O8alS7b<O8al0_lR00008002o`3JS<b<c8c<S<b<c8c<
S<b<c8c<S?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>cl
k?c/o>clk<b<c8c<S<b<c8c<S<b<c8c<S<`2ob80000P00?o0=UlS7b<O8alS7b<O8alS7b<O8b/k:c/
[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/S7b<
O8alS7b<O8alS7b<O8al00?o8@0001l01?l0f<b<c8c<S<b<c8c<S<b<c8c<k?c/o>clk?c/o7D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?b<c8c<S<b<c8c<S<b<
c8c<S0Co8@0001l01?l0f7b<O8alS7b<O8alS7b<O8alk:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MNb/k:c/[>b/k:c/O8alS7b<O8alS7b<O8alS0Go800001d0
1_l0f<b<c8c<S<b<c8c<S<b<c8clk?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e4>clk?c/o>clk?c/c8c<S<b<c8c<S<b<c8c<S0Oo7P0001P02ol0f7b<O8alS7b<
O8alS7b<O8b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MNb/k:c/[>b/k:c/O8alS7b<O8alS7b<O8alS0co6@0001T02_l0f<b<c8c<S<b<c8c<S<b<c8clk?c/
o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/
o8c<S<b<c8c<S<b<c8c<S0_o6P0001T02_l0f7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k:c/[>ae47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<
O8alS0[o6`0001X02Ol0f<b<c8c<S<b<c8c<S<b<o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/o>clS<b<c8c<S<b<c8c<S0[o6`0001X0
2Ol0fGb<O8alS7b<O8alS7c/[>b/k:c/[>b/k:c/[>ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>b/k7b<O8alS7b<O8alS7`02?lL00006P08o`3JS<b<c8c<
S<b<c8c<S?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1eo>clk?c/o>clk?c/o>clk?b<c8c<S<b<c8c<S<`8oa`0000J00So0=^<O8alS7b<O8alS7c/[>b/
k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/k:c/[>b/
k:c/[>b/k:c/[>alS7b<O8alS7b<O8`01olL00006P07o`3Mc8c<S<b<c8c<S<c/o>clk?c/o>clk?c/
o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/
o>clk?c/c8c<S<b<c8c<S<`01olK00006@07o`3OS7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/k:c/[>b/
k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[>b/k:c/[>b/
k:b<O8alS7b<O8alS006oa/0000I00Go0>><c8c<S<b<c8c<S?c/o>clk?c/o>clk?c/o>clk?c/o>`@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>cl
k?b<c8c<S<b<c8c<S005oaX0000H00Go0>ElS7b<O8alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k7b<O8alS7b<O8al00Go6@0001H01Ol0j/b<c8c<S<b<c8clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47Glk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?b<c8c<S<b<c8c<S0Co5`00018000?o[?l00_l0lGb<O8alS7b<O8b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[8alS7b<O8alS7`00ol00jco000B00005000mhcl
k<b<c8c<k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o8c<
S<c/o8`05@0001@00?KoO8b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/S7`F00005@00mOn<o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@k?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/c8co01H0000E00;o0?9lk:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>aloaL0000E00;o0?3<S?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o8`2oaL0
000E00?o0>n<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>alS002oaL0000E00?o0>j<c8clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o8c<1?lF00005004o`3^S7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7b<O0Co5P0001@01?l0kXc<S<c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MOc/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o8c<S<`4oaH0000C00Ko0>elS7b<[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e4:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[8alS7`01_lD00004@08o`3/
c8c<S<c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk<b<c8`9oa80
000?00[o0>alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:b<
O8alS0_o400000l02_l0k<b<c8c<S?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clMA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o8c<S<b<2ol@00004009o`3]O8alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>alS7b<O8al00Wo4@0001401ol0kXc<S<b<c8c<k?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clS<b<c8c<S<`8oa80000A00Oo0>j<O8alS7b<O>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e4:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[8alS7b<O8al1olC00004@07o`3^S<b<c8c<
S<c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47Glk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?b<c8c<S<b<c0Oo4`000140
1ol0khalS7b<O8alk:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/S7b<O8al
S7b<00Ko4`0001401_l0l<b<c8c<S<b<c8clk?c/o>clk?c/o>clk?c/o>clk?c/o>clMA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/o>clk?c/
o>clk?c/o8c<S<b<c8c<S0Ko4`0001401_l0lGb<O8alS7b<O8b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/O8alS7b<O8alS7`01OlC00004@05o`3cS<b<c8c<S<b<c8clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/c8c<S<b<c8c<S<b<00Go4P0001001Ol0mGb<
O8alS7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<
O8al00Co4P0001000ol0nLb<c8c<S<b<c8c<S<b<o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/
o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c003oa40000>00Co0?^<O8alS7b<O8alS7b<O8b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/k:c/O8alS7b<O8alS7b<O8alS004o`l0000;003o
c?ooolb<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/o>clk?c/
o>c<S<b<c8c<S<b<c8c<0006c?ooolb<0ol00l`0000:00003000oomlS7b<O8alS7b<O8alS7b<O8al
S:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O8alS0002?ml
S7b<O8al3@0000d00_l0olb<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?c/o>clk?c/o>clk?c/47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/
o>clk?c/o>clk?c/o>c<S<b<c8c<S<b<c8c<S<b<c001c06<0_l>00003P02o`3oS7b<O8alS7b<O8al
S7b<O8b/k:c/[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/O8alS7b<O8alS7b<O8al
S7b<00;o3`0000h00_l0oXc<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>cl
k?c/o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c8c<0_l@00003P03o`3mO8alS7b<O8alS7b<O8alS:c/
[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O8alS7b<O002oa00
000>00Co0?^<c8c<S<b<c8c<S<b<c8clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47Glk?c/o>clk?c/o>cl
k?c/c8c<S<b<c8c<S<b<c8c<S003oa00000>00Co0?Z<O8alS7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/
k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[8alS7b<O8alS7b<O8al1?l@00003P05o`3ic8c<S<b<
c8c<S<b<c>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/o8c<S<b<c8c<S<b<
c8c<00Co400000h01Ol0n7b<O8alS7b<O8alS7c/[>b/k:c/[>b/k:c/[>ae47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1ek:c/
[>b/k:c/[>b/k:b<O8alS7b<O8alS7b<1Ol@00003P06o`3gS<b<c8c<S<b<c8c<k?c/o>clk?c/o>cl
k11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@k?c/o>clk?c/o>clk<b<c8c<S<b<c8c<S005oa00000>00Ko0?J<O8al
S7b<O8alS:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/O8alS7b<O8al
S7`7o`l0000<00So0?J<c8c<S<b<c8c<S?c/o>clk?c/o>clk11e47D@MA1e47D@MA1e47D@MA1e47D@
MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e4>cl
k?c/o>clk?c/c8c<S<b<c8c<S<`9o`d0000800co0?J<O8alS7b<O8alS:c/[>b/k:c/[>b/47D@MA1e
47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e
47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[8alS7b<O8alS7`=o`T0000;00Wo0?J<c8c<S<b<c8c<
k?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@k?c/o>clk?c/o>c<S<b<c8c<S<`:o``0
000;00Wo0?J<O8alS7b<O8b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e4:c/[>b/
k:c/[>b/S7b<O8alS7`9o`d0000<00So0?J<c8c<S<b<c>clk?c/o>clk?c/47D@MA1e47D@MA1e47D@
MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@
MA1e47D@MA1e47D@MA3/o>clk?c/o>clk<b<c8c<S<`9o`d0000<00So0?N<O8alS7b<[>b/k:c/[>b/
k7D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MNb/k:c/[>b/k:b<O8alS7b<00Oo3P0000d0
1_l0n<b<c8c<S<c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@k?c/
o>clk?c/c8c<S<b<1ol>00003@06o`3hO8alS7b<[>b/k:c/[>b/47D@MA1e47D@MA1e47D@MAnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQme47D@MA1e47D@MA1e47D@[>b/k:c/[>b/S7b<O8`6o`l0000=00Ko0?W<S<b<c>clk?c/o>clMA1e
47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MOc/o>clk?c/c8c<S<`01Ol?0000
3@05o`3kS7b<O8b/k:c/[>b/47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e
47D@MA2/k:c/[>b/S7b<O8`01?l?00003@04o`3mc8c<S<c/o>clk?c/47D@MA1e47D@MA2F7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e4>clk?c/o>c<S<b<c003o`l0000=00?o0?n<O8al
k:c/[>b/47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e
4:c/[>b/k7b<O8`00ol>00003003o`3oc8clk?c/o7D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MOc/o>cl007<0H`3o`d0000;003oohalS:c/
[>ae47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOMA1e000:ohalS:c/[>ae40`00008003oS<c/o7D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF000@S<c/o7D@UQnF7iHO
UQnF7`T00009003oO8b/k7D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF000>O8b/k7D@UQnF7iHOUQl:00002`02o`3oc8c<k?c/
o7D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOMA1e47Gl0006c8c<k?c/0_l<00003003o`3oO8alS:c/[>b/47D@MA1e47D@UQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA2/k:c/[8al005l0H`3o`d0000=00?o
0?n<c8c<S?c/o>clk11e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@
MA1e47D@k?c/o>clS<b<c8`00ol>00003@04o`3mO8alS7c/[>b/k:c/[11e47D@MA1e47D@UQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@[>b/k:c/[>alS7b<O003o`l0000=00Co0?c<S<b<
c8clk?c/o>clk?ae47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1eo>clk?c/
o>clS<b<c8`4o`l0000=00Go0?^<O8alS7c/[>b/k:c/[>ae47D@MA1e47D@MA1e47DOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7gD@MA1e47D@MA1e47D@MNb/k:c/[>b/k7b<O8alS004o`l0000=00Ko0?W<S<b<c8clk?c/o>clk?c/
47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e4>clk?c/o>clk?b<c8c<S<`01Ol?0000
3@06o`3hO8alS7b<O>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1ek:c/
[>b/k:c/[>alS7b<O8`6o`l0000=00Ko0?S<S<b<c8c<k?c/o>clk?c/o>clMA1e47D@MA1e47D@MA1e
47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e
47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clS<b<c8c<S0Oo3P0000`02?l0mhalS7b<O8b/k:c/[>b/
k:c/[>b/47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[8alS7b<O8`01ol>0000
3008o`3fS<b<c8c<S<c/o>clk?c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>cl
k?c/o>c<S<b<c8c<2Ol=00002P0:o`3fS7b<O8alS7b<[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e
47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e
47D@MA1e47D@[>b/k:c/[>b/k:c/[8alS7b<O8al2ol;00002@0;o`3fS<b<c8c<S<b<c>clk?c/o>cl
k?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/c8c<S<b<c8c<3?l:00003@07o`3f
S7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e4:c/[>b/k:c/[>b/k:b<O8al
S7b<O8al2?l>00003@07o`3fS<b<c8c<S<b<c8clk?c/o>clk?c/o>clk11e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
k?c/o>clk?c/o>clk<b<c8c<S<b<c8c<1ol?00003P06o`3fS7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/
k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[>b/k7b<O8alS7b<O8al1ol?00003P06o`3gS<b<c8c<
S<b<c8c<k?c/o>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk<b<c8c<S<b<c8c<
S005oa00000>00Go0?QlS7b<O8alS7b<O8alk:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MNb/k:c/
[>b/k:c/[>b/S7b<O8alS7b<O8alS0Go400000h01Ol0nLb<c8c<S<b<c8c<S<c/o>clk?c/o>clk?c/
o>clMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47Glk?c/o>clk?c/o>clk?b<c8c<S<b<c8c<S<b<c004oa00000>00Co0?Z<O8al
S7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[8alS7b<O8al
S7b<O8al1?l@00003P04o`3kS<b<c8c<S<b<c8c<S<b<o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>cl
k?c/o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c8`00ol@00003P03o`3mO8alS7b<O8alS7b<O8alS:c/
[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O8alS7b<O002oa00
000>003oolb<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47Glk?c/o>clk?c/o>cl
k?c/o>c<S<b<c8c<S<b<c8c<S<b<0004olb<c0l0000=003oohalS7b<O8alS7b<O8alS7b<O8b/k:c/
[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/O8alS7b<O8alS7b<O8al0006ohalS7b<
3P0000`00?n<c8c<S<b<c8c<S<b<c8c<S<b<c8clk?c/o>clk?c/o>clk?c/o>clk11e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>cl
k?c/o>clk?c/c8c<S<b<c8c<S<b<c8`000R<c8c<S<b<c0d0000:0003S?oo00?o0?n<O8alS7b<O8al
S7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O8al
S7b<O8`01Ol00h`0000900003`04o`3ic8c<S<b<c8c<S<b<c8clk?c/o>clk?c/o>clk?c/o>clk?c/
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@k?c/
o>clk?c/o>clk?c/o>clk?c/c8c<S<b<c8c<S<b<c8c<00Co400000l01Ol0mhalS7b<O8alS7b<O8b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[>b/k:c/[>b/k:c/O8alS7b<O8alS7b<O8`01?lA0000
4005o`3ec8c<S<b<c8c<S<b<o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk<b<
c8c<S<b<c8c<S<`01OlA00004006o`3cS7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MNb/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/O8alS7b<O8alS7b<00Go4P0001401_l0lLb<c8c<S<b<c8clk?c/o>clk?c/
o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/c8c<S<b<c8c<S<`01_lB00004@06o`3`O8alS7b<
O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<1_lC0000
4@06o`3`c8c<S<b<c8c<S?c/o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clS<b<
c8c<S<b<1_lC00004@07o`3_S7b<O8alS7c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>ae47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:b<O8alS7b<O8`01_lC00004@07o`3^S<b<c8c<S<c/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47Glk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?b<c8c<S<b<c0Oo4`0001401ol0kXalS7b<O8alk:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/S7b<O8alS7`8oa80000@00So0>j<c8c<S<b<c>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o8c<S<b<c8c<2OlA00003`0:o`3]
O8alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8al00[o
400001002Ol0k<b<c8c<S?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clMA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o8c<S<b<2_lA00004P07o`3/O8alS7c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/S7b<O8`8oa<0000D00Go0>c<S<b<c>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/c8c<S0Ko5@0001@01Ol0kGb<O8b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/S7b<O004oaH0000D00Co0>j<c8c<k?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47Glk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?b<c8c<1?lF00005004o`3^S7b<O>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7b<O0Co5P0001D0
0ol0khc<S?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clMA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
S<b<00?o5P0001D00_l0l7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>alS0;o5`0001D00_l0l/b<o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clS<co5`0001D00?CoS7c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7b<5`0001D00?G<k?c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/c00F0000
4`00nGc/[8alS7b<O8b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k7b<O8alS:c/O00D00004P000ncoo`03o`3_S<b<c8c<S<b<c>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk<b<c8c<S<b<c8`01Ol00n`0000A00005`05o`3XS7b<O8alS7b<O>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O0Co600001P01_l0hhc<S<b<c8c<
S<b<o>clk?c/o>clk?c/o>clk?c/o>clk11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47Glk?c/o>clk?c/o>clk?c/o>clk?c/o8c<S<b<c8c<S<b<00Ko6@0001P01ol0hGb<O8alS7b<
O8alk:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e4:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O006oaX0000I00Oo0=n<c8c<S<b<c8c<
S<c/o>clk?c/o>clk?c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MOc/o>clk?c/o>clk?c/o>clk?c/c8c<S<b<c8c<S<b<00Oo6P0001T02?l0gGb<O8alS7b<O8alS:c/
[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/k:c/
[>b/k:c/[>b/k:c/[>b/S7b<O8alS7b<O8al00Oo6`0001X02?l0fhc<S<b<c8c<S<b<c>clk?c/o>cl
k?c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>cl
k?c/o>clk<b<c8c<S<b<c8c<S008oa/0000J00So0=Z<O8alS7b<O8alS7b<[>b/k:c/[>b/k:c/[>b/
k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[>b/k:c/[8al
S7b<O8alS7b<O0So700001X02?l0fXc<S<b<c8c<S<b<c8c<k?c/o>clk?c/o>clk?c/47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/o>c<S<b<c8c<S<b<c8c<
2?lL00006P09o`3IO8alS7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k:c/[>b/k:b<O8alS7b<O8alS7b<O008oa`0000J00Wo
0=S<S<b<c8c<S<b<c8c<S<c/o>clk?c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MOc/o>clk?c/o>clk?c/c8c<S<b<c8c<S<b<c8`:oa/0000I00[o0=QlS7b<O8alS7b<
O8alS7c/[>b/k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/
[>b/k:c/[>b/k:b<O8alS7b<O8alS7b<O8`;oaX0000G00co0=S<S<b<c8c<S<b<c8c<S<b<o>clk?c/
o>clk?ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?b<
c8c<S<b<c8c<S<b<c8`=oaP0000N00Go0=QlS7b<O8alS7b<O8alS7b<[>b/k:c/[>b/k:`@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/k7b<O8alS7b<O8alS7b<
O8`6oal0000N00Go0=S<S<b<c8c<S<b<c8c<S<b<c>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c8`5ob00000O00Co
0=QlS7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47G/[>b/k:c/[>b/S7b<O8alS7b<O8alS7b<O8`5ob00000O00Co0=S<S<b<c8c<S<b<
c8c<S<b<c>clk?c/o>clk?ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA3/
o>clk?c/o>clS<b<c8c<S<b<c8c<S<b<c8`4ob40000P00?o0=UlS7b<O8alS7b<O8alS7b<O8b/k:c/
[>b/k:`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47G/[>b/k:c/[>b/S7b<
O8alS7b<O8alS7b<O8al00?o8@0002000_l0fXc<S<b<c8c<S<b<c8c<S<b<c8clk?c/o>clk?ae47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>c<S<b<c8c<S<b<c8c<
S<b<c8c<0_lR00008002o`3JS7b<O8alS7b<O8alS7b<O8alS:c/[>b/k:c/[11e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF
7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/k:c/[>b/k7b<O8alS7b<O8alS7b<O8alS7`2ob80
000P00;o0=b<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/c8c<S<b<c8c<S<b<c8c<S<b<c8co8P0002000=koO8al
S7b<O8alS7b<O8alS7b<O8alk:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF
7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@[>b/k:c/[>alS7b<O8alS7b<O8alS7b<O8alS7`R00008000ghc<S<b<c8c<S<b<c8c<
S<b<c8c<S<c/o>clk?c/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
k?c/o>clS<b<c8c<S<b<c8c<S<b<c8c<S<b<c8`08@0001l000=lool02Ol0bGb<O8alS7b<O8alk:c/
[>b/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MNb/k:c/[8alS7b<
O8alS7b<O00;o`03O00001h0000U00Oo0<N<c8c<S<b<c8c<k?c/o>clMA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4>clk?c/o8c<S<b<c8c<S<b<00Oo9P0002D02?l0aGb<
O8alS7b<O>b/k:c/[11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
[>b/k:b<O8alS7b<O8al00Oo9`0002H02?l0`hc<S<b<c8c<k?c/o>`@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e7iHOUQnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47Glk?c/o8c<S<b<c8c<S008obL0000W00So0<5lS7b<
O8alk:c/[>ae47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@
MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA2/k:c/
[8alS7b<O8al00So:00002L02?l0`<b<c8c<S<c/o>clk11e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF
7iHOUQnF7iHOUQme47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA3/o>clS<b<c8c<S0So:@0002P02?l0_halS7b<O>b/k:`@MA1e
47D@MA1e47D@MA1e47D@MA1e4:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@MA1e47D@MA1e4:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e47D@MA1e47D@MA2/k:b<O8alS7b<00So
:@0002P02Ol0_Lb<c8c<k?c/47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o7D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e47DOUQnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e
47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MOc/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e
47D@MA1e47D@MOc/o8c<S<b<c008obX0000X00Wo0;alS7b<O>b/k7D@MA1e47D@MA1e47G/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/47D@MA1e47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHO
UQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1e47D@MA1e4:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>ae47D@MA1e47D@MA1ek:b<O8alS0Wo:P0002P02Ol0_<b<c8c<k?ae
47D@MA1e47D@MOc/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e
47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e47D@MA1e47D@MA1e
47D@k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1e47D@MA3/o8c<S<b<
2OlZ0000:00:o`2kS7b<O>b/47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/47D@MA1e47D@MA1e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF7iHOUQnF7iH@MA1e
47D@MA1e47D@MA1e47D@MA1e4:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>ae47D@MA1e4:b<O8alS00:obT0000W0003o`0000<01Ol0^Xc<S<c/47D@MA1e4>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clMA1e47D@MA1e47D@MA1e47D@
MA1e7iHOUQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47D@MA1eo>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@MA1e47D@k<b<c0Ko1@000ol0000V0000
;`03o`2jS7b<[11e47D@MA2/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/MA1e47D@MA1e47D@MA1e47D@MA2F7iHOUQnF7iHOUQnF7iHOUQnF7gD@MA1e47D@MA1e
47D@MA1e47D@MNb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:`@MA1e47G/O8al1?l`0000;`03o`2jS<b<o7D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHO
UQnF7iHOUQ1e47D@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA1eo8c<0ola0000<002o`2jS7c/MA1e4:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MA1e
47D@MA1e7iHOUQnF7iHOUQnF7iHOUQnF47D@MA1e47D@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/47D@[8al0ola0000<002o`2j
S<c/47D@k?b<c8c<S<b<c8c<S<b<c>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?ae47D@MA1e47D@MA1e47D@UQnF7iHOUQnF7iHOUQnF7iHOMA1e47D@MA1e47D@MA1e47Gl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o8c<S<b<c8c<S<b<c8cl
k11e48c<0_lb0000<002o`2jS7`@MNalS7b<O8alS7b<O8alS7b<O8alS7c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQnF
47D@MA1e47D@MA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>al
S7b<O8alS7b<O8alS7b<O8alS7c/MA1l0_lb0000<002o`2lS11ec8c<S<b<c8c<S<b<c8c<S<b<c8c<
S<b<c8clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>`@MA1e47D@MA1e47D@
MAnF7iHOUQnF7iHOUQnF7iH@MA1e47D@MA1e47D@MA3/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c7D@S?lb0000<000__ml47F<O8al
S7b<O8alS7b<O8alS7b<O8alS7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA1e4:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/S7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8ae
4?lb0000<0001?l@S<`8o`2WS<b<c8c<S<b<c8c<S<b<c8c<S<b<c>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/47D@MA1e47D@MA1e49HOUQnF7iHOUQnF7iHOUQ1e47D@MA1e47D@
MA3/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c8c<
S<b<c8`02Ol00hco000a0000<00?o`2QO8alS7b<O8alS7b<O8alS7b<O8b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[11e47D@MA1e47D@MAnF7iHOUQnF7iHOUQnF47D@MA1e47D@
MA1e4:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/S7b<O8alS7b<O8alS7b<
O8alS7`03_lb0000>008o`2OS<b<c8c<S<b<c8c<S<b<c8c<S<c/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk11e47D@MA1e47D@UQnF7iHOUQnF7iHOUQme47D@MA1e47D@MA3/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c8c<S<b<00So
>@0003P02Ol0WGb<O8alS7b<O8alS7b<O8alS7b<[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:`@MA1e47D@MA1e49HOUQnF7iHOUQnF7iH@MA1e47D@MA1e4:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/S7b<O8alS7b<O8alS7b<O8alS7`02?lj0000>@09o`2K
S<b<c8c<S<b<c8c<S<b<c8c<S<c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
MA1e47D@MA1e47DOUQnF7iHOUQnF7iH@MA1e47D@MA1e4>clk?c/o>clk?c/o>clk?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/c8c<S<b<c8c<S<b<c8c<S<b<c8`02Olj0000>@0:o`2IO8alS7b<O8alS7b<
O8alS7b<O>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/MA1e47D@MA1e49HO
UQnF7iHOUQnF7gD@MA1e47D@MA1ek:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[8alS7b<O8alS7b<O8alS7b<O8al00Wo>`0003X02Ol0V<b<c8c<S<b<c8c<S<b<c8c<S<b<o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e47D@UQnF7iHOUQnF7iH@MA1e
47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?b<c8c<S<b<c8c<S<b<
c8c<S<b<2_lk0000>P0:o`2GS7b<O8alS7b<O8alS7b<O8alS7c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k7D@MA1e47D@MAnF7iHOUQnF7iH@MA1e47D@MA1ek:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>alS7b<O8alS7b<O8alS7b<O8alS009oc`0000j00_o
09G<S<b<c8c<S<b<c8c<S<b<c8c<k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clMA1e47D@MA2F7iHOUQnF7iHOMA1e47D@MA1eo>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?b<c8c<S<b<c8c<S<b<c8c<S<b<c00:oc`0000j00_o09AlS7b<O8alS7b<O8alS7b<
O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k7D@MA1e47DOUQnF7iHO
UQnF47D@MA1e47G/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:b<O8alS7b<
O8alS7b<O8alS7b<2oll0000>P000ol0000300Go09C<S<b<c8c<S<b<c8c<S<b<c8c<S<c/o>clk?c/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?ae47D@MA1e7iHOUQnF7iHOMA1e47D@MOc/
o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk<b<c8c<S<b<c8c<S<b<c8c<S<b<
1_l50003o`0003T0000i0003o`0000D01?l0U7b<O8alS7b<O8alS7b<O8alS7b<O>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>ae47D@MA2F7iHOUQnF7gD@MA1e47G/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:b<O8alS7b<O8alS7b<O8alS7b<O8`5od80
001300;o09C<S<b<c8c<S<b<c8c<S<b<c8c<S<c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?c/47D@MA1e7iHOUQnF7iH@MA1e47Glk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/
o>clk?c/o>clk?c/o>clS<b<c8c<S<b<c8c<S<b<c8c<S<b<0om40000@`02o`2DO8alS7b<O8alS7b<
O8alS7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:`@MA1e47DO
UQnF7iHOMA1e47D@[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[8alS7b<
O8alS7b<O8alS7b<O8alS0;oA@0004@009Goc8c<S<b<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/47D@MA2F7iHOUQme47D@MA3/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/c8c<S<b<c8c<S<b<c8c<S<b<c8c<S002odD0
00140007ogb<O8alS009o`1gS7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/MA1e47DOUQnF7iH@MA1e4:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/O8alS7b<O8`02Ol01XalS7b<odH000140004olb<c0ko07><c8c<S?c/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o7D@MA2F7iHOUQme47D@MOc/o>clk?c/o>cl
k?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/o>clk?c/c8c<S<b<00ko00?<S?l0AP0004@000?oO8`0
4?l0LGb<O8alk:c/[>b/k:c/[>b/k:c/[>b/S7b<O8alS7b<O8alS7c/[>b/k:c/[>b/k:`@MA1e7iHO
UQnF47D@MNb/k:c/[>b/k:c/[>alS7b<O8alS7b<O8alS:c/[>b/k:c/[>b/k:c/[>b/k7b<O8al013o
00><o`00A@0004@000?oc0001@0<o`1_S<b<c>clk?c/o>clk?c/o>c<S<b<c8c<S<b<c8c<S<b<c8c<
S<b<o>clk?c/o>clk11e47DOUQnF7gD@MA3/o>clk?c/o>clS<b<c8c<S<b<c8c<S<b<c8c<S<b<c>cl
k?c/o>clk?c/o8c<S<b<00co1P000l`000140000A0000h`0000700[o06j<O8alk:c/[>b/k:c/[>b/
S7b<O8alS7b<O8alS7b<O8alS7b<O8alS7c/[>b/k:c/[11e49HOUQme47D@[>b/k:c/[>alS7b<O8al
S7b<O8alS7b<O8alS7b<O8alS:c/[>b/k:c/[>b/S7b<O0_oC`0004h02ol0KLb<c>clk?c/o>clk?b<
c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?ae47DOUQnF47D@k?c/o>clk?b<c8c<S<b<
c8c<S<b<c8c<S<b<c8c<S<b<c8c<S?c/o>clk?c/o8c<S<`02_m@0000C`0;o`1[S7c/[>b/k:c/[>al
S7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alk:c/[>b/k7D@UQnF7gD@MNb/k:c/[>alS7b<O8al
S7b<O8alS7b<O8alS7b<O8alS7b<O8alk:c/[>b/k:b<O8`02om@0000C`0;o`1ZS<b<o>clk?c/c8c<
S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S?c/o>clk11e7iHOUQ1eo>clk?c/o8c<S<b<c8c<
S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<c/o>clk?b<c0_oD@0004l03?l0JGb<[>b/k:b<O8alS7b<
O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alS7c/[>b/k7D@UQnF7gD@[>b/k:c/O8alS7b<O8alS7b<
O8alS7b<O8alS7b<O8alS7b<O8alS7b<[>b/k7b<O00;oe40001?00?o1@04o`1Xc8clk?c/c8c<S<b<
c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8clk?c/o7DOUQnF47Glk?c/o8c<S<b<c8c<S<b<
c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<k?c/c8`5o`D00_mA0000C`02o`P00_l02Wb<[>b/S7b<
O8`5o`1;S7b<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O8alk:c/[11e7iHOMNb/k:c/O8alS7b<O8al
S7b<O8alS7b<O8alS7b<O8alS7b<00Go00V<O8alS:c/O8`00ol80003o`0004l0001?0003o`0000P0
00Soc8clk<b<c0co04><c8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8clk?ae49HOMA3/o>clS<b<c8c<
S<b<c8c<S<b<c8c<S<b<c8c<S<b<00go00F<c>c<S002o`T000?o0000C`0004l000?o00002002o`04
S:b<O13o03n<O8alS7b<O8alS7b<O8alS7b<O8alS7b<O>b/k7DOUQ1ek:c/O8alS7b<O8alS7b<O8al
S7b<O8alS7b<O8`04?l01Gc/O8co05`0001K0004ohclS1;o03g<S<b<c8c<S<b<c8c<S<b<c8c<S<b<
c8c<S?c/49HOMOc/o8c<S<b<c8c<S<b<c8c<S<b<c8c<S<b<c8c<01;o00B<o?ooG00005/000?ok7`0
1@0?o`0kS7b<O8alS7b<O8alS7b<O8alS7b<O8alS:c/MAnF4:c/O8alS7b<O8alS7b<O8alS7b<O8al
S7b<O8`03ol50003[?l005`0001K0003on`000L03Ol038c<S<b<c8c<S<b<c0So01><c8c<S<c/49HO
MOc/c8c<S<b<00So00_<S<b<c8c<S<b<c00=o`P000?<o`00G00005/000?oS000200=o`09O8alS7b<
O8al00go00elS7c/[1nF4:b<O8al00go00UlS7b<O8alS7`03Ol90003k00005/0001K0003o00000P0
3_l01Xc<S<b<c13o00^<c8clUQo/o8c<S00@o`06c8c<S<b<3OmX0000I`04o`H00ol01HalS7b<01;o
00UlS:`OU^alS7`04_l018alS7`4o`H01?mX0000I`03o`T000GoS<b<c00Do`07S?bF7nc<S00Co`04
S<b<c0;o2@02ofT0001X0003o`0000P00_l00gb<O00Eo`05O1nFk7`05Ol017b<O?l;0003o`0006L0
001d0004olb<o`P03Ol01<ae7h`>o`P000CoS?ooM@0007@000?oO?l02@06o`H000GoO11eS002o`H0
1Ol:0003S?l007D0001d0003ol`000X00ol90005on`@S?l02@03o`/000?o0000M00007@000?o0000
2P02o`/000?/[?l02P02o``000=l0000M00007@000><00002P02o`/000><o0002`000ol000210000
P@000ol0000:0003S7`000/000?o0000P@0008l000?<00002P000ol000210000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.05001, -1.05001, 0.00731715, 
  0.00731715}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1152}, {0, 850}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 740},
WindowMargins->{{12, Automatic}, {Automatic, 16}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"XAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000003Dl9@?o=olP=P@Ug0fL5N`?P0080004/0B`000000]X2:001
0000I00000000`<30?l00BL?00400@=5TK0000000000060<01T1T000000@0000
00000000007oo@=5Ud3oo@00605@DTiD\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 99, 2, 136, "Title"],

Cell[CellGroupData[{
Cell[1833, 55, 92, 2, 52, "Subtitle"],

Cell[CellGroupData[{
Cell[1950, 61, 87, 1, 26, "Input"],
Cell[2040, 64, 70, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2147, 70, 58, 1, 26, "Input"],
Cell[2208, 73, 265, 4, 70, "Message"]
}, Open  ]],
Cell[2488, 80, 187, 8, 96, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2712, 93, 95, 2, 41, "Subtitle"],
Cell[2810, 97, 271, 7, 82, "Input"],

Cell[CellGroupData[{
Cell[3106, 108, 237, 7, 96, "Input"],
Cell[3346, 117, 203, 5, 68, "Input"],

Cell[CellGroupData[{
Cell[3574, 126, 89, 1, 26, "Input"],
Cell[3666, 129, 19102, 337, 282, 2966, 132, "GraphicsData", 
"PostScript", "Graphics"],
Cell[22771, 468, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[22962, 478, 78, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[23065, 484, 383, 11, 152, "Input"],

Cell[CellGroupData[{
Cell[23473, 499, 238, 7, 82, "Input"],
Cell[23714, 508, 13161, 285, 290, 2209, 144, "GraphicsData", 
"PostScript", "Graphics"],
Cell[36878, 795, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[37069, 805, 91, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[37185, 811, 327, 9, 110, "Input"],
Cell[37515, 822, 30277, 795, 202, 7501, 508, "GraphicsData", 
"PostScript", "Graphics"],
Cell[67795, 1619, 135, 3, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[67979, 1628, 91, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[68095, 1634, 275, 9, 110, "Input"],
Cell[68373, 1645, 11928, 204, 290, 907, 62, "GraphicsData", 
"PostScript", "Graphics"],
Cell[80304, 1851, 130, 3, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[80483, 1860, 101, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[80609, 1866, 115, 4, 40, "Input"],
Cell[80727, 1872, 159, 6, 68, "Input"],
Cell[80889, 1880, 159, 6, 68, "Input"],
Cell[81051, 1888, 206, 5, 68, "Input"],

Cell[CellGroupData[{
Cell[81282, 1897, 266, 9, 110, "Input"],
Cell[81551, 1908, 31461, 821, 290, 9084, 539, "GraphicsData", 
"PostScript", "Graphics"],
Cell[113015, 2731, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[113206, 2741, 116, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[113347, 2747, 121, 4, 40, "Input"],

Cell[CellGroupData[{
Cell[113493, 2755, 129, 4, 40, "Input"],
Cell[113625, 2761, 47286, 891, 290, 5696, 372, "GraphicsData", 
"PostScript", "Graphics"],
Cell[160914, 3654, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[161105, 3664, 91, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[161221, 3670, 129, 4, 40, "Input"],

Cell[CellGroupData[{
Cell[161375, 3678, 82, 1, 26, "Input"],
Cell[161460, 3681, 37, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[161534, 3687, 135, 5, 54, "Input"],
Cell[161672, 3694, 171153, 9247, 290, 130530, 8739, "GraphicsData", 
"PostScript", "Graphics"],
Cell[332828, 12943, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[333019, 12953, 98, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[333142, 12959, 134, 4, 40, "Input"],
Cell[333279, 12965, 36, 1, 26, "Output"],
Cell[333318, 12968, 110, 4, 40, "Input"],

Cell[CellGroupData[{
Cell[333453, 12976, 143, 4, 40, "Input"],
Cell[333599, 12982, 66480, 1800, 290, 19430, 1213, "GraphicsData", 
"PostScript", "Graphics"],
Cell[400082, 14784, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[400273, 14794, 112, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[400410, 14800, 203, 7, 82, "Input"],
Cell[400616, 14809, 36, 1, 26, "Output"],

Cell[CellGroupData[{
Cell[400677, 14814, 305, 11, 138, "Input"],
Cell[400985, 14827, 68765, 3983, 296, 59319, 3862, "GraphicsData", 
"PostScript", "Graphics"],
Cell[469753, 18812, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[469944, 18822, 98, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[470067, 18828, 136, 4, 40, "Input"],
Cell[470206, 18834, 36, 1, 26, "Output"],
Cell[470245, 18837, 72, 1, 26, "Input"],

Cell[CellGroupData[{
Cell[470342, 18842, 116, 4, 40, "Input"],
Cell[470461, 18848, 69421, 2071, 290, 24746, 1513, "GraphicsData", 
"PostScript", "Graphics"],
Cell[539885, 20921, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[540076, 20931, 85, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[540186, 20937, 116, 4, 40, "Input"],
Cell[540305, 20943, 69, 1, 26, "Input"],

Cell[CellGroupData[{
Cell[540399, 20948, 125, 4, 40, "Input"],
Cell[540527, 20954, 84944, 3869, 288, 60044, 3556, "GraphicsData", 
"PostScript", "Graphics"],
Cell[625474, 24825, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[625665, 24835, 87, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[625777, 24841, 201, 7, 82, "Input"],
Cell[625981, 24850, 404, 10, 138, "Input"],

Cell[CellGroupData[{
Cell[626410, 24864, 196, 6, 82, "Input"],
Cell[626609, 24872, 119041, 5852, 285, 95104, 5550, "GraphicsData", 
"PostScript", "Graphics"],
Cell[745653, 30726, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[745844, 30736, 110, 2, 41, "Subtitle"],

Cell[CellGroupData[{
Cell[745979, 30742, 91, 1, 26, "Input"],

Cell[CellGroupData[{
Cell[746095, 30747, 281, 10, 124, "Input"],
Cell[746379, 30759, 97857, 2379, 296, 22493, 1444, "GraphicsData", 
"PostScript", "Graphics"],
Cell[844239, 33140, 130, 3, 26, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

