C
C      ________________________________________________________
C     |                                                        |
C     |             INVERT A SYMMETRIC BAND MATRIX             |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --HFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         V     --SYMMETRIC INVERSE MATRIX STORED IN COM-|
C     |                 PRESSED MODE                           |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE HVERT(V,A)
      REAL A(1),V(1),T
      INTEGER E,F,G,H,I,J,K,L,M,N,O,P
      T = A(1)
      IF ( ABS(T) .EQ. 1232 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH HFACT BEFORE INVERTING'
      STOP
10    IF ( T .GT. 0. ) GOTO 20
      WRITE(6,*) 'ERROR: MATRIX HAS NO INVERSE'
      STOP
20    N = A(2)
      H = A(4)
      E = H + 1
      F = 4 - H - H
      P = 0
      DO 90 G = 1,N
           O = P + 1
           P = O + N - G
           J = F - O + G*E
           K = O
           DO 30 I = O,P
30              V(I) = 0.
           V(O) = 1.
           IF ( H .GT. 0 ) GOTO 40
C     ------------------------
C     |*** DIAGONAL MATRIX***|
C     ------------------------
           V(O) = V(O)/A(4+G)
           GOTO 90
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
40         J = J + H
           IF ( K .EQ. P ) GOTO 60
           T = V(K)/A(J+K)
           L = MIN0(P,K+H)
           K = K + 1
           IF ( T .EQ. 0. ) GOTO 40
           DO 50 I = K,L
50              V(I) = V(I) - T*A(I+J)
           GOTO 40
C     -----------------------------------
C     |*** BACK SUBSTITUTION BY ROWS ***|
C     -----------------------------------
60         V(P) = V(P)/A(J+K)
70         IF ( K .EQ. O ) GOTO 90
           J = J - H
           M = K
           K = K - 1
           L = MIN0(P,K+H)
           T = V(K)
           DO 80 I = M,L
80              T = T - V(I)*A(I+J)
           V(K) = T/A(J+K)
           GOTO 70
90    CONTINUE
      RETURN
      END
