C      ________________________________________________________
C     |                                                        |
C     |COMPUTE DETERMINANT OF A FACTORED SYMMETRIC BAND MATRIX |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --HFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         HDET,E--DETERMINANT IS HDET*10.**E (E INTEGER) |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,ALOG10,DLOG10                |
C     |________________________________________________________|
C
      FUNCTION HDET(E,A)
      REAL A(1),D,F,G
      DOUBLE PRECISION C
      INTEGER E,H,I,K,L,M,N
      D = A(1)
      IF ( ABS(D) .EQ. 1232 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH HFACT BEFORE',
     1'COMPUTING DETERMINANT'
      STOP
10    E = 0
      IF ( D .LT. 0. ) GOTO 70
      D = 1.
      F = 2.**64
      G = 1./F
      H = 64
      N = A(2)
      M = A(4) + 1
      K = 5
      L = 4 + M*N
      DO 40 I = K,L,M
           D = D*A(I)
20         IF ( ABS(D) .LT. F ) GOTO 30
           E = E + H
           D = D*G
           GOTO 20
30         IF ( ABS(D) .GT. G ) GOTO 40
           E = E - H
           D = D*F
           GOTO 30
40    CONTINUE
      IF ( E .NE. 0 ) GOTO 50
      HDET = D
      RETURN
50    IF ( D .EQ. 0. ) GOTO 80
      C = ALOG10(ABS(D)) + E*DLOG10(2.D0)
      E = C
      C = C - E
      IF ( C .LE. 0.D0 ) GOTO 60
      C = C - 1
      E = E + 1
60    F = 10.**C
      IF ( D .LT. 0. ) F = -F
      HDET = F
      RETURN
70    HDET = 0.
      RETURN
80    E = 0
      GOTO 70
      END
