C
C      ________________________________________________________
C     |                                                        |
C     |          DIAGONALIZE A REAL HESSENBERG MATRIX          |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF COMPLEX     |
C     |                 ARRAY V                                |
C     |                                                        |
C     |         A     --COEFFICIENTS OF HESSENBERG MATRIX      |
C     |                 PACKED AT START OF REAL ARRAY          |
C     |                 (LENGTH AT LEAST (N+1)(N+2) - 4)       |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |         W     --REAL WORK ARRAY WITH AT LEAST          |
C     |                 4N ELEMENTS                            |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |         V     --COMPLEX ARRAY OF EIGENVECTORS          |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,AIMAG,CONJG,REAL             |
C     |    PACKAGE FUNCTIONS: MAG                              |
C     |    PACKAGE SUBROUTINES: DAG                            |
C     |________________________________________________________|
C
      SUBROUTINE EDIAG(E,V,LV,A,N,W)
      INTEGER I,J,K,L,LV,M,N
      COMPLEX E(1),V(LV,1),Z
      REAL A(1),W(1),MAG,R,S,T
      J = (N+1)*(N+2) - 4
      I = J/2
10    A(J-1) = A(I)
      A(J) = 0.
      I = I - 1
      J = J - 2
      IF ( I .GT. 0 ) GOTO 10
      DO 30 J = 1,N
           DO 20 I = 1,N
20              V(I,J) = 0.
30         V(J,J) = 1.
      M = N + 1
      L = M + N
      CALL DAG(E,V,LV,A,N,W,W(M),W(L))
      J = M
40    J = J - 1
      IF ( J .LE. 1 ) GOTO 90
      Z = CONJG(E(J))
      R = ABS(AIMAG(Z))
      S = R
      L = J - 1
      DO 50 I = 1,L
           T = MAG(E(I)-Z)
           IF ( T .GE. S ) GOTO 50
           K = I
           S = T
50    CONTINUE
      IF ( R .GT. S ) GOTO 70
      E(J) = REAL(Z)
      DO 60 I = 1,N
60         V(I,J) = REAL(V(I,J))
      GOTO 40
70    E(K) = E(L)
      E(L) = Z
      DO 80 I = 1,N
           V(I,K) = V(I,L)
80         V(I,L) = CONJG(V(I,J))
      J = L
      GOTO 40
90    IF ( J .LT. 1 ) RETURN
      E(J) = REAL(E(J))
      DO 100 I = 1,N
100        V(I,J) = REAL(V(I,J))
      RETURN
      END
