C      ________________________________________________________
C     |                                                        |
C     |       MULTIPLY A GENERAL REAL MATRIX BY A VECTOR       |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --VECTOR                                 |
C     |                                                        |
C     |         A     --ARRAY CONTAINING COEFFICIENT MATRIX    |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         M     --NUMBER OF ROWS IN COEFFICIENT MATRIX   |
C     |                                                        |
C     |         N     --NUMBER OF COLUMNS IN COEFF. MATRIX     |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         Y     --PRODUCT BETWEEN A AND X                |
C     |________________________________________________________|
C
      SUBROUTINE MULT(Y,X,A,LA,M,N)
      INTEGER I,J,LA,M,N
      REAL A(LA,1),X(1),Y(1),T
      DO 10 I = 1,M
10         Y(I) = 0.
      DO 20 J = 1,N
           T = X(J)
           DO 20 I = 1,M
20              Y(I) = Y(I) + A(I,J)*T
      RETURN
      END
