C      ________________________________________________________
C     |                                                        |
C     |    SOLVE THE TRANSPOSE OF A GENERAL FACTORED SYSTEM    |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --KFACT'S OUTPUT                         |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE KTRANS(X,A,B)
      REAL A(1),B(1),X(1),T
      INTEGER I,J,K,L,M,N
      T = A(1)
      IF ( ABS(T) .EQ. 1236 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH KFACT BEFORE SOLVING'
      STOP
10    N = A(2)
      M = N + 1
      IF ( T .LT. 0. ) GOTO 110
      DO 20 I = 1,N
20         X(I) = B(I)
      IF ( N .EQ. 1 ) GOTO 40
      J = 3 + M*N
      K = N - 1
C     --------------------------
C     |*** PIVOT RIGHT SIDE ***|
C     --------------------------
      DO 30 I = 1,K
           L = A(I+J)
           T = X(I)
           X(I) = X(L)
30         X(L) = T
40    T = 0.
      J = 4
      K = 1
C     -------------------------
C     |*** SKIP OVER ZEROS ***|
C     -------------------------
50    IF ( X(K) .NE. 0. ) GOTO 60
      K = K + 1
      J = J + M
      IF ( K .LE. N ) GOTO 50
      RETURN
C     ---------------------------
C     |*** FORE SUBSTITUTION ***|
C     ---------------------------
60    X(K) = (X(K)-T)/A(J+K)
70    IF ( K .EQ. N ) GOTO 90
      T = 0.
      J = J + M
      DO 80 I = 1,K
80         T = T + A(I+J)*X(I)
      K = K + 1
      GOTO 60
C     ---------------------------
C     |*** BACK SUBSTITUTION ***|
C     ---------------------------
90    IF ( K .EQ. 1 ) RETURN
      J = J - M
      T = X(K-1)
      DO 100 I = K,N
100        T = T - X(I)*A(I+J)
      K = K - 1
      I = A(J)
      X(K) = X(I)
      X(I) = T
      GOTO 90
C     -----------------------------
C     |*** COMPUTE NULL VECTOR ***|
C     -----------------------------
110   I = 5 + N + M*N
      L = M
120   I = I - M - 1
      L = L - 1
      IF ( A(I) .NE. 0. ) GOTO 120
      J = J + M*(L-K)
      K = L
      DO 130 I = 1,N
130        X(I) = 0.
      X(K) = 1.
      GOTO 70
      END
