/*******************************************************************************
  order_maximal.c 
********************************************************************************/

                                                             
#include <stdio.h>
#include "kant.h" 
#include "anf.h" 
#include "faclst.e" 
#include "faclst.h"

order
order_maximal WITH_1_ARG (order , start)
/*******************************************************************************

Description:
                                                             
   Compute the ring of alg. integers in a given alg. number field. The 
   computation is done by the round - 2 alg. developed by Zassenhaus.
                                    
   Some modular improvements have been added.                  
  

Calling sequence:
                                                           
          order start     :  The order start has to be an order in the ring of 
                             integers of a number field. Normally start will 
                             will be the equation order of the defining 
                             polynomial.     


          order solution  :  the p-max. overorder of start.                   

      solution = order_maximal (start);                       
                                                             
                            
History:                                 
    
        92-09-22 JS    bug when faclst empty
        92-07-06 JS    no output of order_tran if it does not exist
        92-06-05 JS    order_mult_assure
        92-05-08 MD    detection of prime div. of the index now in 
                       order_maxima_get_index_factors.c                                                 
        92-03-29 MD    now using the red. disc.
	92-03-10 JS    order_disc_calc
        92-02-11 MD/JS order_set_is_maximal
 	92-01-15 MD    first version



********************************************************************************/
{
	block_declarations;         

        anf             field;
        order           ord,ord1,temp;        
        t_handle          Z; 

	faclst	        facs;                 
        t_logical         disc_factors,rdisc_factors,
                        there_are_factors;

        integer_big     prime,red_disc;
        integer_small   i,exp_of_prime;
        integer_small   max,no_of_orders,degree;
 
        order_mult_assure(start);


  order_must_be_over_z (start);      /* Only Z- orders are supported so far  */   

  Z      = order_coef_order(start);  /* We will need Z for some function calls */
  field  = order_anf (start);

  degree = order_rel_degree (start); 
                            
  there_are_factors = order_maximal_get_index_factors (start,&facs);

  
  max = there_are_factors ? faclst_num_prime(facs) : 0; 
                                   /* The number of different primes           */
                                     /* with (possibly) a p-max. order with      */
                                     /* index <> 1                               */


  no_of_orders = 0;                  /* How many orders differnt from the equation */
                                     /* order are there ?                          */



  if (there_are_factors)             /* There are (!) some prime factors          */
  {
/* We now start to compute all the p-max. orders for the prime - numbers */
/* stored in the array "facs"                                            */

    for (i = 0 ;i<max; i++) 
    {

      exp_of_prime = faclst_expon(facs,i);  /* Get the exponent for the i-th. prime in  */
                                            /* the array facs.                          */
           
      prime        = faclst_prime(facs,i);  /* Get the i-th prime in the array */

/* compute the p-max. overorder for p = prime. As a upper bound for     */
/*                                                                      */
/*                    log  index (p-max (start)/start)                  */
/*                       p                                              */
/*                                                                      */
/* we have  : exp_of_prime.                                             */

      ord = order_max_p (start,prime,exp_of_prime); 

      if (anf_print_level >0) 
      {
        if (ord != start && order_basis_is_rel(ord))
        {
	        printf    ("Transformation for %d...\n",prime); 
	        cay_print ("Index of order: %d\n",order_index (ord));
	        mat_anf_write (Z,order_tran (ord));
        }
        else
        {
                cay_print("Order is already %d-maximal.\n", prime);
        }
      }  

/* We know that the ring of alg. integers is the sum of all p-max. orders */
/* when adding over all prime - numbers.                                   */
/* So we simply have to add up all p-max. orders for all primes. (Here we  */
/* actually need just some special primes.)                                */


/* We are starting to add up the p-max. orders. */

      if (no_of_orders == 0)
         ord1 = ord;
      else           
        {   
          if (ord != start)
          {
            temp = ord1;
         
            ord1 = order_add (ord1,ord);   /* Addition of two orders. */

            order_delete (&temp);
            
            no_of_orders++;

          }
          order_delete (&ord);  
        }

      integer_delref (prime);    
    }
    faclst_delete (&facs);
  }

  if (no_of_orders == 0)      /* We didn't find any p-max. overorder */
    ord1 = order_incref (start);
 

  order_set_is_maximal(ord1);
  order_disc_calc(ord1);
 
  return ord1;
}
