
#ifndef _POLY_MAT_H_
#define _POLY_MAT_H_

#if 0
#include "att.h"

/*
** Ordering of the flags inside a matrix.
*/

typedef enum {
	POLY_MAT_ATT_PACK = 0,
	POLY_MAT_ATT_TOTAL
	} poly_mat_att_numbers;
#endif

/*
** Structure of the matrix header.
*/

typedef struct
	{
		t_block_header	block_header;
		t_int	rows;
		t_int	cols;
	}
	poly_mat_header;

#define POLY_MAT_HDR_LEN	(sizeof(poly_mat_header) / sizeof(t_word))

/*
** Structure of the matrix block.
*/

typedef struct
	{
		poly_mat_header	poly_mat_hdr;
		t_word		poly_mat_elts[ VARIABLE_LENGTH ];
	}
	poly_mat_struct;

/*
** Size definitions and requirements.
*/

#define m_poly_mat_req_size( m, n ) \
		( (m) * (n) + POLY_MAT_HDR_LEN )

#define m_poly_mat_avail_size( h ) \
		( mem_words( h ) - POLY_MAT_HDR_LEN )

/*
** Access to information in the matrix header.
*/

#define m_poly_mat_row( h ) \
		(((poly_mat_header *) mem_access(h)) -> rows)

#define m_poly_mat_col( h ) \
		(((poly_mat_header *) mem_access(h)) -> cols)

#if 0
#define m_poly_mat_flgs( h ) \
		(((poly_mat_header *) mem_access(h)) -> flgs)
#endif

/*
** Information contained in the flags in the header.
*/

#if 0
#define m_poly_mat_is_packed(h) \
		att2_is_true( m_poly_mat_flgs(h), POLY_MAT_ATT_PACK )

#define m_poly_mat_set_pack(h) \
		att2_set_true( m_poly_mat_flgs(h), POLY_MAT_ATT_PACK )

#define m_poly_mat_set_unpack(h) \
		att2_set_false( m_poly_mat_flgs(h), POLY_MAT_ATT_PACK )
#endif

/*
** Access to elements of the matrix.
** m_poly_mat_entry( mat, i ): i = 1, ..., m*n.
** m_poly_mat_elt( mat, i, j ): i = 1, ..., m; j = 1, ..., n.
*/

#define m_poly_mat_elt0_ptr( h ) \
		(&((((poly_mat_struct *) mem_access(h)) -> poly_mat_elts)[-1]))

#define m_poly_mat_entry( h, i ) \
		(m_poly_mat_elt0_ptr(h)[(i)])

#define m_poly_mat_elt(h, i, j) \
		m_poly_mat_entry((h), ((i) - 1)*m_poly_mat_col(h) + (j))



#endif /* _POLY_MAT_H_ */

