#include "mem.e"
#include "mem_config.h"

/*******************************************************************************
		    Various configuration macros used everywhere
*******************************************************************************/

#ifdef DEVELOP
#   define DEVELOP_ONLY(e)	{ e; }
#   if defined(__STDC__) && !defined(APOLLO)
#	define ASSERT(e)	memi_assert(e, #e, __FILE__, __LINE__)
#   else
#	define ASSERT(e)	memi_assert(e, "e", __FILE__, __LINE__)
#   endif
#   define UFILE		user_file
#   define ULINE		user_line
#   define FL1(a1)		(a1, UFILE, ULINE) char *UFILE; t_int ULINE;
#   define FL2(a1, a2)		(a1, a2, UFILE, ULINE) char *UFILE; t_int ULINE;
#   define FL3(a1, a2, a3)	(a1, a2, a3, UFILE, ULINE) \
				char *UFILE; t_int ULINE;
#   define CALL_FL1(a1)		(a1, UFILE, ULINE)
#   define CALL_FL2(a1, a2)	(a1, a2, UFILE, ULINE)
#   define CALL_FL3(a1, a2, a3)	(a1, a2, a3, UFILE, ULINE)
#   define CHECK_HANDLE(func, h) memi_check_handle(func, h, UFILE, ULINE)
#   if defined(__STDC__)   && !defined(APOLLO)
#	define CHECK(f, e, h)	memi_develop_check(f, e, #e, h, UFILE, ULINE)
#   else
#	define CHECK(f, e, h)	memi_develop_check(f, e, "e", h, UFILE, ULINE)
#   endif
#   define TRACE(f, h, n)	memi_check_trace(f, h, n, UFILE, ULINE)
#   define TRACE_INIT()		memi_trace_init()
#   define IF_DELCHECK(t, f)	if (mem_do_delcheck) { t; } else { f; }
#   define MEM_BYTES(h)		f_mem_bytes(h, "", 0)
#else
#   define DEVELOP_ONLY(e)	;
#   define ASSERT(e)
#   define FL1(a1)		(a1)
#   define FL2(a1, a2)		(a1, a2)
#   define FL3(a1, a2, a3)	(a1, a2, a3)
#   define CALL_FL1(a1)		(a1)
#   define CALL_FL2(a1, a2)	(a1, a2)
#   define CALL_FL3(a1, a2, a3)	(a1, a2, a3)
#   define CHECK(func, e, h)
#   define CHECK_HANDLE(func, h)
#   define TRACE(f, h, n)
#   define TRACE_INIT()
#   define IF_DELCHECK(t, f)	{ f; }
#   define MEM_BYTES(h)		f_mem_bytes(h)
#endif

#ifdef STATS
#   undef STATS
#   define STATS(e)	{ e; }
#else
#   undef STATS
#   define STATS(e)
#endif

#ifdef VERBOSE
#   undef VERBOSE
#   define VERBOSE(e)	{ if (mem_do_showmem) { e; } }
#else
#   undef VERBOSE
#   define VERBOSE(e)
#endif

#ifdef ANALYSIS
#   define ANALYSIS_DECL(x)	x
#   define IF_ANALYSIS(e)	{  e;  }
#else
#   define ANALYSIS_DECL(x)
#   define IF_ANALYSIS(e)
#endif

#ifdef NEGATIVE_HANDLES
#   ifndef DEVELOP
	*** DIE!!!!! can only have NEGATIVE_HANDLES if DEVELOP is on ***
#   endif
#   define HNORMALIZE(h)	((h) = -(h))
#   define HNORM(h)		(-(h))
#else
#   define HNORMALIZE(h)
#   define HNORM(h)		(h)
#endif

#define DIE mem_die

#ifndef xxxDEVELOP
#   define ENTER_CHECK()    ((void)(mem_do_enter_check && mem_check_workspace()))
#else
#   define ENTER_CHECK()
#endif

#ifdef MEM_GLOBALS
#   define MEM_GLOBAL
#   define MEM_GLOBAL_INIT(x)  = x
#else
#   define MEM_GLOBAL	extern
#   define MEM_GLOBAL_INIT(x)
#endif


/*******************************************************************************
			Various types used everywhere
*******************************************************************************/


typedef void		t_void;
typedef	int		t_len;
typedef	int		t_int;

typedef struct hack
{
    struct hack	*pointer;
} *t_ptr;

/*******************************************************************************
			Various macros used everywhere
*******************************************************************************/

#define NULL		((t_ptr)0)
#define NH		0
#define TRUE		1
#define FALSE		0

#define	PREV_BLOCK(p)		((p)[-3].pointer)
#define	NEXT_BLOCK(p)		((p)[-2].pointer)
#define	NEXT_FREE(p)		((p)[-1].pointer)
#define	BLOCK_HANDLE(p)		((p)[-1].pointer)
#define	PREV_FREE(p)		((p)[0].pointer)

#define	BLOCK_SIZE(p)		(NEXT_BLOCK(p) - (p))
#define	BLOCK_SIZE_NO_HEADER(p)	(NEXT_BLOCK(p) - (p) - HEADER_SIZE)

#define BASE_HEADER_SIZE	3

#ifdef DEVELOP
#    define HEADER_SIZE		((BASE_HEADER_SIZE) + 3)

#    define BLOCK_FILE_NAME(p) \
	(*(char **)&((p)[-(BASE_HEADER_SIZE + 1)].pointer))
#    define BLOCK_LINE_NUM(p) \
	(*(int *)&((p)[-(BASE_HEADER_SIZE + 2)].pointer))
#    define BLOCK_MARK(p) \
	(*(unsigned int *)&((p)[-(BASE_HEADER_SIZE + 3)].pointer))
#    define LEFTMOST_HEADER(p)	((t_ptr)&BLOCK_MARK(p))

#    define ASSIGN_CALLER(bp) \
	 ((BLOCK_FILE_NAME(bp) = UFILE), (BLOCK_LINE_NUM(bp) = ULINE))
#    define ASSIGN_MARK(bp) 	(BLOCK_MARK(bp) = memi_mark)
#    define TRACE_ALLOCS
#    define IF_TRACE_ALLOCS(x)	{ x; }
#    define TRACE_ALLOCS_LOCAL(x) x
#    define USE_MARKS
#    define IF_USE_MARKS(x)	{ x; }
#    define MARKS_LOCAL(x)	x
#else
#    define HEADER_SIZE		BASE_HEADER_SIZE
#    define LEFTMOST_HEADER(p)	((t_ptr)&((p)[-BASE_HEADER_SIZE].pointer))
#    define ASSIGN_CALLER(bp)
#    define ASSIGN_MARK(bp)
#    undef TRACE_ALLOCS
#    define IF_TRACE_ALLOCS(x)	;
#    define TRACE_ALLOCS_LOCAL(x)
#    undef USE_MARKS
#    define IF_USE_MARKS(x)	;
#    define MARKS_LOCAL(x)
#endif

#define	MIN_SIZE		(HEADER_SIZE + 1)
#define	MIN_USER_SIZE		(MIN_SIZE - HEADER_SIZE)
#define MIN_REDUCE_SIZE         MIN_SIZE

#define P_MALLOC		((t_ptr)1)
#define P_HANDLE_TABLE		((t_ptr)2)
#define P_MEM_MALLOC		((t_ptr)3)
#define P_SBRK_GAP		((t_ptr)4)
#define P_HIGH_MEM		((t_ptr)5)
#define P_BIFFABLE_MALLOC	((t_ptr)6)

#define P_DELETED_HANDLE	((t_ptr)1)

#define HANDLE_BASE		((t_ptr)mem_handle_base)

#define IS_FIXED(hp)		\
				((hp) == P_MALLOC || \
				 (hp) == P_MEM_MALLOC || \
				 (hp) == P_BIFFABLE_MALLOC || \
				 (hp) == P_SBRK_GAP)

#define IS_SPECIAL(hp)		(IS_FIXED(hp) || \
				 (hp) == P_HANDLE_TABLE || \
				 (hp) == P_HIGH_MEM)

#define IS_FREE_L(hp, top, bot)	(((hp) < bot || (hp) >= top) && !IS_SPECIAL(hp))
#define IS_FREE(hp)		IS_FREE_L(hp, memi_handle_limit, HANDLE_BASE)
#define IS_ACTIVE_L(hp, top, bot) ((hp) >= bot && (hp) < top)
#define IS_ACTIVE(hp)		IS_ACTIVE_L(hp, memi_handle_limit, HANDLE_BASE)

#define DEREF(p)		((p)->pointer)
#define HANDLE_ACCESS(h)	(((t_ptr *)HANDLE_BASE)[h])

#define MEMI_CLASS(n) \
	    ((n) < CLASS_SMALL_LIMIT? memi_classes[n]: memi_slow_class(n))

/******************************************************************************/

#ifdef STATS
MEM_GLOBAL unsigned
    memi_stats_get_block, memi_stats_small_get_block, memi_stats_reduce,
    memi_stats_alloc, memi_stats_reduce_spare, memi_stats_extend,
    memi_stats_delete, memi_stats_malloc, memi_stats_free, memi_stats_coal,
    memi_stats_alloc_words, memi_stats_reduce_words,
    memi_stats_alloc_words_zero, memi_stats_reduce_words_spare,
    memi_stats_realloc, memi_stats_access;
#endif

#ifdef ANALYSIS
MEM_GLOBAL unsigned
    memi_analysis_coalesce, memi_analysis_coalesce_original,
    memi_analysis_coalesce_right, memi_analysis_coalesce_left,
    memi_analysis_coalesce_both, memi_analysis_coalesce_after,
    memi_analysis_get_block, memi_analysis_total_get_block,
    memi_analysis_list_count, memi_analysis_block_count,
    memi_analysis_spare_block, memi_analysis_free_block,
    memi_analysis_total_free_block, memi_analysis_free_block_count,
    memi_analysis_coalesce_none;
#endif

MEM_GLOBAL unsigned	memi_mark, memi_last_mark;


MEM_GLOBAL t_ptr	memi_free_lists[CLASS_LIMIT];
MEM_GLOBAL t_ptr	memi_free_limit
			  MEM_GLOBAL_INIT(
			    (t_ptr)&memi_free_lists[CLASS_LIMIT]
			);

MEM_GLOBAL t_int	memi_classes[CLASS_SMALL_LIMIT];
MEM_GLOBAL t_ptr	memi_free_handle_list;
MEM_GLOBAL t_ptr	memi_base_mem, memi_high_mem;
MEM_GLOBAL t_int	memi_done_init;

MEM_GLOBAL t_ptr	memi_handle_limit;
MEM_GLOBAL t_ptr	memi_next_handle;

MEM_GLOBAL t_len	memi_trace_h_len, memi_trace_size_len;
MEM_GLOBAL char		*memi_trace_h_table, *memi_trace_size_table;


/*******************************************************************************
    			Symbols exported to the world
*******************************************************************************/

MEM_GLOBAL t_void	(*mem_callback)();
MEM_GLOBAL t_mem_word	**mem_handle_base;
MEM_GLOBAL t_int	mem_do_delcheck, mem_do_enter_check, mem_do_showmem;
MEM_GLOBAL t_len	mem_size_limit, mem_extension_size;

#include "mem_protos.h"
