
/*
** dmat.h
**
** double precision matrix package.
*/

#ifndef INCLUDED_DMAT_H
#define INCLUDED_DMAT_H

#include "integer.e"


/*
** Type of a matrix.
*/

typedef	t_word	t_dmat;


/*
** Matrix header.
*/

typedef struct
{
      t_block_header      trbl_hdr;
      integer_small    row;         /* number of rows in the matrix */
      integer_small    col;         /* number of columns in the matrix */
} t_dmat_header;

#define DMAT_HDR_LEN ( sizeof( t_dmat_header ) )


/*
** Matrix structure.
*/

typedef struct
{
      t_dmat_header	dmat_hdr;
      double		dmat_ent[ VARIABLE_LENGTH ];
} t_dmat_struct;

/*
** Required space (in bh_ints) for a matrix of dimension m by n.
*/

#define dmat_req_space(m, n) \
    ( DMAT_HDR_LEN + (m) * (n) * sizeof(double) )


/*
** Create a blank matrix with space for m * n entries. Row and
** column numbers aren't set.
*/
/* changed by MJ 28.1.93 due to mail from allan
#define dmat_create(m, n)  mem_alloc_words_zero( dmat_req_space(m, n) )
*/

#define dmat_create(m, n) \
           mem_alloc_aligned(sizeof(t_double), dmat_req_space(m, n))

/*
** Delete a matrix.
*/

#define dmat_delete( ph )	mem_delete_hptr( ph )


/*
** Access to the matrix structure through the t_handle.
*/

#define dmat_access(ph)    ( (t_dmat_header *) mem_access(ph) )


/*
** Row and column numbers.
*/

#define dmat_row(ph)     ( dmat_access(ph) -> row )

#define dmat_col(ph)     ( dmat_access(ph) -> col )


/*
** Pointer to elements.
** dmat_eltptr returns pointer to array indexed 1,...,m*n
** dmat_elt indexes are {1,...,m}, {1,...,n}
** dmat_entry indexes are 1,...,m*n
*/

#define dmat_eltptr(ph) \
      (&(((double *) (((t_dmat_struct *) mem_access(ph)) -> dmat_ent))[ -1 ]))

#define dmat_entry(ph, eltno) \
      (dmat_eltptr(ph) [ (eltno) ])

#define dmat_elt(ph, rowno, colno) \
      (dmat_eltptr(ph)[ ((rowno)-1) * dmat_col(ph) + (colno)])


#endif /* INCLUDED_DMAT_H */

