      SUBROUTINE TSTSET(SUB)
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                        T S T S E T                             *
C     *                                                                *
C     ******************************************************************
*
*DOC             sets TSTFLG dependent on TSTSUB
**DOC
*INDEX  TSTSET(IN/0): sets TSTFLG dependent on TSTSUB
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This routine should only be called by START and END.
**DOC       If TSTSUB contains a list of subroutines for enhanced testing
**DOC       this routine first looks whether the subroutine SUB belongs
**DOC       to this list. If so, it sets TSTFLG to TSTFL2.
**DOC       If not it sets TSTFLG to TSTFL1.
**DOC
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       SUB (STR)        Name of subroutine
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       -
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       -
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       DEBUG
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       13.06.91
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       -        -         -
*
%include 'debug.inc'
*
      CHARACTER*6 SUB
      INTEGER INDEX
*
*  Is SUB in the list?
*
      IF (INDEX(TSTSUB,','//SUB//',').GT.0) THEN
C*         WRITE(*,*) ','//SUB//',','    2 ',TSTSUB
         TSTFLG = TSTFL2
      ELSE
C*         WRITE(*,*) ','//SUB//',','    1 ',TSTSUB
         TSTFLG = TSTFL1
      ENDIF
*
*  exit
*
      RETURN
      END

