      SUBROUTINE SUMARY()
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                        S U M A R Y                             *
C     *                                                                *
C     ******************************************************************
*
*DOC             Subroutine statistics if 1 < DLEVEL < 7
**DOC
*INDEX  SUMARY(IN/1): Internal Routine for Statistics
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This routine writes a statistics of subroutine calls on SNROUT.
**DOC       All used values are set to zero afterwards.
**DOC       1 < DLEVEL < 5:
**DOC       Output of number of calls and times
**DOC       4 < DLEVEL < 7:
**DOC       Output only of number of calls
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       SUBCNT(*) = 0
**DOC       SUBTIM(*) = 0
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       -
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       19.02.87
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       JS       03.06.88  Output in english
**DOC       JS       14.10.88  Output on DNROUT
**DOC       JS       05.12.88  Singular and plural!
**DOC
%include 'field.inc'
      CHARACTER*7 CALLS, SINGUL, PLURAL
      INTEGER COUNT
      DATA SINGUL, PLURAL /' call, ',' calls,'/
*
      IF (DLEVEL.LT.2.OR.DLEVEL.GT.6) RETURN
*
      WRITE (DNROUT,1000)
1000  FORMAT(/' ')
*
      IF (DLEVEL.EQ.5.OR.DLEVEL.EQ.6) GOTO 2
*
      DO 100 I=1,ENDLUT
         COUNT = SUBCNT(I)
         IF (COUNT.NE.0) THEN
            IF(COUNT.EQ.1) THEN
               CALLS = SINGUL
            ELSE
               CALLS = PLURAL
            ENDIF
            WRITE(DNROUT,2000) SUBLUT(I),COUNT,CALLS,SUBTIM(I),
     *                         SUBTIM(I)/COUNT
2000        FORMAT(1X,A6,I8,A7,F10.4,' sec;   average time:',F10.4)
            SUBCNT(I) = 0
            SUBTIM(I) = 0
         ENDIF
100   CONTINUE
      RETURN
*
2     DO 101 I=1,ENDLUT
         IF (SUBCNT(I).NE.0) THEN
            WRITE(DNROUT,3000) SUBLUT(I),SUBCNT(I)
3000        FORMAT(1X,A6,I8,' call(s)')
            SUBCNT(I) = 0
            SUBTIM(I) = 0
         ENDIF
101   CONTINUE
      WRITE(DNROUT,*)' '
      WRITE(DNROUT,*)' '
      RETURN
      END
