#include "kant.h"
#include "thue.h" 

t_real
thue_solutions_ymax WITH_1_ARG(
                thue,           th
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_real		h1, h2, h3, h4, h5, ymax, m1, m2, m3; 
	t_comp		apz1, apz2, c1, c2, con;
        t_int           deg, r, i, j, i_max;
        order           ord;
        t_handle        R_ord, R_thue, C_ord;
       	matrix		oul;
	anf_elt		alpha;
 
	ord = thue_order(th);
        deg = thue_abs_degree(th);
        R_ord = order_reals(ord);
       	C_ord = comp_create(real_dec_prec(R_ord)); 
	R_thue = thue_reals(th);
        r = order_r(ord);

	m1 = conv_int_to_real(R_ord, 0);
	for(i=1;i<=deg;i++)
		{
		h2 = conv_int_to_real(R_ord, 0); 
		for(j=1;j<=r;j++)
			{
			oul = order_units_logs(ord);
			h1 = real_abs(R_ord, mat_elt(oul, i, j));
			h3 = h2;
			h2 = real_add(R_ord, h1, h2);
			real_delete(&h3);
			real_delete(&h1);
			}
		m1 = real_max(R_ord, m1, h2);
		real_delete(&h2); 
		}
	h1 = m1;
	m1 = thue_conv_real_to_real(R_ord, m1, R_thue);
	real_delete(&h1);
	
	apz1 = thue_zero(th, 1);
	apz2 = thue_zero(th, 2);
	c1 = comp_subtract(C_ord, apz1, apz2);
	m2 = comp_abs(C_ord, c1);
	comp_delete(&apz1);
	comp_delete(&apz2);
	comp_delete(&c1); 
	for(i=1;i<=deg;i++)
		{
		for(j=i+1;j<=deg;j++)
			{
			apz1 = thue_zero(th, i);
			apz2 = thue_zero(th, j);
			c1 = comp_subtract(C_ord, apz1, apz2);
			h2 = comp_abs(C_ord, c1);
			comp_delete(&c1);
			comp_delete(&apz1);
			comp_delete(&apz2);
			h1 = m2;
			m2 = real_min(R_ord, m2, h2);
			real_delete(&h1);
			real_delete(&h2);
			}
		}
	h1 = m2;
	m2 = thue_conv_real_to_real(R_ord, m2, R_thue);
	real_delete(&h1);

	i_max = dyn_arr_curr_length(thue_gamma(th));
	m3 = conv_int_to_real(R_ord, 0);
	for(i=0;i<i_max;i++)
		{
		alpha = dyn_arr_element(thue_gamma(th), i);
		for(j=1;j<=deg;j++)
			{
			con = anf_elt_ith_con(ord, alpha, j);
			h1 = comp_abs(C_ord, con);
			h2 = m3;
			m3 = real_max(R_ord, m3, h1);	
			real_delete(&h1);
			real_delete(&h2);
			comp_delete(&con);	
			}
		anf_elt_delete(ord, &alpha);	
		}
	h1 = m3;
	m3 = thue_conv_real_to_real(R_ord, m3, R_thue);
	real_delete(&h1);

	h1 = conv_int_to_real(R_thue, 2);
	h2 = real_divide(R_thue, h1, m2);
	h3 = real_mult(R_thue, m1, thue_B1(th));
	h4 = real_add(R_thue, h3, m3);
	h5 = real_mult(R_thue, h4, h2);
	ymax = real_exp(R_thue, h5);
	real_delete(&h1);
	real_delete(&h2);
	real_delete(&h3);
	real_delete(&h4);
	real_delete(&h5);
        if (thue_print_level(th)>=3)
                {
                printf("ymax u nits"); real_write(R_thue, m1, 20); puts("");
                printf("ymax zeroes"); real_write(R_thue, m2, 20); puts("");
                printf("ymax gammas"); real_write(R_thue, m3, 20); puts("");
                }

	real_delete(&m1);
	real_delete(&m2);	
	real_delete(&m3);
	ring_delete(&C_ord);

        return ymax;
}
